/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionTerminationHandle;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.transactional.error.TransactionLifecycleException;
import org.neo4j.server.rest.web.TransactionUriScheme;

@Path(value="/transaction")
public class TransactionalService {
    private final TransactionFacade facade;
    private final TransactionUriScheme uriScheme;

    public TransactionalService(@Context TransactionFacade facade, @Context UriInfo uriInfo) {
        this.facade = facade;
        this.uriScheme = new TransactionUriBuilder(uriInfo);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatementsInNewTransaction(InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        try {
            TransactionHandle transactionHandle = this.facade.newTransactionHandle(this.uriScheme);
            return this.createdResponse(transactionHandle, this.executeStatements(input, transactionHandle, uriInfo.getBaseUri(), request));
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeStatements(@PathParam(value="id") long id, InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.executeStatements(input, transactionHandle, uriInfo.getBaseUri(), request));
    }

    @POST
    @Path(value="/{id}/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitTransaction(@PathParam(value="id") long id, InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.findTransactionHandle(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.executeStatementsAndCommit(input, transactionHandle, uriInfo.getBaseUri(), false, request));
    }

    @POST
    @Path(value="/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response commitNewTransaction(InputStream input, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.newTransactionHandle(this.uriScheme);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        StreamingOutput streamingResults = this.executeStatementsAndCommit(input, transactionHandle, uriInfo.getBaseUri(), true, request);
        return this.okResponse(streamingResults);
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response rollbackTransaction(@PathParam(value="id") long id, @Context UriInfo uriInfo) {
        TransactionHandle transactionHandle;
        try {
            transactionHandle = this.facade.terminate(id);
        }
        catch (TransactionLifecycleException e) {
            return this.invalidTransaction(e, uriInfo.getBaseUri());
        }
        return this.okResponse(this.rollback(transactionHandle, uriInfo.getBaseUri()));
    }

    private Response invalidTransaction(TransactionLifecycleException e, URI baseUri) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.serializeError(e.toNeo4jError(), baseUri)).build();
    }

    private Response createdResponse(TransactionHandle transactionHandle, StreamingOutput streamingResults) {
        return Response.created((URI)transactionHandle.uri()).entity((Object)streamingResults).build();
    }

    private Response okResponse(StreamingOutput streamingResults) {
        return Response.ok().entity((Object)streamingResults).build();
    }

    private StreamingOutput executeStatements(final InputStream input, final TransactionHandle transactionHandle, final URI baseUri, final HttpServletRequest request) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                transactionHandle.execute(TransactionalService.this.facade.deserializer(input), TransactionalService.this.facade.serializer(output, baseUri), request);
            }
        };
    }

    private StreamingOutput executeStatementsAndCommit(final InputStream input, final TransactionHandle transactionHandle, final URI baseUri, final boolean pristine, final HttpServletRequest request) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                OutputStream wrappedOutput = pristine ? new InterruptingOutputStream(output, transactionHandle) : output;
                transactionHandle.commit(TransactionalService.this.facade.deserializer(input), TransactionalService.this.facade.serializer(wrappedOutput, baseUri), pristine, request);
            }
        };
    }

    private StreamingOutput rollback(final TransactionHandle transactionHandle, final URI baseUri) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                if (transactionHandle != null) {
                    transactionHandle.rollback(TransactionalService.this.facade.serializer(output, baseUri));
                }
            }
        };
    }

    private StreamingOutput serializeError(final Neo4jError neo4jError, final URI baseUri) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                ExecutionResultSerializer serializer = TransactionalService.this.facade.serializer(output, baseUri);
                serializer.errors(Arrays.asList(neo4jError));
                serializer.finish();
            }
        };
    }

    private class InterruptingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private final TransactionTerminationHandle terminationHandle;

        private InterruptingOutputStream(OutputStream delegate, TransactionTerminationHandle terminationHandle) {
            this.delegate = delegate;
            this.terminationHandle = terminationHandle;
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.delegate.write(b, off, len);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.delegate.flush();
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.delegate.write(b);
            }
            catch (IOException e) {
                this.terminate();
                throw e;
            }
        }

        private void terminate() {
            this.terminationHandle.terminate();
        }
    }

    public static class TransactionUriBuilder
    implements TransactionUriScheme {
        private final UriInfo uriInfo;

        public TransactionUriBuilder(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        @Override
        public URI txUri(long id) {
            return this.builder(id).build(new Object[0]);
        }

        @Override
        public URI txCommitUri(long id) {
            return this.builder(id).path("/commit").build(new Object[0]);
        }

        private UriBuilder builder(long id) {
            return this.uriInfo.getBaseUriBuilder().path(TransactionalService.class).path("/" + id);
        }
    }
}

