/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management;

import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.management.repr.JmxDomainRepresentation;
import org.neo4j.server.rest.management.repr.JmxMBeanRepresentation;
import org.neo4j.server.rest.management.repr.ServiceDefinitionRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="server/jmx")
public class JmxService
implements AdvertisableService {
    public static final String ROOT_PATH = "server/jmx";
    public static final String DOMAINS_PATH = "/domain";
    public static final String DOMAIN_TEMPLATE = "/domain/{domain}";
    public static final String BEAN_TEMPLATE = "/domain/{domain}/{objectName}";
    public static final String QUERY_PATH = "/query";
    public static final String KERNEL_NAME_PATH = "/kernelquery";
    private final OutputFormat output;

    public JmxService(@Context OutputFormat output, @Context InputFormat input) {
        this.output = output;
    }

    @GET
    public Response getServiceDefinition() {
        ServiceDefinitionRepresentation serviceDef = new ServiceDefinitionRepresentation(ROOT_PATH);
        serviceDef.resourceUri("domains", DOMAINS_PATH);
        serviceDef.resourceTemplate("domain", DOMAIN_TEMPLATE);
        serviceDef.resourceTemplate("bean", BEAN_TEMPLATE);
        serviceDef.resourceUri("query", QUERY_PATH);
        serviceDef.resourceUri("kernelquery", KERNEL_NAME_PATH);
        return this.output.ok((Representation)serviceDef);
    }

    @GET
    @Path(value="/domain")
    public Response listDomains() throws NullPointerException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ListRepresentation domains = ListRepresentation.strings((String[])server.getDomains());
        return this.output.ok((Representation)domains);
    }

    @GET
    @Path(value="/domain/{domain}")
    public Response getDomain(@PathParam(value="domain") String domainName) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JmxDomainRepresentation domain = new JmxDomainRepresentation(domainName);
        for (ObjectName objName : server.queryNames(null, null)) {
            if (!((Object)objName).toString().startsWith(domainName)) continue;
            domain.addBean(objName);
        }
        return this.output.ok((Representation)domain);
    }

    @GET
    @Path(value="/domain/{domain}/{objectName}")
    public Response getBean(@PathParam(value="domain") String domainName, @PathParam(value="objectName") String objectName) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ArrayList<JmxMBeanRepresentation> beans = new ArrayList<JmxMBeanRepresentation>();
        for (ObjectName objName : server.queryNames(this.createObjectName(domainName, objectName), null)) {
            beans.add(new JmxMBeanRepresentation(objName));
        }
        return this.output.ok((Representation)new ListRepresentation("bean", beans));
    }

    private ObjectName createObjectName(String domainName, String objectName) {
        try {
            return new ObjectName(domainName + ":" + URLDecoder.decode(objectName, "UTF-8"));
        }
        catch (MalformedObjectNameException e) {
            throw new WebApplicationException((Throwable)e, 400);
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException((Throwable)e, 400);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/query")
    public Response queryBeans(String query) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            String json = JmxService.dodgeStartingUnicodeMarker(query);
            Collection queries = (Collection)JsonHelper.readJson(json);
            ArrayList<JmxMBeanRepresentation> beans = new ArrayList<JmxMBeanRepresentation>();
            for (Object queryObj : queries) {
                assert (queryObj instanceof String);
                for (ObjectName objName : server.queryNames(new ObjectName((String)queryObj), null)) {
                    beans.add(new JmxMBeanRepresentation(objName));
                }
            }
            return this.output.ok((Representation)new ListRepresentation("jmxBean", beans));
        }
        catch (JsonParseException e) {
            return this.output.badRequest(e);
        }
        catch (MalformedObjectNameException e) {
            return this.output.badRequest(e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/query")
    public Response formQueryBeans(@FormParam(value="value") String data) {
        return this.queryBeans(data);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/kernelquery")
    public Response currentKernelInstance(@Context Database database) {
        Kernel kernelBean = (Kernel)((JmxKernelExtension)database.getGraph().getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class);
        return Response.ok((Object)("\"" + kernelBean.getMBeanQuery().toString() + "\"")).type("application/json").build();
    }

    @Override
    public String getName() {
        return "jmx";
    }

    @Override
    public String getServerPath() {
        return ROOT_PATH;
    }

    private static String dodgeStartingUnicodeMarker(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\ufeff') {
            return string.substring(1);
        }
        return string;
    }
}

