/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.web.XForwardUtil;

public class AuthorizationFilter
implements Filter {
    private static final Pattern PASSWORD_CHANGE_WHITELIST = Pattern.compile("/user/.*");
    private final AuthManager authManager;
    private final Log log;
    private final Pattern[] uriWhitelist;
    private static final ErrorResponse NO_HEADER = new ErrorResponse(401){

        @Override
        void addHeaders(HttpServletResponse response) {
            response.addHeader("WWW-Authenticate", "None");
        }

        @Override
        Object body() {
            return MapUtil.map((Object[])new Object[]{"errors", Arrays.asList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "No authorization header supplied."}))});
        }
    };
    private static final ErrorResponse BAD_HEADER = new ErrorResponse(400){

        @Override
        Object body() {
            return MapUtil.map((Object[])new Object[]{"errors", Arrays.asList(MapUtil.map((Object[])new Object[]{"code", Status.Request.InvalidFormat.code().serialize(), "message", "Invalid Authorization header."}))});
        }
    };
    private static final ErrorResponse INVALID_CREDENTIAL = new ErrorResponse(401){

        @Override
        void addHeaders(HttpServletResponse response) {
            response.addHeader("WWW-Authenticate", "None");
        }

        @Override
        Object body() {
            return MapUtil.map((Object[])new Object[]{"errors", Arrays.asList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "Invalid username or password."}))});
        }
    };
    private static final ErrorResponse TOO_MANY_ATTEMPTS = new ErrorResponse(429){

        @Override
        Object body() {
            return MapUtil.map((Object[])new Object[]{"errors", Arrays.asList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthenticationRateLimit.code().serialize(), "message", "Too many failed authentication requests. Please wait 5 seconds and try again."}))});
        }
    };

    public AuthorizationFilter(AuthManager authManager, LogProvider logProvider, Pattern ... uriWhitelist) {
        this.authManager = authManager;
        this.log = logProvider.getLog(this.getClass());
        this.uriWhitelist = uriWhitelist;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.validateRequestType(servletRequest);
        this.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String path = request.getContextPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (request.getMethod().equals("OPTIONS") || this.whitelisted(path)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header == null) {
            AuthorizationFilter.noHeader().writeResponse(response);
            return;
        }
        String[] usernameAndPassword = this.extractCredential(header);
        if (usernameAndPassword == null) {
            AuthorizationFilter.badHeader().writeResponse(response);
            return;
        }
        String username = usernameAndPassword[0];
        String password = usernameAndPassword[1];
        switch (this.authManager.authenticate(username, password)) {
            case PASSWORD_CHANGE_REQUIRED: {
                if (!PASSWORD_CHANGE_WHITELIST.matcher(path).matches()) {
                    AuthorizationFilter.passwordChangeRequired(username, this.baseURL(request)).writeResponse(response);
                    return;
                }
            }
            case SUCCESS: {
                filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", username, request), servletResponse);
                return;
            }
            case TOO_MANY_ATTEMPTS: {
                AuthorizationFilter.tooManyAttemptes().writeResponse(response);
                return;
            }
        }
        this.log.warn("Failed authentication attempt for '%s' from %s", new Object[]{username, request.getRemoteAddr()});
        AuthorizationFilter.invalidCredential().writeResponse(response);
    }

    private static ErrorResponse noHeader() {
        return NO_HEADER;
    }

    private static ErrorResponse badHeader() {
        return BAD_HEADER;
    }

    private static ErrorResponse invalidCredential() {
        return INVALID_CREDENTIAL;
    }

    private static ErrorResponse tooManyAttemptes() {
        return TOO_MANY_ATTEMPTS;
    }

    private static ErrorResponse passwordChangeRequired(final String username, final String baseURL) {
        return new ErrorResponse(403){

            @Override
            Object body() {
                URI path = UriBuilder.fromUri((String)baseURL).path(String.format("/user/%s/password", username)).build(new Object[0]);
                return MapUtil.map((Object[])new Object[]{"errors", Arrays.asList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthorizationFailed.code().serialize(), "message", "User is required to change their password."})), "password_change", path.toString()});
            }
        };
    }

    private String baseURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String baseURL = url.substring(0, url.length() - request.getRequestURI().length()) + "/";
        return XForwardUtil.externalUri(baseURL, request.getHeader("X-Forwarded-Host"), request.getHeader("X-Forwarded-Proto"));
    }

    public void destroy() {
    }

    private boolean whitelisted(String path) {
        for (Pattern pattern : this.uriWhitelist) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private String[] extractCredential(String header) {
        if (header == null) {
            return null;
        }
        return AuthorizationHeaders.decode(header);
    }

    private void validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
    }

    private void validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
    }

    private static abstract class ErrorResponse {
        private final int statusCode;

        private ErrorResponse(int statusCode) {
            this.statusCode = statusCode;
        }

        void addHeaders(HttpServletResponse response) {
        }

        abstract Object body();

        void writeResponse(HttpServletResponse response) throws IOException {
            response.setStatus(this.statusCode);
            response.addHeader("Content-Type", "application/json; charset=UTF-8");
            this.addHeaders(response);
            response.getOutputStream().write(JsonHelper.createJsonFrom(this.body()).getBytes(Charsets.UTF_8));
        }
    }
}

