/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Logger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class JettyLogBridge
extends AbstractLogger {
    private static final Pattern packagePattern = Pattern.compile("(\\w)\\w+\\.");
    private static final AtomicReference<LogProvider> logProvider = new AtomicReference<NullLogProvider>(NullLogProvider.getInstance());
    private final String fullname;
    private final Log log;

    public JettyLogBridge() {
        this("org.eclipse.jetty.util.log");
    }

    public JettyLogBridge(String fullname) {
        this.fullname = fullname;
        this.log = logProvider.get().getLog(packagePattern.matcher(fullname).replaceAll("$1."));
    }

    public static LogProvider setLogProvider(LogProvider newLogProvider) {
        return logProvider.getAndSet(newLogProvider);
    }

    protected Logger newLogger(String fullname) {
        return new JettyLogBridge(fullname);
    }

    public String getName() {
        return this.fullname;
    }

    public void warn(String msg, Object ... args) {
        this.log.warn(msg, args);
    }

    public void warn(Throwable thrown) {
        this.log.warn("", thrown);
    }

    public void warn(String msg, Throwable thrown) {
        this.log.warn(msg, thrown);
    }

    public void info(String msg, Object ... args) {
    }

    public void info(Throwable thrown) {
    }

    public void info(String msg, Throwable thrown) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void setDebugEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public void debug(String msg, Object ... args) {
    }

    public void debug(Throwable thrown) {
    }

    public void debug(String msg, Throwable thrown) {
    }

    public void ignore(Throwable ignored) {
    }
}

