/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import org.neo4j.server.security.ssl.Certificates;
import org.neo4j.server.security.ssl.KeyStoreInformation;

public class KeyStoreFactory {
    private Certificates certFactory = new Certificates();

    public KeyStoreInformation createKeyStore(File privateKeyPath, File certificatePath) throws IOException, GeneralSecurityException {
        char[] keyStorePassword = this.getRandomChars(50);
        char[] keyPassword = this.getRandomChars(50);
        KeyStore ks = this.createKeyStore(keyStorePassword, keyPassword, privateKeyPath, certificatePath);
        return new KeyStoreInformation(ks, keyStorePassword, keyPassword);
    }

    private KeyStore createKeyStore(char[] keyStorePassword, char[] keyPassword, File privateKeyFile, File certFile) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, keyStorePassword);
        keyStore.setKeyEntry("key", this.certFactory.loadPrivateKey(privateKeyFile), keyPassword, this.certFactory.loadCertificates(certFile));
        return keyStore;
    }

    private char[] getRandomChars(int length) {
        SecureRandom rand = new SecureRandom();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)rand.nextInt();
        }
        return chars;
    }
}

