/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.server.rest.transactional.TransactionTerminator;

class TransitionalTxManagementKernelTransaction {
    private final TransactionTerminator txTerminator;
    private final ThreadToStatementContextBridge bridge;
    private TopLevelTransaction suspendedTransaction;

    TransitionalTxManagementKernelTransaction(TransactionTerminator txTerminator, ThreadToStatementContextBridge bridge) {
        this.txTerminator = txTerminator;
        this.bridge = bridge;
    }

    public void suspendSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction == null) : "Can't suspend the transaction if it already is suspended.";
        this.suspendedTransaction = this.bridge.getTopLevelTransactionBoundToThisThread(true);
        this.bridge.unbindTransactionFromCurrentThread();
    }

    public void resumeSinceTransactionsAreStillThreadBound() {
        assert (this.suspendedTransaction != null) : "Can't resume the transaction if it has not first been suspended.";
        this.bridge.bindTransactionToCurrentThread(this.suspendedTransaction);
        this.suspendedTransaction = null;
    }

    public void terminate() {
        this.txTerminator.terminate();
    }

    public void rollback() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(false);
            kernelTransactionBoundToThisThread.failure();
            kernelTransactionBoundToThisThread.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }

    public void commit() {
        try {
            KernelTransaction kernelTransactionBoundToThisThread = this.bridge.getKernelTransactionBoundToThisThread(true);
            kernelTransactionBoundToThisThread.success();
            kernelTransactionBoundToThisThread.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.bridge.unbindTransactionFromCurrentThread();
        }
    }
}

