/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class HttpHeaderUtils {
    private static final String UTF8 = "UTF-8";
    public static final Map<String, String> CHARSET = Collections.singletonMap("charset", "UTF-8");

    public static MediaType mediaTypeWithCharsetUtf8(String mediaType) {
        return new MediaType(mediaType, null, CHARSET);
    }

    public static MediaType mediaTypeWithCharsetUtf8(MediaType mediaType) {
        Map parameters = mediaType.getParameters();
        if (parameters.isEmpty()) {
            return new MediaType(mediaType.getType(), mediaType.getSubtype(), CHARSET);
        }
        if (parameters.containsKey("charset")) {
            return mediaType;
        }
        HashMap<String, String> paramsWithCharset = new HashMap<String, String>(parameters);
        paramsWithCharset.putAll(CHARSET);
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), paramsWithCharset);
    }
}

