/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.NoSuchPaddingException;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;

public class KeyStoreFactory {
    private SslCertificateFactory sslCertificateFactory = new SslCertificateFactory();

    public KeyStoreInformation createKeyStore(File keyStorePath, File privateKeyPath, File certificatePath) {
        try {
            char[] keyStorePassword = this.getRandomChars(50);
            char[] keyPassword = this.getRandomChars(50);
            this.createKeyStore(keyStorePath, keyStorePassword, keyPassword, privateKeyPath, certificatePath);
            return new KeyStoreInformation(keyStorePath.getAbsolutePath(), keyStorePassword, keyPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to setup keystore for SSL certificate, see nested exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeyStore(File keyStorePath, char[] keyStorePassword, char[] keyPassword, File privateKeyFile, File certFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        FileOutputStream fis = null;
        try {
            if (keyStorePath.exists()) {
                keyStorePath.delete();
            }
            this.ensureFolderExists(keyStorePath.getParentFile());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, keyStorePassword);
            keyStore.setKeyEntry("key", this.sslCertificateFactory.loadPrivateKey(privateKeyFile), keyPassword, new Certificate[]{this.sslCertificateFactory.loadCertificate(certFile)});
            fis = new FileOutputStream(keyStorePath.getAbsolutePath());
            keyStore.store(fis, keyStorePassword);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private char[] getRandomChars(int length) {
        SecureRandom rand = new SecureRandom();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)rand.nextInt();
        }
        return chars;
    }

    private void ensureFolderExists(File path) {
        if (!path.exists()) {
            path.mkdirs();
        }
    }
}

