/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.FirstItemIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ServerListRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ObjectToRepresentationConverter {
    public static Representation convert(Object data) {
        if (data instanceof Iterable) {
            return ObjectToRepresentationConverter.getListRepresentation((Iterable)data);
        }
        if (data instanceof Iterator) {
            Iterator iterator = (Iterator)data;
            return ObjectToRepresentationConverter.getIteratorRepresentation(iterator);
        }
        if (data instanceof Map) {
            return ObjectToRepresentationConverter.getMapRepresentation((Map)data);
        }
        return ObjectToRepresentationConverter.getSingleRepresentation(data);
    }

    public static MappingRepresentation getMapRepresentation(Map data) {
        return new MapRepresentation(data);
    }

    static Representation getIteratorRepresentation(Iterator data) {
        FirstItemIterable results = new FirstItemIterable((Iterator)new IteratorWrapper<Representation, Object>(data){

            protected Representation underlyingObjectToObject(Object value) {
                if (value instanceof Iterable) {
                    FirstItemIterable<Representation> nested = ObjectToRepresentationConverter.convertValuesToRepresentations((Iterable)value);
                    return new ListRepresentation(ObjectToRepresentationConverter.getType(nested), nested);
                }
                return ObjectToRepresentationConverter.getSingleRepresentation(value);
            }
        });
        return new ListRepresentation(ObjectToRepresentationConverter.getType((FirstItemIterable<Representation>)results), (Iterable)results);
    }

    public static ListRepresentation getListRepresentation(Iterable data) {
        FirstItemIterable<Representation> results = ObjectToRepresentationConverter.convertValuesToRepresentations(data);
        return new ServerListRepresentation(ObjectToRepresentationConverter.getType(results), (Iterable<? extends Representation>)results);
    }

    static FirstItemIterable<Representation> convertValuesToRepresentations(Iterable data) {
        return new FirstItemIterable((Iterable)new IterableWrapper<Representation, Object>(data){

            protected Representation underlyingObjectToObject(Object value) {
                return ObjectToRepresentationConverter.convert(value);
            }
        });
    }

    static RepresentationType getType(FirstItemIterable<Representation> representations) {
        Representation representation = (Representation)representations.getFirst();
        if (representation == null) {
            return RepresentationType.STRING;
        }
        return representation.getRepresentationType();
    }

    static Representation getSingleRepresentation(Object result) {
        if (result == null) {
            return ValueRepresentation.string((String)"null");
        }
        if (result instanceof GraphDatabaseService) {
            return new DatabaseRepresentation((GraphDatabaseService)result);
        }
        if (result instanceof Node) {
            return new NodeRepresentation((Node)result);
        }
        if (result instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)result);
        }
        if (result instanceof Double || result instanceof Float) {
            return ValueRepresentation.number((double)((Number)result).doubleValue());
        }
        if (result instanceof Long) {
            return ValueRepresentation.number((long)((Long)result));
        }
        if (result instanceof Integer) {
            return ValueRepresentation.number((int)((Integer)result));
        }
        return ValueRepresentation.string((String)result.toString());
    }
}

