/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.neo4j.server.preflight.PreflightTask;

public class EnsureNeo4jPropertiesExist
implements PreflightTask {
    private static final String EMPTY_STRING = "";
    private boolean passed = false;
    private boolean ran = false;
    protected String failureMessage = "";
    private Configuration config;

    public EnsureNeo4jPropertiesExist(Configuration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        this.ran = true;
        String configFilename = this.config.getString("org.neo4j.server.properties");
        if (configFilename == null) {
            this.failureMessage = String.format("No server configuration file set, unable to load configuration. Expected system property '%s' to point to config file.", "org.neo4j.server.properties");
            return false;
        }
        Properties configProperties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFilename);
            configProperties.load(inputStream);
        }
        catch (IOException e) {
            this.failureMessage = String.format("Failed to load configuration properties from [%s]", configFilename);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.passed = this.validateProperties(configProperties);
        return this.passed;
    }

    protected boolean validateProperties(Properties configProperties) {
        return true;
    }

    @Override
    public String getFailureMessage() {
        if (this.passed) {
            return EMPTY_STRING;
        }
        if (!this.ran) {
            return String.format("%s has not been run", this.getClass().getName());
        }
        return this.failureMessage;
    }
}

