/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.statistic;

import javax.servlet.Filter;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.statistic.StatisticFilter;

public class StatisticStartupListener
implements LifeCycle.Listener {
    private static final Logger LOG = new Logger(StatisticStartupListener.class);
    private final Server jetty;
    private FilterHolder holder;

    public StatisticStartupListener(Server jetty, StatisticFilter statisticFilter) {
        this.jetty = jetty;
        this.holder = new FilterHolder((Filter)statisticFilter);
    }

    public void lifeCycleStarting(LifeCycle event) {
    }

    public void lifeCycleStarted(LifeCycle event) {
        for (Handler handler : this.jetty.getHandlers()) {
            if (!(handler instanceof Context)) continue;
            Context context = (Context)handler;
            String path = context.getContextPath();
            LOG.info("adding statistic-filter to " + path, new Object[0]);
            context.addFilter(this.holder, "/*", 15);
        }
    }

    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
    }

    public void lifeCycleStopping(LifeCycle event) {
        LOG.info("stopping filter", new Object[0]);
        this.holder.doStop();
    }

    public void lifeCycleStopped(LifeCycle event) {
    }

    public void stop() {
        LOG.info("stopping listeneer", new Object[0]);
        this.jetty.removeLifeCycleListener((LifeCycle.Listener)this);
    }
}

