/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.healthcheck;

import java.util.Properties;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;

public class StartupHealthCheck {
    public static final Logger log = Logger.getLogger(StartupHealthCheck.class);
    private final StartupHealthCheckRule[] rules;
    private StartupHealthCheckRule failedRule = null;

    public StartupHealthCheck(StartupHealthCheckRule ... rules) {
        this.rules = rules;
    }

    public boolean run() {
        if (this.rules == null || this.rules.length < 1) {
            return true;
        }
        Properties properties = System.getProperties();
        for (StartupHealthCheckRule r : this.rules) {
            if (r.execute(properties)) continue;
            log.error(r.getFailureMessage(), new Object[0]);
            this.failedRule = r;
            return false;
        }
        return true;
    }

    public StartupHealthCheckRule failedRule() {
        return this.failedRule;
    }
}

