/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.helpers.Service;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public final class RepresentationFormatRepository {
    private final Map<MediaType, RepresentationFormat> formats;
    private final ExtensionInjector injector;

    public RepresentationFormatRepository(ExtensionInjector injector) {
        this.injector = injector;
        this.formats = new HashMap<MediaType, RepresentationFormat>();
        for (RepresentationFormat format : Service.load(RepresentationFormat.class)) {
            this.formats.put(format.mediaType, format);
        }
    }

    public OutputFormat outputFormat(List<MediaType> acceptable, URI baseUri) {
        for (MediaType type : acceptable) {
            RepresentationFormat format = this.formats.get(type);
            if (format == null) continue;
            return new OutputFormat(format, baseUri, this.injector);
        }
        return new OutputFormat(this.useDefault(acceptable), baseUri, this.injector);
    }

    public InputFormat inputFormat(MediaType type) {
        if (type == null) {
            return this.useDefault(new MediaType[0]);
        }
        RepresentationFormat format = this.formats.get(type);
        if (format != null) {
            return format;
        }
        format = this.formats.get(new MediaType(type.getType(), type.getSubtype()));
        if (format != null) {
            return format;
        }
        return this.useDefault(type);
    }

    private DefaultFormat useDefault(List<MediaType> acceptable) {
        return this.useDefault(acceptable.toArray(new MediaType[acceptable.size()]));
    }

    private DefaultFormat useDefault(MediaType ... type) {
        return new DefaultFormat(new JsonFormat(), this.formats.keySet(), type);
    }
}

