/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.webadmin.rest.representations.JmxAttributeRepresentationDispatcher;

public class CypherResultRepresentation
extends ObjectRepresentation {
    private final Representation resultRepresentation;
    private final ListRepresentation columns;

    public CypherResultRepresentation(ExecutionResult result) {
        super(RepresentationType.STRING);
        this.resultRepresentation = this.createResultRepresentation(result);
        this.columns = ListRepresentation.string((Iterable)result.columns());
    }

    @ObjectRepresentation.Mapping(value="columns")
    public Representation columns() {
        return this.columns;
    }

    @ObjectRepresentation.Mapping(value="data")
    public Representation data() {
        return this.resultRepresentation;
    }

    private Representation createResultRepresentation(ExecutionResult executionResult) {
        ArrayList<ListRepresentation> rows = new ArrayList<ListRepresentation>();
        for (Map row : executionResult) {
            ArrayList<Representation> fields = new ArrayList<Representation>();
            for (String column : executionResult.columns()) {
                Representation rowRep = this.getRepresentation(row.get(column));
                fields.add(rowRep);
            }
            rows.add(new ListRepresentation("row", fields));
        }
        return new ListRepresentation("data", rows);
    }

    Representation getRepresentation(Object r) {
        if (r == null) {
            return ValueRepresentation.string(null);
        }
        if (r instanceof Path) {
            return new PathRepresentation<Path>((Path)r);
        }
        if (r instanceof Iterable) {
            return this.handleIterable((Iterable)r);
        }
        if (r instanceof Node) {
            return new NodeRepresentation((Node)r);
        }
        if (r instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)r);
        }
        JmxAttributeRepresentationDispatcher representationDispatcher = new JmxAttributeRepresentationDispatcher();
        return (Representation)representationDispatcher.dispatch(r, "");
    }

    Representation handleIterable(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        for (Object value : data) {
            Representation rep = this.getRepresentation(value);
            results.add(rep);
        }
        RepresentationType representationType = this.getType(results);
        return new ListRepresentation(representationType, results);
    }

    RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }
}

