/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.shell.ShellSettings;
import org.rrd4j.core.RrdDb;

public class Database {
    public static Logger log = Logger.getLogger(Database.class);
    public GraphDatabaseAPI graph;
    private final String databaseStoreDirectory;
    private RrdDb rrdDb;
    private final StatisticCollector statisticCollector = new StatisticCollector();

    public Database(GraphDatabaseAPI db) {
        this.databaseStoreDirectory = db.getStoreDir();
        this.graph = db;
    }

    public Database(GraphDatabaseFactory factory, String databaseStoreDirectory) {
        this(Database.createDatabase(factory, databaseStoreDirectory, null));
        log.warn("No database tuning properties set in the property file, using defaults. Please specify the performance properties file with org.neo4j.server.db.tuning.properties in the server properties file [%s].", System.getProperty("org.neo4j.server.properties"));
    }

    public Database(GraphDatabaseFactory factory, String databaseStoreDirectory, Map<String, String> databaseTuningProperties) {
        this(Database.createDatabase(factory, databaseStoreDirectory, databaseTuningProperties));
    }

    private static GraphDatabaseAPI createDatabase(GraphDatabaseFactory factory, String databaseStoreDirectory, Map<String, String> databaseProperties) {
        log.info("Using database at " + databaseStoreDirectory, new Object[0]);
        if (databaseProperties == null) {
            databaseProperties = new HashMap<String, String>();
        }
        Database.putIfAbsent(databaseProperties, ShellSettings.remote_shell_enabled.name(), "true");
        Database.putIfAbsent(databaseProperties, GraphDatabaseSettings.keep_logical_logs.name(), "true");
        databaseProperties.put(UdcSettings.udc_source.name(), "server");
        return factory.createDatabase(databaseStoreDirectory, databaseProperties);
    }

    private static void putIfAbsent(Map<String, String> databaseProperties, String configKey, String configValue) {
        if (databaseProperties.get(configKey) == null) {
            databaseProperties.put(configKey, configValue);
        }
    }

    public void startup() {
        if (this.graph != null) {
            log.info("Successfully started database", new Object[0]);
        } else {
            log.error("Failed to start database. GraphDatabaseService has not been properly initialized.", new Object[0]);
        }
    }

    public void shutdown() {
        try {
            if (this.rrdDb != null) {
                this.rrdDb.close();
            }
            if (this.graph != null) {
                this.graph.shutdown();
            }
            log.info("Successfully shutdown database", new Object[0]);
        }
        catch (Exception e) {
            log.error("Database did not shut down cleanly. Reason [%s]", e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String getLocation() {
        return this.databaseStoreDirectory;
    }

    public Index<Relationship> getRelationshipIndex(String name) {
        RelationshipIndex index = this.graph.index().forRelationships(name);
        if (index == null) {
            throw new RuntimeException("No index for [" + name + "]");
        }
        return index;
    }

    public Index<Node> getNodeIndex(String name) {
        Index index = this.graph.index().forNodes(name);
        if (index == null) {
            throw new RuntimeException("No index for [" + name + "]");
        }
        return index;
    }

    public RrdDb rrdDb() {
        return this.rrdDb;
    }

    public void setRrdDb(RrdDb rrdDb) {
        this.rrdDb = rrdDb;
    }

    public IndexManager getIndexManager() {
        return this.graph.index();
    }

    public StatisticCollector statisticCollector() {
        return this.statisticCollector;
    }
}

