/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.NeoServerBootstrapper;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.database.GraphDatabaseFactory;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.startup.healthcheck.StartupHealthCheck;
import org.neo4j.server.startup.healthcheck.StartupHealthCheckRule;
import org.neo4j.server.web.Jetty6WebServer;

public abstract class Bootstrapper {
    public static final Integer OK = 0;
    public static final Integer WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final Integer GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    private static Logger log = Logger.getLogger(NeoServerBootstrapper.class);
    protected NeoServerWithEmbeddedWebServer server;

    public static void main(String[] args) {
        Bootstrapper bootstrapper = Bootstrapper.loadMostDerivedBootstrapper();
        Integer exit = bootstrapper.start(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public static Bootstrapper loadMostDerivedBootstrapper() {
        Bootstrapper winner = new NeoServerBootstrapper();
        for (Bootstrapper candidate : Service.load(Bootstrapper.class)) {
            if (!candidate.isMoreDerivedThan(winner)) continue;
            winner = candidate;
        }
        return winner;
    }

    public void controlEvent(int arg) {
    }

    public Integer start() {
        return this.start(new String[0]);
    }

    public Integer start(String[] args) {
        try {
            StartupHealthCheck startupHealthCheck = new StartupHealthCheck(this.rules());
            Jetty6WebServer webServer = new Jetty6WebServer();
            this.server = new NeoServerWithEmbeddedWebServer(this, startupHealthCheck, this.getConfigurator(), webServer, this.getServerModules());
            this.server.start();
            this.addShutdownHook();
            return OK;
        }
        catch (TransactionFailureException tfe) {
            log.error(tfe);
            log.error(String.format("Failed to start Neo Server on port [%d], because ", this.server.getWebServerPort()) + (Object)((Object)tfe) + ". Another process may be using database location " + this.server.getDatabase().getLocation(), new Object[0]);
            return GRAPH_DATABASE_STARTUP_ERROR_CODE;
        }
        catch (Exception e) {
            log.error(e);
            log.error("Failed to start Neo Server on port [%s]", this.server.getWebServerPort());
            return WEB_SERVER_STARTUP_ERROR_CODE;
        }
    }

    public void stop() {
        this.stop(0);
    }

    public int stop(int stopArg) {
        String location = "unknown location";
        try {
            if (this.server != null) {
                this.server.stop();
            }
            log.info("Successfully shutdown Neo Server on port [%d], database [%s]", this.server.getWebServerPort(), location);
            return 0;
        }
        catch (Exception e) {
            log.error("Failed to cleanly shutdown Neo Server on port [%d], database [%s]. Reason [%s] ", this.server.getWebServerPort(), location, e.getMessage());
            return 1;
        }
    }

    public NeoServerWithEmbeddedWebServer getServer() {
        return this.server;
    }

    protected abstract GraphDatabaseFactory getGraphDatabaseFactory(Configuration var1);

    protected abstract Iterable<StartupHealthCheckRule> getHealthCheckRules();

    protected abstract Iterable<Class<? extends ServerModule>> getServerModules();

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Neo4j Server shutdown initiated by kill signal", new Object[0]);
                if (Bootstrapper.this.server != null) {
                    Bootstrapper.this.server.stop();
                }
            }
        });
    }

    protected Configurator getConfigurator() {
        File configFile = new File(System.getProperty("org.neo4j.server.properties", Configurator.DEFAULT_CONFIG_DIR));
        return new PropertyFileConfigurator(new Validator(new DatabaseLocationMustBeSpecifiedRule()), configFile);
    }

    protected boolean isMoreDerivedThan(Bootstrapper other) {
        return other.getClass().isAssignableFrom(this.getClass());
    }

    private StartupHealthCheckRule[] rules() {
        return IteratorUtil.asCollection(this.getHealthCheckRules()).toArray(new StartupHealthCheckRule[0]);
    }
}

