/*
 * Decompiled with CFR 0.152.
 */
package org.neidhardt.rxlocation.services;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.neidhardt.rxlocation.exceptions.MissingPermissionCoarseLocation;
import org.neidhardt.rxlocation.exceptions.MissingPermissionFineLocation;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u000b"}, d2={"hasPermissionCoarseLocation", "", "Landroid/content/Context;", "getHasPermissionCoarseLocation", "(Landroid/content/Context;)Z", "hasPermissionFineLocation", "getHasPermissionFineLocation", "getErrorForMissingPermission", "", "context", "isRequiredPermissionGranted", "rx-location-services_release"})
public final class GoogleLocationServiceKt {
    private static final boolean isRequiredPermissionGranted(Context context) {
        return GoogleLocationServiceKt.getHasPermissionFineLocation(context) || GoogleLocationServiceKt.getHasPermissionCoarseLocation(context);
    }

    private static final Throwable getErrorForMissingPermission(Context context) {
        return !GoogleLocationServiceKt.getHasPermissionFineLocation(context) ? (Throwable)new MissingPermissionFineLocation("Fine location permission is missing, make sure to ask the user for it") : (!GoogleLocationServiceKt.getHasPermissionCoarseLocation(context) ? (Throwable)new MissingPermissionCoarseLocation("Coarse location permission is missing, make sure to ask the user for it") : new Throwable("Required permission is missing"));
    }

    private static final boolean getHasPermissionFineLocation(@NotNull Context $receiver) {
        return ContextCompat.checkSelfPermission((Context)$receiver, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private static final boolean getHasPermissionCoarseLocation(@NotNull Context $receiver) {
        return ContextCompat.checkSelfPermission((Context)$receiver, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    public static final /* synthetic */ boolean access$isRequiredPermissionGranted(Context context) {
        return GoogleLocationServiceKt.isRequiredPermissionGranted(context);
    }

    public static final /* synthetic */ Throwable access$getErrorForMissingPermission(Context context) {
        return GoogleLocationServiceKt.getErrorForMissingPermission(context);
    }
}

