/*
 * Decompiled with CFR 0.152.
 */
package org.neidhardt.rxlocation.services;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.functions.Cancellable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neidhardt.rxlocation.exceptions.MissingSensor;
import org.neidhardt.rxlocation.services.BearingSensorService;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/neidhardt/rxlocation/services/BearingSensorService;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "lastKnownBearing", "", "getLastKnownBearing", "()Ljava/lang/Float;", "setLastKnownBearing", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "sensorManager", "Landroid/hardware/SensorManager;", "calculateAzimuthDegree", "accelerometerReading", "", "magnetometerReading", "getBearingUpdates", "Lio/reactivex/Flowable;", "rx-location-services_release"})
public final class BearingSensorService {
    private final SensorManager sensorManager;
    @Nullable
    private Float lastKnownBearing;

    @Nullable
    public final Float getLastKnownBearing() {
        return this.lastKnownBearing;
    }

    public final void setLastKnownBearing(@Nullable Float f) {
        this.lastKnownBearing = f;
    }

    @NotNull
    public final Flowable<Float> getBearingUpdates() {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(this){
            final /* synthetic */ BearingSensorService this$0;

            /*
             * WARNING - void declaration
             */
            public final void subscribe(@NotNull FlowableEmitter<Float> emitter) {
                void isMagnetometerReadingAvailable;
                void isAccelerometerReadingAvailable;
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                Sensor rotationSensor = BearingSensorService.access$getSensorManager$p(this.this$0).getDefaultSensor(2);
                Sensor accelerationSensor = BearingSensorService.access$getSensorManager$p(this.this$0).getDefaultSensor(1);
                float[] accelerometerReading = new float[3];
                float[] magnetometerReading = new float[3];
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
                booleanRef2.element = false;
                if (rotationSensor == null) {
                    emitter.onError((Throwable)new MissingSensor("Rotation sensor could not be accessed"));
                }
                if (accelerationSensor == null) {
                    emitter.onError((Throwable)new MissingSensor("Acceleration sensor could not be accessed"));
                }
                SensorEventListener accelerationSensorsCallback2 = new SensorEventListener(this, accelerometerReading, (Ref.BooleanRef)isAccelerometerReadingAvailable, emitter, (Ref.BooleanRef)isMagnetometerReadingAvailable, magnetometerReading){
                    final /* synthetic */ getBearingUpdates.1 this$0;
                    final /* synthetic */ float[] $accelerometerReading;
                    final /* synthetic */ Ref.BooleanRef $isAccelerometerReadingAvailable;
                    final /* synthetic */ FlowableEmitter $emitter;
                    final /* synthetic */ Ref.BooleanRef $isMagnetometerReadingAvailable;
                    final /* synthetic */ float[] $magnetometerReading;

                    public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
                    }

                    public void onSensorChanged(@Nullable SensorEvent event) {
                        if (event != null) {
                            System.arraycopy(event.values, 0, this.$accelerometerReading, 0, this.$accelerometerReading.length);
                            this.$isAccelerometerReadingAvailable.element = true;
                        } else {
                            this.$emitter.onError((Throwable)new MissingSensor("Received acceleration sensor event is null"));
                        }
                        if (this.$isAccelerometerReadingAvailable.element && this.$isMagnetometerReadingAvailable.element) {
                            this.$emitter.onNext((Object)Float.valueOf(BearingSensorService.access$calculateAzimuthDegree(this.this$0.this$0, this.$accelerometerReading, this.$magnetometerReading)));
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$accelerometerReading = $captured_local_variable$1;
                        this.$isAccelerometerReadingAvailable = $captured_local_variable$2;
                        this.$emitter = $captured_local_variable$3;
                        this.$isMagnetometerReadingAvailable = $captured_local_variable$4;
                        this.$magnetometerReading = $captured_local_variable$5;
                    }
                };
                SensorEventListener rotationSensorUpdateCallback2 = new SensorEventListener(this, magnetometerReading, (Ref.BooleanRef)isMagnetometerReadingAvailable, emitter, (Ref.BooleanRef)isAccelerometerReadingAvailable, accelerometerReading){
                    final /* synthetic */ getBearingUpdates.1 this$0;
                    final /* synthetic */ float[] $magnetometerReading;
                    final /* synthetic */ Ref.BooleanRef $isMagnetometerReadingAvailable;
                    final /* synthetic */ FlowableEmitter $emitter;
                    final /* synthetic */ Ref.BooleanRef $isAccelerometerReadingAvailable;
                    final /* synthetic */ float[] $accelerometerReading;

                    public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
                    }

                    public void onSensorChanged(@Nullable SensorEvent event) {
                        if (event != null) {
                            System.arraycopy(event.values, 0, this.$magnetometerReading, 0, this.$magnetometerReading.length);
                            this.$isMagnetometerReadingAvailable.element = true;
                        } else {
                            this.$emitter.onError(new Throwable("Received rotation sensor event is null"));
                        }
                        if (this.$isAccelerometerReadingAvailable.element && this.$isMagnetometerReadingAvailable.element) {
                            this.$emitter.onNext((Object)Float.valueOf(BearingSensorService.access$calculateAzimuthDegree(this.this$0.this$0, this.$accelerometerReading, this.$magnetometerReading)));
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$magnetometerReading = $captured_local_variable$1;
                        this.$isMagnetometerReadingAvailable = $captured_local_variable$2;
                        this.$emitter = $captured_local_variable$3;
                        this.$isAccelerometerReadingAvailable = $captured_local_variable$4;
                        this.$accelerometerReading = $captured_local_variable$5;
                    }
                };
                emitter.setCancellable(new Cancellable(this, accelerationSensorsCallback2, rotationSensorUpdateCallback2){
                    final /* synthetic */ getBearingUpdates.1 this$0;
                    final /* synthetic */ getBearingUpdates.accelerationSensorsCallback.1 $accelerationSensorsCallback;
                    final /* synthetic */ getBearingUpdates.rotationSensorUpdateCallback.1 $rotationSensorUpdateCallback;

                    public final void cancel() {
                        BearingSensorService.access$getSensorManager$p(this.this$0.this$0).unregisterListener((SensorEventListener)this.$accelerationSensorsCallback);
                        BearingSensorService.access$getSensorManager$p(this.this$0.this$0).unregisterListener((SensorEventListener)this.$rotationSensorUpdateCallback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$accelerationSensorsCallback = var2_2;
                        this.$rotationSensorUpdateCallback = var3_3;
                    }
                });
                BearingSensorService.access$getSensorManager$p(this.this$0).registerListener(accelerationSensorsCallback2, accelerationSensor, 1);
                BearingSensorService.access$getSensorManager$p(this.this$0).registerListener(rotationSensorUpdateCallback2, rotationSensor, 1);
            }
            {
                this.this$0 = bearingSensorService;
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.create({ emitte\u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    private final float calculateAzimuthDegree(float[] accelerometerReading, float[] magnetometerReading) {
        float[] rotationMatrix = new float[9];
        SensorManager.getRotationMatrix((float[])rotationMatrix, null, (float[])accelerometerReading, (float[])magnetometerReading);
        float[] orientation = new float[3];
        SensorManager.getOrientation((float[])rotationMatrix, (float[])orientation);
        float azimuthInRadians = orientation[0];
        return (float)(Math.toDegrees(azimuthInRadians) + (double)360) % (float)360;
    }

    public BearingSensorService(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("sensor");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        this.sensorManager = (SensorManager)object;
    }

    public static final /* synthetic */ SensorManager access$getSensorManager$p(BearingSensorService $this) {
        return $this.sensorManager;
    }

    public static final /* synthetic */ float access$calculateAzimuthDegree(BearingSensorService $this, float[] accelerometerReading, float[] magnetometerReading) {
        return $this.calculateAzimuthDegree(accelerometerReading, magnetometerReading);
    }
}

