/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.util.Collections;
import java.util.List;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.nd4j.python4j.PythonContextManager;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonExecutioner;
import org.nd4j.python4j.PythonGC;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonTypes;
import org.nd4j.python4j.PythonVariable;

public class Python {
    public static PythonObject importModule(String moduleName) {
        PythonGIL.assertThreadSafe();
        PythonObject module = new PythonObject(python.PyImport_ImportModule((String)moduleName));
        if (module.isNone()) {
            throw new PythonException("Error importing module: " + moduleName);
        }
        return module;
    }

    public static PythonObject attr(String attrName) {
        PythonGIL.assertThreadSafe();
        PyObject builtins = python.PyImport_ImportModule((String)"builtins");
        try {
            PythonObject pythonObject = new PythonObject(python.PyObject_GetAttrString((PyObject)builtins, (String)attrName));
            return pythonObject;
        }
        finally {
            python.Py_DecRef((PyObject)builtins);
        }
    }

    public static PythonObject len(PythonObject pythonObject) {
        PythonGIL.assertThreadSafe();
        long n = python.PyObject_Size((PyObject)pythonObject.getNativePythonObject());
        if (n < 0L) {
            throw new PythonException("Object has no length: " + pythonObject);
        }
        return PythonTypes.INT.toPython(n);
    }

    public static PythonObject str(PythonObject pythonObject) {
        PythonGIL.assertThreadSafe();
        try {
            return PythonTypes.STR.toPython(pythonObject.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PythonObject str() {
        PythonGIL.assertThreadSafe();
        try {
            return PythonTypes.STR.toPython("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PythonObject strType() {
        return Python.attr("str");
    }

    public static PythonObject float_(PythonObject pythonObject) {
        return PythonTypes.FLOAT.toPython(PythonTypes.FLOAT.toJava(pythonObject));
    }

    public static PythonObject float_() {
        try {
            return PythonTypes.FLOAT.toPython(0.0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PythonObject floatType() {
        return Python.attr("float");
    }

    public static PythonObject bool(PythonObject pythonObject) {
        return PythonTypes.BOOL.toPython(PythonTypes.BOOL.toJava(pythonObject));
    }

    public static PythonObject bool() {
        return PythonTypes.BOOL.toPython(false);
    }

    public static PythonObject boolType() {
        return Python.attr("bool");
    }

    public static PythonObject int_(PythonObject pythonObject) {
        return PythonTypes.INT.toPython(PythonTypes.INT.toJava(pythonObject));
    }

    public static PythonObject int_() {
        return PythonTypes.INT.toPython(0L);
    }

    public static PythonObject intType() {
        return Python.attr("int");
    }

    public static PythonObject list(PythonObject pythonObject) {
        PythonGIL.assertThreadSafe();
        try (PythonGC gc = PythonGC.watch();){
            PythonObject listF = Python.attr("list");
            PythonObject ret = listF.call(pythonObject);
            if (ret.isNone()) {
                throw new PythonException("Object is not iterable: " + pythonObject.toString());
            }
            PythonObject pythonObject2 = ret;
            return pythonObject2;
        }
    }

    public static PythonObject list() {
        return PythonTypes.LIST.toPython(Collections.emptyList());
    }

    public static PythonObject listType() {
        return Python.attr("list");
    }

    public static PythonObject dict(PythonObject pythonObject) {
        PythonObject dictF = Python.attr("dict");
        PythonObject ret = dictF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build dict from object: " + pythonObject.toString());
        }
        dictF.del();
        return ret;
    }

    public static PythonObject dict() {
        return PythonTypes.DICT.toPython(Collections.emptyMap());
    }

    public static PythonObject dictType() {
        return Python.attr("dict");
    }

    public static PythonObject set(PythonObject pythonObject) {
        PythonObject setF = Python.attr("set");
        PythonObject ret = setF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build set from object: " + pythonObject.toString());
        }
        setF.del();
        return ret;
    }

    public static PythonObject set() {
        PythonObject setF = Python.attr("set");
        PythonObject ret = setF.call(new Object[0]);
        setF.del();
        return ret;
    }

    public static PythonObject setType() {
        return Python.attr("set");
    }

    public static PythonObject bytearray(PythonObject pythonObject) {
        PythonObject baF = Python.attr("bytearray");
        PythonObject ret = baF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build bytearray from object: " + pythonObject.toString());
        }
        baF.del();
        return ret;
    }

    public static PythonObject bytearray() {
        PythonObject baF = Python.attr("bytearray");
        PythonObject ret = baF.call(new Object[0]);
        baF.del();
        return ret;
    }

    public static PythonObject bytearrayType() {
        return Python.attr("bytearray");
    }

    public static PythonObject memoryview(PythonObject pythonObject) {
        PythonObject mvF = Python.attr("memoryview");
        PythonObject ret = mvF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build memoryview from object: " + pythonObject.toString());
        }
        mvF.del();
        return ret;
    }

    public static PythonObject memoryviewType() {
        return Python.attr("memoryview");
    }

    public static PythonObject bytes(PythonObject pythonObject) {
        PythonObject bytesF = Python.attr("bytes");
        PythonObject ret = bytesF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build bytes from object: " + pythonObject.toString());
        }
        bytesF.del();
        return ret;
    }

    public static PythonObject bytes() {
        PythonObject bytesF = Python.attr("bytes");
        PythonObject ret = bytesF.call(new Object[0]);
        bytesF.del();
        return ret;
    }

    public static PythonObject bytesType() {
        return Python.attr("bytes");
    }

    public static PythonObject tuple(PythonObject pythonObject) {
        PythonObject tupleF = Python.attr("tupleF");
        PythonObject ret = tupleF.call(pythonObject);
        if (ret.isNone()) {
            throw new PythonException("Cannot build tuple from object: " + pythonObject.toString());
        }
        tupleF.del();
        return ret;
    }

    public static PythonObject tuple() {
        PythonObject tupleF = Python.attr("tuple");
        PythonObject ret = tupleF.call(new Object[0]);
        tupleF.del();
        return ret;
    }

    public static PythonObject tupleType() {
        return Python.attr("tuple");
    }

    public static PythonObject Exception(PythonObject pythonObject) {
        PythonObject excF = Python.attr("Exception");
        PythonObject ret = excF.call(pythonObject);
        excF.del();
        return ret;
    }

    public static PythonObject Exception() {
        PythonObject excF = Python.attr("Exception");
        PythonObject ret = excF.call(new Object[0]);
        excF.del();
        return ret;
    }

    public static PythonObject ExceptionType() {
        return Python.attr("Exception");
    }

    public static PythonObject globals() {
        PythonGIL.assertThreadSafe();
        PyObject main = python.PyImport_ImportModule((String)"__main__");
        PyObject globals = python.PyModule_GetDict((PyObject)main);
        python.Py_DecRef((PyObject)main);
        return new PythonObject(globals, false);
    }

    public static PythonObject type(PythonObject pythonObject) {
        PythonObject typeF = Python.attr("type");
        PythonObject ret = typeF.call(pythonObject);
        typeF.del();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isinstance(PythonObject obj, PythonObject ... type) {
        PythonGIL.assertThreadSafe();
        PyObject argsTuple = python.PyTuple_New((long)type.length);
        try {
            for (int i = 0; i < type.length; ++i) {
                PythonObject x = type[i];
                python.Py_IncRef((PyObject)x.getNativePythonObject());
                python.PyTuple_SetItem((PyObject)argsTuple, (long)i, (PyObject)x.getNativePythonObject());
            }
            boolean bl = python.PyObject_IsInstance((PyObject)obj.getNativePythonObject(), (PyObject)argsTuple) != 0;
            return bl;
        }
        finally {
            python.Py_DecRef((PyObject)argsTuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonObject eval(String expression) {
        PythonGIL.assertThreadSafe();
        PyObject compiledCode = python.Py_CompileString((String)expression, (String)"", (int)258);
        PyObject main = python.PyImport_ImportModule((String)"__main__");
        PyObject globals = python.PyModule_GetDict((PyObject)main);
        PyObject locals = python.PyDict_New();
        try {
            PythonObject pythonObject = new PythonObject(python.PyEval_EvalCode((PyObject)compiledCode, (PyObject)globals, (PyObject)locals));
            return pythonObject;
        }
        finally {
            python.Py_DecRef((PyObject)main);
            python.Py_DecRef((PyObject)locals);
            python.Py_DecRef((PyObject)compiledCode);
        }
    }

    public static PythonObject builtins() {
        return Python.importModule("builtins");
    }

    public static PythonObject None() {
        return Python.eval("None");
    }

    public static PythonObject True() {
        return Python.eval("True");
    }

    public static PythonObject False() {
        return Python.eval("False");
    }

    public static boolean callable(PythonObject pythonObject) {
        PythonGIL.assertThreadSafe();
        return python.PyCallable_Check((PyObject)pythonObject.getNativePythonObject()) == 1;
    }

    public static void setContext(String context) {
        PythonContextManager.setContext(context);
    }

    public static String getCurrentContext() {
        return PythonContextManager.getCurrentContext();
    }

    public static void deleteContext(String context) {
        PythonContextManager.deleteContext(context);
    }

    public static void resetContext() {
        PythonContextManager.reset();
    }

    public static void exec(String code) throws PythonException {
        PythonExecutioner.exec(code);
    }

    public static void exec(String code, List<PythonVariable> inputs, List<PythonVariable> outputs) {
        PythonExecutioner.exec(code, inputs, outputs);
    }

    static {
        new PythonExecutioner();
    }
}

