/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.common.primitives.Pair;
import org.nd4j.python4j.GILLock;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonExecutioner;
import org.nd4j.python4j.PythonInterpreter;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonType;
import org.nd4j.python4j.PythonTypes;
import org.nd4j.shade.netty.util.concurrent.FastThreadLocal;

public class UncheckedPythonInterpreter
implements PythonInterpreter {
    private static final String ANS = "__ans__";
    private static final String ANS_EQUALS = "__ans__ = ";
    private static final FastThreadLocal<UncheckedPythonInterpreter> INSTANCE;
    private static PyObject globals;
    private static PyObject globalsAns;
    private static final Map<String, Pair<PythonObject, Object>> cachedVariables;
    private final GILLock gilLock = new GILLock();

    private UncheckedPythonInterpreter() {
    }

    @Override
    public Object getCachedPython(String varName) {
        return cachedVariables.get(varName).getKey();
    }

    @Override
    public Object getCachedJava(String varName) {
        return cachedVariables.get(varName).getValue();
    }

    @Override
    public Pair<PythonObject, Object> getCachedPythonJava(String varName) {
        return cachedVariables.get(varName);
    }

    public PythonObject newNone() {
        this.evalUnchecked("__ans__ = None");
        return this.getAns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Class<UncheckedPythonInterpreter> clazz = UncheckedPythonInterpreter.class;
        synchronized (UncheckedPythonInterpreter.class) {
            if (globals != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.gilLock.lock();
            PythonExecutioner.init();
            try (InputStream is = new ClassPathResource(UncheckedPythonInterpreter.class.getSimpleName() + ".py").getInputStream();){
                String code = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
                int result = python.PyRun_SimpleString((String)code);
                if (result != 0) {
                    throw new PythonException("Execution failed, unable to retrieve python exception.");
                }
                PyObject main = python.PyImport_ImportModule((String)"__main__");
                globals = python.PyModule_GetDict((PyObject)main);
                globalsAns = python.PyUnicode_FromString((String)ANS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.gilLock.unlock();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void eval(String expression) {
        this.gilLock.lock();
        try {
            this.evalUnchecked(expression);
        }
        finally {
            this.gilLock.unlock();
        }
    }

    private void evalUnchecked(String expression) {
        int result = python.PyRun_SimpleString((String)expression);
        if (result != 0) {
            throw new PythonException("Execution failed, unable to retrieve python exception.");
        }
    }

    private PythonObject getAns() {
        return new PythonObject(python.PyObject_GetItem((PyObject)globals, (PyObject)globalsAns), false);
    }

    public static UncheckedPythonInterpreter getInstance() {
        return (UncheckedPythonInterpreter)INSTANCE.get();
    }

    @Override
    public GILLock gilLock() {
        return this.gilLock;
    }

    @Override
    public void exec(String expression) {
        this.eval(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String variable, boolean getNew) {
        Object ret = null;
        this.gilLock.lock();
        try {
            this.evalUnchecked(ANS_EQUALS + variable);
            PythonObject ans = this.getAns();
            PythonType type = PythonTypes.getPythonTypeForPythonObject(ans);
            Object o = type.toJava(ans);
            cachedVariables.put(variable, (Pair<PythonObject, Object>)Pair.of((Object)ans, o));
            ret = o;
        }
        finally {
            this.gilLock.unlock();
        }
        return ret;
    }

    @Override
    public void set(String variable, Object value) {
        this.gilLock.lock();
        try {
            if (value == null) {
                this.evalUnchecked(variable + " = None");
                cachedVariables.put(variable, (Pair<PythonObject, Object>)Pair.of((Object)UncheckedPythonInterpreter.getInstance().newNone(), null));
            } else {
                PythonObject converted = PythonTypes.convert(value);
                python.PyDict_SetItemString((PyObject)globals, (String)variable, (PyObject)converted.getNativePythonObject());
                cachedVariables.put(variable, (Pair<PythonObject, Object>)Pair.of((Object)converted, (Object)value));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Variable=" + variable + " Value=" + value, t);
        }
        finally {
            this.gilLock.unlock();
        }
    }

    static {
        cachedVariables = new ConcurrentHashMap<String, Pair<PythonObject, Object>>();
        INSTANCE = new FastThreadLocal<UncheckedPythonInterpreter>(){

            protected UncheckedPythonInterpreter initialValue() throws Exception {
                return new UncheckedPythonInterpreter();
            }
        };
    }
}

