/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.bytedeco.cpython.python;
import org.bytedeco.javacpp.Loader;
import org.nd4j.python4j.PythonException;

public class PythonProcess {
    private static String pythonExecutable = Loader.load(python.class);

    public static String runAndReturn(String ... arguments) throws IOException, InterruptedException {
        String[] allArgs = new String[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            allArgs[i + 1] = arguments[i];
        }
        allArgs[0] = pythonExecutable;
        ProcessBuilder pb = new ProcessBuilder(allArgs);
        Process process = pb.start();
        String out = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
        process.waitFor();
        return out;
    }

    public static void run(String ... arguments) throws IOException, InterruptedException {
        String[] allArgs = new String[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            allArgs[i + 1] = arguments[i];
        }
        allArgs[0] = pythonExecutable;
        ProcessBuilder pb = new ProcessBuilder(allArgs);
        pb.inheritIO().start().waitFor();
    }

    public static void pipInstall(String packageName) throws PythonException {
        try {
            PythonProcess.run("-m", "pip", "install", packageName);
        }
        catch (Exception e) {
            throw new PythonException("Error installing package " + packageName, e);
        }
    }

    public static void pipInstall(String packageName, String version) {
        PythonProcess.pipInstall(packageName + "==" + version);
    }

    public static void pipUninstall(String packageName) throws PythonException {
        try {
            PythonProcess.run("-m", "pip", "uninstall", packageName);
        }
        catch (Exception e) {
            throw new PythonException("Error uninstalling package " + packageName, e);
        }
    }

    public static void pipInstallFromGit(String gitRepoUrl) {
        if (!((String)gitRepoUrl).contains("://")) {
            gitRepoUrl = "git://" + (String)gitRepoUrl;
        }
        try {
            PythonProcess.run(new String[]{"-m", "pip", "install", "git+", gitRepoUrl});
        }
        catch (Exception e) {
            throw new PythonException("Error installing package from " + (String)gitRepoUrl, e);
        }
    }

    public static String getPackageVersion(String packageName) {
        String out;
        try {
            out = PythonProcess.runAndReturn("-m", "pip", "show", packageName);
        }
        catch (Exception e) {
            throw new PythonException("Error finding version for package " + packageName, e);
        }
        if (!out.contains("Version: ")) {
            throw new PythonException("Can't find package " + packageName);
        }
        String pkgVersion = out.split("Version: ")[1].split(System.lineSeparator())[0];
        return pkgVersion;
    }

    public static boolean isPackageInstalled(String packageName) {
        try {
            String out = PythonProcess.runAndReturn("-m", "pip", "show", packageName);
            return !out.isEmpty();
        }
        catch (Exception e) {
            throw new PythonException("Error checking if package is installed: " + packageName, e);
        }
    }

    public static void pipInstallFromRequirementsTxt(String path) {
        try {
            PythonProcess.run("-m", "pip", "install", "-r", path);
        }
        catch (Exception e) {
            throw new PythonException("Error installing packages from " + path, e);
        }
    }

    public static void pipInstallFromSetupScript(String path, boolean inplace) {
        try {
            PythonProcess.run(path, inplace ? "develop" : "install");
        }
        catch (Exception e) {
            throw new PythonException("Error installing package from " + path, e);
        }
    }
}

