/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.shade.guava.util.concurrent.CycleDetectingLockFactory;

public class GILLock
implements Lock {
    private static CycleDetectingLockFactory cycleDetectingLockFactory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.DISABLED);
    private static final ReentrantLock reentrantLock = cycleDetectingLockFactory.newReentrantLock("python4j_lock");
    private PythonGIL pythonGIL;
    private final AtomicInteger lockedCount = new AtomicInteger();

    @Override
    public void lock() {
        if (this.lockedCount.incrementAndGet() == 1) {
            reentrantLock.lock();
            this.pythonGIL = PythonGIL.lock();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        this.lock();
        return true;
    }

    @Override
    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public void unlock() {
        if (this.lockedCount.decrementAndGet() == 0) {
            if (this.pythonGIL != null) {
                this.pythonGIL.close();
            }
            this.pythonGIL = null;
            reentrantLock.unlock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

