/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.helper.python;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonGIL;
import org.nd4j.python4j.PythonObject;
import org.nd4j.python4j.PythonType;
import org.nd4j.python4j.PythonTypes;
import org.nd4j.python4j.PythonVariable;
import org.nd4j.python4j.PythonVariables;

public class PythonExecutioner {
    private static final String PYTHON_EXCEPTION_KEY = "__python_exception__";
    private static AtomicBoolean init = new AtomicBoolean(false);
    public static final String DEFAULT_PYTHON_PATH_PROPERTY = "org.eclipse.python4j.path";
    public static final String JAVACPP_PYTHON_APPEND_TYPE = "org.eclipse.python4j.path.append";
    public static final String DEFAULT_APPEND_TYPE = "before";

    private static synchronized void init() {
        if (init.get()) {
            return;
        }
        init.set(true);
        PythonExecutioner.initPythonPath();
        org.bytedeco.cpython.global.python.PyEval_InitThreads();
        org.bytedeco.cpython.global.python.Py_InitializeEx((int)0);
        for (PythonType type : PythonTypes.get()) {
            type.init();
        }
        PythonGIL.setMainThreadState();
        org.bytedeco.cpython.global.python.PyEval_SaveThread();
    }

    public static void setVariable(String name, PythonObject value) {
        PythonGIL.assertThreadSafe();
        PyObject main = org.bytedeco.cpython.global.python.PyImport_ImportModule((String)"__main__");
        PyObject globals = org.bytedeco.cpython.global.python.PyModule_GetDict((PyObject)main);
        org.bytedeco.cpython.global.python.PyDict_SetItemString((PyObject)globals, (String)name, (PyObject)value.getNativePythonObject());
        org.bytedeco.cpython.global.python.Py_DecRef((PyObject)main);
    }

    public static void setVariables(List<PythonVariable> pyVars) {
        for (PythonVariable pyVar : pyVars) {
            PythonExecutioner.setVariable(pyVar.getName(), pyVar.getPythonObject());
        }
    }

    public static void setVariables(PythonVariable ... pyVars) {
        PythonExecutioner.setVariables(Arrays.asList(pyVars));
    }

    public static void getVariables(List<PythonVariable> pyVars) {
        for (PythonVariable pyVar : pyVars) {
            pyVar.setValue(PythonExecutioner.getVariable(pyVar.getName(), pyVar.getType()).getValue());
        }
    }

    public static void getVariables(PythonVariable ... pyVars) {
        PythonExecutioner.getVariables(Arrays.asList(pyVars));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonObject getVariable(String name) {
        PythonGIL.assertThreadSafe();
        PyObject main = org.bytedeco.cpython.global.python.PyImport_ImportModule((String)"__main__");
        PyObject globals = org.bytedeco.cpython.global.python.PyModule_GetDict((PyObject)main);
        PyObject pyName = org.bytedeco.cpython.global.python.PyUnicode_FromString((String)name);
        try {
            if (org.bytedeco.cpython.global.python.PyDict_Contains((PyObject)globals, (PyObject)pyName) == 1) {
                PythonObject pythonObject = new PythonObject(org.bytedeco.cpython.global.python.PyObject_GetItem((PyObject)globals, (PyObject)pyName), false);
                return pythonObject;
            }
        }
        finally {
            org.bytedeco.cpython.global.python.Py_DecRef((PyObject)main);
            org.bytedeco.cpython.global.python.Py_DecRef((PyObject)pyName);
        }
        return new PythonObject(null);
    }

    public static <T> PythonVariable<T> getVariable(String name, PythonType<T> type) {
        PythonObject val = PythonExecutioner.getVariable(name);
        return new PythonVariable<T>(name, type, type.toJava(val));
    }

    public static synchronized void simpleExec(String code) {
        PythonGIL.assertThreadSafe();
        int result = org.bytedeco.cpython.global.python.PyRun_SimpleStringFlags((String)code, null);
        if (result != 0) {
            throw new PythonException("Execution failed, unable to retrieve python exception.");
        }
    }

    private static void throwIfExecutionFailed() {
        PythonObject ex = PythonExecutioner.getVariable(PYTHON_EXCEPTION_KEY);
        if (ex != null && !ex.isNone() && !ex.toString().isEmpty()) {
            PythonExecutioner.setVariable(PYTHON_EXCEPTION_KEY, PythonTypes.STR.toPython(""));
            throw new PythonException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getWrappedCode(String code) {
        ClassPathResource resource = new ClassPathResource("org/nd4j/python4j/pythonexec/pythonexec.py");
        try (InputStream is = resource.getInputStream();){
            String out;
            String base = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String indentedCode = "    " + code.replace("\n", "\n    ");
            String string = out = base.replace("    pass", indentedCode);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read python code!", e);
        }
    }

    public static void exec(String code) {
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        PythonExecutioner.throwIfExecutionFailed();
    }

    public static void exec(String code, List<PythonVariable> inputs, List<PythonVariable> outputs) {
        if (inputs != null) {
            PythonExecutioner.setVariables(inputs.toArray(new PythonVariable[0]));
        }
        PythonExecutioner.exec(code);
        if (outputs != null) {
            PythonExecutioner.getVariables(outputs.toArray(new PythonVariable[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonVariables getAllVariables() {
        PythonGIL.assertThreadSafe();
        PythonVariables ret = new PythonVariables(new PythonVariable[0]);
        PyObject main = org.bytedeco.cpython.global.python.PyImport_ImportModule((String)"__main__");
        PyObject globals = org.bytedeco.cpython.global.python.PyModule_GetDict((PyObject)main);
        PyObject keys = org.bytedeco.cpython.global.python.PyDict_Keys((PyObject)globals);
        PyObject keysIter = org.bytedeco.cpython.global.python.PyObject_GetIter((PyObject)keys);
        try {
            long n = org.bytedeco.cpython.global.python.PyObject_Size((PyObject)globals);
            int i = 0;
            while ((long)i < n) {
                block10: {
                    PyObject pyKey = org.bytedeco.cpython.global.python.PyIter_Next((PyObject)keysIter);
                    try {
                        PythonType pt;
                        if (new PythonObject(pyKey, false).toString().startsWith("_")) break block10;
                        PyObject pyVal = org.bytedeco.cpython.global.python.PyObject_GetItem((PyObject)globals, (PyObject)pyKey);
                        try {
                            pt = PythonTypes.getPythonTypeForPythonObject(new PythonObject(pyVal, false));
                        }
                        catch (PythonException pe) {
                            pt = null;
                        }
                        if (pt != null) {
                            ret.add(new PythonVariable(new PythonObject(pyKey, false).toString(), pt, pt.toJava(new PythonObject(pyVal, false))));
                        }
                    }
                    finally {
                        org.bytedeco.cpython.global.python.Py_DecRef((PyObject)pyKey);
                    }
                }
                ++i;
            }
        }
        finally {
            org.bytedeco.cpython.global.python.Py_DecRef((PyObject)keysIter);
            org.bytedeco.cpython.global.python.Py_DecRef((PyObject)keys);
            org.bytedeco.cpython.global.python.Py_DecRef((PyObject)main);
            return ret;
        }
    }

    public static PythonVariables execAndReturnAllVariables(String code, List<PythonVariable> inputs) {
        PythonExecutioner.setVariables(inputs);
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        return PythonExecutioner.getAllVariables();
    }

    public static PythonVariables execAndReturnAllVariables(String code) {
        PythonExecutioner.simpleExec(PythonExecutioner.getWrappedCode(code));
        return PythonExecutioner.getAllVariables();
    }

    private static synchronized void initPythonPath() {
        try {
            String path = System.getProperty(DEFAULT_PYTHON_PATH_PROPERTY);
            ArrayList<File> packagesList = new ArrayList<File>();
            packagesList.addAll(Arrays.asList(PythonExecutioner.cachePackages()));
            for (PythonType type : PythonTypes.get()) {
                packagesList.addAll(Arrays.asList(type.packages()));
            }
            packagesList.add(new File(org.bytedeco.cpython.global.python.cachePackage(), "site-packages"));
            File[] packages = packagesList.toArray(new File[0]);
            if (path == null) {
                python.Py_SetPath((File[])packages);
            } else {
                StringBuffer sb = new StringBuffer();
                JavaCppPathType pathAppendValue = JavaCppPathType.valueOf(System.getProperty(JAVACPP_PYTHON_APPEND_TYPE, DEFAULT_APPEND_TYPE).toUpperCase());
                switch (pathAppendValue) {
                    case BEFORE: {
                        for (File cacheDir : packages) {
                            sb.append(cacheDir);
                            sb.append(File.pathSeparator);
                        }
                        sb.append(path);
                        break;
                    }
                    case AFTER: {
                        sb.append(path);
                        for (File cacheDir : packages) {
                            sb.append(cacheDir);
                            sb.append(File.pathSeparator);
                        }
                        break;
                    }
                    case NONE: {
                        sb.append(path);
                    }
                }
                python.Py_SetPath((String[])new String[]{sb.toString()});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File[] cachePackages() throws IOException {
        File[] path = org.bytedeco.cpython.global.python.cachePackages();
        path = Arrays.copyOf(path, path.length + 1);
        path[path.length - 1] = org.bytedeco.cpython.global.python.cachePackage();
        return path;
    }

    static {
        PythonExecutioner.init();
    }

    private static enum JavaCppPathType {
        BEFORE,
        AFTER,
        NONE;

    }
}

