/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nd4j.python4j.Python;
import org.nd4j.python4j.PythonException;
import org.nd4j.python4j.PythonExecutioner;
import org.nd4j.python4j.PythonGC;
import org.nd4j.python4j.PythonObject;

public class PythonContextManager {
    private static Set<String> contexts = new HashSet<String>();
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static String currentContext;
    private static final String MAIN_CONTEXT = "main";
    private static final String COLLAPSED_KEY = "__collapsed__";

    private static void init() {
        if (init.get()) {
            return;
        }
        new PythonExecutioner();
        init.set(true);
        currentContext = MAIN_CONTEXT;
        contexts.add(currentContext);
    }

    public static void addContext(String contextName) {
        if (!PythonContextManager.validateContextName(contextName)) {
            throw new PythonException("Invalid context name: " + contextName);
        }
        contexts.add(contextName);
    }

    public static boolean hasContext(String contextName) {
        return contexts.contains(contextName);
    }

    private static boolean validateContextName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.toLowerCase().charAt(i);
            if (i == 0 && c >= '0' && c <= '9') {
                return false;
            }
            if (c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static String getContextPrefix(String contextName) {
        return COLLAPSED_KEY + contextName + "__";
    }

    private static String getCollapsedVarNameForContext(String varName, String contextName) {
        return PythonContextManager.getContextPrefix(contextName) + varName;
    }

    private static String expandCollapsedVarName(String varName, String contextName) {
        String prefix = COLLAPSED_KEY + contextName + "__";
        return varName.substring(prefix.length());
    }

    private static void collapseContext(String contextName) {
        try (PythonGC _ = PythonGC.watch();){
            PythonObject globals = Python.globals();
            PythonObject pop = globals.attr("pop");
            PythonObject keysF = globals.attr("keys");
            PythonObject keys = keysF.call(new Object[0]);
            PythonObject keysList = Python.list(keys);
            int numKeys = Python.len(keysList).toInt();
            for (int i = 0; i < numKeys; ++i) {
                PythonObject key = keysList.get(i);
                String keyStr = key.toString();
                if (keyStr.startsWith("__") && keyStr.endsWith("__") || keyStr.startsWith("__collapsed_")) continue;
                String collapsedKey = PythonContextManager.getCollapsedVarNameForContext(keyStr, contextName);
                PythonObject val = pop.call(key);
                PythonObject pyNewKey = new PythonObject(collapsedKey);
                globals.set(pyNewKey, val);
            }
        }
        catch (Exception pe) {
            throw new RuntimeException(pe);
        }
    }

    private static void expandContext(String contextName) {
        try (PythonGC _ = PythonGC.watch();){
            String prefix = PythonContextManager.getContextPrefix(contextName);
            PythonObject globals = Python.globals();
            PythonObject pop = globals.attr("pop");
            PythonObject keysF = globals.attr("keys");
            PythonObject keys = keysF.call(new Object[0]);
            PythonObject keysList = Python.list(keys);
            try (PythonGC __ = PythonGC.pause();){
                int numKeys = Python.len(keysList).toInt();
                for (int i = 0; i < numKeys; ++i) {
                    PythonObject key = keysList.get(i);
                    String keyStr = key.toString();
                    if (!keyStr.startsWith(prefix)) continue;
                    String expandedKey = PythonContextManager.expandCollapsedVarName(keyStr, contextName);
                    PythonObject val = pop.call(key);
                    PythonObject newKey = new PythonObject(expandedKey);
                    globals.set(newKey, val);
                }
            }
        }
    }

    public static void setContext(String contextName) {
        if (contextName.equals(currentContext)) {
            return;
        }
        if (!PythonContextManager.hasContext(contextName)) {
            PythonContextManager.addContext(contextName);
        }
        PythonContextManager.collapseContext(currentContext);
        PythonContextManager.expandContext(contextName);
        currentContext = contextName;
    }

    public static void setMainContext() {
        PythonContextManager.setContext(MAIN_CONTEXT);
    }

    public static String getCurrentContext() {
        return currentContext;
    }

    public static void reset() {
        String tempContext = "___temp__context___";
        String currContext = currentContext;
        PythonContextManager.setContext(tempContext);
        PythonContextManager.deleteContext(currContext);
        PythonContextManager.setContext(currContext);
        PythonContextManager.deleteContext(tempContext);
    }

    public static void deleteContext(String contextName) {
        if (contextName.equals(currentContext)) {
            throw new PythonException("Cannot delete current context!");
        }
        if (!contexts.contains(contextName)) {
            return;
        }
        String prefix = PythonContextManager.getContextPrefix(contextName);
        PythonObject globals = Python.globals();
        PythonObject keysList = Python.list(globals.attr("keys").call(new Object[0]));
        int numKeys = Python.len(keysList).toInt();
        for (int i = 0; i < numKeys; ++i) {
            PythonObject key = keysList.get(i);
            String keyStr = key.toString();
            if (!keyStr.startsWith(prefix)) continue;
            globals.attr("__delitem__").call(key);
        }
        contexts.remove(contextName);
    }

    public static void deleteNonMainContexts() {
        PythonContextManager.setContext(MAIN_CONTEXT);
        for (String c : contexts.toArray(new String[0])) {
            if (c.equals(MAIN_CONTEXT)) continue;
            PythonContextManager.deleteContext(c);
        }
    }

    public String[] getContexts() {
        return contexts.toArray(new String[0]);
    }

    static {
        PythonContextManager.init();
    }

    public static class Context
    implements Closeable {
        private final String name;
        private final String previous;
        private final boolean temp;

        public Context() {
            this.name = "temp_" + UUID.randomUUID().toString().replace("-", "_");
            this.temp = true;
            this.previous = PythonContextManager.getCurrentContext();
            PythonContextManager.setContext(this.name);
        }

        public Context(String name) {
            this.name = name;
            this.temp = false;
            this.previous = PythonContextManager.getCurrentContext();
            PythonContextManager.setContext(name);
        }

        @Override
        public void close() {
            PythonContextManager.setContext(this.previous);
            if (this.temp) {
                PythonContextManager.deleteContext(this.name);
            }
        }
    }
}

