/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.python4j;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import org.bytedeco.cpython.PyObject;
import org.bytedeco.cpython.global.python;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.python4j.Python;
import org.nd4j.python4j.PythonObject;

public class PythonGC
implements Closeable {
    private PythonGC previousFrame = null;
    private boolean active = true;
    private static PythonGC currentFrame = new PythonGC();
    private Set<PyObject> objects = new HashSet<PyObject>();

    private boolean alreadyRegistered(PyObject pyObject) {
        if (this.objects.contains(pyObject)) {
            return true;
        }
        if (this.previousFrame == null) {
            return false;
        }
        return this.previousFrame.alreadyRegistered(pyObject);
    }

    private void addObject(PythonObject pythonObject) {
        if (!this.active) {
            return;
        }
        if (Pointer.isNull((Pointer)pythonObject.getNativePythonObject())) {
            return;
        }
        if (this.alreadyRegistered(pythonObject.getNativePythonObject())) {
            return;
        }
        this.objects.add(pythonObject.getNativePythonObject());
    }

    public static void register(PythonObject pythonObject) {
        currentFrame.addObject(pythonObject);
    }

    public static void keep(PythonObject pythonObject) {
        PythonGC.currentFrame.objects.remove(pythonObject.getNativePythonObject());
        if (PythonGC.currentFrame.previousFrame != null) {
            PythonGC.currentFrame.previousFrame.addObject(pythonObject);
        }
    }

    private PythonGC() {
    }

    public static PythonGC watch() {
        PythonGC ret = new PythonGC();
        ret.previousFrame = currentFrame;
        ret.active = PythonGC.currentFrame.active;
        currentFrame = ret;
        return ret;
    }

    private void collect() {
        for (PyObject pyObject : this.objects) {
            if (pyObject.equals((Object)Python.globals().getNativePythonObject())) continue;
            python.Py_DecRef((PyObject)pyObject);
        }
        this.objects = new HashSet<PyObject>();
    }

    @Override
    public void close() {
        if (this.active) {
            this.collect();
        }
        currentFrame = this.previousFrame;
    }

    public static boolean isWatching() {
        if (!PythonGC.currentFrame.active) {
            return false;
        }
        return PythonGC.currentFrame.previousFrame != null;
    }

    public static PythonGC pause() {
        PythonGC pausedFrame = new PythonGC();
        pausedFrame.active = false;
        pausedFrame.previousFrame = currentFrame;
        currentFrame = pausedFrame;
        return pausedFrame;
    }

    public static void resume() {
        if (PythonGC.currentFrame.active) {
            throw new RuntimeException("GC not paused!");
        }
        currentFrame = PythonGC.currentFrame.previousFrame;
    }
}

