/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.tensorflow.conversion.graphrunner;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.tensorflow.TF_Graph;
import org.bytedeco.tensorflow.TF_Operation;
import org.bytedeco.tensorflow.TF_Output;
import org.bytedeco.tensorflow.TF_Session;
import org.bytedeco.tensorflow.TF_SessionOptions;
import org.bytedeco.tensorflow.TF_Status;
import org.bytedeco.tensorflow.TF_Tensor;
import org.bytedeco.tensorflow.global.tensorflow;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.io.ClassPathResource;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.protobuf.ByteString;
import org.nd4j.shade.protobuf.InvalidProtocolBufferException;
import org.nd4j.shade.protobuf.Message;
import org.nd4j.shade.protobuf.MessageOrBuilder;
import org.nd4j.shade.protobuf.util.JsonFormat;
import org.nd4j.tensorflow.conversion.TensorDataType;
import org.nd4j.tensorflow.conversion.TensorflowConversion;
import org.nd4j.tensorflow.conversion.graphrunner.SavedModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.ConfigProto;
import org.tensorflow.framework.GPUOptions;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class GraphRunner
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(GraphRunner.class);
    private static boolean isTfWarmedUp = false;
    private static boolean isTfWarmingUp = false;
    private SavedModelConfig savedModelConfig;
    private TF_Graph graph;
    private TensorflowConversion conversion = TensorflowConversion.getInstance();
    private TF_Session session;
    private TF_SessionOptions options;
    private TF_Status status;
    private List<String> inputOrder;
    private List<String> outputOrder;
    private ConfigProto sessionOptionsConfigProto;
    private Map<String, TensorDataType> inputDataTypes;
    private Map<String, TensorDataType> outputDataTypes;
    private static Map<Pair<TensorDataType, TensorDataType>, GraphRunner> recastGraphDefs = new ConcurrentHashMap<Pair<TensorDataType, TensorDataType>, GraphRunner>();

    public GraphRunner(List<String> inputNames, List<String> outputNames, SavedModelConfig savedModelConfig, ConfigProto sessionOptionsConfigProto, byte[] sessionOptionsProtoBytes, File sessionOptionsProtoPath, TF_Graph graph, File graphPath, byte[] graphBytes, Map<String, TensorDataType> inputDataTypes, Map<String, TensorDataType> outputDataTypes) {
        try {
            if (sessionOptionsConfigProto == null) {
                if (sessionOptionsConfigProto != null) {
                    this.sessionOptionsConfigProto = ConfigProto.parseFrom((byte[])sessionOptionsProtoBytes);
                } else if (sessionOptionsProtoPath != null) {
                    byte[] load = FileUtils.readFileToByteArray((File)sessionOptionsProtoPath);
                    this.sessionOptionsConfigProto = ConfigProto.parseFrom((byte[])load);
                }
            } else {
                this.sessionOptionsConfigProto = sessionOptionsConfigProto;
            }
            this.inputDataTypes = inputDataTypes;
            this.outputDataTypes = outputDataTypes;
            this.inputOrder = inputNames;
            this.outputOrder = outputNames;
            this.initOptionsIfNeeded();
            if (graph != null) {
                this.graph = graph;
            } else if (graphBytes != null) {
                this.graph = this.conversion.loadGraph(graphBytes, this.status);
            } else if (graphPath != null) {
                graphBytes = IOUtils.toByteArray((URI)graphPath.toURI());
                this.graph = this.conversion.loadGraph(graphBytes, this.status);
            } else {
                this.graph = tensorflow.TF_NewGraph();
            }
            if (savedModelConfig != null) {
                this.savedModelConfig = savedModelConfig;
                LinkedHashMap<String, String> inputsMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> outputsMap = new LinkedHashMap<String, String>();
                this.session = this.conversion.loadSavedModel(savedModelConfig, this.options, null, this.graph, inputsMap, outputsMap, this.status);
                if (this.inputOrder == null || this.inputOrder.isEmpty()) {
                    this.inputOrder = new ArrayList(inputsMap.values());
                }
                if (this.outputOrder == null || this.outputOrder.isEmpty()) {
                    this.outputOrder = new ArrayList(outputsMap.values());
                }
                savedModelConfig.setSavedModelInputOrder(new ArrayList<String>(inputsMap.values()));
                savedModelConfig.setSaveModelOutputOrder(new ArrayList<String>(outputsMap.values()));
                log.info("Loaded input names from saved model configuration " + this.inputOrder);
                log.info("Loaded output names from saved model configuration " + this.outputOrder);
            }
            this.initSessionAndStatusIfNeeded(graphBytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse protobuf", e);
        }
    }

    public Map<String, TF_Tensor> recastInputs(Map<String, TF_Tensor> inputs) {
        return this.recastInputs(inputs, this.inputOrder, this.inputDataTypes);
    }

    public Map<String, TF_Tensor> recastOutputs(Map<String, TF_Tensor> inputs) {
        return this.recastInputs(inputs, this.outputOrder, this.outputDataTypes);
    }

    public Map<String, TF_Tensor> recastInputs(Map<String, TF_Tensor> inputs, List<String> inputOrder, Map<String, TensorDataType> inputDataTypes) {
        if (inputDataTypes == null || inputDataTypes.isEmpty()) {
            inputDataTypes = new LinkedHashMap<String, TensorDataType>();
            for (int i = 0; i < inputOrder.size(); ++i) {
                TensorDataType tensorDataType = TensorDataType.values()[tensorflow.TF_TensorType((TF_Tensor)inputs.get(inputOrder.get(i)))];
                Preconditions.checkNotNull((Object)((Object)tensorDataType), (String)("Data type of " + tensorflow.TF_TensorType((TF_Tensor)inputs.get(inputOrder.get(i))) + " was null!"));
                inputDataTypes.put(inputOrder.get(i), tensorDataType);
            }
        }
        HashMap<String, TF_Tensor> ret = new HashMap<String, TF_Tensor>();
        for (int i = 0; i < inputOrder.size(); ++i) {
            TF_Tensor currInput = inputs.get(inputOrder.get(i));
            TensorDataType fromDType = TensorDataType.values()[tensorflow.TF_TensorType((TF_Tensor)currInput)];
            if (fromDType != inputDataTypes.get(inputOrder.get(i))) {
                TF_Tensor oldTensor = currInput;
                currInput = GraphRunner.castTensor(currInput, fromDType, inputDataTypes.get(inputOrder.get(i)));
                tensorflow.TF_DeleteTensor((TF_Tensor)oldTensor);
            }
            ret.put(inputOrder.get(i), currInput);
        }
        return ret;
    }

    public Map<String, TF_Tensor> runTfTensor(Map<String, TF_Tensor> inputs) {
        HashMap<String, TF_Operation> opsByName;
        LinkedHashMap<String, TF_Tensor> outputArrays;
        if (this.graph == null) {
            throw new IllegalStateException("Graph not initialized.");
        }
        if (inputs.size() != this.inputOrder.size()) {
            throw new IllegalArgumentException("Number of inputs specified do not match number of arrays specified.");
        }
        if (this.inputDataTypes == null) {
            this.inputDataTypes = new LinkedHashMap<String, TensorDataType>();
            for (int i = 0; i < this.inputOrder.size(); ++i) {
                this.inputDataTypes.put(this.inputOrder.get(i), TensorDataType.values()[tensorflow.TF_TensorType((TF_Tensor)inputs.get(this.inputOrder.get(i)))]);
            }
        }
        for (Map.Entry<String, TF_Tensor> entry : inputs.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getValue(), (String)("Entry " + entry.getKey() + " was null!"));
        }
        inputs = this.recastInputs(inputs);
        if (this.savedModelConfig != null) {
            outputArrays = new LinkedHashMap<String, TF_Tensor>();
            opsByName = new HashMap<String, TF_Operation>();
            TF_Output inputOut = new TF_Output((long)this.savedModelConfig.getSavedModelInputOrder().size());
            TF_Tensor[] inputTensors = new TF_Tensor[this.savedModelConfig.getSavedModelInputOrder().size()];
            for (int i = 0; i < this.savedModelConfig.getSavedModelInputOrder().size(); ++i) {
                TF_Tensor tfTensor;
                String[] name = this.savedModelConfig.getSavedModelInputOrder().get(i).split(":");
                TF_Operation inputOp = tensorflow.TF_GraphOperationByName((TF_Graph)this.graph, (String)name[0]);
                opsByName.put(this.savedModelConfig.getSavedModelInputOrder().get(i), inputOp);
                inputOut.position((long)i).oper(inputOp).index(name.length > 1 ? Integer.parseInt(name[1]) : 0);
                inputTensors[i] = tfTensor = inputs.get(this.inputOrder != null && !this.inputOrder.isEmpty() ? this.inputOrder.get(i) : this.savedModelConfig.getSavedModelInputOrder().get(i));
            }
            inputOut.position(0L);
            TF_Output outputOut = new TF_Output((long)this.savedModelConfig.getSaveModelOutputOrder().size());
            for (int i = 0; i < this.savedModelConfig.getSaveModelOutputOrder().size(); ++i) {
                String[] name = this.savedModelConfig.getSaveModelOutputOrder().get(i).split(":");
                TF_Operation outputOp = tensorflow.TF_GraphOperationByName((TF_Graph)this.graph, (String)name[0]);
                opsByName.put(this.savedModelConfig.getSaveModelOutputOrder().get(i), outputOp);
                outputOut.position((long)i).oper(outputOp).index(name.length > 1 ? Integer.parseInt(name[1]) : 0);
            }
            outputOut.position(0L);
            PointerPointer inputTensorsPointer = new PointerPointer((Pointer[])inputTensors);
            PointerPointer outputTensorsPointer = new PointerPointer((long)this.savedModelConfig.getSaveModelOutputOrder().size());
            long start = System.nanoTime();
            tensorflow.TF_SessionRun((TF_Session)this.session, null, (TF_Output)inputOut, (PointerPointer)inputTensorsPointer, (int)inputTensors.length, (TF_Output)outputOut, (PointerPointer)outputTensorsPointer, (int)this.savedModelConfig.getSaveModelOutputOrder().size(), null, (int)0, null, (TF_Status)this.status);
            long end = System.nanoTime();
            long diff = TimeUnit.NANOSECONDS.toMillis(end - start);
            log.debug("Session runtime: {} ms", (Object)diff);
            if (tensorflow.TF_GetCode((TF_Status)this.status) != 0) {
                throw new IllegalStateException("ERROR: Unable to run session " + tensorflow.TF_Message((TF_Status)this.status).getString());
            }
            for (int i = 0; i < this.outputOrder.size(); ++i) {
                outputArrays.put(this.outputOrder != null && !this.outputOrder.isEmpty() ? this.outputOrder.get(i) : this.savedModelConfig.getSaveModelOutputOrder().get(i), new TF_Tensor(outputTensorsPointer.get((long)i)));
            }
            return outputArrays;
        }
        outputArrays = new LinkedHashMap();
        opsByName = new HashMap();
        TF_Output inputOut = new TF_Output((long)this.inputOrder.size());
        TF_Tensor[] inputTensors = new TF_Tensor[this.inputOrder.size()];
        for (int i = 0; i < this.inputOrder.size(); ++i) {
            TF_Tensor tf_tensor;
            String[] name = this.inputOrder.get(i).split(":");
            TF_Operation inputOp = tensorflow.TF_GraphOperationByName((TF_Graph)this.graph, (String)name[0]);
            opsByName.put(this.inputOrder.get(i), inputOp);
            inputOut.position((long)i).oper(inputOp).index(name.length > 1 ? Integer.parseInt(name[1]) : 0);
            inputTensors[i] = tf_tensor = inputs.get(this.inputOrder.get(i));
        }
        inputOut.position(0L);
        TF_Output outputOut = new TF_Output((long)this.outputOrder.size());
        for (int i = 0; i < this.outputOrder.size(); ++i) {
            String[] name = this.outputOrder.get(i).split(":");
            TF_Operation outputOp = tensorflow.TF_GraphOperationByName((TF_Graph)this.graph, (String)name[0]);
            if (outputOp == null) {
                throw new IllegalArgumentException("Illegal output found " + this.outputOrder.get(i) + " - no op found! Mis specified name perhaps?");
            }
            opsByName.put(this.outputOrder.get(i), outputOp);
            outputOut.position((long)i).oper(outputOp).index(name.length > 1 ? Integer.parseInt(name[1]) : 0);
        }
        outputOut.position(0L);
        PointerPointer inputTensorsPointer = new PointerPointer((Pointer[])inputTensors);
        PointerPointer outputTensorsPointer = new PointerPointer((long)this.outputOrder.size());
        long start = System.nanoTime();
        tensorflow.TF_SessionRun((TF_Session)this.session, null, (TF_Output)inputOut, (PointerPointer)inputTensorsPointer, (int)this.inputOrder.size(), (TF_Output)outputOut, (PointerPointer)outputTensorsPointer, (int)this.outputOrder.size(), null, (int)0, null, (TF_Status)this.status);
        long end = System.nanoTime();
        long diff = TimeUnit.NANOSECONDS.toMillis(end - start);
        log.debug("Session runtime: {} ms", (Object)diff);
        if (tensorflow.TF_GetCode((TF_Status)this.status) != 0) {
            throw new IllegalStateException("ERROR: Unable to run session " + tensorflow.TF_Message((TF_Status)this.status).getString());
        }
        for (int i = 0; i < this.outputOrder.size(); ++i) {
            outputArrays.put(this.outputOrder.get(i), new TF_Tensor(outputTensorsPointer.get((long)i)));
        }
        return outputArrays;
    }

    public Map<String, INDArray> run(Map<String, INDArray> inputs) {
        if (!isTfWarmedUp && !isTfWarmingUp) {
            isTfWarmingUp = true;
            this.run(inputs);
            isTfWarmedUp = true;
        }
        LinkedHashMap<String, TF_Tensor> inputTensors = new LinkedHashMap<String, TF_Tensor>();
        for (Map.Entry<String, INDArray> input : inputs.entrySet()) {
            inputTensors.put(input.getKey(), this.conversion.tensorFromNDArray(input.getValue()));
        }
        Map<String, TF_Tensor> outputTensors = this.runTfTensor(inputTensors);
        LinkedHashMap<String, INDArray> output = new LinkedHashMap<String, INDArray>();
        for (Map.Entry<String, TF_Tensor> outputTensor : outputTensors.entrySet()) {
            output.put(outputTensor.getKey(), this.conversion.ndArrayFromTensor(outputTensor.getValue()));
        }
        return output;
    }

    private void initOptionsIfNeeded() {
        if (this.status == null) {
            this.status = tensorflow.TF_NewStatus();
        }
        if (this.options == null) {
            this.options = tensorflow.TF_NewSessionOptions();
            if (this.sessionOptionsConfigProto != null) {
                BytePointer bytePointer = new BytePointer(this.sessionOptionsConfigProto.toByteArray());
                tensorflow.TF_SetConfig((TF_SessionOptions)this.options, (Pointer)bytePointer, (long)bytePointer.getStringBytes().length, (TF_Status)this.status);
                if (tensorflow.TF_GetCode((TF_Status)this.status) != 0) {
                    throw new IllegalStateException("ERROR: Unable to set value configuration:" + tensorflow.TF_Message((TF_Status)this.status).getString());
                }
            }
        }
    }

    private void initSessionAndStatusIfNeeded(GraphDef graphDef1) {
        int i;
        LinkedHashSet<String> seenAsInput = new LinkedHashSet<String>();
        for (i = 0; i < graphDef1.getNodeCount(); ++i) {
            NodeDef node = graphDef1.getNode(i);
            for (int input = 0; input < node.getInputCount(); ++input) {
                seenAsInput.add(node.getInput(input));
            }
        }
        if (this.outputOrder == null) {
            this.outputOrder = new ArrayList<String>();
            log.trace("Attempting to automatically resolve tensorflow output names..");
            for (i = 0; i < graphDef1.getNodeCount(); ++i) {
                if (seenAsInput.contains(graphDef1.getNode(i).getName()) || graphDef1.getNode(i).getOp().equals("Placeholder")) continue;
                this.outputOrder.add(graphDef1.getNode(i).getName());
            }
            if (this.outputOrder.size() > 1) {
                HashSet<String> remove = new HashSet<String>();
                for (String name : this.outputOrder) {
                    if (!name.contains("/")) continue;
                    remove.add(name);
                }
                this.outputOrder.removeAll(remove);
            }
        }
        if (this.session == null) {
            this.initOptionsIfNeeded();
            this.session = tensorflow.TF_NewSession((TF_Graph)this.graph, (TF_SessionOptions)this.options, (TF_Status)this.status);
            if (tensorflow.TF_GetCode((TF_Status)this.status) != 0) {
                throw new IllegalStateException("ERROR: Unable to open session " + tensorflow.TF_Message((TF_Status)this.status).getString());
            }
        }
    }

    private void initSessionAndStatusIfNeeded(byte[] graphToUse) {
        if (graphToUse == null) {
            return;
        }
        try {
            GraphDef graphDef1 = GraphDef.parseFrom((byte[])graphToUse);
            this.initSessionAndStatusIfNeeded(graphDef1);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("", (Throwable)e);
        }
    }

    public static ConfigProto fromJson(String json) {
        ConfigProto.Builder builder = ConfigProto.newBuilder();
        try {
            JsonFormat.parser().merge(json, (Message.Builder)builder);
            ConfigProto build = builder.build();
            ByteString serialized = build.toByteString();
            byte[] binaryString = serialized.toByteArray();
            ConfigProto configProto = ConfigProto.parseFrom((byte[])binaryString);
            return configProto;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static TF_Tensor castTensor(TF_Tensor input, TensorDataType from, TensorDataType to) {
        if (from.equals((Object)to)) {
            return input;
        }
        HashMap<String, TF_Tensor> inputMap = new HashMap<String, TF_Tensor>();
        inputMap.put("input", input);
        GraphRunner graphRunner = GraphRunner.getRunner(from, to);
        try {
            Map<String, TF_Tensor> output = graphRunner.runTfTensor(inputMap);
            return output.get("cast_output");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to run graph", e);
        }
    }

    private static GraphRunner getRunner(TensorDataType from, TensorDataType to) {
        Pair key = Pair.of((Object)((Object)from), (Object)((Object)to));
        if (!recastGraphDefs.containsKey(key)) {
            byte[] graphForDataType = GraphRunner.graphForDataType(from, to);
            GraphRunner graphRunner = GraphRunner.builder().graphBytes(graphForDataType).inputNames(Arrays.asList("input")).outputNames(Arrays.asList("cast_output")).build();
            recastGraphDefs.put((Pair<TensorDataType, TensorDataType>)key, graphRunner);
            return graphRunner;
        }
        return recastGraphDefs.get(key);
    }

    private static byte[] graphForDataType(TensorDataType from, TensorDataType to) {
        ClassPathResource classPathResource = new ClassPathResource("cast_graph/cast_" + TensorDataType.toPythonName(from) + "_" + TensorDataType.toPythonName(to) + ".pb");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (InputStream is = classPathResource.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read graph " + classPathResource.getFilename(), e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String sessionOptionsToJson() {
        if (this.sessionOptionsConfigProto == null) {
            return null;
        }
        try {
            return JsonFormat.printer().print((MessageOrBuilder)this.sessionOptionsConfigProto);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.session != null && this.status != null) {
            tensorflow.TF_CloseSession((TF_Session)this.session, (TF_Status)this.status);
            tensorflow.TF_DeleteSession((TF_Session)this.session, (TF_Status)this.status);
        }
        if (this.status != null && tensorflow.TF_GetCode((TF_Status)this.status) != 0) {
            throw new IllegalStateException("ERROR: Unable to delete session " + tensorflow.TF_Message((TF_Status)this.status).getString());
        }
        if (this.status != null) {
            tensorflow.TF_DeleteStatus((TF_Status)this.status);
        }
    }

    public static ConfigProto getAlignedWithNd4j() {
        ConfigProto configProto = ConfigProto.getDefaultInstance();
        ConfigProto.Builder builder1 = configProto.toBuilder().addDeviceFilters(TensorflowConversion.defaultDeviceForThread());
        try {
            if (Nd4j.getBackend().getClass().getName().toLowerCase().contains("jcu")) {
                builder1.setGpuOptions(GPUOptions.newBuilder().setAllowGrowth(true).setPerProcessGpuMemoryFraction(0.5).build());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return builder1.build();
    }

    public static GraphRunnerBuilder builder() {
        return new GraphRunnerBuilder();
    }

    public GraphRunner() {
    }

    public List<String> getInputOrder() {
        return this.inputOrder;
    }

    public List<String> getOutputOrder() {
        return this.outputOrder;
    }

    public void setInputOrder(List<String> inputOrder) {
        this.inputOrder = inputOrder;
    }

    public void setOutputOrder(List<String> outputOrder) {
        this.outputOrder = outputOrder;
    }

    public ConfigProto getSessionOptionsConfigProto() {
        return this.sessionOptionsConfigProto;
    }

    public Map<String, TensorDataType> getInputDataTypes() {
        return this.inputDataTypes;
    }

    public Map<String, TensorDataType> getOutputDataTypes() {
        return this.outputDataTypes;
    }

    public void setInputDataTypes(Map<String, TensorDataType> inputDataTypes) {
        this.inputDataTypes = inputDataTypes;
    }

    public void setOutputDataTypes(Map<String, TensorDataType> outputDataTypes) {
        this.outputDataTypes = outputDataTypes;
    }

    public static class GraphRunnerBuilder {
        private List<String> inputNames;
        private List<String> outputNames;
        private SavedModelConfig savedModelConfig;
        private ConfigProto sessionOptionsConfigProto;
        private byte[] sessionOptionsProtoBytes;
        private File sessionOptionsProtoPath;
        private TF_Graph graph;
        private File graphPath;
        private byte[] graphBytes;
        private Map<String, TensorDataType> inputDataTypes;
        private Map<String, TensorDataType> outputDataTypes;

        GraphRunnerBuilder() {
        }

        public GraphRunnerBuilder inputNames(List<String> inputNames) {
            this.inputNames = inputNames;
            return this;
        }

        public GraphRunnerBuilder outputNames(List<String> outputNames) {
            this.outputNames = outputNames;
            return this;
        }

        public GraphRunnerBuilder savedModelConfig(SavedModelConfig savedModelConfig) {
            this.savedModelConfig = savedModelConfig;
            return this;
        }

        public GraphRunnerBuilder sessionOptionsConfigProto(ConfigProto sessionOptionsConfigProto) {
            this.sessionOptionsConfigProto = sessionOptionsConfigProto;
            return this;
        }

        public GraphRunnerBuilder sessionOptionsProtoBytes(byte[] sessionOptionsProtoBytes) {
            this.sessionOptionsProtoBytes = sessionOptionsProtoBytes;
            return this;
        }

        public GraphRunnerBuilder sessionOptionsProtoPath(File sessionOptionsProtoPath) {
            this.sessionOptionsProtoPath = sessionOptionsProtoPath;
            return this;
        }

        public GraphRunnerBuilder graph(TF_Graph graph) {
            this.graph = graph;
            return this;
        }

        public GraphRunnerBuilder graphPath(File graphPath) {
            this.graphPath = graphPath;
            return this;
        }

        public GraphRunnerBuilder graphBytes(byte[] graphBytes) {
            this.graphBytes = graphBytes;
            return this;
        }

        public GraphRunnerBuilder inputDataTypes(Map<String, TensorDataType> inputDataTypes) {
            this.inputDataTypes = inputDataTypes;
            return this;
        }

        public GraphRunnerBuilder outputDataTypes(Map<String, TensorDataType> outputDataTypes) {
            this.outputDataTypes = outputDataTypes;
            return this;
        }

        public GraphRunner build() {
            return new GraphRunner(this.inputNames, this.outputNames, this.savedModelConfig, this.sessionOptionsConfigProto, this.sessionOptionsProtoBytes, this.sessionOptionsProtoPath, this.graph, this.graphPath, this.graphBytes, this.inputDataTypes, this.outputDataTypes);
        }

        public String toString() {
            return "GraphRunner.GraphRunnerBuilder(inputNames=" + this.inputNames + ", outputNames=" + this.outputNames + ", savedModelConfig=" + this.savedModelConfig + ", sessionOptionsConfigProto=" + this.sessionOptionsConfigProto + ", sessionOptionsProtoBytes=" + Arrays.toString(this.sessionOptionsProtoBytes) + ", sessionOptionsProtoPath=" + this.sessionOptionsProtoPath + ", graph=" + this.graph + ", graphPath=" + this.graphPath + ", graphBytes=" + Arrays.toString(this.graphBytes) + ", inputDataTypes=" + this.inputDataTypes + ", outputDataTypes=" + this.outputDataTypes + ")";
        }
    }
}

