/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.tensorflowlite.runner;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.tensorflowlite.BuiltinOpResolver;
import org.bytedeco.tensorflowlite.FlatBufferModel;
import org.bytedeco.tensorflowlite.Interpreter;
import org.bytedeco.tensorflowlite.InterpreterBuilder;
import org.bytedeco.tensorflowlite.OpResolver;
import org.bytedeco.tensorflowlite.TfLiteTensor;
import org.bytedeco.tensorflowlite.global.tensorflowlite;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.tensorflowlite.util.TFLiteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorFlowLiteRunner
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TensorFlowLiteRunner.class);
    private FlatBufferModel model;
    private BuiltinOpResolver resolver;
    private InterpreterBuilder builder;
    private Interpreter interpreter;

    public TensorFlowLiteRunner(String modelUri) {
        this.model = FlatBufferModel.BuildFromFile((String)modelUri);
        if (this.model == null || this.model.isNull()) {
            throw new RuntimeException("Cannot load " + modelUri);
        }
        this.model.retainReference();
        this.resolver = new BuiltinOpResolver();
        this.builder = new InterpreterBuilder(this.model, (OpResolver)this.resolver);
        this.interpreter = new Interpreter((Pointer)null);
        this.builder.apply(this.interpreter);
        if (this.interpreter == null || this.interpreter.isNull()) {
            throw new RuntimeException("Cannot build interpreter for " + modelUri);
        }
        this.resolver.retainReference();
        this.builder.retainReference();
        this.interpreter.retainReference();
        if (this.interpreter.AllocateTensors() != 0) {
            throw new RuntimeException("Cannot allocate tensors for " + modelUri);
        }
        if (log.isInfoEnabled()) {
            log.info("=== Pre-invoke Interpreter State ===");
            tensorflowlite.PrintInterpreterState((Interpreter)this.interpreter);
        }
    }

    @Override
    public void close() {
        if (this.interpreter != null) {
            this.interpreter.releaseReference();
        }
        if (this.builder != null) {
            this.builder.releaseReference();
        }
        if (this.resolver != null) {
            this.resolver.releaseReference();
        }
        if (this.model != null) {
            this.model.releaseReference();
        }
    }

    public Map<String, INDArray> exec(Map<String, INDArray> input) {
        long numInputNodes = this.interpreter.inputs().capacity();
        long numOutputNodes = this.interpreter.outputs().capacity();
        int i = 0;
        while ((long)i < numInputNodes) {
            BytePointer inputName = this.interpreter.GetInputName(i);
            INDArray arr = input.get(inputName.getString());
            TfLiteTensor inputTensor = this.interpreter.input_tensor((long)i);
            Preconditions.checkState((inputTensor != null ? 1 : 0) != 0, (String)"Input must be a tensor.");
            Nd4j.copy((INDArray)arr, (INDArray)TFLiteUtils.getArray(inputTensor));
            ++i;
        }
        if (this.interpreter.Invoke() != 0) {
            throw new RuntimeException("Cannot invoke interpreter for " + this.model);
        }
        if (log.isInfoEnabled()) {
            log.info("=== Post-invoke Interpreter State ===");
            tensorflowlite.PrintInterpreterState((Interpreter)this.interpreter);
        }
        LinkedHashMap<String, INDArray> ret = new LinkedHashMap<String, INDArray>();
        int i2 = 0;
        while ((long)i2 < numOutputNodes) {
            TfLiteTensor outputTensor = this.interpreter.output_tensor((long)i2);
            ret.put(this.interpreter.GetOutputName(i2).getString(), TFLiteUtils.getArray(outputTensor));
            ++i2;
        }
        return ret;
    }

    public static TensorFlowLiteRunnerBuilder builder() {
        return new TensorFlowLiteRunnerBuilder();
    }

    public static class TensorFlowLiteRunnerBuilder {
        private String modelUri;

        TensorFlowLiteRunnerBuilder() {
        }

        public TensorFlowLiteRunnerBuilder modelUri(String modelUri) {
            this.modelUri = modelUri;
            return this;
        }

        public TensorFlowLiteRunner build() {
            return new TensorFlowLiteRunner(this.modelUri);
        }

        public String toString() {
            return "TensorFlowLiteRunner.TensorFlowLiteRunnerBuilder(modelUri=" + this.modelUri + ")";
        }
    }
}

