/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.tensorflowlite.util;

import org.bytedeco.javacpp.BoolPointer;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.tensorflowlite.TfLiteIntArray;
import org.bytedeco.tensorflowlite.TfLiteTensor;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class TFLiteUtils {
    public static DataType dataTypeForTfliteType(int dataType) {
        switch (dataType) {
            case 1: {
                return DataType.FLOAT;
            }
            case 2: {
                return DataType.INT32;
            }
            case 3: {
                return DataType.UINT8;
            }
            case 4: {
                return DataType.INT64;
            }
            case 5: {
                return DataType.UTF8;
            }
            case 6: {
                return DataType.BOOL;
            }
            case 7: {
                return DataType.INT16;
            }
            case 9: {
                return DataType.INT8;
            }
            case 10: {
                return DataType.FLOAT16;
            }
            case 11: {
                return DataType.DOUBLE;
            }
            case 13: {
                return DataType.UINT64;
            }
            case 16: {
                return DataType.UINT32;
            }
        }
        throw new IllegalArgumentException("Illegal data type " + dataType);
    }

    public static int tfliteTypeForDataType(DataType dataType) {
        switch (dataType) {
            case DOUBLE: {
                return 11;
            }
            case FLOAT: {
                return 1;
            }
            case HALF: {
                return 10;
            }
            case LONG: {
                return 4;
            }
            case INT: {
                return 2;
            }
            case SHORT: {
                return 7;
            }
            case UBYTE: {
                return 3;
            }
            case BYTE: {
                return 9;
            }
            case BOOL: {
                return 6;
            }
            case UTF8: {
                return 5;
            }
            case UINT32: {
                return 16;
            }
            case UINT64: {
                return 13;
            }
        }
        throw new IllegalArgumentException("Illegal data type " + dataType);
    }

    public static INDArray getArray(TfLiteTensor value) {
        long[] shapeConvert;
        DataType dataType = TFLiteUtils.dataTypeForTfliteType(value.type());
        TfLiteIntArray shape = value.dims();
        if (shape != null) {
            shapeConvert = new long[shape.size()];
            for (int i = 0; i < shapeConvert.length; ++i) {
                shapeConvert[i] = shape.data(i);
            }
        } else {
            shapeConvert = new long[]{1L};
        }
        DataBuffer getBuffer = TFLiteUtils.getDataBuffer(value);
        Preconditions.checkState((boolean)dataType.equals((Object)getBuffer.dataType()), (String)"Data type must be equivalent as specified by the tflite metadata.");
        return Nd4j.create((DataBuffer)getBuffer, (long[])shapeConvert, (long[])Nd4j.getStrides((long[])shapeConvert), (long)0L);
    }

    public static DataBuffer getDataBuffer(TfLiteTensor tens) {
        DataBuffer buffer = null;
        int type = tens.type();
        long size = tens.bytes();
        Pointer data = tens.data().data();
        switch (type) {
            case 1: {
                FloatPointer pFloat = new FloatPointer(data).capacity(size / 4L);
                FloatIndexer floatIndexer = FloatIndexer.create((FloatPointer)pFloat);
                buffer = Nd4j.createBuffer((Pointer)pFloat, (DataType)DataType.FLOAT, (long)(size / 4L), (Indexer)floatIndexer);
                break;
            }
            case 2: {
                IntPointer pInt32 = new IntPointer(data).capacity(size / 4L);
                IntIndexer int32Indexer = IntIndexer.create((IntPointer)pInt32);
                buffer = Nd4j.createBuffer((Pointer)pInt32, (DataType)DataType.INT32, (long)(size / 4L), (Indexer)int32Indexer);
                break;
            }
            case 3: {
                BytePointer pUint8 = new BytePointer(data).capacity(size);
                ByteIndexer uint8Indexer = ByteIndexer.create((BytePointer)pUint8);
                buffer = Nd4j.createBuffer((Pointer)pUint8, (DataType)DataType.UINT8, (long)size, (Indexer)uint8Indexer);
                break;
            }
            case 4: {
                LongPointer pInt64 = new LongPointer(data).capacity(size / 8L);
                LongIndexer int64Indexer = LongIndexer.create((LongPointer)pInt64);
                buffer = Nd4j.createBuffer((Pointer)pInt64, (DataType)DataType.INT64, (long)(size / 8L), (Indexer)int64Indexer);
                break;
            }
            case 5: {
                BytePointer pString = new BytePointer(data).capacity(size);
                ByteIndexer stringIndexer = ByteIndexer.create((BytePointer)pString);
                buffer = Nd4j.createBuffer((Pointer)pString, (DataType)DataType.INT8, (long)size, (Indexer)stringIndexer);
                break;
            }
            case 6: {
                BoolPointer pBool = new BoolPointer(data).capacity(size);
                BooleanIndexer boolIndexer = BooleanIndexer.create((BooleanPointer)new BooleanPointer((Pointer)pBool));
                buffer = Nd4j.createBuffer((Pointer)pBool, (DataType)DataType.BOOL, (long)size, (Indexer)boolIndexer);
                break;
            }
            case 7: {
                ShortPointer pInt16 = new ShortPointer(data).capacity(size / 2L);
                ShortIndexer int16Indexer = ShortIndexer.create((ShortPointer)pInt16);
                buffer = Nd4j.createBuffer((Pointer)pInt16, (DataType)DataType.INT16, (long)(size / 2L), (Indexer)int16Indexer);
                break;
            }
            case 9: {
                BytePointer pInt8 = new BytePointer(data).capacity(size);
                ByteIndexer int8Indexer = ByteIndexer.create((BytePointer)pInt8);
                buffer = Nd4j.createBuffer((Pointer)pInt8, (DataType)DataType.UINT8, (long)size, (Indexer)int8Indexer);
                break;
            }
            case 10: {
                ShortPointer pFloat16 = new ShortPointer(data).capacity(size / 2L);
                ShortIndexer float16Indexer = ShortIndexer.create((ShortPointer)pFloat16);
                buffer = Nd4j.createBuffer((Pointer)pFloat16, (DataType)DataType.FLOAT16, (long)(size / 2L), (Indexer)float16Indexer);
                break;
            }
            case 11: {
                DoublePointer pDouble = new DoublePointer(data).capacity(size / 8L);
                DoubleIndexer doubleIndexer = DoubleIndexer.create((DoublePointer)pDouble);
                buffer = Nd4j.createBuffer((Pointer)pDouble, (DataType)DataType.DOUBLE, (long)(size / 8L), (Indexer)doubleIndexer);
                break;
            }
            case 13: {
                LongPointer pUint64 = new LongPointer(data).capacity(size / 8L);
                LongIndexer uint64Indexer = LongIndexer.create((LongPointer)pUint64);
                buffer = Nd4j.createBuffer((Pointer)pUint64, (DataType)DataType.UINT64, (long)(size / 8L), (Indexer)uint64Indexer);
                break;
            }
            case 16: {
                IntPointer pUint32 = new IntPointer(data).capacity(size / 4L);
                IntIndexer uint32Indexer = IntIndexer.create((IntPointer)pUint32);
                buffer = Nd4j.createBuffer((Pointer)pUint32, (DataType)DataType.UINT32, (long)(size / 4L), (Indexer)uint32Indexer);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type encountered");
            }
        }
        return buffer;
    }
}

