/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.messages.history;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nd4j.parameterserver.distributed.v2.messages.MessagesHistoryHolder;

public class HashHistoryHolder<T>
implements MessagesHistoryHolder<T> {
    protected final Set<T> set;

    public HashHistoryHolder(final int tailLength) {
        this.set = Collections.newSetFromMap(new LinkedHashMap<T, Boolean>(tailLength){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, Boolean> eldest) {
                return this.size() > tailLength;
            }
        });
    }

    @Override
    public synchronized boolean storeIfUnknownMessageId(T id) {
        if (!this.isKnownMessageId(id)) {
            this.set.add(id);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isKnownMessageId(T id) {
        return this.set.contains(id);
    }
}

