/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SubscriberState
implements Serializable,
Comparable<SubscriberState> {
    private boolean isMaster;
    private String serverState;
    private int totalUpdates;
    private int streamId;
    private String connectionInfo;
    private Map<String, Number> parameterUpdaterStatus;
    private boolean isAsync;
    private boolean isReady;

    public static SubscriberState empty() {
        ConcurrentHashMap<String, Number> map = new ConcurrentHashMap<String, Number>();
        return SubscriberState.builder().serverState("empty").streamId(-1).parameterUpdaterStatus(map).totalUpdates(-1).isMaster(false).build();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.isMaster);
        dataOutput.writeUTF(this.serverState);
        dataOutput.writeInt(this.totalUpdates);
        dataOutput.writeInt(this.streamId);
    }

    public static SubscriberState read(DataInput dataInput) throws IOException {
        return SubscriberState.builder().isMaster(dataInput.readBoolean()).serverState(dataInput.readUTF()).totalUpdates(dataInput.readInt()).streamId(dataInput.readInt()).build();
    }

    public String serverType() {
        return this.isMaster ? "master" : "slave";
    }

    @Override
    public int compareTo(SubscriberState o) {
        return Integer.compare(this.streamId, o.streamId);
    }

    public static SubscriberStateBuilder builder() {
        return new SubscriberStateBuilder();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public String getServerState() {
        return this.serverState;
    }

    public int getTotalUpdates() {
        return this.totalUpdates;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public String getConnectionInfo() {
        return this.connectionInfo;
    }

    public Map<String, Number> getParameterUpdaterStatus() {
        return this.parameterUpdaterStatus;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public void setServerState(String serverState) {
        this.serverState = serverState;
    }

    public void setTotalUpdates(int totalUpdates) {
        this.totalUpdates = totalUpdates;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setConnectionInfo(String connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void setParameterUpdaterStatus(Map<String, Number> parameterUpdaterStatus) {
        this.parameterUpdaterStatus = parameterUpdaterStatus;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriberState)) {
            return false;
        }
        SubscriberState other = (SubscriberState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        if (this.getTotalUpdates() != other.getTotalUpdates()) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isReady() != other.isReady()) {
            return false;
        }
        String this$serverState = this.getServerState();
        String other$serverState = other.getServerState();
        if (this$serverState == null ? other$serverState != null : !this$serverState.equals(other$serverState)) {
            return false;
        }
        String this$connectionInfo = this.getConnectionInfo();
        String other$connectionInfo = other.getConnectionInfo();
        if (this$connectionInfo == null ? other$connectionInfo != null : !this$connectionInfo.equals(other$connectionInfo)) {
            return false;
        }
        Map<String, Number> this$parameterUpdaterStatus = this.getParameterUpdaterStatus();
        Map<String, Number> other$parameterUpdaterStatus = other.getParameterUpdaterStatus();
        return !(this$parameterUpdaterStatus == null ? other$parameterUpdaterStatus != null : !((Object)this$parameterUpdaterStatus).equals(other$parameterUpdaterStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriberState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMaster() ? 79 : 97);
        result = result * 59 + this.getTotalUpdates();
        result = result * 59 + this.getStreamId();
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isReady() ? 79 : 97);
        String $serverState = this.getServerState();
        result = result * 59 + ($serverState == null ? 43 : $serverState.hashCode());
        String $connectionInfo = this.getConnectionInfo();
        result = result * 59 + ($connectionInfo == null ? 43 : $connectionInfo.hashCode());
        Map<String, Number> $parameterUpdaterStatus = this.getParameterUpdaterStatus();
        result = result * 59 + ($parameterUpdaterStatus == null ? 43 : ((Object)$parameterUpdaterStatus).hashCode());
        return result;
    }

    public String toString() {
        return "SubscriberState(isMaster=" + this.isMaster() + ", serverState=" + this.getServerState() + ", totalUpdates=" + this.getTotalUpdates() + ", streamId=" + this.getStreamId() + ", connectionInfo=" + this.getConnectionInfo() + ", parameterUpdaterStatus=" + this.getParameterUpdaterStatus() + ", isAsync=" + this.isAsync() + ", isReady=" + this.isReady() + ")";
    }

    public SubscriberState() {
    }

    public SubscriberState(boolean isMaster, String serverState, int totalUpdates, int streamId, String connectionInfo, Map<String, Number> parameterUpdaterStatus, boolean isAsync, boolean isReady) {
        this.isMaster = isMaster;
        this.serverState = serverState;
        this.totalUpdates = totalUpdates;
        this.streamId = streamId;
        this.connectionInfo = connectionInfo;
        this.parameterUpdaterStatus = parameterUpdaterStatus;
        this.isAsync = isAsync;
        this.isReady = isReady;
    }

    public static class SubscriberStateBuilder {
        private boolean isMaster;
        private String serverState;
        private int totalUpdates;
        private int streamId;
        private String connectionInfo;
        private Map<String, Number> parameterUpdaterStatus;
        private boolean isAsync;
        private boolean isReady;

        SubscriberStateBuilder() {
        }

        public SubscriberStateBuilder isMaster(boolean isMaster) {
            this.isMaster = isMaster;
            return this;
        }

        public SubscriberStateBuilder serverState(String serverState) {
            this.serverState = serverState;
            return this;
        }

        public SubscriberStateBuilder totalUpdates(int totalUpdates) {
            this.totalUpdates = totalUpdates;
            return this;
        }

        public SubscriberStateBuilder streamId(int streamId) {
            this.streamId = streamId;
            return this;
        }

        public SubscriberStateBuilder connectionInfo(String connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public SubscriberStateBuilder parameterUpdaterStatus(Map<String, Number> parameterUpdaterStatus) {
            this.parameterUpdaterStatus = parameterUpdaterStatus;
            return this;
        }

        public SubscriberStateBuilder isAsync(boolean isAsync) {
            this.isAsync = isAsync;
            return this;
        }

        public SubscriberStateBuilder isReady(boolean isReady) {
            this.isReady = isReady;
            return this;
        }

        public SubscriberState build() {
            return new SubscriberState(this.isMaster, this.serverState, this.totalUpdates, this.streamId, this.connectionInfo, this.parameterUpdaterStatus, this.isAsync, this.isReady);
        }

        public String toString() {
            return "SubscriberState.SubscriberStateBuilder(isMaster=" + this.isMaster + ", serverState=" + this.serverState + ", totalUpdates=" + this.totalUpdates + ", streamId=" + this.streamId + ", connectionInfo=" + this.connectionInfo + ", parameterUpdaterStatus=" + this.parameterUpdaterStatus + ", isAsync=" + this.isAsync + ", isReady=" + this.isReady + ")";
        }
    }
}

