// Targeted by JavaCPP version 1.4.3: DO NOT EDIT THIS FILE

package org.nd4j.nativeblas;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class Nd4jCpu extends org.nd4j.nativeblas.Nd4jCpuPresets {
    static { Loader.load(); }

    Class[] floatOps = {
        float_Switch.class,
        float_While.class,
        float_Scope.class,
        float_Conditional.class,
        float_Return.class,
        float_expose.class,
        float_sigmoid.class,
        float_sigmoid_bp.class,
        float_softsign.class,
        float_softsign_bp.class,
        float_tanh.class,
        float_tanh_bp.class,
        float_softplus.class,
        float_softplus_bp.class,
        float_relu.class,
        float_relu_bp.class,
        float_selu.class,
        float_selu_bp.class,
        float_lrelu.class,
        float_lrelu_bp.class,
        float_elu.class,
        float_elu_bp.class,
        float_cube.class,
        float_cube_bp.class,
        float_rectifiedtanh.class,
        float_rectifiedtanh_bp.class,
        float_rationaltanh.class,
        float_rationaltanh_bp.class,
        float_hardtanh.class,
        float_hardtanh_bp.class,
        float_hardsigmoid.class,
        float_hardsigmoid_bp.class,
        float_identity.class,
        float_identity_bp.class,
        float_crelu.class,
        float_crelu_bp.class,
        float_relu6.class,
        float_relu6_bp.class,
        float_relu_layer.class,
        float_prelu.class,
        float_prelu_bp.class,
        float_thresholdedrelu.class,
        float_thresholdedrelu_bp.class,
        float_toggle_bits.class,
        float_matmul.class,
        float_tensormmul.class,
        float_axpy.class,
        float_batched_gemm.class,
        float_svd.class,
        float_lt_scalar.class,
        float_gt_scalar.class,
        float_lte_scalar.class,
        float_gte_scalar.class,
        float_eq_scalar.class,
        float_neq_scalar.class,
        float_Where.class,
        float_where_np.class,
        float_select.class,
        float_choose.class,
        float_is_non_decreasing.class,
        float_is_strictly_increasing.class,
        float_is_numeric_tensor.class,
        float_maximum.class,
        float_maximum_bp.class,
        float_minimum.class,
        float_minimum_bp.class,
        float_add.class,
        float_add_bp.class,
        float_subtract.class,
        float_subtract_bp.class,
        float_reversesubtract.class,
        float_reversesubtract_bp.class,
        float_reversemod.class,
        float_reversemod_bp.class,
        float_squaredsubtract.class,
        float_squaredsubtract_bp.class,
        float_multiply.class,
        float_multiply_bp.class,
        float_divide.class,
        float_divide_bp.class,
        float_reversedivide.class,
        float_reversedivide_bp.class,
        float_floormod.class,
        float_floormod_bp.class,
        float_mod.class,
        float_mod_bp.class,
        float_floordiv.class,
        float_floordiv_bp.class,
        float_realdiv.class,
        float_realdiv_bp.class,
        float_truncatediv.class,
        float_assign.class,
        float_assign_bp.class,
        float_meshgrid.class,
        float_equals.class,
        float_not_equals.class,
        float_less_equal.class,
        float_greater_equal.class,
        float_less.class,
        float_greater.class,
        float_boolean_and.class,
        float_boolean_or.class,
        float_boolean_xor.class,
        float_boolean_not.class,
        float_percentile.class,
        float_tf_atan2.class,
        float_conv1d.class,
        float_conv1d_bp.class,
        float_conv2d.class,
        float_conv2d_bp.class,
        float_conv2d_input_bp.class,
        float_sconv2d.class,
        float_sconv2d_bp.class,
        float_deconv2d.class,
        float_deconv2d_bp.class,
        float_deconv3d.class,
        float_deconv3d_bp.class,
        float_maxpool2d.class,
        float_maxpool2d_bp.class,
        float_avgpool2d.class,
        float_avgpool2d_bp.class,
        float_pnormpool2d.class,
        float_pnormpool2d_bp.class,
        float_maxpool3d.class,
        float_maxpool3d_bp.class,
        float_avgpool3d.class,
        float_avgpool3d_bp.class,
        float_fullconv3d.class,
        float_fullconv3d_bp.class,
        float_fullconv3d_grad.class,
        float_pooling2d.class,
        float_im2col.class,
        float_im2col_bp.class,
        float_col2im.class,
        float_upsampling2d.class,
        float_upsampling2d_bp.class,
        float_upsampling3d.class,
        float_upsampling3d_bp.class,
        float_conv3d.class,
        float_conv3d_bp.class,
        float_ismax.class,
        float_dilation2d.class,
        float_conv3dnew.class,
        float_conv3dnew_bp.class,
        float_avgpool3dnew.class,
        float_avgpool3dnew_bp.class,
        float_maxpool3dnew.class,
        float_maxpool3dnew_bp.class,
        float_max_pool_with_argmax.class,
        float_depthwise_conv2d.class,
        float_depthwise_conv2d_bp.class,
        float_pointwise_conv2d.class,
        float_deconv2d_tf.class,
        float_to_double.class,
        float_to_float16.class,
        float_to_float32.class,
        float_to_int32.class,
        float_to_int64.class,
        float_to_uint32.class,
        float_to_uint64.class,
        float_cast.class,
        float_write_list.class,
        float_stack_list.class,
        float_read_list.class,
        float_pick_list.class,
        float_size_list.class,
        float_create_list.class,
        float_scatter_list.class,
        float_split_list.class,
        float_gather_list.class,
        float_clone_list.class,
        float_unstack_list.class,
        float_hinge_loss.class,
        float_huber_loss.class,
        float_log_loss.class,
        float_mean_pairwssqerr_loss.class,
        float_mean_sqerr_loss.class,
        float_sigm_cross_entropy_loss.class,
        float_softmax_cross_entropy_loss.class,
        float_absolute_difference_loss.class,
        float_cosine_distance_loss.class,
        float_softmax_cross_entropy_loss_with_logits.class,
        float_sparse_softmax_cross_entropy_loss_with_logits.class,
        float_softmax.class,
        float_softmax_bp.class,
        float_lrn_old.class,
        float_lrn.class,
        float_lrn_bp.class,
        float_batchnorm.class,
        float_batchnorm_new.class,
        float_batchnorm_bp.class,
        float_apply_sgd.class,
        float_fused_batch_norm.class,
        float_log_softmax.class,
        float_log_softmax_bp.class,
        float_argmax.class,
        float_argmin.class,
        float_norm.class,
        float_matrix_set_diag.class,
        float_matrix_diag.class,
        float_betainc.class,
        float_biasadd.class,
        float_biasadd_bp.class,
        float_diag.class,
        float_diag_part.class,
        float_matrix_diag_part.class,
        float_listdiff.class,
        float_scatter_add.class,
        float_scatter_sub.class,
        float_scatter_mul.class,
        float_scatter_div.class,
        float_scatter_upd.class,
        float_scatter_max.class,
        float_scatter_min.class,
        float_scatter_nd.class,
        float_scatter_nd_update.class,
        float_scatter_nd_add.class,
        float_scatter_nd_sub.class,
        float_fill_as.class,
        float_rint.class,
        float_unique.class,
        float_unique_with_counts.class,
        float_tear.class,
        float_unstack.class,
        float_strided_slice.class,
        float_strided_slice_bp.class,
        float_slice.class,
        float_slice_bp.class,
        float_range.class,
        float_onehot.class,
        float_confusion_matrix.class,
        float_stack.class,
        float_size.class,
        float_rank.class,
        float_broadcastgradientargs.class,
        float_zeros_as.class,
        float_ones_as.class,
        float_square.class,
        float_zeta.class,
        float_polygamma.class,
        float_fill.class,
        float_split_v.class,
        float_split.class,
        float_adjust_hue.class,
        float_adjust_saturation.class,
        float_depth_to_space.class,
        float_space_to_depth.class,
        float_cross.class,
        float_space_to_batch.class,
        float_batch_to_space.class,
        float_top_k.class,
        float_in_top_k.class,
        float_moments.class,
        float_embedding_lookup.class,
        float_dynamic_partition.class,
        float_dynamic_partition_bp.class,
        float_dynamic_stitch.class,
        float_zero_fraction.class,
        float_xw_plus_b.class,
        float_stop_gradient.class,
        float_l2_loss.class,
        float_parallel_stack.class,
        float_log_poison_loss.class,
        float_normalize_moments.class,
        float_sufficient_statistics.class,
        float_weighted_cross_entropy_with_logits.class,
        float_dropout.class,
        float_bincount.class,
        float_broadcast_dynamic_shape.class,
        float_matrix_determinant.class,
        float_matrix_inverse.class,
        float_sequence_mask.class,
        float_segment_max.class,
        float_segment_max_bp.class,
        float_segment_min.class,
        float_segment_min_bp.class,
        float_segment_sum.class,
        float_segment_sum_bp.class,
        float_segment_prod.class,
        float_segment_prod_bp.class,
        float_segment_mean.class,
        float_segment_mean_bp.class,
        float_unsorted_segment_max.class,
        float_unsorted_segment_max_bp.class,
        float_unsorted_segment_min.class,
        float_unsorted_segment_min_bp.class,
        float_unsorted_segment_sum.class,
        float_unsorted_segment_sum_bp.class,
        float_unsorted_segment_prod.class,
        float_unsorted_segment_prod_bp.class,
        float_unsorted_segment_mean.class,
        float_unsorted_segment_mean_bp.class,
        float_unsorted_segment_sqrt_n.class,
        float_unsorted_segment_sqrt_n_bp.class,
        float_extract_image_patches.class,
        float_roll.class,
        float_reduce_sum.class,
        float_reduce_sum_bp.class,
        float_reduce_prod.class,
        float_reduce_prod_bp.class,
        float_reduce_min.class,
        float_reduce_min_bp.class,
        float_reduce_max.class,
        float_reduce_max_bp.class,
        float_reduce_norm1.class,
        float_reduce_norm1_bp.class,
        float_reduce_norm2.class,
        float_reduce_norm2_bp.class,
        float_reduce_sqnorm.class,
        float_reduce_sqnorm_bp.class,
        float_reduce_norm_max.class,
        float_reduce_norm_max_bp.class,
        float_reduce_mean.class,
        float_reduce_mean_bp.class,
        float_reduce_variance.class,
        float_reduce_variance_bp.class,
        float_reduce_stdev.class,
        float_reduce_stdev_bp.class,
        float_reduce_dot_bp.class,
        float_matrix_band_part.class,
        float_set_seed.class,
        float_get_seed.class,
        float_randomuniform.class,
        float_random_normal.class,
        float_random_bernoulli.class,
        float_random_exponential.class,
        float_random_crop.class,
        float_sru_old.class,
        float_sru.class,
        float_sru_logic.class,
        float_sru_bi.class,
        float_sru_bp.class,
        float_sru_bp_logic.class,
        float_sru_bi_bp.class,
        float_lstmCell.class,
        float_sruCell.class,
        float_gruCell.class,
        float_gruCell_bp.class,
        float_lstm.class,
        float_gru.class,
        float_static_rnn.class,
        float_dynamic_rnn.class,
        float_static_bidirectional_rnn.class,
        float_dynamic_bidirectional_rnn.class,
        float_permute.class,
        float_reshapeas.class,
        float_transpose.class,
        float_shape_of.class,
        float_shapes_of.class,
        float_squeeze.class,
        float_expand_dims.class,
        float_reshape.class,
        float_size_at.class,
        float_order.class,
        float_tile_to_shape.class,
        float_tile_to_shape_bp.class,
        float_broadcast_to.class,
        float_test_output_reshape.class,
        float_test_scalar.class,
        float_testreduction.class,
        float_noop.class,
        float_testop2i2o.class,
        float_testcustom.class,
        float_firas_sparse.class,
        float_clipbyvalue.class,
        float_clipbynorm.class,
        float_clipbynorm_bp.class,
        float_clipbyavgnorm.class,
        float_cumsum.class,
        float_cumprod.class,
        float_tile.class,
        float_tile_bp.class,
        float_repeat.class,
        float_invert_permutation.class,
        float_concat.class,
        float_concat_bp.class,
        float_mergemax.class,
        float_mergemaxindex.class,
        float_mergeadd.class,
        float_mergeavg.class,
        float_scatter_update.class,
        float_Floor.class,
        float_Log1p.class,
        float_reverse.class,
        float_reverse_bp.class,
        float_gather.class,
        float_pad.class,
        float_eye.class,
        float_gather_nd.class,
        float_reverse_sequence.class,
        float_trace.class,
        float_random_shuffle.class,
        float_clip_by_global_norm.class,
        float_tri.class,
        float_triu.class,
        float_triu_bp.class,
        float_mirror_pad.class,
        float_cumsum_bp.class,
        float_cumprod_bp.class,
        float_histogram_fixed_width.class,};
    Class[] halfOps = {
        half_Switch.class,
        half_While.class,
        half_Scope.class,
        half_Conditional.class,
        half_Return.class,
        half_expose.class,
        half_sigmoid.class,
        half_sigmoid_bp.class,
        half_softsign.class,
        half_softsign_bp.class,
        half_tanh.class,
        half_tanh_bp.class,
        half_softplus.class,
        half_softplus_bp.class,
        half_relu.class,
        half_relu_bp.class,
        half_selu.class,
        half_selu_bp.class,
        half_lrelu.class,
        half_lrelu_bp.class,
        half_elu.class,
        half_elu_bp.class,
        half_cube.class,
        half_cube_bp.class,
        half_rectifiedtanh.class,
        half_rectifiedtanh_bp.class,
        half_rationaltanh.class,
        half_rationaltanh_bp.class,
        half_hardtanh.class,
        half_hardtanh_bp.class,
        half_hardsigmoid.class,
        half_hardsigmoid_bp.class,
        half_identity.class,
        half_identity_bp.class,
        half_crelu.class,
        half_crelu_bp.class,
        half_relu6.class,
        half_relu6_bp.class,
        half_relu_layer.class,
        half_prelu.class,
        half_prelu_bp.class,
        half_thresholdedrelu.class,
        half_thresholdedrelu_bp.class,
        half_toggle_bits.class,
        half_matmul.class,
        half_tensormmul.class,
        half_axpy.class,
        half_batched_gemm.class,
        half_svd.class,
        half_lt_scalar.class,
        half_gt_scalar.class,
        half_lte_scalar.class,
        half_gte_scalar.class,
        half_eq_scalar.class,
        half_neq_scalar.class,
        half_Where.class,
        half_where_np.class,
        half_select.class,
        half_choose.class,
        half_is_non_decreasing.class,
        half_is_strictly_increasing.class,
        half_is_numeric_tensor.class,
        half_maximum.class,
        half_maximum_bp.class,
        half_minimum.class,
        half_minimum_bp.class,
        half_add.class,
        half_add_bp.class,
        half_subtract.class,
        half_subtract_bp.class,
        half_reversesubtract.class,
        half_reversesubtract_bp.class,
        half_reversemod.class,
        half_reversemod_bp.class,
        half_squaredsubtract.class,
        half_squaredsubtract_bp.class,
        half_multiply.class,
        half_multiply_bp.class,
        half_divide.class,
        half_divide_bp.class,
        half_reversedivide.class,
        half_reversedivide_bp.class,
        half_floormod.class,
        half_floormod_bp.class,
        half_mod.class,
        half_mod_bp.class,
        half_floordiv.class,
        half_floordiv_bp.class,
        half_realdiv.class,
        half_realdiv_bp.class,
        half_truncatediv.class,
        half_assign.class,
        half_assign_bp.class,
        half_meshgrid.class,
        half_equals.class,
        half_not_equals.class,
        half_less_equal.class,
        half_greater_equal.class,
        half_less.class,
        half_greater.class,
        half_boolean_and.class,
        half_boolean_or.class,
        half_boolean_xor.class,
        half_boolean_not.class,
        half_percentile.class,
        half_tf_atan2.class,
        half_conv1d.class,
        half_conv1d_bp.class,
        half_conv2d.class,
        half_conv2d_bp.class,
        half_conv2d_input_bp.class,
        half_sconv2d.class,
        half_sconv2d_bp.class,
        half_deconv2d.class,
        half_deconv2d_bp.class,
        half_deconv3d.class,
        half_deconv3d_bp.class,
        half_maxpool2d.class,
        half_maxpool2d_bp.class,
        half_avgpool2d.class,
        half_avgpool2d_bp.class,
        half_pnormpool2d.class,
        half_pnormpool2d_bp.class,
        half_maxpool3d.class,
        half_maxpool3d_bp.class,
        half_avgpool3d.class,
        half_avgpool3d_bp.class,
        half_fullconv3d.class,
        half_fullconv3d_bp.class,
        half_fullconv3d_grad.class,
        half_pooling2d.class,
        half_im2col.class,
        half_im2col_bp.class,
        half_col2im.class,
        half_upsampling2d.class,
        half_upsampling2d_bp.class,
        half_upsampling3d.class,
        half_upsampling3d_bp.class,
        half_conv3d.class,
        half_conv3d_bp.class,
        half_ismax.class,
        half_dilation2d.class,
        half_conv3dnew.class,
        half_conv3dnew_bp.class,
        half_avgpool3dnew.class,
        half_avgpool3dnew_bp.class,
        half_maxpool3dnew.class,
        half_maxpool3dnew_bp.class,
        half_max_pool_with_argmax.class,
        half_depthwise_conv2d.class,
        half_depthwise_conv2d_bp.class,
        half_pointwise_conv2d.class,
        half_deconv2d_tf.class,
        half_to_double.class,
        half_to_float16.class,
        half_to_float32.class,
        half_to_int32.class,
        half_to_int64.class,
        half_to_uint32.class,
        half_to_uint64.class,
        half_cast.class,
        half_write_list.class,
        half_stack_list.class,
        half_read_list.class,
        half_pick_list.class,
        half_size_list.class,
        half_create_list.class,
        half_scatter_list.class,
        half_split_list.class,
        half_gather_list.class,
        half_clone_list.class,
        half_unstack_list.class,
        half_hinge_loss.class,
        half_huber_loss.class,
        half_log_loss.class,
        half_mean_pairwssqerr_loss.class,
        half_mean_sqerr_loss.class,
        half_sigm_cross_entropy_loss.class,
        half_softmax_cross_entropy_loss.class,
        half_absolute_difference_loss.class,
        half_cosine_distance_loss.class,
        half_softmax_cross_entropy_loss_with_logits.class,
        half_sparse_softmax_cross_entropy_loss_with_logits.class,
        half_softmax.class,
        half_softmax_bp.class,
        half_lrn_old.class,
        half_lrn.class,
        half_lrn_bp.class,
        half_batchnorm.class,
        half_batchnorm_new.class,
        half_batchnorm_bp.class,
        half_apply_sgd.class,
        half_fused_batch_norm.class,
        half_log_softmax.class,
        half_log_softmax_bp.class,
        half_argmax.class,
        half_argmin.class,
        half_norm.class,
        half_matrix_set_diag.class,
        half_matrix_diag.class,
        half_betainc.class,
        half_biasadd.class,
        half_biasadd_bp.class,
        half_diag.class,
        half_diag_part.class,
        half_matrix_diag_part.class,
        half_listdiff.class,
        half_scatter_add.class,
        half_scatter_sub.class,
        half_scatter_mul.class,
        half_scatter_div.class,
        half_scatter_upd.class,
        half_scatter_max.class,
        half_scatter_min.class,
        half_scatter_nd.class,
        half_scatter_nd_update.class,
        half_scatter_nd_add.class,
        half_scatter_nd_sub.class,
        half_fill_as.class,
        half_rint.class,
        half_unique.class,
        half_unique_with_counts.class,
        half_tear.class,
        half_unstack.class,
        half_strided_slice.class,
        half_strided_slice_bp.class,
        half_slice.class,
        half_slice_bp.class,
        half_range.class,
        half_onehot.class,
        half_confusion_matrix.class,
        half_stack.class,
        half_size.class,
        half_rank.class,
        half_broadcastgradientargs.class,
        half_zeros_as.class,
        half_ones_as.class,
        half_square.class,
        half_zeta.class,
        half_polygamma.class,
        half_fill.class,
        half_split_v.class,
        half_split.class,
        half_adjust_hue.class,
        half_adjust_saturation.class,
        half_depth_to_space.class,
        half_space_to_depth.class,
        half_cross.class,
        half_space_to_batch.class,
        half_batch_to_space.class,
        half_top_k.class,
        half_in_top_k.class,
        half_moments.class,
        half_embedding_lookup.class,
        half_dynamic_partition.class,
        half_dynamic_partition_bp.class,
        half_dynamic_stitch.class,
        half_zero_fraction.class,
        half_xw_plus_b.class,
        half_stop_gradient.class,
        half_l2_loss.class,
        half_parallel_stack.class,
        half_log_poison_loss.class,
        half_normalize_moments.class,
        half_sufficient_statistics.class,
        half_weighted_cross_entropy_with_logits.class,
        half_dropout.class,
        half_bincount.class,
        half_broadcast_dynamic_shape.class,
        half_matrix_determinant.class,
        half_matrix_inverse.class,
        half_sequence_mask.class,
        half_segment_max.class,
        half_segment_max_bp.class,
        half_segment_min.class,
        half_segment_min_bp.class,
        half_segment_sum.class,
        half_segment_sum_bp.class,
        half_segment_prod.class,
        half_segment_prod_bp.class,
        half_segment_mean.class,
        half_segment_mean_bp.class,
        half_unsorted_segment_max.class,
        half_unsorted_segment_max_bp.class,
        half_unsorted_segment_min.class,
        half_unsorted_segment_min_bp.class,
        half_unsorted_segment_sum.class,
        half_unsorted_segment_sum_bp.class,
        half_unsorted_segment_prod.class,
        half_unsorted_segment_prod_bp.class,
        half_unsorted_segment_mean.class,
        half_unsorted_segment_mean_bp.class,
        half_unsorted_segment_sqrt_n.class,
        half_unsorted_segment_sqrt_n_bp.class,
        half_extract_image_patches.class,
        half_roll.class,
        half_reduce_sum.class,
        half_reduce_sum_bp.class,
        half_reduce_prod.class,
        half_reduce_prod_bp.class,
        half_reduce_min.class,
        half_reduce_min_bp.class,
        half_reduce_max.class,
        half_reduce_max_bp.class,
        half_reduce_norm1.class,
        half_reduce_norm1_bp.class,
        half_reduce_norm2.class,
        half_reduce_norm2_bp.class,
        half_reduce_sqnorm.class,
        half_reduce_sqnorm_bp.class,
        half_reduce_norm_max.class,
        half_reduce_norm_max_bp.class,
        half_reduce_mean.class,
        half_reduce_mean_bp.class,
        half_reduce_variance.class,
        half_reduce_variance_bp.class,
        half_reduce_stdev.class,
        half_reduce_stdev_bp.class,
        half_reduce_dot_bp.class,
        half_matrix_band_part.class,
        half_set_seed.class,
        half_get_seed.class,
        half_randomuniform.class,
        half_random_normal.class,
        half_random_bernoulli.class,
        half_random_exponential.class,
        half_random_crop.class,
        half_sru_old.class,
        half_sru.class,
        half_sru_logic.class,
        half_sru_bi.class,
        half_sru_bp.class,
        half_sru_bp_logic.class,
        half_sru_bi_bp.class,
        half_lstmCell.class,
        half_sruCell.class,
        half_gruCell.class,
        half_gruCell_bp.class,
        half_lstm.class,
        half_gru.class,
        half_static_rnn.class,
        half_dynamic_rnn.class,
        half_static_bidirectional_rnn.class,
        half_dynamic_bidirectional_rnn.class,
        half_permute.class,
        half_reshapeas.class,
        half_transpose.class,
        half_shape_of.class,
        half_shapes_of.class,
        half_squeeze.class,
        half_expand_dims.class,
        half_reshape.class,
        half_size_at.class,
        half_order.class,
        half_tile_to_shape.class,
        half_tile_to_shape_bp.class,
        half_broadcast_to.class,
        half_test_output_reshape.class,
        half_test_scalar.class,
        half_testreduction.class,
        half_noop.class,
        half_testop2i2o.class,
        half_testcustom.class,
        half_firas_sparse.class,
        half_clipbyvalue.class,
        half_clipbynorm.class,
        half_clipbynorm_bp.class,
        half_clipbyavgnorm.class,
        half_cumsum.class,
        half_cumprod.class,
        half_tile.class,
        half_tile_bp.class,
        half_repeat.class,
        half_invert_permutation.class,
        half_concat.class,
        half_concat_bp.class,
        half_mergemax.class,
        half_mergemaxindex.class,
        half_mergeadd.class,
        half_mergeavg.class,
        half_scatter_update.class,
        half_Floor.class,
        half_Log1p.class,
        half_reverse.class,
        half_reverse_bp.class,
        half_gather.class,
        half_pad.class,
        half_eye.class,
        half_gather_nd.class,
        half_reverse_sequence.class,
        half_trace.class,
        half_random_shuffle.class,
        half_clip_by_global_norm.class,
        half_tri.class,
        half_triu.class,
        half_triu_bp.class,
        half_mirror_pad.class,
        half_cumsum_bp.class,
        half_cumprod_bp.class,
        half_histogram_fixed_width.class,};
    Class[] doubleOps = {
        double_Switch.class,
        double_While.class,
        double_Scope.class,
        double_Conditional.class,
        double_Return.class,
        double_expose.class,
        double_sigmoid.class,
        double_sigmoid_bp.class,
        double_softsign.class,
        double_softsign_bp.class,
        double_tanh.class,
        double_tanh_bp.class,
        double_softplus.class,
        double_softplus_bp.class,
        double_relu.class,
        double_relu_bp.class,
        double_selu.class,
        double_selu_bp.class,
        double_lrelu.class,
        double_lrelu_bp.class,
        double_elu.class,
        double_elu_bp.class,
        double_cube.class,
        double_cube_bp.class,
        double_rectifiedtanh.class,
        double_rectifiedtanh_bp.class,
        double_rationaltanh.class,
        double_rationaltanh_bp.class,
        double_hardtanh.class,
        double_hardtanh_bp.class,
        double_hardsigmoid.class,
        double_hardsigmoid_bp.class,
        double_identity.class,
        double_identity_bp.class,
        double_crelu.class,
        double_crelu_bp.class,
        double_relu6.class,
        double_relu6_bp.class,
        double_relu_layer.class,
        double_prelu.class,
        double_prelu_bp.class,
        double_thresholdedrelu.class,
        double_thresholdedrelu_bp.class,
        double_toggle_bits.class,
        double_matmul.class,
        double_tensormmul.class,
        double_axpy.class,
        double_batched_gemm.class,
        double_svd.class,
        double_lt_scalar.class,
        double_gt_scalar.class,
        double_lte_scalar.class,
        double_gte_scalar.class,
        double_eq_scalar.class,
        double_neq_scalar.class,
        double_Where.class,
        double_where_np.class,
        double_select.class,
        double_choose.class,
        double_is_non_decreasing.class,
        double_is_strictly_increasing.class,
        double_is_numeric_tensor.class,
        double_maximum.class,
        double_maximum_bp.class,
        double_minimum.class,
        double_minimum_bp.class,
        double_add.class,
        double_add_bp.class,
        double_subtract.class,
        double_subtract_bp.class,
        double_reversesubtract.class,
        double_reversesubtract_bp.class,
        double_reversemod.class,
        double_reversemod_bp.class,
        double_squaredsubtract.class,
        double_squaredsubtract_bp.class,
        double_multiply.class,
        double_multiply_bp.class,
        double_divide.class,
        double_divide_bp.class,
        double_reversedivide.class,
        double_reversedivide_bp.class,
        double_floormod.class,
        double_floormod_bp.class,
        double_mod.class,
        double_mod_bp.class,
        double_floordiv.class,
        double_floordiv_bp.class,
        double_realdiv.class,
        double_realdiv_bp.class,
        double_truncatediv.class,
        double_assign.class,
        double_assign_bp.class,
        double_meshgrid.class,
        double_equals.class,
        double_not_equals.class,
        double_less_equal.class,
        double_greater_equal.class,
        double_less.class,
        double_greater.class,
        double_boolean_and.class,
        double_boolean_or.class,
        double_boolean_xor.class,
        double_boolean_not.class,
        double_percentile.class,
        double_tf_atan2.class,
        double_conv1d.class,
        double_conv1d_bp.class,
        double_conv2d.class,
        double_conv2d_bp.class,
        double_conv2d_input_bp.class,
        double_sconv2d.class,
        double_sconv2d_bp.class,
        double_deconv2d.class,
        double_deconv2d_bp.class,
        double_deconv3d.class,
        double_deconv3d_bp.class,
        double_maxpool2d.class,
        double_maxpool2d_bp.class,
        double_avgpool2d.class,
        double_avgpool2d_bp.class,
        double_pnormpool2d.class,
        double_pnormpool2d_bp.class,
        double_maxpool3d.class,
        double_maxpool3d_bp.class,
        double_avgpool3d.class,
        double_avgpool3d_bp.class,
        double_fullconv3d.class,
        double_fullconv3d_bp.class,
        double_fullconv3d_grad.class,
        double_pooling2d.class,
        double_im2col.class,
        double_im2col_bp.class,
        double_col2im.class,
        double_upsampling2d.class,
        double_upsampling2d_bp.class,
        double_upsampling3d.class,
        double_upsampling3d_bp.class,
        double_conv3d.class,
        double_conv3d_bp.class,
        double_ismax.class,
        double_dilation2d.class,
        double_conv3dnew.class,
        double_conv3dnew_bp.class,
        double_avgpool3dnew.class,
        double_avgpool3dnew_bp.class,
        double_maxpool3dnew.class,
        double_maxpool3dnew_bp.class,
        double_max_pool_with_argmax.class,
        double_depthwise_conv2d.class,
        double_depthwise_conv2d_bp.class,
        double_pointwise_conv2d.class,
        double_deconv2d_tf.class,
        double_to_double.class,
        double_to_float16.class,
        double_to_float32.class,
        double_to_int32.class,
        double_to_int64.class,
        double_to_uint32.class,
        double_to_uint64.class,
        double_cast.class,
        double_write_list.class,
        double_stack_list.class,
        double_read_list.class,
        double_pick_list.class,
        double_size_list.class,
        double_create_list.class,
        double_scatter_list.class,
        double_split_list.class,
        double_gather_list.class,
        double_clone_list.class,
        double_unstack_list.class,
        double_hinge_loss.class,
        double_huber_loss.class,
        double_log_loss.class,
        double_mean_pairwssqerr_loss.class,
        double_mean_sqerr_loss.class,
        double_sigm_cross_entropy_loss.class,
        double_softmax_cross_entropy_loss.class,
        double_absolute_difference_loss.class,
        double_cosine_distance_loss.class,
        double_softmax_cross_entropy_loss_with_logits.class,
        double_sparse_softmax_cross_entropy_loss_with_logits.class,
        double_softmax.class,
        double_softmax_bp.class,
        double_lrn_old.class,
        double_lrn.class,
        double_lrn_bp.class,
        double_batchnorm.class,
        double_batchnorm_new.class,
        double_batchnorm_bp.class,
        double_apply_sgd.class,
        double_fused_batch_norm.class,
        double_log_softmax.class,
        double_log_softmax_bp.class,
        double_argmax.class,
        double_argmin.class,
        double_norm.class,
        double_matrix_set_diag.class,
        double_matrix_diag.class,
        double_betainc.class,
        double_biasadd.class,
        double_biasadd_bp.class,
        double_diag.class,
        double_diag_part.class,
        double_matrix_diag_part.class,
        double_listdiff.class,
        double_scatter_add.class,
        double_scatter_sub.class,
        double_scatter_mul.class,
        double_scatter_div.class,
        double_scatter_upd.class,
        double_scatter_max.class,
        double_scatter_min.class,
        double_scatter_nd.class,
        double_scatter_nd_update.class,
        double_scatter_nd_add.class,
        double_scatter_nd_sub.class,
        double_fill_as.class,
        double_rint.class,
        double_unique.class,
        double_unique_with_counts.class,
        double_tear.class,
        double_unstack.class,
        double_strided_slice.class,
        double_strided_slice_bp.class,
        double_slice.class,
        double_slice_bp.class,
        double_range.class,
        double_onehot.class,
        double_confusion_matrix.class,
        double_stack.class,
        double_size.class,
        double_rank.class,
        double_broadcastgradientargs.class,
        double_zeros_as.class,
        double_ones_as.class,
        double_square.class,
        double_zeta.class,
        double_polygamma.class,
        double_fill.class,
        double_split_v.class,
        double_split.class,
        double_adjust_hue.class,
        double_adjust_saturation.class,
        double_depth_to_space.class,
        double_space_to_depth.class,
        double_cross.class,
        double_space_to_batch.class,
        double_batch_to_space.class,
        double_top_k.class,
        double_in_top_k.class,
        double_moments.class,
        double_embedding_lookup.class,
        double_dynamic_partition.class,
        double_dynamic_partition_bp.class,
        double_dynamic_stitch.class,
        double_zero_fraction.class,
        double_xw_plus_b.class,
        double_stop_gradient.class,
        double_l2_loss.class,
        double_parallel_stack.class,
        double_log_poison_loss.class,
        double_normalize_moments.class,
        double_sufficient_statistics.class,
        double_weighted_cross_entropy_with_logits.class,
        double_dropout.class,
        double_bincount.class,
        double_broadcast_dynamic_shape.class,
        double_matrix_determinant.class,
        double_matrix_inverse.class,
        double_sequence_mask.class,
        double_segment_max.class,
        double_segment_max_bp.class,
        double_segment_min.class,
        double_segment_min_bp.class,
        double_segment_sum.class,
        double_segment_sum_bp.class,
        double_segment_prod.class,
        double_segment_prod_bp.class,
        double_segment_mean.class,
        double_segment_mean_bp.class,
        double_unsorted_segment_max.class,
        double_unsorted_segment_max_bp.class,
        double_unsorted_segment_min.class,
        double_unsorted_segment_min_bp.class,
        double_unsorted_segment_sum.class,
        double_unsorted_segment_sum_bp.class,
        double_unsorted_segment_prod.class,
        double_unsorted_segment_prod_bp.class,
        double_unsorted_segment_mean.class,
        double_unsorted_segment_mean_bp.class,
        double_unsorted_segment_sqrt_n.class,
        double_unsorted_segment_sqrt_n_bp.class,
        double_extract_image_patches.class,
        double_roll.class,
        double_reduce_sum.class,
        double_reduce_sum_bp.class,
        double_reduce_prod.class,
        double_reduce_prod_bp.class,
        double_reduce_min.class,
        double_reduce_min_bp.class,
        double_reduce_max.class,
        double_reduce_max_bp.class,
        double_reduce_norm1.class,
        double_reduce_norm1_bp.class,
        double_reduce_norm2.class,
        double_reduce_norm2_bp.class,
        double_reduce_sqnorm.class,
        double_reduce_sqnorm_bp.class,
        double_reduce_norm_max.class,
        double_reduce_norm_max_bp.class,
        double_reduce_mean.class,
        double_reduce_mean_bp.class,
        double_reduce_variance.class,
        double_reduce_variance_bp.class,
        double_reduce_stdev.class,
        double_reduce_stdev_bp.class,
        double_reduce_dot_bp.class,
        double_matrix_band_part.class,
        double_set_seed.class,
        double_get_seed.class,
        double_randomuniform.class,
        double_random_normal.class,
        double_random_bernoulli.class,
        double_random_exponential.class,
        double_random_crop.class,
        double_sru_old.class,
        double_sru.class,
        double_sru_logic.class,
        double_sru_bi.class,
        double_sru_bp.class,
        double_sru_bp_logic.class,
        double_sru_bi_bp.class,
        double_lstmCell.class,
        double_sruCell.class,
        double_gruCell.class,
        double_gruCell_bp.class,
        double_lstm.class,
        double_gru.class,
        double_static_rnn.class,
        double_dynamic_rnn.class,
        double_static_bidirectional_rnn.class,
        double_dynamic_bidirectional_rnn.class,
        double_permute.class,
        double_reshapeas.class,
        double_transpose.class,
        double_shape_of.class,
        double_shapes_of.class,
        double_squeeze.class,
        double_expand_dims.class,
        double_reshape.class,
        double_size_at.class,
        double_order.class,
        double_tile_to_shape.class,
        double_tile_to_shape_bp.class,
        double_broadcast_to.class,
        double_test_output_reshape.class,
        double_test_scalar.class,
        double_testreduction.class,
        double_noop.class,
        double_testop2i2o.class,
        double_testcustom.class,
        double_firas_sparse.class,
        double_clipbyvalue.class,
        double_clipbynorm.class,
        double_clipbynorm_bp.class,
        double_clipbyavgnorm.class,
        double_cumsum.class,
        double_cumprod.class,
        double_tile.class,
        double_tile_bp.class,
        double_repeat.class,
        double_invert_permutation.class,
        double_concat.class,
        double_concat_bp.class,
        double_mergemax.class,
        double_mergemaxindex.class,
        double_mergeadd.class,
        double_mergeavg.class,
        double_scatter_update.class,
        double_Floor.class,
        double_Log1p.class,
        double_reverse.class,
        double_reverse_bp.class,
        double_gather.class,
        double_pad.class,
        double_eye.class,
        double_gather_nd.class,
        double_reverse_sequence.class,
        double_trace.class,
        double_random_shuffle.class,
        double_clip_by_global_norm.class,
        double_tri.class,
        double_triu.class,
        double_triu_bp.class,
        double_mirror_pad.class,
        double_cumsum_bp.class,
        double_cumprod_bp.class,
        double_histogram_fixed_width.class,};

@Name("std::vector<std::vector<int> >") public static class IntVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntVectorVector(Pointer p) { super(p); }
    public IntVectorVector(int[] ... array) { this(array.length); put(array); }
    public IntVectorVector()       { allocate();  }
    public IntVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef IntVectorVector put(@ByRef IntVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);
    public boolean empty(@Cast("size_t") long i) { return size(i) == 0; }
    public native @Index(function = "at") long size(@Cast("size_t") long i);
    public void clear(@Cast("size_t") long i) { resize(i, 0); }
    public native @Index(function = "at") void resize(@Cast("size_t") long i, @Cast("size_t") long n);

    @Index(function = "at") public native int get(@Cast("size_t") long i, @Cast("size_t") long j);
    public native IntVectorVector put(@Cast("size_t") long i, @Cast("size_t") long j, int value);

    public int[][] get() {
        int[][] array = new int[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE][];
        for (int i = 0; i < array.length; i++) {
            array[i] = new int[size(i) < Integer.MAX_VALUE ? (int)size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < array[i].length; j++) {
                array[i][j] = get(i, j);
            }
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.deepToString(get());
    }

    public IntVectorVector put(int[] ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            if (size(i) != array[i].length) { resize(i, array[i].length); }
            for (int j = 0; j < array[i].length; j++) {
                put(i, j, array[i][j]);
            }
        }
        return this;
    }
}

@Name("std::vector<std::vector<Nd4jLong> >") public static class LongVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LongVectorVector(Pointer p) { super(p); }
    public LongVectorVector(long[] ... array) { this(array.length); put(array); }
    public LongVectorVector()       { allocate();  }
    public LongVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef LongVectorVector put(@ByRef LongVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);
    public boolean empty(@Cast("size_t") long i) { return size(i) == 0; }
    public native @Index(function = "at") long size(@Cast("size_t") long i);
    public void clear(@Cast("size_t") long i) { resize(i, 0); }
    public native @Index(function = "at") void resize(@Cast("size_t") long i, @Cast("size_t") long n);

    @Index(function = "at") public native @Cast("Nd4jLong") long get(@Cast("size_t") long i, @Cast("size_t") long j);
    public native LongVectorVector put(@Cast("size_t") long i, @Cast("size_t") long j, long value);

    public long[][] get() {
        long[][] array = new long[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE][];
        for (int i = 0; i < array.length; i++) {
            array[i] = new long[size(i) < Integer.MAX_VALUE ? (int)size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < array[i].length; j++) {
                array[i][j] = get(i, j);
            }
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.deepToString(get());
    }

    public LongVectorVector put(long[] ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            if (size(i) != array[i].length) { resize(i, array[i].length); }
            for (int j = 0; j < array[i].length; j++) {
                put(i, j, array[i][j]);
            }
        }
        return this;
    }
}

@Name("std::vector<nd4j::NDArray<float>*>") public static class FloatNDArrayVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FloatNDArrayVector(Pointer p) { super(p); }
    public FloatNDArrayVector(FloatNDArray value) { this(1); put(0, value); }
    public FloatNDArrayVector(FloatNDArray ... array) { this(array.length); put(array); }
    public FloatNDArrayVector()       { allocate();  }
    public FloatNDArrayVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef FloatNDArrayVector put(@ByRef FloatNDArrayVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native FloatNDArray get(@Cast("size_t") long i);
    public native FloatNDArrayVector put(@Cast("size_t") long i, FloatNDArray value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, FloatNDArray value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @Const FloatNDArray get();
    }

    public FloatNDArray[] get() {
        FloatNDArray[] array = new FloatNDArray[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public FloatNDArray pop_back() {
        long size = size();
        FloatNDArray value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public FloatNDArrayVector push_back(FloatNDArray value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public FloatNDArrayVector put(FloatNDArray value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public FloatNDArrayVector put(FloatNDArray ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<nd4j::NDArray<float16>*>") public static class HalfNDArrayVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HalfNDArrayVector(Pointer p) { super(p); }
    public HalfNDArrayVector(HalfNDArray value) { this(1); put(0, value); }
    public HalfNDArrayVector(HalfNDArray ... array) { this(array.length); put(array); }
    public HalfNDArrayVector()       { allocate();  }
    public HalfNDArrayVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef HalfNDArrayVector put(@ByRef HalfNDArrayVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native HalfNDArray get(@Cast("size_t") long i);
    public native HalfNDArrayVector put(@Cast("size_t") long i, HalfNDArray value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, HalfNDArray value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @Const HalfNDArray get();
    }

    public HalfNDArray[] get() {
        HalfNDArray[] array = new HalfNDArray[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public HalfNDArray pop_back() {
        long size = size();
        HalfNDArray value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public HalfNDArrayVector push_back(HalfNDArray value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public HalfNDArrayVector put(HalfNDArray value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public HalfNDArrayVector put(HalfNDArray ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<nd4j::NDArray<double>*>") public static class DoubleNDArrayVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DoubleNDArrayVector(Pointer p) { super(p); }
    public DoubleNDArrayVector(DoubleNDArray value) { this(1); put(0, value); }
    public DoubleNDArrayVector(DoubleNDArray ... array) { this(array.length); put(array); }
    public DoubleNDArrayVector()       { allocate();  }
    public DoubleNDArrayVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator=") @ByRef DoubleNDArrayVector put(@ByRef DoubleNDArrayVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native DoubleNDArray get(@Cast("size_t") long i);
    public native DoubleNDArrayVector put(@Cast("size_t") long i, DoubleNDArray value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, DoubleNDArray value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator++") @ByRef Iterator increment();
        public native @Name("operator==") boolean equals(@ByRef Iterator it);
        public native @Name("operator*") @Const DoubleNDArray get();
    }

    public DoubleNDArray[] get() {
        DoubleNDArray[] array = new DoubleNDArray[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public DoubleNDArray pop_back() {
        long size = size();
        DoubleNDArray value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public DoubleNDArrayVector push_back(DoubleNDArray value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public DoubleNDArrayVector put(DoubleNDArray value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public DoubleNDArrayVector put(DoubleNDArray ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@NoOffset @Name("std::pair<int,int>") public static class IntIntPair extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntIntPair(Pointer p) { super(p); }
    public IntIntPair(int firstValue, int secondValue) { this(); put(firstValue, secondValue); }
    public IntIntPair()       { allocate();  }
    private native void allocate();
    public native @Name("operator=") @ByRef IntIntPair put(@ByRef IntIntPair x);


    @MemberGetter public native int first(); public native IntIntPair first(int first);
    @MemberGetter public native int second();  public native IntIntPair second(int second);

    public IntIntPair put(int firstValue, int secondValue) {
        first(firstValue);
        second(secondValue);
        return this;
    }
}

// Parsed from NativeOps.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by agibsonccc on 2/21/16.
//

// #ifndef NATIVEOPERATIONS_NATIVEOPS_H
// #define NATIVEOPERATIONS_NATIVEOPS_H


// #ifndef thread_local
// # if __STDC_VERSION__ >= 201112 && !defined __STDC_NO_THREADS__
// #  define thread_local _Thread_local
// # elif defined _WIN32 && (
//        defined _MSC_VER ||
//        defined __ICL ||
//        defined __DMC__ ||
//        defined __BORLANDC__ )
// #  define thread_local __declspec(thread)
/* note that ICC (linux) and Clang are covered by __GNUC__ */
// # elif defined __GNUC__ ||
//        defined __SUNPRO_C ||
//        defined __xlC__
// #  define thread_local __thread
// # else
// #  error "Cannot define thread_local"
// # endif
// #endif

// #include <pointercast.h>
// #include <types/float16.h>
// #include <cnpy.h>

//DO NOT REMOVE: THIS IS AN EDITOR SEMANTICS THING FOR CLION
//IT DEFINES THE EXPORT MACRO FOR THE EDITOR AND THEN
//RE ADDS THE DEFINITION VIA dll.h
// #ifdef  _WIN32
// #define ND4J_EXPORT __declspec(dllexport)
// #else
// #define ND4J_EXPORT
// #endif
// #include <dll.h>
// #include <helpers/BlasHelper.h>

/*
int tad_threshold = 1;
int element_threshold = 32;

bool debug = false;
bool verbose = false;
*/

// #include <array/ShapeList.h>
// #include <graph/VariablesSet.h>
// #include <graph/GraphState.h>
// #include <graph/execution/LogicExecutor.h>
// #include <graph/ResultWrapper.h>

public static class NativeOps extends org.nd4j.nativeblas.NativeOps {
    static { Loader.load(); }
    /** Default native constructor. */
    public NativeOps() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public NativeOps(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NativeOps(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public NativeOps position(long position) {
        return (NativeOps)super.position(position);
    }



    /**
     *
     * @param num
     */
    public native void setElementThreshold(int num);

    /**
     *
     * @param num
     */
    public native void setTADThreshold(int num);

    /**
       *
       * @param opNum
       * @param x
       * @param xShapeInfo
       * @param extraParams
       */
    public native double execIndexReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                             DoublePointer x,
                                             @Cast("Nd4jLong*") LongPointer xInfo,
                                             DoublePointer extraParams);
    public native double execIndexReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                             DoubleBuffer x,
                                             @Cast("Nd4jLong*") LongBuffer xInfo,
                                             DoubleBuffer extraParams);
    public native double execIndexReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                             double[] x,
                                             @Cast("Nd4jLong*") long[] xInfo,
                                             double[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execIndexReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     DoublePointer x,
                                     @Cast("Nd4jLong*") LongPointer xInfo,
                                     DoublePointer extraParams,
                                     DoublePointer result,
                                     @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                     IntPointer dimension, int dimensionLength);
    public native void execIndexReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     DoubleBuffer x,
                                     @Cast("Nd4jLong*") LongBuffer xInfo,
                                     DoubleBuffer extraParams,
                                     DoubleBuffer result,
                                     @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                     IntBuffer dimension, int dimensionLength);
    public native void execIndexReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     double[] x,
                                     @Cast("Nd4jLong*") long[] xInfo,
                                     double[] extraParams,
                                     double[] result,
                                     @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                     int[] dimension, int dimensionLength);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param dimension
     * @param dimensionLength
     */
    public native void execBroadcastDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                DoublePointer x,
                @Cast("Nd4jLong*") LongPointer xInfo,
                DoublePointer y,
                @Cast("Nd4jLong*") LongPointer yInfo,
                DoublePointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                IntPointer dimension,
                int dimensionLength);
    public native void execBroadcastDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                DoubleBuffer x,
                @Cast("Nd4jLong*") LongBuffer xInfo,
                DoubleBuffer y,
                @Cast("Nd4jLong*") LongBuffer yInfo,
                DoubleBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                IntBuffer dimension,
                int dimensionLength);
    public native void execBroadcastDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                double[] x,
                @Cast("Nd4jLong*") long[] xInfo,
                double[] y,
                @Cast("Nd4jLong*") long[] yInfo,
                double[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                int[] dimension,
                int dimensionLength);



    /**
     *
     * @param opNum
     * @param dx
     * @param xStride
     * @param y
     * @param yStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           DoublePointer dx,
                                           @Cast("Nd4jLong") long xStride,
                                           DoublePointer y,
                                           @Cast("Nd4jLong") long yStride,
                                           DoublePointer result,
                                           @Cast("Nd4jLong") long resultStride,
                                           DoublePointer extraParams,
                                           @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           DoubleBuffer dx,
                                           @Cast("Nd4jLong") long xStride,
                                           DoubleBuffer y,
                                           @Cast("Nd4jLong") long yStride,
                                           DoubleBuffer result,
                                           @Cast("Nd4jLong") long resultStride,
                                           DoubleBuffer extraParams,
                                           @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           double[] dx,
                                           @Cast("Nd4jLong") long xStride,
                                           double[] y,
                                           @Cast("Nd4jLong") long yStride,
                                           double[] result,
                                           @Cast("Nd4jLong") long resultStride,
                                           double[] extraParams,
                                           @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     * @param xIndexes
     * @param yIndexes
     * @param resultIndexes
     */
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         DoublePointer dx,
                                         @Cast("Nd4jLong*") LongPointer xInfo,
                                         DoublePointer y,
                                         @Cast("Nd4jLong*") LongPointer yInfo,
                                         DoublePointer result,
                                         @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                         DoublePointer extraParams,
                                         @Cast("Nd4jLong*") LongPointer xIndexes,
                                         @Cast("Nd4jLong*") LongPointer yIndexes,
                                         @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         DoubleBuffer dx,
                                         @Cast("Nd4jLong*") LongBuffer xInfo,
                                         DoubleBuffer y,
                                         @Cast("Nd4jLong*") LongBuffer yInfo,
                                         DoubleBuffer result,
                                         @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                         DoubleBuffer extraParams,
                                         @Cast("Nd4jLong*") LongBuffer xIndexes,
                                         @Cast("Nd4jLong*") LongBuffer yIndexes,
                                         @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execPairwiseTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         double[] dx,
                                         @Cast("Nd4jLong*") long[] xInfo,
                                         double[] y,
                                         @Cast("Nd4jLong*") long[] yInfo,
                                         double[] result,
                                         @Cast("Nd4jLong*") long[] resultShapeInfo,
                                         double[] extraParams,
                                         @Cast("Nd4jLong*") long[] xIndexes,
                                         @Cast("Nd4jLong*") long[] yIndexes,
                                         @Cast("Nd4jLong*") long[] resultIndexes);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execPairwiseTransformDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                DoublePointer dx,
                @Cast("Nd4jLong*") LongPointer xShapeInfo,
                DoublePointer y,
                @Cast("Nd4jLong*") LongPointer yShapeInfo,
                DoublePointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                DoublePointer extraParams);
    public native void execPairwiseTransformDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                DoubleBuffer dx,
                @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                DoubleBuffer y,
                @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                DoubleBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                DoubleBuffer extraParams);
    public native void execPairwiseTransformDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                double[] dx,
                @Cast("Nd4jLong*") long[] xShapeInfo,
                double[] y,
                @Cast("Nd4jLong*") long[] yShapeInfo,
                double[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                double[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                DoublePointer x,
                                @Cast("Nd4jLong*") LongPointer xInfo,
                                DoublePointer extraParams,
                                DoublePointer result,
                                @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                DoubleBuffer x,
                                @Cast("Nd4jLong*") LongBuffer xInfo,
                                DoubleBuffer extraParams,
                                DoubleBuffer result,
                                @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                double[] x,
                                @Cast("Nd4jLong*") long[] xInfo,
                                double[] extraParams,
                                double[] result,
                                @Cast("Nd4jLong*") long[] resultShapeInfo);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                DoublePointer x,
                                @Cast("Nd4jLong*") LongPointer xInfo,
                                DoublePointer extraParams,
                                DoublePointer result,
                                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                IntPointer dimension,
                                int dimensionLength);
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                DoubleBuffer x,
                                @Cast("Nd4jLong*") LongBuffer xInfo,
                                DoubleBuffer extraParams,
                                DoubleBuffer result,
                                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                IntBuffer dimension,
                                int dimensionLength);
    public native void execReduceDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                double[] x,
                                @Cast("Nd4jLong*") long[] xInfo,
                                double[] extraParams,
                                double[] result,
                                @Cast("Nd4jLong*") long[] resultShapeInfo,
                                int[] dimension,
                                int dimensionLength);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @return
     */
    public native double execReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoublePointer x,
                                      @Cast("Nd4jLong*") LongPointer xInfo,
                                      DoublePointer extraParams);
    public native double execReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoubleBuffer x,
                                      @Cast("Nd4jLong*") LongBuffer xInfo,
                                      DoubleBuffer extraParams);
    public native double execReduceScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      double[] x,
                                      @Cast("Nd4jLong*") long[] xInfo,
                                      double[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoublePointer x,
                                 @Cast("Nd4jLong*") LongPointer xInfo,
                                 DoublePointer extraParamsVals,
                                 DoublePointer y,
                                 @Cast("Nd4jLong*") LongPointer yInfo,
                                 DoublePointer result,
                                 @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoubleBuffer x,
                                 @Cast("Nd4jLong*") LongBuffer xInfo,
                                 DoubleBuffer extraParamsVals,
                                 DoubleBuffer y,
                                 @Cast("Nd4jLong*") LongBuffer yInfo,
                                 DoubleBuffer result,
                                 @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 double[] x,
                                 @Cast("Nd4jLong*") long[] xInfo,
                                 double[] extraParamsVals,
                                 double[] y,
                                 @Cast("Nd4jLong*") long[] yInfo,
                                 double[] result,
                                 @Cast("Nd4jLong*") long[] resultShapeInfo);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     */
    public native double execReduce3ScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         DoublePointer x,
                                         @Cast("Nd4jLong*") LongPointer xInfo,
                                         DoublePointer extraParamsVals,
                                         DoublePointer y,
                                         @Cast("Nd4jLong*") LongPointer yInfo);
    public native double execReduce3ScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         DoubleBuffer x,
                                         @Cast("Nd4jLong*") LongBuffer xInfo,
                                         DoubleBuffer extraParamsVals,
                                         DoubleBuffer y,
                                         @Cast("Nd4jLong*") LongBuffer yInfo);
    public native double execReduce3ScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         double[] x,
                                         @Cast("Nd4jLong*") long[] xInfo,
                                         double[] extraParamsVals,
                                         double[] y,
                                         @Cast("Nd4jLong*") long[] yInfo);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoublePointer x,
                                 @Cast("Nd4jLong*") LongPointer xInfo,
                                 DoublePointer extraParamsVals,
                                 DoublePointer y,
                                 @Cast("Nd4jLong*") LongPointer yInfo,
                                 DoublePointer result,
                                 @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                 IntPointer dimension,
                                 int dimensionLength);
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoubleBuffer x,
                                 @Cast("Nd4jLong*") LongBuffer xInfo,
                                 DoubleBuffer extraParamsVals,
                                 DoubleBuffer y,
                                 @Cast("Nd4jLong*") LongBuffer yInfo,
                                 DoubleBuffer result,
                                 @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                 IntBuffer dimension,
                                 int dimensionLength);
    public native void execReduce3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 double[] x,
                                 @Cast("Nd4jLong*") long[] xInfo,
                                 double[] extraParamsVals,
                                 double[] y,
                                 @Cast("Nd4jLong*") long[] yInfo,
                                 double[] result,
                                 @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                 int[] dimension,
                                 int dimensionLength);

    public native void execReduce3AllDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoublePointer x,
                                 @Cast("Nd4jLong*") LongPointer xInfo,
                                 DoublePointer extraParamsVals,
                                 DoublePointer y,
                                 @Cast("Nd4jLong*") LongPointer yInfo,
                                 DoublePointer result,
                                 @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                 IntPointer dimension,
                                 int dimensionLength,
                                 @Cast("Nd4jLong*") LongPointer xTadShapeInfo,
                                 @Cast("Nd4jLong*") LongPointer xOffsets,
                                 @Cast("Nd4jLong*") LongPointer yTadShapeInfo,
                                 @Cast("Nd4jLong*") LongPointer yOffsets);
    public native void execReduce3AllDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 DoubleBuffer x,
                                 @Cast("Nd4jLong*") LongBuffer xInfo,
                                 DoubleBuffer extraParamsVals,
                                 DoubleBuffer y,
                                 @Cast("Nd4jLong*") LongBuffer yInfo,
                                 DoubleBuffer result,
                                 @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                 IntBuffer dimension,
                                 int dimensionLength,
                                 @Cast("Nd4jLong*") LongBuffer xTadShapeInfo,
                                 @Cast("Nd4jLong*") LongBuffer xOffsets,
                                 @Cast("Nd4jLong*") LongBuffer yTadShapeInfo,
                                 @Cast("Nd4jLong*") LongBuffer yOffsets);
    public native void execReduce3AllDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 double[] x,
                                 @Cast("Nd4jLong*") long[] xInfo,
                                 double[] extraParamsVals,
                                 double[] y,
                                 @Cast("Nd4jLong*") long[] yInfo,
                                 double[] result,
                                 @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                 int[] dimension,
                                 int dimensionLength,
                                 @Cast("Nd4jLong*") long[] xTadShapeInfo,
                                 @Cast("Nd4jLong*") long[] xOffsets,
                                 @Cast("Nd4jLong*") long[] yTadShapeInfo,
                                 @Cast("Nd4jLong*") long[] yOffsets);

    public native void execReduce3AllFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatPointer x,
                                  @Cast("Nd4jLong*") LongPointer xInfo,
                                  FloatPointer extraParamsVals,
                                  FloatPointer y,
                                  @Cast("Nd4jLong*") LongPointer yInfo,
                                  FloatPointer result,
                                  @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                  IntPointer dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") LongPointer xTadShapeInfo,
                                  @Cast("Nd4jLong*") LongPointer xOffsets,
                                  @Cast("Nd4jLong*") LongPointer yTadShapeInfo,
                                  @Cast("Nd4jLong*") LongPointer yOffsets);
    public native void execReduce3AllFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatBuffer x,
                                  @Cast("Nd4jLong*") LongBuffer xInfo,
                                  FloatBuffer extraParamsVals,
                                  FloatBuffer y,
                                  @Cast("Nd4jLong*") LongBuffer yInfo,
                                  FloatBuffer result,
                                  @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                  IntBuffer dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") LongBuffer xTadShapeInfo,
                                  @Cast("Nd4jLong*") LongBuffer xOffsets,
                                  @Cast("Nd4jLong*") LongBuffer yTadShapeInfo,
                                  @Cast("Nd4jLong*") LongBuffer yOffsets);
    public native void execReduce3AllFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  float[] x,
                                  @Cast("Nd4jLong*") long[] xInfo,
                                  float[] extraParamsVals,
                                  float[] y,
                                  @Cast("Nd4jLong*") long[] yInfo,
                                  float[] result,
                                  @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                  int[] dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") long[] xTadShapeInfo,
                                  @Cast("Nd4jLong*") long[] xOffsets,
                                  @Cast("Nd4jLong*") long[] yTadShapeInfo,
                                  @Cast("Nd4jLong*") long[] yOffsets);

    public native void execReduce3AllHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  @Cast("float16*") ShortPointer x,
                                  @Cast("Nd4jLong*") LongPointer xInfo,
                                  @Cast("float16*") ShortPointer extraParamsVals,
                                  @Cast("float16*") ShortPointer y,
                                  @Cast("Nd4jLong*") LongPointer yInfo,
                                  @Cast("float16*") ShortPointer result,
                                  @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                  IntPointer dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") LongPointer xTadShapeInfo,
                                  @Cast("Nd4jLong*") LongPointer xOffsets,
                                  @Cast("Nd4jLong*") LongPointer yTadShapeInfo,
                                  @Cast("Nd4jLong*") LongPointer yOffsets);
    public native void execReduce3AllHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  @Cast("float16*") ShortBuffer x,
                                  @Cast("Nd4jLong*") LongBuffer xInfo,
                                  @Cast("float16*") ShortBuffer extraParamsVals,
                                  @Cast("float16*") ShortBuffer y,
                                  @Cast("Nd4jLong*") LongBuffer yInfo,
                                  @Cast("float16*") ShortBuffer result,
                                  @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                  IntBuffer dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") LongBuffer xTadShapeInfo,
                                  @Cast("Nd4jLong*") LongBuffer xOffsets,
                                  @Cast("Nd4jLong*") LongBuffer yTadShapeInfo,
                                  @Cast("Nd4jLong*") LongBuffer yOffsets);
    public native void execReduce3AllHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  @Cast("float16*") short[] x,
                                  @Cast("Nd4jLong*") long[] xInfo,
                                  @Cast("float16*") short[] extraParamsVals,
                                  @Cast("float16*") short[] y,
                                  @Cast("Nd4jLong*") long[] yInfo,
                                  @Cast("float16*") short[] result,
                                  @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                  int[] dimension,
                                  int dimensionLength,
                                  @Cast("Nd4jLong*") long[] xTadShapeInfo,
                                  @Cast("Nd4jLong*") long[] xOffsets,
                                  @Cast("Nd4jLong*") long[] yTadShapeInfo,
                                  @Cast("Nd4jLong*") long[] yOffsets);





    /**
     *
     * @param opNum
     * @param x
     * @param xStride
     * @param result
     * @param resultStride
     * @param scalar
     * @param extraParams
     * @param n
     */
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                DoublePointer x,
                                @Cast("Nd4jLong") long xStride,
                                DoublePointer result,
                                @Cast("Nd4jLong") long resultStride,
                                double scalar,
                                DoublePointer extraParams,
                                @Cast("Nd4jLong") long n);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                DoubleBuffer x,
                                @Cast("Nd4jLong") long xStride,
                                DoubleBuffer result,
                                @Cast("Nd4jLong") long resultStride,
                                double scalar,
                                DoubleBuffer extraParams,
                                @Cast("Nd4jLong") long n);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                double[] x,
                                @Cast("Nd4jLong") long xStride,
                                double[] result,
                                @Cast("Nd4jLong") long resultStride,
                                double scalar,
                                double[] extraParams,
                                @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param scalar
     * @param extraParams
     * @param n
     */
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              DoublePointer x,
                              @Cast("Nd4jLong*") LongPointer xInfo,
                              DoublePointer result,
                              @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                              double scalar,
                              DoublePointer extraParams);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              DoubleBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xInfo,
                              DoubleBuffer result,
                              @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                              double scalar,
                              DoubleBuffer extraParams);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              double[] x,
                              @Cast("Nd4jLong*") long[] xInfo,
                              double[] result,
                              @Cast("Nd4jLong*") long[] resultShapeInfo,
                              double scalar,
                              double[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param scalar
     * @param extraParams
     * @param n
     * @param xIndexes
     * @param resultIndexes
     */
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              DoublePointer x,
                              @Cast("Nd4jLong*") LongPointer xInfo,
                              DoublePointer result,
                              @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                              double scalar,
                              DoublePointer extraParams,
                              @Cast("Nd4jLong") long n,
                              @Cast("Nd4jLong*") LongPointer xIndexes,
                              @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              DoubleBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xInfo,
                              DoubleBuffer result,
                              @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                              double scalar,
                              DoubleBuffer extraParams,
                              @Cast("Nd4jLong") long n,
                              @Cast("Nd4jLong*") LongBuffer xIndexes,
                              @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              double[] x,
                              @Cast("Nd4jLong*") long[] xInfo,
                              double[] result,
                              @Cast("Nd4jLong*") long[] resultShapeInfo,
                              double scalar,
                              double[] extraParams,
                              @Cast("Nd4jLong") long n,
                              @Cast("Nd4jLong*") long[] xIndexes,
                              @Cast("Nd4jLong*") long[] resultIndexes);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     */
    public native double execSummaryStatsScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                              int opNum,
                                              DoublePointer x,
                                              @Cast("Nd4jLong*") LongPointer xInfo,
                                              DoublePointer extraParams,
                                              @Cast("bool") boolean biasCorrected);
    public native double execSummaryStatsScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                              int opNum,
                                              DoubleBuffer x,
                                              @Cast("Nd4jLong*") LongBuffer xInfo,
                                              DoubleBuffer extraParams,
                                              @Cast("bool") boolean biasCorrected);
    public native double execSummaryStatsScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                              int opNum,
                                              double[] x,
                                              @Cast("Nd4jLong*") long[] xInfo,
                                              double[] extraParams,
                                              @Cast("bool") boolean biasCorrected);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoublePointer x,
                                      @Cast("Nd4jLong*") LongPointer xInfo,
                                      DoublePointer extraParams,
                                      DoublePointer result,
                                      @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                      @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoubleBuffer x,
                                      @Cast("Nd4jLong*") LongBuffer xInfo,
                                      DoubleBuffer extraParams,
                                      DoubleBuffer result,
                                      @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                      @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      double[] x,
                                      @Cast("Nd4jLong*") long[] xInfo,
                                      double[] extraParams,
                                      double[] result,
                                      @Cast("Nd4jLong*") long[] resultShapeInfo,
                                      @Cast("bool") boolean biasCorrected);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoublePointer x,
                                      @Cast("Nd4jLong*") LongPointer xInfo,
                                      DoublePointer extraParams,
                                      DoublePointer result,
                                      @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                      IntPointer dimension,
                                      int dimensionLength,
                                      @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      DoubleBuffer x,
                                      @Cast("Nd4jLong*") LongBuffer xInfo,
                                      DoubleBuffer extraParams,
                                      DoubleBuffer result,
                                      @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                      IntBuffer dimension,
                                      int dimensionLength,
                                      @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      double[] x,
                                      @Cast("Nd4jLong*") long[] xInfo,
                                      double[] extraParams,
                                      double[] result,
                                      @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                      int[] dimension,
                                      int dimensionLength,
                                      @Cast("bool") boolean biasCorrected);
    /**
     *
     * @param opNum
     * @param dx
     * @param xStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   DoublePointer dx,
                                   @Cast("Nd4jLong") long xStride,
                                   DoublePointer result,
                                   @Cast("Nd4jLong") long resultStride,
                                   DoublePointer extraParams,
                                   @Cast("Nd4jLong") long n);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   DoubleBuffer dx,
                                   @Cast("Nd4jLong") long xStride,
                                   DoubleBuffer result,
                                   @Cast("Nd4jLong") long resultStride,
                                   DoubleBuffer extraParams,
                                   @Cast("Nd4jLong") long n);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   double[] dx,
                                   @Cast("Nd4jLong") long xStride,
                                   double[] result,
                                   @Cast("Nd4jLong") long resultStride,
                                   double[] extraParams,
                                   @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   DoublePointer dx,
                                   @Cast("Nd4jLong*") LongPointer xInfo,
                                   DoublePointer result,
                                   @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                   DoublePointer extraParams);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   DoubleBuffer dx,
                                   @Cast("Nd4jLong*") LongBuffer xInfo,
                                   DoubleBuffer result,
                                   @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                   DoubleBuffer extraParams);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   double[] dx,
                                   @Cast("Nd4jLong*") long[] xInfo,
                                   double[] result,
                                   @Cast("Nd4jLong*") long[] resultShapeInfo,
                                   double[] extraParams);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   DoublePointer dx,
                                   @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                   DoublePointer result,
                                   @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                   DoublePointer extraParams,
                                   @Cast("Nd4jLong*") LongPointer xIndexes,
                                   @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   DoubleBuffer dx,
                                   @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                   DoubleBuffer result,
                                   @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                   DoubleBuffer extraParams,
                                   @Cast("Nd4jLong*") LongBuffer xIndexes,
                                   @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execTransformDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   double[] dx,
                                   @Cast("Nd4jLong*") long[] xShapeInfo,
                                   double[] result,
                                   @Cast("Nd4jLong*") long[] resultShapeInfo,
                                   double[] extraParams,
                                   @Cast("Nd4jLong*") long[] xIndexes,
                                   @Cast("Nd4jLong*") long[] resultIndexes);

    /**
    *
    * @param opNum
    * @param x
    * @param xShapeInfo
    * @param extraParams
    */
    public native float execIndexReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           FloatPointer x,
                                           @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                           FloatPointer extraParams);
    public native float execIndexReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           FloatBuffer x,
                                           @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                           FloatBuffer extraParams);
    public native float execIndexReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           float[] x,
                                           @Cast("Nd4jLong*") long[] xShapeInfo,
                                           float[] extraParams);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @return
     */
    public native float execIndexReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        @Cast("float16*") ShortPointer x,
                                        @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                        @Cast("float16*") ShortPointer extraParams);
    public native float execIndexReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        @Cast("float16*") ShortBuffer x,
                                        @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                        @Cast("float16*") ShortBuffer extraParams);
    public native float execIndexReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        @Cast("float16*") short[] x,
                                        @Cast("Nd4jLong*") long[] xShapeInfo,
                                        @Cast("float16*") short[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execIndexReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                    FloatPointer x,
                                    @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                    FloatPointer extraParams,
                                    FloatPointer result,
                                    @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                    IntPointer dimension, int dimensionLength);
    public native void execIndexReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                    FloatBuffer x,
                                    @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                    FloatBuffer extraParams,
                                    FloatBuffer result,
                                    @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                    IntBuffer dimension, int dimensionLength);
    public native void execIndexReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                    float[] x,
                                    @Cast("Nd4jLong*") long[] xShapeInfo,
                                    float[] extraParams,
                                    float[] result,
                                    @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                    int[] dimension, int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execIndexReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   @Cast("float16*") ShortPointer x,
                                   @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                   @Cast("float16*") ShortPointer extraParams,
                                   @Cast("float16*") ShortPointer result,
                                   @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                   IntPointer dimension, int dimensionLength);
    public native void execIndexReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   @Cast("float16*") ShortBuffer x,
                                   @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                   @Cast("float16*") ShortBuffer extraParams,
                                   @Cast("float16*") ShortBuffer result,
                                   @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                   IntBuffer dimension, int dimensionLength);
    public native void execIndexReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                   @Cast("float16*") short[] x,
                                   @Cast("Nd4jLong*") long[] xShapeInfo,
                                   @Cast("float16*") short[] extraParams,
                                   @Cast("float16*") short[] result,
                                   @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                   int[] dimension, int dimensionLength);
    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param dimension
     * @param dimensionLength
     */
    public native void execBroadcastFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                FloatPointer x,
                @Cast("Nd4jLong*") LongPointer xShapeInfo,
                FloatPointer y,
                @Cast("Nd4jLong*") LongPointer yShapeInfo,
                FloatPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                IntPointer dimension,
                int dimensionLength);
    public native void execBroadcastFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                FloatBuffer x,
                @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                FloatBuffer y,
                @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                FloatBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                IntBuffer dimension,
                int dimensionLength);
    public native void execBroadcastFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                float[] x,
                @Cast("Nd4jLong*") long[] xShapeInfo,
                float[] y,
                @Cast("Nd4jLong*") long[] yShapeInfo,
                float[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                int[] dimension,
                int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param dimension
     * @param dimensionLength
     */
    public native void execBroadcastHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                @Cast("float16*") ShortPointer x,
                @Cast("Nd4jLong*") LongPointer xShapeInfo,
                @Cast("float16*") ShortPointer y,
                @Cast("Nd4jLong*") LongPointer yShapeInfo,
                @Cast("float16*") ShortPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                IntPointer dimension, int dimensionLength);
    public native void execBroadcastHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                @Cast("float16*") ShortBuffer x,
                @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                @Cast("float16*") ShortBuffer y,
                @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                @Cast("float16*") ShortBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                IntBuffer dimension, int dimensionLength);
    public native void execBroadcastHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int opNum,
                @Cast("float16*") short[] x,
                @Cast("Nd4jLong*") long[] xShapeInfo,
                @Cast("float16*") short[] y,
                @Cast("Nd4jLong*") long[] yShapeInfo,
                @Cast("float16*") short[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                int[] dimension, int dimensionLength);



    /**
     *
     * @param opNum
     * @param dx
     * @param xStride
     * @param y
     * @param yStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                          int opNum,
                                          FloatPointer dx,
                                          @Cast("Nd4jLong") long xStride,
                                          FloatPointer y,
                                          @Cast("Nd4jLong") long yStride,
                                          FloatPointer result,
                                          @Cast("Nd4jLong") long resultStride,
                                          FloatPointer extraParams,
                                          @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                          int opNum,
                                          FloatBuffer dx,
                                          @Cast("Nd4jLong") long xStride,
                                          FloatBuffer y,
                                          @Cast("Nd4jLong") long yStride,
                                          FloatBuffer result,
                                          @Cast("Nd4jLong") long resultStride,
                                          FloatBuffer extraParams,
                                          @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                          int opNum,
                                          float[] dx,
                                          @Cast("Nd4jLong") long xStride,
                                          float[] y,
                                          @Cast("Nd4jLong") long yStride,
                                          float[] result,
                                          @Cast("Nd4jLong") long resultStride,
                                          float[] extraParams,
                                          @Cast("Nd4jLong") long n);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xStride
     * @param y
     * @param yStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         @Cast("float16*") ShortPointer dx,
                                         @Cast("Nd4jLong") long xStride,
                                         @Cast("float16*") ShortPointer y,
                                         @Cast("Nd4jLong") long yStride,
                                         @Cast("float16*") ShortPointer result,
                                         @Cast("Nd4jLong") long resultStride,
                                         @Cast("float16*") ShortPointer extraParams,
                                         @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         @Cast("float16*") ShortBuffer dx,
                                         @Cast("Nd4jLong") long xStride,
                                         @Cast("float16*") ShortBuffer y,
                                         @Cast("Nd4jLong") long yStride,
                                         @Cast("float16*") ShortBuffer result,
                                         @Cast("Nd4jLong") long resultStride,
                                         @Cast("float16*") ShortBuffer extraParams,
                                         @Cast("Nd4jLong") long n);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                         int opNum,
                                         @Cast("float16*") short[] dx,
                                         @Cast("Nd4jLong") long xStride,
                                         @Cast("float16*") short[] y,
                                         @Cast("Nd4jLong") long yStride,
                                         @Cast("float16*") short[] result,
                                         @Cast("Nd4jLong") long resultStride,
                                         @Cast("float16*") short[] extraParams,
                                         @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     * @param xIndexes
     * @param yIndexes
     * @param resultIndexes
     */
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        FloatPointer dx,
                                        @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                        FloatPointer y,
                                        @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                        FloatPointer result,
                                        @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                        FloatPointer extraParams,
                                        @Cast("Nd4jLong*") LongPointer xIndexes,
                                        @Cast("Nd4jLong*") LongPointer yIndexes,
                                        @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        FloatBuffer dx,
                                        @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                        FloatBuffer y,
                                        @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                        FloatBuffer result,
                                        @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                        FloatBuffer extraParams,
                                        @Cast("Nd4jLong*") LongBuffer xIndexes,
                                        @Cast("Nd4jLong*") LongBuffer yIndexes,
                                        @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        float[] dx,
                                        @Cast("Nd4jLong*") long[] xShapeInfo,
                                        float[] y,
                                        @Cast("Nd4jLong*") long[] yShapeInfo,
                                        float[] result,
                                        @Cast("Nd4jLong*") long[] resultShapeInfo,
                                        float[] extraParams,
                                        @Cast("Nd4jLong*") long[] xIndexes,
                                        @Cast("Nd4jLong*") long[] yIndexes,
                                        @Cast("Nd4jLong*") long[] resultIndexes);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param xIndexes
     * @param yIndexes
     * @param resultIndexes
     */
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") ShortPointer dx,
                                       @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                       @Cast("float16*") ShortPointer y,
                                       @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                       @Cast("float16*") ShortPointer result,
                                       @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                       @Cast("float16*") ShortPointer extraParams,
                                       @Cast("Nd4jLong*") LongPointer xIndexes,
                                       @Cast("Nd4jLong*") LongPointer yIndexes,
                                       @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") ShortBuffer dx,
                                       @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                       @Cast("float16*") ShortBuffer y,
                                       @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                       @Cast("float16*") ShortBuffer result,
                                       @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                       @Cast("float16*") ShortBuffer extraParams,
                                       @Cast("Nd4jLong*") LongBuffer xIndexes,
                                       @Cast("Nd4jLong*") LongBuffer yIndexes,
                                       @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") short[] dx,
                                       @Cast("Nd4jLong*") long[] xShapeInfo,
                                       @Cast("float16*") short[] y,
                                       @Cast("Nd4jLong*") long[] yShapeInfo,
                                       @Cast("float16*") short[] result,
                                       @Cast("Nd4jLong*") long[] resultShapeInfo,
                                       @Cast("float16*") short[] extraParams,
                                       @Cast("Nd4jLong*") long[] xIndexes,
                                       @Cast("Nd4jLong*") long[] yIndexes,
                                       @Cast("Nd4jLong*") long[] resultIndexes);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        FloatPointer dx,
                                        @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                        FloatPointer y,
                                        @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                        FloatPointer result,
                                        @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                        FloatPointer extraParams);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        FloatBuffer dx,
                                        @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                        FloatBuffer y,
                                        @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                        FloatBuffer result,
                                        @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                        FloatBuffer extraParams);
    public native void execPairwiseTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        float[] dx,
                                        @Cast("Nd4jLong*") long[] xShapeInfo,
                                        float[] y,
                                        @Cast("Nd4jLong*") long[] yShapeInfo,
                                        float[] result,
                                        @Cast("Nd4jLong*") long[] resultShapeInfo,
                                        float[] extraParams);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     */
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") ShortPointer dx,
                                       @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                       @Cast("float16*") ShortPointer y,
                                       @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                       @Cast("float16*") ShortPointer result,
                                       @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                       @Cast("float16*") ShortPointer extraParams);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") ShortBuffer dx,
                                       @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                       @Cast("float16*") ShortBuffer y,
                                       @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                       @Cast("float16*") ShortBuffer result,
                                       @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                       @Cast("float16*") ShortBuffer extraParams);
    public native void execPairwiseTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       @Cast("float16*") short[] dx,
                                       @Cast("Nd4jLong*") long[] xShapeInfo,
                                       @Cast("float16*") short[] y,
                                       @Cast("Nd4jLong*") long[] yShapeInfo,
                                       @Cast("float16*") short[] result,
                                       @Cast("Nd4jLong*") long[] resultShapeInfo,
                                       @Cast("float16*") short[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatPointer x,
                               @Cast("Nd4jLong*") LongPointer xShapeInfo,
                               FloatPointer extraParams,
                               FloatPointer result,
                               @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatBuffer x,
                               @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                               FloatBuffer extraParams,
                               FloatBuffer result,
                               @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               float[] x,
                               @Cast("Nd4jLong*") long[] xShapeInfo,
                               float[] extraParams,
                               float[] result,
                               @Cast("Nd4jLong*") long[] resultShapeInfo);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortPointer x,
                              @Cast("Nd4jLong*") LongPointer xShapeInfo,
                              @Cast("float16*") ShortPointer extraParams,
                              @Cast("float16*") ShortPointer result,
                              @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                              @Cast("float16*") ShortBuffer extraParams,
                              @Cast("float16*") ShortBuffer result,
                              @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") short[] x,
                              @Cast("Nd4jLong*") long[] xShapeInfo,
                              @Cast("float16*") short[] extraParams,
                              @Cast("float16*") short[] result,
                              @Cast("Nd4jLong*") long[] resultShapeInfo);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatPointer x,
                               @Cast("Nd4jLong*") LongPointer xShapeInfo,
                               FloatPointer extraParams,
                               FloatPointer result,
                               @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                               IntPointer dimension,
                               int dimensionLength);
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatBuffer x,
                               @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                               FloatBuffer extraParams,
                               FloatBuffer result,
                               @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                               IntBuffer dimension,
                               int dimensionLength);
    public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               float[] x,
                               @Cast("Nd4jLong*") long[] xShapeInfo,
                               float[] extraParams,
                               float[] result,
                               @Cast("Nd4jLong*") long[] resultShapeInfo,
                               int[] dimension,
                               int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     * @param dimension
     * @param dimensionLength
     */

    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortPointer x,
                              @Cast("Nd4jLong*") LongPointer xShapeInfo,
                              @Cast("float16*") ShortPointer extraParams,
                              @Cast("float16*") ShortPointer result,
                              @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                              IntPointer dimension,
                              int dimensionLength);
    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                              @Cast("float16*") ShortBuffer extraParams,
                              @Cast("float16*") ShortBuffer result,
                              @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                              IntBuffer dimension,
                              int dimensionLength);
    public native void execReduceHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") short[] x,
                              @Cast("Nd4jLong*") long[] xShapeInfo,
                              @Cast("float16*") short[] extraParams,
                              @Cast("float16*") short[] result,
                              @Cast("Nd4jLong*") long[] resultShapeInfo,
                              int[] dimension,
                              int dimensionLength);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @return
     */
    public native float execReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    FloatPointer x,
                                    @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                    FloatPointer extraParams);
    public native float execReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    FloatBuffer x,
                                    @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                    FloatBuffer extraParams);
    public native float execReduceScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    float[] x,
                                    @Cast("Nd4jLong*") long[] xShapeInfo,
                                    float[] extraParams);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @return
     */
    public native float execReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   @Cast("float16*") ShortPointer x,
                                   @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                   @Cast("float16*") ShortPointer extraParams);
    public native float execReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   @Cast("float16*") ShortBuffer x,
                                   @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                   @Cast("float16*") ShortBuffer extraParams);
    public native float execReduceScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   @Cast("float16*") short[] x,
                                   @Cast("Nd4jLong*") long[] xShapeInfo,
                                   @Cast("float16*") short[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                FloatPointer x,
                                @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                FloatPointer extraParamsVals,
                                FloatPointer y,
                                @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                FloatPointer result,
                                @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                FloatBuffer x,
                                @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                FloatBuffer extraParamsVals,
                                FloatBuffer y,
                                @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                FloatBuffer result,
                                @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                float[] x,
                                @Cast("Nd4jLong*") long[] xShapeInfo,
                                float[] extraParamsVals,
                                float[] y,
                                @Cast("Nd4jLong*") long[] yShapeInfo,
                                float[] result,
                                @Cast("Nd4jLong*") long[] resultShapeInfo);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfo
     */
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                               @Cast("float16*") ShortPointer x,
                               @Cast("Nd4jLong*") LongPointer xShapeInfo,
                               @Cast("float16*") ShortPointer extraParamsVals,
                               @Cast("float16*") ShortPointer y,
                               @Cast("Nd4jLong*") LongPointer yShapeInfo,
                               @Cast("float16*") ShortPointer result,
                               @Cast("Nd4jLong*") LongPointer resultShapeInfo);
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                               @Cast("float16*") ShortBuffer x,
                               @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                               @Cast("float16*") ShortBuffer extraParamsVals,
                               @Cast("float16*") ShortBuffer y,
                               @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                               @Cast("float16*") ShortBuffer result,
                               @Cast("Nd4jLong*") LongBuffer resultShapeInfo);
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                               @Cast("float16*") short[] x,
                               @Cast("Nd4jLong*") long[] xShapeInfo,
                               @Cast("float16*") short[] extraParamsVals,
                               @Cast("float16*") short[] y,
                               @Cast("Nd4jLong*") long[] yShapeInfo,
                               @Cast("float16*") short[] result,
                               @Cast("Nd4jLong*") long[] resultShapeInfo);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     */
    public native float execReduce3ScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       FloatPointer x,
                                       @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                       FloatPointer extraParamsVals,
                                       FloatPointer y,
                                       @Cast("Nd4jLong*") LongPointer yShapeInfo);
    public native float execReduce3ScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       FloatBuffer x,
                                       @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                       FloatBuffer extraParamsVals,
                                       FloatBuffer y,
                                       @Cast("Nd4jLong*") LongBuffer yShapeInfo);
    public native float execReduce3ScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       float[] x,
                                       @Cast("Nd4jLong*") long[] xShapeInfo,
                                       float[] extraParamsVals,
                                       float[] y,
                                       @Cast("Nd4jLong*") long[] yShapeInfo);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @return
     */
    public native float execReduce3ScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      @Cast("float16*") ShortPointer x,
                                      @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                      @Cast("float16*") ShortPointer extraParamsVals,
                                      @Cast("float16*") ShortPointer y,
                                      @Cast("Nd4jLong*") LongPointer yShapeInfo);
    public native float execReduce3ScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      @Cast("float16*") ShortBuffer x,
                                      @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                      @Cast("float16*") ShortBuffer extraParamsVals,
                                      @Cast("float16*") ShortBuffer y,
                                      @Cast("Nd4jLong*") LongBuffer yShapeInfo);
    public native float execReduce3ScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int opNum,
                                      @Cast("float16*") short[] x,
                                      @Cast("Nd4jLong*") long[] xShapeInfo,
                                      @Cast("float16*") short[] extraParamsVals,
                                      @Cast("float16*") short[] y,
                                      @Cast("Nd4jLong*") long[] yShapeInfo);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                FloatPointer x,
                                @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                FloatPointer extraParamsVals,
                                FloatPointer y,
                                @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                FloatPointer result,
                                @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                IntPointer dimension,
                                int dimensionLength);
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                FloatBuffer x,
                                @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                FloatBuffer extraParamsVals,
                                FloatBuffer y,
                                @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                FloatBuffer result,
                                @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                IntBuffer dimension,
                                int dimensionLength);
    public native void execReduce3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                float[] x,
                                @Cast("Nd4jLong*") long[] xShapeInfo,
                                float[] extraParamsVals,
                                float[] y,
                                @Cast("Nd4jLong*") long[] yShapeInfo,
                                float[] result,
                                @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                int[] dimension,
                                int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParamsVals
     * @param y
     * @param yShapeInfo
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16*") ShortPointer x,
                               @Cast("Nd4jLong*") LongPointer xShapeInfo,
                               @Cast("float16*") ShortPointer extraParamsVals,
                               @Cast("float16*") ShortPointer y,
                               @Cast("Nd4jLong*") LongPointer yShapeInfo,
                               @Cast("float16*") ShortPointer result,
                               @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                               IntPointer dimension,
                               int dimensionLength);
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16*") ShortBuffer x,
                               @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                               @Cast("float16*") ShortBuffer extraParamsVals,
                               @Cast("float16*") ShortBuffer y,
                               @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                               @Cast("float16*") ShortBuffer result,
                               @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                               IntBuffer dimension,
                               int dimensionLength);
    public native void execReduce3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16*") short[] x,
                               @Cast("Nd4jLong*") long[] xShapeInfo,
                               @Cast("float16*") short[] extraParamsVals,
                               @Cast("float16*") short[] y,
                               @Cast("Nd4jLong*") long[] yShapeInfo,
                               @Cast("float16*") short[] result,
                               @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                               int[] dimension,
                               int dimensionLength);
    /**
     *
     * @param opNum
     * @param x
     * @param xStride
     * @param result
     * @param resultStride
     * @param scalar
     * @param extraParams
     * @param n
     */
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatPointer x,
                               @Cast("Nd4jLong") long xStride,
                               FloatPointer result,
                               @Cast("Nd4jLong") long resultStride,
                               float scalar,
                               FloatPointer extraParams,
                               @Cast("Nd4jLong") long n);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               FloatBuffer x,
                               @Cast("Nd4jLong") long xStride,
                               FloatBuffer result,
                               @Cast("Nd4jLong") long resultStride,
                               float scalar,
                               FloatBuffer extraParams,
                               @Cast("Nd4jLong") long n);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               float[] x,
                               @Cast("Nd4jLong") long xStride,
                               float[] result,
                               @Cast("Nd4jLong") long resultStride,
                               float scalar,
                               float[] extraParams,
                               @Cast("Nd4jLong") long n);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xStride
     * @param result
     * @param resultStride
     * @param scalar
     * @param extraParams
     * @param n
     */
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortPointer x,
                              @Cast("Nd4jLong") long xStride,
                              @Cast("float16*") ShortPointer result,
                              @Cast("Nd4jLong") long resultStride,
                              float scalar,
                              @Cast("float16*") ShortPointer extraParams,
                              @Cast("Nd4jLong") long n);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") ShortBuffer x,
                              @Cast("Nd4jLong") long xStride,
                              @Cast("float16*") ShortBuffer result,
                              @Cast("Nd4jLong") long resultStride,
                              float scalar,
                              @Cast("float16*") ShortBuffer extraParams,
                              @Cast("Nd4jLong") long n);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("float16*") short[] x,
                              @Cast("Nd4jLong") long xStride,
                              @Cast("float16*") short[] result,
                              @Cast("Nd4jLong") long resultStride,
                              float scalar,
                              @Cast("float16*") short[] extraParams,
                              @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param scalar
     * @param extraParams
     * @param n
     */
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             FloatPointer x,
                             @Cast("Nd4jLong*") LongPointer xShapeInfo,
                             FloatPointer result,
                             @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                             float scalar,
                             FloatPointer extraParams);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             FloatBuffer x,
                             @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                             FloatBuffer result,
                             @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                             float scalar,
                             FloatBuffer extraParams);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             float[] x,
                             @Cast("Nd4jLong*") long[] xShapeInfo,
                             float[] result,
                             @Cast("Nd4jLong*") long[] resultShapeInfo,
                             float scalar,
                             float[] extraParams);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param scalar
     * @param extraParams
     */
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("float16*") ShortPointer x,
                            @Cast("Nd4jLong*") LongPointer xShapeInfo,
                            @Cast("float16*") ShortPointer result,
                            @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                            float scalar,
                            @Cast("float16*") ShortPointer extraParams);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("float16*") ShortBuffer x,
                            @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                            @Cast("float16*") ShortBuffer result,
                            @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                            float scalar,
                            @Cast("float16*") ShortBuffer extraParams);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("float16*") short[] x,
                            @Cast("Nd4jLong*") long[] xShapeInfo,
                            @Cast("float16*") short[] result,
                            @Cast("Nd4jLong*") long[] resultShapeInfo,
                            float scalar,
                            @Cast("float16*") short[] extraParams);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param scalar
     * @param extraParams
     * @param n
     * @param xIndexes
     * @param resultIndexes
     */
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             FloatPointer x,
                             @Cast("Nd4jLong*") LongPointer xShapeInfo,
                             FloatPointer result,
                             @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                             float scalar,
                             FloatPointer extraParams,
                             @Cast("Nd4jLong*") LongPointer xIndexes,
                             @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             FloatBuffer x,
                             @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                             FloatBuffer result,
                             @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                             float scalar,
                             FloatBuffer extraParams,
                             @Cast("Nd4jLong*") LongBuffer xIndexes,
                             @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             float[] x,
                             @Cast("Nd4jLong*") long[] xShapeInfo,
                             float[] result,
                             @Cast("Nd4jLong*") long[] resultShapeInfo,
                             float scalar,
                             float[] extraParams,
                             @Cast("Nd4jLong*") long[] xIndexes,
                             @Cast("Nd4jLong*") long[] resultIndexes);


    /*
     * Special case: scalarOp alang dimension
     */
    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param scalars
     * @param extraParams
     * @param dimension
     * @param dimensionLength
     */
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                             FloatPointer x,
                             @Cast("Nd4jLong*") LongPointer xShapeInfo,
                             FloatPointer z,
                             @Cast("Nd4jLong*") LongPointer zShapeInfo,
                             FloatPointer scalars,
                             FloatPointer extraParams,
                             IntPointer dimension,
                             int dimensionLength);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                             FloatBuffer x,
                             @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                             FloatBuffer z,
                             @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                             FloatBuffer scalars,
                             FloatBuffer extraParams,
                             IntBuffer dimension,
                             int dimensionLength);
    public native void execScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                             float[] x,
                             @Cast("Nd4jLong*") long[] xShapeInfo,
                             float[] z,
                             @Cast("Nd4jLong*") long[] zShapeInfo,
                             float[] scalars,
                             float[] extraParams,
                             int[] dimension,
                             int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param scalars
     * @param extraParams
     * @param dimension
     * @param dimensionLength
     */
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                              DoublePointer x,
                              @Cast("Nd4jLong*") LongPointer xShapeInfo,
                              DoublePointer z,
                              @Cast("Nd4jLong*") LongPointer zShapeInfo,
                              DoublePointer scalars,
                              DoublePointer extraParams,
                              IntPointer dimension,
                              int dimensionLength);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                              DoubleBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                              DoubleBuffer z,
                              @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                              DoubleBuffer scalars,
                              DoubleBuffer extraParams,
                              IntBuffer dimension,
                              int dimensionLength);
    public native void execScalarDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                              double[] x,
                              @Cast("Nd4jLong*") long[] xShapeInfo,
                              double[] z,
                              @Cast("Nd4jLong*") long[] zShapeInfo,
                              double[] scalars,
                              double[] extraParams,
                              int[] dimension,
                              int dimensionLength);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param scalars
     * @param extraParams
     * @param dimension
     * @param dimensionLength
     */
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                            @Cast("float16*") ShortPointer x,
                            @Cast("Nd4jLong*") LongPointer xShapeInfo,
                            @Cast("float16*") ShortPointer z,
                            @Cast("Nd4jLong*") LongPointer zShapeInfo,
                            @Cast("float16*") ShortPointer scalars,
                            @Cast("float16*") ShortPointer extraParams,
                            IntPointer dimension,
                            int dimensionLength);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                            @Cast("float16*") ShortBuffer x,
                            @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                            @Cast("float16*") ShortBuffer z,
                            @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                            @Cast("float16*") ShortBuffer scalars,
                            @Cast("float16*") ShortBuffer extraParams,
                            IntBuffer dimension,
                            int dimensionLength);
    public native void execScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                            @Cast("float16*") short[] x,
                            @Cast("Nd4jLong*") long[] xShapeInfo,
                            @Cast("float16*") short[] z,
                            @Cast("Nd4jLong*") long[] zShapeInfo,
                            @Cast("float16*") short[] scalars,
                            @Cast("float16*") short[] extraParams,
                            int[] dimension,
                            int dimensionLength);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     */
    public native float execSummaryStatsScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,FloatPointer x,
                                            @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                            FloatPointer extraParams, @Cast("bool") boolean biasCorrected);
    public native float execSummaryStatsScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,FloatBuffer x,
                                            @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                            FloatBuffer extraParams, @Cast("bool") boolean biasCorrected);
    public native float execSummaryStatsScalarFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,float[] x,
                                            @Cast("Nd4jLong*") long[] xShapeInfo,
                                            float[] extraParams, @Cast("bool") boolean biasCorrected);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param biasCorrected
     * @return
     */
    public native float execSummaryStatsScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           @Cast("float16*") ShortPointer x,
                                           @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                           @Cast("float16*") ShortPointer extraParams,
                                           @Cast("bool") boolean biasCorrected);
    public native float execSummaryStatsScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           @Cast("float16*") ShortBuffer x,
                                           @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                           @Cast("float16*") ShortBuffer extraParams,
                                           @Cast("bool") boolean biasCorrected);
    public native float execSummaryStatsScalarHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                           int opNum,
                                           @Cast("float16*") short[] x,
                                           @Cast("Nd4jLong*") long[] xShapeInfo,
                                           @Cast("float16*") short[] extraParams,
                                           @Cast("bool") boolean biasCorrected);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     */
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     FloatPointer x,
                                     @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                     FloatPointer extraParams,
                                     FloatPointer result,
                                     @Cast("Nd4jLong*") LongPointer resultShapeInfo,@Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     FloatBuffer x,
                                     @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                     FloatBuffer extraParams,
                                     FloatBuffer result,
                                     @Cast("Nd4jLong*") LongBuffer resultShapeInfo,@Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,int opNum,
                                     float[] x,
                                     @Cast("Nd4jLong*") long[] xShapeInfo,
                                     float[] extraParams,
                                     float[] result,
                                     @Cast("Nd4jLong*") long[] resultShapeInfo,@Cast("bool") boolean biasCorrected);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfo
     * @param biasCorrected
     */
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") ShortPointer x,
                                    @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                    @Cast("float16*") ShortPointer extraParams,
                                    @Cast("float16*") ShortPointer result,
                                    @Cast("Nd4jLong*") LongPointer resultShapeInfo,@Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") ShortBuffer x,
                                    @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                    @Cast("float16*") ShortBuffer extraParams,
                                    @Cast("float16*") ShortBuffer result,
                                    @Cast("Nd4jLong*") LongBuffer resultShapeInfo,@Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") short[] x,
                                    @Cast("Nd4jLong*") long[] xShapeInfo,
                                    @Cast("float16*") short[] extraParams,
                                    @Cast("float16*") short[] result,
                                    @Cast("Nd4jLong*") long[] resultShapeInfo,@Cast("bool") boolean biasCorrected);

    /**
     *
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     */
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     FloatPointer x,
                                     @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                     FloatPointer extraParams,
                                     FloatPointer result,
                                     @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                     IntPointer dimension,
                                     int dimensionLength,
                                     @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     FloatBuffer x,
                                     @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                     FloatBuffer extraParams,
                                     FloatBuffer result,
                                     @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                     IntBuffer dimension,
                                     int dimensionLength,
                                     @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     float[] x,
                                     @Cast("Nd4jLong*") long[] xShapeInfo,
                                     float[] extraParams,
                                     float[] result,
                                     @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                     int[] dimension,
                                     int dimensionLength,
                                     @Cast("bool") boolean biasCorrected);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param x
     * @param xShapeInfo
     * @param extraParams
     * @param result
     * @param resultShapeInfoBuffer
     * @param dimension
     * @param dimensionLength
     * @param biasCorrected
     */
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") ShortPointer x,
                                    @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                    @Cast("float16*") ShortPointer extraParams,
                                    @Cast("float16*") ShortPointer result,
                                    @Cast("Nd4jLong*") LongPointer resultShapeInfoBuffer,
                                    IntPointer dimension,
                                    int dimensionLength,
                                    @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") ShortBuffer x,
                                    @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                    @Cast("float16*") ShortBuffer extraParams,
                                    @Cast("float16*") ShortBuffer result,
                                    @Cast("Nd4jLong*") LongBuffer resultShapeInfoBuffer,
                                    IntBuffer dimension,
                                    int dimensionLength,
                                    @Cast("bool") boolean biasCorrected);
    public native void execSummaryStatsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    @Cast("float16*") short[] x,
                                    @Cast("Nd4jLong*") long[] xShapeInfo,
                                    @Cast("float16*") short[] extraParams,
                                    @Cast("float16*") short[] result,
                                    @Cast("Nd4jLong*") long[] resultShapeInfoBuffer,
                                    int[] dimension,
                                    int dimensionLength,
                                    @Cast("bool") boolean biasCorrected);

    /**
     *
     * @param opNum
     * @param dx
     * @param xStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatPointer dx,
                                  @Cast("Nd4jLong") long xStride,
                                  FloatPointer result,
                                  @Cast("Nd4jLong") long resultStride,
                                  FloatPointer extraParams,
                                  @Cast("Nd4jLong") long n);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatBuffer dx,
                                  @Cast("Nd4jLong") long xStride,
                                  FloatBuffer result,
                                  @Cast("Nd4jLong") long resultStride,
                                  FloatBuffer extraParams,
                                  @Cast("Nd4jLong") long n);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  float[] dx,
                                  @Cast("Nd4jLong") long xStride,
                                  float[] result,
                                  @Cast("Nd4jLong") long resultStride,
                                  float[] extraParams,
                                  @Cast("Nd4jLong") long n);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xStride
     * @param result
     * @param resultStride
     * @param extraParams
     * @param n
     */
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortPointer dx,
                                 @Cast("Nd4jLong") long xStride,
                                 @Cast("float16*") ShortPointer result,
                                 @Cast("Nd4jLong") long resultStride,
                                 @Cast("float16*") ShortPointer extraParams,
                                 @Cast("Nd4jLong") long n);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortBuffer dx,
                                 @Cast("Nd4jLong") long xStride,
                                 @Cast("float16*") ShortBuffer result,
                                 @Cast("Nd4jLong") long resultStride,
                                 @Cast("float16*") ShortBuffer extraParams,
                                 @Cast("Nd4jLong") long n);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") short[] dx,
                                 @Cast("Nd4jLong") long xStride,
                                 @Cast("float16*") short[] result,
                                 @Cast("Nd4jLong") long resultStride,
                                 @Cast("float16*") short[] extraParams,
                                 @Cast("Nd4jLong") long n);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatPointer dx,
                                  @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                  FloatPointer result,
                                  @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                  FloatPointer extraParams);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatBuffer dx,
                                  @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                  FloatBuffer result,
                                  @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                  FloatBuffer extraParams);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  float[] dx,
                                  @Cast("Nd4jLong*") long[] xShapeInfo,
                                  float[] result,
                                  @Cast("Nd4jLong*") long[] resultShapeInfo,
                                  float[] extraParams);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     */
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortPointer dx,
                                 @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                 @Cast("float16*") ShortPointer result,
                                 @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                 @Cast("float16*") ShortPointer extraParams);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortBuffer dx,
                                 @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                 @Cast("float16*") ShortBuffer result,
                                 @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                 @Cast("float16*") ShortBuffer extraParams);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") short[] dx,
                                 @Cast("Nd4jLong*") long[] xShapeInfo,
                                 @Cast("float16*") short[] result,
                                 @Cast("Nd4jLong*") long[] resultShapeInfo,
                                 @Cast("float16*") short[] extraParams);

    /**
     *
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param n
     */
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatPointer dx,
                                  @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                  FloatPointer result,
                                  @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                  FloatPointer extraParams,
                                  @Cast("Nd4jLong*") LongPointer xIndexes,
                                  @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  FloatBuffer dx,
                                  @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                  FloatBuffer result,
                                  @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                  FloatBuffer extraParams,
                                  @Cast("Nd4jLong*") LongBuffer xIndexes,
                                  @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  float[] dx,
                                  @Cast("Nd4jLong*") long[] xShapeInfo,
                                  float[] result,
                                  @Cast("Nd4jLong*") long[] resultShapeInfo,
                                  float[] extraParams,
                                  @Cast("Nd4jLong*") long[] xIndexes,
                                  @Cast("Nd4jLong*") long[] resultIndexes);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param dx
     * @param xShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param extraParams
     * @param xIndexes
     * @param resultIndexes
     */
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortPointer dx,
                                 @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                 @Cast("float16*") ShortPointer result,
                                 @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                                 @Cast("float16*") ShortPointer extraParams,
                                 @Cast("Nd4jLong*") LongPointer xIndexes,
                                 @Cast("Nd4jLong*") LongPointer resultIndexes);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") ShortBuffer dx,
                                 @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                 @Cast("float16*") ShortBuffer result,
                                 @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                                 @Cast("float16*") ShortBuffer extraParams,
                                 @Cast("Nd4jLong*") LongBuffer xIndexes,
                                 @Cast("Nd4jLong*") LongBuffer resultIndexes);
    public native void execTransformHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("float16*") short[] dx,
                                 @Cast("Nd4jLong*") long[] xShapeInfo,
                                 @Cast("float16*") short[] result,
                                 @Cast("Nd4jLong*") long[] resultShapeInfo,
                                 @Cast("float16*") short[] extraParams,
                                 @Cast("Nd4jLong*") long[] xIndexes,
                                 @Cast("Nd4jLong*") long[] resultIndexes);


    /**
* Append an input array
* to the end of a flat array
* in a particular order
* @param offset the offset of the array to start at
* @param order the order
* @param result the result array
* @param resultShapeInfo the shape info for te array
* @param input the input for the array
* @param inputShapeInfo the shape information for that array
*/
    public native void flattenFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                FloatPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                FloatPointer input,
                @Cast("Nd4jLong*") LongPointer inputShapeInfo);
    public native void flattenFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                FloatBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                FloatBuffer input,
                @Cast("Nd4jLong*") LongBuffer inputShapeInfo);
    public native void flattenFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                float[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                float[] input,
                @Cast("Nd4jLong*") long[] inputShapeInfo);


    /**
     *
     * @param extraPointers
     * @param offset
     * @param order
     * @param result
     * @param resultShapeInfo
     * @param input
     * @param inputShapeInfo
     */
    public native void flattenHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                @Cast("float16*") ShortPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                @Cast("float16*") ShortPointer input,
                @Cast("Nd4jLong*") LongPointer inputShapeInfo);
    public native void flattenHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                @Cast("float16*") ShortBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                @Cast("float16*") ShortBuffer input,
                @Cast("Nd4jLong*") LongBuffer inputShapeInfo);
    public native void flattenHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                @Cast("float16*") short[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                @Cast("float16*") short[] input,
                @Cast("Nd4jLong*") long[] inputShapeInfo);

    /**
* Append an input array
* to the end of a flat array
* in a particular order
* @param offset the offset of the array to start at
* @param order the order
* @param result the result array
* @param resultShapeInfo the shape info for te array
* @param input the input for the array
* @param inputShapeInfo the shape information for that array
*/
    public native void flattenDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                DoublePointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                DoublePointer input,
                @Cast("Nd4jLong*") LongPointer inputShapeInfo);
    public native void flattenDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                DoubleBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                DoubleBuffer input,
                @Cast("Nd4jLong*") LongBuffer inputShapeInfo);
    public native void flattenDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int offset,
                char order,
                double[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                double[] input,
                @Cast("Nd4jLong*") long[] inputShapeInfo);

    /**
     * Concatneate multi array of the same shape together
     * along a particular dimension
     */
    public native void concatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                FloatPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                FloatBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                float[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
/**
    * Concatneate multi array of the same shape together
    * along a particular dimension
    */
    public native void concatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                DoublePointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                DoubleBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                double[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);

    /**
     *
     * @param extraPointers
     * @param dimension
     * @param numArrays
     * @param data
     * @param inputShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param tadPointers
     * @param offsetPointers
     */
    public native void concatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") ShortPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") ShortBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void concatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") short[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);


    public native void specialConcatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                FloatPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                FloatBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatFloat(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                float[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo, @Cast("Nd4jPointer*") PointerPointer tadPointers, @Cast("Nd4jPointer*") PointerPointer offsetPointers);
/**
    * Concatneate multi array of the same shape together
    * along a particular dimension
    */
    public native void specialConcatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                DoublePointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                DoubleBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatDouble(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                double[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);

    /**
     *
     * @param extraPointers
     * @param dimension
     * @param numArrays
     * @param data
     * @param inputShapeInfo
     * @param result
     * @param resultShapeInfo
     * @param tadPointers
     * @param offsetPointers
     */
    public native void specialConcatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") ShortPointer result,
                @Cast("Nd4jLong*") LongPointer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") ShortBuffer result,
                @Cast("Nd4jLong*") LongBuffer resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);
    public native void specialConcatHalf(
                @Cast("Nd4jPointer*") PointerPointer extraPointers,
                int dimension,
                int numArrays,
                @Cast("Nd4jPointer*") PointerPointer data,
                @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
                @Cast("float16*") short[] result,
                @Cast("Nd4jLong*") long[] resultShapeInfo,
                @Cast("Nd4jPointer*") PointerPointer tadPointers,
                @Cast("Nd4jPointer*") PointerPointer offsetPointers);

    /**
     * This method implementation exists only for cuda.
     * The other backends should have dummy method for JNI compatibility reasons.
     */
    public native void initializeDevicesAndFunctions();

    public native void initializeFunctions(@Cast("Nd4jPointer*") PointerPointer functions);

    /**
     * This method acquires memory chunk of requested size on host side
     *
     * @param pointer pointer that'll be used for allocation
     * @param memorySize memory size, in bytes
     * @param flags optional parameter
     */
    public native @Cast("Nd4jPointer") Pointer mallocHost(@Cast("Nd4jLong") long memorySize, int flags);

    /**
     * This method acquires memory chunk of requested size on specified device
     *
     * @param pointer pointer that'll be used for allocation
     * @param memorySize memory size, in bytes
     * @param ptrToDeviceId pointer to deviceId. For cuda that's just and int, for OpenCL that's pointer to device_id, etc
     * @param flags optional parameter
     */
    public native @Cast("Nd4jPointer") Pointer mallocDevice(@Cast("Nd4jLong") long memorySize, @Cast("Nd4jPointer") Pointer ptrToDeviceId, int flags);

    /**
     * This method releases previously allocated host memory space
     *
     * @param pointer pointer that'll be freed
     */
    public native int freeHost(@Cast("Nd4jPointer") Pointer pointer);

    /**
     * This method releases previously allocated memory space on device
     *
     * @param pointer pointer that'll be freed
     * @param ptrToDeviceId pointer to deviceId.
     */
    public native int freeDevice(@Cast("Nd4jPointer") Pointer pointer, @Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @return
     */
    public native int ompGetMaxThreads();

    /**
     *
     * @return
     */
    public native int ompGetNumThreads();

    /**
     *
     * @param threads
     */
    public native void setOmpNumThreads(int threads);

    /**
     *
     * @param threads
     */
    public native void setOmpMinThreads(int threads);




    /**
     *
     * @return
     */
    public native @Cast("Nd4jPointer") Pointer createContext();

    /**
     *
     * @return
     */
    public native @Cast("Nd4jPointer") Pointer createStream();

    /**
     *
     * @return
     */
    public native @Cast("Nd4jPointer") Pointer createEvent();

    /**
     *
     * @param event
     * @param stream
     * @return
     */
    public native int registerEvent(@Cast("Nd4jPointer") Pointer event, @Cast("Nd4jPointer") Pointer stream);

    /**
     *
     * @param event
     * @return
     */
    public native int destroyEvent(@Cast("Nd4jPointer") Pointer event);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native int setDevice(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @return
     */
    public native int getDevice();

    /**
     *
     * @param stream
     * @return
     */
    public native int streamSynchronize(@Cast("Nd4jPointer") Pointer stream);

    /**
     *
     * @param event
     * @return
     */
    public native int eventSynchronize(@Cast("Nd4jPointer") Pointer event);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native @Cast("Nd4jLong") long getDeviceFreeMemory(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native @Cast("Nd4jLong") long getDeviceTotalMemory(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native int getDeviceMajor(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native int getDeviceMinor(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @param ptrToDeviceId
     * @return
     */
    public native @Cast("char*") String getDeviceName(@Cast("Nd4jPointer") Pointer ptrToDeviceId);

    /**
     *
     * @param dst
     * @param src
     * @param size
     * @param flags
     * @param reserved
     * @return
     */
    public native int memcpy(@Cast("Nd4jPointer") Pointer dst,
                   @Cast("Nd4jPointer") Pointer src,
                   @Cast("Nd4jLong") long size,
                   int flags,
                   @Cast("Nd4jPointer") Pointer reserved);

    /**
     *
     * @param dst
     * @param src
     * @param size
     * @param flags
     * @param reserved
     * @return
     */
    public native int memcpyAsync(@Cast("Nd4jPointer") Pointer dst,
                        @Cast("Nd4jPointer") Pointer src,
                        @Cast("Nd4jLong") long size,
                        int flags,
                        @Cast("Nd4jPointer") Pointer reserved);

    /**
     *
     * @param dst
     * @param value
     * @param size
     * @param flags
     * @param reserved
     * @return
     */
    public native int memset(@Cast("Nd4jPointer") Pointer dst,
                   int value,
                   @Cast("Nd4jLong") long size,
                   int flags,
                   @Cast("Nd4jPointer") Pointer reserved);

    /**
     *
     * @param dst
     * @param value
     * @param size
     * @param flags
     * @param reserved
     * @return
     */
    public native int memsetAsync(@Cast("Nd4jPointer") Pointer dst,
                        int value,
                        @Cast("Nd4jLong") long size,
                        int flags,
                        @Cast("Nd4jPointer") Pointer reserved);

    /**
     *
     * @param dst
     * @param src
     * @param size
     * @param flags
     * @param reserved
     * @return
     */
    public native int memcpyConstantAsync(@Cast("Nd4jLong") long dst,
                                @Cast("Nd4jPointer") Pointer src,
                                @Cast("Nd4jLong") long size,
                                int flags,
                                @Cast("Nd4jPointer") Pointer reserved);

    /**
     *
     * @return
     */
    public native @Cast("Nd4jPointer") Pointer getConstantSpace();

    /**
     *
     * @return
     */
    public native int getAvailableDevices();

    /**
     *
     * @param reallyEnable
     */
    public native void enableDebugMode(@Cast("bool") boolean reallyEnable);

    /**
     *
     * @param reallyEnable
     */
    public native void enableVerboseMode(@Cast("bool") boolean reallyEnable);

    /**
     *
     * @param gridSize
     */
    public native void setGridLimit(int gridSize);

    /**
     *
     * @param xShapeInfo
     * @param dimension
     * @param dimensionLength
     * @param targetBuffer
     * @param offsetsBuffer
     */
    public native void tadOnlyShapeInfo(@Cast("Nd4jLong*") LongPointer xShapeInfo,
                              IntPointer dimension,
                              int dimensionLength,
                              @Cast("Nd4jLong*") LongPointer targetBuffer,
                              @Cast("Nd4jLong*") LongPointer offsetsBuffer);
    public native void tadOnlyShapeInfo(@Cast("Nd4jLong*") LongBuffer xShapeInfo,
                              IntBuffer dimension,
                              int dimensionLength,
                              @Cast("Nd4jLong*") LongBuffer targetBuffer,
                              @Cast("Nd4jLong*") LongBuffer offsetsBuffer);
    public native void tadOnlyShapeInfo(@Cast("Nd4jLong*") long[] xShapeInfo,
                              int[] dimension,
                              int dimensionLength,
                              @Cast("Nd4jLong*") long[] targetBuffer,
                              @Cast("Nd4jLong*") long[] offsetsBuffer);

    /*
     * PullRow special op
     */

    /**
     *
     * @param extraPointers
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param n
     * @param indexes
     * @param tadShapeInfo
     * @param tadOffsets
     * @param zTadShapeInfo
     * @param zTadOffsets
     */
    public native void pullRowsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          @Cast("float16*") ShortPointer x,
                          @Cast("Nd4jLong*") LongPointer xShapeInfo,
                          @Cast("float16*") ShortPointer z,
                          @Cast("Nd4jLong*") LongPointer zShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") LongPointer indexes,
                          @Cast("Nd4jLong*") LongPointer tadShapeInfo,
                          @Cast("Nd4jLong*") LongPointer tadOffsets,
                          @Cast("Nd4jLong*") LongPointer zTadShapeInfo,
                          @Cast("Nd4jLong*") LongPointer zTadOffsets);
    public native void pullRowsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          @Cast("float16*") ShortBuffer x,
                          @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                          @Cast("float16*") ShortBuffer z,
                          @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") LongBuffer indexes,
                          @Cast("Nd4jLong*") LongBuffer tadShapeInfo,
                          @Cast("Nd4jLong*") LongBuffer tadOffsets,
                          @Cast("Nd4jLong*") LongBuffer zTadShapeInfo,
                          @Cast("Nd4jLong*") LongBuffer zTadOffsets);
    public native void pullRowsHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          @Cast("float16*") short[] x,
                          @Cast("Nd4jLong*") long[] xShapeInfo,
                          @Cast("float16*") short[] z,
                          @Cast("Nd4jLong*") long[] zShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") long[] indexes,
                          @Cast("Nd4jLong*") long[] tadShapeInfo,
                          @Cast("Nd4jLong*") long[] tadOffsets,
                          @Cast("Nd4jLong*") long[] zTadShapeInfo,
                          @Cast("Nd4jLong*") long[] zTadOffsets);

    /**
     *
     * @param extraPointers
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param n
     * @param indexes
     * @param tadShapeInfo
     * @param tadOffsets
     * @param zTadShapeInfo
     * @param zTadOffsets
     */
    public native void pullRowsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           FloatPointer x,
                           @Cast("Nd4jLong*") LongPointer xShapeInfo,
                           FloatPointer z,
                           @Cast("Nd4jLong*") LongPointer zShapeInfo,
                           @Cast("Nd4jLong") long n,
                           @Cast("Nd4jLong*") LongPointer indexes,
                           @Cast("Nd4jLong*") LongPointer tadShapeInfo,
                           @Cast("Nd4jLong*") LongPointer tadOffsets,
                           @Cast("Nd4jLong*") LongPointer zTadShapeInfo,
                           @Cast("Nd4jLong*") LongPointer zTadOffsets);
    public native void pullRowsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           FloatBuffer x,
                           @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                           FloatBuffer z,
                           @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                           @Cast("Nd4jLong") long n,
                           @Cast("Nd4jLong*") LongBuffer indexes,
                           @Cast("Nd4jLong*") LongBuffer tadShapeInfo,
                           @Cast("Nd4jLong*") LongBuffer tadOffsets,
                           @Cast("Nd4jLong*") LongBuffer zTadShapeInfo,
                           @Cast("Nd4jLong*") LongBuffer zTadOffsets);
    public native void pullRowsFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           float[] x,
                           @Cast("Nd4jLong*") long[] xShapeInfo,
                           float[] z,
                           @Cast("Nd4jLong*") long[] zShapeInfo,
                           @Cast("Nd4jLong") long n,
                           @Cast("Nd4jLong*") long[] indexes,
                           @Cast("Nd4jLong*") long[] tadShapeInfo,
                           @Cast("Nd4jLong*") long[] tadOffsets,
                           @Cast("Nd4jLong*") long[] zTadShapeInfo,
                           @Cast("Nd4jLong*") long[] zTadOffsets);

    /**
     *
     * @param extraPointers
     * @param x
     * @param xShapeInfo
     * @param z
     * @param zShapeInfo
     * @param n
     * @param indexes
     * @param tadShapeInfo
     * @param tadOffsets
     * @param zTadShapeInfo
     * @param zTadOffsets
     */
    public native void pullRowsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            DoublePointer x,
                            @Cast("Nd4jLong*") LongPointer xShapeInfo,
                            DoublePointer z,
                            @Cast("Nd4jLong*") LongPointer zShapeInfo,
                            @Cast("Nd4jLong") long n,
                            @Cast("Nd4jLong*") LongPointer indexes,
                            @Cast("Nd4jLong*") LongPointer tadShapeInfo,
                            @Cast("Nd4jLong*") LongPointer tadOffsets,
                            @Cast("Nd4jLong*") LongPointer zTadShapeInfo,
                            @Cast("Nd4jLong*") LongPointer zTadOffsets);
    public native void pullRowsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            DoubleBuffer x,
                            @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                            DoubleBuffer z,
                            @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                            @Cast("Nd4jLong") long n,
                            @Cast("Nd4jLong*") LongBuffer indexes,
                            @Cast("Nd4jLong*") LongBuffer tadShapeInfo,
                            @Cast("Nd4jLong*") LongBuffer tadOffsets,
                            @Cast("Nd4jLong*") LongBuffer zTadShapeInfo,
                            @Cast("Nd4jLong*") LongBuffer zTadOffsets);
    public native void pullRowsDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            double[] x,
                            @Cast("Nd4jLong*") long[] xShapeInfo,
                            double[] z,
                            @Cast("Nd4jLong*") long[] zShapeInfo,
                            @Cast("Nd4jLong") long n,
                            @Cast("Nd4jLong*") long[] indexes,
                            @Cast("Nd4jLong*") long[] tadShapeInfo,
                            @Cast("Nd4jLong*") long[] tadOffsets,
                            @Cast("Nd4jLong*") long[] zTadShapeInfo,
                            @Cast("Nd4jLong*") long[] zTadOffsets);

    /**
     * Array averaging op
     */
    /**
     *
     * @param extras
     * @param dx
     * @param dz
     * @param n
     * @param length
     * @param propagate
     */
    public native void averageHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("float16*") ShortPointer dz,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);
    public native void averageHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("float16*") ShortBuffer dz,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);
    public native void averageHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("float16*") short[] dz,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);

    /**
     *
     * @param extras
     * @param dx
     * @param dz
     * @param n
     * @param length
     * @param propagate
     */
    public native void averageFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          FloatPointer dz,
                          int n,
                          @Cast("Nd4jLong") long length,
                          @Cast("bool") boolean propagate);
    public native void averageFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          FloatBuffer dz,
                          int n,
                          @Cast("Nd4jLong") long length,
                          @Cast("bool") boolean propagate);
    public native void averageFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          float[] dz,
                          int n,
                          @Cast("Nd4jLong") long length,
                          @Cast("bool") boolean propagate);

    /**
     *
     * @param extras
     * @param dx
     * @param dz
     * @param n
     * @param length
     * @param propagate
     */
    public native void averageDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           DoublePointer dz,
                           int n,
                           @Cast("Nd4jLong") long length,
                           @Cast("bool") boolean propagate);
    public native void averageDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           DoubleBuffer dz,
                           int n,
                           @Cast("Nd4jLong") long length,
                           @Cast("bool") boolean propagate);
    public native void averageDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           double[] dz,
                           int n,
                           @Cast("Nd4jLong") long length,
                           @Cast("bool") boolean propagate);


    public native void accumulateHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              @Cast("float16*") ShortPointer dz,
                              int n,
                              @Cast("Nd4jLong") long length);
    public native void accumulateHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              @Cast("float16*") ShortBuffer dz,
                              int n,
                              @Cast("Nd4jLong") long length);
    public native void accumulateHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              @Cast("float16*") short[] dz,
                              int n,
                              @Cast("Nd4jLong") long length);


    public native void accumulateFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              FloatPointer dz,
                              int n,
                              @Cast("Nd4jLong") long length);
    public native void accumulateFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              FloatBuffer dz,
                              int n,
                              @Cast("Nd4jLong") long length);
    public native void accumulateFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                              @Cast("Nd4jPointer*") PointerPointer dx,
                              float[] dz,
                              int n,
                              @Cast("Nd4jLong") long length);

    public native void accumulateDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           DoublePointer dz,
                           int n,
                           @Cast("Nd4jLong") long length);
    public native void accumulateDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           DoubleBuffer dz,
                           int n,
                           @Cast("Nd4jLong") long length);
    public native void accumulateDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           double[] dz,
                           int n,
                           @Cast("Nd4jLong") long length);


    /**
     * P2P enabler
     */
    /**
     *
     * @param enable
     */
    public native void enableP2P(@Cast("bool") boolean enable);

    /**
     *
     */
    public native void checkP2P();

    /**
     *
     * @return
     */
    public native @Cast("bool") boolean isP2PAvailable();

    /**
     * Shuffle methods
     */

    /**
     *
     * @param extras
     * @param dx
     * @param xShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param N
     * @param shuffleMap
     * @param tadShapeInfo
     * @param tadOffsets
     */
    public native void shuffleDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer dz,
                           @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                           int N,
                           IntPointer shuffleMap,
                           @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer dz,
                           @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                           int N,
                           IntBuffer shuffleMap,
                           @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                           @Cast("Nd4jPointer*") PointerPointer dx,
                           @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer dz,
                           @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                           int N,
                           int[] shuffleMap,
                           @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                           @Cast("Nd4jPointer*") PointerPointer tadOffsets);

    /**
     *
     * @param extras
     * @param dx
     * @param xShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param N
     * @param shuffleMap
     * @param tadShapeInfo
     * @param tadOffsets
     */
    public native void shuffleFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer dz,
                          @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                          int N,
                          IntPointer shuffleMap,
                          @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer dz,
                          @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                          int N,
                          IntBuffer shuffleMap,
                          @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                          @Cast("Nd4jPointer*") PointerPointer dx,
                          @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer dz,
                          @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                          int N,
                          int[] shuffleMap,
                          @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                          @Cast("Nd4jPointer*") PointerPointer tadOffsets);


    /**
     *
     * @param extras
     * @param dx
     * @param xShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param N
     * @param shuffleMap
     * @param tadShapeInfo
     * @param tadOffsets
     */
    public native void shuffleHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz,
                         @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         int N,
                         IntPointer shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz,
                         @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         int N,
                         IntBuffer shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);
    public native void shuffleHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer dx,
                         @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz,
                         @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         int N,
                         int[] shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);

    /**
     * Type Conversions
     */

    /**
     *
     * @param extras
     * @param srcType
     * @param x
     * @param N
     * @param dstType
     * @param z
     */
    public native void convertTypes(@Cast("Nd4jPointer*") PointerPointer extras, int srcType, @Cast("Nd4jPointer") Pointer x, @Cast("Nd4jLong") long N, int dstType, @Cast("Nd4jPointer") Pointer z);


    /**
     *
     * @return
     */
    public native @Cast("bool") boolean isExperimentalEnabled();

    /**
     * Aggregate
     */

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param arguments
     * @param numArguments
     * @param shapeArguments
     * @param numShapeArguments
     * @param indexArguments
     * @param numIndexArguments
     * @param intArrays
     * @param numIntArrays
     * @param realArguments
     * @param numRealArguments
     */
    public native void execAggregateFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                @Cast("float**") PointerPointer arguments,
                                int numArguments,
                                @Cast("Nd4jLong**") PointerPointer shapeArguments,
                                int numShapeArguments,
                                IntPointer indexArguments,
                                int numIndexArguments,
                                @Cast("int**") PointerPointer intArrays,
                                int numIntArrays,
                                FloatPointer realArguments,
                                int numRealArguments);
    public native void execAggregateFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                @ByPtrPtr FloatPointer arguments,
                                int numArguments,
                                @Cast("Nd4jLong**") @ByPtrPtr LongPointer shapeArguments,
                                int numShapeArguments,
                                IntPointer indexArguments,
                                int numIndexArguments,
                                @ByPtrPtr IntPointer intArrays,
                                int numIntArrays,
                                FloatPointer realArguments,
                                int numRealArguments);
    public native void execAggregateFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                @ByPtrPtr FloatBuffer arguments,
                                int numArguments,
                                @Cast("Nd4jLong**") @ByPtrPtr LongBuffer shapeArguments,
                                int numShapeArguments,
                                IntBuffer indexArguments,
                                int numIndexArguments,
                                @ByPtrPtr IntBuffer intArrays,
                                int numIntArrays,
                                FloatBuffer realArguments,
                                int numRealArguments);
    public native void execAggregateFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                @ByPtrPtr float[] arguments,
                                int numArguments,
                                @Cast("Nd4jLong**") @ByPtrPtr long[] shapeArguments,
                                int numShapeArguments,
                                int[] indexArguments,
                                int numIndexArguments,
                                @ByPtrPtr int[] intArrays,
                                int numIntArrays,
                                float[] realArguments,
                                int numRealArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param arguments
     * @param numArguments
     * @param shapeArguments
     * @param numShapeArguments
     * @param indexArguments
     * @param numIndexArguments
     * @param intArrays
     * @param numIntArrays
     * @param realArguments
     * @param numRealArguments
     */
    public native void execAggregateDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @Cast("double**") PointerPointer arguments,
                                 int numArguments,
                                 @Cast("Nd4jLong**") PointerPointer shapeArguments,
                                 int numShapeArguments,
                                 IntPointer indexArguments,
                                 int numIndexArguments,
                                 @Cast("int**") PointerPointer intArrays,
                                 int numIntArrays,
                                 DoublePointer realArguments,
                                 int numRealArguments);
    public native void execAggregateDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @ByPtrPtr DoublePointer arguments,
                                 int numArguments,
                                 @Cast("Nd4jLong**") @ByPtrPtr LongPointer shapeArguments,
                                 int numShapeArguments,
                                 IntPointer indexArguments,
                                 int numIndexArguments,
                                 @ByPtrPtr IntPointer intArrays,
                                 int numIntArrays,
                                 DoublePointer realArguments,
                                 int numRealArguments);
    public native void execAggregateDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @ByPtrPtr DoubleBuffer arguments,
                                 int numArguments,
                                 @Cast("Nd4jLong**") @ByPtrPtr LongBuffer shapeArguments,
                                 int numShapeArguments,
                                 IntBuffer indexArguments,
                                 int numIndexArguments,
                                 @ByPtrPtr IntBuffer intArrays,
                                 int numIntArrays,
                                 DoubleBuffer realArguments,
                                 int numRealArguments);
    public native void execAggregateDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 @ByPtrPtr double[] arguments,
                                 int numArguments,
                                 @Cast("Nd4jLong**") @ByPtrPtr long[] shapeArguments,
                                 int numShapeArguments,
                                 int[] indexArguments,
                                 int numIndexArguments,
                                 @ByPtrPtr int[] intArrays,
                                 int numIntArrays,
                                 double[] realArguments,
                                 int numRealArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param arguments
     * @param numArguments
     * @param shapeArguments
     * @param numShapeArguments
     * @param indexArguments
     * @param numIndexArguments
     * @param intArrays
     * @param numIntArrays
     * @param realArguments
     * @param numRealArguments
     */
    public native void execAggregateHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16**") PointerPointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") PointerPointer shapeArguments,
                               int numShapeArguments,
                               IntPointer indexArguments,
                               int numIndexArguments,
                               @Cast("int**") PointerPointer intArrays,
                               int numIntArrays,
                               @Cast("float16*") ShortPointer realArguments,
                               int numRealArguments);
    public native void execAggregateHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16**") @ByPtrPtr ShortPointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr LongPointer shapeArguments,
                               int numShapeArguments,
                               IntPointer indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr IntPointer intArrays,
                               int numIntArrays,
                               @Cast("float16*") ShortPointer realArguments,
                               int numRealArguments);
    public native void execAggregateHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16**") @ByPtrPtr ShortBuffer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr LongBuffer shapeArguments,
                               int numShapeArguments,
                               IntBuffer indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr IntBuffer intArrays,
                               int numIntArrays,
                               @Cast("float16*") ShortBuffer realArguments,
                               int numRealArguments);
    public native void execAggregateHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("float16**") @ByPtrPtr short[] arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr long[] shapeArguments,
                               int numShapeArguments,
                               int[] indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr int[] intArrays,
                               int numIntArrays,
                               @Cast("float16*") short[] realArguments,
                               int numRealArguments);


    /**
     *
     * @param extraPointers
     * @param numAggregates
     * @param opNum
     * @param maxArgs
     * @param maxShapes
     * @param maxIntArrays
     * @param maxIntArraySize
     * @param maxIdx
     * @param maxReals
     * @param ptrToArguments
     */
    public native void execAggregateBatchFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int numAggregates,
                                     int opNum,
                                     int maxArgs,
                                     int maxShapes,
                                     int maxIntArrays,
                                     int maxIntArraySize,
                                     int maxIdx,
                                     int maxReals,
                                     Pointer ptrToArguments);

    /**
     *
     * @param extraPointers
     * @param numAggregates
     * @param opNum
     * @param maxArgs
     * @param maxShapes
     * @param maxIntArrays
     * @param maxIntArraySize
     * @param maxIdx
     * @param maxReals
     * @param ptrToArguments
     */
    public native void execAggregateBatchDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                      int numAggregates,
                                      int opNum,
                                      int maxArgs,
                                      int maxShapes,
                                      int maxIntArrays,
                                      int maxIntArraySize,
                                      int maxIdx,
                                      int maxReals,
                                      Pointer ptrToArguments);

    /**
     *
     * @param extraPointers
     * @param numAggregates
     * @param opNum
     * @param maxArgs
     * @param maxShapes
     * @param maxIntArrays
     * @param maxIntArraySize
     * @param maxIdx
     * @param maxReals
     * @param ptrToArguments
     */
    public native void execAggregateBatchHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int numAggregates,
                                    int opNum,
                                    int maxArgs,
                                    int maxShapes,
                                    int maxIntArrays,
                                    int maxIntArraySize,
                                    int maxIdx,
                                    int maxReals,
                                    Pointer ptrToArguments);

    /**
     * Random operations
     */

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatPointer z,
                             @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                             FloatPointer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatBuffer z,
                             @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                             FloatBuffer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             float[] z,
                             @Cast("Nd4jLong*") long[] zShapeBuffer,
                             float[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param y
     * @param yShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatPointer x,
                             @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                             FloatPointer y,
                             @Cast("Nd4jLong*") LongPointer yShapeBuffer,
                             FloatPointer z,
                             @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                             FloatPointer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatBuffer x,
                             @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                             FloatBuffer y,
                             @Cast("Nd4jLong*") LongBuffer yShapeBuffer,
                             FloatBuffer z,
                             @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                             FloatBuffer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             float[] x,
                             @Cast("Nd4jLong*") long[] xShapeBuffer,
                             float[] y,
                             @Cast("Nd4jLong*") long[] yShapeBuffer,
                             float[] z,
                             @Cast("Nd4jLong*") long[] zShapeBuffer,
                             float[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatPointer x,
                             @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                             FloatPointer z,
                             @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                             FloatPointer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             FloatBuffer x,
                             @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                             FloatBuffer z,
                             @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                             FloatBuffer extraArguments);
    public native void execRandomFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             float[] x,
                             @Cast("Nd4jLong*") long[] xShapeBuffer,
                             float[] z,
                             @Cast("Nd4jLong*") long[] zShapeBuffer,
                             float[] extraArguments);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoublePointer z,
                              @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                              DoublePointer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoubleBuffer z,
                              @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                              DoubleBuffer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              double[] z,
                              @Cast("Nd4jLong*") long[] zShapeBuffer,
                              double[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param y
     * @param yShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoublePointer x,
                              @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                              DoublePointer y,
                              @Cast("Nd4jLong*") LongPointer yShapeBuffer,
                              DoublePointer z,
                              @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                              DoublePointer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoubleBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                              DoubleBuffer y,
                              @Cast("Nd4jLong*") LongBuffer yShapeBuffer,
                              DoubleBuffer z,
                              @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                              DoubleBuffer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              double[] x,
                              @Cast("Nd4jLong*") long[] xShapeBuffer,
                              double[] y,
                              @Cast("Nd4jLong*") long[] yShapeBuffer,
                              double[] z,
                              @Cast("Nd4jLong*") long[] zShapeBuffer,
                              double[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoublePointer x,
                              @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                              DoublePointer z,
                              @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                              DoublePointer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              DoubleBuffer x,
                              @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                              DoubleBuffer z,
                              @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                              DoubleBuffer extraArguments);
    public native void execRandomDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              @Cast("Nd4jPointer") Pointer state,
                              double[] x,
                              @Cast("Nd4jLong*") long[] xShapeBuffer,
                              double[] z,
                              @Cast("Nd4jLong*") long[] zShapeBuffer,
                              double[] extraArguments);


    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortPointer z,
                            @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                            @Cast("float16*") ShortPointer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortBuffer z,
                            @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                            @Cast("float16*") ShortBuffer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") short[] z,
                            @Cast("Nd4jLong*") long[] zShapeBuffer,
                            @Cast("float16*") short[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param y
     * @param yShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortPointer x,
                            @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                            @Cast("float16*") ShortPointer y,
                            @Cast("Nd4jLong*") LongPointer yShapeBuffer,
                            @Cast("float16*") ShortPointer z,
                            @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                            @Cast("float16*") ShortPointer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortBuffer x,
                            @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                            @Cast("float16*") ShortBuffer y,
                            @Cast("Nd4jLong*") LongBuffer yShapeBuffer,
                            @Cast("float16*") ShortBuffer z,
                            @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                            @Cast("float16*") ShortBuffer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") short[] x,
                            @Cast("Nd4jLong*") long[] xShapeBuffer,
                            @Cast("float16*") short[] y,
                            @Cast("Nd4jLong*") long[] yShapeBuffer,
                            @Cast("float16*") short[] z,
                            @Cast("Nd4jLong*") long[] zShapeBuffer,
                            @Cast("float16*") short[] extraArguments);

    /**
     *
     * @param extraPointers
     * @param opNum
     * @param state
     * @param x
     * @param xShapeBuffer
     * @param z
     * @param zShapeBuffer
     * @param extraArguments
     */
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortPointer x,
                            @Cast("Nd4jLong*") LongPointer xShapeBuffer,
                            @Cast("float16*") ShortPointer z,
                            @Cast("Nd4jLong*") LongPointer zShapeBuffer,
                            @Cast("float16*") ShortPointer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") ShortBuffer x,
                            @Cast("Nd4jLong*") LongBuffer xShapeBuffer,
                            @Cast("float16*") ShortBuffer z,
                            @Cast("Nd4jLong*") LongBuffer zShapeBuffer,
                            @Cast("float16*") ShortBuffer extraArguments);
    public native void execRandomHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            @Cast("float16*") short[] x,
                            @Cast("Nd4jLong*") long[] xShapeBuffer,
                            @Cast("float16*") short[] z,
                            @Cast("Nd4jLong*") long[] zShapeBuffer,
                            @Cast("float16*") short[] extraArguments);



    /**
     *
     * @param extraPointers
     * @param seed
     * @param bufferSize
     * @param ptrToBuffer
     * @return
     */
    public native @Cast("Nd4jPointer") Pointer initRandom(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               long seed,
                               long bufferSize,
                               @Cast("Nd4jPointer") Pointer ptrToBuffer);

    /**
     *
     * @param extraPointers
     * @param seed
     * @param ptrRandom
     */
    public native void refreshBuffer(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           long seed,
                           @Cast("Nd4jPointer") Pointer ptrRandom);

    /**
     *
     * @param extraPointers
     * @param seed
     * @param ptrRandom
     */
    public native void reSeedBuffer(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          long seed,
                          @Cast("Nd4jPointer") Pointer ptrRandom);

    /**
     *
     * @param ptrRandom
     */
    public native void destroyRandom(@Cast("Nd4jPointer") Pointer ptrRandom);

    /**
     * Grid operations
     */

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xStride
     * @param dy
     * @param yStride
     * @param dz
     * @param zStride
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateStridedFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                           int opTypeA,
                                           int opNumA,
                                           int opTypeB,
                                           int opNumB,
                                           @Cast("Nd4jLong") long N,
                                           FloatPointer dx,
                                           @Cast("Nd4jLong") long xStride,
                                           FloatPointer dy,
                                           @Cast("Nd4jLong") long yStride,
                                           FloatPointer dz,
                                           @Cast("Nd4jLong") long zStride,
                                           FloatPointer extraA,
                                           FloatPointer extraB,
                                           float scalarA,
                                           float scalarB);
    public native void execMetaPredicateStridedFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                           int opTypeA,
                                           int opNumA,
                                           int opTypeB,
                                           int opNumB,
                                           @Cast("Nd4jLong") long N,
                                           FloatBuffer dx,
                                           @Cast("Nd4jLong") long xStride,
                                           FloatBuffer dy,
                                           @Cast("Nd4jLong") long yStride,
                                           FloatBuffer dz,
                                           @Cast("Nd4jLong") long zStride,
                                           FloatBuffer extraA,
                                           FloatBuffer extraB,
                                           float scalarA,
                                           float scalarB);
    public native void execMetaPredicateStridedFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                           int opTypeA,
                                           int opNumA,
                                           int opTypeB,
                                           int opNumB,
                                           @Cast("Nd4jLong") long N,
                                           float[] dx,
                                           @Cast("Nd4jLong") long xStride,
                                           float[] dy,
                                           @Cast("Nd4jLong") long yStride,
                                           float[] dz,
                                           @Cast("Nd4jLong") long zStride,
                                           float[] extraA,
                                           float[] extraB,
                                           float scalarA,
                                           float scalarB);

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xShapeInfo
     * @param dy
     * @param yShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateShapeFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                         int opTypeA,
                                         int opNumA,
                                         int opTypeB,
                                         int opNumB,
                                         @Cast("Nd4jLong") long N,
                                         FloatPointer dx,
                                         @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                         FloatPointer dy,
                                         @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                         FloatPointer dz,
                                         @Cast("Nd4jLong*") LongPointer zShapeInfo,
                                         FloatPointer extraA,
                                         FloatPointer extraB,
                                         float scalarA,
                                         float scalarB);
    public native void execMetaPredicateShapeFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                         int opTypeA,
                                         int opNumA,
                                         int opTypeB,
                                         int opNumB,
                                         @Cast("Nd4jLong") long N,
                                         FloatBuffer dx,
                                         @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                         FloatBuffer dy,
                                         @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                         FloatBuffer dz,
                                         @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                                         FloatBuffer extraA,
                                         FloatBuffer extraB,
                                         float scalarA,
                                         float scalarB);
    public native void execMetaPredicateShapeFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                         int opTypeA,
                                         int opNumA,
                                         int opTypeB,
                                         int opNumB,
                                         @Cast("Nd4jLong") long N,
                                         float[] dx,
                                         @Cast("Nd4jLong*") long[] xShapeInfo,
                                         float[] dy,
                                         @Cast("Nd4jLong*") long[] yShapeInfo,
                                         float[] dz,
                                         @Cast("Nd4jLong*") long[] zShapeInfo,
                                         float[] extraA,
                                         float[] extraB,
                                         float scalarA,
                                         float scalarB);

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xStride
     * @param dy
     * @param yStride
     * @param dz
     * @param zStride
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateStridedDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                            int opTypeA,
                                            int opNumA,
                                            int opTypeB,
                                            int opNumB,
                                            @Cast("Nd4jLong") long N,
                                            DoublePointer dx,
                                            @Cast("Nd4jLong") long xStride,
                                            DoublePointer dy,
                                            @Cast("Nd4jLong") long yStride,
                                            DoublePointer dz,
                                            @Cast("Nd4jLong") long zStride,
                                            DoublePointer extraA,
                                            DoublePointer extraB,
                                            double scalarA,
                                            double scalarB);
    public native void execMetaPredicateStridedDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                            int opTypeA,
                                            int opNumA,
                                            int opTypeB,
                                            int opNumB,
                                            @Cast("Nd4jLong") long N,
                                            DoubleBuffer dx,
                                            @Cast("Nd4jLong") long xStride,
                                            DoubleBuffer dy,
                                            @Cast("Nd4jLong") long yStride,
                                            DoubleBuffer dz,
                                            @Cast("Nd4jLong") long zStride,
                                            DoubleBuffer extraA,
                                            DoubleBuffer extraB,
                                            double scalarA,
                                            double scalarB);
    public native void execMetaPredicateStridedDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                            int opTypeA,
                                            int opNumA,
                                            int opTypeB,
                                            int opNumB,
                                            @Cast("Nd4jLong") long N,
                                            double[] dx,
                                            @Cast("Nd4jLong") long xStride,
                                            double[] dy,
                                            @Cast("Nd4jLong") long yStride,
                                            double[] dz,
                                            @Cast("Nd4jLong") long zStride,
                                            double[] extraA,
                                            double[] extraB,
                                            double scalarA,
                                            double scalarB);

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xShapeInfo
     * @param dy
     * @param yShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateShapeDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          DoublePointer dx,
                                          @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                          DoublePointer dy,
                                          @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                          DoublePointer dz,
                                          @Cast("Nd4jLong*") LongPointer zShapeInfo,
                                          DoublePointer extraA,
                                          DoublePointer extraB,
                                          double scalarA,
                                          double scalarB);
    public native void execMetaPredicateShapeDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          DoubleBuffer dx,
                                          @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                          DoubleBuffer dy,
                                          @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                          DoubleBuffer dz,
                                          @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                                          DoubleBuffer extraA,
                                          DoubleBuffer extraB,
                                          double scalarA,
                                          double scalarB);
    public native void execMetaPredicateShapeDouble(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          double[] dx,
                                          @Cast("Nd4jLong*") long[] xShapeInfo,
                                          double[] dy,
                                          @Cast("Nd4jLong*") long[] yShapeInfo,
                                          double[] dz,
                                          @Cast("Nd4jLong*") long[] zShapeInfo,
                                          double[] extraA,
                                          double[] extraB,
                                          double scalarA,
                                          double scalarB);

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xStride
     * @param dy
     * @param yStride
     * @param dz
     * @param zStride
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateStridedHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          @Cast("float16*") ShortPointer dx,
                                          @Cast("Nd4jLong") long xStride,
                                          @Cast("float16*") ShortPointer dy,
                                          @Cast("Nd4jLong") long yStride,
                                          @Cast("float16*") ShortPointer dz,
                                          @Cast("Nd4jLong") long zStride,
                                          @Cast("float16*") ShortPointer extraA,
                                          @Cast("float16*") ShortPointer extraB,
                                          float scalarA,
                                          float scalarB);
    public native void execMetaPredicateStridedHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          @Cast("float16*") ShortBuffer dx,
                                          @Cast("Nd4jLong") long xStride,
                                          @Cast("float16*") ShortBuffer dy,
                                          @Cast("Nd4jLong") long yStride,
                                          @Cast("float16*") ShortBuffer dz,
                                          @Cast("Nd4jLong") long zStride,
                                          @Cast("float16*") ShortBuffer extraA,
                                          @Cast("float16*") ShortBuffer extraB,
                                          float scalarA,
                                          float scalarB);
    public native void execMetaPredicateStridedHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          @Cast("Nd4jLong") long N,
                                          @Cast("float16*") short[] dx,
                                          @Cast("Nd4jLong") long xStride,
                                          @Cast("float16*") short[] dy,
                                          @Cast("Nd4jLong") long yStride,
                                          @Cast("float16*") short[] dz,
                                          @Cast("Nd4jLong") long zStride,
                                          @Cast("float16*") short[] extraA,
                                          @Cast("float16*") short[] extraB,
                                          float scalarA,
                                          float scalarB);

    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param N
     * @param dx
     * @param xShapeInfo
     * @param dy
     * @param yShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     */
    public native void execMetaPredicateShapeHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                        int opTypeA,
                                        int opNumA,
                                        int opTypeB,
                                        int opNumB,
                                        @Cast("Nd4jLong") long N,
                                        @Cast("float16*") ShortPointer dx,
                                        @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                        @Cast("float16*") ShortPointer dy,
                                        @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                        @Cast("float16*") ShortPointer dz,
                                        @Cast("Nd4jLong*") LongPointer zShapeInfo,
                                        @Cast("float16*") ShortPointer extraA,
                                        @Cast("float16*") ShortPointer extraB,
                                        float scalarA,
                                        float scalarB);
    public native void execMetaPredicateShapeHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                        int opTypeA,
                                        int opNumA,
                                        int opTypeB,
                                        int opNumB,
                                        @Cast("Nd4jLong") long N,
                                        @Cast("float16*") ShortBuffer dx,
                                        @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                        @Cast("float16*") ShortBuffer dy,
                                        @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                        @Cast("float16*") ShortBuffer dz,
                                        @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                                        @Cast("float16*") ShortBuffer extraA,
                                        @Cast("float16*") ShortBuffer extraB,
                                        float scalarA,
                                        float scalarB);
    public native void execMetaPredicateShapeHalf(@Cast("Nd4jPointer*") PointerPointer extras,
                                        int opTypeA,
                                        int opNumA,
                                        int opTypeB,
                                        int opNumB,
                                        @Cast("Nd4jLong") long N,
                                        @Cast("float16*") short[] dx,
                                        @Cast("Nd4jLong*") long[] xShapeInfo,
                                        @Cast("float16*") short[] dy,
                                        @Cast("Nd4jLong*") long[] yShapeInfo,
                                        @Cast("float16*") short[] dz,
                                        @Cast("Nd4jLong*") long[] zShapeInfo,
                                        @Cast("float16*") short[] extraA,
                                        @Cast("float16*") short[] extraB,
                                        float scalarA,
                                        float scalarB);


    /**
     *
     * @param extras
     * @param opTypeA
     * @param opNumA
     * @param opTypeB
     * @param opNumB
     * @param dx
     * @param xShapeInfo
     * @param dy
     * @param yShapeInfo
     * @param dz
     * @param zShapeInfo
     * @param dimension
     * @param dimensionLength
     * @param tadShapeInfo
     * @param tadOffsets
     * @param extraA
     * @param extraB
     * @param scalarA
     * @param scalarB
     * @param scalarReturned
     */
    public native void execMetaPredicateReduceFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          FloatPointer dx,
                                          @Cast("Nd4jLong*") LongPointer xShapeInfo,
                                          FloatPointer dy,
                                          @Cast("Nd4jLong*") LongPointer yShapeInfo,
                                          FloatPointer dz,
                                          @Cast("Nd4jLong*") LongPointer zShapeInfo,
                                          IntPointer dimension,
                                          int dimensionLength,
                                          @Cast("Nd4jLong*") LongPointer tadShapeInfo,
                                          @Cast("Nd4jLong*") LongPointer tadOffsets,
                                          FloatPointer extraA,
                                          FloatPointer extraB,
                                          float scalarA,
                                          float scalarB,
                                          @Cast("bool") boolean scalarReturned);
    public native void execMetaPredicateReduceFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          FloatBuffer dx,
                                          @Cast("Nd4jLong*") LongBuffer xShapeInfo,
                                          FloatBuffer dy,
                                          @Cast("Nd4jLong*") LongBuffer yShapeInfo,
                                          FloatBuffer dz,
                                          @Cast("Nd4jLong*") LongBuffer zShapeInfo,
                                          IntBuffer dimension,
                                          int dimensionLength,
                                          @Cast("Nd4jLong*") LongBuffer tadShapeInfo,
                                          @Cast("Nd4jLong*") LongBuffer tadOffsets,
                                          FloatBuffer extraA,
                                          FloatBuffer extraB,
                                          float scalarA,
                                          float scalarB,
                                          @Cast("bool") boolean scalarReturned);
    public native void execMetaPredicateReduceFloat(@Cast("Nd4jPointer*") PointerPointer extras,
                                          int opTypeA,
                                          int opNumA,
                                          int opTypeB,
                                          int opNumB,
                                          float[] dx,
                                          @Cast("Nd4jLong*") long[] xShapeInfo,
                                          float[] dy,
                                          @Cast("Nd4jLong*") long[] yShapeInfo,
                                          float[] dz,
                                          @Cast("Nd4jLong*") long[] zShapeInfo,
                                          int[] dimension,
                                          int dimensionLength,
                                          @Cast("Nd4jLong*") long[] tadShapeInfo,
                                          @Cast("Nd4jLong*") long[] tadOffsets,
                                          float[] extraA,
                                          float[] extraB,
                                          float scalarA,
                                          float scalarB,
                                          @Cast("bool") boolean scalarReturned);


/**
 *
 * @param data
 * @param shapeBuffer
 * @param wordSize
 * @param headerSize
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") LongPointer headerSize);
    public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") LongBuffer headerSize);
    public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") long[] headerSize);

/**
   * Load numpy from a header
    * based on the cnpy parse from header method.
   * @param data the header data to parse
   * @return a pointer to a numpy cnpy:NpyArray struct
   */
    public native @Cast("Nd4jPointer") Pointer loadNpyFromHeader(@Cast("Nd4jPointer") Pointer data);


/**
   * Create a numpy array from an nd4j
   * array
   * @param data a pointer to the data
   * @param shapeBuffer  the shapebuffer for the nd4j array
   * @param wordSize  the word size (4 for float, 8 for doubles)
   * @return a pointer to a numpy array
   */
    public native @Cast("Nd4jPointer") Pointer numpyFromNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize);


/**
 *
 * @param npyArray
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer shapeBufferForNumpy(@Cast("Nd4jPointer") Pointer npyArray);


/**
* Get the shape buffer from a
* numpy array.
* **Warning** this allocates memory
* @param npyArray
* @return
*/
    public native @Cast("Nd4jPointer") Pointer shapeBufferForNumpyHeader(@Cast("Nd4jPointer") Pointer npyArray);



/**
 *
 * @param npyArray
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer dataPointForNumpyHeader(@Cast("Nd4jPointer") Pointer npyArray);

/**
 *
 * @param npyArray
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer dataPointForNumpyStruct(@Cast("Nd4jPointer") Pointer npyArrayStruct);

/**
 *
 * @param npyArray
 * @param fromFile
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer dataPointForNumpy(@Cast("Nd4jPointer") Pointer npyArray);

/**
 * Load a numpy array from a file
 * and return it as an Nd4jPointer
 * @param path
 * @return
 */
    public native @Cast("Nd4jPointer") Pointer numpyFromFile(@StdString BytePointer path);
    public native @Cast("Nd4jPointer") Pointer numpyFromFile(@StdString String path);


/**
  * Get the element size for a numpy array
  * @param npyArray  the numpy array's address
  * to get the length for
  * @return
  */
    public native int elementSizeForNpyArray(@Cast("Nd4jPointer") Pointer npyArray);


/**
* Get the element size for a numpy array
* @param npyArray  the numpy array's address
* to get the length for
* @return
*/
    public native int elementSizeForNpyArrayHeader(@Cast("Nd4jPointer") Pointer npyArray);


    public native void releaseNumpy(@Cast("Nd4jPointer") Pointer npyArray);


    /**
     * Return the length of a shape buffer
     * based on the pointer
     * @param buffer  the buffer pointer to check
     * @return
     */
    public native int lengthForShapeBufferPointer(@Cast("Nd4jPointer") Pointer buffer);


      /**
   * The pointer to get the address for
   *
   * @param address the address to get the pointer
   * @return the pointer for the given address
   */

    public native @Cast("Nd4jPointer") Pointer pointerForAddress(@Cast("Nd4jLong") long address);

    /**
     * This method takes single N-dimensional tensor, and copies its TADs to target arrays
     *
     * @param x
     * @param xShapeInfo
     * @param targets
     * @param zShapeInfo
     * @return
     */
    public native void tearDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongPointer zShapeInfo, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets);
    public native void tearDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongBuffer zShapeInfo, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets);
    public native void tearDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") long[] zShapeInfo, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets);

    /**
     * This method takes single N-dimensional tensor, and copies its TADs to target arrays
     *
     * @param x
     * @param xShapeInfo
     * @param targets
     * @param zShapeInfo
     * @return
     */
    public native void tearFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongPointer zShapeInfo, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets);
    public native void tearFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongBuffer zShapeInfo, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets);
    public native void tearFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") long[] zShapeInfo, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets);

    /**
     * This method takes single N-dimensional tensor, and copies its TADs to target arrays
     *
     * @param x
     * @param xShapeInfo
     * @param targets
     * @param zShapeInfo
     * @return
     */
    public native void tearHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongPointer zShapeInfo, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets);
    public native void tearHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") LongBuffer zShapeInfo, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets);
    public native void tearHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("Nd4jPointer*") PointerPointer targets, @Cast("Nd4jLong*") long[] zShapeInfo, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets);


    public native @Cast("Nd4jLong") long encodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);

    public native @Cast("Nd4jLong") long encodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);

    public native @Cast("Nd4jLong") long encodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native @Cast("Nd4jLong") long encodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);

    public native void decodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, FloatPointer dz);
    public native void decodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, FloatBuffer dz);
    public native void decodeBitmapFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, float[] dz);

    public native void decodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, DoublePointer dz);
    public native void decodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, DoubleBuffer dz);
    public native void decodeBitmapDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, double[] dz);

    public native void decodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") ShortPointer dz);
    public native void decodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") ShortBuffer dz);
    public native void decodeBitmapHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") short[] dz);


    public native void encodeThresholdP1Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native void encodeThresholdP1Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native void encodeThresholdP1Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);

    public native void encodeThresholdP1Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native void encodeThresholdP1Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native void encodeThresholdP1Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);

    public native void encodeThresholdP1Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer dx, @Cast("Nd4jLong") long N, IntPointer dz, float threshold);
    public native void encodeThresholdP1Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz, float threshold);
    public native void encodeThresholdP1Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] dx, @Cast("Nd4jLong") long N, int[] dz, float threshold);


    public native void encodeThresholdP2Int(@Cast("Nd4jPointer*") PointerPointer extraPointers, IntPointer dx, @Cast("Nd4jLong") long N, IntPointer dz);
    public native void encodeThresholdP2Int(@Cast("Nd4jPointer*") PointerPointer extraPointers, IntBuffer dx, @Cast("Nd4jLong") long N, IntBuffer dz);
    public native void encodeThresholdP2Int(@Cast("Nd4jPointer*") PointerPointer extraPointers, int[] dx, @Cast("Nd4jLong") long N, int[] dz);


    public native void encodeThresholdP3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer dx, IntPointer offsets, @Cast("Nd4jLong") long N, IntPointer dz);
    public native void encodeThresholdP3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer dx, IntBuffer offsets, @Cast("Nd4jLong") long N, IntBuffer dz);
    public native void encodeThresholdP3Float(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] dx, int[] offsets, @Cast("Nd4jLong") long N, int[] dz);

    public native void encodeThresholdP3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer dx, IntPointer offsets, @Cast("Nd4jLong") long N, IntPointer dz);
    public native void encodeThresholdP3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer dx, IntBuffer offsets, @Cast("Nd4jLong") long N, IntBuffer dz);
    public native void encodeThresholdP3Double(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] dx, int[] offsets, @Cast("Nd4jLong") long N, int[] dz);

    public native void encodeThresholdP3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer dx, IntPointer offsets, @Cast("Nd4jLong") long N, IntPointer dz);
    public native void encodeThresholdP3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer dx, IntBuffer offsets, @Cast("Nd4jLong") long N, IntBuffer dz);
    public native void encodeThresholdP3Half(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] dx, int[] offsets, @Cast("Nd4jLong") long N, int[] dz);


    public native void decodeThresholdFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, FloatPointer dz);
    public native void decodeThresholdFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, FloatBuffer dz);
    public native void decodeThresholdFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, float[] dz);

    public native void decodeThresholdDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, DoublePointer dz);
    public native void decodeThresholdDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, DoubleBuffer dz);
    public native void decodeThresholdDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, double[] dz);

    public native void decodeThresholdHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") ShortPointer dz);
    public native void decodeThresholdHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") ShortBuffer dz);
    public native void decodeThresholdHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, Pointer dx, @Cast("Nd4jLong") long N, @Cast("float16*") short[] dz);



    public native void sortFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("bool") boolean descending);

    public native void sortDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("bool") boolean descending);

    public native void sortHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, @Cast("bool") boolean descending);
    public native void sortHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] x, @Cast("Nd4jLong*") long[] xShapeInfo, @Cast("bool") boolean descending);



    public native void sortTadFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, IntPointer dimension, int dimensionLength, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, FloatBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, IntBuffer dimension, int dimensionLength, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, float[] x, @Cast("Nd4jLong*") long[] xShapeInfo, int[] dimension, int dimensionLength, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets, @Cast("bool") boolean descending);

    public native void sortTadDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoublePointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, IntPointer dimension, int dimensionLength, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, DoubleBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, IntBuffer dimension, int dimensionLength, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, double[] x, @Cast("Nd4jLong*") long[] xShapeInfo, int[] dimension, int dimensionLength, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets, @Cast("bool") boolean descending);

    public native void sortTadHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortPointer x, @Cast("Nd4jLong*") LongPointer xShapeInfo, IntPointer dimension, int dimensionLength, @Cast("Nd4jLong*") LongPointer tadShapeInfo, @Cast("Nd4jLong*") LongPointer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") ShortBuffer x, @Cast("Nd4jLong*") LongBuffer xShapeInfo, IntBuffer dimension, int dimensionLength, @Cast("Nd4jLong*") LongBuffer tadShapeInfo, @Cast("Nd4jLong*") LongBuffer tadOffsets, @Cast("bool") boolean descending);
    public native void sortTadHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("float16*") short[] x, @Cast("Nd4jLong*") long[] xShapeInfo, int[] dimension, int dimensionLength, @Cast("Nd4jLong*") long[] tadShapeInfo, @Cast("Nd4jLong*") long[] tadOffsets, @Cast("bool") boolean descending);


    // special sort impl for sorting out COO indices and values
    public native void sortCooIndicesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer indices, FloatPointer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer indices, FloatBuffer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] indices, float[] values, @Cast("Nd4jLong") long length, int rank);

    public native void sortCooIndicesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer indices, DoublePointer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer indices, DoubleBuffer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] indices, double[] values, @Cast("Nd4jLong") long length, int rank);

    public native void sortCooIndicesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer indices, @Cast("float16*") ShortPointer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer indices, @Cast("float16*") ShortBuffer values, @Cast("Nd4jLong") long length, int rank);
    public native void sortCooIndicesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] indices, @Cast("float16*") short[] values, @Cast("Nd4jLong") long length, int rank);


    public native @Cast("Nd4jLong*") LongPointer mmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") String fileName, @Cast("Nd4jLong") long length);
    public native @Cast("Nd4jLong*") LongBuffer mmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") BytePointer fileName, @Cast("Nd4jLong") long length);

    public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer ptrMap, @Cast("Nd4jLong") long length);
    public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer ptrMap, @Cast("Nd4jLong") long length);
    public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] ptrMap, @Cast("Nd4jLong") long length);


    // flatbuffers execution
    public native ResultWrapper executeFlatGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer flatBufferPointer);
    public native ResultWrapper executeFlatGraphDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer flatBufferPointer);
    public native ResultWrapper executeFlatGraphHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer flatBufferPointer);

    // protobuf execution
    public native @Cast("Nd4jPointer") Pointer executeProtoGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer protoBufferPointer);
    public native @Cast("Nd4jPointer") Pointer executeProtoGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") String fileName);
    public native @Cast("Nd4jPointer") Pointer executeProtoGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") BytePointer fileName);

    public native @Cast("char*") String getAllCustomOps();

    public native @Cast("char*") String getAllOperations();

    // customOp executioner
    public native int execCustomOpFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, FloatPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, FloatBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, float[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, @Cast("float16*") ShortPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, @Cast("float16*") ShortBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool") boolean isInplace);
    public native int execCustomOpHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, @Cast("float16*") short[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool") boolean isInplace);

    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, FloatPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, FloatBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, float[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") ShortPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") ShortBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") short[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);

    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, FloatPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, FloatBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, float[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") ShortPointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") ShortBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, @Cast("float16*") short[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
    public native ShapeList calculateOutputShapesDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);

    public native void deleteShapeList(@Cast("Nd4jPointer") Pointer shapeList);

    public native int registerGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer") Pointer flatBufferPointer);
    public native int registerGraphDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer") Pointer flatBufferPointer);
    public native int registerGraphHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer") Pointer flatBufferPointer);

    public native FloatVariablesSet executeStoredGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntPointer inputIndices, int numInputs);
    public native FloatVariablesSet executeStoredGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntBuffer inputIndices, int numInputs);
    public native FloatVariablesSet executeStoredGraphFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int[] inputIndices, int numInputs);
    public native DoubleVariablesSet executeStoredGraphDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntPointer inputIndices, int numInputs);
    public native DoubleVariablesSet executeStoredGraphDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntBuffer inputIndices, int numInputs);
    public native DoubleVariablesSet executeStoredGraphDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int[] inputIndices, int numInputs);
    public native HalfVariablesSet executeStoredGraphHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntPointer inputIndices, int numInputs);
    public native HalfVariablesSet executeStoredGraphHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntBuffer inputIndices, int numInputs);
    public native HalfVariablesSet executeStoredGraphHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int[] inputIndices, int numInputs);

    public native int unregisterGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId);

    public native void deleteIntArray(@Cast("Nd4jPointer") Pointer pointer);
    public native void deleteLongArray(@Cast("Nd4jPointer") Pointer pointer);
    public native void deletePointerArray(@Cast("Nd4jPointer") Pointer pointer);

    public native void deleteVariablesSetFloat(@Cast("Nd4jPointer") Pointer pointer);
    public native void deleteVariablesSetDouble(@Cast("Nd4jPointer") Pointer pointer);
    public native void deleteVariablesSetHalf(@Cast("Nd4jPointer") Pointer pointer);

    // GraphState creation
    public native @Cast("Nd4jPointer") Pointer getGraphStateHalf(@Cast("Nd4jLong") long id);
    public native @Cast("Nd4jPointer") Pointer getGraphStateFloat(@Cast("Nd4jLong") long id);
    public native @Cast("Nd4jPointer") Pointer getGraphStateDouble(@Cast("Nd4jLong") long id);

    public native void deleteGraphStateHalf(@Cast("Nd4jPointer") Pointer state);
    public native void deleteGraphStateFloat(@Cast("Nd4jPointer") Pointer state);
    public native void deleteGraphStateDouble(@Cast("Nd4jPointer") Pointer state);

    public native void deleteResultWrapper(@Cast("Nd4jPointer") Pointer ptr);

    public native int estimateThresholdFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, int N, float threshold);
    public native int estimateThresholdDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, int N, float threshold);
    public native int estimateThresholdHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, int N, float threshold);

    // this method executes op that requires scope to be present: if/while/cond/whatever
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongPointer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongBuffer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeHalf(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") long[] scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongPointer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongBuffer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") long[] scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongPointer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongBuffer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
    public native @Cast("Nd4jStatus") int execCustomOpWithScopeDouble(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") long[] scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);




}






// #endif //NATIVEOPERATIONS_NATIVEOPS_H


// Parsed from memory/ExternalWorkspace.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef LIBND4J_EXTERNALWORKSPACE_H
// #define LIBND4J_EXTERNALWORKSPACE_H

// #include <pointercast.h>
// #include <dll.h>
        @Namespace("nd4j::memory") @NoOffset public static class ExternalWorkspace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public ExternalWorkspace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public ExternalWorkspace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public ExternalWorkspace position(long position) {
                return (ExternalWorkspace)super.position(position);
            }
        
            public ExternalWorkspace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public ExternalWorkspace(@Cast("Nd4jPointer") Pointer ptrH, @Cast("Nd4jLong") long sizeH, @Cast("Nd4jPointer") Pointer ptrD, @Cast("Nd4jLong") long sizeD) { super((Pointer)null); allocate(ptrH, sizeH, ptrD, sizeD); }
            private native void allocate(@Cast("Nd4jPointer") Pointer ptrH, @Cast("Nd4jLong") long sizeH, @Cast("Nd4jPointer") Pointer ptrD, @Cast("Nd4jLong") long sizeD);
            
            public native Pointer pointerHost();
            public native Pointer pointerDevice();

            public native @Cast("Nd4jLong") long sizeHost();
            public native @Cast("Nd4jLong") long sizeDevice();
        }
    


// #endif

// Parsed from memory/Workspace.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class implements Workspace functionality in c++
//
//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_WORKSPACE_H
// #define LIBND4J_WORKSPACE_H

// #include <atomic>
// #include <vector>
// #include <mutex>
// #include <dll.h>
// #include <pointercast.h>
// #include <types/float16.h>
// #include <memory/ExternalWorkspace.h>

//        void ping();

        /** enum nd4j::memory::MemoryType */
        public static final int
            HOST = 0,
            DEVICE = 1;

        @Namespace("nd4j::memory") @NoOffset public static class Workspace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Workspace(Pointer p) { super(p); }
        
            public Workspace(ExternalWorkspace external) { super((Pointer)null); allocate(external); }
            private native void allocate(ExternalWorkspace external);
            public Workspace(@Cast("Nd4jLong") long initialSize/*=0*/) { super((Pointer)null); allocate(initialSize); }
            private native void allocate(@Cast("Nd4jLong") long initialSize/*=0*/);
            public Workspace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jLong") long getAllocatedSize();
            public native @Cast("Nd4jLong") long getCurrentSize();
            public native @Cast("Nd4jLong") long getCurrentOffset();
            public native @Cast("Nd4jLong") long getSpilledSize();
            public native @Cast("Nd4jLong") long getUsedSize();

            public native void expandBy(@Cast("Nd4jLong") long numBytes);
            public native void expandTo(@Cast("Nd4jLong") long numBytes);

//            bool resizeSupported();

            public native Pointer allocateBytes(@Cast("Nd4jLong") long numBytes);
            public native Pointer allocateBytes(@Cast("nd4j::memory::MemoryType") int type, @Cast("Nd4jLong") long numBytes);

            public native void scopeIn();
            public native void scopeOut();

            /*
             * This method creates NEW workspace of the same memory size and returns pointer to it
             */
            public native Workspace clone();
        }
    


// #endif //LIBND4J_WORKSPACE_H


// Parsed from indexing/NDIndex.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_NDINDEX_H
// #define LIBND4J_NDINDEX_H

// #include <pointercast.h>
// #include <vector>
// #include <dll.h>
    @Namespace("nd4j") @NoOffset public static class NDIndex extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndex(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public NDIndex(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public NDIndex position(long position) {
            return (NDIndex)super.position(position);
        }
    
        public NDIndex() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native @Cast("bool") boolean isAll();
        public native @Cast("bool") boolean isPoint();

        public native @Cast("Nd4jLong*") @StdVector LongPointer getIndices();
        public native @Cast("Nd4jLong") long stride();

        public static native NDIndex all();
        public static native NDIndex point(@Cast("Nd4jLong") long pt);
        public static native NDIndex interval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/);
        public static native NDIndex interval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end);
    }

    @Namespace("nd4j") public static class NDIndexAll extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexAll(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public NDIndexAll(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public NDIndexAll position(long position) {
            return (NDIndexAll)super.position(position);
        }
    
        public NDIndexAll() { super((Pointer)null); allocate(); }
        private native void allocate();
    }


    @Namespace("nd4j") public static class NDIndexPoint extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexPoint(Pointer p) { super(p); }
    
        public NDIndexPoint(@Cast("Nd4jLong") long point) { super((Pointer)null); allocate(point); }
        private native void allocate(@Cast("Nd4jLong") long point);
    }

    @Namespace("nd4j") public static class NDIndexInterval extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexInterval(Pointer p) { super(p); }
    
        public NDIndexInterval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/) { super((Pointer)null); allocate(start, end, stride); }
        private native void allocate(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/);
        public NDIndexInterval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end) { super((Pointer)null); allocate(start, end); }
        private native void allocate(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end);
    }




// #endif //LIBND4J_NDINDEX_H


// Parsed from indexing/IndicesList.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_INDICESLIST_H
// #define LIBND4J_INDICESLIST_H

// #include <initializer_list>
// #include "NDIndex.h"
    @Namespace("nd4j") @NoOffset public static class IndicesList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public IndicesList(Pointer p) { super(p); }
    

        public native int size();
        public native NDIndex at(int idx);
        public native void push_back(NDIndex idx);
        public native @Cast("bool") boolean isScalar();
    }

// #endif //LIBND4J_INDICESLIST_H


// Parsed from array/DataType.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_DATATYPE_H
// #define ND4J_DATATYPE_H
    /** enum nd4j::DataType */
    public static final int
        DataType_INHERIT = 0,
        DataType_BOOL = 1,
        DataType_FLOAT8 = 2,
        DataType_HALF = 3,
        DataType_HALF2 = 4,
        DataType_FLOAT = 5,
        DataType_DOUBLE = 6,
        DataType_INT8 = 7,
        DataType_INT16 = 8,
        DataType_INT32 = 9,
        DataType_INT64 = 10,
        DataType_UINT8 = 11,
        DataType_UINT16 = 12,
        DataType_UINT32 = 13,
        DataType_UINT64 = 14,
        DataType_QINT8 = 15,
        DataType_QINT16 = 16;


// #endif

// Parsed from graph/VariableType.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_VARIABLE_TYPE_H
// #define ND4J_VARIABLE_TYPE_H
        /** enum nd4j::graph::VariableType */
        public static final int
            NDARRAY = 0,
            ARRAY_LIST = 1,
            FLOW = 2;
    


// #endif

// Parsed from graph/ArgumentsList.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 24.01.18.
//

// #ifndef LIBND4J_INPUTLIST_H
// #define LIBND4J_INPUTLIST_H

// #include <op_boilerplate.h>
// #include <pointercast.h>
// #include <dll.h>
// #include <vector>
// #include <types/pair.h>
    @Namespace("nd4j::graph") @NoOffset public static class ArgumentsList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ArgumentsList(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ArgumentsList(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ArgumentsList position(long position) {
            return (ArgumentsList)super.position(position);
        }
    
        public ArgumentsList() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
         * This method returns number of argument pairs available
         *
         * @return
         */
        public native int size();

        /**
         * This method returns Pair at specified index
         *
         * @param index
         * @return
         */
        public native @ByRef Pair at(int index);
    }



// #endif //LIBND4J_INPUTLIST_H


// Parsed from types/pair.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 24.01.18.
//

// #ifndef LIBND4J_PAIR_H
// #define LIBND4J_PAIR_H

// #include <dll.h>
    @Namespace("nd4j") @NoOffset public static class Pair extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Pair(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Pair(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Pair position(long position) {
            return (Pair)super.position(position);
        }
    
        public Pair(int first/*=0*/, int second/*=0*/) { super((Pointer)null); allocate(first, second); }
        private native void allocate(int first/*=0*/, int second/*=0*/);
        public Pair() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int first();
        public native int second();
    }



// #endif //LIBND4J_PAIR_H


// Parsed from NDArray.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

// #ifndef NDARRAY_H
// #define NDARRAY_H

// #include <initializer_list>
// #include <functional>
// #include <shape.h>
// #include "NativeOpExcutioner.h"
// #include <memory/Workspace.h>
// #include <indexing/NDIndex.h>
// #include <indexing/IndicesList.h>
// #include <graph/Intervals.h>
// #include <array/DataType.h>
// #include <stdint.h>
// #include <array/ArrayOptions.h>
// #include <array/ArrayType.h>
// #include <array/ResultSet.h>
    @Namespace("nd4j") public static native @ByVal @Name("operator -") FloatNDArray subtract(float arg0, @Const @ByRef FloatNDArray arg1);
    @Namespace("nd4j") public static native @ByVal @Name("operator -") HalfNDArray subtract(@Cast("const float16") short arg0, @Const @ByRef HalfNDArray arg1);
    @Namespace("nd4j") public static native @ByVal @Name("operator -") DoubleNDArray subtract(double arg0, @Const @ByRef DoubleNDArray arg1);
    @Namespace("nd4j") public static native @ByVal @Name("operator +") FloatNDArray add(float arg0, @Const @ByRef FloatNDArray arg1);
    @Namespace("nd4j") public static native @ByVal @Name("operator +") HalfNDArray add(@Cast("const float16") short arg0, @Const @ByRef HalfNDArray arg1);
    @Namespace("nd4j") public static native @ByVal @Name("operator +") DoubleNDArray add(double arg0, @Const @ByRef DoubleNDArray arg1);


    @Name("nd4j::NDArray<float>") @NoOffset public static class FloatNDArray extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FloatNDArray(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public FloatNDArray(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public FloatNDArray position(long position) {
            return (FloatNDArray)super.position(position);
        }
    

        public static native FloatNDArray createEmpty(Workspace workspace/*=nullptr*/);
        public static native FloatNDArray createEmpty();

        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, float value, char order/*='c'*/);
        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, float value);
        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, float value, char order/*='c'*/);
        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, float value);
        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, float value, char order/*='c'*/);
        public static native FloatNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, float value);
        
        public static native FloatNDArray linspace(float from, float to, @Cast("const Nd4jLong") long numElements);

        public static native FloatNDArray scalar(float value);

        
        /**
        *  default constructor, do not allocate memory, memory for array is passed from outside 
        */
        public FloatNDArray(FloatPointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(FloatPointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public FloatNDArray() { super((Pointer)null); allocate(); }
        private native void allocate();
        public FloatNDArray(FloatBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(FloatBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public FloatNDArray(float[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(float[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);

        
        /**
         * Constructor for scalar NDArray
         */
        public FloatNDArray(float scalar) { super((Pointer)null); allocate(scalar); }
        private native void allocate(float scalar);

        /**
        *  copy constructor
        */
        public FloatNDArray(@Const @ByRef FloatNDArray other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef FloatNDArray other);

        /**
        *  move constructor
        */

// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  constructor, create empty array stored at given workspace
        */
        public FloatNDArray(Workspace workspace) { super((Pointer)null); allocate(workspace); }
        private native void allocate(Workspace workspace);

        /**
        *  this constructor creates new NDArray with shape matching "other" array, do not copy "other" elements into new array
        */
        public FloatNDArray(@Const FloatNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(other, copyStrides, workspace); }
        private native void allocate(@Const FloatNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
				
        /**
		*  constructor creates new NDArray using shape information from "shapeInfo", set all elements in new array to be zeros, if copyStrides is true then use stride values from "shapeInfo", else calculate strides independently 
        */
		public FloatNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public FloatNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo);
		public FloatNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public FloatNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
		public FloatNDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public FloatNDArray(@Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo);

        /**
        *  this constructor creates new array using shape information contained in vector argument    
        */
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        * This constructor creates new array with elements copied from data and using shape information stored in shape
        *
        * PLEASE NOTE: data will be copied AS IS, without respect to specified order. You must ensure order match here.
        */
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector FloatPointer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector FloatPointer data, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector FloatPointer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector FloatPointer data);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector FloatBuffer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector FloatBuffer data, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector FloatBuffer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector FloatBuffer data);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector float[] data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector float[] data, Workspace workspace/*=nullptr*/);
        public FloatNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector float[] data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector float[] data);

        /**
        *  this constructor creates new array using given buffer (without memory allocating) and shape information stored in shape
        */
        public FloatNDArray(FloatPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(FloatPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(FloatPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(FloatPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public FloatNDArray(FloatBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(FloatBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(FloatBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(FloatBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public FloatNDArray(float[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(float[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public FloatNDArray(float[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(float[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  copy assignment operator
        */
        public native @ByRef @Name("operator =") FloatNDArray put(@Const @ByRef FloatNDArray other);

        /**
        *  move assignment operator
        */

        /**
        *  assignment operator, assigns the same scalar to all array elements 
        */
        public native @ByRef @Name("operator =") FloatNDArray put(float scalar);

        /**
        *   operators for memory allocation and deletion
        */ 
        public native @Name("operator new") Pointer _new(@Cast("size_t") long i);
        public native @Name("operator delete") void _delete(Pointer p);

        /**
        *  method replaces existing buffer/shapeinfo, AND releases original pointers (if releaseExisting TRUE)
        */
        public native void replacePointers(FloatPointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(FloatPointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void replacePointers(FloatBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(FloatBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void replacePointers(float[] buffer, @Cast("Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(float[] buffer, @Cast("Nd4jLong*") long[] shapeInfo);
 
        /**
        *  create a new array by replicating current array by repeats times along given dimension
        *  dimension - dimension along which to repeat elements
        *  repeats - number of repetitions
        */        
        public native FloatNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongPointer repeats);
        public native FloatNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongBuffer repeats);
        public native FloatNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */
        public static native @ByVal FloatNDArray quantize(@ByRef FloatNDArray array);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */

        /**
        *  fill target array by repeating current array 
        *  dimension - dimension along which to repeat elements        
        */
        public native void repeat(int dimension, @ByRef FloatNDArray target);

        /**
        *  return _dataType;
        */
        public native @Cast("nd4j::DataType") int dataType();

        /**
        *  creates array which is view of this array
        */
        public native FloatNDArray getView();

        /**
        *  creates array which points on certain sub-range of this array, sub-range is defined by given indices
        */
        public native FloatNDArray subarray(@ByRef IndicesList indices);
        public native FloatNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongPointer strides);
        public native FloatNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongBuffer strides);
        public native FloatNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector long[] strides);
        public native FloatNDArray subarray(@Const @ByRef Intervals idx);

        /**
        *  cast array elements to given dtype
        */ 
        public native FloatNDArray cast(@Cast("nd4j::DataType") int dtype);
        public native void cast(FloatNDArray target, @Cast("nd4j::DataType") int dtype);

        /**
        *   returns _workspace
        */
        public native Workspace getWorkspace();

        /**
        *   returns _buffer
        */
        public native FloatPointer getBuffer();
        public native FloatPointer buffer();

        /**
        *   returns _shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeInfo();
        public native @Cast("Nd4jLong*") LongPointer getShapeInfo();

        /**
        *  if _bufferD==nullptr return _buffer, else return _bufferD
        */
        public native FloatPointer specialBuffer();

        /**
         * Returns True if it's legally empty NDArray, or false otherwise
         * @return
         */
        public native @Cast("bool") boolean isEmpty();

        /**
        *  if _shapeInfoD==nullptr return _shapeInfo, else return _shapeInfoD
        */
        public native @Cast("Nd4jLong*") LongPointer specialShapeInfo();

        /**
        *  set values for _bufferD and _shapeInfoD
        */
        public native void setSpecialBuffers(FloatPointer buffer, @Cast("Nd4jLong*") LongPointer shape);
        public native void setSpecialBuffers(FloatBuffer buffer, @Cast("Nd4jLong*") LongBuffer shape);
        public native void setSpecialBuffers(float[] buffer, @Cast("Nd4jLong*") long[] shape);

        /**
        *  permutes (in-place) the dimensions in array according to "dimensions" array
        */
        public native @Cast("bool") boolean permutei(@StdVector IntPointer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector IntBuffer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector int[] dimensions);
        public native @Cast("bool") boolean permutei(@Const IntPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const IntBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const int[] dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native @Cast("bool") boolean isFinite();
        public native @Cast("bool") boolean hasNaNs();
        public native @Cast("bool") boolean hasInfs();

        /**
        *  permutes the dimensions in array according to "dimensions" array, new array points on _buffer of this array
        */
        public native FloatNDArray permute(@StdVector IntPointer dimensions);
        public native FloatNDArray permute(@StdVector IntBuffer dimensions);
        public native FloatNDArray permute(@StdVector int[] dimensions);
        public native FloatNDArray permute(@Const IntPointer dimensions, int rank);
        public native FloatNDArray permute(@Const IntBuffer dimensions, int rank);
        public native FloatNDArray permute(@Const int[] dimensions, int rank);

        public native void permute(@Const IntPointer dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@Const IntBuffer dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@Const int[] dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@StdVector IntPointer dimensions, @ByRef FloatNDArray target);
        public native void permute(@StdVector IntBuffer dimensions, @ByRef FloatNDArray target);
        public native void permute(@StdVector int[] dimensions, @ByRef FloatNDArray target);
        public native FloatNDArray permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native FloatNDArray permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native FloatNDArray permute(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native FloatNDArray permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native FloatNDArray permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native FloatNDArray permute(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native void permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@Cast("const Nd4jLong*") long[] dimensions, int rank, @ByRef FloatNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, @ByRef FloatNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, @ByRef FloatNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector long[] dimensions, @ByRef FloatNDArray target);

        /**
         * This method streamlines given view or permuted array, and reallocates buffer
         */
        public native void streamline(char order/*='a'*/);
        public native void streamline();



        /**
        *  check whether array is contiguous in memory
        */ 
        public native @Cast("bool") boolean isContiguous();

        /**
        *  prints information about array shape
        *  msg - message to print out 
        */ 
        public native void printShapeInfo(@Cast("char*") String msg/*=nullptr*/);
        public native void printShapeInfo();
        public native void printShapeInfo(@Cast("char*") BytePointer msg/*=nullptr*/);

        /**
        *  prints buffer elements
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printBuffer();
        public native void printBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        /**
        *  prints buffer elements, takes into account offset between elements (element-wise-stride)
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printIndexedBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printIndexedBuffer();
        public native void printIndexedBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        public native @StdString BytePointer asIndexedString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asIndexedString();
        public native @StdString BytePointer asString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asString();

        /**
        *  this method assigns values of given array to this one
        */ 
        public native void assign(@Const FloatNDArray other);

        /**
        *  this method assigns values of given array to this one
        */

        /**
        *  this method assigns given value to all elements in array
        */ 
        public native void assign(float value);

        /**
        *  returns new copy of this array, optionally in different order
        */
        public native FloatNDArray dup(char newOrder/*='a'*/);
        public native FloatNDArray dup();

        /** 
        *  returns sum of all elements of array
        */
        public native float sumNumber();

        /**
        *  returns mean number of array
        */ 
        public native float meanNumber();


        /**
         * This method explicitly enforces new shape for this NDArray, old shape/stride information is lost
         */
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions);

        /**
        *  calculates sum along dimension(s) in this array and save it to created reduced array
        *  dimensions - array of dimensions to calculate sum over
        *  keepDims - if true then put unities in place of reduced dimensions
        */
        public native FloatNDArray sum(@StdVector IntPointer dimensions);
        public native FloatNDArray sum(@StdVector IntBuffer dimensions);
        public native FloatNDArray sum(@StdVector int[] dimensions);

		/**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector, result is stored in new array to be returned
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        */

        /**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector
        *  target - where to save result of reducing
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        *  extras - extra parameters
        */

        /**
        *  return variance of array elements set
        *  biasCorrected -  if true bias correction will be applied
        */

        /**
        *  apply scalar operation to array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns element index which corresponds to some condition imposed by operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns index of max element in a given array (optionally: along given dimension(s))
        *  dimensions - optional vector with dimensions
        */          
        public native @Cast("Nd4jLong") long argMax();

        /**
        *  apply OpName transformation directly to array
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to array and store result in target
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to this array and store result in new array being returned
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in this array
        *  other - second array necessary for pairwise operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in target array
        *  other - second array necessary for pairwise operation
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast a smaller array (tad) along  bigger one (this)
        *  tad - array to broadcast
        *  dimensions -  dimensions array to broadcast along
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  target - where to store result
        *  checkTargetShape - if true check whether target shape is suitable for broadcasting
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input array which is simple scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */


// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  apply OpName random operation to array 
        *  buffer - pointer on RandomBuffer
        *  y - optional input array
        *  z - optional input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *   apply transpose operation to the copy of this array, that is this array remains unaffected 
        */
        public native FloatNDArray transpose();
        public native @ByVal FloatNDArray transp();

        /**
        *  perform transpose operation and store result in target, this array remains unaffected 
        *  target - where to store result
        */ 
        public native void transpose(@ByRef FloatNDArray target);

        /**
        *  apply in-place transpose operation to this array, so this array becomes transposed 
        */ 
        public native void transposei();

        /**
        *  return array pointing on certain range of this array
        *  index - the number of array to be returned among set of possible arrays 
        *  dimensions - array of dimensions to point on
        */
        public native FloatNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntPointer dimensions);
        public native FloatNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntBuffer dimensions);
        public native FloatNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector int[] dimensions);

        /**
        *  returns the number of arrays pointing on specified dimension(s)
        *  dimensions - array of dimensions to point on
        */
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntPointer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector int[] dimensions);

        /**
        *  returns true if elements of two arrays are equal to within given epsilon value
        *  other - input array to compare
        *  eps - epsilon, this value defines the precision of elements comparison
        */
        public native @Cast("bool") boolean equalsTo(@Const FloatNDArray other, float eps/*=(T) 1e-5f*/);
        public native @Cast("bool") boolean equalsTo(@Const FloatNDArray other);
        
        /**
        *  add given row vector to all rows of this array
        *  row - row vector to add
        */
        public native void addiRowVector(@Const FloatNDArray row);

        /**
        *  add given row vector to all rows of this array, store result in target
        *  row - row vector to add
        *  target - where to store result
        */
        public native void addRowVector(@Const FloatNDArray row, FloatNDArray target);

        /**
        *  subtract given row vector from all rows of this array, store result in target
        *  row - row vector to subtract
        *  target - where to store result
        */
        public native void subRowVector(@Const FloatNDArray row, FloatNDArray target);
        
        /**
        *  multiply all rows of this array on given row vector, store result in target
        *  row - row vector to multiply on
        *  target - where to store result
        */
        public native void mulRowVector(@Const FloatNDArray row, FloatNDArray target);

        /**
        *  divide all rows of this array on given row vector, store result in target
        *  row - row vector to divide on
        *  target - where to store result
        */
        public native void divRowVector(@Const FloatNDArray row, FloatNDArray target);
        
        /**
        *  add given column vector to all columns of this array, store result in target
        *  column - column vector to add
        *  target - where to store result
        */
        public native void addColumnVector(@Const FloatNDArray column, FloatNDArray target);

        /**
        *  add given column vector to all columns of this array, this array becomes affected (in-place operation)
        *  column - column vector to add
        */
		public native void addiColumnVector(@Const FloatNDArray column);

        /**
        *  multiply all columns of this array on given column vector, this array becomes affected (in-place operation)
        *  column - column vector to multiply on
        */
		public native void muliColumnVector(@Const FloatNDArray column);

        /**
        *  returns number of bytes used by _buffer & _shapeInfo
        */
        public native @Cast("Nd4jLong") long memoryFootprint();
        
        /**
        *  these methods suited for FlatBuffers use
        */
        public native @StdVector FloatPointer getBufferAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeInfoAsVector();
        public native @Cast("int64_t*") @StdVector LongPointer getShapeInfoAsFlatVector();
				
        /**
        *  set new order and shape in case of suitable array length (in-place operation)
        *  order - order to set
        *  shape - shape to set
        *
        *  if there was permute applied before or there are weird strides, then new buffer is allocated for array
        */
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector long[] shape);
	
        /**
        *  creates new array with corresponding order and shape, new array will point on _buffer of this array
        *  order - order to set
        *  shape - shape to set
        *
        * if permute have been applied before or there are weird strides, then new buffer is allocated for new array
        */
		public native FloatNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native FloatNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native FloatNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		
        /**
        *  calculate strides and set given order
        *  order - order to set
        */
		public native void updateStrides(char order);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        */
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  returns new array which is created by repeating of this array the number of times given by reps 
        *  repeats - contains numbers of repetitions
        */
		public native @ByVal FloatNDArray tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native @ByVal FloatNDArray tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native @ByVal FloatNDArray tile(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        *  target - where to store result
        */
        public native void tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats, @ByRef FloatNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats, @ByRef FloatNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector long[] repeats, @ByRef FloatNDArray target);

        /**
        *  change an array by repeating it the number of times to acquire the new shape which is the same as target shape        
        *  target - where to store result
        */
        public native void tile(@ByRef FloatNDArray target);
        
        /**
        *  returns an array which is result of broadcasting of this and other arrays 
        *  other - input array
        */
		public native FloatNDArray broadcast(@Const @ByRef FloatNDArray other);
		
        /**
        *  check whether array's rows (arg=0) or columns (arg=1) create orthogonal basis
        *  arg - 0 -> row, 1 -> column
        */
		public native @Cast("bool") boolean hasOrthonormalBasis(int arg); 
				
        /**
        *  check whether array is identity matrix
        */
		public native @Cast("bool") boolean isIdentityMatrix(); 
		
        /**
        *  check whether array is unitary matrix
        */
		public native @Cast("bool") boolean isUnitary(); 
                        
        /**
        *  reduces dimensions in this array relying on index operation OpName
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  reduces dimensions in array relying on index operation OpName
        *  target - where to store result
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (tads not axis)
        *  extraArgs - extra parameters for operation
        */
                
        /**
        *  apply reduce3 (exec) operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (same as reduceAlongDimension)
        *  extraArgs - extra parameters for operation
        */


        /**
        *  returns variance along given dimensions
        *  biasCorrected -  if true bias correction will be applied
        *  dimensions - vector of dimensions to calculate variance along
        */

        /**
        *  operator returns subarray with buffer pointing at this->_buffer with offset defined by given intervals
        *  idx - intervals of indexes which define the subarrays to point on, idx has form {dim0Start,dim0End,  dim1Start,dim1End, ....} and length (2 * this->rankOf())
        *        when (dimStart == dimEnd) then whole range will be used for current dimension
        *  keepUnitiesInShape - if false then eliminate unities from resulting array shape, for example {1,a,1,b} -> {a,b}
        */
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("Nd4jLong*") @StdVector LongPointer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("Nd4jLong*") @StdVector LongBuffer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("Nd4jLong*") @StdVector long[] idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);

        /**
        *  evaluates subarray with buffer pointing at this->_buffer and offset defined by given sequential index subArrIdx and dimensions in dimsToExclude
        *  subArrIdx - index of current sub-array
        *  dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5], and subArrIdx must be in range [0,7]
        *                  if dimsToExclude is empty then idxRanges containing all zeros (means whole array) will be returned.
        */ 
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") FloatNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude);

        /**
        *  addition operator: array + other
        *  other - input array to add
        */
        public native @ByVal @Name("operator +") FloatNDArray add(@Const @ByRef FloatNDArray other);

        /**
        *  addition operator: array + scalar
        *  scalar - input scalar to add
        */
        public native @ByVal @Name("operator +") FloatNDArray add(float scalar);

        /**
        *  friend functions which implement addition operator: scalar + array
        *  scalar - input scalar to add
        */
        
        
        
        
        /**
        *  addition unary operator array += other
        *  other - input array to add
        */
        public native @Name("operator +=") void addPut(@Const @ByRef FloatNDArray other);

        /**
        *  subtraction unary operator array -= other
        *  other - input array to add
        */
        public native @Name("operator -=") void subtractPut(@Const @ByRef FloatNDArray other);

        public native @Name("operator +=") void addPut(float other);
        public native @Name("operator -=") void subtractPut(float other);
        
        /**
        *  subtraction operator: array - other
        *  other - input array to subtract
        */
        public native @ByVal @Name("operator -") FloatNDArray subtract(@Const @ByRef FloatNDArray other);
        
        /**
        *  subtraction operator: array - scalar
        *  scalar - input scalar to subtract
        */
        public native @ByVal @Name("operator -") FloatNDArray subtract(float scalar);        

        /**
        *  negative operator, it changes sign of all array elements on opposite
        */
        public native @ByVal @Name("operator -") FloatNDArray subtract();

        /**
        *  friend functions which implement subtraction operator: scalar - array
        *  scalar - input scalar to subtract
        */
        
        
        

        /**
        *  pairwise multiplication operator: array * other
        *  other - input array to multiply on
        */
        public native @ByVal @Name("operator *") FloatNDArray multiply(@Const @ByRef FloatNDArray other);        
    
        /**
        *  multiplication operator: array * scalar
        *  scalar - input scalar to multiply on
        */
        public native @ByVal @Name("operator *") FloatNDArray multiply(float scalar);
        
        /**
        *  pairwise multiplication unary operator array *= other
        *  other - input array to multiply on
        */
        public native @Name("operator *=") void multiplyPut(@Const @ByRef FloatNDArray other);

        /**
        *  multiplication unary operator array *= scalar
        *  scalar - input scalar to multiply on
        */
        public native @Name("operator *=") void multiplyPut(float scalar);

        /**
        *  pairwise division operator: array / other
        *  other - input array to divide on
        */
        public native @ByVal @Name("operator /") FloatNDArray divide(@Const @ByRef FloatNDArray other);        

        /**
        *  division operator: array / scalar
        *  scalar - input scalar to divide each array element on
        */
        public native @ByVal @Name("operator /") FloatNDArray divide(float scalar);

        /**
        *  pairwise division unary operator: array /= other
        *  other - input array to divide on
        */
        public native @Name("operator /=") void dividePut(@Const @ByRef FloatNDArray other);

        /**
        *  division unary operator: array /= scalar
        *  scalar - input scalar to divide on
        */
        public native @Name("operator /=") void dividePut(float scalar);

        /**
        *  friend function which implements mathematical multiplication of two arrays
        *  left - input array
        *  right - input array
        */
        

        /**
        *  this method assigns elements of other array to the subarray of this array defined by given intervals
        *  other - input array to assign elements from
        *  idx - intervals of indexes which define the subarray
        */ 
        public native void assign(@Const @ByRef FloatNDArray other, @Const @ByRef Intervals idx);

        /**
        *  return vector containing _buffer as flat binary array
        */
        public native @StdVector BytePointer asByteVector();

        /**
        *  makes array to be identity matrix (not necessarily square), that is set all diagonal elements = 1, rest = 0
        */
        public native void setIdentity();

        /**
        *  swaps the contents of tow arrays, 
        *  PLEASE NOTE: method doesn't take into account the shapes of arrays, shapes may be different except one condition: arrays lengths must be the same 
        */
        public native void swapUnsafe(@ByRef FloatNDArray other);

        /**
        *  return vector with buffer which points on corresponding diagonal elements of array
        *  type - means of vector to be returned: column ('c') or row ('r')
        */
        public native FloatNDArray diagonal(char type );

        /**
        *  fill matrix with given value starting from specified diagonal in given direction, works only with 2D matrix
        *
        *  diag - diagonal starting from matrix is filled. 
        *      diag = 0 corresponds to main diagonal, 
        *      diag < 0 below main diagonal
        *      diag > 0 above main diagonal
        *  direction - in what direction to fill matrix. There are 2 possible directions:
        *      'u' - fill up, mathematically this corresponds to lower triangular matrix 
        *      'l' - fill down, mathematically this corresponds to upper triangular matrix
        */
        public native void setValueInDiagMatrix(float value, int diag, char direction);

		/**
        *  change an array by repeating it the number of times in order to acquire new shape equal to the input shape
        *
        *  shape  - contains new shape to broadcast array to 
        *  target - optional argument, if target != nullptr the resulting array will be placed in target, in opposite case tile operation is done in place
        */
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape, FloatNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape, FloatNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape, FloatNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  calculates the trace of an array, that is sum of elements on main diagonal = sum array[i, i, i, ...]
        */
        public native float getTrace();

        /**
        *  fill array linearly as follows: arr[0] = from, arr[1] = from+step, arr[2] = from+2*step, ...
        */
        public native void linspace(float from, float step/*=1.0f*/);
        public native void linspace(float from);

        public native FloatNDArray createUninitialized();

        public native FloatResultSet multipleTensorsAlongDimension(@StdVector IntPointer indices, @StdVector IntPointer dimensions);
        public native FloatResultSet multipleTensorsAlongDimension(@StdVector IntBuffer indices, @StdVector IntBuffer dimensions);
        public native FloatResultSet multipleTensorsAlongDimension(@StdVector int[] indices, @StdVector int[] dimensions);

        public native FloatResultSet allTensorsAlongDimension(@StdVector IntPointer dimensions);
        public native FloatResultSet allTensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native FloatResultSet allTensorsAlongDimension(@StdVector int[] dimensions);

        public native FloatResultSet allExamples();

        /**
        *  default destructor
        */ 

        /**
        *  set _shapeInfo
        */
        public native void setShapeInfo(@Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") long[] shapeInfo);

        /**
        *  set _buffer
        */
        public native void setBuffer(FloatPointer buffer);
        public native void setBuffer(FloatBuffer buffer);
        public native void setBuffer(float[] buffer);

        /**
        *  set _isBuffAlloc and _isShapeAlloc
        */
        public native void triggerAllocationFlag(@Cast("bool") boolean bufferAllocated, @Cast("bool") boolean shapeAllocated);
        
        /**
        *  returns the value of "dim" dimension 
        */
        public native @Cast("Nd4jLong") long sizeAt(int dim);

        /**        
        *  returns order of array
        */
        public native char ordering();

        /**
        *  return _isView
        */ 
        public native @Cast("bool") boolean isView();

        /**
        *  returns shape portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeOf();
        
        /**
        *  returns strides portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer stridesOf();

        /**
        *  returns rank of array
        */
        public native int rankOf();        

        /** 
        *  returns length of array
        */
        public native @Cast("Nd4jLong") long lengthOf();

        /**
        *  returns number of rows in array
        */
        public native @Cast("Nd4jLong") long rows();

        /**
        *  returns number of columns in array
        */ 
        public native @Cast("Nd4jLong") long columns();

        /**
        *  returns size of array elements type
        */ 
        public native int sizeOfT();

        /**
        *  returns element-wise-stride
        */ 
        public native @Cast("Nd4jLong") long ews();

        // returns true if arrays have same shape
        public native @Cast("bool") boolean isSameShape(@Const FloatNDArray other);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  returns true if these two NDArrays have same rank, dimensions, strides, ews and order
        */
        public native @Cast("bool") boolean isSameShapeStrict(@Const FloatNDArray other);

        /**
        *  returns true if buffer && shapeInfo were defined (non nullptr)
        */
        public native @Cast("bool") boolean nonNull();

        /** 
        *  returns array element with given index from linear buffer
        *  i - element index in array
        */
        public native float getScalar(@Cast("const Nd4jLong") long i);

        /** 
        *  returns array element with given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        */
        public native float getIndexedScalar(@Cast("const Nd4jLong") long i);
        
        /** 
        *  returns element with given indexes from 2D array 
        *  i - number of row 
        *  j - number of column
        */
        public native float getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /** 
        *  returns element with given indexes from 3D array 
        *  i - height
        *  j - width
        *  k - depth
        */
        public native float getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);
        
        /** 
        *  assigns given scalar to array element by given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putIndexedScalar(@Cast("const Nd4jLong") long i, float value);

        /** 
        *  assigns given scalar to array element by given index, regards array buffer as linear
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, float value);

        /** 
        *  assigns given scalar to 2D array element by given indexes
        *  i - number of row
        *  j - number of row
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, float value);

        /** 
        *  assigns given scalar to 3D array element by given indexes
        *  i - height
        *  j - width
        *  k - depth
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k, float value);

        /**
        *  returns true if array is 2D
        */
        public native @Cast("bool") boolean isMatrix();

        /**
        *  returns true if array is vector
        */
        public native @Cast("bool") boolean isVector();

        /**
        *  returns true if array is column vector
        */
        public native @Cast("bool") boolean isColumnVector();

        /**
        *  returns true if array is row vector
        */
        public native @Cast("bool") boolean isRowVector();

        /**
        *  returns true if array is scalar
        */
        public native @Cast("bool") boolean isScalar();

        /**
        *  inline accessing operator for matrix, i - absolute index        
        */

        /**
        *  inline modifying operator for matrix, i - absolute index        
        */
        public native @ByRef @Name("operator ()") FloatPointer apply(@Cast("const Nd4jLong") long i);

        /**
        *  inline accessing operator for 2D array, i - row, j - column
        */

        /**
        *  inline modifying operator for 2D array, i - row, j - column
        */
        public native @ByRef @Name("operator ()") FloatPointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /**
        *  inline accessing operator for 3D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for 3D array, i - height, j - width, k - depth
        */ 
        public native @ByRef @Name("operator ()") FloatPointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);

        /**
        *  inline modifying operator for 4D array, i - height, j - width, k - depth
        */ 
        public native @ByRef @Name("operator ()") FloatPointer apply(@Cast("const Nd4jLong") long t, @Cast("const Nd4jLong") long u, @Cast("const Nd4jLong") long v, @Cast("const Nd4jLong") long w);

        /**
        *  inline accessing operator for 4D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */ 
        public native @ByRef @Name("operator ()") FloatPointer apply(@Cast("const Nd4jLong*") LongPointer idx);
        public native @ByRef @Name("operator ()") FloatBuffer apply(@Cast("const Nd4jLong*") LongBuffer idx);
        public native @ByRef @Name("operator ()") float[] apply(@Cast("const Nd4jLong*") long[] idx);

        /**
        *  inline accessing operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */


        public native @Cast("bool") boolean isAttached();

        public native FloatNDArray detach();


        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef FloatNDArray other);
    }


    @Name("nd4j::NDArray<float16>") @NoOffset public static class HalfNDArray extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public HalfNDArray(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public HalfNDArray(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public HalfNDArray position(long position) {
            return (HalfNDArray)super.position(position);
        }
    

        public static native HalfNDArray createEmpty(Workspace workspace/*=nullptr*/);
        public static native HalfNDArray createEmpty();

        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("const float16") short value, char order/*='c'*/);
        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("const float16") short value);
        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("const float16") short value, char order/*='c'*/);
        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("const float16") short value);
        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, @Cast("const float16") short value, char order/*='c'*/);
        public static native HalfNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, @Cast("const float16") short value);
        
        public static native HalfNDArray linspace(@Cast("const float16") short from, @Cast("const float16") short to, @Cast("const Nd4jLong") long numElements);

        public static native HalfNDArray scalar(@Cast("const float16") short value);

        
        /**
        *  default constructor, do not allocate memory, memory for array is passed from outside 
        */
        public HalfNDArray(@Cast("float16*") ShortPointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(@Cast("float16*") ShortPointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public HalfNDArray() { super((Pointer)null); allocate(); }
        private native void allocate();
        public HalfNDArray(@Cast("float16*") ShortBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(@Cast("float16*") ShortBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public HalfNDArray(@Cast("float16*") short[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(@Cast("float16*") short[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);

        
        /**
         * Constructor for scalar NDArray
         */
        public HalfNDArray(@Cast("float16") short scalar) { super((Pointer)null); allocate(scalar); }
        private native void allocate(@Cast("float16") short scalar);

        /**
        *  copy constructor
        */
        public HalfNDArray(@Const @ByRef HalfNDArray other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef HalfNDArray other);

        /**
        *  move constructor
        */

// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  constructor, create empty array stored at given workspace
        */
        public HalfNDArray(Workspace workspace) { super((Pointer)null); allocate(workspace); }
        private native void allocate(Workspace workspace);

        /**
        *  this constructor creates new NDArray with shape matching "other" array, do not copy "other" elements into new array
        */
        public HalfNDArray(@Const HalfNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(other, copyStrides, workspace); }
        private native void allocate(@Const HalfNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
				
        /**
		*  constructor creates new NDArray using shape information from "shapeInfo", set all elements in new array to be zeros, if copyStrides is true then use stride values from "shapeInfo", else calculate strides independently 
        */
		public HalfNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public HalfNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo);
		public HalfNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public HalfNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
		public HalfNDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public HalfNDArray(@Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo);

        /**
        *  this constructor creates new array using shape information contained in vector argument    
        */
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        * This constructor creates new array with elements copied from data and using shape information stored in shape
        *
        * PLEASE NOTE: data will be copied AS IS, without respect to specified order. You must ensure order match here.
        */
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("float16*") @StdVector ShortPointer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("float16*") @StdVector ShortPointer data, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("float16*") @StdVector ShortPointer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("float16*") @StdVector ShortPointer data);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("float16*") @StdVector ShortBuffer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("float16*") @StdVector ShortBuffer data, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("float16*") @StdVector ShortBuffer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("float16*") @StdVector ShortBuffer data);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("float16*") @StdVector short[] data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("float16*") @StdVector short[] data, Workspace workspace/*=nullptr*/);
        public HalfNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("float16*") @StdVector short[] data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("float16*") @StdVector short[] data);

        /**
        *  this constructor creates new array using given buffer (without memory allocating) and shape information stored in shape
        */
        public HalfNDArray(@Cast("float16*") ShortPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(@Cast("float16*") ShortPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(@Cast("float16*") ShortPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(@Cast("float16*") ShortPointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public HalfNDArray(@Cast("float16*") ShortBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(@Cast("float16*") ShortBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(@Cast("float16*") ShortBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(@Cast("float16*") ShortBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public HalfNDArray(@Cast("float16*") short[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(@Cast("float16*") short[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public HalfNDArray(@Cast("float16*") short[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(@Cast("float16*") short[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  copy assignment operator
        */
        public native @ByRef @Name("operator =") HalfNDArray put(@Const @ByRef HalfNDArray other);

        /**
        *  move assignment operator
        */

        /**
        *  assignment operator, assigns the same scalar to all array elements 
        */
        public native @ByRef @Name("operator =") HalfNDArray put(@Cast("const float16") short scalar);

        /**
        *   operators for memory allocation and deletion
        */ 
        public native @Name("operator new") Pointer _new(@Cast("size_t") long i);
        public native @Name("operator delete") void _delete(Pointer p);

        /**
        *  method replaces existing buffer/shapeinfo, AND releases original pointers (if releaseExisting TRUE)
        */
        public native void replacePointers(@Cast("float16*") ShortPointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(@Cast("float16*") ShortPointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void replacePointers(@Cast("float16*") ShortBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(@Cast("float16*") ShortBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void replacePointers(@Cast("float16*") short[] buffer, @Cast("Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(@Cast("float16*") short[] buffer, @Cast("Nd4jLong*") long[] shapeInfo);
 
        /**
        *  create a new array by replicating current array by repeats times along given dimension
        *  dimension - dimension along which to repeat elements
        *  repeats - number of repetitions
        */        
        public native HalfNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongPointer repeats);
        public native HalfNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongBuffer repeats);
        public native HalfNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */
        public static native @ByVal HalfNDArray quantize(@ByRef HalfNDArray array);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */

        /**
        *  fill target array by repeating current array 
        *  dimension - dimension along which to repeat elements        
        */
        public native void repeat(int dimension, @ByRef HalfNDArray target);

        /**
        *  return _dataType;
        */
        public native @Cast("nd4j::DataType") int dataType();

        /**
        *  creates array which is view of this array
        */
        public native HalfNDArray getView();

        /**
        *  creates array which points on certain sub-range of this array, sub-range is defined by given indices
        */
        public native HalfNDArray subarray(@ByRef IndicesList indices);
        public native HalfNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongPointer strides);
        public native HalfNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongBuffer strides);
        public native HalfNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector long[] strides);
        public native HalfNDArray subarray(@Const @ByRef Intervals idx);

        /**
        *  cast array elements to given dtype
        */ 
        public native HalfNDArray cast(@Cast("nd4j::DataType") int dtype);
        public native void cast(HalfNDArray target, @Cast("nd4j::DataType") int dtype);

        /**
        *   returns _workspace
        */
        public native Workspace getWorkspace();

        /**
        *   returns _buffer
        */
        public native @Cast("float16*") ShortPointer getBuffer();
        public native @Cast("float16*") ShortPointer buffer();

        /**
        *   returns _shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeInfo();
        public native @Cast("Nd4jLong*") LongPointer getShapeInfo();

        /**
        *  if _bufferD==nullptr return _buffer, else return _bufferD
        */
        public native @Cast("float16*") ShortPointer specialBuffer();

        /**
         * Returns True if it's legally empty NDArray, or false otherwise
         * @return
         */
        public native @Cast("bool") boolean isEmpty();

        /**
        *  if _shapeInfoD==nullptr return _shapeInfo, else return _shapeInfoD
        */
        public native @Cast("Nd4jLong*") LongPointer specialShapeInfo();

        /**
        *  set values for _bufferD and _shapeInfoD
        */
        public native void setSpecialBuffers(@Cast("float16*") ShortPointer buffer, @Cast("Nd4jLong*") LongPointer shape);
        public native void setSpecialBuffers(@Cast("float16*") ShortBuffer buffer, @Cast("Nd4jLong*") LongBuffer shape);
        public native void setSpecialBuffers(@Cast("float16*") short[] buffer, @Cast("Nd4jLong*") long[] shape);

        /**
        *  permutes (in-place) the dimensions in array according to "dimensions" array
        */
        public native @Cast("bool") boolean permutei(@StdVector IntPointer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector IntBuffer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector int[] dimensions);
        public native @Cast("bool") boolean permutei(@Const IntPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const IntBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const int[] dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native @Cast("bool") boolean isFinite();
        public native @Cast("bool") boolean hasNaNs();
        public native @Cast("bool") boolean hasInfs();

        /**
        *  permutes the dimensions in array according to "dimensions" array, new array points on _buffer of this array
        */
        public native HalfNDArray permute(@StdVector IntPointer dimensions);
        public native HalfNDArray permute(@StdVector IntBuffer dimensions);
        public native HalfNDArray permute(@StdVector int[] dimensions);
        public native HalfNDArray permute(@Const IntPointer dimensions, int rank);
        public native HalfNDArray permute(@Const IntBuffer dimensions, int rank);
        public native HalfNDArray permute(@Const int[] dimensions, int rank);

        public native void permute(@Const IntPointer dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@Const IntBuffer dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@Const int[] dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@StdVector IntPointer dimensions, @ByRef HalfNDArray target);
        public native void permute(@StdVector IntBuffer dimensions, @ByRef HalfNDArray target);
        public native void permute(@StdVector int[] dimensions, @ByRef HalfNDArray target);
        public native HalfNDArray permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native HalfNDArray permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native HalfNDArray permute(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native HalfNDArray permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native HalfNDArray permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native HalfNDArray permute(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native void permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@Cast("const Nd4jLong*") long[] dimensions, int rank, @ByRef HalfNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, @ByRef HalfNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, @ByRef HalfNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector long[] dimensions, @ByRef HalfNDArray target);

        /**
         * This method streamlines given view or permuted array, and reallocates buffer
         */
        public native void streamline(char order/*='a'*/);
        public native void streamline();



        /**
        *  check whether array is contiguous in memory
        */ 
        public native @Cast("bool") boolean isContiguous();

        /**
        *  prints information about array shape
        *  msg - message to print out 
        */ 
        public native void printShapeInfo(@Cast("char*") String msg/*=nullptr*/);
        public native void printShapeInfo();
        public native void printShapeInfo(@Cast("char*") BytePointer msg/*=nullptr*/);

        /**
        *  prints buffer elements
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printBuffer();
        public native void printBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        /**
        *  prints buffer elements, takes into account offset between elements (element-wise-stride)
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printIndexedBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printIndexedBuffer();
        public native void printIndexedBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        public native @StdString BytePointer asIndexedString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asIndexedString();
        public native @StdString BytePointer asString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asString();

        /**
        *  this method assigns values of given array to this one
        */ 
        public native void assign(@Const HalfNDArray other);

        /**
        *  this method assigns values of given array to this one
        */

        /**
        *  this method assigns given value to all elements in array
        */ 
        public native void assign(@Cast("const float16") short value);

        /**
        *  returns new copy of this array, optionally in different order
        */
        public native HalfNDArray dup(char newOrder/*='a'*/);
        public native HalfNDArray dup();

        /** 
        *  returns sum of all elements of array
        */
        public native @Cast("float16") short sumNumber();

        /**
        *  returns mean number of array
        */ 
        public native @Cast("float16") short meanNumber();


        /**
         * This method explicitly enforces new shape for this NDArray, old shape/stride information is lost
         */
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions);

        /**
        *  calculates sum along dimension(s) in this array and save it to created reduced array
        *  dimensions - array of dimensions to calculate sum over
        *  keepDims - if true then put unities in place of reduced dimensions
        */
        public native HalfNDArray sum(@StdVector IntPointer dimensions);
        public native HalfNDArray sum(@StdVector IntBuffer dimensions);
        public native HalfNDArray sum(@StdVector int[] dimensions);

		/**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector, result is stored in new array to be returned
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        */

        /**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector
        *  target - where to save result of reducing
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        *  extras - extra parameters
        */

        /**
        *  return variance of array elements set
        *  biasCorrected -  if true bias correction will be applied
        */

        /**
        *  apply scalar operation to array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns element index which corresponds to some condition imposed by operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns index of max element in a given array (optionally: along given dimension(s))
        *  dimensions - optional vector with dimensions
        */          
        public native @Cast("Nd4jLong") long argMax();

        /**
        *  apply OpName transformation directly to array
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to array and store result in target
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to this array and store result in new array being returned
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in this array
        *  other - second array necessary for pairwise operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in target array
        *  other - second array necessary for pairwise operation
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast a smaller array (tad) along  bigger one (this)
        *  tad - array to broadcast
        *  dimensions -  dimensions array to broadcast along
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  target - where to store result
        *  checkTargetShape - if true check whether target shape is suitable for broadcasting
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input array which is simple scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */


// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  apply OpName random operation to array 
        *  buffer - pointer on RandomBuffer
        *  y - optional input array
        *  z - optional input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *   apply transpose operation to the copy of this array, that is this array remains unaffected 
        */
        public native HalfNDArray transpose();
        public native @ByVal HalfNDArray transp();

        /**
        *  perform transpose operation and store result in target, this array remains unaffected 
        *  target - where to store result
        */ 
        public native void transpose(@ByRef HalfNDArray target);

        /**
        *  apply in-place transpose operation to this array, so this array becomes transposed 
        */ 
        public native void transposei();

        /**
        *  return array pointing on certain range of this array
        *  index - the number of array to be returned among set of possible arrays 
        *  dimensions - array of dimensions to point on
        */
        public native HalfNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntPointer dimensions);
        public native HalfNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntBuffer dimensions);
        public native HalfNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector int[] dimensions);

        /**
        *  returns the number of arrays pointing on specified dimension(s)
        *  dimensions - array of dimensions to point on
        */
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntPointer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector int[] dimensions);

        /**
        *  returns true if elements of two arrays are equal to within given epsilon value
        *  other - input array to compare
        *  eps - epsilon, this value defines the precision of elements comparison
        */
        public native @Cast("bool") boolean equalsTo(@Const HalfNDArray other, @Cast("float16") short eps/*=(T) 1e-5f*/);
        public native @Cast("bool") boolean equalsTo(@Const HalfNDArray other);
        
        /**
        *  add given row vector to all rows of this array
        *  row - row vector to add
        */
        public native void addiRowVector(@Const HalfNDArray row);

        /**
        *  add given row vector to all rows of this array, store result in target
        *  row - row vector to add
        *  target - where to store result
        */
        public native void addRowVector(@Const HalfNDArray row, HalfNDArray target);

        /**
        *  subtract given row vector from all rows of this array, store result in target
        *  row - row vector to subtract
        *  target - where to store result
        */
        public native void subRowVector(@Const HalfNDArray row, HalfNDArray target);
        
        /**
        *  multiply all rows of this array on given row vector, store result in target
        *  row - row vector to multiply on
        *  target - where to store result
        */
        public native void mulRowVector(@Const HalfNDArray row, HalfNDArray target);

        /**
        *  divide all rows of this array on given row vector, store result in target
        *  row - row vector to divide on
        *  target - where to store result
        */
        public native void divRowVector(@Const HalfNDArray row, HalfNDArray target);
        
        /**
        *  add given column vector to all columns of this array, store result in target
        *  column - column vector to add
        *  target - where to store result
        */
        public native void addColumnVector(@Const HalfNDArray column, HalfNDArray target);

        /**
        *  add given column vector to all columns of this array, this array becomes affected (in-place operation)
        *  column - column vector to add
        */
		public native void addiColumnVector(@Const HalfNDArray column);

        /**
        *  multiply all columns of this array on given column vector, this array becomes affected (in-place operation)
        *  column - column vector to multiply on
        */
		public native void muliColumnVector(@Const HalfNDArray column);

        /**
        *  returns number of bytes used by _buffer & _shapeInfo
        */
        public native @Cast("Nd4jLong") long memoryFootprint();
        
        /**
        *  these methods suited for FlatBuffers use
        */
        public native @Cast("float16*") @StdVector ShortPointer getBufferAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeInfoAsVector();
        public native @Cast("int64_t*") @StdVector LongPointer getShapeInfoAsFlatVector();
				
        /**
        *  set new order and shape in case of suitable array length (in-place operation)
        *  order - order to set
        *  shape - shape to set
        *
        *  if there was permute applied before or there are weird strides, then new buffer is allocated for array
        */
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector long[] shape);
	
        /**
        *  creates new array with corresponding order and shape, new array will point on _buffer of this array
        *  order - order to set
        *  shape - shape to set
        *
        * if permute have been applied before or there are weird strides, then new buffer is allocated for new array
        */
		public native HalfNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native HalfNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native HalfNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		
        /**
        *  calculate strides and set given order
        *  order - order to set
        */
		public native void updateStrides(char order);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        */
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  returns new array which is created by repeating of this array the number of times given by reps 
        *  repeats - contains numbers of repetitions
        */
		public native @ByVal HalfNDArray tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native @ByVal HalfNDArray tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native @ByVal HalfNDArray tile(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        *  target - where to store result
        */
        public native void tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats, @ByRef HalfNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats, @ByRef HalfNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector long[] repeats, @ByRef HalfNDArray target);

        /**
        *  change an array by repeating it the number of times to acquire the new shape which is the same as target shape        
        *  target - where to store result
        */
        public native void tile(@ByRef HalfNDArray target);
        
        /**
        *  returns an array which is result of broadcasting of this and other arrays 
        *  other - input array
        */
		public native HalfNDArray broadcast(@Const @ByRef HalfNDArray other);
		
        /**
        *  check whether array's rows (arg=0) or columns (arg=1) create orthogonal basis
        *  arg - 0 -> row, 1 -> column
        */
		public native @Cast("bool") boolean hasOrthonormalBasis(int arg); 
				
        /**
        *  check whether array is identity matrix
        */
		public native @Cast("bool") boolean isIdentityMatrix(); 
		
        /**
        *  check whether array is unitary matrix
        */
		public native @Cast("bool") boolean isUnitary(); 
                        
        /**
        *  reduces dimensions in this array relying on index operation OpName
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  reduces dimensions in array relying on index operation OpName
        *  target - where to store result
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (tads not axis)
        *  extraArgs - extra parameters for operation
        */
                
        /**
        *  apply reduce3 (exec) operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (same as reduceAlongDimension)
        *  extraArgs - extra parameters for operation
        */


        /**
        *  returns variance along given dimensions
        *  biasCorrected -  if true bias correction will be applied
        *  dimensions - vector of dimensions to calculate variance along
        */

        /**
        *  operator returns subarray with buffer pointing at this->_buffer with offset defined by given intervals
        *  idx - intervals of indexes which define the subarrays to point on, idx has form {dim0Start,dim0End,  dim1Start,dim1End, ....} and length (2 * this->rankOf())
        *        when (dimStart == dimEnd) then whole range will be used for current dimension
        *  keepUnitiesInShape - if false then eliminate unities from resulting array shape, for example {1,a,1,b} -> {a,b}
        */
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("Nd4jLong*") @StdVector LongPointer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("Nd4jLong*") @StdVector LongBuffer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("Nd4jLong*") @StdVector long[] idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);

        /**
        *  evaluates subarray with buffer pointing at this->_buffer and offset defined by given sequential index subArrIdx and dimensions in dimsToExclude
        *  subArrIdx - index of current sub-array
        *  dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5], and subArrIdx must be in range [0,7]
        *                  if dimsToExclude is empty then idxRanges containing all zeros (means whole array) will be returned.
        */ 
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") HalfNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude);

        /**
        *  addition operator: array + other
        *  other - input array to add
        */
        public native @ByVal @Name("operator +") HalfNDArray add(@Const @ByRef HalfNDArray other);

        /**
        *  addition operator: array + scalar
        *  scalar - input scalar to add
        */
        public native @ByVal @Name("operator +") HalfNDArray add(@Cast("const float16") short scalar);

        /**
        *  friend functions which implement addition operator: scalar + array
        *  scalar - input scalar to add
        */
        
        
        
        
        /**
        *  addition unary operator array += other
        *  other - input array to add
        */
        public native @Name("operator +=") void addPut(@Const @ByRef HalfNDArray other);

        /**
        *  subtraction unary operator array -= other
        *  other - input array to add
        */
        public native @Name("operator -=") void subtractPut(@Const @ByRef HalfNDArray other);

        public native @Name("operator +=") void addPut(@Cast("const float16") short other);
        public native @Name("operator -=") void subtractPut(@Cast("const float16") short other);
        
        /**
        *  subtraction operator: array - other
        *  other - input array to subtract
        */
        public native @ByVal @Name("operator -") HalfNDArray subtract(@Const @ByRef HalfNDArray other);
        
        /**
        *  subtraction operator: array - scalar
        *  scalar - input scalar to subtract
        */
        public native @ByVal @Name("operator -") HalfNDArray subtract(@Cast("const float16") short scalar);        

        /**
        *  negative operator, it changes sign of all array elements on opposite
        */
        public native @ByVal @Name("operator -") HalfNDArray subtract();

        /**
        *  friend functions which implement subtraction operator: scalar - array
        *  scalar - input scalar to subtract
        */
        
        
        

        /**
        *  pairwise multiplication operator: array * other
        *  other - input array to multiply on
        */
        public native @ByVal @Name("operator *") HalfNDArray multiply(@Const @ByRef HalfNDArray other);        
    
        /**
        *  multiplication operator: array * scalar
        *  scalar - input scalar to multiply on
        */
        public native @ByVal @Name("operator *") HalfNDArray multiply(@Cast("const float16") short scalar);
        
        /**
        *  pairwise multiplication unary operator array *= other
        *  other - input array to multiply on
        */
        public native @Name("operator *=") void multiplyPut(@Const @ByRef HalfNDArray other);

        /**
        *  multiplication unary operator array *= scalar
        *  scalar - input scalar to multiply on
        */
        public native @Name("operator *=") void multiplyPut(@Cast("const float16") short scalar);

        /**
        *  pairwise division operator: array / other
        *  other - input array to divide on
        */
        public native @ByVal @Name("operator /") HalfNDArray divide(@Const @ByRef HalfNDArray other);        

        /**
        *  division operator: array / scalar
        *  scalar - input scalar to divide each array element on
        */
        public native @ByVal @Name("operator /") HalfNDArray divide(@Cast("const float16") short scalar);

        /**
        *  pairwise division unary operator: array /= other
        *  other - input array to divide on
        */
        public native @Name("operator /=") void dividePut(@Const @ByRef HalfNDArray other);

        /**
        *  division unary operator: array /= scalar
        *  scalar - input scalar to divide on
        */
        public native @Name("operator /=") void dividePut(@Cast("const float16") short scalar);

        /**
        *  friend function which implements mathematical multiplication of two arrays
        *  left - input array
        *  right - input array
        */
        

        /**
        *  this method assigns elements of other array to the subarray of this array defined by given intervals
        *  other - input array to assign elements from
        *  idx - intervals of indexes which define the subarray
        */ 
        public native void assign(@Const @ByRef HalfNDArray other, @Const @ByRef Intervals idx);

        /**
        *  return vector containing _buffer as flat binary array
        */
        public native @StdVector BytePointer asByteVector();

        /**
        *  makes array to be identity matrix (not necessarily square), that is set all diagonal elements = 1, rest = 0
        */
        public native void setIdentity();

        /**
        *  swaps the contents of tow arrays, 
        *  PLEASE NOTE: method doesn't take into account the shapes of arrays, shapes may be different except one condition: arrays lengths must be the same 
        */
        public native void swapUnsafe(@ByRef HalfNDArray other);

        /**
        *  return vector with buffer which points on corresponding diagonal elements of array
        *  type - means of vector to be returned: column ('c') or row ('r')
        */
        public native HalfNDArray diagonal(char type );

        /**
        *  fill matrix with given value starting from specified diagonal in given direction, works only with 2D matrix
        *
        *  diag - diagonal starting from matrix is filled. 
        *      diag = 0 corresponds to main diagonal, 
        *      diag < 0 below main diagonal
        *      diag > 0 above main diagonal
        *  direction - in what direction to fill matrix. There are 2 possible directions:
        *      'u' - fill up, mathematically this corresponds to lower triangular matrix 
        *      'l' - fill down, mathematically this corresponds to upper triangular matrix
        */
        public native void setValueInDiagMatrix(@Cast("const float16") short value, int diag, char direction);

		/**
        *  change an array by repeating it the number of times in order to acquire new shape equal to the input shape
        *
        *  shape  - contains new shape to broadcast array to 
        *  target - optional argument, if target != nullptr the resulting array will be placed in target, in opposite case tile operation is done in place
        */
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape, HalfNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape, HalfNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape, HalfNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  calculates the trace of an array, that is sum of elements on main diagonal = sum array[i, i, i, ...]
        */
        public native @Cast("float16") short getTrace();

        /**
        *  fill array linearly as follows: arr[0] = from, arr[1] = from+step, arr[2] = from+2*step, ...
        */
        public native void linspace(@Cast("const float16") short from, @Cast("const float16") short step/*=1.0f*/);
        public native void linspace(@Cast("const float16") short from);

        public native HalfNDArray createUninitialized();

        public native HalfResultSet multipleTensorsAlongDimension(@StdVector IntPointer indices, @StdVector IntPointer dimensions);
        public native HalfResultSet multipleTensorsAlongDimension(@StdVector IntBuffer indices, @StdVector IntBuffer dimensions);
        public native HalfResultSet multipleTensorsAlongDimension(@StdVector int[] indices, @StdVector int[] dimensions);

        public native HalfResultSet allTensorsAlongDimension(@StdVector IntPointer dimensions);
        public native HalfResultSet allTensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native HalfResultSet allTensorsAlongDimension(@StdVector int[] dimensions);

        public native HalfResultSet allExamples();

        /**
        *  default destructor
        */ 

        /**
        *  set _shapeInfo
        */
        public native void setShapeInfo(@Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") long[] shapeInfo);

        /**
        *  set _buffer
        */
        public native void setBuffer(@Cast("float16*") ShortPointer buffer);
        public native void setBuffer(@Cast("float16*") ShortBuffer buffer);
        public native void setBuffer(@Cast("float16*") short[] buffer);

        /**
        *  set _isBuffAlloc and _isShapeAlloc
        */
        public native void triggerAllocationFlag(@Cast("bool") boolean bufferAllocated, @Cast("bool") boolean shapeAllocated);
        
        /**
        *  returns the value of "dim" dimension 
        */
        public native @Cast("Nd4jLong") long sizeAt(int dim);

        /**        
        *  returns order of array
        */
        public native char ordering();

        /**
        *  return _isView
        */ 
        public native @Cast("bool") boolean isView();

        /**
        *  returns shape portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeOf();
        
        /**
        *  returns strides portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer stridesOf();

        /**
        *  returns rank of array
        */
        public native int rankOf();        

        /** 
        *  returns length of array
        */
        public native @Cast("Nd4jLong") long lengthOf();

        /**
        *  returns number of rows in array
        */
        public native @Cast("Nd4jLong") long rows();

        /**
        *  returns number of columns in array
        */ 
        public native @Cast("Nd4jLong") long columns();

        /**
        *  returns size of array elements type
        */ 
        public native int sizeOfT();

        /**
        *  returns element-wise-stride
        */ 
        public native @Cast("Nd4jLong") long ews();

        // returns true if arrays have same shape
        public native @Cast("bool") boolean isSameShape(@Const HalfNDArray other);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  returns true if these two NDArrays have same rank, dimensions, strides, ews and order
        */
        public native @Cast("bool") boolean isSameShapeStrict(@Const HalfNDArray other);

        /**
        *  returns true if buffer && shapeInfo were defined (non nullptr)
        */
        public native @Cast("bool") boolean nonNull();

        /** 
        *  returns array element with given index from linear buffer
        *  i - element index in array
        */
        public native @Cast("float16") short getScalar(@Cast("const Nd4jLong") long i);

        /** 
        *  returns array element with given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        */
        public native @Cast("float16") short getIndexedScalar(@Cast("const Nd4jLong") long i);
        
        /** 
        *  returns element with given indexes from 2D array 
        *  i - number of row 
        *  j - number of column
        */
        public native @Cast("float16") short getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /** 
        *  returns element with given indexes from 3D array 
        *  i - height
        *  j - width
        *  k - depth
        */
        public native @Cast("float16") short getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);
        
        /** 
        *  assigns given scalar to array element by given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putIndexedScalar(@Cast("const Nd4jLong") long i, @Cast("const float16") short value);

        /** 
        *  assigns given scalar to array element by given index, regards array buffer as linear
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const float16") short value);

        /** 
        *  assigns given scalar to 2D array element by given indexes
        *  i - number of row
        *  j - number of row
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const float16") short value);

        /** 
        *  assigns given scalar to 3D array element by given indexes
        *  i - height
        *  j - width
        *  k - depth
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k, @Cast("const float16") short value);

        /**
        *  returns true if array is 2D
        */
        public native @Cast("bool") boolean isMatrix();

        /**
        *  returns true if array is vector
        */
        public native @Cast("bool") boolean isVector();

        /**
        *  returns true if array is column vector
        */
        public native @Cast("bool") boolean isColumnVector();

        /**
        *  returns true if array is row vector
        */
        public native @Cast("bool") boolean isRowVector();

        /**
        *  returns true if array is scalar
        */
        public native @Cast("bool") boolean isScalar();

        /**
        *  inline accessing operator for matrix, i - absolute index        
        */

        /**
        *  inline modifying operator for matrix, i - absolute index        
        */
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortPointer apply(@Cast("const Nd4jLong") long i);

        /**
        *  inline accessing operator for 2D array, i - row, j - column
        */

        /**
        *  inline modifying operator for 2D array, i - row, j - column
        */
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortPointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /**
        *  inline accessing operator for 3D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for 3D array, i - height, j - width, k - depth
        */ 
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortPointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);

        /**
        *  inline modifying operator for 4D array, i - height, j - width, k - depth
        */ 
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortPointer apply(@Cast("const Nd4jLong") long t, @Cast("const Nd4jLong") long u, @Cast("const Nd4jLong") long v, @Cast("const Nd4jLong") long w);

        /**
        *  inline accessing operator for 4D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */ 
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortPointer apply(@Cast("const Nd4jLong*") LongPointer idx);
        public native @Cast("float16*") @ByRef @Name("operator ()") ShortBuffer apply(@Cast("const Nd4jLong*") LongBuffer idx);
        public native @Cast("float16*") @ByRef @Name("operator ()") short[] apply(@Cast("const Nd4jLong*") long[] idx);

        /**
        *  inline accessing operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */


        public native @Cast("bool") boolean isAttached();

        public native HalfNDArray detach();


        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef HalfNDArray other);
    }


    @Name("nd4j::NDArray<double>") @NoOffset public static class DoubleNDArray extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DoubleNDArray(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public DoubleNDArray(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public DoubleNDArray position(long position) {
            return (DoubleNDArray)super.position(position);
        }
    

        public static native DoubleNDArray createEmpty(Workspace workspace/*=nullptr*/);
        public static native DoubleNDArray createEmpty();

        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, double value, char order/*='c'*/);
        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongPointer shape, double value);
        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, double value, char order/*='c'*/);
        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector LongBuffer shape, double value);
        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, double value, char order/*='c'*/);
        public static native DoubleNDArray valueOf(@Cast("Nd4jLong*") @StdVector long[] shape, double value);
        
        public static native DoubleNDArray linspace(double from, double to, @Cast("const Nd4jLong") long numElements);

        public static native DoubleNDArray scalar(double value);

        
        /**
        *  default constructor, do not allocate memory, memory for array is passed from outside 
        */
        public DoubleNDArray(DoublePointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(DoublePointer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongPointer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public DoubleNDArray() { super((Pointer)null); allocate(); }
        private native void allocate();
        public DoubleNDArray(DoubleBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(DoubleBuffer buffer/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(double[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, shapeInfo, workspace); }
        private native void allocate(double[] buffer/*=nullptr*/, @Cast("Nd4jLong*") long[] shapeInfo/*=nullptr*/, Workspace workspace/*=nullptr*/);

        
        /**
         * Constructor for scalar NDArray
         */
        public DoubleNDArray(double scalar) { super((Pointer)null); allocate(scalar); }
        private native void allocate(double scalar);

        /**
        *  copy constructor
        */
        public DoubleNDArray(@Const @ByRef DoubleNDArray other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef DoubleNDArray other);

        /**
        *  move constructor
        */

// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  constructor, create empty array stored at given workspace
        */
        public DoubleNDArray(Workspace workspace) { super((Pointer)null); allocate(workspace); }
        private native void allocate(Workspace workspace);

        /**
        *  this constructor creates new NDArray with shape matching "other" array, do not copy "other" elements into new array
        */
        public DoubleNDArray(@Const DoubleNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(other, copyStrides, workspace); }
        private native void allocate(@Const DoubleNDArray other, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
				
        /**
		*  constructor creates new NDArray using shape information from "shapeInfo", set all elements in new array to be zeros, if copyStrides is true then use stride values from "shapeInfo", else calculate strides independently 
        */
		public DoubleNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public DoubleNDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo);
		public DoubleNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public DoubleNDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
		public DoubleNDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, workspace); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean copyStrides/*=false*/, Workspace workspace/*=nullptr*/);
		public DoubleNDArray(@Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo);

        /**
        *  this constructor creates new array using shape information contained in vector argument    
        */
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        * This constructor creates new array with elements copied from data and using shape information stored in shape
        *
        * PLEASE NOTE: data will be copied AS IS, without respect to specified order. You must ensure order match here.
        */
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(order, shape, data, workspace); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data);

        /**
        *  this constructor creates new array using given buffer (without memory allocating) and shape information stored in shape
        */
        public DoubleNDArray(DoublePointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(DoublePointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(DoublePointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(DoublePointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public DoubleNDArray(DoubleBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(DoubleBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(DoubleBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(DoubleBuffer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public DoubleNDArray(double[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(buffer, order, shape, workspace); }
        private native void allocate(double[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape, Workspace workspace/*=nullptr*/);
        public DoubleNDArray(double[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(buffer, order, shape); }
        private native void allocate(double[] buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  copy assignment operator
        */
        public native @ByRef @Name("operator =") DoubleNDArray put(@Const @ByRef DoubleNDArray other);

        /**
        *  move assignment operator
        */

        /**
        *  assignment operator, assigns the same scalar to all array elements 
        */
        public native @ByRef @Name("operator =") DoubleNDArray put(double scalar);

        /**
        *   operators for memory allocation and deletion
        */ 
        public native @Name("operator new") Pointer _new(@Cast("size_t") long i);
        public native @Name("operator delete") void _delete(Pointer p);

        /**
        *  method replaces existing buffer/shapeinfo, AND releases original pointers (if releaseExisting TRUE)
        */
        public native void replacePointers(DoublePointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(DoublePointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void replacePointers(DoubleBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(DoubleBuffer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void replacePointers(double[] buffer, @Cast("Nd4jLong*") long[] shapeInfo, @Cast("const bool") boolean releaseExisting/*=true*/);
        public native void replacePointers(double[] buffer, @Cast("Nd4jLong*") long[] shapeInfo);
 
        /**
        *  create a new array by replicating current array by repeats times along given dimension
        *  dimension - dimension along which to repeat elements
        *  repeats - number of repetitions
        */        
        public native DoubleNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongPointer repeats);
        public native DoubleNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector LongBuffer repeats);
        public native DoubleNDArray repeat(int dimension, @Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */
        public static native @ByVal DoubleNDArray quantize(@ByRef DoubleNDArray array);

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */

        /**
        *  fill target array by repeating current array 
        *  dimension - dimension along which to repeat elements        
        */
        public native void repeat(int dimension, @ByRef DoubleNDArray target);

        /**
        *  return _dataType;
        */
        public native @Cast("nd4j::DataType") int dataType();

        /**
        *  creates array which is view of this array
        */
        public native DoubleNDArray getView();

        /**
        *  creates array which points on certain sub-range of this array, sub-range is defined by given indices
        */
        public native DoubleNDArray subarray(@ByRef IndicesList indices);
        public native DoubleNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongPointer strides);
        public native DoubleNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector LongBuffer strides);
        public native DoubleNDArray subarray(@ByRef IndicesList indices, @Cast("Nd4jLong*") @StdVector long[] strides);
        public native DoubleNDArray subarray(@Const @ByRef Intervals idx);

        /**
        *  cast array elements to given dtype
        */ 
        public native DoubleNDArray cast(@Cast("nd4j::DataType") int dtype);
        public native void cast(DoubleNDArray target, @Cast("nd4j::DataType") int dtype);

        /**
        *   returns _workspace
        */
        public native Workspace getWorkspace();

        /**
        *   returns _buffer
        */
        public native DoublePointer getBuffer();
        public native DoublePointer buffer();

        /**
        *   returns _shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeInfo();
        public native @Cast("Nd4jLong*") LongPointer getShapeInfo();

        /**
        *  if _bufferD==nullptr return _buffer, else return _bufferD
        */
        public native DoublePointer specialBuffer();

        /**
         * Returns True if it's legally empty NDArray, or false otherwise
         * @return
         */
        public native @Cast("bool") boolean isEmpty();

        /**
        *  if _shapeInfoD==nullptr return _shapeInfo, else return _shapeInfoD
        */
        public native @Cast("Nd4jLong*") LongPointer specialShapeInfo();

        /**
        *  set values for _bufferD and _shapeInfoD
        */
        public native void setSpecialBuffers(DoublePointer buffer, @Cast("Nd4jLong*") LongPointer shape);
        public native void setSpecialBuffers(DoubleBuffer buffer, @Cast("Nd4jLong*") LongBuffer shape);
        public native void setSpecialBuffers(double[] buffer, @Cast("Nd4jLong*") long[] shape);

        /**
        *  permutes (in-place) the dimensions in array according to "dimensions" array
        */
        public native @Cast("bool") boolean permutei(@StdVector IntPointer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector IntBuffer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector int[] dimensions);
        public native @Cast("bool") boolean permutei(@Const IntPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const IntBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const int[] dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native @Cast("bool") boolean isFinite();
        public native @Cast("bool") boolean hasNaNs();
        public native @Cast("bool") boolean hasInfs();

        /**
        *  permutes the dimensions in array according to "dimensions" array, new array points on _buffer of this array
        */
        public native DoubleNDArray permute(@StdVector IntPointer dimensions);
        public native DoubleNDArray permute(@StdVector IntBuffer dimensions);
        public native DoubleNDArray permute(@StdVector int[] dimensions);
        public native DoubleNDArray permute(@Const IntPointer dimensions, int rank);
        public native DoubleNDArray permute(@Const IntBuffer dimensions, int rank);
        public native DoubleNDArray permute(@Const int[] dimensions, int rank);

        public native void permute(@Const IntPointer dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@Const IntBuffer dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@Const int[] dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@StdVector IntPointer dimensions, @ByRef DoubleNDArray target);
        public native void permute(@StdVector IntBuffer dimensions, @ByRef DoubleNDArray target);
        public native void permute(@StdVector int[] dimensions, @ByRef DoubleNDArray target);
        public native DoubleNDArray permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native DoubleNDArray permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native DoubleNDArray permute(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native DoubleNDArray permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native DoubleNDArray permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native DoubleNDArray permute(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native void permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@Cast("const Nd4jLong*") long[] dimensions, int rank, @ByRef DoubleNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, @ByRef DoubleNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, @ByRef DoubleNDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector long[] dimensions, @ByRef DoubleNDArray target);

        /**
         * This method streamlines given view or permuted array, and reallocates buffer
         */
        public native void streamline(char order/*='a'*/);
        public native void streamline();



        /**
        *  check whether array is contiguous in memory
        */ 
        public native @Cast("bool") boolean isContiguous();

        /**
        *  prints information about array shape
        *  msg - message to print out 
        */ 
        public native void printShapeInfo(@Cast("char*") String msg/*=nullptr*/);
        public native void printShapeInfo();
        public native void printShapeInfo(@Cast("char*") BytePointer msg/*=nullptr*/);

        /**
        *  prints buffer elements
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printBuffer();
        public native void printBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        /**
        *  prints buffer elements, takes into account offset between elements (element-wise-stride)
        *  msg - message to print out 
        *  limit - number of array elements to print out
        */ 
        public native void printIndexedBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);
        public native void printIndexedBuffer();
        public native void printIndexedBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long limit/*=-1*/);

        public native @StdString BytePointer asIndexedString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asIndexedString();
        public native @StdString BytePointer asString(@Cast("Nd4jLong") long limit/*=-1*/);
        public native @StdString BytePointer asString();

        /**
        *  this method assigns values of given array to this one
        */ 
        public native void assign(@Const DoubleNDArray other);

        /**
        *  this method assigns values of given array to this one
        */

        /**
        *  this method assigns given value to all elements in array
        */ 
        public native void assign(double value);

        /**
        *  returns new copy of this array, optionally in different order
        */
        public native DoubleNDArray dup(char newOrder/*='a'*/);
        public native DoubleNDArray dup();

        /** 
        *  returns sum of all elements of array
        */
        public native double sumNumber();

        /**
        *  returns mean number of array
        */ 
        public native double meanNumber();


        /**
         * This method explicitly enforces new shape for this NDArray, old shape/stride information is lost
         */
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions, char order/*='a'*/);
        public native void enforce(@Cast("Nd4jLong*") @StdVector long[] dimensions);

        /**
        *  calculates sum along dimension(s) in this array and save it to created reduced array
        *  dimensions - array of dimensions to calculate sum over
        *  keepDims - if true then put unities in place of reduced dimensions
        */
        public native DoubleNDArray sum(@StdVector IntPointer dimensions);
        public native DoubleNDArray sum(@StdVector IntBuffer dimensions);
        public native DoubleNDArray sum(@StdVector int[] dimensions);

		/**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector, result is stored in new array to be returned
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        */

        /**
        *  method reduces array by excluding its shapes along dimensions present in given dimensions vector
        *  target - where to save result of reducing
        *  dimensions - array of dimensions to reduce along
        *  keepDims - if true then put unities in place of reduced dimensions
        *  extras - extra parameters
        */

        /**
        *  return variance of array elements set
        *  biasCorrected -  if true bias correction will be applied
        */

        /**
        *  apply scalar operation to array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns element index which corresponds to some condition imposed by operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  returns index of max element in a given array (optionally: along given dimension(s))
        *  dimensions - optional vector with dimensions
        */          
        public native @Cast("Nd4jLong") long argMax();

        /**
        *  apply OpName transformation directly to array
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to array and store result in target
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply OpName transformation to this array and store result in new array being returned
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in this array
        *  other - second array necessary for pairwise operation
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply pairwise OpName transformation based on "this" and "other" arras elements, store result in target array
        *  other - second array necessary for pairwise operation
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast a smaller array (tad) along  bigger one (this)
        *  tad - array to broadcast
        *  dimensions -  dimensions array to broadcast along
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  extraParams - extra parameters for operation
        */

        /**
        *  apply operation which requires broadcasting, broadcast one tensor along another, also this method checks the possibility of broadcasting
        *  other - input array 
        *  target - where to store result
        *  checkTargetShape - if true check whether target shape is suitable for broadcasting
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */

        /** 
        *  apply a scalar operation to an array
        *  scalar - input array which is simple scalar
        *  target - where to store result
        *  extraParams - extra parameters for operation
        */


// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *  apply OpName random operation to array 
        *  buffer - pointer on RandomBuffer
        *  y - optional input array
        *  z - optional input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *   apply transpose operation to the copy of this array, that is this array remains unaffected 
        */
        public native DoubleNDArray transpose();
        public native @ByVal DoubleNDArray transp();

        /**
        *  perform transpose operation and store result in target, this array remains unaffected 
        *  target - where to store result
        */ 
        public native void transpose(@ByRef DoubleNDArray target);

        /**
        *  apply in-place transpose operation to this array, so this array becomes transposed 
        */ 
        public native void transposei();

        /**
        *  return array pointing on certain range of this array
        *  index - the number of array to be returned among set of possible arrays 
        *  dimensions - array of dimensions to point on
        */
        public native DoubleNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntPointer dimensions);
        public native DoubleNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector IntBuffer dimensions);
        public native DoubleNDArray tensorAlongDimension(@Cast("Nd4jLong") long index, @StdVector int[] dimensions);

        /**
        *  returns the number of arrays pointing on specified dimension(s)
        *  dimensions - array of dimensions to point on
        */
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntPointer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector int[] dimensions);

        /**
        *  returns true if elements of two arrays are equal to within given epsilon value
        *  other - input array to compare
        *  eps - epsilon, this value defines the precision of elements comparison
        */
        public native @Cast("bool") boolean equalsTo(@Const DoubleNDArray other, double eps/*=(T) 1e-5f*/);
        public native @Cast("bool") boolean equalsTo(@Const DoubleNDArray other);
        
        /**
        *  add given row vector to all rows of this array
        *  row - row vector to add
        */
        public native void addiRowVector(@Const DoubleNDArray row);

        /**
        *  add given row vector to all rows of this array, store result in target
        *  row - row vector to add
        *  target - where to store result
        */
        public native void addRowVector(@Const DoubleNDArray row, DoubleNDArray target);

        /**
        *  subtract given row vector from all rows of this array, store result in target
        *  row - row vector to subtract
        *  target - where to store result
        */
        public native void subRowVector(@Const DoubleNDArray row, DoubleNDArray target);
        
        /**
        *  multiply all rows of this array on given row vector, store result in target
        *  row - row vector to multiply on
        *  target - where to store result
        */
        public native void mulRowVector(@Const DoubleNDArray row, DoubleNDArray target);

        /**
        *  divide all rows of this array on given row vector, store result in target
        *  row - row vector to divide on
        *  target - where to store result
        */
        public native void divRowVector(@Const DoubleNDArray row, DoubleNDArray target);
        
        /**
        *  add given column vector to all columns of this array, store result in target
        *  column - column vector to add
        *  target - where to store result
        */
        public native void addColumnVector(@Const DoubleNDArray column, DoubleNDArray target);

        /**
        *  add given column vector to all columns of this array, this array becomes affected (in-place operation)
        *  column - column vector to add
        */
		public native void addiColumnVector(@Const DoubleNDArray column);

        /**
        *  multiply all columns of this array on given column vector, this array becomes affected (in-place operation)
        *  column - column vector to multiply on
        */
		public native void muliColumnVector(@Const DoubleNDArray column);

        /**
        *  returns number of bytes used by _buffer & _shapeInfo
        */
        public native @Cast("Nd4jLong") long memoryFootprint();
        
        /**
        *  these methods suited for FlatBuffers use
        */
        public native @StdVector DoublePointer getBufferAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeAsVector();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeInfoAsVector();
        public native @Cast("int64_t*") @StdVector LongPointer getShapeInfoAsFlatVector();
				
        /**
        *  set new order and shape in case of suitable array length (in-place operation)
        *  order - order to set
        *  shape - shape to set
        *
        *  if there was permute applied before or there are weird strides, then new buffer is allocated for array
        */
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector long[] shape);
	
        /**
        *  creates new array with corresponding order and shape, new array will point on _buffer of this array
        *  order - order to set
        *  shape - shape to set
        *
        * if permute have been applied before or there are weird strides, then new buffer is allocated for new array
        */
		public native DoubleNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native DoubleNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native DoubleNDArray reshape(char order, @Cast("Nd4jLong*") @StdVector long[] shape);
		
        /**
        *  calculate strides and set given order
        *  order - order to set
        */
		public native void updateStrides(char order);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        */
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  returns new array which is created by repeating of this array the number of times given by reps 
        *  repeats - contains numbers of repetitions
        */
		public native @ByVal DoubleNDArray tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native @ByVal DoubleNDArray tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native @ByVal DoubleNDArray tile(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        *  target - where to store result
        */
        public native void tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats, @ByRef DoubleNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats, @ByRef DoubleNDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector long[] repeats, @ByRef DoubleNDArray target);

        /**
        *  change an array by repeating it the number of times to acquire the new shape which is the same as target shape        
        *  target - where to store result
        */
        public native void tile(@ByRef DoubleNDArray target);
        
        /**
        *  returns an array which is result of broadcasting of this and other arrays 
        *  other - input array
        */
		public native DoubleNDArray broadcast(@Const @ByRef DoubleNDArray other);
		
        /**
        *  check whether array's rows (arg=0) or columns (arg=1) create orthogonal basis
        *  arg - 0 -> row, 1 -> column
        */
		public native @Cast("bool") boolean hasOrthonormalBasis(int arg); 
				
        /**
        *  check whether array is identity matrix
        */
		public native @Cast("bool") boolean isIdentityMatrix(); 
		
        /**
        *  check whether array is unitary matrix
        */
		public native @Cast("bool") boolean isUnitary(); 
                        
        /**
        *  reduces dimensions in this array relying on index operation OpName
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  reduces dimensions in array relying on index operation OpName
        *  target - where to store result
        *  dimensions - vector of dimensions to reduce along
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  extraArgs - extra parameters for operation
        */

        /**
        *  apply reduce3 operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (tads not axis)
        *  extraArgs - extra parameters for operation
        */
                
        /**
        *  apply reduce3 (exec) operation OpName to this and other array, return result in new output array
        *  other - input array
        *  dimensions - vector of dimensions to reduce along (same as reduceAlongDimension)
        *  extraArgs - extra parameters for operation
        */


        /**
        *  returns variance along given dimensions
        *  biasCorrected -  if true bias correction will be applied
        *  dimensions - vector of dimensions to calculate variance along
        */

        /**
        *  operator returns subarray with buffer pointing at this->_buffer with offset defined by given intervals
        *  idx - intervals of indexes which define the subarrays to point on, idx has form {dim0Start,dim0End,  dim1Start,dim1End, ....} and length (2 * this->rankOf())
        *        when (dimStart == dimEnd) then whole range will be used for current dimension
        *  keepUnitiesInShape - if false then eliminate unities from resulting array shape, for example {1,a,1,b} -> {a,b}
        */
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("Nd4jLong*") @StdVector LongPointer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("Nd4jLong*") @StdVector LongBuffer idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("Nd4jLong*") @StdVector long[] idx, @Cast("bool") boolean keepUnitiesInShape/*=false*/);

        /**
        *  evaluates subarray with buffer pointing at this->_buffer and offset defined by given sequential index subArrIdx and dimensions in dimsToExclude
        *  subArrIdx - index of current sub-array
        *  dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5], and subArrIdx must be in range [0,7]
        *                  if dimsToExclude is empty then idxRanges containing all zeros (means whole array) will be returned.
        */ 
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") DoubleNDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude);

        /**
        *  addition operator: array + other
        *  other - input array to add
        */
        public native @ByVal @Name("operator +") DoubleNDArray add(@Const @ByRef DoubleNDArray other);

        /**
        *  addition operator: array + scalar
        *  scalar - input scalar to add
        */
        public native @ByVal @Name("operator +") DoubleNDArray add(double scalar);

        /**
        *  friend functions which implement addition operator: scalar + array
        *  scalar - input scalar to add
        */
        
        
        
        
        /**
        *  addition unary operator array += other
        *  other - input array to add
        */
        public native @Name("operator +=") void addPut(@Const @ByRef DoubleNDArray other);

        /**
        *  subtraction unary operator array -= other
        *  other - input array to add
        */
        public native @Name("operator -=") void subtractPut(@Const @ByRef DoubleNDArray other);

        public native @Name("operator +=") void addPut(double other);
        public native @Name("operator -=") void subtractPut(double other);
        
        /**
        *  subtraction operator: array - other
        *  other - input array to subtract
        */
        public native @ByVal @Name("operator -") DoubleNDArray subtract(@Const @ByRef DoubleNDArray other);
        
        /**
        *  subtraction operator: array - scalar
        *  scalar - input scalar to subtract
        */
        public native @ByVal @Name("operator -") DoubleNDArray subtract(double scalar);        

        /**
        *  negative operator, it changes sign of all array elements on opposite
        */
        public native @ByVal @Name("operator -") DoubleNDArray subtract();

        /**
        *  friend functions which implement subtraction operator: scalar - array
        *  scalar - input scalar to subtract
        */
        
        
        

        /**
        *  pairwise multiplication operator: array * other
        *  other - input array to multiply on
        */
        public native @ByVal @Name("operator *") DoubleNDArray multiply(@Const @ByRef DoubleNDArray other);        
    
        /**
        *  multiplication operator: array * scalar
        *  scalar - input scalar to multiply on
        */
        public native @ByVal @Name("operator *") DoubleNDArray multiply(double scalar);
        
        /**
        *  pairwise multiplication unary operator array *= other
        *  other - input array to multiply on
        */
        public native @Name("operator *=") void multiplyPut(@Const @ByRef DoubleNDArray other);

        /**
        *  multiplication unary operator array *= scalar
        *  scalar - input scalar to multiply on
        */
        public native @Name("operator *=") void multiplyPut(double scalar);

        /**
        *  pairwise division operator: array / other
        *  other - input array to divide on
        */
        public native @ByVal @Name("operator /") DoubleNDArray divide(@Const @ByRef DoubleNDArray other);        

        /**
        *  division operator: array / scalar
        *  scalar - input scalar to divide each array element on
        */
        public native @ByVal @Name("operator /") DoubleNDArray divide(double scalar);

        /**
        *  pairwise division unary operator: array /= other
        *  other - input array to divide on
        */
        public native @Name("operator /=") void dividePut(@Const @ByRef DoubleNDArray other);

        /**
        *  division unary operator: array /= scalar
        *  scalar - input scalar to divide on
        */
        public native @Name("operator /=") void dividePut(double scalar);

        /**
        *  friend function which implements mathematical multiplication of two arrays
        *  left - input array
        *  right - input array
        */
        

        /**
        *  this method assigns elements of other array to the subarray of this array defined by given intervals
        *  other - input array to assign elements from
        *  idx - intervals of indexes which define the subarray
        */ 
        public native void assign(@Const @ByRef DoubleNDArray other, @Const @ByRef Intervals idx);

        /**
        *  return vector containing _buffer as flat binary array
        */
        public native @StdVector BytePointer asByteVector();

        /**
        *  makes array to be identity matrix (not necessarily square), that is set all diagonal elements = 1, rest = 0
        */
        public native void setIdentity();

        /**
        *  swaps the contents of tow arrays, 
        *  PLEASE NOTE: method doesn't take into account the shapes of arrays, shapes may be different except one condition: arrays lengths must be the same 
        */
        public native void swapUnsafe(@ByRef DoubleNDArray other);

        /**
        *  return vector with buffer which points on corresponding diagonal elements of array
        *  type - means of vector to be returned: column ('c') or row ('r')
        */
        public native DoubleNDArray diagonal(char type );

        /**
        *  fill matrix with given value starting from specified diagonal in given direction, works only with 2D matrix
        *
        *  diag - diagonal starting from matrix is filled. 
        *      diag = 0 corresponds to main diagonal, 
        *      diag < 0 below main diagonal
        *      diag > 0 above main diagonal
        *  direction - in what direction to fill matrix. There are 2 possible directions:
        *      'u' - fill up, mathematically this corresponds to lower triangular matrix 
        *      'l' - fill down, mathematically this corresponds to upper triangular matrix
        */
        public native void setValueInDiagMatrix(double value, int diag, char direction);

		/**
        *  change an array by repeating it the number of times in order to acquire new shape equal to the input shape
        *
        *  shape  - contains new shape to broadcast array to 
        *  target - optional argument, if target != nullptr the resulting array will be placed in target, in opposite case tile operation is done in place
        */
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape, DoubleNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape, DoubleNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape, DoubleNDArray target/*=nullptr*/);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  calculates the trace of an array, that is sum of elements on main diagonal = sum array[i, i, i, ...]
        */
        public native double getTrace();

        /**
        *  fill array linearly as follows: arr[0] = from, arr[1] = from+step, arr[2] = from+2*step, ...
        */
        public native void linspace(double from, double step/*=1.0f*/);
        public native void linspace(double from);

        public native DoubleNDArray createUninitialized();

        public native DoubleResultSet multipleTensorsAlongDimension(@StdVector IntPointer indices, @StdVector IntPointer dimensions);
        public native DoubleResultSet multipleTensorsAlongDimension(@StdVector IntBuffer indices, @StdVector IntBuffer dimensions);
        public native DoubleResultSet multipleTensorsAlongDimension(@StdVector int[] indices, @StdVector int[] dimensions);

        public native DoubleResultSet allTensorsAlongDimension(@StdVector IntPointer dimensions);
        public native DoubleResultSet allTensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native DoubleResultSet allTensorsAlongDimension(@StdVector int[] dimensions);

        public native DoubleResultSet allExamples();

        /**
        *  default destructor
        */ 

        /**
        *  set _shapeInfo
        */
        public native void setShapeInfo(@Cast("Nd4jLong*") LongPointer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeInfo);
        public native void setShapeInfo(@Cast("Nd4jLong*") long[] shapeInfo);

        /**
        *  set _buffer
        */
        public native void setBuffer(DoublePointer buffer);
        public native void setBuffer(DoubleBuffer buffer);
        public native void setBuffer(double[] buffer);

        /**
        *  set _isBuffAlloc and _isShapeAlloc
        */
        public native void triggerAllocationFlag(@Cast("bool") boolean bufferAllocated, @Cast("bool") boolean shapeAllocated);
        
        /**
        *  returns the value of "dim" dimension 
        */
        public native @Cast("Nd4jLong") long sizeAt(int dim);

        /**        
        *  returns order of array
        */
        public native char ordering();

        /**
        *  return _isView
        */ 
        public native @Cast("bool") boolean isView();

        /**
        *  returns shape portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeOf();
        
        /**
        *  returns strides portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer stridesOf();

        /**
        *  returns rank of array
        */
        public native int rankOf();        

        /** 
        *  returns length of array
        */
        public native @Cast("Nd4jLong") long lengthOf();

        /**
        *  returns number of rows in array
        */
        public native @Cast("Nd4jLong") long rows();

        /**
        *  returns number of columns in array
        */ 
        public native @Cast("Nd4jLong") long columns();

        /**
        *  returns size of array elements type
        */ 
        public native int sizeOfT();

        /**
        *  returns element-wise-stride
        */ 
        public native @Cast("Nd4jLong") long ews();

        // returns true if arrays have same shape
        public native @Cast("bool") boolean isSameShape(@Const DoubleNDArray other);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  returns true if these two NDArrays have same rank, dimensions, strides, ews and order
        */
        public native @Cast("bool") boolean isSameShapeStrict(@Const DoubleNDArray other);

        /**
        *  returns true if buffer && shapeInfo were defined (non nullptr)
        */
        public native @Cast("bool") boolean nonNull();

        /** 
        *  returns array element with given index from linear buffer
        *  i - element index in array
        */
        public native double getScalar(@Cast("const Nd4jLong") long i);

        /** 
        *  returns array element with given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        */
        public native double getIndexedScalar(@Cast("const Nd4jLong") long i);
        
        /** 
        *  returns element with given indexes from 2D array 
        *  i - number of row 
        *  j - number of column
        */
        public native double getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /** 
        *  returns element with given indexes from 3D array 
        *  i - height
        *  j - width
        *  k - depth
        */
        public native double getScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);
        
        /** 
        *  assigns given scalar to array element by given index, takes into account offset between elements (element-wise-stride)
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putIndexedScalar(@Cast("const Nd4jLong") long i, double value);

        /** 
        *  assigns given scalar to array element by given index, regards array buffer as linear
        *  i - element index in array
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, double value);

        /** 
        *  assigns given scalar to 2D array element by given indexes
        *  i - number of row
        *  j - number of row
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, double value);

        /** 
        *  assigns given scalar to 3D array element by given indexes
        *  i - height
        *  j - width
        *  k - depth
        *  value - scalar value to assign
        */
        public native void putScalar(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k, double value);

        /**
        *  returns true if array is 2D
        */
        public native @Cast("bool") boolean isMatrix();

        /**
        *  returns true if array is vector
        */
        public native @Cast("bool") boolean isVector();

        /**
        *  returns true if array is column vector
        */
        public native @Cast("bool") boolean isColumnVector();

        /**
        *  returns true if array is row vector
        */
        public native @Cast("bool") boolean isRowVector();

        /**
        *  returns true if array is scalar
        */
        public native @Cast("bool") boolean isScalar();

        /**
        *  inline accessing operator for matrix, i - absolute index        
        */

        /**
        *  inline modifying operator for matrix, i - absolute index        
        */
        public native @ByRef @Name("operator ()") DoublePointer apply(@Cast("const Nd4jLong") long i);

        /**
        *  inline accessing operator for 2D array, i - row, j - column
        */

        /**
        *  inline modifying operator for 2D array, i - row, j - column
        */
        public native @ByRef @Name("operator ()") DoublePointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j);

        /**
        *  inline accessing operator for 3D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for 3D array, i - height, j - width, k - depth
        */ 
        public native @ByRef @Name("operator ()") DoublePointer apply(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k);

        /**
        *  inline modifying operator for 4D array, i - height, j - width, k - depth
        */ 
        public native @ByRef @Name("operator ()") DoublePointer apply(@Cast("const Nd4jLong") long t, @Cast("const Nd4jLong") long u, @Cast("const Nd4jLong") long v, @Cast("const Nd4jLong") long w);

        /**
        *  inline accessing operator for 4D array, i - height, j - width, k - depth
        */

        /**
        *  inline modifying operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */ 
        public native @ByRef @Name("operator ()") DoublePointer apply(@Cast("const Nd4jLong*") LongPointer idx);
        public native @ByRef @Name("operator ()") DoubleBuffer apply(@Cast("const Nd4jLong*") LongBuffer idx);
        public native @ByRef @Name("operator ()") double[] apply(@Cast("const Nd4jLong*") long[] idx);

        /**
        *  inline accessing operator for ND array
        *  idx - array with corresponding indexes, for example {2,10,0,5,...,8}, number of indexes should be equal to array rank
        */


        public native @Cast("bool") boolean isAttached();

        public native DoubleNDArray detach();


        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef DoubleNDArray other);
    }




//////////////////////////////////////////////////////////////////////////
///// IMLEMENTATION OF INLINE METHODS ///// 
//////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// accessing operator for matrix, i - absolute index


//////////////////////////////////////////////////////////////////////////
// modifying operator for matrix, i - absolute index


//////////////////////////////////////////////////////////////////////////
// accessing operator for 2D matrix, i - row, j - column


//////////////////////////////////////////////////////////////////////////
// modifying operator for 2D matrix, i - row, j - column


//////////////////////////////////////////////////////////////////////////
// accessing operator for 3D array, i - row, j - column


//////////////////////////////////////////////////////////////////////////
// modifying operator for 3D array






//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// Return value from linear buffer


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// Returns value from 2D matrix by coordinates/indexes         


//////////////////////////////////////////////////////////////////////////
// returns value from 3D tensor by coordinates        


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// This method sets value in linear buffer to position i        


//////////////////////////////////////////////////////////////////////////
// This method sets value in 2D matrix to position i, j         


//////////////////////////////////////////////////////////////////////////
// This method sets value in 3D matrix to position i,j,k        


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// still the definition of inline function must be in header file


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// returns true if these two NDArrays have same _shapeInfo
// still the definition of inline function must be in header file








// #endif


// Parsed from array/NDArrayList.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class describes collection of NDArrays
//
// @author raver119!gmail.com
//

// #ifndef NDARRAY_LIST_H
// #define NDARRAY_LIST_H

// #include <string>
// #include <atomic>
// #include <map>
// #include <NDArray.h>
// #include <memory/Workspace.h>
    @Name("nd4j::NDArrayList<float>") @NoOffset public static class FloatNDArrayList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FloatNDArrayList(Pointer p) { super(p); }
    
        public FloatNDArrayList(int height, @Cast("bool") boolean expandable/*=false*/) { super((Pointer)null); allocate(height, expandable); }
        private native void allocate(int height, @Cast("bool") boolean expandable/*=false*/);
        public FloatNDArrayList(int height) { super((Pointer)null); allocate(height); }
        private native void allocate(int height);

        public native FloatNDArray read(int idx);
        public native FloatNDArray readRaw(int idx);
        public native @Cast("Nd4jStatus") int write(int idx, FloatNDArray array);
        public native FloatNDArray pick(@StdVector IntPointer indices);
        public native FloatNDArray pick(@StdVector IntBuffer indices);
        public native FloatNDArray pick(@StdVector int[] indices);
        public native @Cast("bool") boolean isWritten(int index);

        public native FloatNDArray stack();
        public native void unstack(FloatNDArray array, int axis);

        public native @ByRef IntIntPair id();
        public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();
        public native Workspace workspace();

        public native FloatNDArrayList clone();

        public native @Cast("bool") boolean equals(@ByRef FloatNDArrayList other);

        public native int elements();
        public native int height();

        public native int counter();
    }
    @Name("nd4j::NDArrayList<float16>") @NoOffset public static class HalfNDArrayList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public HalfNDArrayList(Pointer p) { super(p); }
    
        public HalfNDArrayList(int height, @Cast("bool") boolean expandable/*=false*/) { super((Pointer)null); allocate(height, expandable); }
        private native void allocate(int height, @Cast("bool") boolean expandable/*=false*/);
        public HalfNDArrayList(int height) { super((Pointer)null); allocate(height); }
        private native void allocate(int height);

        public native HalfNDArray read(int idx);
        public native HalfNDArray readRaw(int idx);
        public native @Cast("Nd4jStatus") int write(int idx, HalfNDArray array);
        public native HalfNDArray pick(@StdVector IntPointer indices);
        public native HalfNDArray pick(@StdVector IntBuffer indices);
        public native HalfNDArray pick(@StdVector int[] indices);
        public native @Cast("bool") boolean isWritten(int index);

        public native HalfNDArray stack();
        public native void unstack(HalfNDArray array, int axis);

        public native @ByRef IntIntPair id();
        public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();
        public native Workspace workspace();

        public native HalfNDArrayList clone();

        public native @Cast("bool") boolean equals(@ByRef HalfNDArrayList other);

        public native int elements();
        public native int height();

        public native int counter();
    }
    @Name("nd4j::NDArrayList<double>") @NoOffset public static class DoubleNDArrayList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DoubleNDArrayList(Pointer p) { super(p); }
    
        public DoubleNDArrayList(int height, @Cast("bool") boolean expandable/*=false*/) { super((Pointer)null); allocate(height, expandable); }
        private native void allocate(int height, @Cast("bool") boolean expandable/*=false*/);
        public DoubleNDArrayList(int height) { super((Pointer)null); allocate(height); }
        private native void allocate(int height);

        public native DoubleNDArray read(int idx);
        public native DoubleNDArray readRaw(int idx);
        public native @Cast("Nd4jStatus") int write(int idx, DoubleNDArray array);
        public native DoubleNDArray pick(@StdVector IntPointer indices);
        public native DoubleNDArray pick(@StdVector IntBuffer indices);
        public native DoubleNDArray pick(@StdVector int[] indices);
        public native @Cast("bool") boolean isWritten(int index);

        public native DoubleNDArray stack();
        public native void unstack(DoubleNDArray array, int axis);

        public native @ByRef IntIntPair id();
        public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();
        public native Workspace workspace();

        public native DoubleNDArrayList clone();

        public native @Cast("bool") boolean equals(@ByRef DoubleNDArrayList other);

        public native int elements();
        public native int height();

        public native int counter();
    }


// #endif

// Parsed from array/ResultSet.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class is suited for execution results representation. 
// 
// PLESE NOTE: It will delete all stored NDArrays upon destructor call
//
// Created by raver119 on 07.09.17.
//

// #ifndef LIBND4J_RESULTSET_H
// #define LIBND4J_RESULTSET_H

// #include <vector>
// #include <graph/generated/result_generated.h>
// #include <pointercast.h> // forward declaration of template class NDArray
    
    @Name("nd4j::ResultSet<float>") @NoOffset public static class FloatResultSet extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FloatResultSet(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public FloatResultSet(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public FloatResultSet position(long position) {
            return (FloatResultSet)super.position(position);
        }
    
        // default constructor
        public FloatResultSet() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int size();
        public native FloatNDArray at(@Cast("unsigned long") long idx);
        public native void push_back(FloatNDArray array);

        public native @Cast("Nd4jStatus") int status();
        public native void setStatus(@Cast("Nd4jStatus") int status);
        public native void purge();
        public native void setNonRemovable();
    }
    
    @Name("nd4j::ResultSet<float16>") @NoOffset public static class HalfResultSet extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public HalfResultSet(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public HalfResultSet(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public HalfResultSet position(long position) {
            return (HalfResultSet)super.position(position);
        }
    
        // default constructor
        public HalfResultSet() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int size();
        public native HalfNDArray at(@Cast("unsigned long") long idx);
        public native void push_back(HalfNDArray array);

        public native @Cast("Nd4jStatus") int status();
        public native void setStatus(@Cast("Nd4jStatus") int status);
        public native void purge();
        public native void setNonRemovable();
    }
    
    @Name("nd4j::ResultSet<double>") @NoOffset public static class DoubleResultSet extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DoubleResultSet(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public DoubleResultSet(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public DoubleResultSet position(long position) {
            return (DoubleResultSet)super.position(position);
        }
    
        // default constructor
        public DoubleResultSet() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int size();
        public native DoubleNDArray at(@Cast("unsigned long") long idx);
        public native void push_back(DoubleNDArray array);

        public native @Cast("Nd4jStatus") int status();
        public native void setStatus(@Cast("Nd4jStatus") int status);
        public native void purge();
        public native void setNonRemovable();
    }


// #endif //LIBND4J_RESULTSET_H


// Parsed from graph/Variable.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_VARIABLE_H
// #define LIBND4J_VARIABLE_H

// #include <string>
// #include <NDArray.h>
// #include <array/NDArrayList.h>
// #include <graph/VariableType.h>
// #include <graph/generated/array_generated.h>
// #include <graph/generated/node_generated.h>
// #include <graph/generated/graph_generated.h>
        @Name("nd4j::graph::Variable<float>") @NoOffset public static class FloatVariable extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatVariable(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FloatVariable(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FloatVariable position(long position) {
                return (FloatVariable)super.position(position);
            }
        
            public FloatVariable(@Cast("bool") boolean placeHolder) { super((Pointer)null); allocate(placeHolder); }
            private native void allocate(@Cast("bool") boolean placeHolder);
            public FloatVariable(FloatNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(FloatNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/);
            public FloatVariable(FloatNDArray arrayw, @Cast("char*") String name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(FloatNDArray arrayw, @Cast("char*") String name, int id);
            public FloatVariable(FloatNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(FloatNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/);
            public FloatVariable(FloatNDArray arrayw, @Cast("char*") BytePointer name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(FloatNDArray arrayw, @Cast("char*") BytePointer name, int id);
            public FloatVariable(FloatNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(FloatNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/);
            public FloatVariable() { super((Pointer)null); allocate(); }
            private native void allocate();
            public FloatVariable(FloatNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(FloatNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/);

            public native FloatVariable clone();

            public native @Cast("bool") boolean hasNDArray();
            public native FloatNDArray getNDArray();
            public native void setNDArray(FloatNDArray array);

            public native @Cast("bool") boolean hasNDArrayList();
            public native FloatNDArrayList getNDArrayList();
            public native void setNDArrayList(FloatNDArrayList list);

            public native @Cast("bool") boolean isExternal();
            public native @Cast("bool") boolean isReadOnly();
            public native @Cast("bool") boolean isEmpty();
            public native @Cast("bool") boolean isRemovable();

            public native @Cast("bool") boolean isPlaceholder();

            public native @Cast("nd4j::graph::VariableType") int variableType();
            public native void setVariableType(@Cast("nd4j::graph::VariableType") int variableType);

            /**
             * This method returns InputType of this variable  
             */
            //InputType variableType() {
            //    return _variableType;
            //}

            public native void markExternal(@Cast("bool") boolean reallyExternal);
            public native void markReadOnly(@Cast("bool") boolean reallyReadOnly);
            public native void markRemovable(@Cast("bool") boolean reallyRemovable);

            public native int id();
            public native int index();
            public native void setIndex(int index);
            public native void setId(int id);
            public native void setId(int id, int idx);

            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getName();
            public native void setName(@StdString @Cast({"char*", "std::string*"}) BytePointer name);

// #ifndef __JAVACPP_HACK__
// #endif
        }
        @Name("nd4j::graph::Variable<float16>") @NoOffset public static class HalfVariable extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfVariable(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public HalfVariable(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public HalfVariable position(long position) {
                return (HalfVariable)super.position(position);
            }
        
            public HalfVariable(@Cast("bool") boolean placeHolder) { super((Pointer)null); allocate(placeHolder); }
            private native void allocate(@Cast("bool") boolean placeHolder);
            public HalfVariable(HalfNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(HalfNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/);
            public HalfVariable(HalfNDArray arrayw, @Cast("char*") String name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(HalfNDArray arrayw, @Cast("char*") String name, int id);
            public HalfVariable(HalfNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(HalfNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/);
            public HalfVariable(HalfNDArray arrayw, @Cast("char*") BytePointer name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(HalfNDArray arrayw, @Cast("char*") BytePointer name, int id);
            public HalfVariable(HalfNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(HalfNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/);
            public HalfVariable() { super((Pointer)null); allocate(); }
            private native void allocate();
            public HalfVariable(HalfNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(HalfNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/);

            public native HalfVariable clone();

            public native @Cast("bool") boolean hasNDArray();
            public native HalfNDArray getNDArray();
            public native void setNDArray(HalfNDArray array);

            public native @Cast("bool") boolean hasNDArrayList();
            public native HalfNDArrayList getNDArrayList();
            public native void setNDArrayList(HalfNDArrayList list);

            public native @Cast("bool") boolean isExternal();
            public native @Cast("bool") boolean isReadOnly();
            public native @Cast("bool") boolean isEmpty();
            public native @Cast("bool") boolean isRemovable();

            public native @Cast("bool") boolean isPlaceholder();

            public native @Cast("nd4j::graph::VariableType") int variableType();
            public native void setVariableType(@Cast("nd4j::graph::VariableType") int variableType);

            /**
             * This method returns InputType of this variable  
             */
            //InputType variableType() {
            //    return _variableType;
            //}

            public native void markExternal(@Cast("bool") boolean reallyExternal);
            public native void markReadOnly(@Cast("bool") boolean reallyReadOnly);
            public native void markRemovable(@Cast("bool") boolean reallyRemovable);

            public native int id();
            public native int index();
            public native void setIndex(int index);
            public native void setId(int id);
            public native void setId(int id, int idx);

            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getName();
            public native void setName(@StdString @Cast({"char*", "std::string*"}) BytePointer name);

// #ifndef __JAVACPP_HACK__
// #endif
        }
        @Name("nd4j::graph::Variable<double>") @NoOffset public static class DoubleVariable extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleVariable(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public DoubleVariable(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public DoubleVariable position(long position) {
                return (DoubleVariable)super.position(position);
            }
        
            public DoubleVariable(@Cast("bool") boolean placeHolder) { super((Pointer)null); allocate(placeHolder); }
            private native void allocate(@Cast("bool") boolean placeHolder);
            public DoubleVariable(DoubleNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(DoubleNDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/);
            public DoubleVariable(DoubleNDArray arrayw, @Cast("char*") String name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(DoubleNDArray arrayw, @Cast("char*") String name, int id);
            public DoubleVariable(DoubleNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(DoubleNDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/);
            public DoubleVariable(DoubleNDArray arrayw, @Cast("char*") BytePointer name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(DoubleNDArray arrayw, @Cast("char*") BytePointer name, int id);
            public DoubleVariable(DoubleNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(DoubleNDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/);
            public DoubleVariable() { super((Pointer)null); allocate(); }
            private native void allocate();
            public DoubleVariable(DoubleNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(DoubleNDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/);

            public native DoubleVariable clone();

            public native @Cast("bool") boolean hasNDArray();
            public native DoubleNDArray getNDArray();
            public native void setNDArray(DoubleNDArray array);

            public native @Cast("bool") boolean hasNDArrayList();
            public native DoubleNDArrayList getNDArrayList();
            public native void setNDArrayList(DoubleNDArrayList list);

            public native @Cast("bool") boolean isExternal();
            public native @Cast("bool") boolean isReadOnly();
            public native @Cast("bool") boolean isEmpty();
            public native @Cast("bool") boolean isRemovable();

            public native @Cast("bool") boolean isPlaceholder();

            public native @Cast("nd4j::graph::VariableType") int variableType();
            public native void setVariableType(@Cast("nd4j::graph::VariableType") int variableType);

            /**
             * This method returns InputType of this variable  
             */
            //InputType variableType() {
            //    return _variableType;
            //}

            public native void markExternal(@Cast("bool") boolean reallyExternal);
            public native void markReadOnly(@Cast("bool") boolean reallyReadOnly);
            public native void markRemovable(@Cast("bool") boolean reallyRemovable);

            public native int id();
            public native int index();
            public native void setIndex(int index);
            public native void setId(int id);
            public native void setId(int id, int idx);

            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getName();
            public native void setName(@StdString @Cast({"char*", "std::string*"}) BytePointer name);

// #ifndef __JAVACPP_HACK__
// #endif
        }
    



// #endif //LIBND4J_VARIABLE_H


// Parsed from graph/VariablesSet.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 15/11/17.
//

// #ifndef LIBND4J_VARIABLESSET_H
// #define LIBND4J_VARIABLESSET_H

// #include <iterator>
// #include <vector>
// #include <pointercast.h>
// #include <dll.h>
// #include <graph/Variable.h>
        @Name("nd4j::graph::VariablesSet<float>") @NoOffset public static class FloatVariablesSet extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatVariablesSet(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FloatVariablesSet(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FloatVariablesSet position(long position) {
                return (FloatVariablesSet)super.position(position);
            }
        
            public FloatVariablesSet(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/) { super((Pointer)null); allocate(status); }
            private native void allocate(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/);
            public FloatVariablesSet() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jStatus") int status();

            public native int size();

            public native void push_back(FloatVariable variable);

            public native FloatVariable at(int index);

        }
        @Name("nd4j::graph::VariablesSet<float16>") @NoOffset public static class HalfVariablesSet extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfVariablesSet(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public HalfVariablesSet(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public HalfVariablesSet position(long position) {
                return (HalfVariablesSet)super.position(position);
            }
        
            public HalfVariablesSet(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/) { super((Pointer)null); allocate(status); }
            private native void allocate(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/);
            public HalfVariablesSet() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jStatus") int status();

            public native int size();

            public native void push_back(HalfVariable variable);

            public native HalfVariable at(int index);

        }
        @Name("nd4j::graph::VariablesSet<double>") @NoOffset public static class DoubleVariablesSet extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleVariablesSet(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public DoubleVariablesSet(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public DoubleVariablesSet position(long position) {
                return (DoubleVariablesSet)super.position(position);
            }
        
            public DoubleVariablesSet(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/) { super((Pointer)null); allocate(status); }
            private native void allocate(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/);
            public DoubleVariablesSet() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jStatus") int status();

            public native int size();

            public native void push_back(DoubleVariable variable);

            public native DoubleVariable at(int index);

        }
    




// #endif //LIBND4J_VARIABLESSET_H


// Parsed from graph/FlowPath.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 16/11/17.
//

// #ifndef LIBND4J_FLOWPATH_H
// #define LIBND4J_FLOWPATH_H

// #include <map>
// #include <pointercast.h>
// #include <graph/NodeState.h>
// #include <graph/FrameState.h>
// #include <graph/profiling/GraphProfile.h>
// #include <dll.h>
        @Namespace("nd4j::graph") @NoOffset public static class FlowPath extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FlowPath(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FlowPath(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FlowPath position(long position) {
                return (FlowPath)super.position(position);
            }
        
            public FlowPath() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native void setInnerTime(int nodeId, @Cast("Nd4jLong") long time);
            public native void setOuterTime(int nodeId, @Cast("Nd4jLong") long time);

            public native @Cast("Nd4jLong") long innerTime(int nodeId);
            public native @Cast("Nd4jLong") long outerTime(int nodeId);

            public native @Cast("bool") boolean isNodeActive(int nodeId);
            public native void markNodeActive(int nodeId, @Cast("bool") boolean isActive);

            public native @Cast("bool") boolean wasExecuted(int nodeId);
            public native void markExecuted(int nodeId, @Cast("bool") boolean wasExecuted);

            public native int branch(int nodeId);
            public native void markBranch(int nodeId, int index);

            // Frame-related methods

            public native void registerFrame(@Cast("Nd4jLong") long frameId);
            public native void forgetFrame(@Cast("Nd4jLong") long frameId);

            public native @Cast("bool") boolean isFrameActive(@Cast("Nd4jLong") long frameId);
            public native void markFrameActive(@Cast("Nd4jLong") long frameId, @Cast("bool") boolean isActive);

            public native @Cast("bool") boolean isRewindPlanned(@Cast("Nd4jLong") long frameId);
            public native void planRewind(@Cast("Nd4jLong") long frameId, @Cast("bool") boolean reallyRewind);

            public native int getRewindPosition(@Cast("Nd4jLong") long frameId);
            public native void setRewindPosition(@Cast("Nd4jLong") long frameId, int position);
            public native void setRewindPositionOnce(@Cast("Nd4jLong") long frameId, int position);

            public native void incrementNumberOfCycles(@Cast("Nd4jLong") long frameId);
            public native @Cast("Nd4jLong") long getNumberOfCycles(@Cast("Nd4jLong") long frameId);

            public native GraphProfile profile();
        }
    



// #endif //LIBND4J_FLOWPATH_H


// Parsed from graph/Intervals.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by yurii@skymind.io on 24.10.2017.
//

// #ifndef LIBND4J_INTERVALS_H
// #define LIBND4J_INTERVALS_H

// #include <pointercast.h>
// #include <vector>
// #include <initializer_list>
// #include <dll.h>

    @Namespace("nd4j") @NoOffset public static class Intervals extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Intervals(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Intervals(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Intervals position(long position) {
            return (Intervals)super.position(position);
        }
    

        // default constructor
        public Intervals() { super((Pointer)null); allocate(); }
        private native void allocate();
        
        // constructor
        public Intervals(@Const @ByRef LongVectorVector content ) { super((Pointer)null); allocate(content); }
        private native void allocate(@Const @ByRef LongVectorVector content );
        
        // accessing operator
        public native @Cast("Nd4jLong*") @StdVector @Name("operator []") LongPointer get(@Cast("const Nd4jLong") long i);

        // returns size of _content
        public native int size();

    }




// #endif //LIBND4J_INTERVALS_H


// Parsed from graph/Stash.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_STASH_H
// #define LIBND4J_STASH_H

//#include <graph/Block.h>
// #include <NDArray.h>
// #include <map>
// #include <string>
// #include <atomic>
// #include <pointercast.h>
        @Namespace("nd4j::graph") @NoOffset public static class KeyPair extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public KeyPair(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public KeyPair(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public KeyPair position(long position) {
                return (KeyPair)super.position(position);
            }
        
            public KeyPair(int node/*=0*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(node, name); }
            private native void allocate(int node/*=0*/, @Cast("char*") String name/*=nullptr*/);
            public KeyPair() { super((Pointer)null); allocate(); }
            private native void allocate();
            public KeyPair(int node/*=0*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(node, name); }
            private native void allocate(int node/*=0*/, @Cast("char*") BytePointer name/*=nullptr*/);

            public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef KeyPair other);
        }

        @Name("nd4j::graph::Stash<float>") @NoOffset public static class FloatStash extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatStash(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FloatStash(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FloatStash position(long position) {
                return (FloatStash)super.position(position);
            }
        
            public FloatStash() { super((Pointer)null); allocate(); }
            private native void allocate();

            //void storeArray(nd4j::graph::Block<T>& block, const char *name, nd4j::NDArray<T> *array);
            public native void storeArray(int nodeId, @Cast("char*") String name, FloatNDArray array);
            public native void storeArray(int nodeId, @Cast("char*") BytePointer name, FloatNDArray array);

            //bool checkStash(nd4j::graph::Block<T>& block, const char *name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") String name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") BytePointer name);

            //nd4j::NDArray<T>* extractArray(nd4j::graph::Block<T>& block, const char *name);
            public native FloatNDArray extractArray(int nodeId, @Cast("char*") String name);
            public native FloatNDArray extractArray(int nodeId, @Cast("char*") BytePointer name);

            public native void clear();
        }

        @Name("nd4j::graph::Stash<float16>") @NoOffset public static class HalfStash extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfStash(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public HalfStash(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public HalfStash position(long position) {
                return (HalfStash)super.position(position);
            }
        
            public HalfStash() { super((Pointer)null); allocate(); }
            private native void allocate();

            //void storeArray(nd4j::graph::Block<T>& block, const char *name, nd4j::NDArray<T> *array);
            public native void storeArray(int nodeId, @Cast("char*") String name, HalfNDArray array);
            public native void storeArray(int nodeId, @Cast("char*") BytePointer name, HalfNDArray array);

            //bool checkStash(nd4j::graph::Block<T>& block, const char *name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") String name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") BytePointer name);

            //nd4j::NDArray<T>* extractArray(nd4j::graph::Block<T>& block, const char *name);
            public native HalfNDArray extractArray(int nodeId, @Cast("char*") String name);
            public native HalfNDArray extractArray(int nodeId, @Cast("char*") BytePointer name);

            public native void clear();
        }

        @Name("nd4j::graph::Stash<double>") @NoOffset public static class DoubleStash extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleStash(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public DoubleStash(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public DoubleStash position(long position) {
                return (DoubleStash)super.position(position);
            }
        
            public DoubleStash() { super((Pointer)null); allocate(); }
            private native void allocate();

            //void storeArray(nd4j::graph::Block<T>& block, const char *name, nd4j::NDArray<T> *array);
            public native void storeArray(int nodeId, @Cast("char*") String name, DoubleNDArray array);
            public native void storeArray(int nodeId, @Cast("char*") BytePointer name, DoubleNDArray array);

            //bool checkStash(nd4j::graph::Block<T>& block, const char *name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") String name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") BytePointer name);

            //nd4j::NDArray<T>* extractArray(nd4j::graph::Block<T>& block, const char *name);
            public native DoubleNDArray extractArray(int nodeId, @Cast("char*") String name);
            public native DoubleNDArray extractArray(int nodeId, @Cast("char*") BytePointer name);

            public native void clear();
        }
    





// #endif //LIBND4J_STASH_H


// Parsed from graph/GraphState.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 23.01.18.
//

// #ifndef LIBND4J_GRAPHSTATE_H
// #define LIBND4J_GRAPHSTATE_H

// #include <pointercast.h>
// #include <op_boilerplate.h>
// #include <dll.h>
// #include <vector>
// #include <map>
// #include <graph/Scope.h>
// #include <Status.h>
// #include <graph/VariableSpace.h>
// #include <ops/declarable/DeclarableOp.h>
// #include <types/pair.h>
// #include <graph/ArgumentsList.h>
// #include <graph/Graph.h>
    @Name("nd4j::graph::GraphState<float>") @NoOffset public static class FloatGraphState extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public FloatGraphState(Pointer p) { super(p); }
    
        public FloatGraphState(@Cast("Nd4jLong") long id) { super((Pointer)null); allocate(id); }
        private native void allocate(@Cast("Nd4jLong") long id);

        /**
         *
         * @return
         */
        public native @Cast("Nd4jLong") long id();

        /**
         * This method adds scope to this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int registerScope(int scopeId);

        /**
         * This method cheks if scope with given ID exists
         * 
         * @param scopeId - ID of the scope
         * @return - TRUE if scope exists, FALSE otherwise
         */
        public native @Cast("bool") boolean hasScope(int scopeId);

        /**
         * This method removes specified scope from this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int forgetScope(int scopeId);

// #ifndef __JAVACPP_HACK__
// #endif
        /**
         * This method adds given op to the end of specified scope
         *
         * @param scopeId
         * @param opNum
         * @param type
         * @return
         */
        public native @Cast("Nd4jStatus") int attachOpToScope(int scopeId, @Cast("Nd4jLong") long opNum, int type, @ByVal ArgumentsList inputs);

        /**
         * This method adds return statement to specified scope
         *
         * PLEASE NOTE: should be used only in body scopes
         *
         * @param scopeId
         * @param nodeId
         * @param args
         * @return
         */
        public native @Cast("Nd4jStatus") int defineReturn(int scopeId, int nodeId, @ByVal ArgumentsList args);

        /**
         * This method returns current variable space of this state holder
         *
         * @return
         */
        public native FloatVariableSpace variableSpace();
    }
    @Name("nd4j::graph::GraphState<float16>") @NoOffset public static class HalfGraphState extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public HalfGraphState(Pointer p) { super(p); }
    
        public HalfGraphState(@Cast("Nd4jLong") long id) { super((Pointer)null); allocate(id); }
        private native void allocate(@Cast("Nd4jLong") long id);

        /**
         *
         * @return
         */
        public native @Cast("Nd4jLong") long id();

        /**
         * This method adds scope to this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int registerScope(int scopeId);

        /**
         * This method cheks if scope with given ID exists
         * 
         * @param scopeId - ID of the scope
         * @return - TRUE if scope exists, FALSE otherwise
         */
        public native @Cast("bool") boolean hasScope(int scopeId);

        /**
         * This method removes specified scope from this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int forgetScope(int scopeId);

// #ifndef __JAVACPP_HACK__
// #endif
        /**
         * This method adds given op to the end of specified scope
         *
         * @param scopeId
         * @param opNum
         * @param type
         * @return
         */
        public native @Cast("Nd4jStatus") int attachOpToScope(int scopeId, @Cast("Nd4jLong") long opNum, int type, @ByVal ArgumentsList inputs);

        /**
         * This method adds return statement to specified scope
         *
         * PLEASE NOTE: should be used only in body scopes
         *
         * @param scopeId
         * @param nodeId
         * @param args
         * @return
         */
        public native @Cast("Nd4jStatus") int defineReturn(int scopeId, int nodeId, @ByVal ArgumentsList args);

        /**
         * This method returns current variable space of this state holder
         *
         * @return
         */
        public native HalfVariableSpace variableSpace();
    }
    @Name("nd4j::graph::GraphState<double>") @NoOffset public static class DoubleGraphState extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DoubleGraphState(Pointer p) { super(p); }
    
        public DoubleGraphState(@Cast("Nd4jLong") long id) { super((Pointer)null); allocate(id); }
        private native void allocate(@Cast("Nd4jLong") long id);

        /**
         *
         * @return
         */
        public native @Cast("Nd4jLong") long id();

        /**
         * This method adds scope to this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int registerScope(int scopeId);

        /**
         * This method cheks if scope with given ID exists
         * 
         * @param scopeId - ID of the scope
         * @return - TRUE if scope exists, FALSE otherwise
         */
        public native @Cast("bool") boolean hasScope(int scopeId);

        /**
         * This method removes specified scope from this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int forgetScope(int scopeId);

// #ifndef __JAVACPP_HACK__
// #endif
        /**
         * This method adds given op to the end of specified scope
         *
         * @param scopeId
         * @param opNum
         * @param type
         * @return
         */
        public native @Cast("Nd4jStatus") int attachOpToScope(int scopeId, @Cast("Nd4jLong") long opNum, int type, @ByVal ArgumentsList inputs);

        /**
         * This method adds return statement to specified scope
         *
         * PLEASE NOTE: should be used only in body scopes
         *
         * @param scopeId
         * @param nodeId
         * @param args
         * @return
         */
        public native @Cast("Nd4jStatus") int defineReturn(int scopeId, int nodeId, @ByVal ArgumentsList args);

        /**
         * This method returns current variable space of this state holder
         *
         * @return
         */
        public native DoubleVariableSpace variableSpace();
    }





// #endif //LIBND4J_GRAPHSTATE_H


// Parsed from graph/VariableSpace.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_VARIABLESPACE_H
// #define LIBND4J_VARIABLESPACE_H

// #include <helpers/logger.h>
// #include <helpers/helper_random.h>
// #include <string>
// #include <vector>
// #include <list>
// #include <map>
// #include <mutex>
// #include <NDArray.h>
// #include <array/NDArrayList.h>
// #include <graph/Variable.h>
// #include <memory/Workspace.h>
// #include <graph/Stash.h>
// #include <graph/FlowPath.h>

        @Name("nd4j::graph::VariableSpace<float>") @NoOffset public static class FloatVariableSpace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatVariableSpace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FloatVariableSpace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FloatVariableSpace position(long position) {
                return (FloatVariableSpace)super.position(position);
            }
        
            public FloatVariableSpace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @ByRef @Name("operator =") FloatVariableSpace put(@Const @ByRef FloatVariableSpace other);

            public native int numberOfPlaceholders();
            public native @Cast("nd4j::graph::Variable<float>**") @StdVector PointerPointer getPlaceholders();
            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);
            public native void setWorkspace(Workspace workspace);
            
            public native Workspace workspace();

            public native @Cast("bool") boolean hasExternalVariable(int it);
            public native @Cast("bool") boolean hasExternalVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasExternalVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("bool") boolean hasVariable(int id);
            public native @Cast("bool") boolean hasVariable(int id, int idx);
            public native @Cast("bool") boolean hasVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native FloatVariable getVariable(int id);
            public native FloatVariable getVariable(int id, int idx);
            public native FloatVariable getVariable(@ByRef IntIntPair pair);
            public native FloatVariable getVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("nd4j::graph::Variable<float>**") @StdVector PointerPointer getVariables();

            public native void putVariable(@ByRef IntIntPair pair, FloatNDArray array);
            public native void putVariable(@ByRef IntIntPair pair, FloatVariable variable);
            public native void putVariable(int id, FloatVariable variable);
            public native void putVariable(int id, FloatNDArray array);
            public native void putVariable(int id, int idx, FloatNDArray array);
            public native void putVariable(int id, int idx, FloatVariable array);

            public native void dropVariable(@ByRef IntIntPair pair);
            public native void dropVariable(int id, int idx);

            public native void trackList(FloatNDArrayList list);

            public native void putOutputVariable(FloatVariable variable);

            public native void replaceVariable(FloatVariable variable);

            // memory-related statistics
            public native @Cast("Nd4jLong") long externalMemory();
            public native @Cast("Nd4jLong") long internalMemory();
            public native @Cast("Nd4jLong") long totalMemory();

            public native int externalEntries();
            public native int internalEntries();
            public native int totalEntries();

            public native FloatVariableSpace clone();

            public native @Cast("nd4j::graph::Variable<float>**") @StdVector PointerPointer handles();
            public native void injectVariable(@ByRef IntIntPair pair, FloatVariable variable);

            public native FloatStash getStash();

            public native @Cast("nd4j::graph::Variable<float>**") @StdVector PointerPointer getExternalVariables();

            public native void setFlowPath(FlowPath timers);
            public native FlowPath flowPath();
        }

        @Name("nd4j::graph::VariableSpace<float16>") @NoOffset public static class HalfVariableSpace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfVariableSpace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public HalfVariableSpace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public HalfVariableSpace position(long position) {
                return (HalfVariableSpace)super.position(position);
            }
        
            public HalfVariableSpace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @ByRef @Name("operator =") HalfVariableSpace put(@Const @ByRef HalfVariableSpace other);

            public native int numberOfPlaceholders();
            public native @Cast("nd4j::graph::Variable<float16>**") @StdVector PointerPointer getPlaceholders();
            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);
            public native void setWorkspace(Workspace workspace);
            
            public native Workspace workspace();

            public native @Cast("bool") boolean hasExternalVariable(int it);
            public native @Cast("bool") boolean hasExternalVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasExternalVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("bool") boolean hasVariable(int id);
            public native @Cast("bool") boolean hasVariable(int id, int idx);
            public native @Cast("bool") boolean hasVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native HalfVariable getVariable(int id);
            public native HalfVariable getVariable(int id, int idx);
            public native HalfVariable getVariable(@ByRef IntIntPair pair);
            public native HalfVariable getVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("nd4j::graph::Variable<float16>**") @StdVector PointerPointer getVariables();

            public native void putVariable(@ByRef IntIntPair pair, HalfNDArray array);
            public native void putVariable(@ByRef IntIntPair pair, HalfVariable variable);
            public native void putVariable(int id, HalfVariable variable);
            public native void putVariable(int id, HalfNDArray array);
            public native void putVariable(int id, int idx, HalfNDArray array);
            public native void putVariable(int id, int idx, HalfVariable array);

            public native void dropVariable(@ByRef IntIntPair pair);
            public native void dropVariable(int id, int idx);

            public native void trackList(HalfNDArrayList list);

            public native void putOutputVariable(HalfVariable variable);

            public native void replaceVariable(HalfVariable variable);

            // memory-related statistics
            public native @Cast("Nd4jLong") long externalMemory();
            public native @Cast("Nd4jLong") long internalMemory();
            public native @Cast("Nd4jLong") long totalMemory();

            public native int externalEntries();
            public native int internalEntries();
            public native int totalEntries();

            public native HalfVariableSpace clone();

            public native @Cast("nd4j::graph::Variable<float16>**") @StdVector PointerPointer handles();
            public native void injectVariable(@ByRef IntIntPair pair, HalfVariable variable);

            public native HalfStash getStash();

            public native @Cast("nd4j::graph::Variable<float16>**") @StdVector PointerPointer getExternalVariables();

            public native void setFlowPath(FlowPath timers);
            public native FlowPath flowPath();
        }

        @Name("nd4j::graph::VariableSpace<double>") @NoOffset public static class DoubleVariableSpace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleVariableSpace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public DoubleVariableSpace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public DoubleVariableSpace position(long position) {
                return (DoubleVariableSpace)super.position(position);
            }
        
            public DoubleVariableSpace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @ByRef @Name("operator =") DoubleVariableSpace put(@Const @ByRef DoubleVariableSpace other);

            public native int numberOfPlaceholders();
            public native @Cast("nd4j::graph::Variable<double>**") @StdVector PointerPointer getPlaceholders();
            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);
            public native void setWorkspace(Workspace workspace);
            
            public native Workspace workspace();

            public native @Cast("bool") boolean hasExternalVariable(int it);
            public native @Cast("bool") boolean hasExternalVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasExternalVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("bool") boolean hasVariable(int id);
            public native @Cast("bool") boolean hasVariable(int id, int idx);
            public native @Cast("bool") boolean hasVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native DoubleVariable getVariable(int id);
            public native DoubleVariable getVariable(int id, int idx);
            public native DoubleVariable getVariable(@ByRef IntIntPair pair);
            public native DoubleVariable getVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("nd4j::graph::Variable<double>**") @StdVector PointerPointer getVariables();

            public native void putVariable(@ByRef IntIntPair pair, DoubleNDArray array);
            public native void putVariable(@ByRef IntIntPair pair, DoubleVariable variable);
            public native void putVariable(int id, DoubleVariable variable);
            public native void putVariable(int id, DoubleNDArray array);
            public native void putVariable(int id, int idx, DoubleNDArray array);
            public native void putVariable(int id, int idx, DoubleVariable array);

            public native void dropVariable(@ByRef IntIntPair pair);
            public native void dropVariable(int id, int idx);

            public native void trackList(DoubleNDArrayList list);

            public native void putOutputVariable(DoubleVariable variable);

            public native void replaceVariable(DoubleVariable variable);

            // memory-related statistics
            public native @Cast("Nd4jLong") long externalMemory();
            public native @Cast("Nd4jLong") long internalMemory();
            public native @Cast("Nd4jLong") long totalMemory();

            public native int externalEntries();
            public native int internalEntries();
            public native int totalEntries();

            public native DoubleVariableSpace clone();

            public native @Cast("nd4j::graph::Variable<double>**") @StdVector PointerPointer handles();
            public native void injectVariable(@ByRef IntIntPair pair, DoubleVariable variable);

            public native DoubleStash getStash();

            public native @Cast("nd4j::graph::Variable<double>**") @StdVector PointerPointer getExternalVariables();

            public native void setFlowPath(FlowPath timers);
            public native FlowPath flowPath();
        }
    



// #endif //LIBND4J_VARIABLESPACE_H


// Parsed from helpers/helper_generator.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_HELPER_GENERATOR_H
// #define LIBND4J_HELPER_GENERATOR_H

// #include <op_boilerplate.h>
// #include <pointercast.h>
// #include <array/DataTypeUtils.h>
// #include <dll.h>

// #ifdef _MSC_VER
// include for uint64_t on MSVC
// #include <stdint.h>
// #elif ANDROID
// #include <stdint.h>

// #ifndef UINT64_C
// #if defined(__LP64__)
// #define UINT64_C(c)     c ## UL
// #else
// #define UINT64_C(c)     c ## ULL
// #endif //LP64
// #endif // UINT64

// #endif // MSVC/ANDROID


// #ifdef __GNUC__
// #include <inttypes.h>
// #endif


public static native @MemberGetter long MAX_UINT();
public static final long MAX_UINT = MAX_UINT();

// #ifdef __CUDACC__
// #else
        @Namespace("nd4j::random") @NoOffset public static class RandomBuffer extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public RandomBuffer(Pointer p) { super(p); }
        
            /**
             * This method allocates buffer of size * sizeof(Nd4jLong)
             *
             * @param size
             * @return
             */
// #ifdef __CUDACC__
// #endif
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongPointer buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongPointer buffer);
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongBuffer buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongBuffer buffer);
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") long[] buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") long[] buffer);

            public native @Cast("uint64_t*") LongPointer getBuffer();

            public native @Cast("uint64_t*") LongPointer getDeviceBuffer();

// #ifdef __CUDACC__
// #endif

            public native @Cast("Nd4jLong") long getSize();

            public native @Cast("Nd4jLong") long getSeed();

            public native void setSeed(@Cast("Nd4jLong") long seed);

            public native @Cast("Nd4jLong") long getAllocatedSize();

            public native @Cast("Nd4jLong") long getOffset();

            public native void setOffset(@Cast("Nd4jLong") long offset);

            public native void reSeed(@Cast("Nd4jLong") long amplifier);

            public native @Cast("uint64_t") long getElement(@Cast("Nd4jLong") long position);

            public native @Cast("uint64_t") long next64(@Cast("uint64_t") long shiftedSeed);

            public static native @Cast("uint64_t") long rotl(@Cast("const uint64_t") long x, @Cast("uint64_t") long k);

            public static native @Cast("uint64_t") long safeShift(@Cast("uint64_t") long x, @Cast("uint64_t") long y);

            public native @Cast("uint64_t") long seedConv(@Cast("Nd4jLong") long seed);

            public native void incrementGeneration();

            public native @Cast("Nd4jLong") long getNextIndex();

            public native @Cast("uint64_t") long getNextElement();


            /**
             * This method skips X elements from buffer
             *
             * @param numberOfElements number of elements to skip
             */
// #ifdef __CUDACC__
// #endif
            public native void rewindH(@Cast("Nd4jLong") long numberOfElements);

            /**
            * This method returns random int in range [0..MAX_INT]
            * @return
            */
            public native int nextInt();

            public native @Cast("uint64_t") long nextUInt64();

            /**
             * This method returns random int in range [0..to]
             * @param to
             * @return
             */
            public native int nextInt(int to);

            /**
             * This method returns random int in range [from..to]
             * @param from
             * @param to
             * @return
             */
            public native int nextInt(int from, int to);


            /**
             * This method returns random T in range of [0..1]
             * @return
             */

            /**
             * This method returns random T in range of [0..to]
             * @param to
             * @return
             */

            /**
             * This method returns random T in range [from..to]
             * @param from
             * @param to
             * @return
             */

            public native @Cast("uint64_t") long relativeUInt64(@Cast("Nd4jLong") long index);

            /**
             *  relative methods are made as workaround for lock-free concurrent execution
             */
            public native int relativeInt(@Cast("Nd4jLong") long index);

            /**
             * This method returns random int within [0..to]
             *
             * @param index
             * @param to
             * @return
             */
            public native int relativeInt(@Cast("Nd4jLong") long index, int to);

            /**
             * This method returns random int within [from..to]
             *
             * @param index
             * @param to
             * @param from
             * @return
             */
            public native int relativeInt(@Cast("Nd4jLong") long index, int from, int to);

            /**
             * This method returns random T within [0..1]
             *
             * @param index
             * @return
             */

/**
 * This method returns random T within [0..to]
 *
 * @param index
 * @param to
 * @return
 */

/**
 * This method returns random T within [from..to]
 *
 * @param index
 * @param from
 * @param to
 * @return
 */

        }

        @Namespace("nd4j::random") @NoOffset public static class IGenerator extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public IGenerator(Pointer p) { super(p); }
        


            public native RandomBuffer getBuffer();

            public native void setOffset(@Cast("Nd4jLong") long offset);

            public native @Cast("Nd4jLong") long getElementAbsolute(@Cast("Nd4jLong") long position);

            public native @Cast("Nd4jLong") long getElementRelative(@Cast("Nd4jLong") long position);

            public native void refreshBuffer();
        }



        @Namespace("nd4j::random") @NoOffset public static class Xoroshiro128 extends IGenerator {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Xoroshiro128(Pointer p) { super(p); }
        
            public Xoroshiro128(RandomBuffer buffer) { super((Pointer)null); allocate(buffer); }
            private native void allocate(RandomBuffer buffer);

            public native void refreshBuffer();
        }
    

// #endif //LIBND4J_HELPER_GENERATOR_H


// Parsed from graph/profiling/GraphProfile.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef ND4J_GRAPH_PROFILE_H
// #define ND4J_GRAPH_PROFILE_H

// #include "NodeProfile.h"
// #include <pointercast.h>
// #include <dll.h>
// #include <vector>
// #include <string>
// #include <map>
// #include <chrono>
        @Namespace("nd4j::graph") @NoOffset public static class GraphProfile extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public GraphProfile(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public GraphProfile(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public GraphProfile position(long position) {
                return (GraphProfile)super.position(position);
            }
        
            public GraphProfile() { super((Pointer)null); allocate(); }
            private native void allocate();

            /**
             * These methods just adding amount of bytes to various counters
             */
            public native void addToTotal(@Cast("Nd4jLong") long bytes);
            public native void addToActivations(@Cast("Nd4jLong") long bytes);
            public native void addToTemporary(@Cast("Nd4jLong") long bytes);
            public native void addToObjects(@Cast("Nd4jLong") long bytes);

            /**
             * This method allows to set graph construction (i.e. deserialization) time in nanoseconds
             */
            public native void setBuildTime(@Cast("Nd4jLong") long nanos);

            /**
             * This method sets graph execution time in nanoseconds.
             */
            public native void setExecutionTime(@Cast("Nd4jLong") long nanos);

            public native void startEvent(@Cast("char*") String name);
            public native void startEvent(@Cast("char*") BytePointer name);
            public native void recordEvent(@Cast("char*") String name);
            public native void recordEvent(@Cast("char*") BytePointer name);
            public native void deleteEvent(@Cast("char*") String name);
            public native void deleteEvent(@Cast("char*") BytePointer name);

            /**
             * This method saves time as delta from last saved time
             */
            public native void spotEvent(@Cast("char*") String name);
            public native void spotEvent(@Cast("char*") BytePointer name);

            /**
             * This method returns pointer to NodeProfile by ID
             * PLEASE NOTE: this method will create new NodeProfile if there's none
             */
            public native NodeProfile nodeById(int id, @Cast("char*") String name/*=nullptr*/);
            public native NodeProfile nodeById(int id);
            public native NodeProfile nodeById(int id, @Cast("char*") BytePointer name/*=nullptr*/);
            public native @Cast("bool") boolean nodeExists(int id);

            /**
             * This method merges values from other profile report
             * @param other
             */
            public native void merge(GraphProfile other);
            public native void assign(GraphProfile other);

            /**
             * These methods are just utility methods for time
             */
            public static native @Cast("Nd4jLong") long currentTime();
            public static native @Cast("Nd4jLong") long relativeTime(@Cast("Nd4jLong") long time);

            public native void printOut();
        }
    


// #endif

// Parsed from graph/profiling/NodeProfile.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_NODE_PROFILE_H
// #define LIBND4J_NODE_PROFILE_H

// #include <pointercast.h>
// #include <dll.h>
// #include <string>
        @Namespace("nd4j::graph") @NoOffset public static class NodeProfile extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public NodeProfile(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public NodeProfile(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public NodeProfile position(long position) {
                return (NodeProfile)super.position(position);
            }
        
            public NodeProfile() { super((Pointer)null); allocate(); }
            private native void allocate();

            public NodeProfile(int id, @Cast("char*") String name) { super((Pointer)null); allocate(id, name); }
            private native void allocate(int id, @Cast("char*") String name);
            public NodeProfile(int id, @Cast("char*") BytePointer name) { super((Pointer)null); allocate(id, name); }
            private native void allocate(int id, @Cast("char*") BytePointer name);

            public native void setBuildTime(@Cast("Nd4jLong") long time);
            public native void setPreparationTime(@Cast("Nd4jLong") long time);
            public native void setExecutionTime(@Cast("Nd4jLong") long time);
            public native void setTotalTime(@Cast("Nd4jLong") long time);
            public native void setShapeFunctionTime(@Cast("Nd4jLong") long time);
            public native void setArrayTime(@Cast("Nd4jLong") long time);
            public native void setInputTime(@Cast("Nd4jLong") long time);

            public native void setActivationsSize(@Cast("Nd4jLong") long bytes);
            public native void setTemporarySize(@Cast("Nd4jLong") long bytes);
            public native void setObjectsSize(@Cast("Nd4jLong") long bytes);
            public native void setTotalSize(@Cast("Nd4jLong") long bytes);

            public native @Cast("Nd4jLong") long getActivationsSize();
            public native @Cast("Nd4jLong") long getTemporarySize();
            public native @Cast("Nd4jLong") long getObjectsSize();
            public native @Cast("Nd4jLong") long getTotalSize();

            public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();

            public native void merge(NodeProfile other);
            public native void assign(NodeProfile other);

            public native void printOut();
        }
    


// #endif

// Parsed from graph/Context.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_BLOCK_H
// #define LIBND4J_BLOCK_H

// #include <vector>
// #include <graph/Variable.h>
// #include <graph/VariableSpace.h>
// #include <graph/ContextPrototype.h>
// #include <memory/Workspace.h>

// #ifdef HAVE_MKLDNN
// #endif

// CUDA-specific includes
// #ifdef __CUDACC__

// #endif
        /**
         * This class defines input desired for any given node/operation within graph
         */
        @Name("nd4j::graph::Context<float>") @NoOffset public static class FloatContext extends FloatContextPrototype {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatContext(Pointer p) { super(p); }
        
            // TODO: maybe override new here as well?

            // CUDA-specific fields
// #ifdef __CUDACC__
// #endif

            public FloatContext(FloatContextPrototype prototype, FloatVariableSpace variableSpace) { super((Pointer)null); allocate(prototype, variableSpace); }
            private native void allocate(FloatContextPrototype prototype, FloatVariableSpace variableSpace);

            public FloatContext(int nodeId, FloatVariableSpace variableSpace/*=nullptr*/) { super((Pointer)null); allocate(nodeId, variableSpace); }
            private native void allocate(int nodeId, FloatVariableSpace variableSpace/*=nullptr*/);
            public FloatContext(int nodeId) { super((Pointer)null); allocate(nodeId); }
            private native void allocate(int nodeId);
            public FloatContext(int nodeId, FloatVariableSpace variableSpace, @Cast("bool") boolean isInplace) { super((Pointer)null); allocate(nodeId, variableSpace, isInplace); }
            private native void allocate(int nodeId, FloatVariableSpace variableSpace, @Cast("bool") boolean isInplace);

            // default destructor

            // these methods are for execution timing
            public native void setOuterTime(@Cast("Nd4jLong") long time);
            public native void setInnerTime(@Cast("Nd4jLong") long time);
            public native @Cast("Nd4jLong") long getOuterTime();
            public native @Cast("Nd4jLong") long getInnerTime();

            // these methods are related to Workspace abstraction
            public native @Cast("bool") boolean hasWorkspaceProvided();
            public native void attachWorkspace(Workspace workspace);
            public native void forgetWorkspace();

            // these methods return full-time workspace
            public native Workspace getWorkspace();
            public native Workspace workspace();
            public native Workspace fWorkspace();

            // this method returns workspace for temporary allocations
            public native Workspace tWorkspace();

            // this method returns workspace for object allocations
            public native Workspace oWorkspace();


            public native void setVariableSpace(FloatVariableSpace variableSpace);

            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);

            public native FloatVariableSpace getVariableSpace();

            // these fields define, if we can execute specific node in-place, without generating new array


            // these variables are only for Divergent Nodes
            public native int getBranch();
            public native void setBranch(int branch);

// #ifdef HAVE_MKLDNN
// #endif
            /**
             *
             * @return
             */
            public native FloatStash getStash();

            /**
             *
             */
            public native void trackList(FloatNDArrayList list);


            /**
             * This method returns variable for a given input index for this block
             * @param idx
             * @return
             */
            public native FloatVariable getVariable(int idx);
            public native FloatVariable variable(int idx);


            /**
             * This method fetches variable from Workspace DIRECTLY
             * @param p
             * @return
             */
            public native FloatVariable variable(int node, int index);
            public native FloatVariable variable(@ByRef IntIntPair p);


            public native void pushNDArrayToVariableSpace(int nodeId, int index, FloatNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(int nodeId, int index, FloatNDArray array);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, FloatNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, FloatNDArray array);

            public native void pushNDArrayListToVariableSpace(int nodeId, int index, FloatNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(int nodeId, int index, FloatNDArrayList list);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, FloatNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, FloatNDArrayList list);

            public native @Cast("bool") boolean isValueAvailable(int idx/*=0*/);
            public native @Cast("bool") boolean isValueAvailable();

            public native FloatVariable ensureVariable(int idx/*=0*/);
            public native FloatVariable ensureVariable();
        }
        @Name("nd4j::graph::Context<float16>") @NoOffset public static class HalfContext extends HalfContextPrototype {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfContext(Pointer p) { super(p); }
        
            // TODO: maybe override new here as well?

            // CUDA-specific fields
// #ifdef __CUDACC__
// #endif

            public HalfContext(HalfContextPrototype prototype, HalfVariableSpace variableSpace) { super((Pointer)null); allocate(prototype, variableSpace); }
            private native void allocate(HalfContextPrototype prototype, HalfVariableSpace variableSpace);

            public HalfContext(int nodeId, HalfVariableSpace variableSpace/*=nullptr*/) { super((Pointer)null); allocate(nodeId, variableSpace); }
            private native void allocate(int nodeId, HalfVariableSpace variableSpace/*=nullptr*/);
            public HalfContext(int nodeId) { super((Pointer)null); allocate(nodeId); }
            private native void allocate(int nodeId);
            public HalfContext(int nodeId, HalfVariableSpace variableSpace, @Cast("bool") boolean isInplace) { super((Pointer)null); allocate(nodeId, variableSpace, isInplace); }
            private native void allocate(int nodeId, HalfVariableSpace variableSpace, @Cast("bool") boolean isInplace);

            // default destructor

            // these methods are for execution timing
            public native void setOuterTime(@Cast("Nd4jLong") long time);
            public native void setInnerTime(@Cast("Nd4jLong") long time);
            public native @Cast("Nd4jLong") long getOuterTime();
            public native @Cast("Nd4jLong") long getInnerTime();

            // these methods are related to Workspace abstraction
            public native @Cast("bool") boolean hasWorkspaceProvided();
            public native void attachWorkspace(Workspace workspace);
            public native void forgetWorkspace();

            // these methods return full-time workspace
            public native Workspace getWorkspace();
            public native Workspace workspace();
            public native Workspace fWorkspace();

            // this method returns workspace for temporary allocations
            public native Workspace tWorkspace();

            // this method returns workspace for object allocations
            public native Workspace oWorkspace();


            public native void setVariableSpace(HalfVariableSpace variableSpace);

            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);

            public native HalfVariableSpace getVariableSpace();

            // these fields define, if we can execute specific node in-place, without generating new array


            // these variables are only for Divergent Nodes
            public native int getBranch();
            public native void setBranch(int branch);

// #ifdef HAVE_MKLDNN
// #endif
            /**
             *
             * @return
             */
            public native HalfStash getStash();

            /**
             *
             */
            public native void trackList(HalfNDArrayList list);


            /**
             * This method returns variable for a given input index for this block
             * @param idx
             * @return
             */
            public native HalfVariable getVariable(int idx);
            public native HalfVariable variable(int idx);


            /**
             * This method fetches variable from Workspace DIRECTLY
             * @param p
             * @return
             */
            public native HalfVariable variable(int node, int index);
            public native HalfVariable variable(@ByRef IntIntPair p);


            public native void pushNDArrayToVariableSpace(int nodeId, int index, HalfNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(int nodeId, int index, HalfNDArray array);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, HalfNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, HalfNDArray array);

            public native void pushNDArrayListToVariableSpace(int nodeId, int index, HalfNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(int nodeId, int index, HalfNDArrayList list);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, HalfNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, HalfNDArrayList list);

            public native @Cast("bool") boolean isValueAvailable(int idx/*=0*/);
            public native @Cast("bool") boolean isValueAvailable();

            public native HalfVariable ensureVariable(int idx/*=0*/);
            public native HalfVariable ensureVariable();
        }
        @Name("nd4j::graph::Context<double>") @NoOffset public static class DoubleContext extends DoubleContextPrototype {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleContext(Pointer p) { super(p); }
        
            // TODO: maybe override new here as well?

            // CUDA-specific fields
// #ifdef __CUDACC__
// #endif

            public DoubleContext(DoubleContextPrototype prototype, DoubleVariableSpace variableSpace) { super((Pointer)null); allocate(prototype, variableSpace); }
            private native void allocate(DoubleContextPrototype prototype, DoubleVariableSpace variableSpace);

            public DoubleContext(int nodeId, DoubleVariableSpace variableSpace/*=nullptr*/) { super((Pointer)null); allocate(nodeId, variableSpace); }
            private native void allocate(int nodeId, DoubleVariableSpace variableSpace/*=nullptr*/);
            public DoubleContext(int nodeId) { super((Pointer)null); allocate(nodeId); }
            private native void allocate(int nodeId);
            public DoubleContext(int nodeId, DoubleVariableSpace variableSpace, @Cast("bool") boolean isInplace) { super((Pointer)null); allocate(nodeId, variableSpace, isInplace); }
            private native void allocate(int nodeId, DoubleVariableSpace variableSpace, @Cast("bool") boolean isInplace);

            // default destructor

            // these methods are for execution timing
            public native void setOuterTime(@Cast("Nd4jLong") long time);
            public native void setInnerTime(@Cast("Nd4jLong") long time);
            public native @Cast("Nd4jLong") long getOuterTime();
            public native @Cast("Nd4jLong") long getInnerTime();

            // these methods are related to Workspace abstraction
            public native @Cast("bool") boolean hasWorkspaceProvided();
            public native void attachWorkspace(Workspace workspace);
            public native void forgetWorkspace();

            // these methods return full-time workspace
            public native Workspace getWorkspace();
            public native Workspace workspace();
            public native Workspace fWorkspace();

            // this method returns workspace for temporary allocations
            public native Workspace tWorkspace();

            // this method returns workspace for object allocations
            public native Workspace oWorkspace();


            public native void setVariableSpace(DoubleVariableSpace variableSpace);

            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);

            public native DoubleVariableSpace getVariableSpace();

            // these fields define, if we can execute specific node in-place, without generating new array


            // these variables are only for Divergent Nodes
            public native int getBranch();
            public native void setBranch(int branch);

// #ifdef HAVE_MKLDNN
// #endif
            /**
             *
             * @return
             */
            public native DoubleStash getStash();

            /**
             *
             */
            public native void trackList(DoubleNDArrayList list);


            /**
             * This method returns variable for a given input index for this block
             * @param idx
             * @return
             */
            public native DoubleVariable getVariable(int idx);
            public native DoubleVariable variable(int idx);


            /**
             * This method fetches variable from Workspace DIRECTLY
             * @param p
             * @return
             */
            public native DoubleVariable variable(int node, int index);
            public native DoubleVariable variable(@ByRef IntIntPair p);


            public native void pushNDArrayToVariableSpace(int nodeId, int index, DoubleNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(int nodeId, int index, DoubleNDArray array);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, DoubleNDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, DoubleNDArray array);

            public native void pushNDArrayListToVariableSpace(int nodeId, int index, DoubleNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(int nodeId, int index, DoubleNDArrayList list);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, DoubleNDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, DoubleNDArrayList list);

            public native @Cast("bool") boolean isValueAvailable(int idx/*=0*/);
            public native @Cast("bool") boolean isValueAvailable();

            public native DoubleVariable ensureVariable(int idx/*=0*/);
            public native DoubleVariable ensureVariable();
        }
    



// #endif //LIBND4J_BLOCK_H


// Parsed from graph/ContextPrototype.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef ND4J_CONTEXT_PROTOTYPE_H
// #define ND4J_CONTEXT_PROTOTYPE_H

// #include <vector>
// #include <Environment.h>
        @Name("nd4j::graph::ContextPrototype<float>") @NoOffset public static class FloatContextPrototype extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatContextPrototype(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FloatContextPrototype(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FloatContextPrototype position(long position) {
                return (FloatContextPrototype)super.position(position);
            }
        
            public FloatContextPrototype(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/) { super((Pointer)null); allocate(nodeId, inPlace); }
            private native void allocate(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/);
            public FloatContextPrototype() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native int getNodeId();
            public native int nodeId();

            // this method returns true, if inputs are defined
            public native @Cast("bool") boolean hasVariablesFilled();

            public native @Cast("bool") boolean isInplace();
            public native void markInplace(@Cast("bool") boolean reallyInplace);

            public native void pickInput(int input);
            public native void pickInput(int input, int index);
            public native void pickInput(@ByRef IntIntPair p);
            public native void fillInputs(@StdVector IntPointer inputs);
            public native void fillInputs(@StdVector IntBuffer inputs);
            public native void fillInputs(@StdVector int[] inputs);
            public native @StdVector IntIntPair inputs();

            public native @StdVector FloatPointer getTArguments();
            public native @StdVector IntPointer getIArguments();

            public native int numT();
            public native int numI();

            public native IntIntPair input(int idx);

            public native int opNum();
            public native void setOpNum(int opNum);

            public native @Cast("bool") boolean isUseMKLDNN();
            public native void setUseMKLDNN(@Cast("bool") boolean useMKLDNN);

            /**
             * This method returns number of inputs available in this block
             * @return
             */
            public native @Cast("unsigned long") long width();

            // just a clone
            public native FloatContextPrototype clone();
        }
        @Name("nd4j::graph::ContextPrototype<float16>") @NoOffset public static class HalfContextPrototype extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfContextPrototype(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public HalfContextPrototype(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public HalfContextPrototype position(long position) {
                return (HalfContextPrototype)super.position(position);
            }
        
            public HalfContextPrototype(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/) { super((Pointer)null); allocate(nodeId, inPlace); }
            private native void allocate(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/);
            public HalfContextPrototype() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native int getNodeId();
            public native int nodeId();

            // this method returns true, if inputs are defined
            public native @Cast("bool") boolean hasVariablesFilled();

            public native @Cast("bool") boolean isInplace();
            public native void markInplace(@Cast("bool") boolean reallyInplace);

            public native void pickInput(int input);
            public native void pickInput(int input, int index);
            public native void pickInput(@ByRef IntIntPair p);
            public native void fillInputs(@StdVector IntPointer inputs);
            public native void fillInputs(@StdVector IntBuffer inputs);
            public native void fillInputs(@StdVector int[] inputs);
            public native @StdVector IntIntPair inputs();

            public native @Cast("float16*") @StdVector ShortPointer getTArguments();
            public native @StdVector IntPointer getIArguments();

            public native int numT();
            public native int numI();

            public native IntIntPair input(int idx);

            public native int opNum();
            public native void setOpNum(int opNum);

            public native @Cast("bool") boolean isUseMKLDNN();
            public native void setUseMKLDNN(@Cast("bool") boolean useMKLDNN);

            /**
             * This method returns number of inputs available in this block
             * @return
             */
            public native @Cast("unsigned long") long width();

            // just a clone
            public native HalfContextPrototype clone();
        }
        @Name("nd4j::graph::ContextPrototype<double>") @NoOffset public static class DoubleContextPrototype extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleContextPrototype(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public DoubleContextPrototype(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public DoubleContextPrototype position(long position) {
                return (DoubleContextPrototype)super.position(position);
            }
        
            public DoubleContextPrototype(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/) { super((Pointer)null); allocate(nodeId, inPlace); }
            private native void allocate(int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/);
            public DoubleContextPrototype() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native int getNodeId();
            public native int nodeId();

            // this method returns true, if inputs are defined
            public native @Cast("bool") boolean hasVariablesFilled();

            public native @Cast("bool") boolean isInplace();
            public native void markInplace(@Cast("bool") boolean reallyInplace);

            public native void pickInput(int input);
            public native void pickInput(int input, int index);
            public native void pickInput(@ByRef IntIntPair p);
            public native void fillInputs(@StdVector IntPointer inputs);
            public native void fillInputs(@StdVector IntBuffer inputs);
            public native void fillInputs(@StdVector int[] inputs);
            public native @StdVector IntIntPair inputs();

            public native @StdVector DoublePointer getTArguments();
            public native @StdVector IntPointer getIArguments();

            public native int numT();
            public native int numI();

            public native IntIntPair input(int idx);

            public native int opNum();
            public native void setOpNum(int opNum);

            public native @Cast("bool") boolean isUseMKLDNN();
            public native void setUseMKLDNN(@Cast("bool") boolean useMKLDNN);

            /**
             * This method returns number of inputs available in this block
             * @return
             */
            public native @Cast("unsigned long") long width();

            // just a clone
            public native DoubleContextPrototype clone();
        }
    


// #endif //ND4J_CONTEXT_PROTOTYPE_H


// Parsed from graph/ResultWrapper.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 11/06/18.
//

// #ifndef LIBND4J_RESULTWRAPPER_H
// #define LIBND4J_RESULTWRAPPER_H

// #include <op_boilerplate.h>
// #include <pointercast.h>
// #include <dll.h>
        @Namespace("nd4j::graph") @NoOffset public static class ResultWrapper extends org.nd4j.nativeblas.ResultWrapperAbstraction {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public ResultWrapper(Pointer p) { super(p); }
        
            public ResultWrapper(@Cast("Nd4jLong") long size, @Cast("Nd4jPointer") Pointer ptr) { super((Pointer)null); allocate(size, ptr); }
            private native void allocate(@Cast("Nd4jLong") long size, @Cast("Nd4jPointer") Pointer ptr);

            public native @Cast("Nd4jLong") long size();

            public native @Cast("Nd4jPointer") Pointer pointer();
        }
    



// #endif //LIBND4J_RESULTWRAPPER_H


// Parsed from helpers/shape.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

/*
 * shape.h
 *
 *  Created on: Dec 28, 2015
 *      Author: agibsonccc
 */

// #ifndef SHAPE_H_
// #define SHAPE_H_

// #include <cstring>
// #include <cstdio>
// #include "../dll.h"
// #include "../nd4jmalloc.h"
// #include "../templatemath.h"
// #include "../helpers/logger.h"
// #include "../pointercast.h"
// #include "../cnpy/cnpy.h"
// #include <op_boilerplate.h>

public static final int MAX_DIMENSION = 0x7fffffff;
public static final int MAX_NUM_THREADS =  1024;
public static final int MAX_RANK = 32;
public static final int MAX_SHAPEINFOLENGTH = 2*MAX_RANK+4;
public static final int MAX_COORD = 3;
public static final int PREALLOC_SIZE = 33554432;
// #ifdef __CUDACC__
// #endif


// #ifdef __CUDACC__
// #else
// #define INLINEDEF inline
// #endif

// #include "../pairwise_util.h"
// #include <stdint.h>
// #include <array/ArrayOptions.h>

/**
 * Shape information approximating
 * the information on an ndarray
 */
    @Namespace("shape") @NoOffset public static class ShapeInformation extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ShapeInformation(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ShapeInformation(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ShapeInformation position(long position) {
            return (ShapeInformation)super.position(position);
        }
    
        public ShapeInformation(@Cast("Nd4jLong*") LongPointer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongPointer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") LongPointer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongPointer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);
        public ShapeInformation() { super((Pointer)null); allocate(); }
        private native void allocate();
        public ShapeInformation(@Cast("Nd4jLong*") LongBuffer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") LongBuffer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);
        public ShapeInformation(@Cast("Nd4jLong*") long[] shape_/*=nullptr*/, @Cast("Nd4jLong*") long[] stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") long[] shape_/*=nullptr*/, @Cast("Nd4jLong*") long[] stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);

        public native @Cast("Nd4jLong*") LongPointer shape(); public native ShapeInformation shape(LongPointer shape);
        public native @Cast("Nd4jLong*") LongPointer stride(); public native ShapeInformation stride(LongPointer stride);
        public native char order(); public native ShapeInformation order(char order);
        public native int rank(); public native ShapeInformation rank(int rank);
        public native int offset(); public native ShapeInformation offset(int offset);
        public native int elementWiseStride(); public native ShapeInformation elementWiseStride(int elementWiseStride);
    }

/**
 * Indexing information
 * for bounds checking
 */
    @Namespace("shape") public static class CurrentIndexing extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public CurrentIndexing() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public CurrentIndexing(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public CurrentIndexing(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public CurrentIndexing position(long position) {
            return (CurrentIndexing)super.position(position);
        }
    
        public native int numElementsPerThread(); public native CurrentIndexing numElementsPerThread(int numElementsPerThread);
        public native int blockStartingIndex(); public native CurrentIndexing blockStartingIndex(int blockStartingIndex);
        public native int startingThreadIndex(); public native CurrentIndexing startingThreadIndex(int startingThreadIndex);
        public native int endingThreadIndex(); public native CurrentIndexing endingThreadIndex(int endingThreadIndex);

    }



    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(int shape1Rank,@Cast("Nd4jLong*") LongPointer shape1,int shape2Rank,@Cast("Nd4jLong*") LongPointer shape2);
    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(int shape1Rank,@Cast("Nd4jLong*") LongBuffer shape1,int shape2Rank,@Cast("Nd4jLong*") LongBuffer shape2);
    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(int shape1Rank,@Cast("Nd4jLong*") long[] shape1,int shape2Rank,@Cast("Nd4jLong*") long[] shape2);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer detachShape(@Cast("Nd4jLong*") LongPointer originalShape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer detachShape(@Cast("Nd4jLong*") LongBuffer originalShape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] detachShape(@Cast("Nd4jLong*") long[] originalShape);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer copyShape(@Cast("Nd4jLong*") LongPointer originalShape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer copyShape(@Cast("Nd4jLong*") LongBuffer originalShape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] copyShape(@Cast("Nd4jLong*") long[] originalShape);

    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(@Cast("Nd4jLong*") LongPointer shapeInfo1,@Cast("Nd4jLong*") LongPointer shapeInfo2);
    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(@Cast("Nd4jLong*") LongBuffer shapeInfo1,@Cast("Nd4jLong*") LongBuffer shapeInfo2);
    @Namespace("shape") public static native @Cast("bool") boolean shapeEquals(@Cast("Nd4jLong*") long[] shapeInfo1,@Cast("Nd4jLong*") long[] shapeInfo2);

    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("Nd4jLong*") LongPointer shape1,int shape2Rank,@Cast("Nd4jLong*") LongPointer shape2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("Nd4jLong*") LongBuffer shape1,int shape2Rank,@Cast("Nd4jLong*") LongBuffer shape2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("Nd4jLong*") long[] shape1,int shape2Rank,@Cast("Nd4jLong*") long[] shape2);

    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") LongPointer shapeInfo1,@Cast("Nd4jLong*") LongPointer shapeInfo2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") LongBuffer shapeInfo1,@Cast("Nd4jLong*") LongBuffer shapeInfo2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") long[] shapeInfo1,@Cast("Nd4jLong*") long[] shapeInfo2);

    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") LongPointer stride1,int rank1,@Cast("Nd4jLong*") LongPointer stride2,int rank2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") LongBuffer stride1,int rank1,@Cast("Nd4jLong*") LongBuffer stride2,int rank2);
    @Namespace("shape") public static native @Cast("bool") boolean strideEquals(@Cast("Nd4jLong*") long[] stride1,int rank1,@Cast("Nd4jLong*") long[] stride2,int rank2);

    @Namespace("shape") public static native @Cast("bool") boolean equalsSoft(@Cast("Nd4jLong*") LongPointer shapeA, @Cast("Nd4jLong*") LongPointer shapeB);
    @Namespace("shape") public static native @Cast("bool") boolean equalsSoft(@Cast("Nd4jLong*") LongBuffer shapeA, @Cast("Nd4jLong*") LongBuffer shapeB);
    @Namespace("shape") public static native @Cast("bool") boolean equalsSoft(@Cast("Nd4jLong*") long[] shapeA, @Cast("Nd4jLong*") long[] shapeB);

    @Namespace("shape") public static native @Cast("bool") boolean equalsStrict(@Cast("Nd4jLong*") LongPointer shapeA, @Cast("Nd4jLong*") LongPointer shapeB);
    @Namespace("shape") public static native @Cast("bool") boolean equalsStrict(@Cast("Nd4jLong*") LongBuffer shapeA, @Cast("Nd4jLong*") LongBuffer shapeB);
    @Namespace("shape") public static native @Cast("bool") boolean equalsStrict(@Cast("Nd4jLong*") long[] shapeA, @Cast("Nd4jLong*") long[] shapeB);

    @Namespace("shape") public static native int sizeAt(@Cast("const Nd4jLong*") LongPointer shape, int dim);
    @Namespace("shape") public static native int sizeAt(@Cast("const Nd4jLong*") LongBuffer shape, int dim);
    @Namespace("shape") public static native int sizeAt(@Cast("const Nd4jLong*") long[] shape, int dim);

    @Namespace("shape") public static native void traceNew(int id);


    @Namespace("shape") public static native int tadIndexForLinear(int linearIndex, int tadLength);

    @Namespace("shape") public static native int tadLength(@Cast("Nd4jLong*") LongPointer shapeInfo, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public static native int tadLength(@Cast("Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public static native int tadLength(@Cast("Nd4jLong*") long[] shapeInfo, int[] dimension, int dimensionLength);

    @Namespace("shape") public static native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") LongPointer oldShape, int newRank, @Cast("Nd4jLong*") LongPointer newShape, @Cast("bool") boolean isFOrder);
    @Namespace("shape") public static native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") LongBuffer oldShape, int newRank, @Cast("Nd4jLong*") LongBuffer newShape, @Cast("bool") boolean isFOrder);
    @Namespace("shape") public static native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") long[] oldShape, int newRank, @Cast("Nd4jLong*") long[] newShape, @Cast("bool") boolean isFOrder);

    @Namespace("shape") public static native @Cast("bool") boolean reshapeCF(int oldRank, @Cast("Nd4jLong*") LongPointer oldShape, int newRank, @Cast("Nd4jLong*") LongPointer newShape, @Cast("bool") boolean isFOrder, @Cast("Nd4jLong*") LongPointer target);
    @Namespace("shape") public static native @Cast("bool") boolean reshapeCF(int oldRank, @Cast("Nd4jLong*") LongBuffer oldShape, int newRank, @Cast("Nd4jLong*") LongBuffer newShape, @Cast("bool") boolean isFOrder, @Cast("Nd4jLong*") LongBuffer target);
    @Namespace("shape") public static native @Cast("bool") boolean reshapeCF(int oldRank, @Cast("Nd4jLong*") long[] oldShape, int newRank, @Cast("Nd4jLong*") long[] newShape, @Cast("bool") boolean isFOrder, @Cast("Nd4jLong*") long[] target);

    /**
    * Get the shape info buffer
    * for the given rank and shape.
    */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeBuffer(int rank, @Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeBuffer(int rank, @Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeBuffer(int rank, @Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeBuffer(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeBuffer(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeBuffer(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] buffer);

    /**
    * Get the shape info buffer
    * for the given rank and shape.
     */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeBufferFortran(int rank, @Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeBufferFortran(int rank, @Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeBufferFortran(int rank, @Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeBufferFortran(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer output);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeBufferFortran(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer output);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeBufferFortran(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] output);

    //ND4J_EXPORT _CUDA_HD void doPermuteShapeBuffer(Nd4jLong *shapeBuffer, int* rearrange, Nd4jLong *tmpBuffer);

    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank, @Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange, @Cast("Nd4jLong*") LongPointer tmpBuffer);
    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank, @Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange, @Cast("Nd4jLong*") LongBuffer tmpBuffer);
    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank, @Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange, @Cast("Nd4jLong*") long[] tmpBuffer);

// #ifdef __CUDACC__
// #endif



/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("Nd4jLong*") LongPointer shape, int rank, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("Nd4jLong*") LongBuffer shape, int rank, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("Nd4jLong*") long[] shape, int rank, @Cast("Nd4jLong*") long[] ret);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStrides(@Cast("Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("Nd4jLong*") LongPointer shape, int rank, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("Nd4jLong*") LongBuffer shape, int rank, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStrides(@Cast("Nd4jLong*") long[] shape, int rank, @Cast("Nd4jLong*") long[] ret);

    @Namespace("shape") public static native void updateStrides(@Cast("Nd4jLong*") LongPointer shape, char order);
    @Namespace("shape") public static native void updateStrides(@Cast("Nd4jLong*") LongBuffer shape, char order);
    @Namespace("shape") public static native void updateStrides(@Cast("Nd4jLong*") long[] shape, char order);


// check whether input dimensions are permuted, not permuted dimensions order have to be 0,....,rank-1

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("Nd4jLong*") LongPointer shape, int rank, int startNum);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("Nd4jLong*") LongBuffer shape, int rank, int startNum);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("Nd4jLong*") long[] shape, int rank, int startNum);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("Nd4jLong*") LongPointer shape, int rank, int startNum, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("Nd4jLong*") LongBuffer shape, int rank, int startNum, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("Nd4jLong*") long[] shape, int rank, int startNum, @Cast("Nd4jLong*") long[] ret);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("Nd4jLong*") LongPointer shape, int rank, int startNum);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("Nd4jLong*") LongBuffer shape, int rank, int startNum);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStrides(@Cast("Nd4jLong*") long[] shape, int rank, int startNum);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("Nd4jLong*") LongPointer shape, int rank, int startNum, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("Nd4jLong*") LongBuffer shape, int rank, int startNum, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] calcStrides(@Cast("Nd4jLong*") long[] shape, int rank, int startNum, @Cast("Nd4jLong*") long[] ret);

/**
 * @param toCopy the shape to copy
 * @return a copy of the original struct
 */
    @Namespace("shape") public static native ShapeInformation shapeCopy( ShapeInformation toCopy);


    @Namespace("shape") public static native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public static native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public static native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") long[] shapeBuffer);


/**
 * copy-past from java hasDefaultStridesForShape function
 * check whether array is not permuted and has contiguous elements in memory
 */ 
    @Namespace("shape") public static native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") long[] shapeInfo);


/**
 * Compute the element wise stride
 * for a given shape/stride configuration
 * @param rank the rank of the shape/stride
 * @param shape the shape
 * @param stride the stride
 * @param isFOrder 0 or 1 for whether the array is f
 * ordered or not
 * @return -1 if there is no element wise stride the
 * element wise stride of reshape(1,length) otherwise
 */
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int isFOrder);
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int isFOrder);
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int isFOrder);

/**
 * Compute the element wise stride
 * for a given shape/stride configuration
 * @param rank the rank of the shape/stride
 * @param shape the shape
 * @param stride the stride
 * @param isFOrder 0 or 1 for whether the array is f
 * ordered or not
 * @return -1 if there is no element wise stride the
 * element wise stride of reshape(1,length) otherwise
 */
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int isFOrder, @Cast("Nd4jLong*") LongPointer dimension, int dimensionLength);
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int isFOrder, @Cast("Nd4jLong*") LongBuffer dimension, int dimensionLength);
    @Namespace("shape") public static native int computeElementWiseStride(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int isFOrder, @Cast("Nd4jLong*") long[] dimension, int dimensionLength);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeInfoOnlyShapeAndStride(@Cast("Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") long[] buffer);
/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer doPermuteSwap(int length, @Cast("Nd4jLong*") LongPointer shape, IntPointer rearrange);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer doPermuteSwap(int length, @Cast("Nd4jLong*") LongBuffer shape, IntBuffer rearrange);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] doPermuteSwap(int length, @Cast("Nd4jLong*") long[] shape, int[] rearrange);



/**
 * In place permute swap
 * @param length
 * @param shape
 * @param rearrange
 */
    @Namespace("shape") public static native void doPermuteSwap(int length, @Cast("Nd4jLong**") PointerPointer shape, IntPointer rearrange);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer permuteShapeBuffer(@Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer permuteShapeBuffer(@Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] permuteShapeBuffer(@Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange);

    @Namespace("shape") public static native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange, @Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange, @Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange, @Cast("Nd4jLong*") long[] out);

    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongPointer shapeBuffer, @Const IntPointer rearrange);
    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeBuffer, @Const IntBuffer rearrange);
    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") long[] shapeBuffer, @Const int[] rearrange);

    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongPointer shapeBuffer, @Cast("const Nd4jLong*") LongPointer rearrange);
    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeBuffer, @Cast("const Nd4jLong*") LongBuffer rearrange);
    @Namespace("shape") public static native void doPermuteShapeInfo(@Cast("Nd4jLong*") long[] shapeBuffer, @Cast("const Nd4jLong*") long[] rearrange);

    @Namespace("shape") public static native void doPermuteShapeBuffer(@Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange);
    @Namespace("shape") public static native void doPermuteShapeBuffer(@Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange);
    @Namespace("shape") public static native void doPermuteShapeBuffer(@Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange);

    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank,@Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange);
    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank,@Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange);
    @Namespace("shape") public static native void doPermuteShapeBuffer(int rank,@Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange);
    /**
     * Rearrange the permute indexes
     * according to which  dimensions are specified.
     *
     * For example, dimension is implicitly:
     * 0,1,2
     *
     * If you want to do a reduce along dimensions 0 and 1,
     * you need to permute the indexes to be:
     * 2,0,1
     *
     * which will give us the ability to ierate along an element
     * wise stride.
     */

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer createPermuteIndexes(int originalRank, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer createPermuteIndexes(int originalRank, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] createPermuteIndexes(int originalRank, int[] dimension,int dimensionLength);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer computeResultShape(@Cast("Nd4jLong*") LongPointer originalShapeBuffer, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer computeResultShape(@Cast("Nd4jLong*") LongBuffer originalShapeBuffer, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] computeResultShape(@Cast("Nd4jLong*") long[] originalShapeBuffer, int[] dimension,int dimensionLength);

    /**
     * This method does inplace transpose of given shapeBuffer
     *
     * @param shapeBuffer
     */
    @Namespace("shape") public static native void transposeInplace(@Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public static native void transposeInplace(@Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public static native void transposeInplace(@Cast("Nd4jLong*") long[] shapeBuffer);


/**
 * Get the ordering for the device
 * @param length
 * @param shape
 * @param stride
 * @param elementStride
 * @return
 */
    @Namespace("shape") public static native char getOrder(int length, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int elementStride);
    @Namespace("shape") public static native char getOrder(int length, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int elementStride);
    @Namespace("shape") public static native char getOrder(int length, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int elementStride);

/**
 * Ensure that every value in the re arrange
 * array is unique
 * @param arr
 * @param shape
 * @param arrLength
 * @param shapeLength
 * @return
 */

/**
 * Permute the shape information
 * @param info the shape information to permute
 * @param rearrange the order to re arrange
 * @param rank the rank of the rearrange array
 */
    @Namespace("shape") public static native void permute(@Cast("shape::ShapeInformation**") PointerPointer info, IntPointer rearrange, int rank);
    @Namespace("shape") public static native void permute(@ByPtrPtr ShapeInformation info, IntPointer rearrange, int rank);
    @Namespace("shape") public static native void permute(@ByPtrPtr ShapeInformation info, IntBuffer rearrange, int rank);
    @Namespace("shape") public static native void permute(@ByPtrPtr ShapeInformation info, int[] rearrange, int rank);

/**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of cthe shape
 */
    @Namespace("shape") public static native int isVector(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public static native int isVector(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public static native int isVector(@Cast("Nd4jLong*") long[] shape, int rank);


    /**
     * When 1 dimension is the whole length of the
     * array
     */
    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native int oneDimEqualToLength(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native int isVector(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native int isVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native int isVector(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native @Cast("bool") boolean isLikeVector(@Cast("Nd4jLong*") LongPointer shapeInfo, @ByRef IntPointer posOfNonUnityDim);
    @Namespace("shape") public static native @Cast("bool") boolean isLikeVector(@Cast("Nd4jLong*") LongBuffer shapeInfo, @ByRef IntBuffer posOfNonUnityDim);
    @Namespace("shape") public static native @Cast("bool") boolean isLikeVector(@Cast("Nd4jLong*") long[] shapeInfo, @ByRef int[] posOfNonUnityDim);

    @Namespace("shape") public static native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native @Cast("bool") boolean isColumnVector(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isColumnVector(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isColumnVector(@Cast("Nd4jLong*") long[] shapeInfo);
    /**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of the shape
 */

    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native int isMatrix(@Cast("Nd4jLong*") long[] shapeInfo);
/**
 * Returns the shape portion of an information
 * buffer
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeOf(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeOf(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeOf(@Cast("Nd4jLong*") long[] buffer);

/**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */

    /**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */
    /**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/
    @Namespace("shape") public static native void copyTo(int length, @Cast("Nd4jLong*") LongPointer from, @Cast("Nd4jLong*") LongPointer to, @Cast("Nd4jLong*") LongPointer indexes);
    @Namespace("shape") public static native void copyTo(int length, @Cast("Nd4jLong*") LongBuffer from, @Cast("Nd4jLong*") LongBuffer to, @Cast("Nd4jLong*") LongBuffer indexes);
    @Namespace("shape") public static native void copyTo(int length, @Cast("Nd4jLong*") long[] from, @Cast("Nd4jLong*") long[] to, @Cast("Nd4jLong*") long[] indexes);

/**
 * Permute the given strides
 * in the given rearrange order
 * @param toPermute the buffer to permute
 * @param shapeRank the length of the buffer to permute
 * @param rearrange the rearrange order (must be 0 based indexes
 * and all must be filled in)
 * @return the rearranged array
 */
    //ND4J_EXPORT _CUDA_HD Nd4jLong *permutedStrides(Nd4jLong *toPermute, int shapeRank, Nd4jLong *rearrange);

/**
 * Return the slice (shape + 1 in pointer arithmetic)
 * @param shape the shape to take the slice of
 * @return the shape array - the first entry
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer slice(@Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer slice(@Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] slice(@Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public static native int slices(@Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public static native int slices(@Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public static native int slices(@Cast("Nd4jLong*") long[] shapeBuffer);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") long[] shapeBuffer);
/**
 * Returns the length of the
 * shape information buffer:
 * rank * 2 + 3
 * @param rank the rank to get the shape
 * info length for
 * @return rank * 2 + 4
 */
    @Namespace("shape") public static native int shapeInfoLength(int rank);

    @Namespace("shape") public static native int shapeInfoLength(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native int shapeInfoLength(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native int shapeInfoLength(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native @Cast("size_t") long shapeInfoByteLength(int rank);

    @Namespace("shape") public static native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") long[] shapeInfo);

/**
 * Returns the rank portion of
 * an information buffer
 */
    @Namespace("shape") public static native int rank(@Cast("const Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native int rank(@Cast("const Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native int rank(@Cast("const Nd4jLong*") long[] buffer);

/**
 * Converts a raw int buffer of the layout:
 * rank
 * shape
 * stride
 * offset
 * elementWiseStride
 *
 * where shape and stride are both straight int pointers
 */
    @Namespace("shape") public static native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") long[] buffer);

/**
 * Returns the stride portion of an information
 * buffer
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer stride(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer stride(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] stride(@Cast("Nd4jLong*") long[] buffer);

/**
 * Compute the length of the given shape
 */
    @Namespace("shape") public static native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") long[] shapeInfo);

/***
 * Returns the offset portion of an information buffer
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") long[] buffer);

    @Namespace("shape") public static native @Cast("Nd4jLong*") @ByRef LongPointer extra(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") @ByRef LongBuffer extra(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") @ByRef long[] extra(@Cast("Nd4jLong*") long[] buffer);

/**
 * Returns the ordering
 * for this shape information buffer
 */
    @Namespace("shape") public static native char order(@Cast("const Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native char order(@Cast("const Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native char order(@Cast("const Nd4jLong*") long[] buffer);

/**
 * Returns the element wise stride for this information
 * buffer
 */
   @Namespace("shape") public static native @Cast("Nd4jLong") long elementWiseStride(@Cast("Nd4jLong*") LongPointer buffer);
   @Namespace("shape") public static native @Cast("Nd4jLong") long elementWiseStride(@Cast("Nd4jLong*") LongBuffer buffer);
   @Namespace("shape") public static native @Cast("Nd4jLong") long elementWiseStride(@Cast("Nd4jLong*") long[] buffer);


    /**
 * Returns the element wise stride for this information
 * buffer
     * relative to a dimension and ordering for a reduction index
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") LongPointer buffer, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") LongBuffer buffer, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") long[] buffer, int[] dimension, int dimensionLength);

/**
 * Returns whether
 * the given shape info buffer
 * represents a scalar shape
 */
    @Namespace("shape") public static native int isScalar(@Cast("Nd4jLong*") LongPointer info);
    @Namespace("shape") public static native int isScalar(@Cast("Nd4jLong*") LongBuffer info);
    @Namespace("shape") public static native int isScalar(@Cast("Nd4jLong*") long[] info);

/**
 * Returns whether
 * the given shape information
 * represents a scalar
 * shape or not
 */
    @Namespace("shape") public static native int isScalar(ShapeInformation info);

/**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
     * Iterate over a given set of indexes
     * the begin and end indexes are 0 based.
     * 1 padding is automatically assumed for the ending.
     *
     * For example if you want to iterate over 0 to 4
     * it will go to 4 rather than 3.
     *
     * indexes should be the indexes to exclude
     * indexes length should be the length of indexes
     */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer everyIndexBut(@Cast("Nd4jLong*") LongPointer indexes,int indexesLength,int begin,int end);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer everyIndexBut(@Cast("Nd4jLong*") LongBuffer indexes,int indexesLength,int begin,int end);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] everyIndexBut(@Cast("Nd4jLong*") long[] indexes,int indexesLength,int begin,int end);

/**
 * Computes the offset for accessing
 * a global element given the shape information
 * and the offset to be read.
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    ND4J_EXPORT int tadOffset(shape::ShapeInformation *xInfo, int offset);

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ensureVectorShape(@Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ensureVectorShape(@Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ensureVectorShape(@Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer createScalarShapeInfo();

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer createScalarShapeInfo(@Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer createScalarShapeInfo(@Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] createScalarShapeInfo(@Cast("Nd4jLong*") long[] ret);

/**
 * Generate an int buffer
 * up to the given length
 * at the specified increment
 *
 */

/**
 * Range between from and two with an
 * increment of 1
 */

/**
 * Keep the given indexes
 * in the data
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer keep(@Cast("Nd4jLong*") LongPointer data, IntPointer index, int indexLength, int dataLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer keep(@Cast("Nd4jLong*") LongBuffer data, IntBuffer index, int indexLength, int dataLength);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] keep(@Cast("Nd4jLong*") long[] data, int[] index, int indexLength, int dataLength);

/**
 * Generate reverse copy of the data
 * @param data
 * @param length
 * @return
 */
/**
 *
 * @param arr1
 * @param arr1Length
 * @param arr2
 * @param arr2Length
 * @return
 */

/**
 *
 * @param numArrays
 * @param numTotalElements
 * @param arr
 * @param lengths
 * @return
 */

/**
 * Get the length per slice of the
 * given shape and the dimension
 * @param rank the rank of the shape
 * @param shape the shape of to get
 * the length per slice for
 * @param dimension the dimension to
 * get the length per slice for
 * @param dimensionLength the length of the dimension array
 * @return the length per slice of the given shape
 * along the given dimension
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("Nd4jLong*") LongPointer shape, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("Nd4jLong*") LongBuffer shape, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("Nd4jLong*") long[] shape, int[] dimension, int dimensionLength);

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("Nd4jLong*") LongPointer shape,
                                           @Cast("Nd4jLong*") LongPointer tensorShape,
                                           int tensorShapeLength,
                                           IntPointer dimension,
                                           int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("Nd4jLong*") LongBuffer shape,
                                           @Cast("Nd4jLong*") LongBuffer tensorShape,
                                           int tensorShapeLength,
                                           IntBuffer dimension,
                                           int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("Nd4jLong*") long[] shape,
                                           @Cast("Nd4jLong*") long[] tensorShape,
                                           int tensorShapeLength,
                                           int[] dimension,
                                           int dimensionLength);

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long sliceOffsetForTensor(int index,int tensorLength,int lengthPerSlice2);
/**
 * Computes the tensor along dimension
 * offset
 * @param index the index to get the offset for the tad for
 * @param rank the rank of the shapes and strides
 * @param info the shape information to use for tad
 * @param dimension the dimensions to use for computing the tensor along dimensions
 */
//    ND4J_EXPORT _CUDA_HD int offset(int index,
//                         int rank,
//                         shape::ShapeInformation *info,
//                         Nd4jLong *dimension,
//                         int dimensionLength);


/**
 * Computes the number
 * of tensors along
 * a given dimension
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") LongPointer shape,
                                            IntPointer dimension,
                                            int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") LongBuffer shape,
                                            IntBuffer dimension,
                                            int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") long[] shape,
                                            int[] dimension,
                                            int dimensionLength);

/**
 * Computes the number
 * of tensors along
 * a given dimension
 */
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") LongPointer shapeInfo, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public static native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") long[] shapeInfo, int[] dimension, int dimensionLength);



/**
 * Returns the tensor along dimension
 * for the given block index
 * @param blockSize
 * @param blockIdx
 * @param i
 * @return
 */
    @Namespace("shape") public static native int tadForBlockIndex(int blockSize, int blockIdx, int i);

/**
 * Computes the number of tads per block
 *
 */
    @Namespace("shape") public static native int tadsPerBlock(int blockSize, int tads);

//    ND4J_EXPORT _CUDA_HD Nd4jLong *tadShapeInfo(int index, Nd4jLong *xShapeInfo, Nd4jLong *dimension,
//                                int dimensionLength);

/**
 * Returns a shape buffer
 * for the shape information metadata.
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer toShapeBuffer( ShapeInformation info);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") long[] ret);

/**
 * Returns the number of elements per thread
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int numElementsPerThread(int N);

/**
 * Returns the block starting index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int blockStartingIndex(int N);

/**
 * Returns the thread starting index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int threadStartingIndex(int N, int stride, int offset);

/**
 * Returns the thread ending index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int threadEndingIndex(int N, int stride, int offset);

/**
 * Returns indexing information
 * for the current kernel invocation
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    CurrentIndexing *currentIndex(int N, int offset, int stride);

/** Given an linear index, element wise stride
 * and the length of each tad
 * map a linear index to a tad
 * @param i the index to map
 * @param the element wise stride for the tads
 * @param numElementsPerTad the number of elements
 * per tad
 */
    @Namespace("shape") public static native int tadIndex(int i, int elementWiseStride, int numElementsPerTad);

/**
 * Map a tad to a
 * reduction index.
 * @param tadIndexForOriginal the original tad index for the
 * split up problem (eg: split is dimension 3 mapping to a 2,3 problem)
 * @param tadsForReduced the number of tads for the shrunk down problem (eg: 2,3)
 * @param tadsForOriginal the number of tads for the smaller problem (eg: 3)
 */
    @Namespace("shape") public static native int reductionIndexForTad(int tadIndexForOriginal, int tadsForReduced,
                                 int tadsForOriginal);

/**
 * Computes the number of tads
 * per reduce index for the
 * reduction tad.
 */
    @Namespace("shape") public static native int tadsPerReduceIndex(int tadsForReduce, int tadsForOriginal);

/**
 * Maps a linear index to a reduction index
 * @param i the linear index to map
 * @param elementWiseStride the element wise stride
 * for the multiple problem
 * @param tadNum the number of tads for the shrunken problem
 * @param originalTadNum the tad number for the reduced version of the problem
 */
    @Namespace("shape") public static native int reductionIndexForLinear(int i, int elementWiseStride, int numElementsPerTad,
                                    int tadNum, int originalTadNum);

/**
 * Returns the prod of the data
 * up to the given length
 */
    @Namespace("shape") public static native int prod(@Cast("Nd4jLong*") LongPointer data, int length);
    @Namespace("shape") public static native int prod(@Cast("Nd4jLong*") LongBuffer data, int length);
    @Namespace("shape") public static native int prod(@Cast("Nd4jLong*") long[] data, int length);

    @Namespace("shape") public static native @Cast("Nd4jLong") long prodLong( @Cast("Nd4jLong*") LongPointer data, int length);
    @Namespace("shape") public static native @Cast("Nd4jLong") long prodLong( @Cast("Nd4jLong*") LongBuffer data, int length);
    @Namespace("shape") public static native @Cast("Nd4jLong") long prodLong( @Cast("Nd4jLong*") long[] data, int length);

    /**
     * Returns the rear most left over item not present in
     * the dimension array. This assumes that the dimension array is sorted.
     *
     * For example, given a dimension array of:
     * 0,2
     *
     * and
     *
     * 12,4,2,1 in data
     *
     * You end up with 1 (data[3])
     * since the first item won't match
     * the last item of the dimension array
     */

//    ND4J_EXPORT _CUDA_HD int rearMostLeftOverItem(Nd4jLong *data,int length,Nd4jLong *dimension,int dimensionLength);

    /**
* Get an offset for retrieval
* from a data buffer
* based on the given
* shape stride and given indices
* @param baseOffset the offset to start from
* @param shape the shape of the array
* @param stride the stride of the array
* @param indices the indices to iterate over
* @return the double at the specified index
*/
    @Namespace("shape") public static native @Cast("Nd4jLong") long getOffset(@Cast("Nd4jLong") long baseOffset,  @Cast("Nd4jLong*") LongPointer shape,  @Cast("Nd4jLong*") LongPointer stride,  @Cast("const Nd4jLong*") LongPointer indices,int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong") long getOffset(@Cast("Nd4jLong") long baseOffset,  @Cast("Nd4jLong*") LongBuffer shape,  @Cast("Nd4jLong*") LongBuffer stride,  @Cast("const Nd4jLong*") LongBuffer indices,int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong") long getOffset(@Cast("Nd4jLong") long baseOffset,  @Cast("Nd4jLong*") long[] shape,  @Cast("Nd4jLong*") long[] stride,  @Cast("const Nd4jLong*") long[] indices,int rank);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer createShapeInfo(@Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer createShapeInfo(@Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int rank);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] createShapeInfo(@Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int rank);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer createShapeInfo(@Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int rank, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer createShapeInfo(@Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int rank, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] createShapeInfo(@Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int rank, @Cast("Nd4jLong*") long[] buffer);

    /**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ind2sub(int rank,  @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ind2sub(int rank,  @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ind2sub(int rank,  @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ind2sub(int rank,  @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ind2sub(int rank,  @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ind2sub(int rank,  @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index);

    /**
     * Convert a linear index to
     * the equivalent nd index
     * @param shape the shape of the dimensions
     * @param index the index to map
     * @param numIndices the number of total indices (typically prod of shape(
     * @return the mapped indexes along each dimension
     */
    @Namespace("shape") public static native void ind2sub(int rank,@Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2sub(int rank,@Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2sub(int rank,@Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") long[] out);

/**
     * Convert a linear index to
     * the equivalent nd index.
     * Infers the number of indices from the specified shape.
     *
     * @param shape the shape of the dimensions
     * @param index the index to map
     * @return the mapped indexes along each dimension
     */
    @Namespace("shape") public static native void ind2sub(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2sub(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2sub(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") long[] out);

    /**
  * Convert a linear index to
  * the equivalent nd index
  * @param shape the shape of the dimensions
  * @param index the index to map
  * @param numIndices the number of total indices (typically prod of shape(
  * @return the mapped indexes along each dimension
  */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ind2subC(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ind2subC(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ind2subC(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index);
    /**
  * Convert a linear index to
  * the equivalent nd index
  * @param shape the shape of the dimensions
  * @param index the index to map
  * @param numIndices the number of total indices (typically prod of shape(
  * @return the mapped indexes along each dimension
  */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ind2subC(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ind2subC(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ind2subC(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices);

    /**
   * Convert a linear index to
   * the equivalent nd index
   * @param shape the shape of the dimensions
   * @param index the index to map
   * @param numIndices the number of total indices (typically prod of shape(
   * @return the mapped indexes along each dimension
   */
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices, @Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices, @Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices, @Cast("Nd4jLong*") long[] out);

/**
     * Convert a linear index to
     * the equivalent nd index.
     * Infers the number of indices from the specified shape.
     *
     * @param shape the shape of the dimensions
     * @param index the index to map
     * @return the mapped indexes along each dimension
     */
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2subC(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong") long index, @Cast("Nd4jLong*") long[] out);

    /**
  * Convert the given index (such as 1,1)
  * to a linear index
  * @param shape the shape of the indexes to convert
  * @param indices the index to convert
  * @return the linear index given the shape
  * and indices
  */
    @Namespace("shape") public static native int sub2Ind(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer indices);
    @Namespace("shape") public static native int sub2Ind(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer indices);
    @Namespace("shape") public static native int sub2Ind(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] indices);

    /**
   * Compute the real linear indices for the given shape and stride
   */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer computeIndices(int rank,  @Cast("Nd4jLong*") LongPointer shape,  @Cast("Nd4jLong*") LongPointer stride);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer computeIndices(int rank,  @Cast("Nd4jLong*") LongBuffer shape,  @Cast("Nd4jLong*") LongBuffer stride);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] computeIndices(int rank,  @Cast("Nd4jLong*") long[] shape,  @Cast("Nd4jLong*") long[] stride);

    /**
   * Compute the real linear indices for the
     * given shape buffer. Shape,stride and rank are derived
     * from the buffer
   */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer computeIndices( @Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer computeIndices( @Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] computeIndices( @Cast("Nd4jLong*") long[] shapeBuffer);

    /**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong") long index, @Cast("Nd4jLong") long numIndices,@Cast("Nd4jLong*") long[] out);

    /**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong") long index,@Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong") long index,@Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public static native void ind2subOrder(@Cast("Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong") long index,@Cast("Nd4jLong*") long[] out);

    @Namespace("shape") public static native void printShapeInfo(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native void printShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native void printShapeInfo(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("Nd4jLong*") long[] shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer strides);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer strides);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] strides);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer strides);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer strides);
    @Namespace("shape") public static native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] strides);

    @Namespace("shape") public static native void printIntArray(@Cast("Nd4jLong*") LongPointer arr,int length);
    @Namespace("shape") public static native void printIntArray(@Cast("Nd4jLong*") LongBuffer arr,int length);
    @Namespace("shape") public static native void printIntArray(@Cast("Nd4jLong*") long[] arr,int length);

    @Namespace("shape") public static native void printArray(FloatPointer arr,int length);
    @Namespace("shape") public static native void printArray(FloatBuffer arr,int length);
    @Namespace("shape") public static native void printArray(float[] arr,int length);

    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer shapeBufferOfNpy(int rank, @Cast("unsigned int*") IntPointer shape,@Cast("bool") boolean fortranOrder);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer shapeBufferOfNpy(int rank, @Cast("unsigned int*") IntBuffer shape,@Cast("bool") boolean fortranOrder);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] shapeBufferOfNpy(int rank, @Cast("unsigned int*") int[] shape,@Cast("bool") boolean fortranOrder);

//    ND4J_EXPORT _CUDA_HD Nd4jLong *shapeBufferOfNpyBuffer(char *buffer);


   // this function checks the consistence of dimensions with array rank (negative dimensions, too large dimensions, too big number of dimensions)
    // also sort input array of dimensions, this operation is also necessary for creating TAD object
    @Namespace("shape") public static native void checkDimensions(int rank, @StdVector IntPointer dimensions);
    @Namespace("shape") public static native void checkDimensions(int rank, @StdVector IntBuffer dimensions);
    @Namespace("shape") public static native void checkDimensions(int rank, @StdVector int[] dimensions);


    // return absolute index of array min, min is sub-array of max, index to be returned is min index and corresponds to maxIdx of max array
    @Namespace("shape") public static native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, int maxIdx);
    @Namespace("shape") public static native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, int maxIdx);
    @Namespace("shape") public static native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, int maxIdx);

    @Namespace("shape") public static native void shapeScalar(@Cast("Nd4jLong*const") LongPointer buffer);
    @Namespace("shape") public static native void shapeScalar(@Cast("Nd4jLong*const") LongBuffer buffer);
    @Namespace("shape") public static native void shapeScalar(@Cast("Nd4jLong*const") long[] buffer);

    @Namespace("shape") public static native void shapeVector(@Cast("const Nd4jLong") long length, @Cast("Nd4jLong*const") LongPointer buffer);
    @Namespace("shape") public static native void shapeVector(@Cast("const Nd4jLong") long length, @Cast("Nd4jLong*const") LongBuffer buffer);
    @Namespace("shape") public static native void shapeVector(@Cast("const Nd4jLong") long length, @Cast("Nd4jLong*const") long[] buffer);


    @Namespace("shape") public static native void shapeOldScalar(@Cast("Nd4jLong*const") LongPointer buffer, char order);
    @Namespace("shape") public static native void shapeOldScalar(@Cast("Nd4jLong*const") LongBuffer buffer, char order);
    @Namespace("shape") public static native void shapeOldScalar(@Cast("Nd4jLong*const") long[] buffer, char order);




//END HEADERS


    //BEGIN IMPLEMENTATIONS


// #ifdef __CUDACC__
// #endif

// #ifdef __CUDACC__
// #endif

/**
* Length of a tad given
* the shape information
*/



/**
 * Tad element wise stride:
 * given the inner most dimension (the sorted dimension of the last)
 * the element wise stride of the tad (disregarding order) is the
 * last dimension's stride.
 *
 * For a given singular dimension this will just be the only entry.
 * For example, given the following c order shape/stride:
 * 2,2,3,2
 * 12,6,2,1
 *
 * The tad element wise stride for 3 will be 1.
 * For zero it wil be 12
 *
 * For 2,3 it's 1
 *
 * Note here that the multi dimensional 2,3 case
 * is equivalent to the singular 3 case.
 *
 *
 * Note that this is for the dimension that ultimately
 * ends up removed.
 *
 * Again: this may not preserve ordering of the tad
 * but maybe used for reductions.
 */
    @Namespace("shape") public static native int tadElementWiseStride(@Cast("Nd4jLong*") LongPointer shapeInfo, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public static native int tadElementWiseStride(@Cast("Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public static native int tadElementWiseStride(@Cast("Nd4jLong*") long[] shapeInfo, int[] dimension,int dimensionLength);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */


// check whether input dimensions are permuted, not permuted dimensions order have to be 0,....,rank-1


/**
 * @param toCopy the shape to copy
 * @return a copy of the original struct
 */

/**
 * Get the shape info buffer
 * for the given rank and shape.
 */

    /**
     * This is special method, it returns ONLY 2D shapebuffer.
     *
     * This method is used only for SoftMax
     */

/**
* Get the shape info buffer
* for the given rank and shape.
*/

/**
 * Compute the real linear indices for the given shape and stride
 */

/**
* Compute the real linear indices for the given shape and stride
*/


/**
* Convert the given index (such as 1,1)
* to a linear index
* @param shape the shape of the indexes to convert
* @param indices the index to convert
* @return the linear index given the shape
* and indices
*/

/**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */

/**
 * Convert a linear index to
 * the equivalent nd index.
 * Infers the number of indices from the specified shape.
 *
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @return the mapped indexes along each dimension
 */

/**
* Convert a linear index to
* the equivalent nd index
* @param shape the shape of the dimensions
* @param index the index to map
* @param numIndices the number of total indices (typically prod of shape(
* @return the mapped indexes along each dimension
*/

/**
     * Convert a linear index to
     * the equivalent nd index.
     * Infers the number of indices from the specified shape.
     *
     * @param shape the shape of the dimensions
     * @param index the index to map
     * @return the mapped indexes along each dimension
     */

/**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */

/**
 * Convert a linear index to
 * the equivalent nd index.
 * Infers the number of indices from the specified shape.
 *
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @return the mapped indexes along each dimension
 */

/**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */

/**
     * Convert a linear index to
     * the equivalent nd index.
     * Infers the number of indices from the specified shape.
     *
     * @param shape the shape of the dimensions
     * @param index the index to map
     * @return the mapped indexes along each dimension
     */

/**
* Convert a linear index to
* the equivalent nd index
* @param shape the shape of the dimensions
* @param index the index to map
* @param numIndices the number of total indices (typically prod of shape(
* @return the mapped indexes along each dimension
*/

/**
* Convert a linear index to
* the equivalent nd index
* @param shape the shape of the dimensions
* @param index the index to map
* @param numIndices the number of total indices (typically prod of shape(
* @return the mapped indexes along each dimension
*/

/**
 * Convert a linear index to
 * the equivalent nd index
 * @param shape the shape of the dimensions
 * @param index the index to map
 * @param numIndices the number of total indices (typically prod of shape(
 * @return the mapped indexes along each dimension
 */



/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */

/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */
/*
    INLINEDEF _CUDA_HD void doPermuteShapeBuffer(Nd4jLong *shapeBuffer, int *rearrange, Nd4jLong *tmpBuffer) {
        auto shapeRef = shapeBuffer;
        //rank of the rearrange array == rank of shape buffer
        int rearrageRank = shape::rank(shapeRef);
        auto shape = shape::shapeOf(shapeRef);
        auto stride = shape::stride(shapeRef);

        shape::copyOf(rearrageRank,rearrange, tmpBuffer);
        shape::doPermuteSwap(rearrageRank,&shape, tmpBuffer);

        shape::copyOf(rearrageRank,rearrange, tmpBuffer);
        shape::doPermuteSwap(rearrageRank,&stride,tmpBuffer);

        shapeRef[shapeInfoLength(rearrageRank) - 2] = -1;
        shapeRef[shape::shapeInfoLength(rearrageRank) - 1] = shape::getOrder(rearrageRank,shape,stride,1);
    }
    */

/**
 * Get the ordering for the device
 * @param length
 * @param shape
 * @param stride
 * @param elementStride
 * @return
 */





/**
 * Ensure that every value in the re arrange
 * array is unique
 * @param arr
 * @param shape
 * @param arrLength
 * @param shapeLength
 * @return
 */

/**
 * Permute the shape information
 * @param info the shape information to permute
 * @param rearrange the order to re arrange
 * @param rank the rank of the rearrange array
 */

/**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of the shape
 */

/**
* Returns whether the
* given shape is a vector or not
* @param shape the shape of the array
* @param rank the rank of the shape
*/

/**
 * Returns the shape portion of an information
 * buffer
 */

/**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */

/**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/

/**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/

/**
 * Permute the given strides
 * in the given rearrange order
 * @param toPermute the buffer to permute
 * @param shapeRank the length of the buffer to permute
 * @param rearrange the rearrange order (must be 0 based indexes
 * and all must be filled in)
 * @return the rearranged array
 */
 /*
    INLINEDEF _CUDA_HD Nd4jLong *permutedStrides(Nd4jLong *toPermute, int shapeRank, int *rearrange) {
        Nd4jLong *strideCopy = copyOf(shapeRank, toPermute);
        checkArrangeArray(rearrange, shapeRank, shapeRank);
        Nd4jLong *newStride = doPermuteSwap(shapeRank, strideCopy, rearrange);
        delete[] strideCopy;
        return newStride;
    }
    */

/**
 * Return the slice (shape + 1 in pointer arithmetic)
 * @param shape the shape to take the slice of
 * @return the shape array - the first entry
 */

/**
 * Returns the length of the
 * shape information buffer:
 * rank * 2 + 3
 * @param rank the rank to get the shape
 * info length for
 * @return rank * 2 + 4
 */

/**
 * Returns the rank portion of
 * an information buffer
 */

/**
 * Converts a raw int buffer of the layout:
 * rank
 * shape
 * stride
 * offset
 * elementWiseStride
 *
 * where shape and stride are both straight int pointers
 */

/**
 * Returns the stride portion of an information
 * buffer
 */


/**
 * Compute the length of the given shape
 */

/***
 * Returns the offset
 * portion of an information buffer
 */


/**
 * Returns the ordering
 * for this shape information buffer
 */

/**
 * Returns the element wise stride for this information
 * buffer
 */

/**
* Returns the element wise stride for this information
* buffer relative to a dimension and reduction index
*/

/**
 * Returns whether
 * the given shape info buffer
 * represents a scalar shape
 */

/**
 * Returns whether
 * the given shape information
 * represents a scalar
 * shape or not
 */

/**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

/**
 * Computes the offset for accessing
 * a global element given the shape information
 * and the offset to be read.
 */
// #ifdef __CUDACC__
// #endif

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongPointer ensureVectorShape(@Cast("Nd4jLong*") LongPointer shape, int dimension);
    @Namespace("shape") public static native @Cast("Nd4jLong*") LongBuffer ensureVectorShape(@Cast("Nd4jLong*") LongBuffer shape, int dimension);
    @Namespace("shape") public static native @Cast("Nd4jLong*") long[] ensureVectorShape(@Cast("Nd4jLong*") long[] shape, int dimension);

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */

    /**
     * This method does STRICT comparison for two shape buffers
     *
     * @param shape
     * @return
     */

    /**
     * This method does SOFT comparison for two shape buffers, we compare only rank & shapes
     *
     * @param shape
     * @return
     */

/**
 * Generate an int buffer
 * up to the given length
 * at the specified increment
 *
 */

/**
 * Generate a range
 * beginning at from and ending at to
 * incrementing by 1
 * @param from the start
 * @param to the end
 * @return the int array starting at from and ending at to
 */

/**
 * Keep the given indexes in the data
 * @param data
 * @param index
 * @param indexLength
 * @param dataLength
 * @return
 */

/**
 * Generate a reverse
 * copy of the data
 */

/**
 *
 * @param arr1
 * @param arr1Length
 * @param arr2
 * @param arr2Length
 * @return
 */

/**
 *
 * @param numArrays
 * @param numTotalElements
 * @param arr
 * @param lengths
 * @return
 */

/**
 * Get the length per slice of the
 * given shape and the dimension
 * @param rank the rank of the shape
 * @param shape the shape of to get
 * the length per slice for
 * @param dimension the dimension to
 * get the length per slice for
 * @param dimensionLength the length of the dimension array
 * @return the length per slice of the given shape
 * along the given dimension
 */

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */

    /**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */


// #ifdef __CUDACC__
// #endif





/**
 * Computes the number
 * of tensors along
 * a given dimension
 */

/**
 * Computes the number
 * of tensors along
 * a given dimension
 */




/**
* Get an offset for retrieval
* from a data buffer
* based on the given
* shape stride and given indices
* @param baseOffset the offset to start from
* @param shape the shape of the array
* @param stride the stride of the array
* @param indices the indices to iterate over
* @return the double at the specified index
*/




/**
 * Returns the tensor along dimension
 * for the given block index
 * @param blockSize
 * @param blockIdx
 * @param i
 * @return
 */

/**
 * Computes the number of tads per block
 *
 */

/**
 * Returns a shape buffer
 * for the shape information metadata.
 */
/**
 * Given an linear index, element wise stride
 * and the length of each tad
 * map a linear index to a tad
 * @param i the index to map
 * @param the element wise stride for the tads
 * @param numElementsPerTad the number of elements
 * per tad
 */

/**
 * Map a tad to a
 * reduction index.
 * @param tadIndexForOriginal the original tad index for the
 * split up problem (eg: split is dimension 3 mapping to a 2,3 problem)
 * @param tadsForReduced the number of tads for the shrunk down problem (eg: 2,3)
 * @param tadsForOriginal the number of tads for the smaller problem (eg: 3)
 */

/**
 * Tad index for linear
 * @param linearIndex
 * @param tadLength
 * @return
 */

/**
 * Computes the number of tads
 * per reduce index for the
 * reduction tad.
 */

/**
 * Maps a linear index to a reduction index
 * @param i the linear index to map
 * @param elementWiseStride the element wise stride
 * for the multiple problem
 * @param tadNum the number of tads for the shrunken problem
 * @param originalTadNum the tad number for the reduced version of the problem
 */

/**
 * Returns the prod of the data
 * up to the given length
 */

/**
 * Returns the prod of the data
 * up to the given length
 */

    @Namespace("shape") public static native int rearMostLeftOverItem(@Cast("Nd4jLong*") LongPointer data, @Cast("Nd4jLong*") LongPointer dimension,int dimensionLength);
    @Namespace("shape") public static native int rearMostLeftOverItem(@Cast("Nd4jLong*") LongBuffer data, @Cast("Nd4jLong*") LongBuffer dimension,int dimensionLength);
    @Namespace("shape") public static native int rearMostLeftOverItem(@Cast("Nd4jLong*") long[] data, @Cast("Nd4jLong*") long[] dimension,int dimensionLength);

// #ifdef __CUDACC__
// #endif






//    INLINEDEF _CUDA_HD Nd4jLong *shapeBufferOfNpyBuffer(char *buffer) {
//        unsigned Nd4jLong *shape;
//        unsigned int ndims, wordSize;
//        bool fortranOrder;
//        cnpy::parseNpyHeaderStr(std::string(buffer),wordSize,shape,ndims,fortranOrder);
//        Nd4jLong * ret =  shape::shapeBufferOfNpy(ndims,shape,fortranOrder);
//        delete[] shape;
//        return ret;
//    }

////////////////////////////////////////////////////////////////////////// 
// copy-past from java hasDefaultStridesForShape function

    // this function checks the consistence of dimensions with array rank (negative dimensions, too large dimensions, too big number of dimensions)
    // also it sorts input array of dimensions, this operation is also necessary for creating TAD object



// return absolute index of array min, min is sub-array of max, index to be returned is min's index and corresponds to maxIdx of max array 



// #endif /* SHAPE_H_ */
        

// Parsed from helpers/OpArgsHolder.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author Yurii Shyrma (iuriish@yahoo.com), created on 15.07.2018
//

// #ifndef LIBND4J_OPARGSHOLDER_H
// #define LIBND4J_OPARGSHOLDER_H


// #include <NDArray.h>
 
@Name("nd4j::OpArgsHolder<float>") @NoOffset public static class FloatOpArgsHolder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FloatOpArgsHolder(Pointer p) { super(p); }


	

    public FloatOpArgsHolder(@Const @ByRef FloatNDArrayVector inArrs, @StdVector FloatPointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef FloatNDArrayVector inArrs, @StdVector FloatPointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/);
    public FloatOpArgsHolder(@Const @ByRef FloatNDArrayVector inArrs) { super((Pointer)null); allocate(inArrs); }
    private native void allocate(@Const @ByRef FloatNDArrayVector inArrs);
    public FloatOpArgsHolder(@Const @ByRef FloatNDArrayVector inArrs, @StdVector FloatBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef FloatNDArrayVector inArrs, @StdVector FloatBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/);
    public FloatOpArgsHolder(@Const @ByRef FloatNDArrayVector inArrs, @StdVector float[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef FloatNDArrayVector inArrs, @StdVector float[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/);

    public native @Const @ByRef FloatNDArrayVector getInArrs();

    public native @StdVector FloatPointer getTArgs();

    public native @Cast("Nd4jLong*") @StdVector LongPointer getIArgs();

    public native @Cast("bool*") @StdVector BoolPointer getAllocInfo();

    public native int getNumInArrs();

    public native int getNumTArgs();

    public native int getNumIArgs();

    public native @ByVal FloatOpArgsHolder createArgsHolderForBP(@Const @ByRef FloatNDArrayVector inGradArrs, @Cast("const bool") boolean isInPlace/*=false*/);
    public native @ByVal FloatOpArgsHolder createArgsHolderForBP(@Const @ByRef FloatNDArrayVector inGradArrs); 
    
}
 
@Name("nd4j::OpArgsHolder<float16>") @NoOffset public static class HalfOpArgsHolder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HalfOpArgsHolder(Pointer p) { super(p); }


	

    public HalfOpArgsHolder(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector ShortPointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector ShortPointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/);
    public HalfOpArgsHolder(@Const @ByRef HalfNDArrayVector inArrs) { super((Pointer)null); allocate(inArrs); }
    private native void allocate(@Const @ByRef HalfNDArrayVector inArrs);
    public HalfOpArgsHolder(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector ShortBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector ShortBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/);
    public HalfOpArgsHolder(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector short[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef HalfNDArrayVector inArrs, @Cast("float16*") @StdVector short[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/);

    public native @Const @ByRef HalfNDArrayVector getInArrs();

    public native @Cast("float16*") @StdVector ShortPointer getTArgs();

    public native @Cast("Nd4jLong*") @StdVector LongPointer getIArgs();

    public native @Cast("bool*") @StdVector BoolPointer getAllocInfo();

    public native int getNumInArrs();

    public native int getNumTArgs();

    public native int getNumIArgs();

    public native @ByVal HalfOpArgsHolder createArgsHolderForBP(@Const @ByRef HalfNDArrayVector inGradArrs, @Cast("const bool") boolean isInPlace/*=false*/);
    public native @ByVal HalfOpArgsHolder createArgsHolderForBP(@Const @ByRef HalfNDArrayVector inGradArrs); 
    
}
 
@Name("nd4j::OpArgsHolder<double>") @NoOffset public static class DoubleOpArgsHolder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DoubleOpArgsHolder(Pointer p) { super(p); }


	

    public DoubleOpArgsHolder(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/);
    public DoubleOpArgsHolder(@Const @ByRef DoubleNDArrayVector inArrs) { super((Pointer)null); allocate(inArrs); }
    private native void allocate(@Const @ByRef DoubleNDArrayVector inArrs);
    public DoubleOpArgsHolder(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/);
    public DoubleOpArgsHolder(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs); }
    private native void allocate(@Const @ByRef DoubleNDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<T>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/);

    public native @Const @ByRef DoubleNDArrayVector getInArrs();

    public native @StdVector DoublePointer getTArgs();

    public native @Cast("Nd4jLong*") @StdVector LongPointer getIArgs();

    public native @Cast("bool*") @StdVector BoolPointer getAllocInfo();

    public native int getNumInArrs();

    public native int getNumTArgs();

    public native int getNumIArgs();

    public native @ByVal DoubleOpArgsHolder createArgsHolderForBP(@Const @ByRef DoubleNDArrayVector inGradArrs, @Cast("const bool") boolean isInPlace/*=false*/);
    public native @ByVal DoubleOpArgsHolder createArgsHolderForBP(@Const @ByRef DoubleNDArrayVector inGradArrs); 
    
}







// #endif //LIBND4J_OPARGSHOLDER_H


// Parsed from array/ShapeList.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_SHAPELIST_H
// #define LIBND4J_SHAPELIST_H

// #include <vector>
// #include <shape.h>
    @Namespace("nd4j") @NoOffset public static class ShapeList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ShapeList(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ShapeList(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ShapeList position(long position) {
            return (ShapeList)super.position(position);
        }
    
        public ShapeList(@Cast("Nd4jLong*") LongPointer shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("Nd4jLong*") LongPointer shape/*=nullptr*/);
        public ShapeList() { super((Pointer)null); allocate(); }
        private native void allocate();
        public ShapeList(@Cast("Nd4jLong*") LongBuffer shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("Nd4jLong*") LongBuffer shape/*=nullptr*/);
        public ShapeList(@Cast("Nd4jLong*") long[] shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("Nd4jLong*") long[] shape/*=nullptr*/);
        public ShapeList(@Cast("Nd4jLong**") @StdVector PointerPointer shapes) { super((Pointer)null); allocate(shapes); }
        private native void allocate(@Cast("Nd4jLong**") @StdVector PointerPointer shapes);
        //ShapeList(bool autoRemovable);

        public native @Cast("Nd4jLong**") @StdVector PointerPointer asVector();
        public native void destroy();
        public native int size();
        public native @Cast("Nd4jLong*") LongPointer at(int idx);
        public native void push_back(@Cast("Nd4jLong*") LongPointer shape);
        public native void push_back(@Cast("Nd4jLong*") LongBuffer shape);
        public native void push_back(@Cast("Nd4jLong*") long[] shape);

        /**
         * PLEASE NOTE: This method should be called ONLY if shapes were generated at workspaces. Otherwise you'll get memory leak
         */
        public native void detach();
    }



// #endif //LIBND4J_SHAPELIST_H


// Parsed from op_boilerplate.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

/*
 * This set of macros is used to generate kernel calls/method calls/cuda kernels on the fly, during precompile phase.
 *
 * Entry macros start with DISPATCH_* name.
 * Basically they are rolling through *_OPS list, building list of kernels.
 * And DISPATCH_KERNEL_META rolls through any two *_OPS list, building meta kernels and their host counterparts
 *
 *
 * Those scary FE_*, FX_*, FZ_*, FM_* etc macro walls are used to give preprocessor ability to loop over list of argument,
 * which emulates forEach() pattern.
 *
 * I.e. here's macro call which generates CUDA kernels for RANDOM_OPS:
 *
 * DISPATCH_KERNEL_SIMPLE(randomSingle_, randomSingleGeneric, float, INPUT(Nd4jPointer state, float *z, int *zShapeBuffer, float *extraArguments), PARAMS(state, z, zShapeBuffer, extraArguments), OPS_A(RANDOM_OPS))
 *
 * we provide arguments:
 *      output method template
 *      target generic kernel
 *      dataType
 *      signature
 *      parameters to be passed into generic kernel
 *      list of operations
 *
 *
 * List of operations used are defined in the same *.h file, i.e. for RandomOps it's defined as:
 * #define RANDOM_OPS \
 *       (0, randomOps::UniformDistribution) ,\
 *       (1, randomOps::DropOut) ,\
 *       (2, randomOps::DropOutInverted) ,\
 *       (3, randomOps::ProbablisticMerge) ,\
 *       (4, randomOps::Linspace) ,\
 *       (5, randomOps::Choice) ,\
 *       (6, randomOps::GaussianDistribution) ,\
 *       (7, randomOps::BernoulliDistribution) ,\
 *       (8, randomOps::BinomialDistribution)
 *
 *
 * So, DISPATCH_KERNEL_SIMPLE call will generate one kernel for each of ops.
 * This allows us easy addition of new operations. Basically one should just add new Op to the list, and recompile libnd4j
 *
 * HINT: To debug macro you might want to use simple trick: open console and run "watch -n 1 gcc -e file.h"
 * This will give you real-time result of macro preprocessing, which will greatly simplify invention process.
 *
 *
 * @author Paul Dubs (@treo)
 * @author raver119@gmail.com
 */
// #pragma once
// #ifndef OP_BOILERPLATE_HH
// #define OP_BOILERPLATE_HH

// #include <type_boilerplate.h>
// #include <helpers/OpTracker.h>

// #ifdef __CUDACC__

// #elif __JAVACPP_HACK__
// #define meta_def
// #define op_def
// #define op_def_special
// #elif _MSC_VER
// #elif __clang__
// #define op_def inline
// #define op_def_special inline
// #define meta_def inline
// #elif __GNUC__
// #define meta_def _Pragma("omp declare simd") inline __attribute__((always_inline))
// #define op_def _Pragma("omp declare simd") inline __attribute__((always_inline))
// #define op_def_special _Pragma("omp declare simd") inline __attribute__((always_inline))
// #endif


public static native @MemberGetter int ELEMENT_THRESHOLD();
public static final int ELEMENT_THRESHOLD = ELEMENT_THRESHOLD();
public static native @MemberGetter int TAD_THRESHOLD();
public static final int TAD_THRESHOLD = TAD_THRESHOLD();

// #define SHAPELIST(...)  new ShapeList({__VA_ARGS__}, block.workspace() != nullptr)

// #ifdef __CUDA_ARCH__
// #define PRINT_FIRST(...)    if (threadIdx.x == 0 && blockIdx.x == 0) {printf(__VA_ARGS__); }
// #else
// #define PRINT_FIRST(...)    printf(__VA_ARGS__); fflush(stdout)
// #endif

// #define DEBUG_CALL(STREAM)      if (nd4j::Environment::getInstance()->isDebug()) { cudaError_t tRes = cudaStreamSynchronize(*STREAM); checkCudaErrors(tRes); if (tRes != 0) { throw std::runtime_error(); }; }
// #define DEBUG_KERNEL(STREAM, OP_NUM)       if (nd4j::Environment::getInstance()->isDebug()) { cudaError_t tRes = cudaStreamSynchronize(*STREAM); checkCudaErrors(tRes); if (tRes != 0) {std::string tFile(__FILE__); std::string tOp = "Kernel OpNum failed: [" + nd4j::StringUtils::valueToString<int>(OP_NUM) + std::string("]; File: ") + tFile + std::string(":") + nd4j::StringUtils::valueToString<int>(__LINE__); throw std::runtime_error(tOp.c_str()); }; }


// #define LAUNCH(A, B, C, D) <<<A, B, C, D>>>


// #define CONCAT2(A,B) A ## B
// #define CONCAT3(A,B,C) A ## B ## C

// #define ARGMIX3(A,B,C) A ## B ## _## C
// #define ARGMIX4(A,B,C,D) A ## B ## _## C ## _ ## D

// #define MIX2(A,B) A ## _ ## B
// #define MIX3(A,B,C) A ## _ ## B ## _## C
// #define MIX4(A,B,C,D) A ## _ ## B ## _## C ## _ ## D


// #define EMPTY()
// #define DEFER(id) id EMPTY()
// #define OBSTRUCT(...) __VA_ARGS__ DEFER(EMPTY)()


// #define _EXPAND_OP_CALL(FN, SIG, NUM, TYPE) case NUM: { FN<TYPE<T>>SIG; break; };
// #define _EXPAND_RETURNING_OP_CALL(FN, SIG, NUM, TYPE) else if(opNum == NUM){ return FN<TYPE<T>>SIG; }
// #define _EXPAND_PACKED_OP_CALL(FN, SIG, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _OP_CALL (FN, SIG, UNPAREN(OPNUM_PAIR)))
// #define _EXPAND_RETURNING_PACKED_OP_CALL(FN, SIG, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _RETURNING_OP_CALL (FN, SIG, UNPAREN(OPNUM_PAIR)))

// #define FE_1(WHAT, FN, SIG, OPNUM_PAIR) WHAT(FN, SIG, OPNUM_PAIR)
// #define FE_2(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_1(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_3(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_2(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_4(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_3(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_5(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_4(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_6(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_5(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_7(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_6(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_8(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_7(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_9(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_8(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_10(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_9(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_11(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_10(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_12(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_11(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_13(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_12(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_14(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_13(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_15(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_14(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_16(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_15(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_17(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_16(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_18(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_17(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_19(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_18(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_20(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_19(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_21(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_20(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_22(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_21(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_23(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_22(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_24(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_23(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_25(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_24(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_26(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_25(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_27(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_26(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_28(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_27(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_29(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_28(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_30(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_29(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_31(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_30(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_32(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_31(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_33(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_32(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_34(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_33(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_35(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_34(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_36(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_35(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_37(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_36(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_38(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_37(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_39(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_38(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_40(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_39(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_41(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_40(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_42(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_41(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_43(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_42(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_44(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_43(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_45(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_44(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_46(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_45(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_47(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_46(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_48(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_47(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_49(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_48(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_50(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_49(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_51(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_50(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_52(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_51(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_53(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_52(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_54(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_53(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_55(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_54(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_56(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_55(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_57(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_56(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_58(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_57(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_59(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_58(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_60(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_59(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_61(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_60(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_62(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_61(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_63(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_62(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_64(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_63(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_65(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_64(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_66(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_65(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_67(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_66(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_68(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_67(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_69(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_68(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_70(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_69(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_71(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_70(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_72(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_71(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_73(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_72(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_74(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_73(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_75(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_74(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_76(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_75(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_77(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_76(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_78(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_77(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_79(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_78(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_80(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_79(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_81(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_80(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_82(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_81(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_83(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_82(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_84(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_83(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_85(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_84(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_86(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_85(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_87(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_86(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_88(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_87(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_89(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_88(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_90(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_89(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_91(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_90(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_92(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_91(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_93(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_92(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_94(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_93(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_95(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_94(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_96(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_95(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_97(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_96(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_98(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_97(WHAT, FN, SIG, __VA_ARGS__))
// #define FE_99(WHAT, FN, SIG, OPNUM_PAIR, ...) WHAT(FN, SIG, OPNUM_PAIR)EVAL(FE_98(WHAT, FN, SIG, __VA_ARGS__))


// #define CL1_1(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)
// #define CL1_2(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_1(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_3(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_2(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_4(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_3(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_5(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_4(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_6(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_5(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_7(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_6(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_8(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_7(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_9(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_8(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_10(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_9(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_11(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_10(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_12(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_11(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_13(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_12(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_14(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_13(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_15(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_14(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_16(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_15(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_17(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_16(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_18(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_17(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_19(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_18(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_20(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_19(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_21(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_20(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_22(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_21(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_23(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_22(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_24(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_23(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_25(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_24(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_26(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_25(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_27(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_26(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_28(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_27(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_29(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_28(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_30(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_29(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_31(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_30(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_32(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_31(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_33(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_32(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_34(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_33(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_35(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_34(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_36(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_35(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_37(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_36(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_38(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_37(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_39(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_38(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_40(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_39(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_41(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_40(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_42(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_41(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_43(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_42(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_44(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_43(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_45(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_44(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_46(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_45(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_47(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_46(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_48(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_47(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_49(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_48(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_50(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_49(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_51(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_50(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_52(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_51(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_53(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_52(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_54(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_53(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_55(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_54(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_56(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_55(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_57(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_56(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_58(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_57(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_59(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_58(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_60(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_59(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_61(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_60(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_62(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_61(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_63(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_62(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_64(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_63(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_65(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_64(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_66(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_65(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_67(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_66(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_68(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_67(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_69(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_68(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_70(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_69(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_71(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_70(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_72(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_71(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_73(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_72(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_74(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_73(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_75(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_74(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_76(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_75(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_77(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_76(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_78(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_77(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_79(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_78(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_80(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_79(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_81(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_80(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_82(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_81(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_83(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_82(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_84(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_83(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_85(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_84(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_86(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_85(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_87(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_86(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_88(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_87(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_89(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_88(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_90(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_89(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_91(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_90(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_92(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_91(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_93(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_92(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_94(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_93(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_95(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_94(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_96(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_95(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_97(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_96(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_98(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_97(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define CL1_99(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(CL1_98(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))


// #define TR_1(WHAT, TYPE, OPNUM_PAIR) WHAT(TYPE, OPNUM_PAIR)
// #define TR_2(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_1(WHAT, TYPE, __VA_ARGS__))
// #define TR_3(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_2(WHAT, TYPE, __VA_ARGS__))
// #define TR_4(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_3(WHAT, TYPE, __VA_ARGS__))
// #define TR_5(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_4(WHAT, TYPE, __VA_ARGS__))
// #define TR_6(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_5(WHAT, TYPE, __VA_ARGS__))
// #define TR_7(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_6(WHAT, TYPE, __VA_ARGS__))
// #define TR_8(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_7(WHAT, TYPE, __VA_ARGS__))
// #define TR_9(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_8(WHAT, TYPE, __VA_ARGS__))
// #define TR_10(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_9(WHAT, TYPE, __VA_ARGS__))
// #define TR_11(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_10(WHAT, TYPE, __VA_ARGS__))
// #define TR_12(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_11(WHAT, TYPE, __VA_ARGS__))
// #define TR_13(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_12(WHAT, TYPE, __VA_ARGS__))
// #define TR_14(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_13(WHAT, TYPE, __VA_ARGS__))
// #define TR_15(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_14(WHAT, TYPE, __VA_ARGS__))
// #define TR_16(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_15(WHAT, TYPE, __VA_ARGS__))
// #define TR_17(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_16(WHAT, TYPE, __VA_ARGS__))
// #define TR_18(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_17(WHAT, TYPE, __VA_ARGS__))
// #define TR_19(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_18(WHAT, TYPE, __VA_ARGS__))
// #define TR_20(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_19(WHAT, TYPE, __VA_ARGS__))
// #define TR_21(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_20(WHAT, TYPE, __VA_ARGS__))
// #define TR_22(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_21(WHAT, TYPE, __VA_ARGS__))
// #define TR_23(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_22(WHAT, TYPE, __VA_ARGS__))
// #define TR_24(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_23(WHAT, TYPE, __VA_ARGS__))
// #define TR_25(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_24(WHAT, TYPE, __VA_ARGS__))
// #define TR_26(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_25(WHAT, TYPE, __VA_ARGS__))
// #define TR_27(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_26(WHAT, TYPE, __VA_ARGS__))
// #define TR_28(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_27(WHAT, TYPE, __VA_ARGS__))
// #define TR_29(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_28(WHAT, TYPE, __VA_ARGS__))
// #define TR_30(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_29(WHAT, TYPE, __VA_ARGS__))
// #define TR_31(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_30(WHAT, TYPE, __VA_ARGS__))
// #define TR_32(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_31(WHAT, TYPE, __VA_ARGS__))
// #define TR_33(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_32(WHAT, TYPE, __VA_ARGS__))
// #define TR_34(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_33(WHAT, TYPE, __VA_ARGS__))
// #define TR_35(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_34(WHAT, TYPE, __VA_ARGS__))
// #define TR_36(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_35(WHAT, TYPE, __VA_ARGS__))
// #define TR_37(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_36(WHAT, TYPE, __VA_ARGS__))
// #define TR_38(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_37(WHAT, TYPE, __VA_ARGS__))
// #define TR_39(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_38(WHAT, TYPE, __VA_ARGS__))
// #define TR_40(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_39(WHAT, TYPE, __VA_ARGS__))
// #define TR_41(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_40(WHAT, TYPE, __VA_ARGS__))
// #define TR_42(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_41(WHAT, TYPE, __VA_ARGS__))
// #define TR_43(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_42(WHAT, TYPE, __VA_ARGS__))
// #define TR_44(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_43(WHAT, TYPE, __VA_ARGS__))
// #define TR_45(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_44(WHAT, TYPE, __VA_ARGS__))
// #define TR_46(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_45(WHAT, TYPE, __VA_ARGS__))
// #define TR_47(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_46(WHAT, TYPE, __VA_ARGS__))
// #define TR_48(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_47(WHAT, TYPE, __VA_ARGS__))
// #define TR_49(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_48(WHAT, TYPE, __VA_ARGS__))
// #define TR_50(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_49(WHAT, TYPE, __VA_ARGS__))
// #define TR_51(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_50(WHAT, TYPE, __VA_ARGS__))
// #define TR_52(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_51(WHAT, TYPE, __VA_ARGS__))
// #define TR_53(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_52(WHAT, TYPE, __VA_ARGS__))
// #define TR_54(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_53(WHAT, TYPE, __VA_ARGS__))
// #define TR_55(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_54(WHAT, TYPE, __VA_ARGS__))
// #define TR_56(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_55(WHAT, TYPE, __VA_ARGS__))
// #define TR_57(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_56(WHAT, TYPE, __VA_ARGS__))
// #define TR_58(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_57(WHAT, TYPE, __VA_ARGS__))
// #define TR_59(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_58(WHAT, TYPE, __VA_ARGS__))
// #define TR_60(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_59(WHAT, TYPE, __VA_ARGS__))
// #define TR_61(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_60(WHAT, TYPE, __VA_ARGS__))
// #define TR_62(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_61(WHAT, TYPE, __VA_ARGS__))
// #define TR_63(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_62(WHAT, TYPE, __VA_ARGS__))
// #define TR_64(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_63(WHAT, TYPE, __VA_ARGS__))
// #define TR_65(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_64(WHAT, TYPE, __VA_ARGS__))
// #define TR_66(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_65(WHAT, TYPE, __VA_ARGS__))
// #define TR_67(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_66(WHAT, TYPE, __VA_ARGS__))
// #define TR_68(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_67(WHAT, TYPE, __VA_ARGS__))
// #define TR_69(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_68(WHAT, TYPE, __VA_ARGS__))
// #define TR_70(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_69(WHAT, TYPE, __VA_ARGS__))
// #define TR_71(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_70(WHAT, TYPE, __VA_ARGS__))
// #define TR_72(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_71(WHAT, TYPE, __VA_ARGS__))
// #define TR_73(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_72(WHAT, TYPE, __VA_ARGS__))
// #define TR_74(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_73(WHAT, TYPE, __VA_ARGS__))
// #define TR_75(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_74(WHAT, TYPE, __VA_ARGS__))
// #define TR_76(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_75(WHAT, TYPE, __VA_ARGS__))
// #define TR_77(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_76(WHAT, TYPE, __VA_ARGS__))
// #define TR_78(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_77(WHAT, TYPE, __VA_ARGS__))
// #define TR_79(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_78(WHAT, TYPE, __VA_ARGS__))
// #define TR_80(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_79(WHAT, TYPE, __VA_ARGS__))
// #define TR_81(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_80(WHAT, TYPE, __VA_ARGS__))
// #define TR_82(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_81(WHAT, TYPE, __VA_ARGS__))
// #define TR_83(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_82(WHAT, TYPE, __VA_ARGS__))
// #define TR_84(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_83(WHAT, TYPE, __VA_ARGS__))
// #define TR_85(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_84(WHAT, TYPE, __VA_ARGS__))
// #define TR_86(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_85(WHAT, TYPE, __VA_ARGS__))
// #define TR_87(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_86(WHAT, TYPE, __VA_ARGS__))
// #define TR_88(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_87(WHAT, TYPE, __VA_ARGS__))
// #define TR_89(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_88(WHAT, TYPE, __VA_ARGS__))
// #define TR_90(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_89(WHAT, TYPE, __VA_ARGS__))
// #define TR_91(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_90(WHAT, TYPE, __VA_ARGS__))
// #define TR_92(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_91(WHAT, TYPE, __VA_ARGS__))
// #define TR_93(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_92(WHAT, TYPE, __VA_ARGS__))
// #define TR_94(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_93(WHAT, TYPE, __VA_ARGS__))
// #define TR_95(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_94(WHAT, TYPE, __VA_ARGS__))
// #define TR_96(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_95(WHAT, TYPE, __VA_ARGS__))
// #define TR_97(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_96(WHAT, TYPE, __VA_ARGS__))
// #define TR_98(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_97(WHAT, TYPE, __VA_ARGS__))
// #define TR_99(WHAT, TYPE, OPNUM_PAIR, ...) WHAT(TYPE, OPNUM_PAIR)EVAL(TR_98(WHAT, TYPE, __VA_ARGS__))

// #define DIR_1(WHAT, PARAMS, OPNUM_PAIR) WHAT(PARAMS, OPNUM_PAIR)
// #define DIR_2(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_1(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_3(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_2(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_4(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_3(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_5(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_4(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_6(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_5(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_7(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_6(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_8(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_7(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_9(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_8(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_10(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_9(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_11(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_10(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_12(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_11(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_13(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_12(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_14(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_13(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_15(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_14(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_16(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_15(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_17(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_16(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_18(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_17(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_19(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_18(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_20(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_19(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_21(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_20(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_22(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_21(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_23(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_22(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_24(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_23(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_25(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_24(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_26(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_25(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_27(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_26(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_28(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_27(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_29(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_28(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_30(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_29(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_31(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_30(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_32(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_31(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_33(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_32(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_34(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_33(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_35(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_34(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_36(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_35(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_37(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_36(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_38(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_37(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_39(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_38(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_40(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_39(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_41(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_40(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_42(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_41(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_43(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_42(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_44(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_43(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_45(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_44(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_46(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_45(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_47(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_46(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_48(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_47(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_49(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_48(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_50(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_49(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_51(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_50(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_52(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_51(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_53(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_52(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_54(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_53(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_55(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_54(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_56(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_55(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_57(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_56(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_58(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_57(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_59(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_58(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_60(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_59(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_61(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_60(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_62(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_61(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_63(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_62(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_64(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_63(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_65(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_64(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_66(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_65(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_67(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_66(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_68(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_67(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_69(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_68(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_70(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_69(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_71(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_70(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_72(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_71(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_73(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_72(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_74(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_73(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_75(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_74(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_76(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_75(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_77(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_76(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_78(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_77(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_79(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_78(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_80(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_79(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_81(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_80(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_82(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_81(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_83(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_82(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_84(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_83(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_85(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_84(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_86(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_85(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_87(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_86(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_88(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_87(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_89(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_88(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_90(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_89(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_91(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_90(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_92(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_91(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_93(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_92(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_94(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_93(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_95(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_94(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_96(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_95(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_97(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_96(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_98(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_97(WHAT, PARAMS, __VA_ARGS__))
// #define DIR_99(WHAT, PARAMS, OPNUM_PAIR, ...) WHAT(PARAMS, OPNUM_PAIR)EVAL(DIR_98(WHAT, PARAMS, __VA_ARGS__))


// #define FZ_1(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)
// #define FZ_2(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_1(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_3(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_2(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_4(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_3(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_5(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_4(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_6(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_5(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_7(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_6(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_8(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_7(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_9(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_8(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_10(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_9(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_11(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_10(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_12(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_11(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_13(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_12(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_14(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_13(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_15(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_14(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_16(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_15(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_17(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_16(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_18(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_17(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_19(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_18(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_20(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_19(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_21(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_20(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_22(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_21(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_23(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_22(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_24(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_23(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_25(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_24(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_26(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_25(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_27(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_26(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_28(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_27(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_29(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_28(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_30(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_29(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_31(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_30(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_32(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_31(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_33(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_32(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_34(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_33(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_35(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_34(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_36(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_35(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_37(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_36(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_38(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_37(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_39(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_38(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_40(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_39(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_41(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_40(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_42(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_41(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_43(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_42(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_44(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_43(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_45(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_44(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_46(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_45(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_47(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_46(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_48(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_47(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_49(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_48(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_50(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_49(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_51(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_50(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_52(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_51(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_53(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_52(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_54(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_53(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_55(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_54(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_56(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_55(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_57(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_56(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_58(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_57(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_59(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_58(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_60(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_59(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_61(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_60(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_62(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_61(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_63(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_62(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_64(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_63(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_65(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_64(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_66(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_65(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_67(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_66(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_68(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_67(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_69(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_68(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_70(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_69(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_71(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_70(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_72(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_71(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_73(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_72(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_74(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_73(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_75(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_74(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_76(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_75(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_77(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_76(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_78(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_77(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_79(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_78(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_80(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_79(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_81(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_80(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_82(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_81(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_83(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_82(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_84(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_83(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_85(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_84(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_86(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_85(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_87(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_86(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_88(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_87(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_89(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_88(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_90(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_89(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_91(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_90(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_92(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_91(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_93(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_92(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_94(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_93(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_95(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_94(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_96(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_95(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_97(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_96(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_98(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_97(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define FZ_99(WHAT, NAME, TYPE, SIGNATURE, OPNUM_PAIR, ...) WHAT(NAME, TYPE, SIGNATURE, OPNUM_PAIR)EVAL(FZ_98(WHAT, NAME, TYPE, SIGNATURE, __VA_ARGS__))

// #define FF_1(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FF_2(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_1(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_3(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_2(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_4(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_3(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_5(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_4(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_6(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_5(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_7(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_6(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_8(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_7(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_9(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_8(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_10(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_9(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_11(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_10(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_12(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_11(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_13(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_12(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_14(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_13(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_15(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_14(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_16(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_15(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_17(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_16(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_18(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_17(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_19(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_18(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FF_20(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FF_19(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))


// #define FFI_1(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FFI_2(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_1(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_3(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_2(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_4(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_3(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_5(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_4(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_6(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_5(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_7(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_6(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_8(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_7(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_9(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_8(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_10(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_9(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_11(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_10(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_12(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_11(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_13(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_12(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_14(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_13(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_15(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_14(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_16(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_15(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_17(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_16(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_18(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_17(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_19(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_18(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FFI_20(WHAT, TYPE, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(TYPE, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FFI_19(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))

// #define FM_1(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FM_2(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_1(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_3(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_2(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_4(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_3(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_5(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_4(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_6(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_5(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_7(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_6(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_8(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_7(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_9(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_8(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_10(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_9(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_11(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_10(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_12(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_11(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_13(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_12(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_14(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_13(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_15(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_14(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_16(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_15(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_17(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_16(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR,__VA_ARGS__))
// #define FM_18(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_17(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_19(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_18(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_20(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_19(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_21(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_20(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_22(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_21(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_23(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_22(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_24(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_23(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_25(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_24(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_26(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_25(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_27(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_26(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_28(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_27(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_29(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_28(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_30(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_29(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_31(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_30(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_32(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_31(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_33(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_32(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_34(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_33(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_35(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_34(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_36(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_35(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_37(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_36(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_38(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_37(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_39(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_38(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_40(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_39(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_41(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_40(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_42(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_41(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_43(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_42(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_44(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_43(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_45(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_44(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_46(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_45(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_47(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_46(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_48(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_47(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_49(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_48(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_50(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_49(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_51(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_50(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_52(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_51(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_53(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_52(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_54(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_53(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_55(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_54(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_56(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_55(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_57(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_56(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_58(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_57(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_59(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_58(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_60(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_59(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_61(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_60(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_62(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_61(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_63(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_62(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_64(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_63(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_65(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_64(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_66(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_65(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_67(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_66(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_68(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_67(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_69(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_68(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FM_70(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FM_69(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))


// #define FX_1(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FX_2(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_1(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_3(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_2(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_4(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_3(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_5(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_4(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_6(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_5(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_7(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_6(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_8(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_7(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_9(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_8(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_10(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_9(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_11(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_10(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_12(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_11(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_13(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_12(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_14(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_13(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_15(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_14(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_16(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_15(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_17(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_16(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_18(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_17(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_19(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_18(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_20(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_19(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_21(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_20(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_22(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_21(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_23(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_22(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_24(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_23(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_25(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_24(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_26(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_25(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_27(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_26(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_28(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_27(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_29(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_28(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_30(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_29(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_31(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_30(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_32(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_31(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_33(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_32(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_34(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_33(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_35(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_34(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_36(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_35(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_37(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_36(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_38(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_37(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_39(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_38(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_40(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_39(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_41(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_40(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_42(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_41(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_43(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_42(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_44(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_43(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_45(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_44(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_46(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_45(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_47(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_46(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_48(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_47(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_49(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_48(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_50(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_49(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_51(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_50(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_52(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_51(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_53(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_52(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_54(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_53(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_55(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_54(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_56(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_55(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_57(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_56(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_58(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_57(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_59(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_58(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_60(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_59(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_61(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_60(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_62(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_61(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_63(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_62(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_64(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_63(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_65(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_64(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_66(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_65(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_67(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_66(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_68(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_67(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_69(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_68(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FX_70(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, SIG, OPCLASS, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FX_69(WHAT, FN, SIG, OPCLASS, OPNUM_PAIR, __VA_ARGS__))


// #define FK_1(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FK_2(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_1(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_3(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_2(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_4(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_3(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_5(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_4(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_6(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_5(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_7(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_6(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_8(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_7(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_9(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_8(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_10(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_9(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_11(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_10(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_12(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_11(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_13(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_12(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_14(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_13(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_15(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_14(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_16(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_15(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_17(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_16(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_18(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_17(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_19(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_18(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_20(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_19(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_21(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_20(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_22(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_21(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_23(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_22(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_24(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_23(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_25(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_24(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_26(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_25(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_27(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_26(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_28(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_27(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_29(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_28(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_30(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_29(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_31(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_30(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_32(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_31(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_33(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_32(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_34(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_33(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_35(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_34(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_36(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_35(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_37(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_36(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_38(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_37(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_39(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_38(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_40(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_39(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_41(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_40(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_42(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_41(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_43(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_42(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_44(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_43(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_45(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_44(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_46(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_45(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_47(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_46(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_48(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_47(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_49(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_48(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_50(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_49(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_51(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_50(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_52(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_51(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_53(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_52(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_54(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_53(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_55(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_54(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_56(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_55(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_57(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_56(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_58(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_57(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_59(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_58(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_60(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_59(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_61(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_60(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_62(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_61(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_63(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_62(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_64(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_63(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_65(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_64(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_66(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_65(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_67(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_66(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_68(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_67(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_69(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_68(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FK_70(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FK_69(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))



// #define FI_1(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)
// #define FI_2(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_1(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_3(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_2(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_4(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_3(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_5(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_4(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_6(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_5(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_7(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_6(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_8(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_7(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_9(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_8(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_10(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_9(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_11(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_10(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_12(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_11(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_13(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_12(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_14(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_13(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_15(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_14(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_16(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_15(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_17(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_16(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_18(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_17(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_19(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_18(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_20(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_19(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_21(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_20(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_22(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_21(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_23(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_22(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_24(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_23(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_25(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_24(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_26(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_25(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_27(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_26(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_28(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_27(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_29(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_28(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_30(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_29(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_31(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_30(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_32(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_31(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_33(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_32(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_34(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_33(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_35(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_34(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_36(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_35(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_37(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_36(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_38(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_37(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_39(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_38(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_40(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_39(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_41(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_40(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_42(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_41(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_43(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_42(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_44(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_43(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_45(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_44(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_46(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_45(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_47(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_46(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_48(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_47(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_49(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_48(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_50(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_49(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_51(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_50(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_52(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_51(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_53(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_52(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_54(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_53(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_55(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_54(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_56(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_55(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_57(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_56(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_58(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_57(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_59(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_58(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_60(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_59(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_61(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_60(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_62(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_61(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_63(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_62(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_64(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_63(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_65(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_64(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_66(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_65(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_67(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_66(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_68(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_67(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_69(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_68(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FI_70(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B, ...) WHAT(FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, OPNUM_PAIR_B)EVAL(FI_69(WHAT, FN, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))


// #define FS_1(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)
// #define FS_2(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_1(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_3(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_2(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_4(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_3(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_5(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_4(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_6(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_5(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_7(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_6(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_8(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_7(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_9(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_8(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_10(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_9(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_11(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_10(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_12(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_11(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_13(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_12(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_14(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_13(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_15(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_14(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_16(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_15(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_17(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_16(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_18(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_17(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_19(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_18(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_20(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_19(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_21(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_20(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_22(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_21(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_23(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_22(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_24(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_23(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_25(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_24(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_26(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_25(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_27(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_26(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_28(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_27(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_29(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_28(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_30(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_29(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_31(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_30(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_32(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_31(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_33(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_32(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_34(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_33(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_35(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_34(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_36(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_35(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_37(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_36(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_38(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_37(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_39(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_38(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_40(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_39(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_41(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_40(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_42(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_41(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_43(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_42(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_44(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_43(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_45(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_44(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_46(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_45(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_47(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_46(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_48(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_47(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_49(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_48(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_50(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_49(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_51(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_50(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_52(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_51(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_53(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_52(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_54(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_53(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_55(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_54(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_56(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_55(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_57(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_56(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_58(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_57(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_59(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_58(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_60(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_59(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_61(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_60(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_62(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_61(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_63(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_62(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_64(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_63(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_65(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_64(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_66(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_65(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_67(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_66(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_68(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_67(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_69(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_68(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_70(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_69(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_71(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_70(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_72(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_71(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_73(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_72(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_74(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_73(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_75(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_74(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_76(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_75(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_77(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_76(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_78(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_77(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_79(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_78(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_80(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_79(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_81(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_80(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_82(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_81(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_83(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_82(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_84(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_83(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_85(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_84(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_86(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_85(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_87(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_86(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_88(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_87(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_89(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_88(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_90(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_89(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_91(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_90(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_92(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_91(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_93(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_92(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_94(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_93(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_95(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_94(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_96(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_95(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_97(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_96(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_98(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_97(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FS_99(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR, ...) WHAT(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR)EVAL(FS_98(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))

//////////////////////////////
// #ifdef __clang__
// #define _EXPAND_META_CALL(FN, SIG, OPCLASS, NUM_A, TYPE_A, NUM_B, TYPE_B) if(opNumA == NUM_A && opNumB == NUM_B){ MIX4(FN,NUM_A,NUM_B,OPCLASS) LAUNCH(256, 512, 1024, *stream) SIG; };
// #elif _MSC_VER
// #define _EXPAND_META_CALL(FN, SIG, OPCLASS, NUM_A, TYPE_A, NUM_B, TYPE_B) if(opNumA == NUM_A && opNumB == NUM_B){ MIX4(FN,NUM_A,NUM_B,OPCLASS) LAUNCH(256, 512, 1024, *stream) SIG; };
// #elif __GNUC__
// #define _EXPAND_META_CALL(FN, SIG, OPCLASS, NUM_A, TYPE_A, NUM_B, TYPE_B) else if(opNumA == NUM_A && opNumB == NUM_B){ MIX4(FN,NUM_A,NUM_B,OPCLASS) LAUNCH(256, 512, 2048, *stream) SIG; }
// #elif __CUDACC__
// #endif
// #define _EXPAND_OP_SIMPLE(NAME, TYPE, PARAMZ, NUM_A, TYPE_A) case NUM_A: {MIX3(NAME, NUM_A, TYPE) LAUNCH(launchDims.x, launchDims.y, launchDims.z, *stream) PARAMZ;} break;

// #define _EXPAND_OP_CALL_1(NAME, TYPE, PARAMZ, NUM_A, TYPE_A) NAME<TYPE_A<TYPE>>PARAMZ;
// #define _EXPAND_OP_DIRECT(PARAMZ, NUM_A, TYPE_A)  case NUM_A: { z = TYPE_A<T>::op PARAMZ; break; }
// #define _EXPAND_OP_CALL_T(TYPE, NUM_A, TYPE_A) OpTracker::getInstance()->storeOperation(TYPE, #TYPE_A, NUM_A);

// #define _EXPAND_FACTORY_CALL(TYPE, LAYER_ID, LAYER_NAME, ACTIVATION_ID, ACTIVATION_NAME) if (activationNum == ACTIVATION_ID && layerNum == LAYER_ID) { return new LAYER_NAME<TYPE, ACTIVATION_NAME<TYPE>>(); };

// #define _EXPAND_PACKED_CALL_1(NAME, TYPE, PARAMZ, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _OP_CALL_1(NAME, TYPE, PARAMZ, UNPAREN(OPNUM_PAIR)))
// #define _EXPAND_PACKED_DIRECT(PARAMZ, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _OP_DIRECT(PARAMZ, UNPAREN(OPNUM_PAIR)))
// #define _EXPAND_PACKED_CALL_T(TYPE, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _OP_CALL_T(TYPE, UNPAREN(OPNUM_PAIR)))

// #define _EXPAND_KERNEL_CALL(NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, NUM_A, TYPE_A, NUM_B, TYPE_B) extern "C" __global__ void ARGMIX4(NAME, NUM_A, NUM_B, TYPE)INPUTZ {KERNEL<TYPE, OPCLASS<TYPE, TYPE_A<TYPE>, TYPE_B<TYPE>>>PARAMZ ;};
// #define _EXPAND_KERNEL_SIMPLE(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, NUM_A, TYPE_A) extern "C" __global__ void ARGMIX3(NAME, NUM_A, TYPE)INPUTZ {KERNEL<TYPE, TYPE_A<TYPE>>PARAMZ ;};
// #define _EXPAND_PACKED_SIMPLE(NAME, TYPE, PARAMZ, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _OP_SIMPLE(NAME, TYPE, PARAMZ, UNPAREN(OPNUM_PAIR)))
// #define _EXPAND_PACKED_KERNEL_SIMPLE(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, OPNUM_PAIR) EVALUATING_PASTE(_EXPAND, _KERNEL_SIMPLE (NAME, KERNEL, TYPE, INPUTZ, PARAMZ, UNPAREN(OPNUM_PAIR)))
// #define _EXPAND_PACKED_KERNEL_CALL(NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR_A, OPNUM_PAIR_B) EVALUATING_PASTE(_EXPAND, _KERNEL_CALL (NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, UNPAREN(OPNUM_PAIR_B), UNPAREN(OPNUM_PAIR_A)))
// #define _EXPAND_PACKED_META_CALL(FN, SIG, OPCLASS, OPNUM_PAIR_A, OPNUM_PAIR_B) EVALUATING_PASTE(_EXPAND, _META_CALL (FN, SIG, OPCLASS, UNPAREN(OPNUM_PAIR_B), UNPAREN(OPNUM_PAIR_A) ))

// #define _EXPAND_PACKED_FACTORY_CALL(TYPE, OPNUM_PAIR_A, OPNUM_PAIR_B) EVALUATING_PASTE(_EXPAND, _FACTORY_CALL (TYPE, UNPAREN(OPNUM_PAIR_B), UNPAREN(OPNUM_PAIR_A)))
//////////////////////////////

// #define GET_MACROS_1(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, _71, _72, _73, _74, _75, _76, _77, _78, _79, _80, _81, _82, _83, _84, _85, _86, _87, _88, _89, _90, _91, _92, _93, _94, _95, _96, _97, _98, _99, NAME,...) NAME
// #define GET_MACROS_D(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, _71, _72, _73, _74, _75, _76, _77, _78, _79, _80, _81, _82, _83, _84, _85, _86, _87, _88, _89, _90, _91, _92, _93, _94, _95, _96, _97, _98, _99, NAME,...) NAME
// #define GET_MACROS_T(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, _71, _72, _73, _74, _75, _76, _77, _78, _79, _80, _81, _82, _83, _84, _85, _86, _87, _88, _89, _90, _91, _92, _93, _94, _95, _96, _97, _98, _99, NAME,...) NAME

// #define  GET_MACRO(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, _71, _72, _73, _74, _75, _76, _77, _78, _79, _80, _81, _82, _83, _84, _85, _86, _87, _88, _89, _90, _91, _92, _93, _94, _95, _96, _97, _98, _99, NAME,...) NAME
// #define GET_MACROS(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, _71, _72, _73, _74, _75, _76, _77, _78, _79, _80, _81, _82, _83, _84, _85, _86, _87, _88, _89, _90, _91, _92, _93, _94, _95, _96, _97, _98, _99, NAME,...) NAME
// #define GET_MACROX(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, NAME,...) NAME
// #define GET_MACROE(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, NAME,...) NAME
// #define GET_MACROK(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, NAME,...) NAME
// #define GET_MACROI(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63, _64, _65, _66, _67, _68, _69, _70, NAME,...) NAME
// #define GET_MACROF(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, NAME,...) NAME
// #define FOR_EACH(WHAT, NAME, SIGNATURE, ...) EVAL(GET_MACRO(__VA_ARGS__,  FE_99, FE_98, FE_97, FE_96, FE_95, FE_94, FE_93, FE_92, FE_91, FE_90, FE_89, FE_88, FE_87, FE_86, FE_85, FE_84, FE_83, FE_82, FE_81, FE_80, FE_79, FE_78, FE_77, FE_76, FE_75, FE_74, FE_73, FE_72, FE_71, FE_70, FE_69, FE_68, FE_67, FE_66, FE_65, FE_64, FE_63, FE_62, FE_61, FE_60, FE_59, FE_58, FE_57, FE_56, FE_55, FE_54, FE_53, FE_52, FE_51, FE_50, FE_49, FE_48, FE_47, FE_46, FE_45, FE_44, FE_43, FE_42, FE_41, FE_40, FE_39, FE_38, FE_37, FE_36, FE_35, FE_34, FE_33, FE_32, FE_31, FE_30, FE_29, FE_28, FE_27, FE_26, FE_25, FE_24, FE_23, FE_22, FE_21, FE_20, FE_19, FE_18, FE_17, FE_16, FE_15, FE_14, FE_13, FE_12, FE_11, FE_10, FE_9, FE_8, FE_7, FE_6, FE_5, FE_4, FE_3, FE_2, FE_1)(WHAT, NAME, SIGNATURE, __VA_ARGS__))

// #define FOR_EACH_M(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR, ...) EXPAND(GET_MACROX(__VA_ARGS__, FM_70, FM_69, FM_68, FM_67, FM_66, FM_65, FM_64, FM_63, FM_62, FM_61, FM_60, FM_59, FM_58, FM_57, FM_56, FM_55, FM_54, FM_53, FM_52, FM_51, FM_50, FM_49, FM_48, FM_47, FM_46, FM_45, FM_44, FM_43, FM_42, FM_41, FM_40, FM_39, FM_38, FM_37, FM_36, FM_35, FM_34, FM_33, FM_32, FM_31, FM_30, FM_29, FM_28, FM_27, FM_26, FM_25, FM_24, FM_23, FM_22, FM_21, FM_20, FM_19, FM_18, FM_17, FM_16, FM_15, FM_14, FM_13, FM_12, FM_11, FM_10, FM_9, FM_8, FM_7, FM_6, FM_5, FM_4, FM_3, FM_2, FM_1)(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR, __VA_ARGS__))
// #define FOR_EACH_X(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR, ...) EXPAND(GET_MACROE(__VA_ARGS__, FX_70, FX_69, FX_68, FX_67, FX_66, FX_65, FX_64, FX_63, FX_62, FX_61, FX_60, FX_59, FX_58, FX_57, FX_56, FX_55, FX_54, FX_53, FX_52, FX_51, FX_50, FX_49, FX_48, FX_47, FX_46, FX_45, FX_44, FX_43, FX_42, FX_41, FX_40, FX_39, FX_38, FX_37, FX_36, FX_35, FX_34, FX_33, FX_32, FX_31, FX_30, FX_29, FX_28, FX_27, FX_26, FX_25, FX_24, FX_23, FX_22, FX_21, FX_20, FX_19, FX_18, FX_17, FX_16, FX_15, FX_14, FX_13, FX_12, FX_11, FX_10, FX_9, FX_8, FX_7, FX_6, FX_5, FX_4, FX_3, FX_2, FX_1)(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR, __VA_ARGS__))

// #define FOR_EACH_CALL_1(WHAT, NAME, TYPE, PARAMZ, ...) EXPAND(GET_MACROS_1(__VA_ARGS__,  CL1_99, CL1_98, CL1_97, CL1_96, CL1_95, CL1_94, CL1_93, CL1_92, CL1_91, CL1_90, CL1_89, CL1_88, CL1_87, CL1_86, CL1_85, CL1_84, CL1_83, CL1_82, CL1_81, CL1_80, CL1_79, CL1_78, CL1_77, CL1_76, CL1_75, CL1_74, CL1_73, CL1_72, CL1_71, CL1_70, CL1_69, CL1_68, CL1_67, CL1_66, CL1_65, CL1_64, CL1_63, CL1_62, CL1_61, CL1_60, CL1_59, CL1_58, CL1_57, CL1_56, CL1_55, CL1_54, CL1_53, CL1_52, CL1_51, CL1_50, CL1_49, CL1_48, CL1_47, CL1_46, CL1_45, CL1_44, CL1_43, CL1_42, CL1_41, CL1_40, CL1_39, CL1_38, CL1_37, CL1_36, CL1_35, CL1_34, CL1_33, CL1_32, CL1_31, CL1_30, CL1_29, CL1_28, CL1_27, CL1_26, CL1_25, CL1_24, CL1_23, CL1_22, CL1_21, CL1_20, CL1_19, CL1_18, CL1_17, CL1_16, CL1_15, CL1_14, CL1_13, CL1_12, CL1_11, CL1_10, CL1_9, CL1_8, CL1_7, CL1_6, CL1_5, CL1_4, CL1_3, CL1_2, CL1_1)(WHAT, NAME, TYPE, PARAMZ, __VA_ARGS__))
// #define FOR_EACH_DIRECT(WHAT, PARAMZ, ...) EXPAND(GET_MACROS_D(__VA_ARGS__,  DIR_99, DIR_98, DIR_97, DIR_96, DIR_95, DIR_94, DIR_93, DIR_92, DIR_91, DIR_90, DIR_89, DIR_88, DIR_87, DIR_86, DIR_85, DIR_84, DIR_83, DIR_82, DIR_81, DIR_80, DIR_79, DIR_78, DIR_77, DIR_76, DIR_75, DIR_74, DIR_73, DIR_72, DIR_71, DIR_70, DIR_69, DIR_68, DIR_67, DIR_66, DIR_65, DIR_64, DIR_63, DIR_62, DIR_61, DIR_60, DIR_59, DIR_58, DIR_57, DIR_56, DIR_55, DIR_54, DIR_53, DIR_52, DIR_51, DIR_50, DIR_49, DIR_48, DIR_47, DIR_46, DIR_45, DIR_44, DIR_43, DIR_42, DIR_41, DIR_40, DIR_39, DIR_38, DIR_37, DIR_36, DIR_35, DIR_34, DIR_33, DIR_32, DIR_31, DIR_30, DIR_29, DIR_28, DIR_27, DIR_26, DIR_25, DIR_24, DIR_23, DIR_22, DIR_21, DIR_20, DIR_19, DIR_18, DIR_17, DIR_16, DIR_15, DIR_14, DIR_13, DIR_12, DIR_11, DIR_10, DIR_9, DIR_8, DIR_7, DIR_6, DIR_5, DIR_4, DIR_3, DIR_2, DIR_1)(WHAT, PARAMZ, __VA_ARGS__))
// #define FOR_EACH_TRACKER(WHAT, TYPE, ...) EXPAND(GET_MACROS_T(__VA_ARGS__,  TR_99, TR_98, TR_97, TR_96, TR_95, TR_94, TR_93, TR_92, TR_91, TR_90, TR_89, TR_88, TR_87, TR_86, TR_85, TR_84, TR_83, TR_82, TR_81, TR_80, TR_79, TR_78, TR_77, TR_76, TR_75, TR_74, TR_73, TR_72, TR_71, TR_70, TR_69, TR_68, TR_67, TR_66, TR_65, TR_64, TR_63, TR_62, TR_61, TR_60, TR_59, TR_58, TR_57, TR_56, TR_55, TR_54, TR_53, TR_52, TR_51, TR_50, TR_49, TR_48, TR_47, TR_46, TR_45, TR_44, TR_43, TR_42, TR_41, TR_40, TR_39, TR_38, TR_37, TR_36, TR_35, TR_34, TR_33, TR_32, TR_31, TR_30, TR_29, TR_28, TR_27, TR_26, TR_25, TR_24, TR_23, TR_22, TR_21, TR_20, TR_19, TR_18, TR_17, TR_16, TR_15, TR_14, TR_13, TR_12, TR_11, TR_10, TR_9, TR_8, TR_7, TR_6, TR_5, TR_4, TR_3, TR_2, TR_1)(WHAT, TYPE, __VA_ARGS__))

// #define FOR_EACH_Z(WHAT, NAME, TYPE, PARAMZ, ...) EXPAND(GET_MACROS(__VA_ARGS__,  FZ_99, FZ_98, FZ_97, FZ_96, FZ_95, FZ_94, FZ_93, FZ_92, FZ_91, FZ_90, FZ_89, FZ_88, FZ_87, FZ_86, FZ_85, FZ_84, FZ_83, FZ_82, FZ_81, FZ_80, FZ_79, FZ_78, FZ_77, FZ_76, FZ_75, FZ_74, FZ_73, FZ_72, FZ_71, FZ_70, FZ_69, FZ_68, FZ_67, FZ_66, FZ_65, FZ_64, FZ_63, FZ_62, FZ_61, FZ_60, FZ_59, FZ_58, FZ_57, FZ_56, FZ_55, FZ_54, FZ_53, FZ_52, FZ_51, FZ_50, FZ_49, FZ_48, FZ_47, FZ_46, FZ_45, FZ_44, FZ_43, FZ_42, FZ_41, FZ_40, FZ_39, FZ_38, FZ_37, FZ_36, FZ_35, FZ_34, FZ_33, FZ_32, FZ_31, FZ_30, FZ_29, FZ_28, FZ_27, FZ_26, FZ_25, FZ_24, FZ_23, FZ_22, FZ_21, FZ_20, FZ_19, FZ_18, FZ_17, FZ_16, FZ_15, FZ_14, FZ_13, FZ_12, FZ_11, FZ_10, FZ_9, FZ_8, FZ_7, FZ_6, FZ_5, FZ_4, FZ_3, FZ_2, FZ_1)(WHAT, NAME, TYPE, PARAMZ, __VA_ARGS__))
// #define FOR_EACH_S(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, ...) EXPAND(GET_MACROS(__VA_ARGS__,  FS_99, FS_98, FS_97, FS_96, FS_95, FS_94, FS_93, FS_92, FS_91, FS_90, FS_89, FS_88, FS_87, FS_86, FS_85, FS_84, FS_83, FS_82, FS_81, FS_80, FS_79, FS_78, FS_77, FS_76, FS_75, FS_74, FS_73, FS_72, FS_71, FS_70, FS_69, FS_68, FS_67, FS_66, FS_65, FS_64, FS_63, FS_62, FS_61, FS_60, FS_59, FS_58, FS_57, FS_56, FS_55, FS_54, FS_53, FS_52, FS_51, FS_50, FS_49, FS_48, FS_47, FS_46, FS_45, FS_44, FS_43, FS_42, FS_41, FS_40, FS_39, FS_38, FS_37, FS_36, FS_35, FS_34, FS_33, FS_32, FS_31, FS_30, FS_29, FS_28, FS_27, FS_26, FS_25, FS_24, FS_23, FS_22, FS_21, FS_20, FS_19, FS_18, FS_17, FS_16, FS_15, FS_14, FS_13, FS_12, FS_11, FS_10, FS_9, FS_8, FS_7, FS_6, FS_5, FS_4, FS_3, FS_2, FS_1)(WHAT, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__))
// #define FOR_EACH_I(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, ...) EXPAND(GET_MACROI(__VA_ARGS__, FI_70, FI_69, FI_68, FI_67, FI_66, FI_65, FI_64, FI_63, FI_62, FI_61, FI_60, FI_59, FI_58, FI_57, FI_56, FI_55, FI_54, FI_53, FI_52, FI_51, FI_50, FI_49, FI_48, FI_47, FI_46, FI_45, FI_44, FI_43, FI_42, FI_41, FI_40, FI_39, FI_38, FI_37, FI_36, FI_35, FI_34, FI_33, FI_32, FI_31, FI_30, FI_29, FI_28, FI_27, FI_26, FI_25, FI_24, FI_23, FI_22, FI_21, FI_20, FI_19, FI_18, FI_17, FI_16, FI_15, FI_14, FI_13, FI_12, FI_11, FI_10, FI_9, FI_8, FI_7, FI_6, FI_5, FI_4, FI_3, FI_2, FI_1)(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))
// #define FOR_EACH_K(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, ...) EXPAND(GET_MACROK(__VA_ARGS__, FK_70, FK_69, FK_68, FK_67, FK_66, FK_65, FK_64, FK_63, FK_62, FK_61, FK_60, FK_59, FK_58, FK_57, FK_56, FK_55, FK_54, FK_53, FK_52, FK_51, FK_50, FK_49, FK_48, FK_47, FK_46, FK_45, FK_44, FK_43, FK_42, FK_41, FK_40, FK_39, FK_38, FK_37, FK_36, FK_35, FK_34, FK_33, FK_32, FK_31, FK_30, FK_29, FK_28, FK_27, FK_26, FK_25, FK_24, FK_23, FK_22, FK_21, FK_20, FK_19, FK_18, FK_17, FK_16, FK_15, FK_14, FK_13, FK_12, FK_11, FK_10, FK_9, FK_8, FK_7, FK_6, FK_5, FK_4, FK_3, FK_2, FK_1)(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR, __VA_ARGS__))

// #define FOR_EACH_F(WHAT, TYPE, OPNUM_PAIR, ...) EXPAND(GET_MACROF(__VA_ARGS__, FF_20, FF_19, FF_18, FF_17, FF_16, FF_15, FF_14, FF_13, FF_12, FF_11, FF_10, FF_9, FF_8, FF_7, FF_6, FF_5, FF_4, FF_3, FF_2, FF_1)(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))
// #define FOR_EACH_FI(WHAT, TYPE, OPNUM_PAIR, ...) EXPAND(GET_MACROF(__VA_ARGS__, FFI_20, FFI_19, FFI_18, FFI_17, FFI_16, FFI_15, FFI_14, FFI_13, FFI_12, FFI_11, FFI_10, FFI_9, FFI_8, FFI_7, FFI_6, FFI_5, FFI_4, FFI_3, FFI_2, FFI_1)(WHAT, TYPE, OPNUM_PAIR, __VA_ARGS__))


// #define _EXEC_OPS(WHAT, NAME, SIGNATURE, ...) EVAL(FOR_EACH(WHAT, NAME, SIGNATURE, __VA_ARGS__))
// #define _EXEC_OP_SIMPLE(NAME, TYPE, SIGNATURE, ...) EVAL(FOR_EACH_Z(THETA, NAME, TYPE, SIGNATURE, __VA_ARGS__))

// #define _EXEC_BUILDER_1(NAME, TYPE, SIGNATURE, ...) EVAL(FOR_EACH_CALL_1(CALL_1, NAME, TYPE, SIGNATURE, __VA_ARGS__))
// #define _EXEC_OP_DIRECT(SIGNATURE, ...) EVAL(FOR_EACH_DIRECT(DIRECT, SIGNATURE, __VA_ARGS__))
// #define _EXEC_TRACKER(TYPE, ...) EVAL(FOR_EACH_TRACKER(CALL_T, TYPE, __VA_ARGS__))

// #define _EXEC_META_X(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR_A, ...) EVAL(FOR_EACH_X(WHAT, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR_A, __VA_ARGS__))
// #define _EXEC_META_M(WHAT, NAME, SIGNATURE, OPCLASS, LIST_A, ...) EVAL(FOR_EACH_M(ALPHA, NAME, SIGNATURE, OPCLASS, OPS_A(LIST_A), __VA_ARGS__))
// #define _EXEC_FACTORY(WHAT, TYPE, LIST_A, ...) EVAL(FOR_EACH_F(PHI, TYPE, OPS_A(LIST_A), __VA_ARGS__))
// #define _EXEC_FACTORY_INTERNAL(WHAT, TYPE, ACTIVATION, ...) EVAL(FOR_EACH_FI(WHAT, TYPE, ACTIVATION, __VA_ARGS__))

// #define _EXEC_KERNEL_F(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, ...) EVAL(FOR_EACH_S(GAMMA, NAME, KERNEL, TYPE, INPUTZ, PARAMZ, __VA_ARGS__ ))
// #define _EXEC_KERNEL_M(NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, LIST_A, ...) EVAL(FOR_EACH_K(BETA, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPS_A(LIST_A), __VA_ARGS__ ))
// #define _EXEC_KERNEL_X(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ,  OPNUM_PAIR_A, ...) EVAL(FOR_EACH_I(WHAT, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR_A, __VA_ARGS__))
//_EXPAND_PACKED_OP_CALL
// #define DISPATCH_BY_OPNUM(NAME, SIGNATURE, ...) switch(opNum) { EVAL(_EXEC_OPS(_EXPAND_PACKED_OP_CALL, NAME, (SIGNATURE), __VA_ARGS__)) default: { printf("[ERROR] Unknown opNum=%d on %s:%d", opNum, __FILE__, __LINE__); }}

// #ifdef __clang__
// #define DISPATCH_METAOP(NAME, SIGNATURE, OPCLASS, LIST_A, LIST_B) EVAL(_EXEC_META_M(RANDOMWHAT, NAME, (SIGNATURE), OPCLASS, (LIST_A), LIST_B))
// #elif _MSC_VER
// #define DISPATCH_METAOP(NAME, SIGNATURE, OPCLASS, LIST_A, LIST_B) EVAL(_EXEC_META_M(RANDOMWHAT, NAME, (SIGNATURE), OPCLASS, (LIST_A), LIST_B))
// #elif __GNUC__
// #define DISPATCH_METAOP(NAME, SIGNATURE, OPCLASS, LIST_A, LIST_B) if(false){} EVAL(_EXEC_META_M(RANDOMWHAT, NAME, (SIGNATURE), OPCLASS, (LIST_A), LIST_B)) else{ printf("[ERROR] Unknown opNum=%d on %s:%d", opNumA, __FILE__, __LINE__); }
// #elif __CUDACC__
// #endif

// #define BUILD_LAYERS_FACTORY(TYPE, LIST_A, LIST_B) EVAL(_EXEC_FACTORY(RANDOMWHAT, TYPE, (LIST_A), LIST_B))

// #define DISPATCH_SIMPLE(NAME, TYPE, SIGNATURE, LIST_A) switch(opNum) { EVAL(_EXEC_OP_SIMPLE(NAME, TYPE, (SIGNATURE), LIST_A)) default: { printf("[ERROR] Unknown opNum=%d on %s:%d", opNum, __FILE__, __LINE__); }}

// #define DISPATCH_KERNEL_SIMPLE(NAME, KERNEL, TYPE, INPUTZ, PARAMZ, LIST_A) EVAL(_EXEC_KERNEL_F(NAME, KERNEL, TYPE, (INPUTZ), (PARAMZ), LIST_A))
// #define DISPATCH_KERNEL_META(NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, LIST_A, LIST_B ) EVAL(_EXEC_KERNEL_M(NAME, KERNEL, TYPE, OPCLASS, (INPUTZ), (PARAMZ), (LIST_A), LIST_B))
// #define DISPATCH_INTERNAL(NAME, SIGNATURE, OPCLASS, OPNUM_PAIR_B, ...) EXPAND(_EXEC_META_X(_EXPAND_PACKED_META_CALL, NAME, SIGNATURE, OPCLASS, OPNUM_PAIR_B, __VA_ARGS__))

// #define DISPATCH_FACTORY(TYPE, ACTIVATION, ...) EXPAND(_EXEC_FACTORY_INTERNAL(_EXPAND_PACKED_FACTORY_CALL, TYPE, ACTIVATION, __VA_ARGS__))

// #define DISPATCH_KERNEL_INTERNAL(NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR_B, ...) EXPAND(_EXEC_KERNEL_X(_EXPAND_PACKED_KERNEL_CALL, NAME, KERNEL, TYPE, OPCLASS, INPUTZ, PARAMZ, OPNUM_PAIR_B, __VA_ARGS__))

// #define BUILD_CALL_1(NAME, TYPE, SIGNATURE, OPS) EVAL(_EXEC_BUILDER_1(NAME, TYPE, SIGNATURE, OPS))
// #define BUILD_TRACKER(TYPE, OPS) EVAL(_EXEC_TRACKER(TYPE, OPS))

// #define EXECUTE_NOE(SIGNATURE, LIST_A) switch(opNum) {EVAL(_EXEC_OP_DIRECT(SIGNATURE, LIST_A)) default: { printf("[ERROR] Unknown opNum=%d on %s:%d", opNum, __FILE__, __LINE__); }};

// #define RETURNING_DISPATCH_BY_OPNUM(NAME, SIGNATURE, ...) if(false){} EVAL(_EXEC_OPS(_EXPAND_RETURNING_PACKED_OP_CALL, NAME, (SIGNATURE), __VA_ARGS__)) else{ printf("[ERROR] Unknown opNum=%d on %s:%d", opNum, __FILE__, __LINE__); return 0; }
// #define PARAMS(...) __VA_ARGS__
// #define INPUT(...) __VA_ARGS__
// #define OPS_A(...) __VA_ARGS__
// #define OPS_B(...) __VA_ARGS__
// #define OPS_X(...) __VA_ARGS__
// #define ALPHA(A, B, C, D, E) EXPAND(DISPATCH_INTERNAL(A, B, C, E, UNPAREN(D)))
// #define BETA(A, B, C, D, E, F, G, H) EXPAND(DISPATCH_KERNEL_INTERNAL(A, B, C, D, E, F, H, UNPAREN(G)))
// #define GAMMA(A, B, C, D, E, F) EXPAND(_EXPAND_PACKED_KERNEL_SIMPLE(A, B, C, D, E, F))
// #define THETA(A, B, C, D) EXPAND(_EXPAND_PACKED_SIMPLE(A, B, C, D))
// #define PHI(A, B, C) EXPAND(DISPATCH_FACTORY(A, C, UNPAREN(B)))

// #define CALL_1(A, B, C, D) EXPAND(_EXPAND_PACKED_CALL_1(A, B, C, D))
// #define CALL_T(A, B) EXPAND(_EXPAND_PACKED_CALL_T(A, B))
// #define DIRECT(A, B) EXPAND(_EXPAND_PACKED_DIRECT(A, B))




/** graph definitions */
// #define REQUIRE_OK(A)  if (nd4j::ops::resultHelper( (A), #A, __FILE__, __LINE__ ) != 0) return ND4J_STATUS_VALIDATION;
// #define REQUIRE_TRUE(...) if (nd4j::ops::conditionHelper(__FILE__, __LINE__, __VA_ARGS__) != 0) throw std::invalid_argument("Op validation failed");

// #define DECLARE_ENTRY(NAME, ...)           template struct ND4J_EXPORT __registratorFloat<NAME<float>>;
//                                       template struct ND4J_EXPORT __registratorHalf<NAME<float16>>;
//                                       template struct ND4J_EXPORT __registratorDouble<NAME<double>>;
//                                       template struct ND4J_EXPORT __registratorSynonymHalf<NAME<float16>>;
//                                       template struct ND4J_EXPORT __registratorSynonymDouble<NAME<double>>;
//                                       template struct ND4J_EXPORT __registratorSynonymFloat<NAME<float>>;


// #if defined(_MSC_VER) || defined(_WIN64) || defined(_WIN32) || defined(__CLION_IDE__) || defined(__VSCODE__)
// #define NOT_EXCLUDED(NAME) 1>0
// #else
// #define NOT_EXCLUDED(NAME) defined(LIBND4J_ALL_OPS) || defined(NAME)
// #endif

// #ifdef __JAVACPP_HACK__
// #define REGISTER_H(NAME)
// #elif defined(LIBND4J_ALL_OPS)
// #else
// #define REGISTER_H(NAME)  template <typename OpName>
//                         struct __registratorFloat_##NAME {
//                             __registratorFloat_##NAME() {
//                                 OpName *ptr = new OpName();
//                                 OpRegistrator::getInstance()->registerOperationFloat(ptr);
//                                 OpTracker::getInstance()->storeOperation(OpType_CUSTOM, *ptr->getOpDescriptor());
//                             }
//                         };
//                         template <typename OpName>
//                         struct __registratorHalf_##NAME {
//                             __registratorHalf_##NAME() {
//                                 OpName *ptr = new OpName();
//                                 OpRegistrator::getInstance()->registerOperationHalf(ptr);
//                             }
//                         };
//                         template <typename OpName>
//                         struct __registratorDouble_##NAME {
//                             __registratorDouble_##NAME() {
//                                 OpName *ptr = new OpName();
//                                 OpRegistrator::getInstance()->registerOperationDouble(ptr);
//                             }
//                         };
//                         static nd4j::ops::__registratorFloat_##NAME<NAME<float>> zzz_register_opf_##NAME;
//                         static nd4j::ops::__registratorHalf_##NAME<NAME<float16>> zzz_register_oph_##NAME;
//                         static nd4j::ops::__registratorDouble_##NAME<NAME<double>> zzz_register_opd_##NAME;
// #endif

// #ifdef __JAVACPP_HACK__
// #define REGISTER_C(NAME)
// #elif defined(LIBND4J_ALL_OPS)
// #else
// #define REGISTER_C(NAME)
// #endif

// #define DECLARE_OP(NAME, NIN, NOUT, INPLACEABLE)   template <typename T>
//                                                 class NAME: public nd4j::ops::DeclarableOp<T> {
//                                                 public:
//                                                     NAME();
//                                                     nd4j::ShapeList* calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block);
//                                                 protected:
//                                                     Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                                 };
//                                                 REGISTER_H(NAME)

// #define DECLARE_BOOLEAN_OP(NAME, NIN, SCALAR)   template <typename T>
//                                                 class NAME: public nd4j::ops::BooleanOp<T> {
//                                                 public:
//                                                     NAME();
//                                                 protected:
//                                                     Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                                 };
//                                                 REGISTER_H(NAME)

// #define BOOLEAN_OP_IMPL(NAME, NIN, SCALAR)   template <typename T>
//                                                 NAME<T>::NAME() : nd4j::ops::BooleanOp<T>(#NAME, NIN, SCALAR) { };
//                                                 REGISTER_C(NAME)
//                                                 template class ND4J_EXPORT NAME<float>;
//                                                 template class ND4J_EXPORT NAME<float16>;
//                                                 template class ND4J_EXPORT NAME<double>;
//                                                 template <typename T>
//                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)

// #define DECLARE_LIST_OP(NAME, NIN, NOUT, TARGS, IARGS)      template <typename T>
//                                                             class NAME: public nd4j::ops::DeclarableListOp<T> {
//                                                             public:
//                                                                 NAME();
//                                                             protected:
//                                                                 Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                                             };
//                                                             REGISTER_H(NAME)

// #define LIST_OP_IMPL(NAME, NIN, NOUT, TARGS, IARGS)         template <typename T>
//                                                             NAME<T>::NAME() : nd4j::ops::DeclarableListOp<T>(NIN, NOUT, #NAME, TARGS, IARGS) { };
//                                                             template class ND4J_EXPORT NAME<float>;
//                                                             template class ND4J_EXPORT NAME<float16>;
//                                                             template class ND4J_EXPORT NAME<double>;
//                                                             REGISTER_C(NAME)
//                                                             template <typename T>
//                                                             Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)

// #define DECLARE_LOGIC_OP(NAME)      template <typename T>
//                                     class NAME: public nd4j::ops::LogicOp<T> {
//                                     public:
//                                         NAME();
//                                     protected:
//                                         Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                     };
//                                     REGISTER_H(NAME)

// #define LOGIC_OP_IMPL(NAME)     template <typename T>
//                                 NAME<T>::NAME() : nd4j::ops::LogicOp<T>(#NAME) { };
//                                 template class ND4J_EXPORT NAME<float>;
//                                 template class ND4J_EXPORT NAME<float16>;
//                                 template class ND4J_EXPORT NAME<double>;
//                                 REGISTER_C(NAME)
//                                 template <typename T>
//                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block) { return nd4j::ops::LogicOp<T>::validateAndExecute(block); };



// #define OP_IMPL(NAME, NIN, NOUT, INPLACEABLE)   template <typename T>
//                                                 NAME<T>::NAME() : nd4j::ops::DeclarableOp<T>(NIN, NOUT, #NAME, INPLACEABLE) { };
//                                                 template class ND4J_EXPORT NAME<float>;
//                                                 template class ND4J_EXPORT NAME<float16>;
//                                                 template class ND4J_EXPORT NAME<double>;
//                                                 REGISTER_C(NAME)
//                                                 template <typename T>
//                                                 nd4j::ShapeList* nd4j::ops::NAME<T>::calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block) {
//                                                     auto shapeList = SHAPELIST();
//                                                     for (int e = 0; e < this->getOpDescriptor()->getNumberOfOutputs(); e++) {
//                                                         Nd4jLong* newshape;
//                                                         ALLOCATE(newshape, block.getWorkspace(), shape::shapeInfoLength(inputShape->at(e)), Nd4jLong);
//                                                         if (shape::order(inputShape->at(e)) == 'c')
//                                                             shape::shapeBuffer(shape::rank(inputShape->at(e)), shape::shapeOf(inputShape->at(e)), newshape);
//                                                         else
//                                                             shape::shapeBufferFortran(shape::rank(inputShape->at(e)), shape::shapeOf(inputShape->at(e)), newshape);
//                                                         shapeList->push_back(newshape);
//                                                     }
//                                                     return shapeList;
//                                                 }
//                                                 template <typename T>
//                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)


// #define DECLARE_SYN(NAME, ORIGINAL)
// template <typename OpName>
// struct __registratorSynonymFloat_##NAME {
//     __registratorSynonymFloat_##NAME(const char *name, const char *oname) {
//         auto ptr = reinterpret_cast<OpName *>(OpRegistrator::getInstance()->getOperationFloat(oname));
//         if (ptr == nullptr) {
//             std::string newName(name);
//             std::string oldName(oname);
//             OpRegistrator::getInstance()->updateMSVC(nd4j::ops::HashHelper::getInstance()->getLongHash(newName), oldName);
//             return;
//         }
//         OpRegistrator::getInstance()->registerOperationFloat(name, ptr);
//     }
// };
// template <typename OpName>
// struct __registratorSynonymHalf_##NAME {
//     __registratorSynonymHalf_##NAME(const char *name, const char *oname) {
//         auto ptr = reinterpret_cast<OpName *>(OpRegistrator::getInstance()->getOperationHalf(oname));
//         if (ptr == nullptr) {
//             std::string newName(name);
//             std::string oldName(oname);
//             OpRegistrator::getInstance()->updateMSVC(nd4j::ops::HashHelper::getInstance()->getLongHash(newName), oldName);
//             return;
//         }
//         OpRegistrator::getInstance()->registerOperationHalf(name, ptr);
//     }
// };
// template <typename OpName>
// struct __registratorSynonymDouble_##NAME {
//     __registratorSynonymDouble_##NAME(const char *name, const char *oname) {
//         auto ptr = reinterpret_cast<OpName *>(OpRegistrator::getInstance()->getOperationDouble(oname));
//         if (ptr == nullptr) {
//             std::string newName(name);
//             std::string oldName(oname);
//             OpRegistrator::getInstance()->updateMSVC(nd4j::ops::HashHelper::getInstance()->getLongHash(newName), oldName);
//             return;
//         }
//         OpRegistrator::getInstance()->registerOperationDouble(name, ptr);
//     }
// };
//                                         static nd4j::ops::__registratorSynonymFloat_##NAME<ORIGINAL<float>> zzz_register_opf_##NAME(#NAME, #ORIGINAL);
//                                         static nd4j::ops::__registratorSynonymHalf_##NAME<ORIGINAL<float16>> zzz_register_oph_##NAME(#NAME, #ORIGINAL);
//                                         static nd4j::ops::__registratorSynonymDouble_##NAME<ORIGINAL<double>> zzz_register_opd_##NAME(#NAME, #ORIGINAL)

// #define DECLARE_DIVERGENT_OP(NAME, NIN, NOUT, INPLACEABLE)  template <typename T>
//                                                             class NAME: public nd4j::ops::DeclarableOp<T> {
//                                                             public:
//                                                                 NAME();
//                                                                 nd4j::ShapeList* calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block);
//                                                             protected:
//                                                                 Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                                             };
//                                                             REGISTER_H(NAME)

// #define DIVERGENT_OP_IMPL(NAME, NIN, NOUT, INPLACEABLE)     template <typename T>
//                                                             NAME<T>::NAME() : nd4j::ops::DeclarableOp<T>(NIN, NOUT, #NAME, INPLACEABLE, true) { };
//                                                             template class ND4J_EXPORT NAME<float>;
//                                                             template class ND4J_EXPORT NAME<float16>;
//                                                             template class ND4J_EXPORT NAME<double>;
//                                                             REGISTER_C(NAME)
//                                                             template <typename T>
//                                                             nd4j::ShapeList* nd4j::ops::NAME<T>::calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block) {
//                                                                 auto shapeList = SHAPELIST();
//                                                                 for (int e = 0; e < this->getOpDescriptor()->getNumberOfOutputs(); e++) {
//                                                                     Nd4jLong* newshape;
//                                                                     COPY_SHAPE(inputShape->at(0), newshape);
//                                                                     shapeList->push_back(newshape);
//                                                                 }
//                                                                 return shapeList;
//                                                             }
//                                                             template <typename T>
//                                                             Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)

// #define DECLARE_CONFIGURABLE_OP(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)     template <typename T>
//                                                                                 class NAME: public nd4j::ops::DeclarableOp<T> {
//                                                                                 public:
//                                                                                     NAME();
//                                                                                     nd4j::ShapeList* calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block);
//                                                                                 protected:
//                                                                                     Nd4jStatus validateAndExecute(nd4j::graph::Context<T>& block);
//                                                                                 };
//                                                                                 REGISTER_H(NAME)

// #define CONFIGURABLE_OP_IMPL(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)        template <typename T>
//                                                                                 NAME<T>::NAME() : nd4j::ops::DeclarableOp<T>(NIN, NOUT, #NAME, INPLACEABLE, TARGS, IARGS) { };
//                                                                                 template class ND4J_EXPORT NAME<float>;
//                                                                                 template class ND4J_EXPORT NAME<float16>;
//                                                                                 template class ND4J_EXPORT NAME<double>;
//                                                                                 REGISTER_C(NAME)
//                                                                                 template <typename T>
//                                                                                 nd4j::ShapeList* nd4j::ops::NAME<T>::calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block) {
//                                                                                     auto shapeList = SHAPELIST();
//                                                                                     for (int e = 0; e < this->getOpDescriptor()->getNumberOfOutputs(); e++) {
//                                                                                         Nd4jLong* newshape;
//                                                                                         ALLOCATE(newshape, block.getWorkspace(), shape::shapeInfoLength(inputShape->at(e)), Nd4jLong);
//                                                                                         if (shape::order(inputShape->at(e)) == 'c')
//                                                                                             shape::shapeBuffer(shape::rank(inputShape->at(e)), shape::shapeOf(inputShape->at(e)), newshape);
//                                                                                         else
//                                                                                             shape::shapeBufferFortran(shape::rank(inputShape->at(e)), shape::shapeOf(inputShape->at(e)), newshape);
//                                                                                         shapeList->push_back(newshape);
//                                                                                     }
//                                                                                     return shapeList;
//                                                                                 }
//                                                                                 template <typename T>
//                                                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(Context<T>& block)

// #define DECLARE_REDUCTION_OP(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)        template <typename T>
//                                                                                 class NAME: public nd4j::ops::DeclarableReductionOp<T> {
//                                                                                 public:
//                                                                                     NAME();
//                                                                                 protected:
//                                                                                     Nd4jStatus validateAndExecute(Context<T>& block);
//                                                                                 };
//                                                                                 REGISTER_H(NAME)

// #define REDUCTION_OP_IMPL(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)           template <typename T>
//                                                                                 NAME<T>::NAME() : nd4j::ops::DeclarableReductionOp<T>(NIN, NOUT, #NAME, INPLACEABLE, TARGS, IARGS) { };
//                                                                                 template class ND4J_EXPORT NAME<float>;
//                                                                                 template class ND4J_EXPORT NAME<float16>;
//                                                                                 template class ND4J_EXPORT NAME<double>;
//                                                                                 REGISTER_C(NAME)
//                                                                                 template <typename T>
//                                                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)


// #define DECLARE_CUSTOM_OP(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)           template <typename T>
//                                                                                 class NAME: public nd4j::ops::DeclarableCustomOp<T> {
//                                                                                 protected:
//                                                                                     Nd4jStatus validateAndExecute(Context<T>& block);
//                                                                                 public:
//                                                                                     NAME();
//                                                                                     nd4j::ShapeList* calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block);
//                                                                                 };
//                                                                                 REGISTER_H(NAME)

// #define CUSTOM_OP_IMPL(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)              template <typename T>
//                                                                                 NAME<T>::NAME(): nd4j::ops::DeclarableCustomOp<T>(NIN, NOUT, #NAME, INPLACEABLE, TARGS, IARGS) { };
//                                                                                 template class ND4J_EXPORT NAME<float>;
//                                                                                 template class ND4J_EXPORT NAME<float16>;
//                                                                                 template class ND4J_EXPORT NAME<double>;
//                                                                                 REGISTER_C(NAME)
//                                                                                 template <typename T>
//                                                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)

// this declaration MUST follow DECLARE_CUSTOM_OP
// #define DECLARE_SHAPE_FN(NAME)                                                  template<typename T>
//                                                                                 nd4j::ShapeList* nd4j::ops::NAME<T>::calculateOutputShape(nd4j::ShapeList* inputShape, nd4j::graph::Context<T>& block)

// #define DECLARE_BROADCASTABLE_OP(NAME,TARGS, IARGS)                             template <typename T>
//                                                                                 class NAME: public nd4j::ops::BroadcastableOp<T> {
//                                                                                 protected:
//                                                                                     Nd4jStatus validateAndExecute(Context<T>& block);
//                                                                                 public:
//                                                                                     NAME();
//                                                                                 };
//                                                                                 REGISTER_H(NAME)

// #define BROADCASTABLE_OP_IMPL(NAME, TARGS, IARGS)                               template <typename T>
//                                                                                 NAME<T>::NAME(): nd4j::ops::BroadcastableOp<T>(#NAME, TARGS, IARGS) { };
//                                                                                 template class ND4J_EXPORT NAME<float>;
//                                                                                 template class ND4J_EXPORT NAME<float16>;
//                                                                                 template class ND4J_EXPORT NAME<double>;
//                                                                                 REGISTER_C(NAME)
//                                                                                 template <typename T>
//                                                                                 Nd4jStatus nd4j::ops::NAME<T>::validateAndExecute(nd4j::graph::Context<T>& block)


// #define DECLARE_DEVICE_OP(NAME, NIN, NOUT, INPLACEABLE, TARGS, IARGS)

// #define REPLICATE_SHAPE(SRC, TGT)   if (shape::order(SRC) == 'c')
//                                         shape::shapeBuffer(shape::rank(SRC), shape::shapeOf(SRC), TGT);
//                                     else
//                                         shape::shapeBufferFortran(shape::rank(SRC), shape::shapeOf(SRC), TGT);



// #define ALLOCATE(VARIABLE, WORKSPACE, LENGTH, TT)   if (WORKSPACE == nullptr) {VARIABLE = new TT[LENGTH]; } else {VARIABLE = reinterpret_cast<TT*>(WORKSPACE->allocateBytes(LENGTH * sizeof(TT))); }
// #define RELEASE(VARIABLE, WORKSPACE)    if (WORKSPACE == nullptr) delete[] VARIABLE;


// #define STORE_RESULT(A)     this->storeResult(block, 0, A)
// #define OVERWRITE_RESULT(A)     this->overwriteResult(block, 0, A)
// #define OVERWRITE_2_RESULTS(A, B)     this->overwriteResult(block, 0, A); this->overwriteResult(block, 1, B)
// #define STORE_2_RESULTS(A, B)   this->storeResult(block, 0, A); this->storeResult(block, 1, B)
// #define STORE_3_RESULTS(A, B, C)    this->storeResult(block, 0, A); this->storeResult(block, 1, B); this->storeResult(block, 2, C)
// #define STORE_4_RESULTS(A, B, C, D)     this->storeResult(block, 0, A); this->storeResult(block, 1, B); this->storeResult(block, 2, C); this->storeResult(block, 3, D)
// #define STORE_5_RESULTS(A, B, C, D, E)      this->storeResult(block, 0, A); this->storeResult(block, 1, B); this->storeResult(block, 2, C); this->storeResult(block, 3, D); this->storeResult(block, 4, E)

// #define STASH(NAME, ARRAY)  block.getStash()->storeArray(block.getNodeId(), NAME, ARRAY);
// #define CHECK_STASH(NAME)   block.getStash()->checkStash(block.getNodeId(), NAME);
// #define UNSTASH(NAME)       block.getStash()->extractArray(block.getNodeId(), NAME);

// #define INPUT_VARIABLE(INDEX)     reinterpret_cast<nd4j::NDArray<T> *>(block.getVariable(INDEX)->getNDArray())
// #define OUTPUT_VARIABLE(INDEX)    reinterpret_cast<nd4j::NDArray<T> *>(this->getZ(block, INDEX))

// #define INPUT_LIST(INDEX)     reinterpret_cast<nd4j::NDArrayList<T> *>(block.getVariable(INDEX)->getNDArrayList())

// #define INT_ARG(INDEX)     block.getIArguments()->at(INDEX)
// #define T_ARG(INDEX)     block.getTArguments()->at(INDEX)


// #define COPY_SHAPE(SRC, TGT)    ALLOCATE(TGT, block.getWorkspace(), shape::shapeInfoLength(SRC), Nd4jLong);
//                                 REPLICATE_SHAPE(SRC, TGT);

// #define COPY_SHAPE_EX(SRC, TGT, WORKSPACE)    ALLOCATE(TGT, WORKSPACE, shape::shapeInfoLength(SRC), Nd4jLong);
//                                 REPLICATE_SHAPE(SRC, TGT);

// define macros for compiler enforcement to make function inline  
// #ifdef __clang__
// #define FORCEINLINE inline 
// #elif _MSC_VER
// #define FORCEINLINE __forceinline
// #elif __GNUC__
// #define FORCEINLINE __attribute__((always_inline)) inline 
// #elif __CUDACC__ 
// #else
// #define FORCEINLINE inline 
// #endif


// #ifdef __CUDACC__

// #else

// #define _CUDA_H
// #define _CUDA_D
// #define _CUDA_G
// #define _CUDA_HD

// #endif // CUDACC

// #define CHECK_ALLOC(PTR, MSG) if (PTR == nullptr) { nd4j_printf("%s\n", MSG); throw std::bad_alloc(); };

// #define LAMBDA_H(X, ...) [__VA_ARGS__] (float16 X) -> float16
// #define LAMBDA_HH(X, Y, ...) [__VA_ARGS__] (float16 X, float16 Y) -> float16

// #define ILAMBDA_D(X, ...) [__VA_ARGS__] (Nd4jLong _idx, double X) -> double
// #define ILAMBDA_DD(X, Y, ...) [__VA_ARGS__] (Nd4jLong _idx, double X, double Y) -> double

// #define LAMBDA_D(X, ...) [__VA_ARGS__] (double X) -> double
// #define LAMBDA_DD(X, Y, ...) [__VA_ARGS__] (double X, double Y) -> double
// #define LAMBDA_DDD(t, u, v, ...) [__VA_ARGS__] (double t, double u, double v) -> double

// #define ILAMBDA_F(X, ...) [__VA_ARGS__] (Nd4jLong _idx, float X) -> float
// #define ILAMBDA_FF(X, Y, ...) [__VA_ARGS__] (Nd4jLong _idx, float X, float Y) -> float

// #define LAMBDA_F(X, ...) [__VA_ARGS__] (float X) -> float
// #define LAMBDA_FF(X, Y, ...) [__VA_ARGS__] (float X, float Y) -> float
// #define LAMBDA_FFF(t, u, v, ...) [__VA_ARGS__] (float t, float u, float v) -> float

// #define LAMBDA_T(X, ...) [__VA_ARGS__] (T X) -> T
// #define LAMBDA_TT(X, Y, ...) [__VA_ARGS__] (T X, T Y) -> T
// #define LAMBDA_TTT(t, u, v, ...) [__VA_ARGS__] (T t, T u, T v) -> T

// #define ILAMBDA_T(X, ...) [__VA_ARGS__] (Nd4jLong _idx, T X) -> T
// #define ILAMBDA_TT(X, Y, ...) [__VA_ARGS__] (Nd4jLong _idx, T X, T Y) -> T

// #endif


// Parsed from ops/InputType.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_INPUTTYPE_H
// #define ND4J_INPUTTYPE_H
        /** enum nd4j::ops::InputType */
        public static final int
            InputType_BOOLEAN = 0,
            InputType_NUMERIC = 1,
            InputType_STRINGULAR = 2,
            InputType_NUMERIC_SET = 3,
            InputType_STRINGULAR_SET = 4;
    


// #endif

// Parsed from ops/declarable/OpDescriptor.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_OPDESCRIPTOR_H
// #define LIBND4J_OPDESCRIPTOR_H

// #include <string>
// #include <helpers/helper_hash.h>
// #include <ops/InputType.h>
// #include <graph/generated/node_generated.h>

        /**
        *   This class is very basic info holder for ops. bean/pojo pretty much.
        *
        */
        @Namespace("nd4j::ops") @NoOffset public static class OpDescriptor extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public OpDescriptor(Pointer p) { super(p); }
        
            // default constructor
            public OpDescriptor(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace); }
            private native void allocate(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace);
            public OpDescriptor(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace); }
            private native void allocate(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace);

            // constructor for boolean ops
            public OpDescriptor(int numInputs, @StdString BytePointer opName, @Cast("bool") boolean isScalar) { super((Pointer)null); allocate(numInputs, opName, isScalar); }
            private native void allocate(int numInputs, @StdString BytePointer opName, @Cast("bool") boolean isScalar);
            public OpDescriptor(int numInputs, @StdString String opName, @Cast("bool") boolean isScalar) { super((Pointer)null); allocate(numInputs, opName, isScalar); }
            private native void allocate(int numInputs, @StdString String opName, @Cast("bool") boolean isScalar);

            // default constructor

            // constructor for configurable op
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs);
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs);

            // constructor for non-configurable divergent op
            public OpDescriptor(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent); }
            private native void allocate(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent);
            public OpDescriptor(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent); }
            private native void allocate(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent);

            // constructor for non-configurable divergent op

            // constructor for configurable divergent op
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs);
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs);

            // constructor for logical ops (while, scope, etc)
            public OpDescriptor(@Cast("char*") String opName, @Cast("bool") boolean isLogic) { super((Pointer)null); allocate(opName, isLogic); }
            private native void allocate(@Cast("char*") String opName, @Cast("bool") boolean isLogic);
            public OpDescriptor(@Cast("char*") BytePointer opName, @Cast("bool") boolean isLogic) { super((Pointer)null); allocate(opName, isLogic); }
            private native void allocate(@Cast("char*") BytePointer opName, @Cast("bool") boolean isLogic);

            public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef OpDescriptor other);

            // default destructor

            // this method returns minimal expected number of T arguments
            public native int getNumberOfTArgs();

            // this method returns minimal expected number of Integer arguments
            public native int getNumberOfIArgs();

            // this method returns minimal expected number of inputs
            public native int getNumberOfInputs();

            // this method returns hash code for this operation
            public native @Cast("Nd4jLong") long getHash();

            // this method returns minimal expected number of outputs
            public native int getNumberOfOutputs();

            // this method returns opName (can be empty)
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            // returns TRUE if this op is divergent. FALSE otherwise
            public native @Cast("bool") boolean isDivergent();

            // returns TRUE if this op allows in-place execution
            public native @Cast("bool") boolean allowsInplace();

            // this method returns opNum (applicable for legacy XYZ ops only)
            public native int getOpNum();

            // this method allows to set specifc opNum
            public native void setOpNum(int opNum);

            public native void setHash(@Cast("Nd4jLong") long hash);

            public native void setInputType(@Cast("nd4j::ops::InputType") int type);
            public native @Cast("nd4j::ops::InputType") int inputType();
        }
    


// #endif //LIBND4J_OPDESCRIPTOR_H


// Parsed from ops/declarable/BroadcastableOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver on 6/6/2018.
//

// #ifndef LIBND4J_BROADCASTABLEOP_H
// #define LIBND4J_BROADCASTABLEOP_H

// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include "DeclarableOp.h"
// #include "DeclarableCustomOp.h"
        @Name("nd4j::ops::BroadcastableOp<float>") public static class FloatBroadcastableOp extends FloatDeclarableCustomOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatBroadcastableOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::BroadcastableOp<float16>") public static class HalfBroadcastableOp extends HalfDeclarableCustomOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfBroadcastableOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef HalfContext block);
        }
        @Name("nd4j::ops::BroadcastableOp<double>") public static class DoubleBroadcastableOp extends DoubleDeclarableCustomOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleBroadcastableOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef DoubleContext block);
        }
    



// #endif //LIBND4J_BROADCASTABLEOP_H


// Parsed from ops/declarable/DeclarableOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_DECLARABLE_OPS_H
// #define LIBND4J_DECLARABLE_OPS_H

// #include <sstream>
// #include <types/float16.h>
// #include <pointercast.h>
// #include <NDArray.h>
// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include <helpers/helper_hash.h>
// #include <array/ShapeList.h>
// #include <array/ResultSet.h>
// #include <helpers/OpArgsHolder.h>
// #include <dll.h>
//#include <ops/declarable/declarable_ops.h>

// #include <chrono>
// #include <ctime>

        @Namespace("nd4j::ops") public static native @Cast("Nd4jStatus") int conditionHelper(@Cast("char*") String file, int line, int condition, int argNumber, @Cast("char*") String format);
        @Namespace("nd4j::ops") public static native @Cast("Nd4jStatus") int conditionHelper(@Cast("char*") BytePointer file, int line, int condition, int argNumber, @Cast("char*") BytePointer format);

        /**
         * This class is the basic building block of Graph Operations. Any CustomOp out there is built on top of this "abstract" class.
         *
         */
        @Name("nd4j::ops::DeclarableOp<float>") @NoOffset public static class FloatDeclarableOp extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatDeclarableOp(Pointer p) { super(p); }
        
            // for special cases, like BooleanOps

            // regular constructors

            // for LogicalOps

            // default testructor

            // this method returns OpDescriptor, describing this Op instance
            public native OpDescriptor getOpDescriptor();

            /**
            *   This method should be available in each implemented Op, and should return Op output shape(s), for a given input shape(s)
            */
            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);

            /**
             * Returns opName
             *
             * @return
             */
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            /**
             * Returns opHash
             */
            public native @Cast("Nd4jLong") long getOpHash();

            /**
             * This method sets arguments for op
             */
//            void setArguments();

            /**
             * This method returns pointer to results
             */
//            void getResults();

            /**
             * This method executes given Op
             *
             * @param block
             * @return 0 if OK, error code otherwise
             */
            public native @Cast("Nd4jStatus") int execute(FloatContext block);

            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native FloatResultSet execute(@Const @ByRef FloatNDArrayVector inputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector FloatBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef FloatNDArrayVector inputs, @ByRef FloatNDArrayVector outputs, @StdVector float[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);

            public native FloatResultSet execute(@Const @ByRef FloatOpArgsHolder holder, @Cast("bool") boolean isInplace/*=false*/);
            public native FloatResultSet execute(@Const @ByRef FloatOpArgsHolder holder);

            // There methods provide various validation options
            public native @Cast("Nd4jStatus") int validateNonEmptyInput(@ByRef FloatContext block);

            // this method checks if all input arrays have equal lengths
            public native @Cast("Nd4jStatus") int validateInputLengthMatch(@ByRef FloatContext block);

            // this method checks if all input arrays have the same shapes (orders/strides are NOT checked)
            public native @Cast("Nd4jStatus") int validateInputDimensionsMatch(@ByRef FloatContext block);

            // this method check if all input arrays have the same orders
            public native @Cast("Nd4jStatus") int validateOrdersMatch(@ByRef FloatContext block);

            // this method checks if all input arrays are 2D
            public native @Cast("Nd4jStatus") int validateInput2D(@ByRef FloatContext block);

            // this method checks if all input arrays are 3D
            public native @Cast("Nd4jStatus") int validateInput3D(@ByRef FloatContext block);

            // this method checks if all input arrays are 4D
            public native @Cast("Nd4jStatus") int validateInput4D(@ByRef FloatContext block);

            // this method checks if all input arrays are ND
            public native @Cast("Nd4jStatus") int validateInputDimensions(@ByRef FloatContext block, int rank);

            // this method checks if number of available arguments matches op expectations
            public native @Cast("Nd4jStatus") int validateArguments(@ByRef FloatContext block);
        }
        @Name("nd4j::ops::DeclarableOp<float16>") @NoOffset public static class HalfDeclarableOp extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfDeclarableOp(Pointer p) { super(p); }
        
            // for special cases, like BooleanOps

            // regular constructors

            // for LogicalOps

            // default testructor

            // this method returns OpDescriptor, describing this Op instance
            public native OpDescriptor getOpDescriptor();

            /**
            *   This method should be available in each implemented Op, and should return Op output shape(s), for a given input shape(s)
            */
            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef HalfContext block);

            /**
             * Returns opName
             *
             * @return
             */
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            /**
             * Returns opHash
             */
            public native @Cast("Nd4jLong") long getOpHash();

            /**
             * This method sets arguments for op
             */
//            void setArguments();

            /**
             * This method returns pointer to results
             */
//            void getResults();

            /**
             * This method executes given Op
             *
             * @param block
             * @return 0 if OK, error code otherwise
             */
            public native @Cast("Nd4jStatus") int execute(HalfContext block);

            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native HalfResultSet execute(@Const @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortPointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef HalfNDArrayVector inputs, @ByRef HalfNDArrayVector outputs, @Cast("float16*") @StdVector short[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);

            public native HalfResultSet execute(@Const @ByRef HalfOpArgsHolder holder, @Cast("bool") boolean isInplace/*=false*/);
            public native HalfResultSet execute(@Const @ByRef HalfOpArgsHolder holder);

            // There methods provide various validation options
            public native @Cast("Nd4jStatus") int validateNonEmptyInput(@ByRef HalfContext block);

            // this method checks if all input arrays have equal lengths
            public native @Cast("Nd4jStatus") int validateInputLengthMatch(@ByRef HalfContext block);

            // this method checks if all input arrays have the same shapes (orders/strides are NOT checked)
            public native @Cast("Nd4jStatus") int validateInputDimensionsMatch(@ByRef HalfContext block);

            // this method check if all input arrays have the same orders
            public native @Cast("Nd4jStatus") int validateOrdersMatch(@ByRef HalfContext block);

            // this method checks if all input arrays are 2D
            public native @Cast("Nd4jStatus") int validateInput2D(@ByRef HalfContext block);

            // this method checks if all input arrays are 3D
            public native @Cast("Nd4jStatus") int validateInput3D(@ByRef HalfContext block);

            // this method checks if all input arrays are 4D
            public native @Cast("Nd4jStatus") int validateInput4D(@ByRef HalfContext block);

            // this method checks if all input arrays are ND
            public native @Cast("Nd4jStatus") int validateInputDimensions(@ByRef HalfContext block, int rank);

            // this method checks if number of available arguments matches op expectations
            public native @Cast("Nd4jStatus") int validateArguments(@ByRef HalfContext block);
        }
        @Name("nd4j::ops::DeclarableOp<double>") @NoOffset public static class DoubleDeclarableOp extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleDeclarableOp(Pointer p) { super(p); }
        
            // for special cases, like BooleanOps

            // regular constructors

            // for LogicalOps

            // default testructor

            // this method returns OpDescriptor, describing this Op instance
            public native OpDescriptor getOpDescriptor();

            /**
            *   This method should be available in each implemented Op, and should return Op output shape(s), for a given input shape(s)
            */
            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef DoubleContext block);

            /**
             * Returns opName
             *
             * @return
             */
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            /**
             * Returns opHash
             */
            public native @Cast("Nd4jLong") long getOpHash();

            /**
             * This method sets arguments for op
             */
//            void setArguments();

            /**
             * This method returns pointer to results
             */
//            void getResults();

            /**
             * This method executes given Op
             *
             * @param block
             * @return 0 if OK, error code otherwise
             */
            public native @Cast("Nd4jStatus") int execute(DoubleContext block);

            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native DoubleResultSet execute(@Const @ByRef DoubleNDArrayVector inputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(RandomBuffer rng, @ByRef DoubleNDArrayVector inputs, @ByRef DoubleNDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);

            public native DoubleResultSet execute(@Const @ByRef DoubleOpArgsHolder holder, @Cast("bool") boolean isInplace/*=false*/);
            public native DoubleResultSet execute(@Const @ByRef DoubleOpArgsHolder holder);

            // There methods provide various validation options
            public native @Cast("Nd4jStatus") int validateNonEmptyInput(@ByRef DoubleContext block);

            // this method checks if all input arrays have equal lengths
            public native @Cast("Nd4jStatus") int validateInputLengthMatch(@ByRef DoubleContext block);

            // this method checks if all input arrays have the same shapes (orders/strides are NOT checked)
            public native @Cast("Nd4jStatus") int validateInputDimensionsMatch(@ByRef DoubleContext block);

            // this method check if all input arrays have the same orders
            public native @Cast("Nd4jStatus") int validateOrdersMatch(@ByRef DoubleContext block);

            // this method checks if all input arrays are 2D
            public native @Cast("Nd4jStatus") int validateInput2D(@ByRef DoubleContext block);

            // this method checks if all input arrays are 3D
            public native @Cast("Nd4jStatus") int validateInput3D(@ByRef DoubleContext block);

            // this method checks if all input arrays are 4D
            public native @Cast("Nd4jStatus") int validateInput4D(@ByRef DoubleContext block);

            // this method checks if all input arrays are ND
            public native @Cast("Nd4jStatus") int validateInputDimensions(@ByRef DoubleContext block, int rank);

            // this method checks if number of available arguments matches op expectations
            public native @Cast("Nd4jStatus") int validateArguments(@ByRef DoubleContext block);
        }
    


// #endif //LIBND4J_DECLARABLE_OPS_H


// Parsed from ops/declarable/DeclarableListOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef LIBND4J_DECLARABLE_LIST_OP_H
// #define LIBND4J_DECLARABLE_LIST_OP_H

// #include <array/ResultSet.h>
// #include <graph/Context.h>
// #include <ops/declarable/OpRegistrator.h>
// #include <ops/declarable/DeclarableOp.h>
        @Name("nd4j::ops::DeclarableListOp<float>") public static class FloatDeclarableListOp extends FloatDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatDeclarableListOp(Pointer p) { super(p); }
        

            
            public native @Cast("Nd4jStatus") int execute(FloatContext block);
            public native FloatResultSet execute(FloatNDArrayList list, @ByRef FloatNDArrayVector inputs, @StdVector FloatPointer tArgs, @StdVector IntPointer iArgs);
            public native FloatResultSet execute(FloatNDArrayList list, @ByRef FloatNDArrayVector inputs, @StdVector FloatBuffer tArgs, @StdVector IntBuffer iArgs);
            public native FloatResultSet execute(FloatNDArrayList list, @ByRef FloatNDArrayVector inputs, @StdVector float[] tArgs, @StdVector int[] iArgs);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::DeclarableListOp<float16>") public static class HalfDeclarableListOp extends HalfDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfDeclarableListOp(Pointer p) { super(p); }
        

            
            public native @Cast("Nd4jStatus") int execute(HalfContext block);
            public native HalfResultSet execute(HalfNDArrayList list, @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortPointer tArgs, @StdVector IntPointer iArgs);
            public native HalfResultSet execute(HalfNDArrayList list, @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector ShortBuffer tArgs, @StdVector IntBuffer iArgs);
            public native HalfResultSet execute(HalfNDArrayList list, @ByRef HalfNDArrayVector inputs, @Cast("float16*") @StdVector short[] tArgs, @StdVector int[] iArgs);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef HalfContext block);
        }
        @Name("nd4j::ops::DeclarableListOp<double>") public static class DoubleDeclarableListOp extends DoubleDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleDeclarableListOp(Pointer p) { super(p); }
        

            
            public native @Cast("Nd4jStatus") int execute(DoubleContext block);
            public native DoubleResultSet execute(DoubleNDArrayList list, @ByRef DoubleNDArrayVector inputs, @StdVector DoublePointer tArgs, @StdVector IntPointer iArgs);
            public native DoubleResultSet execute(DoubleNDArrayList list, @ByRef DoubleNDArrayVector inputs, @StdVector DoubleBuffer tArgs, @StdVector IntBuffer iArgs);
            public native DoubleResultSet execute(DoubleNDArrayList list, @ByRef DoubleNDArrayVector inputs, @StdVector double[] tArgs, @StdVector int[] iArgs);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef DoubleContext block);
        }
    


// #endif

// Parsed from ops/declarable/DeclarableReductionOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_DECLARABLE_REDUCTION_OP_H
// #define LIBND4J_DECLARABLE_REDUCTION_OP_H

// #include <ops/declarable/DeclarableOp.h>
        @Name("nd4j::ops::DeclarableReductionOp<float>") public static class FloatDeclarableReductionOp extends FloatDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatDeclarableReductionOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::DeclarableReductionOp<float16>") public static class HalfDeclarableReductionOp extends HalfDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfDeclarableReductionOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef HalfContext block);
        }
        @Name("nd4j::ops::DeclarableReductionOp<double>") public static class DoubleDeclarableReductionOp extends DoubleDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleDeclarableReductionOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef DoubleContext block);
        }
    


// #endif //LIBND4J_DECLARABLE_REDUCTION_OP_H


// Parsed from ops/declarable/DeclarableCustomOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_DECLARABLECUSTOMOP_H
// #define LIBND4J_DECLARABLECUSTOMOP_H

// #include <ops/declarable/DeclarableOp.h>
        @Name("nd4j::ops::DeclarableCustomOp<float>") public static class FloatDeclarableCustomOp extends FloatDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatDeclarableCustomOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShapes, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::DeclarableCustomOp<float16>") public static class HalfDeclarableCustomOp extends HalfDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfDeclarableCustomOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShapes, @ByRef HalfContext block);
        }
        @Name("nd4j::ops::DeclarableCustomOp<double>") public static class DoubleDeclarableCustomOp extends DoubleDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleDeclarableCustomOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShapes, @ByRef DoubleContext block);
        }
    


// #endif //LIBND4J_DECLARABLECUSTOMOP_H


// Parsed from ops/declarable/BooleanOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 13.10.2017.
//

// #ifndef LIBND4J_BOOLEANOP_H
// #define LIBND4J_BOOLEANOP_H

// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include "DeclarableOp.h"
        @Name("nd4j::ops::BooleanOp<float>") @NoOffset public static class FloatBooleanOp extends FloatDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatBooleanOp(Pointer p) { super(p); }
        
            public native @Cast("bool") boolean evaluate(@ByRef FloatNDArrayVector args);
            public native @Cast("bool") boolean evaluate(@ByRef FloatContext block);

            public native @Cast("Nd4jStatus") int execute(FloatContext block);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::BooleanOp<float16>") @NoOffset public static class HalfBooleanOp extends HalfDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfBooleanOp(Pointer p) { super(p); }
        
            public native @Cast("bool") boolean evaluate(@ByRef HalfNDArrayVector args);
            public native @Cast("bool") boolean evaluate(@ByRef HalfContext block);

            public native @Cast("Nd4jStatus") int execute(HalfContext block);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef HalfContext block);
        }
        @Name("nd4j::ops::BooleanOp<double>") @NoOffset public static class DoubleBooleanOp extends DoubleDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DoubleBooleanOp(Pointer p) { super(p); }
        
            public native @Cast("bool") boolean evaluate(@ByRef DoubleNDArrayVector args);
            public native @Cast("bool") boolean evaluate(@ByRef DoubleContext block);

            public native @Cast("Nd4jStatus") int execute(DoubleContext block);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef DoubleContext block);
        }
    




// #endif //LIBND4J_BOOLEANOP_H

// Parsed from ops/declarable/LogicOp.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 15.10.2017.
//

// #ifndef LIBND4J_LOGICOP_H
// #define LIBND4J_LOGICOP_H

// #include "DeclarableOp.h"

        /**
         * Logic ops are unique snowflakes in any Graph. They dramatically change Graph Execution process, by introducing loops, conditions, etc.
         *
         * Their code is the part of GraphExecutioner logic. But we still want them to be expressed via Graph
         * \tparam T
         */
        @Name("nd4j::ops::LogicOp<float>") public static class FloatLogicOp extends FloatDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FloatLogicOp(Pointer p) { super(p); }
        
            public FloatLogicOp(@Cast("char*") String name) { super((Pointer)null); allocate(name); }
            private native void allocate(@Cast("char*") String name);
            public FloatLogicOp(@Cast("char*") BytePointer name) { super((Pointer)null); allocate(name); }
            private native void allocate(@Cast("char*") BytePointer name);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef FloatContext block);
        }
        @Name("nd4j::ops::LogicOp<float16>") public static class HalfLogicOp extends HalfDeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public HalfLogicOp(Pointer p) { super(p); }
        
            public HalfLogicOp(@Cast("char*") String name) { super((Pointer)null); allocate(name); }
            private native void allocate(@Cast("char*") String name);
            public HalfLogicOp(@Cast("char*") BytePointer name) { super((Pointer)null); allocate(name); }
    