/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.workspace;

import lombok.NonNull;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.LocationPolicy;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.memory.pointers.PointersPair;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.abstracts.Nd4jWorkspace;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuWorkspace
extends Nd4jWorkspace {
    private static final Logger log = LoggerFactory.getLogger(CpuWorkspace.class);
    protected LongPointer mmap;

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
    }

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String workspaceId) {
        super(configuration, workspaceId);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        if (workspaceId == null) {
            throw new NullPointerException("workspaceId is marked @NonNull but is null");
        }
    }

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String workspaceId, Integer deviceId) {
        super(configuration, workspaceId);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        if (workspaceId == null) {
            throw new NullPointerException("workspaceId is marked @NonNull but is null");
        }
        this.deviceId = deviceId;
    }

    protected void init() {
        super.init();
        if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.RAM) {
            if (this.currentSize.get() > 0L) {
                this.isInit.set(true);
                if (this.isDebug.get()) {
                    log.info("Allocating [{}] workspace of {} bytes...", (Object)this.id, (Object)this.currentSize.get());
                }
                this.workspace.setHostPointer(new PagedPointer(this.memoryManager.allocate(this.currentSize.get() + 1024L, MemoryKind.HOST, true)));
            }
        } else if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.MMAP) {
            long flen = this.tempFile.length();
            this.mmap = NativeOpsHolder.getInstance().getDeviceNativeOps().mmapFile(null, this.tempFile.getAbsolutePath(), flen);
            if (this.mmap == null) {
                throw new RuntimeException("MMAP failed");
            }
            this.workspace.setHostPointer(new PagedPointer(this.mmap.get(0L)));
        }
    }

    protected void clearPinnedAllocations(boolean extended) {
        if (this.isDebug.get()) {
            log.info("Workspace [{}] device_{} threadId {} cycle {}: clearing pinned allocations...", new Object[]{this.id, Nd4j.getAffinityManager().getDeviceForCurrentThread(), Thread.currentThread().getId(), this.cyclesCount.get()});
        }
        while (!this.pinnedAllocations.isEmpty()) {
            PointersPair pair = (PointersPair)this.pinnedAllocations.peek();
            if (pair == null) {
                throw new RuntimeException();
            }
            long stepNumber = pair.getAllocationCycle();
            long stepCurrent = this.stepsCount.get();
            if (this.isDebug.get()) {
                log.info("Allocation step: {}; Current step: {}", (Object)stepNumber, (Object)stepCurrent);
            }
            if (stepNumber + 2L >= stepCurrent && !extended) break;
            this.pinnedAllocations.remove();
            NativeOpsHolder.getInstance().getDeviceNativeOps().freeHost((Pointer)pair.getHostPointer());
            this.pinnedCount.decrementAndGet();
            this.pinnedAllocationsSize.addAndGet(pair.getRequiredMemory() * -1L);
        }
    }

    protected void clearExternalAllocations() {
        if (this.isDebug.get()) {
            log.info("Workspace [{}] device_{} threadId {} guid [{}]: clearing external allocations...", new Object[]{this.id, Nd4j.getAffinityManager().getDeviceForCurrentThread(), Thread.currentThread().getId(), this.guid});
        }
        NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        for (PointersPair pair : this.externalAllocations) {
            if (pair.getHostPointer() == null) continue;
            nativeOps.freeHost((Pointer)pair.getHostPointer());
        }
        this.externalAllocations.clear();
        this.externalCount.set(0);
        this.spilledAllocationsSize.set(0L);
    }

    public synchronized void destroyWorkspace(boolean extended) {
        if (this.isDebug.get()) {
            log.info("Destroying workspace...");
        }
        this.currentSize.set(0L);
        this.hostOffset.set(0L);
        this.deviceOffset.set(0L);
        if (extended) {
            this.clearExternalAllocations();
        }
        this.clearPinnedAllocations(extended);
        if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.RAM) {
            if (this.workspace.getHostPointer() != null) {
                NativeOpsHolder.getInstance().getDeviceNativeOps().freeHost((Pointer)this.workspace.getHostPointer());
            }
        } else if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.MMAP && this.workspace.getHostPointer() != null) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().munmapFile(null, this.mmap, this.tempFile.length());
        }
        this.workspace.setDevicePointer(null);
        this.workspace.setHostPointer(null);
    }

    protected void resetWorkspace() {
    }
}

