/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.GradientOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.ShapeOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpStatus;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.cpu.nativecpu.CpuTADManager;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jCpu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpExecutioner
extends DefaultOpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(NativeOpExecutioner.class);
    private NativeOps loop = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private ConstantHandler constantHandler = Nd4j.getConstantHandler();
    private CpuTADManager tadManager = new CpuTADManager();
    private static final String DEBUG_ENABLED = "ND4J_DEBUG";
    private static final String VERBOSE = "ND4J_VERBOSE";
    private ThreadLocal<Map<Integer, PointerPointer>> inputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> inputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputShapes = new ThreadLocal();
    private ThreadLocal<Map<Integer, PointerPointer>> outputBuffers = new ThreadLocal();
    private ThreadLocal<Map<Integer, DoublePointer>> tArgsPointer = new ThreadLocal();
    private ThreadLocal<Map<Integer, ShortPointer>> halfArgsPointer = new ThreadLocal();
    protected Map<String, CustomOpDescriptor> customOps = null;
    protected ThreadLocal<PointerPointer> extraz = new ThreadLocal();
    private ThreadLocal<Map<Integer, Pointer>> batchPointers = new ThreadLocal();
    private ThreadLocal<Map<Integer, AggregateMemoryBlock>> memoryBlocks = new ThreadLocal();

    public NativeOpExecutioner() {
        boolean var;
        this.tadManager.init(this.loop, this.constantHandler);
        if (System.getenv(DEBUG_ENABLED) != null) {
            try {
                var = Boolean.parseBoolean(System.getenv(DEBUG_ENABLED));
                this.loop.enableDebugMode(var);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)DEBUG_ENABLED, (Object)System.getenv(DEBUG_ENABLED));
            }
        }
        if (System.getenv(VERBOSE) != null) {
            try {
                var = Boolean.parseBoolean(System.getenv(VERBOSE));
                this.loop.enableVerboseMode(var);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)VERBOSE, (Object)System.getenv(VERBOSE));
            }
        }
    }

    public Op exec(Op op) {
        this.checkForCompression(op);
        if (op instanceof ScalarOp) {
            ScalarOp s = (ScalarOp)op;
            this.exec(s);
        } else if (op instanceof GradientOp) {
            op.exec();
        } else if (op instanceof TransformOp) {
            TransformOp t = (TransformOp)op;
            this.exec(t);
        } else if (op instanceof Accumulation) {
            Accumulation ac = (Accumulation)op;
            this.exec(ac);
        } else if (op instanceof IndexAccumulation) {
            IndexAccumulation iac = (IndexAccumulation)op;
            this.exec(iac);
        } else if (op instanceof BroadcastOp) {
            BroadcastOp broadcastOp = (BroadcastOp)op;
            this.exec(broadcastOp, broadcastOp.getDimension());
        } else if (op instanceof ShapeOp) {
            ShapeOp shapeOp = (ShapeOp)op;
            this.exec(shapeOp);
        } else if (op instanceof RandomOp) {
            RandomOp rngOp = (RandomOp)op;
            this.exec(rngOp, Nd4j.getRandom());
        }
        return op;
    }

    public INDArray exec(IndexAccumulation op, int ... dimension) {
        int[] retShape;
        int[] nArray;
        if (dimension == null || dimension.length == 0) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        this.checkForCompression((Op)op);
        NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])dimension);
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + op.x().rank();
        }
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if (Shape.wholeArrayDimension((int[])dimension)) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = retShape = ArrayUtil.removeIndex((int[])op.x().shape(), (int[])dimension);
        }
        if (retShape.length == 1) {
            retShape = dimension[0] == 0 ? new int[]{1, retShape[0]} : new int[]{retShape[0], 1};
        } else if (retShape.length == 0) {
            retShape = new int[]{1, 1};
        }
        if (op.z() == null || op.x() == op.z()) {
            INDArray ret = op.x().data().dataType() == DataBuffer.Type.DOUBLE ? Nd4j.valueArrayOf((int[])retShape, (double)op.zeroDouble()) : Nd4j.valueArrayOf((int[])retShape, (double)op.zeroFloat());
            op.setZ(ret);
        } else if (!Arrays.equals(retShape, op.z().shape())) {
            throw new IllegalStateException("Z array shape does not match expected return type for op " + op + ": expected shape " + Arrays.toString(retShape) + ", z.shape()=" + Arrays.toString(op.z().shape()));
        }
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets});
        long st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        Pointer x = op.x().data().addressPointer();
        Pointer z = op.z().data().addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.z().isScalar()) {
                int res = (int)this.loop.execIndexReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                op.setFinalResult(res);
                op.z().putScalar(0, (float)res);
            } else {
                this.loop.execIndexReduceDouble(dummy, op.opNum(), (DoublePointer)x, (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)z, (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (op.z().isScalar()) {
            int res = (int)this.loop.execIndexReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            op.setFinalResult(res);
            op.z().putScalar(0, (float)res);
        } else {
            this.loop.execIndexReduceFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        this.profilingHookOut((Op)op, st);
        return op.z();
    }

    public INDArray exec(Accumulation op, int ... dimension) {
        INDArray ret;
        int yT;
        int xT;
        int[] retShape;
        int i;
        dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])dimension);
        NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        int[] maxShape = Shape.getMaxShape((INDArray[])new INDArray[]{op.x(), op.y()});
        for (i = 0; i < dimension.length; ++i) {
            if (dimension[i] < maxShape.length || dimension[i] == Integer.MAX_VALUE) continue;
            throw new ND4JIllegalStateException("Op target dimension " + Arrays.toString(dimension) + " contains element that higher then rank of op.X: [" + op.x().rank() + "]");
        }
        for (i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + op.x().rank();
        }
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if ((retShape = Shape.wholeArrayDimension((int[])dimension) ? new int[]{1, 1} : ArrayUtil.removeIndex((int[])maxShape, (int[])dimension)).length == 1) {
            retShape = dimension[0] == 0 ? new int[]{1, retShape[0]} : new int[]{retShape[0], 1};
        } else if (retShape.length == 0) {
            retShape = new int[]{1, 1};
        }
        if (op.x().isVector() && op.x().length() == ArrayUtil.prod((int[])retShape) && ArrayUtil.prodLong((int[])retShape) > 1L && op.y() == null) {
            return op.noOp();
        }
        if (op.z() == null || op.z() == op.x()) {
            if (op.isComplexAccumulation()) {
                xT = op.x().tensorssAlongDimension(dimension);
                yT = op.y().tensorssAlongDimension(dimension);
                ret = Nd4j.create((int)xT, (int)yT);
            } else {
                if (op.y() != null) {
                    if (op.x().lengthLong() == op.y().lengthLong()) {
                        if (op.x().tensorssAlongDimension(dimension) != op.y().tensorssAlongDimension(dimension)) {
                            throw new ND4JIllegalStateException("Number of TADs along dimension don't match: (x shape = " + Arrays.toString(op.x().shape()) + ", y shape = " + Arrays.toString(op.y().shape()) + ", dimension = " + Arrays.toString(dimension) + ")");
                        }
                    } else {
                        long xTADSize = op.x().lengthLong() / (long)op.x().tensorssAlongDimension(dimension);
                        if (xTADSize != (long)op.y().length()) {
                            throw new ND4JIllegalStateException("Size of TADs along dimension don't match for pairwise execution: (x TAD size = " + xTADSize + ", y size = " + op.y().lengthLong());
                        }
                    }
                }
                ret = op.x().data().dataType() == DataBuffer.Type.DOUBLE ? Nd4j.valueArrayOf((int[])retShape, (double)op.zeroDouble()) : Nd4j.valueArrayOf((int[])retShape, (double)op.zeroFloat());
            }
            op.setZ(ret);
        } else {
            if (!op.isComplexAccumulation() && op.z().lengthLong() != ArrayUtil.prodLong((int[])retShape)) {
                throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(op.z().shape()) + "] doesn't match expected [" + Arrays.toString(retShape) + "]");
            }
            if (op.isComplexAccumulation()) {
                xT = op.x().tensorssAlongDimension(dimension);
                yT = op.y().tensorssAlongDimension(dimension);
                if (op.z().lengthLong() != (long)(xT * yT)) {
                    throw new ND4JIllegalStateException("Shape of target array for reduction [" + Arrays.toString(op.z().shape()) + "] doesn't match expected [" + xT * yT + "]");
                }
            }
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                op.z().assign((Number)op.zeroDouble());
            } else {
                op.z().assign((Number)Float.valueOf(op.zeroFloat()));
            }
            ret = op.z();
        }
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pair<DataBuffer, DataBuffer> yTadBuffers = null;
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        boolean tvf = false;
        if (op.y() != null && op.x().tensorAlongDimension(0, dimension).lengthLong() == op.y().lengthLong()) {
            tvf = true;
        }
        if (op.isComplexAccumulation()) {
            yTadBuffers = this.tadManager.getTADOnlyShapeInfo(op.y(), dimension);
            if (op.x().tensorAlongDimension(0, dimension).lengthLong() != op.y().tensorAlongDimension(0, dimension).lengthLong()) {
                throw new ND4JIllegalStateException("Impossible to issue AllDistances operation: TAD lengths mismatch along given dimension");
            }
        }
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets, tvf ? hostTadOffsets : null});
        long st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op instanceof Variance) {
                if (ret.isScalar()) {
                    ret.putScalar(0, this.loop.execSummaryStatsScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), true));
                } else {
                    Variance var = (Variance)op;
                    this.loop.execSummaryStatsDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, var.isBiasCorrected());
                }
            } else if (op.y() != null && op.getOpType() == Op.Type.REDUCE3) {
                if (op.isComplexAccumulation()) {
                    this.loop.execReduce3AllDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, (IntPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), (IntPointer)((DataBuffer)yTadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)yTadBuffers.getSecond()).addressPointer()));
                } else if (ret.isScalar()) {
                    ret.putScalar(0, this.loop.execReduce3ScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
                } else {
                    this.loop.execReduce3Double(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
                }
            } else if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
            } else {
                this.loop.execReduceDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (op instanceof Variance) {
            Variance variance = (Variance)op;
            if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execSummaryStatsScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), variance.isBiasCorrected()));
            } else {
                this.loop.execSummaryStatsFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, variance.isBiasCorrected());
            }
        } else if (op.y() != null && op.getOpType() == Op.Type.REDUCE3) {
            if (op.isComplexAccumulation()) {
                this.loop.execReduce3AllFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, (IntPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), (IntPointer)((DataBuffer)yTadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)yTadBuffers.getSecond()).addressPointer()));
            } else if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execReduce3ScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
            } else {
                this.loop.execReduce3Float(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (ret.isScalar()) {
            ret.putScalar(0, this.loop.execReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op)));
        } else {
            this.loop.execReduceFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        return ret;
    }

    private void invoke(ScalarOp op, int[] dimension) {
        dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])dimension);
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        if (op.x().data().dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (IntPointer)Nd4j.getConstantHandler().getConstantBuffer(dimension).addressPointer(), dimension.length);
        } else if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (IntPointer)Nd4j.getConstantHandler().getConstantBuffer(dimension).addressPointer(), dimension.length);
        }
    }

    private void exec(ScalarOp op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else {
            long st = this.profilingHookIn((Op)op);
            NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
            if (op.x().lengthLong() != op.z().lengthLong()) {
                throw new ND4JIllegalStateException("op.X length should be equal to op.Z length: [" + Arrays.toString(op.x().shapeInfoDataBuffer().asInt()) + "] != [" + Arrays.toString(op.z().shapeInfoDataBuffer().asInt()) + "]");
            }
            if (op.getDimension() != null) {
                this.invoke(op, op.getDimension());
                return;
            }
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.z().elementWiseStride() >= 1 && !op.isExecSpecial()) {
                    this.loop.execScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (DoublePointer)op.z().data().addressPointer(), op.z().elementWiseStride(), op.scalar().doubleValue(), (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
                } else {
                    this.loop.execScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), op.scalar().doubleValue(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                }
            } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.z().elementWiseStride() >= 1 && !op.isExecSpecial()) {
                this.loop.execScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (FloatPointer)op.z().data().addressPointer(), op.z().elementWiseStride(), op.scalar().floatValue(), (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), op.scalar().floatValue(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            }
            this.profilingHookOut((Op)op, st);
        }
    }

    private Pointer getPointerForExtraArgs(Op op) {
        if (op.extraArgs() != null) {
            return op.extraArgsDataBuff().addressPointer();
        }
        return null;
    }

    private void exec(TransformOp op) {
        long st = 0L;
        NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get();
        if (op.opNum() == 7 && op.y() != null && op.y().isScalar()) {
            op.setY(Nd4j.valueArrayOf((int[])op.x().shape(), (double)op.y().getDouble(0)));
        }
        if (op.opNum() == 41 && op.extraArgs() != null) {
            int[] dimension = new int[((Integer)op.extraArgs()[0]).intValue()];
            for (int i = 0; i < dimension.length; ++i) {
                dimension[i] = (Integer)op.extraArgs()[i + 1];
            }
            Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
            Pointer tad = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            Pointer off = offsets == null ? null : offsets.addressPointer();
            dummy.put(0L, tad);
            dummy.put(1L, off);
            st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        } else {
            st = this.profilingHookIn((Op)op);
        }
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.y() != null) {
                int xEWS = op.x().elementWiseStride();
                int yEWS = op.y().elementWiseStride();
                int zEWS = op.z().elementWiseStride();
                boolean xRow = op.x().isRowVector();
                boolean yRow = op.y().isRowVector();
                boolean zRow = op.z().isRowVector();
                if (xEWS >= 1 && yEWS >= 1 && xEWS == yEWS && !op.isExecSpecial() && op.x().ordering() == op.y().ordering() && op.x().ordering() == op.z().ordering() || xEWS >= 1 && yEWS == xEWS && zEWS == xEWS && xRow && yRow && zRow) {
                    this.loop.execPairwiseTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), xEWS, (DoublePointer)op.y().data().addressPointer(), yEWS, (DoublePointer)op.z().data().addressPointer(), zEWS, (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
                } else {
                    this.loop.execPairwiseTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                }
            } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && !op.isExecSpecial() && op.x().ordering() == op.z().ordering()) {
                this.loop.execTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (DoublePointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
            }
        } else if (op.y() != null) {
            int xEWS = op.x().elementWiseStride();
            int yEWS = op.y().elementWiseStride();
            int zEWS = op.z().elementWiseStride();
            boolean xRow = op.x().isRowVector();
            boolean yRow = op.y().isRowVector();
            boolean zRow = op.z().isRowVector();
            if (xEWS >= 1 && yEWS >= 1 && xEWS == yEWS && !op.isExecSpecial() && op.x().ordering() == op.y().ordering() && op.x().ordering() == op.z().ordering() || xEWS >= 1 && yEWS == xEWS && zEWS == xEWS && xRow && yRow && zRow) {
                this.loop.execPairwiseTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), xEWS, (FloatPointer)op.y().data().addressPointer(), yEWS, (FloatPointer)op.z().data().addressPointer(), zEWS, (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execPairwiseTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            }
        } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.x().ordering() == op.z().ordering()) {
            this.loop.execTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (FloatPointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
        } else {
            this.loop.execTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
        }
        this.profilingHookOut((Op)op, st);
    }

    public INDArray exec(BroadcastOp op, int ... dimension) {
        long st = this.profilingHookIn((Op)op);
        if (dimension == null) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        dimension = Shape.normalizeAxis((int)op.x().rank(), (int[])dimension);
        NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] < op.x().rank() || dimension[i] == Integer.MAX_VALUE) continue;
            throw new ND4JIllegalStateException("Op target dimension " + Arrays.toString(dimension) + " contains element that higher then rank of op.X: [" + op.x().rank() + "]");
        }
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        if (this.extraz.get() == null) {
            this.extraz.set(new PointerPointer(32L));
        }
        PointerPointer dummy = this.extraz.get().put(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execBroadcastDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        } else {
            this.loop.execBroadcastFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        return op.z();
    }

    private void exec(IndexAccumulation op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else {
            if (op.z() == op.x() || op.z() == null) {
                op.setZ(Nd4j.scalar((double)0.0));
            }
            long st = this.profilingHookIn((Op)op);
            NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                op.setFinalResult((int)this.loop.execIndexReduceScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
            } else {
                op.setFinalResult((int)this.loop.execIndexReduceScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op)));
            }
            op.z().assign((Number)op.getFinalResult());
            this.profilingHookOut((Op)op, st);
        }
    }

    private void exec(Accumulation op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else if (op.isExecSpecial()) {
            op.exec();
        } else {
            long st = this.profilingHookIn((Op)op);
            NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
            if (op.z() == op.x()) {
                op.setZ(Nd4j.scalar((double)0.0));
            }
            if (op.y() != null && op.getOpType() == Op.Type.REDUCE3 && op.x().lengthLong() != op.y().lengthLong()) {
                throw new ND4JIllegalStateException("X and Y operands should have equall lengths. X length: " + op.x().lengthLong() + "; Y length: " + op.y().lengthLong());
            }
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                if (op instanceof Variance) {
                    op.setFinalResult(this.loop.execSummaryStatsScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), true));
                    op.z().putScalar(0, op.getFinalResult().doubleValue());
                } else if (op.y() != null && op.getOpType() == Op.Type.REDUCE3) {
                    op.setFinalResult(this.loop.execReduce3ScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
                    op.z().putScalar(0, op.getFinalResult().doubleValue());
                } else {
                    op.setFinalResult(this.loop.execReduceScalarDouble(null, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
                    op.z().putScalar(0, op.getFinalResult().doubleValue());
                }
            } else if (op instanceof Variance) {
                Variance variance = (Variance)op;
                op.setFinalResult((double)this.loop.execSummaryStatsScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), variance.isBiasCorrected()));
                op.z().putScalar(0, op.getFinalResult().floatValue());
            } else if (op.y() != null && op.getOpType() == Op.Type.REDUCE3) {
                op.setFinalResult((double)this.loop.execReduce3ScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
                op.z().putScalar(0, op.getFinalResult().floatValue());
            } else {
                op.setFinalResult((double)this.loop.execReduceScalarFloat(null, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op)));
                op.z().putScalar(0, op.getFinalResult().floatValue());
            }
            this.profilingHookOut((Op)op, st);
        }
    }

    protected <T extends Aggregate> Pointer getPointer(Batch<T> batch) {
        if (this.batchPointers.get() == null) {
            this.batchPointers.set(new HashMap());
        }
        if (!this.batchPointers.get().containsKey(batch.opNum())) {
            IntPointer pointer = new IntPointer(batch.getSample().getRequiredBatchMemorySize() / 4L);
            this.batchPointers.get().put(batch.opNum(), (Pointer)pointer);
            return pointer;
        }
        return this.batchPointers.get().get(batch.opNum());
    }

    public <T extends Aggregate> void exec(Batch<T> batch) {
        IntPointer pointer = (IntPointer)this.getPointer(batch);
        int maxTypes = 5;
        int maxIntArrays = batch.getSample().maxIntArrays();
        int maxArraySize = batch.getSample().maxIntArraySize();
        int indexPos = maxTypes * Batch.getBatchLimit();
        int intArraysPos = indexPos + batch.getSample().maxIndexArguments() * Batch.getBatchLimit();
        int realPos = (intArraysPos + maxIntArrays * maxArraySize * Batch.getBatchLimit()) / (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? 2 : 1);
        int argsPos = (realPos + batch.getSample().maxRealArguments() * Batch.getBatchLimit()) / (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? 1 : 2);
        int shapesPos = argsPos + batch.getSample().maxArguments() * Batch.getBatchLimit();
        for (int i = 0; i < batch.getNumAggregates(); ++i) {
            int e;
            Aggregate op = (Aggregate)batch.getAggregates().get(i);
            int idx = i * maxTypes;
            pointer.put((long)idx, op.getArguments().size());
            pointer.put((long)(idx + 1), op.getShapes().size());
            pointer.put((long)(idx + 2), op.getIndexingArguments().size());
            pointer.put((long)(idx + 3), op.getRealArguments().size());
            pointer.put((long)(idx + 4), op.getIntArrayArguments().size());
            for (int e2 = 0; e2 < op.getIndexingArguments().size(); ++e2) {
                idx = indexPos + i * batch.getSample().maxIndexArguments();
                pointer.put((long)(idx + e2), ((Integer)op.getIndexingArguments().get(e2)).intValue());
            }
            int bsize = maxIntArrays * maxArraySize;
            for (int e3 = 0; e3 < op.getIntArrayArguments().size(); ++e3) {
                int step = i * bsize + e3 * maxArraySize;
                if (op.getIntArrayArguments().get(e3) == null) continue;
                for (int x = 0; x < ((int[])op.getIntArrayArguments().get(e3)).length; ++x) {
                    idx = intArraysPos + step + x;
                    pointer.put((long)idx, ((int[])op.getIntArrayArguments().get(e3))[x]);
                }
            }
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                FloatPointer fPtr = new FloatPointer((Pointer)pointer);
                for (e = 0; e < op.getRealArguments().size(); ++e) {
                    idx = realPos + i * op.maxRealArguments();
                    fPtr.put((long)(idx + e), ((Number)op.getRealArguments().get(e)).floatValue());
                }
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                DoublePointer dPtr = new DoublePointer((Pointer)pointer);
                for (e = 0; e < op.getRealArguments().size(); ++e) {
                    idx = realPos + i * op.maxRealArguments();
                    dPtr.put((long)(idx + e), ((Number)op.getRealArguments().get(e)).doubleValue());
                }
            }
            if (this.extraz.get() == null) {
                this.extraz.set(new PointerPointer(32L));
            }
            PointerPointer ptrPtr = new PointerPointer((Pointer)pointer);
            for (e = 0; e < op.getArguments().size(); ++e) {
                idx = argsPos + i * batch.getSample().maxArguments();
                if (op.getArguments().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((INDArray)op.getArguments().get(e)).data().addressPointer());
            }
            for (e = 0; e < op.getShapes().size(); ++e) {
                idx = shapesPos + i * batch.getSample().maxShapes();
                if (op.getShapes().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((DataBuffer)op.getShapes().get(e)).addressPointer());
            }
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execAggregateBatchFloat(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execAggregateBatchDouble(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer);
        } else {
            throw new UnsupportedOperationException("Half precision isn't supported on CPU");
        }
    }

    public void exec(List<Aggregate> batch) {
        if (batch.size() == 0) {
            return;
        }
        List batches = Batch.getBatches(batch);
        for (Batch single : batches) {
            this.exec(single);
        }
    }

    public void exec(Aggregate op) {
        int x;
        if (this.memoryBlocks.get() == null) {
            this.memoryBlocks.set(new HashMap());
        }
        if (this.memoryBlocks.get().get(op.opNum()) == null) {
            this.memoryBlocks.get().put(op.opNum(), new AggregateMemoryBlock(op));
        }
        AggregateMemoryBlock block = this.memoryBlocks.get().get(op.opNum());
        int numArguments = op.getArguments().size();
        int numIndexArguments = op.getIndexingArguments().size();
        int numRealArguments = op.getRealArguments().size();
        int numShapes = op.getShapes().size();
        int numIntArrays = op.getIntArrayArguments().size();
        PointerPointer arguments = block.getArgumentsPointer();
        ArrayList<IntPointer> pointers = new ArrayList<IntPointer>();
        PointerPointer intArrays = block.getArraysPointer();
        for (int x2 = 0; x2 < numArguments; ++x2) {
            arguments.put((long)x2, op.getArguments().get(x2) == null ? null : ((INDArray)op.getArguments().get(x2)).data().addressPointer());
        }
        PointerPointer shapes = block.getShapesPointer();
        for (int x3 = 0; x3 < numShapes; ++x3) {
            if (((DataBuffer)op.getShapes().get(x3)).dataType() != DataBuffer.Type.INT) {
                throw new RuntimeException("ShapeBuffers should have INT data opType");
            }
            shapes.put((long)x3, op.getShapes().get(x3) == null ? null : ((DataBuffer)op.getShapes().get(x3)).addressPointer());
        }
        IntPointer pointer = block.getIndexingPointer();
        for (int x4 = 0; x4 < numIndexArguments; ++x4) {
            pointer.put((long)x4, ((Integer)op.getIndexingArguments().get(x4)).intValue());
        }
        double[] reals = new double[numRealArguments];
        for (x = 0; x < numRealArguments; ++x) {
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                ((FloatPointer)block.getRealArgumentsPointer()).put((long)x, ((Number)op.getRealArguments().get(x)).floatValue());
                continue;
            }
            ((DoublePointer)block.getRealArgumentsPointer()).put((long)x, ((Number)op.getRealArguments().get(x)).doubleValue());
        }
        for (x = 0; x < numIntArrays; ++x) {
            IntPointer intPtr = block.getIntArrays().get(x);
            intPtr.put((int[])op.getIntArrayArguments().get(x), 0, ((int[])op.getIntArrayArguments().get(x)).length);
            intArrays.put((long)x, (Pointer)intPtr);
            pointers.add(intPtr);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execAggregateFloat(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, (FloatPointer)block.getRealArgumentsPointer(), numRealArguments);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execAggregateDouble(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, (DoublePointer)block.getRealArgumentsPointer(), numRealArguments);
        } else {
            throw new UnsupportedOperationException("Half precision isn't supported on CPU");
        }
    }

    public Properties getEnvironmentInformation() {
        Properties properties = super.getEnvironmentInformation();
        properties.put("backend", "CPU");
        properties.put("omp.threads", (Object)this.loop.ompGetMaxThreads());
        properties.put("blas.threads", (Object)Nd4j.factory().blas().getMaxThreads());
        properties.put("blas.vendor", Nd4j.factory().blas().getBlasVendor().toString());
        properties.put("memory.free", (Object)(Pointer.maxBytes() - Pointer.totalBytes()));
        return properties;
    }

    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    public INDArray exec(RandomOp op, Random rng) {
        if (rng.getStateBuffer() == null) {
            throw new IllegalStateException("You should use one of NativeRandom classes for NativeOperations execution");
        }
        long st = this.profilingHookIn((Op)op);
        NativeOpExecutioner.validateDataType((DataBuffer.Type)Nd4j.dataType(), (Op)op);
        if (op.x() != null && op.y() != null && op.z() != null) {
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
            }
        } else if (op.x() != null && op.z() != null) {
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
            }
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
        }
        this.profilingHookOut((Op)op, st);
        return op.z();
    }

    public TADManager getTADManager() {
        return this.tadManager;
    }

    public INDArray thresholdEncode(INDArray input, double threshold) {
        return this.thresholdEncode(input, threshold, null);
    }

    public INDArray thresholdEncode(INDArray input, double threshold, Integer boundary) {
        MatchCondition condition = new MatchCondition(input, Conditions.absGreaterThanOrEqual((Number)threshold));
        int cntAbs = Nd4j.getExecutioner().exec((Accumulation)condition, new int[]{Integer.MAX_VALUE}).getInt(new int[]{0});
        if (cntAbs < 2) {
            return null;
        }
        if (boundary != null) {
            cntAbs = Math.min(cntAbs, boundary);
        }
        DataBuffer buffer = input.data();
        long originalLength = buffer.length() * (long)Nd4j.sizeOfDataType((DataBuffer.Type)buffer.dataType());
        int compressedLength = cntAbs + 4;
        DataBuffer encodedBuffer = Nd4j.getMemoryManager().getCurrentWorkspace() == null ? Nd4j.getDataBufferFactory().createInt((long)(4 + cntAbs), false) : Nd4j.getDataBufferFactory().createInt((long)(4 + cntAbs), false, Nd4j.getMemoryManager().getCurrentWorkspace());
        encodedBuffer.put(0L, cntAbs);
        encodedBuffer.put(1L, (int)buffer.length());
        encodedBuffer.put(2L, Float.floatToIntBits((float)threshold));
        encodedBuffer.put(3L, 0);
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.setCompressedLength((long)(compressedLength * 4));
        descriptor.setOriginalLength(originalLength);
        descriptor.setOriginalElementSize((long)Nd4j.sizeOfDataType((DataBuffer.Type)buffer.dataType()));
        descriptor.setNumberOfElements(buffer.length());
        descriptor.setCompressionAlgorithm("THRESHOLD");
        descriptor.setCompressionType(CompressionType.LOSSLESS);
        Nd4j.getNDArrayFactory().convertDataEx(AbstractCompressor.getBufferTypeEx((DataBuffer)buffer), buffer.addressPointer(), DataBuffer.TypeEx.THRESHOLD, encodedBuffer.addressPointer(), buffer.length());
        Nd4j.getAffinityManager().tagLocation(buffer, AffinityManager.Location.HOST);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)encodedBuffer, (DataBuffer)input.shapeInfoDataBuffer());
    }

    public INDArray thresholdDecode(INDArray encoded, INDArray target) {
        DataBuffer buffer = encoded.data();
        if (buffer.dataType() != DataBuffer.Type.INT) {
            throw new ND4JIllegalStateException("thresholdEncoded array should have dataType of INT");
        }
        long compressedLength = buffer.getInt(0L);
        long originalLength = buffer.getInt(1L);
        float threshold = buffer.getInt(2L);
        if (target.lengthLong() != originalLength) {
            throw new ND4JIllegalStateException("originalLength [" + originalLength + "] stored in encoded array doesn't match target length [" + target.lengthLong() + "]");
        }
        DataBuffer.TypeEx typeDst = AbstractCompressor.getBufferTypeEx((DataBuffer)target.data());
        this.loop.convertTypes(null, DataBuffer.TypeEx.THRESHOLD.ordinal(), buffer.addressPointer(), (long)target.length(), typeDst.ordinal(), target.data().addressPointer());
        return target;
    }

    public long bitmapEncode(INDArray indArray, INDArray target, double threshold) {
        long length = indArray.lengthLong();
        long tLen = target.data().length();
        if (tLen != length / 16L + 5L) {
            throw new ND4JIllegalStateException("Length of target array should be " + (length / 16L + 5L));
        }
        if (target.data().dataType() != DataBuffer.Type.INT) {
            throw new ND4JIllegalStateException("Target array should have INT dataType");
        }
        DataBuffer buffer = target.data();
        buffer.put(0L, (int)length);
        buffer.put(1L, (int)length);
        buffer.put(2L, Float.floatToIntBits((float)threshold));
        buffer.put(3L, 1);
        long affected = 0L;
        if (indArray.data().dataType() == DataBuffer.Type.FLOAT) {
            affected = this.loop.encodeBitmapFloat(null, (FloatPointer)indArray.data().addressPointer(), length, (IntPointer)buffer.addressPointer(), (float)threshold);
        } else if (indArray.data().dataType() == DataBuffer.Type.DOUBLE) {
            affected = this.loop.encodeBitmapDouble(null, (DoublePointer)indArray.data().addressPointer(), length, (IntPointer)buffer.addressPointer(), (float)threshold);
        } else {
            throw new UnsupportedOperationException("HALF precision isn't supported on CPU yet");
        }
        return affected;
    }

    public INDArray bitmapDecode(INDArray encoded, INDArray target) {
        if (target.data().dataType() == DataBuffer.Type.FLOAT) {
            this.loop.decodeBitmapFloat(null, encoded.data().addressPointer(), (long)target.length(), (FloatPointer)target.data().addressPointer());
        }
        return target;
    }

    public synchronized Map<String, CustomOpDescriptor> getCustomOperations() {
        if (this.customOps == null) {
            String[] split;
            String list = this.loop.getAllCustomOps();
            if (list == null || list.isEmpty()) {
                log.warn("No customs ops available!");
                this.customOps = Collections.emptyMap();
                return this.customOps;
            }
            HashMap<String, CustomOpDescriptor> map = new HashMap<String, CustomOpDescriptor>();
            for (String op : split = list.split(";")) {
                if (op == null || op.isEmpty()) continue;
                String[] another = op.split(":");
                CustomOpDescriptor descriptor = CustomOpDescriptor.builder().hash(Long.valueOf(another[1]).longValue()).numInputs(Integer.valueOf(another[2]).intValue()).numOutputs(Integer.valueOf(another[3]).intValue()).allowsInplace(Integer.valueOf(another[4]) == 1).numTArgs(Integer.valueOf(another[5]).intValue()).numIArgs(Integer.valueOf(another[6]).intValue()).build();
                map.put(another[0], descriptor);
            }
            this.customOps = Collections.unmodifiableMap(map);
        }
        return this.customOps;
    }

    private PointerPointer getPointerPointerFrom(ThreadLocal<Map<Integer, PointerPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, PointerPointer> store = new HashMap<Integer, PointerPointer>();
            store.put(numArguments, new PointerPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            PointerPointer pointerPointer = new PointerPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private ShortPointer getShortPointerFrom(ThreadLocal<Map<Integer, ShortPointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, ShortPointer> store = new HashMap<Integer, ShortPointer>();
            store.put(numArguments, new ShortPointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            ShortPointer pointerPointer = new ShortPointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private DoublePointer getDoublePointerFrom(ThreadLocal<Map<Integer, DoublePointer>> map, int numArguments) {
        if (map.get() == null) {
            HashMap<Integer, DoublePointer> store = new HashMap<Integer, DoublePointer>();
            store.put(numArguments, new DoublePointer((long)numArguments));
            map.set(store);
            return map.get().get(numArguments);
        }
        if (map.get().get(numArguments) == null) {
            DoublePointer pointerPointer = new DoublePointer((long)numArguments);
            map.get().put(numArguments, pointerPointer);
            return pointerPointer;
        }
        return map.get().get(numArguments);
    }

    private PointerPointer getInputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.inputShapes, numArguments);
    }

    private PointerPointer getInputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.inputBuffers, numArguments);
    }

    private PointerPointer getOutputShapes(int numArguments) {
        return this.getPointerPointerFrom(this.outputShapes, numArguments);
    }

    private PointerPointer getOutputBuffers(int numArguments) {
        return this.getPointerPointerFrom(this.outputBuffers, numArguments);
    }

    public void exec(@NonNull CustomOp op) {
        FloatPointer tArgs;
        int[] iArgs1;
        INDArray[] inputArgs;
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (op.numOutputArguments() == 0 && !op.isInplaceCall()) {
            throw new ND4JIllegalStateException("Op name " + op.opName() + " failed to execute. You can't execute non-inplace CustomOp without outputs being specified");
        }
        String name = op.opName().toLowerCase();
        long hash = op.opHash();
        PointerPointer inputShapes = this.getInputShapes(op.numInputArguments());
        PointerPointer inputBuffers = this.getInputBuffers(op.numInputArguments());
        int cnt = 0;
        for (INDArray iNDArray : inputArgs = op.inputArguments()) {
            if (iNDArray == null) {
                throw new NullPointerException("Input argument is null");
            }
            inputBuffers.put((long)cnt, iNDArray.data().addressPointer());
            inputShapes.put((long)cnt++, iNDArray.shapeInfoDataBuffer().addressPointer());
        }
        INDArray[] outputArgs = op.outputArguments();
        for (int i = 0; i < outputArgs.length; ++i) {
            if (outputArgs[i] != null) continue;
            throw new ND4JIllegalStateException("Op output arguments must not be null!");
        }
        PointerPointer outputShapes = this.getOutputShapes(op.numOutputArguments());
        PointerPointer outputBuffers = this.getOutputBuffers(op.numOutputArguments());
        cnt = 0;
        for (INDArray out : outputArgs) {
            outputBuffers.put((long)cnt, out.data().addressPointer());
            outputShapes.put((long)cnt++, out.shapeInfoDataBuffer().addressPointer());
        }
        IntPointer intPointer = op.numIArguments() > 0 ? new IntPointer((long)op.numIArguments()) : null;
        cnt = 0;
        for (int i : iArgs1 = op.iArgs()) {
            intPointer.put((long)cnt++, i);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            tArgs = op.numTArguments() > 0 ? new FloatPointer((long)op.numTArguments()) : null;
            double[] tArgs1 = op.tArgs();
            cnt = 0;
            for (double t : tArgs1) {
                tArgs.put((long)cnt++, (float)t);
            }
            OpStatus status = OpStatus.byNumber((int)this.loop.execCustomOpFloat(null, hash, inputBuffers, inputShapes, op.numInputArguments(), outputBuffers, outputShapes, op.numOutputArguments(), tArgs, op.numTArguments(), intPointer, op.numIArguments(), op.isInplaceCall()));
            if (status != OpStatus.ND4J_STATUS_OK) {
                throw new ND4JIllegalStateException("Op execution failed: " + status);
            }
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            tArgs = op.numTArguments() > 0 ? this.getDoublePointerFrom(this.tArgsPointer, op.numTArguments()) : null;
            double[] tArgs1 = op.tArgs();
            cnt = 0;
            for (double t : tArgs1) {
                tArgs.put((long)cnt++, t);
            }
            int t = op.numInputArguments();
            OpStatus status = OpStatus.ND4J_STATUS_OK;
            try {
                status = OpStatus.byNumber((int)this.loop.execCustomOpDouble(null, hash, inputBuffers, inputShapes, op.numInputArguments(), outputBuffers, outputShapes, op.numOutputArguments(), (DoublePointer)tArgs, op.numTArguments(), intPointer, op.numIArguments(), op.isInplaceCall()));
            }
            catch (Exception e) {
                log.error("Failed to execute. Please see above message (printed out from c++) for a possible cause of error.");
                throw e;
            }
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            double[] tArgs1;
            tArgs = op.numTArguments() > 0 ? this.getShortPointerFrom(this.halfArgsPointer, op.numTArguments()) : null;
            cnt = 0;
            for (double t : tArgs1 = op.tArgs()) {
                tArgs.put((long)cnt++, ArrayUtil.toHalf((double)t));
            }
            OpStatus status = OpStatus.byNumber((int)this.loop.execCustomOpHalf(null, hash, inputBuffers, inputShapes, op.numInputArguments(), outputBuffers, outputShapes, op.numOutputArguments(), (ShortPointer)tArgs, op.numTArguments(), intPointer, op.numIArguments(), op.isInplaceCall()));
            if (status != OpStatus.ND4J_STATUS_OK) {
                throw new ND4JIllegalStateException("Op execution failed: " + status);
            }
        }
    }

    protected int[] getShapeFromPointer(IntPointer ptr) {
        int rank = ptr.get(0L);
        int[] array = new int[rank];
        for (int i = 0; i < rank; ++i) {
            array[i] = ptr.get((long)(i + 1));
        }
        return array;
    }

    public List<int[]> calculateOutputShape(@NonNull CustomOp op) {
        int e;
        FloatPointer tArgs;
        int[] iArgs1;
        if (op == null) {
            throw new NullPointerException("op");
        }
        String lc = op.opName().toLowerCase();
        long hash = op.opHash();
        ArrayList<int[]> result = new ArrayList<int[]>();
        if (op.numInputArguments() < 1) {
            return Collections.emptyList();
        }
        PointerPointer inputBuffers = new PointerPointer((long)op.numInputArguments());
        PointerPointer inputShapes = new PointerPointer((long)op.numInputArguments());
        INDArray[] inputArgs = op.inputArguments();
        int cnt = 0;
        for (INDArray in : inputArgs) {
            inputBuffers.put((long)cnt, in.data().addressPointer());
            inputShapes.put((long)cnt++, in.shapeInfoDataBuffer().addressPointer());
        }
        IntPointer iArgs = op.numIArguments() > 0 ? new IntPointer((long)op.numIArguments()) : null;
        cnt = 0;
        for (int i : iArgs1 = op.iArgs()) {
            iArgs.put((long)cnt++, i);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            tArgs = op.numTArguments() > 0 ? new FloatPointer((long)op.numTArguments()) : null;
            double[] tArgs1 = op.tArgs();
            cnt = 0;
            for (double t : tArgs1) {
                tArgs.put((long)cnt++, (float)t);
            }
            Nd4jCpu.ShapeList ptrptr = (Nd4jCpu.ShapeList)this.loop.calculateOutputShapesFloat(null, hash, inputBuffers, inputShapes, op.numInputArguments(), tArgs, op.numTArguments(), iArgs, op.numIArguments());
            if (ptrptr == null) {
                throw new RuntimeException();
            }
            for (e = 0; e < ptrptr.size(); ++e) {
                result.add(this.getShapeFromPointer(new PagedPointer((Pointer)ptrptr.at(e)).asIntPointer()));
            }
            this.loop.deleteShapeList((Pointer)ptrptr);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            tArgs = op.numTArguments() > 0 ? new DoublePointer((long)op.numTArguments()) : null;
            cnt = 0;
            double[] tArgs1 = op.tArgs();
            for (double t : tArgs1) {
                tArgs.put((long)cnt++, t);
            }
            Object ptrptr = (Object)((Nd4jCpu.ShapeList)this.loop.calculateOutputShapesDouble(null, hash, inputBuffers, inputShapes, op.numInputArguments(), (DoublePointer)tArgs, op.numTArguments(), iArgs, op.numIArguments()));
            if (ptrptr == null) {
                throw new RuntimeException();
            }
            for (e = 0; e < ((Nd4jCpu.ShapeList)((Object)ptrptr)).size(); ++e) {
                result.add(this.getShapeFromPointer(new PagedPointer((Pointer)((Nd4jCpu.ShapeList)((Object)ptrptr)).at(e)).asIntPointer()));
            }
            this.loop.deleteShapeList((Pointer)ptrptr);
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            tArgs = op.numTArguments() > 0 ? new ShortPointer((long)op.numTArguments()) : null;
            cnt = 0;
            double[] tArgs1 = op.tArgs();
            for (double t : tArgs1) {
                tArgs.put((long)cnt++, ArrayUtil.toHalf((double)t));
            }
            Object ptrptr = (Object)((Nd4jCpu.ShapeList)this.loop.calculateOutputShapesHalf(null, hash, inputBuffers, inputShapes, op.numInputArguments(), (ShortPointer)tArgs, op.numTArguments(), iArgs, op.numIArguments()));
            if (ptrptr == null) {
                throw new RuntimeException();
            }
            int numOutputs = this.getCustomOperations().get(lc).getNumOutputs();
            for (int e2 = 0; e2 < ((Nd4jCpu.ShapeList)((Object)ptrptr)).size(); ++e2) {
                result.add(this.getShapeFromPointer(new PagedPointer((Pointer)((Nd4jCpu.ShapeList)((Object)ptrptr)).at(e2)).asIntPointer()));
            }
            this.loop.deleteShapeList((Pointer)ptrptr);
        }
        return result;
    }

    public void enableDebugMode(boolean reallyEnable) {
        this.loop.enableDebugMode(reallyEnable);
    }

    public void enableVerboseMode(boolean reallyEnable) {
        this.loop.enableVerboseMode(reallyEnable);
    }

    public void registerGraph(long id, Pointer graph) {
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.registerGraphFloat(null, id, graph);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.registerGraphDouble(null, id, graph);
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            this.loop.registerGraphHalf(null, id, graph);
        }
    }

    public Map<String, INDArray> executeGraph(long id, Map<String, INDArray> map) {
        OpStatus status;
        Pointer result;
        PointerPointer ptrBuffers = new PointerPointer((long)map.size());
        PointerPointer ptrShapes = new PointerPointer((long)map.size());
        IntPointer ptrIndices = new IntPointer((long)map.size());
        int cnt = 0;
        ArrayList<String> keySet = new ArrayList<String>(map.keySet());
        for (String key : keySet) {
            INDArray array = map.get(key);
            ptrBuffers.put((long)cnt, array.data().addressPointer());
            ptrShapes.put((long)cnt, array.shapeInfoDataBuffer().addressPointer());
            ptrIndices.put((long)cnt, cnt);
            ++cnt;
        }
        LinkedHashMap<String, INDArray> newMap = new LinkedHashMap<String, INDArray>();
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            result = (Nd4jCpu.FloatVariablesSet)this.loop.executeStoredGraphFloat(null, id, ptrBuffers, ptrShapes, ptrIndices, map.size());
            status = OpStatus.byNumber((int)result.status());
            if (status != OpStatus.ND4J_STATUS_OK) {
                throw new ND4JIllegalStateException("Op execution failed: " + status);
            }
            for (int e = 0; e < result.size(); ++e) {
                Nd4jCpu.FloatVariable var = result.at(e);
                int nodeId = var.id();
                int index = var.index();
                IntPointer shapeInfo = var.getNDArray().shapeInfo();
                FloatPointer buffer = var.getNDArray().buffer();
                int rank = shapeInfo.get(0L);
                int[] jshape = new int[rank * 2 + 4];
                for (int i = 0; i < jshape.length; ++i) {
                    jshape[i] = shapeInfo.get((long)i);
                }
                int[] shapeOf = Shape.shapeOf((int[])jshape);
                int[] stridesOf = Shape.stridesOf((int[])jshape);
                char order = Shape.order((int[])jshape);
                INDArray array = Nd4j.create((int[])shapeOf, (int[])stridesOf, (long)0L, (char)order);
                Pointer.memcpy((Pointer)array.data().addressPointer(), (Pointer)buffer, (long)(ArrayUtil.prod((int[])shapeOf) * Nd4j.sizeOfDataType()));
                newMap.put(keySet.get(nodeId), array);
            }
            this.loop.deleteVariablesSetFloat(result);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            result = (Nd4jCpu.DoubleVariablesSet)this.loop.executeStoredGraphDouble(null, id, ptrBuffers, ptrShapes, ptrIndices, map.size());
            status = OpStatus.byNumber((int)result.status());
            if (status != OpStatus.ND4J_STATUS_OK) {
                throw new ND4JIllegalStateException("Op execution failed: " + status);
            }
            for (int e = 0; e < result.size(); ++e) {
                Nd4jCpu.DoubleVariable var = result.at(e);
                int nodeId = var.id();
                int index = var.index();
                IntPointer shapeInfo = var.getNDArray().shapeInfo();
                DoublePointer buffer = var.getNDArray().buffer();
                int rank = shapeInfo.get(0L);
                int[] jshape = new int[rank * 2 + 4];
                for (int i = 0; i < jshape.length; ++i) {
                    jshape[i] = shapeInfo.get((long)i);
                }
                int[] shapeOf = Shape.shapeOf((int[])jshape);
                int[] stridesOf = Shape.stridesOf((int[])jshape);
                char order = Shape.order((int[])jshape);
                INDArray array = Nd4j.create((int[])shapeOf, (int[])stridesOf, (long)0L, (char)order);
                Pointer.memcpy((Pointer)array.data().addressPointer(), (Pointer)buffer, (long)(ArrayUtil.prod((int[])shapeOf) * Nd4j.sizeOfDataType()));
                newMap.put(keySet.get(nodeId), array);
            }
            this.loop.deleteVariablesSetDouble(result);
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            result = (Nd4jCpu.DoubleVariablesSet)this.loop.executeStoredGraphHalf(null, id, ptrBuffers, ptrShapes, ptrIndices, map.size());
            status = OpStatus.byNumber((int)result.status());
            if (status != OpStatus.ND4J_STATUS_OK) {
                throw new ND4JIllegalStateException("Op execution failed: " + status);
            }
            for (int e = 0; e < result.size(); ++e) {
                Nd4jCpu.DoubleVariable var = result.at(e);
                int nodeId = var.id();
                int index = var.index();
                IntPointer shapeInfo = var.getNDArray().shapeInfo();
                DoublePointer buffer = var.getNDArray().buffer();
                int rank = shapeInfo.get(0L);
                int[] jshape = new int[rank * 2 + 4];
                for (int i = 0; i < jshape.length; ++i) {
                    jshape[i] = shapeInfo.get((long)i);
                }
                int[] shapeOf = Shape.shapeOf((int[])jshape);
                int[] stridesOf = Shape.stridesOf((int[])jshape);
                char order = Shape.order((int[])jshape);
                INDArray array = Nd4j.create((int[])shapeOf, (int[])stridesOf, (long)0L, (char)order);
                Pointer.memcpy((Pointer)array.data().addressPointer(), (Pointer)buffer, (long)(ArrayUtil.prod((int[])shapeOf) * Nd4j.sizeOfDataType()));
                newMap.put(keySet.get(nodeId), array);
            }
            this.loop.deleteVariablesSetHalf(result);
        }
        return newMap;
    }

    public void forgetGraph(long id) {
        this.loop.unregisterGraph(null, id);
    }

    public void setElementsThreshold(int threshold) {
        this.loop.setElementThreshold(threshold);
    }

    public void setTadThreshold(int threshold) {
        this.loop.setTADThreshold(threshold);
    }

    private static class AggregateMemoryBlock {
        private List<IntPointer> intArrays = new ArrayList<IntPointer>();
        private IntPointer indexingPointer;
        private Pointer realArgumentsPointer;
        private PointerPointer shapesPointer;
        private PointerPointer argumentsPointer;
        private PointerPointer arraysPointer;
        private final int opNum;

        private AggregateMemoryBlock(@NonNull Aggregate op) {
            if (op == null) {
                throw new NullPointerException("op");
            }
            this.opNum = op.opNum();
            for (int i = 0; i < op.maxIntArrays(); ++i) {
                this.intArrays.add(new IntPointer((long)op.maxIntArraySize()));
            }
            this.indexingPointer = new IntPointer((long)op.maxIndexArguments());
            this.realArgumentsPointer = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? new DoublePointer((long)op.maxRealArguments()) : new FloatPointer((long)op.maxRealArguments());
            this.shapesPointer = new PointerPointer((long)op.maxShapes());
            this.argumentsPointer = new PointerPointer((long)op.maxArguments());
            this.arraysPointer = new PointerPointer((long)op.maxIntArrays());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateMemoryBlock that = (AggregateMemoryBlock)o;
            return this.opNum == that.opNum;
        }

        public int hashCode() {
            return this.opNum;
        }

        public List<IntPointer> getIntArrays() {
            return this.intArrays;
        }

        public IntPointer getIndexingPointer() {
            return this.indexingPointer;
        }

        public Pointer getRealArgumentsPointer() {
            return this.realArgumentsPointer;
        }

        public PointerPointer getShapesPointer() {
            return this.shapesPointer;
        }

        public PointerPointer getArgumentsPointer() {
            return this.argumentsPointer;
        }

        public PointerPointer getArraysPointer() {
            return this.arraysPointer;
        }

        public int getOpNum() {
            return this.opNum;
        }

        public void setIntArrays(List<IntPointer> intArrays) {
            this.intArrays = intArrays;
        }

        public void setIndexingPointer(IntPointer indexingPointer) {
            this.indexingPointer = indexingPointer;
        }

        public void setRealArgumentsPointer(Pointer realArgumentsPointer) {
            this.realArgumentsPointer = realArgumentsPointer;
        }

        public void setShapesPointer(PointerPointer shapesPointer) {
            this.shapesPointer = shapesPointer;
        }

        public void setArgumentsPointer(PointerPointer argumentsPointer) {
            this.argumentsPointer = argumentsPointer;
        }

        public void setArraysPointer(PointerPointer arraysPointer) {
            this.arraysPointer = arraysPointer;
        }

        public String toString() {
            return "NativeOpExecutioner.AggregateMemoryBlock(intArrays=" + this.getIntArrays() + ", indexingPointer=" + this.getIndexingPointer() + ", realArgumentsPointer=" + this.getRealArgumentsPointer() + ", shapesPointer=" + this.getShapesPointer() + ", argumentsPointer=" + this.getArgumentsPointer() + ", arraysPointer=" + this.getArraysPointer() + ", opNum=" + this.getOpNum() + ")";
        }
    }
}

