/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.ops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.math3.util.Pair;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.cpu.nativecpu.CpuTADManager;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpExecutioner
extends DefaultOpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(NativeOpExecutioner.class);
    private NativeOps loop = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private ConstantHandler constantHandler = Nd4j.getConstantHandler();
    private CpuTADManager tadManager = new CpuTADManager();
    private ThreadLocal<Map<Integer, Pointer>> batchPointers = new ThreadLocal();

    public NativeOpExecutioner() {
        this.tadManager.init(this.loop, this.constantHandler);
    }

    public Op exec(Op op) {
        this.checkForCompression(op);
        if (op instanceof ScalarOp) {
            ScalarOp s = (ScalarOp)op;
            this.exec(s);
        } else if (op instanceof TransformOp) {
            TransformOp t = (TransformOp)op;
            this.exec(t);
        } else if (op instanceof Accumulation) {
            Accumulation ac = (Accumulation)op;
            this.exec(ac);
        } else if (op instanceof IndexAccumulation) {
            IndexAccumulation iac = (IndexAccumulation)op;
            this.exec(iac);
        } else if (op instanceof BroadcastOp) {
            BroadcastOp broadcastOp = (BroadcastOp)op;
            this.exec(broadcastOp, broadcastOp.getDimension());
        }
        return op;
    }

    public INDArray exec(IndexAccumulation op, int ... dimension) {
        int[] retShape;
        int[] nArray;
        if (dimension == null || dimension.length == 0) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        this.checkForCompression((Op)op);
        Arrays.sort(dimension);
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + op.x().rank();
        }
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if (Shape.wholeArrayDimension((int[])dimension)) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = retShape = ArrayUtil.removeIndex((int[])op.x().shape(), (int[])dimension);
        }
        if (retShape.length == 1) {
            retShape = dimension[0] == 0 ? new int[]{1, retShape[0]} : new int[]{retShape[0], 1};
        } else if (retShape.length == 0) {
            retShape = new int[]{1, 1};
        }
        INDArray ret = Nd4j.valueArrayOf((int[])retShape, (double)op.zeroDouble());
        op.setZ(ret);
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        PointerPointer dummy = new PointerPointer(new Pointer[]{hostTadShapeInfo, hostTadOffsets});
        long st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        Pointer x = op.x().data().addressPointer();
        Pointer z = op.z().data().addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.z().isScalar()) {
                int res = (int)this.loop.execIndexReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                op.setFinalResult(res);
                op.z().putScalar(0, (float)res);
            } else {
                this.loop.execIndexReduceDouble(dummy, op.opNum(), (DoublePointer)x, (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)z, (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (op.z().isScalar()) {
            int res = (int)this.loop.execIndexReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            op.setFinalResult(res);
            op.z().putScalar(0, (float)res);
        } else {
            this.loop.execIndexReduceFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        this.profilingHookOut((Op)op, st);
        return op.z();
    }

    public INDArray exec(Accumulation op, int ... dimension) {
        int[] retShape;
        int[] nArray;
        int i;
        Arrays.sort(dimension);
        for (i = 0; i < dimension.length; ++i) {
            if (dimension[i] < op.x().rank() || dimension[i] == Integer.MAX_VALUE) continue;
            throw new ND4JIllegalStateException("Op target dimension " + Arrays.toString(dimension) + " contains element that higher then rank of op.X: [" + op.x().rank() + "]");
        }
        for (i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + op.x().rank();
        }
        if (dimension.length == op.x().rank()) {
            dimension = new int[]{Integer.MAX_VALUE};
        }
        if (Shape.wholeArrayDimension((int[])dimension)) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = retShape = ArrayUtil.removeIndex((int[])op.x().shape(), (int[])dimension);
        }
        if (retShape.length == 1) {
            retShape = dimension[0] == 0 ? new int[]{1, retShape[0]} : new int[]{retShape[0], 1};
        } else if (retShape.length == 0) {
            retShape = new int[]{1, 1};
        }
        if (op.x().isVector() && op.x().length() == ArrayUtil.prod((int[])retShape)) {
            return op.noOp();
        }
        INDArray ret = Nd4j.valueArrayOf((int[])retShape, (double)op.zeroDouble());
        op.setZ(ret);
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        PointerPointer dummy = new PointerPointer(new Pointer[]{hostTadShapeInfo, hostTadOffsets});
        long st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op instanceof Variance) {
                if (ret.isScalar()) {
                    ret.putScalar(0, this.loop.execSummaryStatsScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), true));
                } else {
                    Variance var = (Variance)op;
                    this.loop.execSummaryStatsDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, var.isBiasCorrected());
                }
            } else if (op.y() != null) {
                if (ret.isScalar()) {
                    ret.putScalar(0, this.loop.execReduce3ScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
                } else {
                    this.loop.execReduce3Double(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
                }
            } else if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
            } else {
                this.loop.execReduceDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (op instanceof Variance) {
            Variance variance = (Variance)op;
            if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execSummaryStatsScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), variance.isBiasCorrected()));
            } else {
                this.loop.execSummaryStatsFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length, variance.isBiasCorrected());
            }
        } else if (op.y() != null) {
            if (ret.isScalar()) {
                ret.putScalar(0, this.loop.execReduce3ScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
            } else {
                this.loop.execReduce3Float(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
            }
        } else if (ret.isScalar()) {
            ret.putScalar(0, this.loop.execReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op)));
        } else {
            this.loop.execReduceFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        return ret;
    }

    private void invoke(ScalarOp op, int[] dimension) {
        Arrays.sort(dimension);
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        PointerPointer dummy = new PointerPointer(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        if (op.x().data().dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), new IntPointer(dimension), dimension.length);
        } else if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), new IntPointer(dimension), dimension.length);
        }
    }

    private void exec(ScalarOp op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else {
            long st = this.profilingHookIn((Op)op);
            if (op.getDimension() != null) {
                this.invoke(op, op.getDimension());
                return;
            }
            PointerPointer dummy = new PointerPointer(new Pointer[]{null});
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.z().elementWiseStride() >= 1 && !op.isExecSpecial()) {
                    this.loop.execScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (DoublePointer)op.z().data().addressPointer(), op.z().elementWiseStride(), op.scalar().doubleValue(), (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
                } else {
                    this.loop.execScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), op.scalar().doubleValue(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                }
            } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.z().elementWiseStride() >= 1 && !op.isExecSpecial()) {
                this.loop.execScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (FloatPointer)op.z().data().addressPointer(), op.z().elementWiseStride(), op.scalar().floatValue(), (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), op.scalar().floatValue(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            }
            this.profilingHookOut((Op)op, st);
        }
    }

    private Pointer getPointerForExtraArgs(Op op) {
        if (op.extraArgs() != null) {
            return op.extraArgsDataBuff().addressPointer();
        }
        return null;
    }

    private void exec(TransformOp op) {
        long st = 0L;
        PointerPointer dummy = new PointerPointer(4L);
        if (op.opNum() == 41 && op.extraArgs() != null) {
            int[] dimension = new int[]{(Integer)op.extraArgs()[1]};
            Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
            Pointer tad = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            Pointer off = offsets == null ? null : offsets.addressPointer();
            dummy.put(0L, tad);
            dummy.put(1L, off);
            st = this.profilingHookIn((Op)op, new DataBuffer[]{(DataBuffer)tadBuffers.getFirst()});
        } else {
            st = this.profilingHookIn((Op)op);
        }
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.y() != null) {
                if (op.x().elementWiseStride() >= 1 && op.y().elementWiseStride() >= 1 && op.x().elementWiseStride() == op.y().elementWiseStride() && !op.isExecSpecial() && op.x().ordering() == op.y().ordering() && op.x().ordering() == op.z().ordering()) {
                    this.loop.execPairwiseTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (DoublePointer)op.y().data().addressPointer(), op.y().elementWiseStride(), (DoublePointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
                } else {
                    this.loop.execPairwiseTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
                }
            } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && !op.isExecSpecial() && op.x().ordering() == op.z().ordering()) {
                this.loop.execTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (DoublePointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (DoublePointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execTransformDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op));
            }
        } else if (op.y() != null) {
            if (op.x().elementWiseStride() >= 1 && op.y().elementWiseStride() >= 1 && op.x().elementWiseStride() == op.y().elementWiseStride() && !op.isExecSpecial() && op.x().ordering() == op.y().ordering()) {
                this.loop.execPairwiseTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (FloatPointer)op.y().data().addressPointer(), op.y().elementWiseStride(), (FloatPointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
            } else {
                this.loop.execPairwiseTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
            }
        } else if (op.x().elementWiseStride() >= 1 && !op.isExecSpecial() && op.x().ordering() == op.z().ordering()) {
            this.loop.execTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), op.x().elementWiseStride(), (FloatPointer)op.z().data().addressPointer(), op.z().elementWiseStride(), (FloatPointer)this.getPointerForExtraArgs((Op)op), op.n());
        } else {
            this.loop.execTransformFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op));
        }
        this.profilingHookOut((Op)op, st);
    }

    public INDArray exec(BroadcastOp op, int ... dimension) {
        long st = this.profilingHookIn((Op)op);
        Arrays.sort(dimension);
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] < op.x().rank() || dimension[i] == Integer.MAX_VALUE) continue;
            throw new ND4JIllegalStateException("Op target dimension " + Arrays.toString(dimension) + " contains element that higher then rank of op.X: [" + op.x().rank() + "]");
        }
        Pair<DataBuffer, DataBuffer> tadBuffers = this.tadManager.getTADOnlyShapeInfo(op.x(), dimension);
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer hostTadOffsets = ((DataBuffer)tadBuffers.getSecond()).addressPointer();
        Pointer devTadShapeInfoZ = null;
        Pointer devTadOffsetsZ = null;
        Pair<DataBuffer, DataBuffer> tadBuffersZ = this.tadManager.getTADOnlyShapeInfo(op.z(), dimension);
        devTadShapeInfoZ = ((DataBuffer)tadBuffersZ.getFirst()).addressPointer();
        devTadOffsetsZ = ((DataBuffer)tadBuffersZ.getSecond()).addressPointer();
        PointerPointer dummy = new PointerPointer(new Pointer[]{hostTadShapeInfo, hostTadOffsets, devTadShapeInfoZ, devTadOffsetsZ});
        Pointer dimensionAddress = this.constantHandler.getConstantBuffer(dimension).addressPointer();
        if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execBroadcastDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        } else {
            this.loop.execBroadcastFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (IntPointer)dimensionAddress, dimension.length);
        }
        return op.z();
    }

    private void exec(IndexAccumulation op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else {
            long st = this.profilingHookIn((Op)op);
            PointerPointer dummy = new PointerPointer(new Pointer[]{null});
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                op.setFinalResult((int)this.loop.execIndexReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
            } else {
                op.setFinalResult((int)this.loop.execIndexReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op)));
            }
            this.profilingHookOut((Op)op, st);
        }
    }

    private void exec(Accumulation op) {
        if (op.x() instanceof IComplexNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else {
            long st = this.profilingHookIn((Op)op);
            PointerPointer dummy = new PointerPointer(new Pointer[]{null});
            if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
                if (op instanceof Variance) {
                    op.setFinalResult((Number)this.loop.execSummaryStatsScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), true));
                } else if (op.y() != null) {
                    op.setFinalResult((Number)this.loop.execReduce3ScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer()));
                } else {
                    op.setFinalResult((Number)this.loop.execReduceScalarDouble(dummy, op.opNum(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)this.getPointerForExtraArgs((Op)op)));
                }
            } else if (op instanceof Variance) {
                Variance variance = (Variance)op;
                op.setFinalResult((Number)Float.valueOf(this.loop.execSummaryStatsScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), variance.isBiasCorrected())));
            } else if (op.y() != null) {
                op.setFinalResult((Number)Float.valueOf(this.loop.execReduce3ScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer())));
            } else {
                op.setFinalResult((Number)Float.valueOf(this.loop.execReduceScalarFloat(dummy, op.opNum(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)this.getPointerForExtraArgs((Op)op))));
            }
            this.profilingHookOut((Op)op, st);
        }
    }

    protected <T extends Aggregate> Pointer getPointer(Batch<T> batch) {
        if (this.batchPointers.get() == null) {
            this.batchPointers.set(new HashMap());
        }
        if (!this.batchPointers.get().containsKey(batch.opNum())) {
            IntPointer pointer = new IntPointer(batch.getSample().getRequiredBatchMemorySize() / 4L);
            this.batchPointers.get().put(batch.opNum(), (Pointer)pointer);
            return pointer;
        }
        return this.batchPointers.get().get(batch.opNum());
    }

    public <T extends Aggregate> void exec(Batch<T> batch) {
        IntPointer pointer = (IntPointer)this.getPointer(batch);
        int maxTypes = 5;
        int maxIntArrays = batch.getSample().maxIntArrays();
        int maxArraySize = batch.getSample().maxIntArraySize();
        int indexPos = maxTypes * Batch.getBatchLimit();
        int intArraysPos = indexPos + batch.getSample().maxIndexArguments() * Batch.getBatchLimit();
        int realPos = (intArraysPos + maxIntArrays * maxArraySize * Batch.getBatchLimit()) / (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? 2 : 1);
        int argsPos = (realPos + batch.getSample().maxRealArguments() * Batch.getBatchLimit()) / (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? 1 : 2);
        int shapesPos = argsPos + batch.getSample().maxArguments() * Batch.getBatchLimit();
        for (int i = 0; i < batch.getNumAggregates(); ++i) {
            int e;
            Aggregate op = (Aggregate)batch.getAggregates().get(i);
            int idx = i * maxTypes;
            pointer.put((long)idx, op.getArguments().size());
            pointer.put((long)(idx + 1), op.getShapes().size());
            pointer.put((long)(idx + 2), op.getIndexingArguments().size());
            pointer.put((long)(idx + 3), op.getRealArguments().size());
            pointer.put((long)(idx + 4), op.getIntArrayArguments().size());
            for (int e2 = 0; e2 < op.getIndexingArguments().size(); ++e2) {
                idx = indexPos + i * batch.getSample().maxIndexArguments();
                pointer.put((long)(idx + e2), ((Integer)op.getIndexingArguments().get(e2)).intValue());
            }
            int bsize = maxIntArrays * maxArraySize;
            for (int e3 = 0; e3 < op.getIntArrayArguments().size(); ++e3) {
                int step = i * bsize + e3 * maxArraySize;
                if (op.getIntArrayArguments().get(e3) == null) continue;
                for (int x = 0; x < ((int[])op.getIntArrayArguments().get(e3)).length; ++x) {
                    idx = intArraysPos + step + x;
                    pointer.put((long)idx, ((int[])op.getIntArrayArguments().get(e3))[x]);
                }
            }
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                FloatPointer fPtr = new FloatPointer((Pointer)pointer);
                for (e = 0; e < op.getRealArguments().size(); ++e) {
                    idx = realPos + i * op.maxRealArguments();
                    fPtr.put((long)(idx + e), ((Number)op.getRealArguments().get(e)).floatValue());
                }
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                DoublePointer dPtr = new DoublePointer((Pointer)pointer);
                for (e = 0; e < op.getRealArguments().size(); ++e) {
                    idx = realPos + i * op.maxRealArguments();
                    dPtr.put((long)(idx + e), ((Number)op.getRealArguments().get(e)).doubleValue());
                }
            }
            PointerPointer ptrPtr = new PointerPointer((Pointer)pointer);
            for (e = 0; e < op.getArguments().size(); ++e) {
                idx = argsPos + i * batch.getSample().maxArguments();
                if (op.getArguments().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((INDArray)op.getArguments().get(e)).data().addressPointer());
            }
            for (e = 0; e < op.getShapes().size(); ++e) {
                idx = shapesPos + i * batch.getSample().maxShapes();
                if (op.getShapes().get(e) == null) continue;
                ptrPtr.put((long)(idx + e), ((DataBuffer)op.getShapes().get(e)).addressPointer());
            }
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execAggregateBatchFloat(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execAggregateBatchDouble(null, batch.getNumAggregates(), batch.opNum(), batch.getSample().maxArguments(), batch.getSample().maxShapes(), batch.getSample().maxIntArrays(), batch.getSample().maxIntArraySize(), batch.getSample().maxIndexArguments(), batch.getSample().maxRealArguments(), (Pointer)pointer);
        } else {
            throw new UnsupportedOperationException("Half precision isn't supported on CPU");
        }
    }

    public void exec(List<Aggregate> batch) {
        if (batch.size() == 0) {
            return;
        }
        List batches = Batch.getBatches(batch);
        for (Batch single : batches) {
            this.exec(single);
        }
    }

    public void exec(Aggregate op) {
        int x;
        int numArguments = op.getArguments().size();
        int numIndexArguments = op.getIndexingArguments().size();
        int numRealArguments = op.getRealArguments().size();
        int numShapes = op.getShapes().size();
        int numIntArrays = op.getIntArrayArguments().size();
        PointerPointer arguments = new PointerPointer((long)numArguments);
        ArrayList<IntPointer> pointers = new ArrayList<IntPointer>();
        PointerPointer intArrays = new PointerPointer((long)numIntArrays);
        for (int x2 = 0; x2 < numArguments; ++x2) {
            arguments.put((long)x2, op.getArguments().get(x2) == null ? null : ((INDArray)op.getArguments().get(x2)).data().addressPointer());
        }
        PointerPointer shapes = new PointerPointer((long)numShapes);
        for (int x3 = 0; x3 < numShapes; ++x3) {
            if (((DataBuffer)op.getShapes().get(x3)).dataType() != DataBuffer.Type.INT) {
                throw new RuntimeException("ShapeBuffers should have INT data type");
            }
            shapes.put((long)x3, op.getShapes().get(x3) == null ? null : ((DataBuffer)op.getShapes().get(x3)).addressPointer());
        }
        int[] indexes = new int[numIndexArguments];
        for (int x4 = 0; x4 < numIndexArguments; ++x4) {
            indexes[x4] = (Integer)op.getIndexingArguments().get(x4);
        }
        IntPointer pointer = new IntPointer(indexes);
        double[] reals = new double[numRealArguments];
        for (x = 0; x < numRealArguments; ++x) {
            reals[x] = ((Number)op.getRealArguments().get(x)).doubleValue();
        }
        for (x = 0; x < numIntArrays; ++x) {
            IntPointer intPtr = new IntPointer((int[])op.getIntArrayArguments().get(x));
            intArrays.put((long)x, (Pointer)intPtr);
            pointers.add(intPtr);
        }
        INDArray realsBuffer = Nd4j.create((double[])reals);
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execAggregateFloat(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, (FloatPointer)realsBuffer.data().addressPointer(), numRealArguments);
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execAggregateDouble(null, op.opNum(), arguments, numArguments, shapes, numShapes, pointer, numIndexArguments, intArrays, numIntArrays, (DoublePointer)realsBuffer.data().addressPointer(), numRealArguments);
        } else {
            throw new UnsupportedOperationException("Half precision isn't supported on CPU");
        }
    }

    public Properties getEnvironmentInformation() {
        Properties properties = super.getEnvironmentInformation();
        properties.put("backend", "CPU");
        properties.put("omp.threads", (Object)this.loop.ompGetMaxThreads());
        properties.put("blas.threads", (Object)Nd4j.factory().blas().getMaxThreads());
        properties.put("blas.vendor", ((Nd4jBlas)Nd4j.factory().blas()).getBlasVendor().toString());
        return properties;
    }

    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    public INDArray exec(RandomOp op, Random rng) {
        if (rng.getStateBuffer() == null) {
            throw new IllegalStateException("You should use one of NativeRandom classes for NativeOperations execution");
        }
        long st = this.profilingHookIn((Op)op);
        if (op.x() != null && op.y() != null && op.z() != null) {
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.y().data().addressPointer(), (IntPointer)op.y().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
            }
        } else if (op.x() != null && op.z() != null) {
            if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
                this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
            } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
                this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.x().data().addressPointer(), (IntPointer)op.x().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
            }
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.loop.execRandomFloat(null, op.opNum(), rng.getStatePointer(), (FloatPointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (FloatPointer)op.extraArgsDataBuff().addressPointer());
        } else if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execRandomDouble(null, op.opNum(), rng.getStatePointer(), (DoublePointer)op.z().data().addressPointer(), (IntPointer)op.z().shapeInfoDataBuffer().addressPointer(), (DoublePointer)op.extraArgsDataBuff().addressPointer());
        }
        this.profilingHookOut((Op)op, st);
        return op.z();
    }

    public TADManager getTADManager() {
        return this.tadManager;
    }
}

