/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.cache.ArrayDescriptor;
import org.nd4j.linalg.cache.BasicConstantHandler;
import org.nd4j.linalg.factory.Nd4j;

public class ConstantBuffersCache
extends BasicConstantHandler {
    protected Map<ArrayDescriptor, DataBuffer> buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();

    public DataBuffer getConstantBuffer(int[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBuffer((int[])array);
            this.buffersCache.put(descriptor, buffer);
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public void purgeConstants() {
        this.buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();
    }

    public DataBuffer getConstantBuffer(float[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBuffer((float[])array);
            this.buffersCache.put(descriptor, buffer);
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(double[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBuffer((double[])array);
            this.buffersCache.put(descriptor, buffer);
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }
}

