/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import org.bytedeco.javacpp.Loader;
import org.nd4j.linalg.api.blas.Blas;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jBlas
implements Blas {
    private static final Logger log = LoggerFactory.getLogger(Nd4jBlas.class);

    public Nd4jBlas() {
        String skipper = System.getenv("ND4J_SKIP_BLAS_THREADS");
        if (skipper == null || skipper.isEmpty()) {
            String numThreadsString = System.getenv("OMP_NUM_THREADS");
            if (numThreadsString != null && !numThreadsString.isEmpty()) {
                int numThreads = Integer.parseInt(numThreadsString);
                this.setMaxThreads(numThreads);
            } else {
                int cores = Loader.totalCores();
                int chips = Loader.totalChips();
                int numThreads = cores > 0 && chips > 0 ? Math.max(1, cores / chips) : NativeOpsHolder.getCores(Runtime.getRuntime().availableProcessors());
                this.setMaxThreads(numThreads);
            }
            String logInit = System.getProperty("org.nd4j.log.initialization");
            if (this.logOpenMPBlasThreads() && (logInit == null || logInit.isEmpty() || Boolean.parseBoolean(logInit))) {
                log.info("Number of threads used for OpenMP BLAS: {}", (Object)this.getMaxThreads());
            }
        }
    }

    public Blas.Vendor getBlasVendor() {
        boolean isUnknowVendor;
        int vendor = this.getBlasVendorId();
        boolean bl = isUnknowVendor = vendor > Blas.Vendor.values().length - 1 || vendor <= 0;
        if (isUnknowVendor) {
            return Blas.Vendor.UNKNOWN;
        }
        return Blas.Vendor.values()[vendor];
    }

    public boolean logOpenMPBlasThreads() {
        return true;
    }
}

