/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import org.bytedeco.javacpp.Loader;
import org.nd4j.linalg.api.blas.Blas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jBlas
implements Blas {
    private static Logger logger = LoggerFactory.getLogger(Nd4jBlas.class);

    public Nd4jBlas() {
        String skipper = System.getenv("ND4J_SKIP_BLAS_THREADS");
        if (skipper == null || skipper.isEmpty()) {
            String numThreadsString = System.getenv("OMP_NUM_THREADS");
            if (numThreadsString != null && !numThreadsString.isEmpty()) {
                int numThreads = Integer.parseInt(numThreadsString);
                this.setMaxThreads(numThreads);
            } else {
                int cores = Loader.totalCores();
                int chips = Loader.totalChips();
                int numThreads = cores > 0 && chips > 0 ? Math.max(1, cores / chips) : this.getCores(Runtime.getRuntime().availableProcessors());
                this.setMaxThreads(numThreads);
            }
            logger.info("Number of threads used for BLAS: {}", (Object)this.getMaxThreads());
        }
    }

    private int getCores(int totals) {
        if (totals >= 256) {
            return 64;
        }
        int ht_off = totals / 2;
        if (ht_off <= 4) {
            return 4;
        }
        if (ht_off > 24) {
            int rounds = 0;
            while (ht_off > 24) {
                if (ht_off <= 24) continue;
                ht_off /= 2;
                ++rounds;
            }
            if (ht_off == 20 && rounds < 2) {
                ht_off /= 2;
            }
        } else {
            if (ht_off <= 6) {
                return ht_off;
            }
            if (this.isOdd(ht_off)) {
                return ht_off;
            }
            if (ht_off == 20 || ht_off == 16) {
                ht_off /= 2;
            }
        }
        return ht_off;
    }

    public Blas.Vendor getBlasVendor() {
        boolean isUnknowVendor;
        int vendor = this.getBlasVendorId();
        boolean bl = isUnknowVendor = vendor > Blas.Vendor.values().length - 1 || vendor <= 0;
        if (isUnknowVendor) {
            return Blas.Vendor.UNKNOWN;
        }
        return Blas.Vendor.values()[vendor];
    }

    private boolean isOdd(int value) {
        return value % 2 != 0;
    }
}

