/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.nio.Buffer;
import org.nd4j.linalg.api.buffer.unsafe.UnsafeHolder;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.nativeblas.PointerConverter;

public class DefaultPointerConverter
implements PointerConverter {
    @Override
    public long toPointer(IComplexNDArray arr) {
        return arr.data().address();
    }

    @Override
    public long toPointer(INDArray arr) {
        return arr.data().address();
    }

    @Override
    public long toPointer(Buffer buffer) {
        if (buffer.isDirect()) {
            try {
                return UnsafeHolder.getUnsafe().objectFieldOffset(UnsafeHolder.getAddressField());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            int offset = UnsafeHolder.getUnsafe().arrayBaseOffset(buffer.array().getClass());
            int scale = UnsafeHolder.getUnsafe().arrayIndexScale(buffer.array().getClass());
            switch (scale) {
                case 4: {
                    long factor = UnsafeHolder.is64Bit() ? 8L : 1L;
                    long i1 = ((long)UnsafeHolder.getUnsafe().getInt(buffer.array(), offset) & 0xFFFFFFFFL) * factor;
                    return i1;
                }
                case 8: {
                    throw new AssertionError((Object)"Not supported");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get address");
        }
        throw new IllegalStateException("Unable to get address");
    }
}

