/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.compression.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.compression.impl.AbstractCompressor;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.nd4j.linalg.factory.Nd4j;

public class Gzip
extends AbstractCompressor {
    public String getDescriptor() {
        return "GZIP";
    }

    public CompressionType getCompressionType() {
        return CompressionType.LOSSLESS;
    }

    @Override
    public DataBuffer decompress(DataBuffer buffer) {
        try {
            CompressedDataBuffer compressed = (CompressedDataBuffer)buffer;
            CompressionDescriptor descriptor = compressed.getCompressionDescriptor();
            BytePointer pointer = (BytePointer)compressed.addressPointer();
            ByteArrayInputStream bis = new ByteArrayInputStream(pointer.getStringBytes());
            GZIPInputStream gzip = new GZIPInputStream(bis);
            DataInputStream dis = new DataInputStream(gzip);
            DataBuffer bufferRestored = Nd4j.createBuffer((long)descriptor.getNumberOfElements());
            bufferRestored.read(dis);
            return bufferRestored;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataBuffer compress(DataBuffer buffer) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)stream);
            DataOutputStream dos = new DataOutputStream(gzip);
            buffer.write(dos);
            dos.flush();
            dos.close();
            byte[] bytes = stream.toByteArray();
            BytePointer pointer = new BytePointer(bytes);
            CompressionDescriptor descriptor = new CompressionDescriptor(buffer, (NDArrayCompressor)this);
            descriptor.setCompressedLength((long)bytes.length);
            CompressedDataBuffer result = new CompressedDataBuffer((Pointer)pointer, descriptor);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected CompressedDataBuffer compressPointer(DataBuffer.TypeEx srcType, Pointer srcPointer, int length, int elementSize) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

