/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.nd4j.compression.impl.NoOp;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.AbstractStorage;
import org.nd4j.linalg.compression.NDArrayCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedRamStorage<T>
implements AbstractStorage<T> {
    private static final Logger log = LoggerFactory.getLogger(CompressedRamStorage.class);
    private NDArrayCompressor compressor = new NoOp();
    private Map<T, INDArray> compressedEntries = new ConcurrentHashMap<T, INDArray>();
    private boolean useInplaceCompression = false;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean emulateIsAbsent = false;

    private CompressedRamStorage() {
    }

    public void store(T key, INDArray object) {
        INDArray toStore;
        if (this.useInplaceCompression) {
            this.compressor.compressi(object);
            toStore = object;
        } else {
            toStore = this.compressor.compress(object);
        }
        if (this.emulateIsAbsent) {
            this.lock.writeLock().lock();
        }
        this.compressedEntries.put(key, toStore);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().unlock();
        }
    }

    public void store(T key, float[] array) {
        INDArray toStore = this.compressor.compress(array);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().lock();
        }
        this.compressedEntries.put(key, toStore);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().unlock();
        }
    }

    public void store(T key, double[] array) {
        INDArray toStore = this.compressor.compress(array);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().lock();
        }
        this.compressedEntries.put(key, toStore);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeIfAbsent(T key, INDArray object) {
        try {
            if (this.emulateIsAbsent) {
                this.lock.writeLock().lock();
            }
            if (this.compressedEntries.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            this.store(key, object);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.emulateIsAbsent) {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray get(T key) {
        try {
            if (this.emulateIsAbsent) {
                this.lock.readLock().lock();
            }
            if (this.containsKey(key)) {
                INDArray result = this.compressedEntries.get(key);
                INDArray iNDArray = this.compressor.decompress(result);
                return iNDArray;
            }
            INDArray iNDArray = null;
            return iNDArray;
        }
        finally {
            if (this.emulateIsAbsent) {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(T key) {
        try {
            if (this.emulateIsAbsent) {
                this.lock.readLock().lock();
            }
            boolean bl = this.compressedEntries.containsKey(key);
            return bl;
        }
        finally {
            if (this.emulateIsAbsent) {
                this.lock.readLock().unlock();
            }
        }
    }

    public void clear() {
        if (this.emulateIsAbsent) {
            this.lock.writeLock().lock();
        }
        this.compressedEntries.clear();
        if (this.emulateIsAbsent) {
            this.lock.writeLock().unlock();
        }
    }

    public void drop(T key) {
        if (this.emulateIsAbsent) {
            this.lock.writeLock().lock();
        }
        this.compressedEntries.remove(key);
        if (this.emulateIsAbsent) {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        try {
            if (this.emulateIsAbsent) {
                this.lock.readLock().lock();
            }
            long l = this.compressedEntries.size();
            return l;
        }
        finally {
            if (this.emulateIsAbsent) {
                this.lock.readLock().unlock();
            }
        }
    }

    public static class Builder<T> {
        private NDArrayCompressor compressor = new NoOp();
        private boolean useInplaceCompression = false;
        private boolean emulateIsAbsent = false;

        public Builder<T> setCompressor(@NonNull NDArrayCompressor compressor) {
            if (compressor == null) {
                throw new NullPointerException("compressor");
            }
            this.compressor = compressor;
            return this;
        }

        public Builder<T> useInplaceCompression(boolean reallyUse) {
            this.useInplaceCompression = reallyUse;
            return this;
        }

        public Builder<T> emulateIsAbsent(boolean reallyEmulate) {
            this.emulateIsAbsent = reallyEmulate;
            return this;
        }

        public CompressedRamStorage<T> build() {
            CompressedRamStorage storage = new CompressedRamStorage();
            storage.compressor = this.compressor;
            storage.useInplaceCompression = this.useInplaceCompression;
            storage.emulateIsAbsent = this.emulateIsAbsent;
            return storage;
        }
    }
}

