/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.Properties;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Platform(include={"NativeOps.h"}, compiler={"cpp11"}, link={"nd4j"}, library="jnind4j")
public class NativeOps
extends Pointer {
    private static Logger log = LoggerFactory.getLogger(NativeOps.class);

    public NativeOps() {
        this.allocate();
        this.initializeDevicesAndFunctions();
        String numThreadsString = System.getenv("OMP_NUM_THREADS");
        if (numThreadsString != null && !numThreadsString.isEmpty()) {
            int numThreads = Integer.parseInt(numThreadsString);
            this.setOmpNumThreads(numThreads);
        } else {
            this.setOmpNumThreads(NativeOps.getCores(Runtime.getRuntime().availableProcessors()));
        }
        log.info("Number of threads used for NativeOps: {}", (Object)this.ompGetMaxThreads());
    }

    private native void allocate();

    private static int getCores(int totals) {
        if (totals >= 256) {
            return 64;
        }
        int ht_off = totals / 2;
        if (ht_off <= 4) {
            return 4;
        }
        if (ht_off > 24) {
            int rounds = 0;
            while (ht_off > 24) {
                if (ht_off <= 24) continue;
                ht_off /= 2;
                ++rounds;
            }
            if (ht_off == 20 && rounds < 2) {
                ht_off /= 2;
            }
        } else {
            if (ht_off <= 6) {
                return ht_off;
            }
            if (NativeOps.isOdd(ht_off)) {
                return ht_off;
            }
            if (ht_off == 20 || ht_off == 16) {
                ht_off /= 2;
            }
        }
        return ht_off;
    }

    private static boolean isOdd(int value) {
        return value % 2 != 0;
    }

    public native double execIndexReduceScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5);

    public native void execIndexReduceDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, IntPointer var8, int var9);

    public native void execBroadcastDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, DoublePointer var7, IntPointer var8, IntPointer var9, int var10);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, DoublePointer var3, int var4, DoublePointer var5, int var6, DoublePointer var7, int var8, DoublePointer var9, long var10);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, DoublePointer var7, IntPointer var8, DoublePointer var9, IntPointer var10, IntPointer var11, IntPointer var12);

    public native void execPairwiseTransformDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, DoublePointer var7, IntPointer var8, DoublePointer var9);

    public native void execReduceDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7);

    public native void execReduceDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, IntPointer var8, int var9);

    public native double execReduceScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5);

    public native void execReduce3Double(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, DoublePointer var8, IntPointer var9);

    public native double execReduce3ScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7);

    public native void execReduce3Double(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, DoublePointer var8, IntPointer var9, IntPointer var10, int var11);

    public native void execScalarDouble(PointerPointer var1, int var2, DoublePointer var3, int var4, DoublePointer var5, int var6, double var7, DoublePointer var9, long var10);

    public native void execScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, double var7, DoublePointer var9);

    public native void execScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, double var7, DoublePointer var9, long var10, IntPointer var12, IntPointer var13);

    public native double execSummaryStatsScalarDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, boolean var6);

    public native void execSummaryStatsDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, boolean var8);

    public native void execSummaryStatsDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, DoublePointer var6, IntPointer var7, IntPointer var8, int var9, boolean var10);

    public native void execTransformDouble(PointerPointer var1, int var2, DoublePointer var3, int var4, DoublePointer var5, int var6, DoublePointer var7, long var8);

    public native void execTransformDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, DoublePointer var7);

    public native void execTransformDouble(PointerPointer var1, int var2, DoublePointer var3, IntPointer var4, DoublePointer var5, IntPointer var6, DoublePointer var7, IntPointer var8, IntPointer var9);

    public native float execIndexReduceScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5);

    public native float execIndexReduceScalarHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5);

    public native void execIndexReduceFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, IntPointer var8, int var9);

    public native void execIndexReduceHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, IntPointer var8, int var9);

    public native void execBroadcastFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, FloatPointer var7, IntPointer var8, IntPointer var9, int var10);

    public native void execBroadcastHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, @Cast(value={"float16*"}) ShortPointer var7, IntPointer var8, IntPointer var9, int var10);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, FloatPointer var3, int var4, FloatPointer var5, int var6, FloatPointer var7, int var8, FloatPointer var9, long var10);

    public native void execPairwiseTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, int var4, @Cast(value={"float16*"}) ShortPointer var5, int var6, @Cast(value={"float16*"}) ShortPointer var7, int var8, @Cast(value={"float16*"}) ShortPointer var9, long var10);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, FloatPointer var7, IntPointer var8, FloatPointer var9, IntPointer var10, IntPointer var11, IntPointer var12);

    public native void execPairwiseTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, @Cast(value={"float16*"}) ShortPointer var7, IntPointer var8, @Cast(value={"float16*"}) ShortPointer var9, IntPointer var10, IntPointer var11, IntPointer var12);

    public native void execPairwiseTransformFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, FloatPointer var7, IntPointer var8, FloatPointer var9);

    public native void execPairwiseTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, @Cast(value={"float16*"}) ShortPointer var7, IntPointer var8, @Cast(value={"float16*"}) ShortPointer var9);

    public native void execReduceFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7);

    public native void execReduceHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7);

    public native void execReduceFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, IntPointer var8, int var9);

    public native void execReduceHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, IntPointer var8, int var9);

    public native float execReduceScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5);

    public native float execReduceScalarHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5);

    public native void execReduce3Float(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, FloatPointer var8, IntPointer var9);

    public native void execReduce3Half(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, @Cast(value={"float16*"}) ShortPointer var8, IntPointer var9);

    public native float execReduce3ScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7);

    public native float execReduce3ScalarHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7);

    public native void execReduce3Float(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, FloatPointer var8, IntPointer var9, IntPointer var10, int var11);

    public native void execReduce3Half(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, @Cast(value={"float16*"}) ShortPointer var8, IntPointer var9, IntPointer var10, int var11);

    public native void execScalarFloat(PointerPointer var1, int var2, FloatPointer var3, int var4, FloatPointer var5, int var6, double var7, FloatPointer var9, long var10);

    public native void execScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, float var7, FloatPointer var8);

    public native void execScalarHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, float var7, @Cast(value={"float16*"}) ShortPointer var8);

    public native void execScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, double var7, FloatPointer var9, IntPointer var10, IntPointer var11);

    public native float execSummaryStatsScalarFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, boolean var6);

    public native float execSummaryStatsScalarHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, boolean var6);

    public native void execSummaryStatsFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, boolean var8);

    public native void execSummaryStatsHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, boolean var8);

    public native void execSummaryStatsFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, FloatPointer var6, IntPointer var7, IntPointer var8, int var9, boolean var10);

    public native void execSummaryStatsHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, IntPointer var8, int var9, boolean var10);

    public native void execTransformFloat(PointerPointer var1, int var2, FloatPointer var3, int var4, FloatPointer var5, int var6, FloatPointer var7, long var8);

    public native void execTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, int var4, @Cast(value={"float16*"}) ShortPointer var5, int var6, @Cast(value={"float16*"}) ShortPointer var7, long var8);

    public native void execTransformFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, FloatPointer var7);

    public native void execTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, @Cast(value={"float16*"}) ShortPointer var7);

    public native void execTransformFloat(PointerPointer var1, int var2, FloatPointer var3, IntPointer var4, FloatPointer var5, IntPointer var6, FloatPointer var7, IntPointer var8, IntPointer var9);

    public native void execTransformHalf(PointerPointer var1, int var2, @Cast(value={"float16*"}) ShortPointer var3, IntPointer var4, @Cast(value={"float16*"}) ShortPointer var5, IntPointer var6, @Cast(value={"float16*"}) ShortPointer var7, IntPointer var8, IntPointer var9);

    public native void flattenFloat(PointerPointer var1, int var2, char var3, FloatPointer var4, IntPointer var5, FloatPointer var6, IntPointer var7);

    public native void flattenHalf(PointerPointer var1, int var2, char var3, @Cast(value={"float16*"}) ShortPointer var4, IntPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7);

    public native void flattenDouble(PointerPointer var1, int var2, char var3, DoublePointer var4, IntPointer var5, DoublePointer var6, IntPointer var7);

    public native void concatDouble(PointerPointer var1, int var2, int var3, PointerPointer var4, PointerPointer var5, DoublePointer var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native void concatFloat(PointerPointer var1, int var2, int var3, PointerPointer var4, PointerPointer var5, FloatPointer var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native void concatHalf(PointerPointer var1, int var2, int var3, PointerPointer var4, PointerPointer var5, @Cast(value={"float16*"}) ShortPointer var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native int ompGetMaxThreads();

    public native int ompGetNumThreads();

    public native void setOmpNumThreads(int var1);

    public native void setOmpMinThreads(int var1);

    public native void initializeDevicesAndFunctions();

    public synchronized native Pointer mallocHost(long var1, int var3);

    public synchronized native Pointer mallocDevice(long var1, Pointer var3, int var4);

    public native int freeHost(Pointer var1);

    public native int freeDevice(Pointer var1, Pointer var2);

    public native Pointer createContext();

    public native Pointer createStream();

    public native Pointer createEvent();

    public native Pointer createBlasHandle();

    public native int registerEvent(Pointer var1, Pointer var2);

    public native int destroyEvent(Pointer var1);

    public native int setBlasStream(Pointer var1, Pointer var2);

    public native int setDevice(Pointer var1);

    public native int getDevice();

    public native int streamSynchronize(Pointer var1);

    public native int eventSynchronize(Pointer var1);

    public native long getDeviceFreeMemory(Pointer var1);

    public native long getDeviceTotalMemory(Pointer var1);

    public native int memcpy(Pointer var1, Pointer var2, long var3, int var5, Pointer var6);

    public native int memcpyAsync(Pointer var1, Pointer var2, long var3, int var5, Pointer var6);

    public native int memcpyConstantAsync(long var1, Pointer var3, long var4, int var6, Pointer var7);

    public native int memset(Pointer var1, int var2, long var3, int var5, Pointer var6);

    public native int memsetAsync(Pointer var1, int var2, long var3, int var5, Pointer var6);

    public native Pointer getConstantSpace();

    public native int getAvailableDevices();

    public native void enableDebugMode(boolean var1);

    public native void enableVerboseMode(boolean var1);

    public native void setGridLimit(int var1);

    public native void tadOnlyShapeInfo(IntPointer var1, IntPointer var2, int var3, IntPointer var4, IntPointer var5);

    public native void pullRowsFloat(PointerPointer var1, FloatPointer var2, IntPointer var3, FloatPointer var4, IntPointer var5, int var6, IntPointer var7, IntPointer var8, IntPointer var9);

    public native void pullRowsDouble(PointerPointer var1, DoublePointer var2, IntPointer var3, DoublePointer var4, IntPointer var5, int var6, IntPointer var7, IntPointer var8, IntPointer var9);

    public native void pullRowsHalf(PointerPointer var1, @Cast(value={"float16*"}) ShortPointer var2, IntPointer var3, @Cast(value={"float16*"}) ShortPointer var4, IntPointer var5, int var6, IntPointer var7, IntPointer var8, IntPointer var9);

    public native void averageHalf(PointerPointer var1, PointerPointer var2, @Cast(value={"float16*"}) ShortPointer var3, int var4, long var5, boolean var7);

    public native void averageFloat(PointerPointer var1, PointerPointer var2, FloatPointer var3, int var4, long var5, boolean var7);

    public native void averageDouble(PointerPointer var1, PointerPointer var2, DoublePointer var3, int var4, long var5, boolean var7);

    public native void enableP2P(boolean var1);

    public native void checkP2P();

    public native boolean isP2PAvailable();

    public native void shuffleDouble(PointerPointer var1, PointerPointer var2, PointerPointer var3, PointerPointer var4, PointerPointer var5, int var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native void shuffleFloat(PointerPointer var1, PointerPointer var2, PointerPointer var3, PointerPointer var4, PointerPointer var5, int var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native void shuffleHalf(PointerPointer var1, PointerPointer var2, PointerPointer var3, PointerPointer var4, PointerPointer var5, int var6, IntPointer var7, PointerPointer var8, PointerPointer var9);

    public native void convertTypes(PointerPointer var1, int var2, Pointer var3, long var4, int var6, Pointer var7);

    public native boolean isExperimentalEnabled();

    public native void execMetaPredicateStridedFloat(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, FloatPointer var8, int var9, FloatPointer var10, int var11, FloatPointer var12, int var13, FloatPointer var14, FloatPointer var15, float var16, float var17);

    public native void execMetaPredicateStridedDouble(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, DoublePointer var8, int var9, DoublePointer var10, int var11, DoublePointer var12, int var13, DoublePointer var14, DoublePointer var15, double var16, double var18);

    public native void execMetaPredicateStridedHalf(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, @Cast(value={"float16*"}) ShortPointer var8, int var9, @Cast(value={"float16*"}) ShortPointer var10, int var11, @Cast(value={"float16*"}) ShortPointer var12, int var13, @Cast(value={"float16*"}) ShortPointer var14, @Cast(value={"float16*"}) ShortPointer var15, float var16, float var17);

    public native void execMetaPredicateShapeFloat(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, FloatPointer var8, IntPointer var9, FloatPointer var10, IntPointer var11, FloatPointer var12, IntPointer var13, FloatPointer var14, FloatPointer var15, float var16, float var17);

    public native void execMetaPredicateShapeDouble(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, DoublePointer var8, IntPointer var9, DoublePointer var10, IntPointer var11, DoublePointer var12, IntPointer var13, DoublePointer var14, DoublePointer var15, double var16, double var18);

    public native void execMetaPredicateShapeHalf(PointerPointer var1, int var2, int var3, int var4, int var5, long var6, @Cast(value={"float16*"}) ShortPointer var8, IntPointer var9, @Cast(value={"float16*"}) ShortPointer var10, IntPointer var11, @Cast(value={"float16*"}) ShortPointer var12, IntPointer var13, @Cast(value={"float16*"}) ShortPointer var14, @Cast(value={"float16*"}) ShortPointer var15, float var16, float var17);

    public native void execMetaPredicateReduceFloat(PointerPointer var1, int var2, int var3, int var4, int var5, FloatPointer var6, IntPointer var7, FloatPointer var8, IntPointer var9, FloatPointer var10, IntPointer var11, IntPointer var12, int var13, IntPointer var14, IntPointer var15, FloatPointer var16, FloatPointer var17, float var18, float var19, boolean var20);

    static {
        String platform = Loader.getPlatform();
        Properties properties = Loader.loadProperties((String)(platform + "-nd4j"), (String)platform);
        properties.remove("platform.preloadpath");
        String s = System.getProperty("org.nd4j.nativeblas.pathsfirst", "false").toLowerCase();
        boolean pathsFirst = s.equals("true") || s.equals("t") || s.equals("");
        try {
            Loader.load(NativeOps.class, (Properties)properties, (boolean)pathsFirst);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("ND4J is probably missing dependencies. For more information, please refer to: http://nd4j.org/getstarted.html", e);
        }
    }
}

