/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.factory;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DoubleBuffer;
import org.nd4j.linalg.api.buffer.FloatBuffer;
import org.nd4j.linalg.api.buffer.IntBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.util.ArrayUtil;

public class DefaultDataBufferFactory
implements DataBufferFactory {
    protected DataBuffer.AllocationMode allocationMode;

    @Override
    public void setAllocationMode(DataBuffer.AllocationMode allocationMode) {
        this.allocationMode = allocationMode;
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        if (this.allocationMode == null) {
            String otherAlloc = System.getProperty("alloc");
            if (otherAlloc.equals("heap")) {
                this.setAllocationMode(DataBuffer.AllocationMode.HEAP);
            } else if (otherAlloc.equals("direct")) {
                this.setAllocationMode(DataBuffer.AllocationMode.DIRECT);
            } else if (otherAlloc.equals("javacpp")) {
                this.setAllocationMode(DataBuffer.AllocationMode.JAVACPP);
            }
        }
        return this.allocationMode;
    }

    @Override
    public DataBuffer create(DataBuffer underlyingBuffer, long offset, long length) {
        if (underlyingBuffer.dataType() == DataBuffer.Type.DOUBLE) {
            return new DoubleBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.FLOAT) {
            return new FloatBuffer(underlyingBuffer, length, offset);
        }
        if (underlyingBuffer.dataType() == DataBuffer.Type.INT) {
            return new IntBuffer(underlyingBuffer, length, offset);
        }
        return null;
    }

    @Override
    public DataBuffer createInt(int offset, ByteBuffer buffer, int length) {
        return new IntBuffer(buffer, length, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, ByteBuffer buffer, int length) {
        return new FloatBuffer(buffer, length, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, ByteBuffer buffer, int length) {
        return new DoubleBuffer(buffer, length, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, int length) {
        return new DoubleBuffer(length, 8, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, int length) {
        return new FloatBuffer(length, 4, offset);
    }

    @Override
    public DataBuffer createInt(int offset, int length) {
        return new IntBuffer(length, 4, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, int[] data) {
        return this.createDouble(offset, data, true);
    }

    @Override
    public DataBuffer createFloat(int offset, int[] data) {
        FloatBuffer ret = new FloatBuffer(ArrayUtil.toFloats((int[])data), true, offset);
        return ret;
    }

    @Override
    public DataBuffer createInt(int offset, int[] data) {
        return new IntBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, double[] data) {
        return new DoubleBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, byte[] data, int length) {
        return this.createDouble(offset, ArrayUtil.toDoubleArray((byte[])data), true);
    }

    @Override
    public DataBuffer createFloat(int offset, byte[] data, int length) {
        return this.createFloat(offset, ArrayUtil.toFloatArray((byte[])data), true);
    }

    @Override
    public DataBuffer createFloat(int offset, double[] data) {
        return new FloatBuffer(ArrayUtil.toFloats((double[])data), true, offset);
    }

    @Override
    public DataBuffer createInt(int offset, double[] data) {
        return new IntBuffer(ArrayUtil.toInts((double[])data), true, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, float[] data) {
        return new DoubleBuffer(ArrayUtil.toDoubles((float[])data), true, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, float[] data) {
        return new FloatBuffer(data, true, offset);
    }

    @Override
    public DataBuffer createInt(int offset, float[] data) {
        return new IntBuffer(ArrayUtil.toInts((float[])data), true, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, int[] data, boolean copy) {
        return new DoubleBuffer(ArrayUtil.toDoubles((int[])data), true, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, int[] data, boolean copy) {
        return new FloatBuffer(ArrayUtil.toFloats((int[])data), copy, offset);
    }

    @Override
    public DataBuffer createInt(int offset, int[] data, boolean copy) {
        return new IntBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, double[] data, boolean copy) {
        return new DoubleBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, double[] data, boolean copy) {
        return new FloatBuffer(ArrayUtil.toFloats((double[])data), copy, offset);
    }

    @Override
    public DataBuffer createInt(int offset, double[] data, boolean copy) {
        return new IntBuffer(ArrayUtil.toInts((double[])data), copy, offset);
    }

    @Override
    public DataBuffer createDouble(int offset, float[] data, boolean copy) {
        return new DoubleBuffer(ArrayUtil.toDoubles((float[])data), copy, offset);
    }

    @Override
    public DataBuffer createFloat(int offset, float[] data, boolean copy) {
        return new FloatBuffer(data, copy, offset);
    }

    @Override
    public DataBuffer createInt(int offset, float[] data, boolean copy) {
        return new IntBuffer(ArrayUtil.toInts((float[])data), copy, offset);
    }

    @Override
    public DataBuffer createInt(ByteBuffer buffer, int length) {
        return new IntBuffer(buffer, length);
    }

    @Override
    public DataBuffer createFloat(ByteBuffer buffer, int length) {
        return new FloatBuffer(buffer, length);
    }

    @Override
    public DataBuffer createDouble(ByteBuffer buffer, int length) {
        return new DoubleBuffer(buffer, length);
    }

    @Override
    public DataBuffer createDouble(long length) {
        return new DoubleBuffer(length);
    }

    @Override
    public DataBuffer createDouble(long length, boolean initialize) {
        return new DoubleBuffer(length, initialize);
    }

    @Override
    public DataBuffer createFloat(long length) {
        return new FloatBuffer(length);
    }

    @Override
    public DataBuffer createFloat(long length, boolean initialize) {
        return new FloatBuffer(length, initialize);
    }

    @Override
    public DataBuffer createInt(long length) {
        return new IntBuffer(length);
    }

    @Override
    public DataBuffer createInt(long length, boolean initialize) {
        return new IntBuffer(length, initialize);
    }

    @Override
    public DataBuffer createDouble(int[] data) {
        return this.createDouble(data, true);
    }

    @Override
    public DataBuffer createFloat(int[] data) {
        return this.createFloat(data, true);
    }

    @Override
    public DataBuffer createInt(int[] data) {
        return this.createInt(data, true);
    }

    @Override
    public DataBuffer createDouble(double[] data) {
        return this.createDouble(data, true);
    }

    @Override
    public DataBuffer createDouble(byte[] data, int length) {
        return new DoubleBuffer(ByteBuffer.wrap(data), length);
    }

    @Override
    public DataBuffer createFloat(byte[] data, int length) {
        return new FloatBuffer(ByteBuffer.wrap(data), length);
    }

    @Override
    public DataBuffer createFloat(double[] data) {
        return this.createFloat(data, true);
    }

    @Override
    public DataBuffer createInt(double[] data) {
        return this.createInt(data, true);
    }

    @Override
    public DataBuffer createDouble(float[] data) {
        return this.createDouble(data, true);
    }

    @Override
    public DataBuffer createFloat(float[] data) {
        return this.createFloat(data, true);
    }

    @Override
    public DataBuffer createInt(float[] data) {
        return this.createInt(data, true);
    }

    @Override
    public DataBuffer createDouble(int[] data, boolean copy) {
        return new DoubleBuffer(ArrayUtil.toDoubles((int[])data), copy);
    }

    @Override
    public DataBuffer createFloat(int[] data, boolean copy) {
        return new FloatBuffer(ArrayUtil.toFloats((int[])data), copy);
    }

    @Override
    public DataBuffer createInt(int[] data, boolean copy) {
        return new IntBuffer(data, copy);
    }

    @Override
    public DataBuffer createDouble(double[] data, boolean copy) {
        return new DoubleBuffer(data, copy);
    }

    @Override
    public DataBuffer createFloat(double[] data, boolean copy) {
        return new FloatBuffer(ArrayUtil.toFloats((double[])data), copy);
    }

    @Override
    public DataBuffer createInt(double[] data, boolean copy) {
        return new IntBuffer(ArrayUtil.toInts((double[])data), copy);
    }

    @Override
    public DataBuffer createDouble(float[] data, boolean copy) {
        return new DoubleBuffer(data, copy);
    }

    @Override
    public DataBuffer createFloat(float[] data, boolean copy) {
        return new FloatBuffer(data, copy);
    }

    @Override
    public DataBuffer createInt(float[] data, boolean copy) {
        return new IntBuffer(ArrayUtil.toInts((float[])data), copy);
    }

    @Override
    public DataBuffer create(Pointer pointer, DataBuffer.Type type, long length, Indexer indexer) {
        switch (type) {
            case INT: {
                return new IntBuffer(pointer, indexer, length);
            }
            case DOUBLE: {
                return new DoubleBuffer(pointer, indexer, length);
            }
            case FLOAT: {
                return new FloatBuffer(pointer, indexer, length);
            }
        }
        throw new IllegalArgumentException("Invalid type " + (Object)((Object)type));
    }

    @Override
    public DataBuffer createHalf(long length) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(long length, boolean initialize) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(float[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(double[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, double[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, float[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, int[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, double[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, float[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, int[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, byte[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int[] data, boolean copy) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(float[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(double[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int[] data) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, byte[] data, int length) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(int offset, int length) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(ByteBuffer buffer, int length) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }

    @Override
    public DataBuffer createHalf(byte[] data, int length) {
        throw new UnsupportedOperationException("FP16 isn't supported for CPU yet");
    }
}

