/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.AbsValueGreaterOrEqualsThan;
import org.nd4j.linalg.indexing.conditions.AbsValueGreaterThan;
import org.nd4j.linalg.indexing.conditions.AbsValueLessOrEqualsThan;
import org.nd4j.linalg.indexing.conditions.AbsValueLessThan;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.EpsilonEquals;
import org.nd4j.linalg.indexing.conditions.EpsilonNotEquals;
import org.nd4j.linalg.indexing.conditions.EqualsCondition;
import org.nd4j.linalg.indexing.conditions.GreaterThan;
import org.nd4j.linalg.indexing.conditions.GreaterThanOrEqual;
import org.nd4j.linalg.indexing.conditions.IsFinite;
import org.nd4j.linalg.indexing.conditions.IsInfinite;
import org.nd4j.linalg.indexing.conditions.IsNaN;
import org.nd4j.linalg.indexing.conditions.LessThan;
import org.nd4j.linalg.indexing.conditions.LessThanOrEqual;
import org.nd4j.linalg.indexing.conditions.NotEqualsCondition;
import org.nd4j.linalg.indexing.conditions.NotFinite;

public class Conditions {
    public static Condition isInfinite() {
        return new IsInfinite();
    }

    public static Condition isNan() {
        return new IsNaN();
    }

    public static Condition isFinite() {
        return new IsFinite();
    }

    public static Condition notFinite() {
        return new NotFinite();
    }

    public static Condition epsNotEquals() {
        return Conditions.epsNotEquals(0.0);
    }

    public static Condition epsNotEquals(Number value) {
        return new EpsilonNotEquals(value);
    }

    public static Condition epsEquals() {
        return Conditions.epsEquals(0.0);
    }

    public static Condition epsEquals(Number value) {
        return Conditions.epsEquals(value, Nd4j.EPS_THRESHOLD);
    }

    public static Condition epsEquals(Number value, Number epsilon) {
        return new EpsilonEquals(value, epsilon.doubleValue());
    }

    public static Condition equals() {
        return Conditions.equals(0.0);
    }

    public static Condition equals(Number value) {
        return new EqualsCondition(value);
    }

    public static Condition notEquals() {
        return Conditions.notEquals(0.0);
    }

    public static Condition notEquals(Number value) {
        return new NotEqualsCondition(value);
    }

    public static Condition greaterThan() {
        return Conditions.greaterThan(0.0);
    }

    public static Condition greaterThan(Number value) {
        return new GreaterThan(value);
    }

    public static Condition lessThan() {
        return Conditions.lessThan(0.0);
    }

    public static Condition lessThan(Number value) {
        return new LessThan(value);
    }

    public static Condition lessThanOrEqual() {
        return Conditions.lessThanOrEqual(0.0);
    }

    public static Condition lessThanOrEqual(Number value) {
        return new LessThanOrEqual(value);
    }

    public static Condition greaterThanOrEqual() {
        return Conditions.greaterThanOrEqual(0.0);
    }

    public static Condition greaterThanOrEqual(Number value) {
        return new GreaterThanOrEqual(value);
    }

    public static Condition absGreaterThanOrEqual() {
        return Conditions.absGreaterThanOrEqual(0.0);
    }

    public static Condition absGreaterThanOrEqual(Number value) {
        return new AbsValueGreaterOrEqualsThan(value);
    }

    public static Condition absLessThanOrEqual() {
        return Conditions.absLessThanOrEqual(0.0);
    }

    public static Condition absLessThanOrEqual(Number value) {
        return new AbsValueLessOrEqualsThan(value);
    }

    public static Condition absGreaterThan() {
        return Conditions.absGreaterThan(0.0);
    }

    public static Condition absGreaterThan(Number value) {
        return new AbsValueGreaterThan(value);
    }

    public static Condition absLessThan() {
        return Conditions.absLessThan(0.0);
    }

    public static Condition absLessThan(Number value) {
        return new AbsValueLessThan(value);
    }
}

