/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.primitives.Triple;
import org.nd4j.common.tools.PropertyParser;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.context.Nd4jContext;
import org.nd4j.graph.FlatArray;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.MemoryManager;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.MemoryWorkspaceManager;
import org.nd4j.linalg.api.memory.deallocation.DeallocatorService;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.ShapeInfoProvider;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMax;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMin;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.api.ops.impl.scalar.ReplaceNans;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.shape.Stack;
import org.nd4j.linalg.api.ops.impl.shape.Tile;
import org.nd4j.linalg.api.ops.impl.transforms.Pad;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Reverse;
import org.nd4j.linalg.api.ops.random.custom.RandomExponential;
import org.nd4j.linalg.api.ops.random.impl.BernoulliDistribution;
import org.nd4j.linalg.api.ops.random.impl.BinomialDistribution;
import org.nd4j.linalg.api.ops.random.impl.Choice;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.Linspace;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.api.rng.DefaultRandom;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.rng.distribution.factory.DefaultDistributionFactory;
import org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.compression.BasicNDArrayCompressor;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.convolution.DefaultConvolutionInstance;
import org.nd4j.linalg.env.EnvironmentalAction;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.ND4JUnknownDataTypeException;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.Environment;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.factory.RandomFactory;
import org.nd4j.linalg.factory.ops.NDBitwise;
import org.nd4j.linalg.factory.ops.NDCNN;
import org.nd4j.linalg.factory.ops.NDImage;
import org.nd4j.linalg.factory.ops.NDLoss;
import org.nd4j.linalg.factory.ops.NDMath;
import org.nd4j.linalg.factory.ops.NDNN;
import org.nd4j.linalg.factory.ops.NDRNN;
import org.nd4j.linalg.factory.ops.NDRandom;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.LongUtils;
import org.nd4j.shade.guava.primitives.Ints;
import org.nd4j.shade.guava.primitives.Longs;
import org.nd4j.versioncheck.VersionCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nd4j {
    private static final Logger log = LoggerFactory.getLogger(Nd4j.class);
    public static final NDBitwise bitwise = new NDBitwise();
    public static final NDMath math = new NDMath();
    public static final NDRandom random = new NDRandom();
    public static final NDNN nn = new NDNN();
    public static final NDLoss loss = new NDLoss();
    public static final NDCNN cnn = new NDCNN();
    public static final NDRNN rnn = new NDRNN();
    public static final NDImage image = new NDImage();
    private static final String DATA_BUFFER_OPS = "databufferfactory";
    private static final String CONVOLUTION_OPS = "convops";
    @Deprecated
    public static final String DTYPE = "dtype";
    private static final String BLAS_OPS = "blas.ops";
    public static final String NATIVE_OPS = "native.ops";
    private static final String ORDER_KEY = "ndarray.order";
    private static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    private static final String OP_EXECUTIONER = "opexec";
    public static final String DISTRIBUTION = "dist";
    private static final String SHAPEINFO_PROVIDER = "shapeinfoprovider";
    private static final String CONSTANT_PROVIDER = "constantsprovider";
    private static final String AFFINITY_MANAGER = "affinitymanager";
    private static final String COMPRESSION_DEBUG = "compressiondebug";
    private static final String MEMORY_MANAGER = "memorymanager";
    private static final String WORKSPACE_MANAGER = "workspacemanager";
    private static final String RANDOM_PROVIDER = "random";
    @Deprecated
    public static final String LOG_INIT_ENV_PROPERTY = "org.nd4j.log.initialization";
    protected static DataType dtype = DataType.FLOAT;
    public static DataBuffer.AllocationMode alloc = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
    public static double EPS_THRESHOLD = 1.0E-5;
    private static boolean allowsOrder = false;
    public static boolean compressDebug = false;
    public static volatile boolean preventUnpack;
    public static Nd4jBackend backend;
    public static RandomFactory randomFactory;
    private static MemoryWorkspaceManager workspaceManager;
    private static DeallocatorService deallocatorService;
    private static AtomicReference<DataType> defaultFloatingPointDataType;
    private static DataBufferFactory DATA_BUFFER_FACTORY_INSTANCE;
    private static BlasWrapper BLAS_WRAPPER_INSTANCE;
    protected static NDArrayFactory INSTANCE;
    private static ConvolutionInstance CONVOLUTION_INSTANCE;
    private static OpExecutioner OP_EXECUTIONER_INSTANCE;
    private static DistributionFactory DISTRIBUTION_FACTORY;
    private static ShapeInfoProvider shapeInfoProvider;
    private static ConstantHandler constantHandler;
    private static AffinityManager affinityManager;
    private static MemoryManager memoryManager;
    private static AtomicBoolean fallbackMode;
    protected static Properties props;
    private static final java.util.logging.Logger logger;
    private static final INDArray[] EMPTY_ARRAYS;

    public static NDBitwise bitwise() {
        return bitwise;
    }

    public static NDMath math() {
        return math;
    }

    public static NDRandom random() {
        return random;
    }

    public static NDNN nn() {
        return nn;
    }

    public static NDLoss loss() {
        return loss;
    }

    public static NDCNN cnn() {
        return cnn;
    }

    public static NDRNN rnn() {
        return rnn;
    }

    public static NDImage image() {
        return image;
    }

    public static INDArray pad(@NonNull INDArray toPad, @NonNull int[][] padWidth) {
        if (toPad == null) {
            throw new NullPointerException("toPad is marked non-null but is null");
        }
        if (padWidth == null) {
            throw new NullPointerException("padWidth is marked non-null but is null");
        }
        return Nd4j.pad(toPad, Nd4j.createFromArray(padWidth));
    }

    public static INDArray pad(@NonNull INDArray toPad, int ... padWidth) {
        if (toPad == null) {
            throw new NullPointerException("toPad is marked non-null but is null");
        }
        if (padWidth == null) {
            throw new NullPointerException("padWidth is marked non-null but is null");
        }
        return Nd4j.pad(toPad, padWidth, Pad.Mode.CONSTANT, 0.0);
    }

    public static INDArray pad(INDArray toPad, INDArray padding) {
        return Nd4j.pad(toPad, padding, Pad.Mode.CONSTANT, 0.0);
    }

    public static INDArray pad(@NonNull INDArray toPad, @NonNull int[][] padWidth, @NonNull Pad.Mode padMode, double padValue) {
        if (toPad == null) {
            throw new NullPointerException("toPad is marked non-null but is null");
        }
        if (padWidth == null) {
            throw new NullPointerException("padWidth is marked non-null but is null");
        }
        if (padMode == null) {
            throw new NullPointerException("padMode is marked non-null but is null");
        }
        return Nd4j.pad(toPad, Nd4j.createFromArray(padWidth), padMode, padValue);
    }

    public static INDArray pad(@NonNull INDArray toPad, @NonNull int[] padWidth, @NonNull Pad.Mode padMode, double padValue) {
        if (toPad == null) {
            throw new NullPointerException("toPad is marked non-null but is null");
        }
        if (padWidth == null) {
            throw new NullPointerException("padWidth is marked non-null but is null");
        }
        if (padMode == null) {
            throw new NullPointerException("padMode is marked non-null but is null");
        }
        int[][] pads = new int[toPad.rank()][padWidth.length];
        for (int i = 0; i < pads.length; ++i) {
            pads[i] = padWidth;
        }
        return Nd4j.pad(toPad, pads, padMode, padValue);
    }

    public static INDArray pad(@NonNull INDArray toPad, @NonNull INDArray padWidth, @NonNull Pad.Mode padMode, double padValue) {
        if (toPad == null) {
            throw new NullPointerException("toPad is marked non-null but is null");
        }
        if (padWidth == null) {
            throw new NullPointerException("padWidth is marked non-null but is null");
        }
        if (padMode == null) {
            throw new NullPointerException("padMode is marked non-null but is null");
        }
        Preconditions.checkArgument(((long)toPad.rank() == padWidth.size(0) ? 1 : 0) != 0, (String)"Must provide padding values for each dimension.  Expected %s pairs for a rank %s array, got %s", (long)toPad.rank(), (long)toPad.rank(), (long)padWidth.size(0));
        long[] newShape = new long[toPad.rank()];
        for (int i = 0; i < newShape.length; ++i) {
            newShape[i] = toPad.size(i) + (long)padWidth.getRow(i).sumNumber().intValue();
        }
        INDArray out = Nd4j.createUninitialized(toPad.dataType(), newShape);
        Pad op = new Pad(toPad, padWidth, out, padMode, padValue);
        return Nd4j.getExecutioner().exec(op)[0];
    }

    public static INDArray append(INDArray arr, int padAmount, double val, int axis) {
        return Nd4j.appendImpl(arr, padAmount, val, axis, true);
    }

    public static INDArray prepend(INDArray arr, int padAmount, double val, int axis) {
        return Nd4j.appendImpl(arr, padAmount, val, axis, false);
    }

    private static INDArray appendImpl(INDArray arr, int padAmount, double val, int axis, boolean appendFlag) {
        if (padAmount == 0) {
            return arr;
        }
        long[] paShape = ArrayUtil.copy((long[])arr.shape());
        if (axis < 0) {
            axis += arr.shape().length;
        }
        paShape[axis] = padAmount;
        INDArray concatArray = Nd4j.valueArrayOf(paShape, val, arr.dataType());
        return appendFlag ? Nd4j.concat(axis, arr, concatArray) : Nd4j.concat(axis, concatArray, arr);
    }

    public static INDArray expandDims(INDArray input, int dimension) {
        if (dimension < 0) {
            dimension += input.rank();
        }
        long[] shape = input.shape();
        long[] indexes = new long[input.rank() + 1];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i < dimension ? shape[i] : (i == dimension ? 1L : shape[i - 1]);
        }
        return input.reshape(input.ordering(), indexes);
    }

    public static INDArray squeeze(INDArray input, int dimension) {
        long[] shape;
        if (dimension < 0) {
            dimension += input.rank();
        }
        Preconditions.checkState(((shape = input.shape())[dimension] == 1L ? 1 : 0) != 0, (String)String.format("Squeeze: Only dimension of size 1 can be squeezed. Attempted to squeeze dimension %d of array with shape %s (size %d).", dimension, ArrayUtils.toString((Object)shape), shape[dimension]));
        long[] newShape = ArrayUtil.removeIndex((long[])shape, (int)dimension);
        return input.reshape(input.ordering(), newShape);
    }

    public static boolean allowsSpecifyOrdering() {
        return allowsOrder;
    }

    public static void shuffle(INDArray toShuffle, Random random, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        INSTANCE.shuffle(toShuffle, random, dimension);
    }

    public static void shuffle(INDArray toShuffle, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, Random rnd, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        INSTANCE.shuffle(toShuffle, rnd, dimension);
    }

    public static void shuffle(List<INDArray> toShuffle, Random rnd, List<int[]> dimensions) {
        INSTANCE.shuffle(toShuffle, rnd, dimensions);
    }

    public static DistributionFactory getDistributions() {
        return DISTRIBUTION_FACTORY;
    }

    public static org.nd4j.linalg.api.rng.Random getRandom() {
        return randomFactory.getRandom();
    }

    public static RandomFactory getRandomFactory() {
        return randomFactory;
    }

    public static ConvolutionInstance getConvolution() {
        return CONVOLUTION_INSTANCE;
    }

    public static void setConvolution(ConvolutionInstance convolutionInstance) {
        if (convolutionInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        CONVOLUTION_INSTANCE = convolutionInstance;
    }

    public static long[] shape(INDArray arr) {
        return arr.shape();
    }

    public static INDArray create(int[] sliceShape, float[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.createUninitialized(DataType.FLOAT, ArrayUtil.toLongArray((int[])ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape})));
        int i = 0;
        while ((long)i < ret.slices()) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(ArrayUtil.toLongArray((int[])sliceShape)));
            ++i;
        }
        return ret;
    }

    public static INDArray create(LongShapeDescriptor descriptor) {
        return Nd4j.create(descriptor, true);
    }

    public static INDArray create(LongShapeDescriptor descriptor, boolean initialize) {
        if (descriptor.isEmpty() && descriptor.rank() == 0) {
            return Nd4j.empty(descriptor.dataType());
        }
        if (initialize) {
            return Nd4j.create(descriptor.dataType(), descriptor.getShape(), descriptor.getStride(), descriptor.getOrder());
        }
        return Nd4j.createUninitialized(descriptor.dataType(), descriptor.getShape(), descriptor.getOrder());
    }

    public static INDArray create(int[] sliceShape, double[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.createUninitialized(DataType.DOUBLE, ArrayUtil.toLongArray((int[])ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape})));
        int i = 0;
        while ((long)i < ret.slices()) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(ArrayUtil.toLongArray((int[])sliceShape)));
            ++i;
        }
        return ret;
    }

    public static Environment getEnvironment() {
        return backend.getEnvironment();
    }

    public static OpExecutioner getExecutioner() {
        return OP_EXECUTIONER_INSTANCE;
    }

    public static DataBufferFactory getDataBufferFactory() {
        return DATA_BUFFER_FACTORY_INSTANCE;
    }

    public static INDArray rollAxis(INDArray a, int axis) {
        return Nd4j.rollAxis(a, axis, 0);
    }

    public static INDArray argMax(INDArray arr, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        IMax imax = new IMax(arr, dimension);
        return Nd4j.getExecutioner().exec(imax);
    }

    public static INDArray argMin(INDArray arr, int ... dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        IMin imin = new IMin(arr, dimension);
        return Nd4j.getExecutioner().exec(imin);
    }

    public static INDArray rollAxis(INDArray a, int axis, int start) {
        if (axis < 0) {
            axis += a.rank();
        }
        if (start < 0) {
            start += a.rank();
        }
        if (axis == start) {
            return a;
        }
        if (axis < start) {
            --start;
        }
        if (axis < 0 || axis >= a.rank()) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        if (start < 0 || axis >= a.rank() + 1) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        ArrayList<Integer> range = new ArrayList<Integer>(Ints.asList((int[])ArrayUtil.range((int)0, (int)a.rank())));
        range.remove(axis);
        range.add(start, axis);
        int[] newRange = Ints.toArray(range);
        return a.permute(newRange);
    }

    public static INDArray tensorMmul(INDArray a, INDArray b, INDArray result, int[][] axes) {
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (a.size(axes[0][i]) != b.size(axes[1][i])) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + a.rank();
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + b.rank();
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < a.rank(); ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat((int[][])new int[][]{Ints.toArray(listA), axes[0]});
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < b.rank(); ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat((int[][])new int[][]{axes[1], Ints.toArray(listB)});
        int n2 = 1;
        int aLength = Math.min(a.rank(), axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 = (int)((long)n2 * a.size(axes[0][i]));
        }
        long[] newShapeA = new long[]{-1L, n2};
        long[] oldShapeA = Nd4j.getOldShape(listA, a);
        int n3 = 1;
        int bNax = Math.min(b.rank(), axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 = (int)((long)n3 * b.size(axes[1][i]));
        }
        long[] newShapeB = new long[]{n3, -1L};
        long[] oldShapeB = Nd4j.getOldShape(listB, b);
        INDArray at = a.permute(newAxesA).reshape(newShapeA);
        INDArray bt = b.permute(newAxesB).reshape(newShapeB);
        INDArray ret = at.mmul(bt, result);
        long[] aPlusB = Longs.concat((long[][])new long[][]{oldShapeA, oldShapeB});
        return ret.reshape(aPlusB);
    }

    private static long[] getOldShape(List<Integer> list, INDArray x) {
        long[] res;
        if (list.size() == 0) {
            res = new long[]{1L};
        } else {
            res = Longs.toArray(list);
            for (int i = 0; i < res.length; ++i) {
                res[i] = x.size((int)res[i]);
            }
        }
        return res;
    }

    public static INDArray tensorMmul(INDArray a, INDArray b, int[][] axes) {
        DynamicCustomOp op = DynamicCustomOp.builder("tensordot").addInputs(a, b).addIntegerArguments((long)axes[0].length).addIntegerArguments(axes[0]).addIntegerArguments((long)axes[1].length).addIntegerArguments(axes[1]).build();
        List<LongShapeDescriptor> l = op.calculateOutputShape();
        INDArray out = Nd4j.create(l.get(0).asDataType(a.dataType()));
        op.addOutputArgument(out);
        Nd4j.exec(op);
        return out;
    }

    public static INDArray gemm(INDArray a, INDArray b, boolean transposeA, boolean transposeB) {
        long cRows = transposeA ? a.columns() : a.rows();
        long cCols = transposeB ? b.rows() : b.columns();
        INDArray c = Nd4j.createUninitialized(a.dataType(), new long[]{cRows, cCols}, (char)(a.ordering() == 'c' && b.ordering() == 'c' ? 99 : 102));
        return Nd4j.gemm(a, b, c, transposeA, transposeB, 1.0, 0.0);
    }

    public static INDArray gemm(INDArray a, INDArray b, INDArray c, boolean transposeA, boolean transposeB, double alpha, double beta) {
        Preconditions.checkArgument((c.elementWiseStride() == 1 ? 1 : 0) != 0, (String)"Nd4j.gemm() C array should NOT be a view");
        Nd4j.exec(new Mmul(a, b, c, alpha, beta, MMulTranspose.builder().transposeA(transposeA).transposeB(transposeB).build()));
        return c;
    }

    public static INDArray matmul(INDArray a, INDArray b, INDArray result, boolean transposeA, boolean transposeB, boolean transposeResult) {
        Mmul op = new Mmul(a, b, result, MMulTranspose.builder().transposeA(transposeA).transposeB(transposeB).transposeResult(transposeResult).build());
        return Nd4j.exec(op)[0];
    }

    public static INDArray matmul(INDArray a, INDArray b, INDArray result) {
        Mmul op = new Mmul(a, b, result, null);
        return Nd4j.exec(op)[0];
    }

    public static INDArray matmul(INDArray a, INDArray b, boolean transposeA, boolean transposeB, boolean transposeResult) {
        return Nd4j.matmul(a, b, null, transposeA, transposeB, transposeResult);
    }

    public static INDArray matmul(INDArray a, INDArray b) {
        return Nd4j.matmul(a, b, null);
    }

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static INDArray cumsum(INDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static INDArray max(INDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static INDArray min(INDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static INDArray prod(INDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static INDArray normmax(INDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static INDArray norm2(INDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static INDArray norm1(INDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static INDArray std(INDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static INDArray var(INDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static INDArray sum(INDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static INDArray mean(INDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static INDArray cumsum(INDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static INDArray max(INDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static INDArray min(INDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static INDArray prod(INDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static INDArray normmax(INDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static INDArray norm2(INDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static INDArray norm1(INDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static INDArray std(INDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static INDArray var(INDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static INDArray sum(INDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static INDArray mean(INDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static DataBuffer createBuffer(DataBuffer underlyingBuffer, long offset, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(underlyingBuffer, offset, length);
    }

    public static DataBuffer createBuffer(int[] shape, DataType type, long offset) {
        int length = ArrayUtil.prod((int[])shape);
        return type == DataType.DOUBLE ? Nd4j.createBuffer(new double[length], offset) : Nd4j.createBuffer(new float[length], offset);
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataType type, int length, long offset) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(buffer, type, (long)length, offset);
    }

    public static DataBuffer createBuffer(byte[] data, int length, long offset) {
        DataBuffer ret = Nd4j.dataType() == DataType.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data, length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data, length);
        return ret;
    }

    public static DataBuffer createBuffer(int length, long offset) {
        DataBuffer ret = Nd4j.dataType() == DataType.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, length) : (Nd4j.dataType() == DataType.INT ? DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, length) : (Nd4j.dataType() == DataType.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, length) : (Nd4j.dataType() == DataType.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, length) : null)));
        return ret;
    }

    private static Indexer getIndexerByType(Pointer pointer, DataType dataType) {
        switch (dataType) {
            case UINT64: 
            case LONG: {
                return LongIndexer.create((LongPointer)((LongPointer)pointer));
            }
            case UINT32: 
            case INT: {
                return IntIndexer.create((IntPointer)((IntPointer)pointer));
            }
            case UINT16: {
                return UShortIndexer.create((ShortPointer)((ShortPointer)pointer));
            }
            case SHORT: {
                return ShortIndexer.create((ShortPointer)((ShortPointer)pointer));
            }
            case BYTE: {
                return ByteIndexer.create((BytePointer)((BytePointer)pointer));
            }
            case UBYTE: {
                return UByteIndexer.create((BytePointer)((BytePointer)pointer));
            }
            case BOOL: {
                return BooleanIndexer.create((BooleanPointer)((BooleanPointer)pointer));
            }
            case FLOAT: {
                return FloatIndexer.create((FloatPointer)((FloatPointer)pointer));
            }
            case BFLOAT16: {
                return Bfloat16Indexer.create((ShortPointer)((ShortPointer)pointer));
            }
            case HALF: {
                return HalfIndexer.create((ShortPointer)((ShortPointer)pointer));
            }
            case DOUBLE: {
                return DoubleIndexer.create((DoublePointer)((DoublePointer)pointer));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static DataBuffer createBuffer(@NonNull Pointer pointer, long length, @NonNull DataType dataType) {
        if (pointer == null) {
            throw new NullPointerException("pointer is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Pointer nPointer = Nd4j.getPointer(pointer, dataType);
        return DATA_BUFFER_FACTORY_INSTANCE.create(nPointer, dataType, length, Nd4j.getIndexerByType(nPointer, dataType));
    }

    public static DataBuffer createBuffer(@NonNull Pointer pointer, @NonNull Pointer devicePointer, long length, @NonNull DataType dataType) {
        if (pointer == null) {
            throw new NullPointerException("pointer is marked non-null but is null");
        }
        if (devicePointer == null) {
            throw new NullPointerException("devicePointer is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Pointer nPointer = Nd4j.getPointer(pointer, dataType);
        return DATA_BUFFER_FACTORY_INSTANCE.create(nPointer, devicePointer, dataType, length, Nd4j.getIndexerByType(nPointer, dataType));
    }

    private static Pointer getPointer(@NonNull Pointer pointer, @NonNull DataType dataType) {
        LongPointer nPointer;
        if (pointer == null) {
            throw new NullPointerException("pointer is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        switch (dataType) {
            case UINT64: 
            case LONG: {
                nPointer = new LongPointer(pointer);
                break;
            }
            case UINT32: 
            case INT: {
                nPointer = new IntPointer(pointer);
                break;
            }
            case UINT16: 
            case SHORT: {
                nPointer = new ShortPointer(pointer);
                break;
            }
            case BYTE: {
                nPointer = new BytePointer(pointer);
                break;
            }
            case UBYTE: {
                nPointer = new BytePointer(pointer);
                break;
            }
            case BOOL: {
                nPointer = new BooleanPointer(pointer);
                break;
            }
            case BFLOAT16: 
            case HALF: {
                nPointer = new ShortPointer(pointer);
                break;
            }
            case FLOAT: {
                nPointer = new FloatPointer(pointer);
                break;
            }
            case DOUBLE: {
                nPointer = new DoublePointer(pointer);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
            }
        }
        return nPointer;
    }

    public static DataBuffer createBuffer(float[] data, long offset) {
        return Nd4j.createTypedBuffer(Arrays.copyOfRange(data, (int)offset, data.length), DataType.FLOAT, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBuffer(double[] data, long offset) {
        return Nd4j.createTypedBuffer(Arrays.copyOfRange(data, (int)offset, data.length), DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBuffer(@NonNull int[] shape, @NonNull DataType type) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Nd4j.createBuffer(ArrayUtil.toLongArray((int[])shape), type);
    }

    public static DataBuffer createBuffer(@NonNull long[] shape, @NonNull DataType type) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        long length = Shape.lengthOf(shape);
        switch (type) {
            case BOOL: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createBool(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createBool(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case UBYTE: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createUByte(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createUByte(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case UINT16: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createUShort(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createUShort(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case UINT32: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createUInt(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createUInt(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case UINT64: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createULong(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createULong(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case BYTE: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createByte(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createByte(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case SHORT: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createShort(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createShort(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case INT: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createInt(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case LONG: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createLong(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case HALF: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case BFLOAT16: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createBFloat16(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createBFloat16(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case FLOAT: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
            case DOUBLE: {
                return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, true, Nd4j.getMemoryManager().getCurrentWorkspace());
            }
        }
        throw new UnsupportedOperationException("Cannot create type: " + (Object)((Object)type));
    }

    public static DataBuffer createBufferDetached(int[] shape, DataType type) {
        return Nd4j.createBufferDetachedImpl(Shape.lengthOf(shape), type);
    }

    public static DataBuffer createBufferDetached(long[] shape, DataType type) {
        return Nd4j.createBufferDetachedImpl(Shape.lengthOf(shape), type);
    }

    private static DataBuffer createBufferDetachedImpl(long length, DataType type) {
        switch (type) {
            case DOUBLE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createDouble(length);
            }
            case FLOAT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createFloat(length);
            }
            case HALF: {
                return DATA_BUFFER_FACTORY_INSTANCE.createHalf(length);
            }
            case BFLOAT16: {
                return DATA_BUFFER_FACTORY_INSTANCE.createBFloat16(length);
            }
            case UINT64: {
                return DATA_BUFFER_FACTORY_INSTANCE.createULong(length);
            }
            case LONG: {
                return DATA_BUFFER_FACTORY_INSTANCE.createLong(length);
            }
            case UINT32: {
                return DATA_BUFFER_FACTORY_INSTANCE.createUInt(length);
            }
            case INT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createInt(length);
            }
            case UINT16: {
                return DATA_BUFFER_FACTORY_INSTANCE.createUShort(length);
            }
            case SHORT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createShort(length);
            }
            case UBYTE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createUByte(length);
            }
            case BYTE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createByte(length);
            }
            case BOOL: {
                return DATA_BUFFER_FACTORY_INSTANCE.createBool(length);
            }
        }
        throw new UnsupportedOperationException("Cannot create type: " + (Object)((Object)type));
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataType type, int length) {
        return Nd4j.createBuffer(buffer, type, length, 0L);
    }

    public static DataBuffer createBuffer(int[] data) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createInt(data) : DATA_BUFFER_FACTORY_INSTANCE.createInt(data, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBuffer(long[] data) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createLong(data) : DATA_BUFFER_FACTORY_INSTANCE.createLong(data, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBufferDetached(int[] data) {
        return DATA_BUFFER_FACTORY_INSTANCE.createInt(data);
    }

    public static DataBuffer createBufferDetached(long[] data) {
        return DATA_BUFFER_FACTORY_INSTANCE.createLong(data);
    }

    public static DataBuffer createBuffer(long length) {
        return Nd4j.createBuffer(length, true);
    }

    public static DataBuffer createBuffer(Pointer pointer, DataType type, long length, Indexer indexer) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(pointer, type, length, indexer);
    }

    public static DataBuffer createBuffer(long length, boolean initialize) {
        return Nd4j.createBuffer(Nd4j.dataType(), length, initialize);
    }

    public static DataBuffer createBuffer(DataType dataType, long length, boolean initialize) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, initialize, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBuffer(DataType dataType, long length, boolean initialize, MemoryWorkspace workspace) {
        return workspace == null ? DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, initialize, workspace);
    }

    public static DataBuffer createBuffer(float[] data) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(data) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(data, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createBufferDetached(float[] data) {
        return DATA_BUFFER_FACTORY_INSTANCE.createFloat(data);
    }

    public static DataBuffer createBufferDetached(double[] data) {
        return DATA_BUFFER_FACTORY_INSTANCE.createDouble(data);
    }

    public static DataBuffer createBuffer(double[] data) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(data, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    private static DataBuffer getDataBuffer(int length, DataType dataType) {
        return Nd4j.getMemoryManager().getCurrentWorkspace() == null ? DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)length, false) : DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, false, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static DataBuffer createTypedBuffer(double[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(float[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(int[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(long[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(short[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(byte[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(boolean[] data, DataType dataType) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType);
        buffer.setData(data);
        return buffer;
    }

    private static DataBuffer getDataBuffer(int length, DataType dataType, MemoryWorkspace workspace) {
        return workspace == null ? DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)length, false) : DATA_BUFFER_FACTORY_INSTANCE.create(dataType, length, false, workspace);
    }

    public static DataBuffer createTypedBuffer(double[] data, DataType dataType, MemoryWorkspace workspace) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType, workspace);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBuffer(float[] data, DataType dataType, MemoryWorkspace workspace) {
        DataBuffer buffer = Nd4j.getDataBuffer(data.length, dataType, workspace);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(double[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(float[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(int[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(long[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(short[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(byte[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static DataBuffer createTypedBufferDetached(boolean[] data, DataType dataType) {
        DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.create(dataType, (long)data.length, false);
        buffer.setData(data);
        return buffer;
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static DataType dataType() {
        return DataTypeUtil.getDtypeFromContext();
    }

    @Deprecated
    public static void setDataType(@NonNull DataType dtype) {
        if (dtype == null) {
            throw new NullPointerException("dtype is marked non-null but is null");
        }
        Nd4j.setDefaultDataTypes(dtype, dtype.isFPType() ? dtype : Nd4j.defaultFloatingPointType());
    }

    public static void setDefaultDataTypes(@NonNull DataType defaultType, @NonNull DataType defaultFloatingPointType) {
        if (defaultType == null) {
            throw new NullPointerException("defaultType is marked non-null but is null");
        }
        if (defaultFloatingPointType == null) {
            throw new NullPointerException("defaultFloatingPointType is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)defaultFloatingPointType.isFPType(), (String)"Invalid default floating point type: %s is not a floating point type", (Object)((Object)defaultFloatingPointType));
        DataTypeUtil.setDTypeForContext(defaultType);
        defaultFloatingPointDataType.set(defaultFloatingPointType);
    }

    public static Nd4jBackend getBackend() {
        return backend;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static INDArray[] sortWithIndices(INDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        long nV = ndarray.vectorsAlongDimension(dimension);
        int i = 0;
        while ((long)i < nV) {
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final Double[] data = new Double[(int)vec.length()];
            Double[] index = new Double[(int)vec.length()];
            int j = 0;
            while ((long)j < vec.length()) {
                data[j] = vec.getDouble((long)j);
                index[j] = j;
                ++j;
            }
            Arrays.sort(index, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    int o = (int)o1.doubleValue();
                    int oo2 = (int)o2.doubleValue();
                    return Double.compare(data[o], data[oo2]);
                }
            });
            if (ascending) {
                j = 0;
                while ((long)j < vec.length()) {
                    vec.putScalar((long)j, (double)data[(int)index[j].doubleValue()]);
                    indexVector.putScalar((long)j, (double)index[j]);
                    ++j;
                }
            } else {
                int count = data.length - 1;
                int j2 = 0;
                while ((long)j2 < vec.length()) {
                    int currCount2 = count--;
                    vec.putScalar((long)j2, (double)data[(int)index[currCount2].doubleValue()]);
                    indexVector.putScalar((long)j2, (double)index[currCount2]);
                    ++j2;
                }
            }
            ++i;
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static INDArray sort(INDArray ndarray, boolean ascending) {
        return Nd4j.getNDArrayFactory().sort(ndarray, !ascending);
    }

    public static INDArray sort(INDArray ndarray, int dimension, boolean ascending) {
        return Nd4j.getNDArrayFactory().sort(ndarray, !ascending, dimension);
    }

    public static INDArray sortRows(final INDArray in, final int colIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort rows on non-2d matrix");
        }
        if (colIdx < 0 || colIdx >= in.columns()) {
            throw new IllegalArgumentException("Cannot sort on values in column " + colIdx + ", nCols=" + in.columns());
        }
        INDArray out = Nd4j.create(in.dataType(), in.shape());
        int nRows = in.rows();
        ArrayList<Integer> list = new ArrayList<Integer>(nRows);
        for (i = 0; i < nRows; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble((long)o1.intValue(), (long)colIdx), in.getDouble((long)o2.intValue(), (long)colIdx));
                }
                return -Double.compare(in.getDouble((long)o1.intValue(), (long)colIdx), in.getDouble((long)o2.intValue(), (long)colIdx));
            }
        });
        for (i = 0; i < nRows; ++i) {
            out.putRow(i, in.getRow(((Integer)list.get(i)).intValue()));
        }
        return out;
    }

    public static INDArray sortColumns(final INDArray in, final int rowIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort columns on non-2d matrix");
        }
        if (rowIdx < 0 || rowIdx >= in.rows()) {
            throw new IllegalArgumentException("Cannot sort on values in row " + rowIdx + ", nRows=" + in.rows());
        }
        INDArray out = Nd4j.create(in.shape());
        int nCols = in.columns();
        ArrayList<Integer> list = new ArrayList<Integer>(nCols);
        for (i = 0; i < nCols; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble((long)rowIdx, (long)o1.intValue()), in.getDouble((long)rowIdx, (long)o2.intValue()));
                }
                return -Double.compare(in.getDouble((long)rowIdx, (long)o1.intValue()), in.getDouble((long)rowIdx, (long)o2.intValue()));
            }
        });
        for (i = 0; i < nCols; ++i) {
            out.putColumn(i, in.getColumn(((Integer)list.get(i)).intValue()));
        }
        return out;
    }

    public static INDArray repeat(INDArray n, int num) {
        long[] lArray;
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        long[] nShape = n.shape();
        if (n.isColumnVector()) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = n.shape()[0];
        } else {
            lArray = nShape;
        }
        long[] shape = lArray;
        long[] retShape = Longs.concat((long[][])new long[][]{{num}, shape});
        return Nd4j.create(list, retShape);
    }

    public static INDArray linspace(@NonNull DataType dtype, long lower, long num, long step) {
        if (dtype == null) {
            throw new NullPointerException("dtype is marked non-null but is null");
        }
        if (num == 1L) {
            return Nd4j.scalar(dtype, lower);
        }
        if (dtype.isIntType()) {
            long upper = lower + num * step;
            return Nd4j.linspaceWithCustomOpByRange(lower, upper, num, step, dtype);
        }
        if (dtype.isFPType()) {
            return Nd4j.getExecutioner().exec(new Linspace((double)lower, num, (double)step, dtype));
        }
        throw new IllegalStateException("Illegal data type for linspace: " + dtype.toString());
    }

    public static INDArray linspace(long lower, long upper, long num) {
        return Nd4j.linspace(lower, upper, num, Nd4j.dataType());
    }

    public static INDArray linspace(long lower, long upper, long num, @NonNull DataType dtype) {
        if (dtype == null) {
            throw new NullPointerException("dtype is marked non-null but is null");
        }
        if (lower == upper && num == 1L) {
            return Nd4j.scalar(dtype, lower);
        }
        if (num == 1L) {
            return Nd4j.scalar(dtype, lower);
        }
        if (dtype.isIntType()) {
            return Nd4j.linspaceWithCustomOp(lower, upper, (int)num, dtype);
        }
        if (dtype.isFPType()) {
            return Nd4j.linspace((double)lower, (double)upper, (long)((int)num), dtype);
        }
        throw new IllegalStateException("Illegal data type for linspace: " + dtype.toString());
    }

    public static INDArray linspace(@NonNull DataType dataType, double lower, double step, long num) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Preconditions.checkState((boolean)dataType.isFPType(), (String)"Datatype must be a floating point type for linspace, got %s", (Object)((Object)dataType));
        if (num == 1L) {
            return Nd4j.scalar(dataType, lower);
        }
        return Nd4j.getExecutioner().exec(new Linspace(lower, num, step, dataType));
    }

    public static INDArray linspace(double lower, double upper, long num, @NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        Preconditions.checkState((boolean)dataType.isFPType(), (String)"Datatype must be a floating point type for linspace, got %s", (Object)((Object)dataType));
        if (num == 1L) {
            return Nd4j.scalar(dataType, lower);
        }
        return Nd4j.getExecutioner().exec(new Linspace(lower, upper, num, dataType));
    }

    private static INDArray linspaceWithCustomOp(long lower, long upper, int num, DataType dataType) {
        if (num == 1) {
            return Nd4j.scalar(dataType, lower);
        }
        INDArray result = Nd4j.createUninitialized(dataType, new long[]{num}, Nd4j.order().charValue());
        DynamicCustomOp op = DynamicCustomOp.builder("lin_space").addInputs(Nd4j.scalar(lower), Nd4j.scalar(upper), Nd4j.scalar(num)).addOutputs(result).build();
        Nd4j.getExecutioner().execAndReturn(op);
        return result;
    }

    private static INDArray linspaceWithCustomOpByRange(long lower, long upper, long num, long step, DataType dataType) {
        if (num == 1L) {
            return Nd4j.scalar(dataType, lower);
        }
        INDArray result = Nd4j.createUninitialized(dataType, new long[]{num}, Nd4j.order().charValue());
        DynamicCustomOp op = DynamicCustomOp.builder("range").addInputs(Nd4j.scalar(lower), Nd4j.scalar(upper), Nd4j.scalar(step)).addOutputs(result).build();
        Nd4j.getExecutioner().execAndReturn(op);
        return result;
    }

    public static INDArray[] meshgrid(@NonNull INDArray x, @NonNull INDArray y) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)x.isVectorOrScalar(), (String)"X must be a vector");
        Preconditions.checkArgument((boolean)y.isVectorOrScalar(), (String)"Y must be a vector");
        if (y.dataType() != x.dataType()) {
            y = y.castTo(x.dataType());
        }
        INDArray xOut = Nd4j.createUninitialized(x.dataType(), y.length(), x.length());
        INDArray yOut = Nd4j.createUninitialized(x.dataType(), y.length(), x.length());
        DynamicCustomOp op = DynamicCustomOp.builder("meshgrid").addInputs(x, y).addOutputs(xOut, yOut).build();
        Nd4j.getExecutioner().execAndReturn(op);
        return new INDArray[]{xOut, yOut};
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray toFlattened(char order, Collection<INDArray> matrices) {
        return INSTANCE.toFlattened(order, matrices);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray toFlattened(char order, INDArray ... matrices) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        return INSTANCE.toFlattened(order, matrices);
    }

    public static INDArray eye(long n) {
        return INSTANCE.eye(n);
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static void writeTxt(INDArray write, String filePath, String split, int precision) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath, int precision) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath, String split) {
        Nd4j.writeTxt(write, filePath);
    }

    public static void writeTxt(INDArray write, String filePath) {
        try {
            String toWrite = Nd4j.writeStringForArray(write);
            FileUtils.writeStringToFile((File)new File(filePath), (String)toWrite, (String)null, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing output", e);
        }
    }

    private static String writeStringForArray(INDArray write) {
        if (write.isView() || !Shape.hasDefaultStridesForShape(write)) {
            write = write.dup();
        }
        String format = "0.000000000000000000E0";
        return "{\n\"filefrom\": \"dl4j\",\n\"ordering\": \"" + write.ordering() + "\",\n\"shape\":\t" + Arrays.toString(write.shape()) + ",\n\"data\":\n" + new NDArrayStrings(",", format).format(write, false) + "\n}\n";
    }

    public static void write(OutputStream writer, INDArray write) throws IOException {
        DataOutputStream stream = new DataOutputStream(writer);
        Nd4j.write(write, stream);
        stream.close();
    }

    public static byte[] toByteArray(@NonNull INDArray arr) throws IOException {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        if (arr.length() * (long)arr.data().getElementSize() > Integer.MAX_VALUE) {
            throw new ND4JIllegalStateException("");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(arr.length() * (long)arr.data().getElementSize()));
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        return bos.toByteArray();
    }

    public static INDArray fromByteArray(@NonNull byte[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(arr);
        return Nd4j.read(bis);
    }

    public static INDArray readNumpy(@NonNull InputStream filePath, @NonNull String split) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (split == null) {
            throw new NullPointerException("split is marked non-null but is null");
        }
        return Nd4j.readNumpy(DataType.FLOAT, filePath, split, StandardCharsets.UTF_8);
    }

    public static INDArray readNumpy(@NonNull DataType dataType, @NonNull InputStream filePath, @NonNull String split, @NonNull Charset charset) throws IOException {
        String line;
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (split == null) {
            throw new NullPointerException("split is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(filePath, charset));
        ArrayList<float[]> data2 = new ArrayList<float[]>();
        int numColumns = -1;
        while ((line = reader.readLine()) != null) {
            String[] data = line.trim().split(split);
            if (numColumns < 0) {
                numColumns = data.length;
            } else {
                Preconditions.checkState((data.length == numColumns ? 1 : 0) != 0, (String)"Data has inconsistent number of columns: data length %s, numColumns %s", (int)data.length, (int)numColumns);
            }
            data2.add(Nd4j.readSplit(data));
        }
        float[][] fArr = new float[data2.size()][0];
        for (int i = 0; i < data2.size(); ++i) {
            fArr[i] = (float[])data2.get(i);
        }
        INDArray ret = Nd4j.createFromArray(fArr).castTo(dataType);
        return ret;
    }

    private static float[] readSplit(String[] split) {
        float[] ret = new float[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                ret[i] = Float.parseFloat(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (split[i].equalsIgnoreCase("inf")) {
                    ret[i] = Float.POSITIVE_INFINITY;
                    continue;
                }
                if (split[i].equalsIgnoreCase("-inf")) {
                    ret[i] = Float.NEGATIVE_INFINITY;
                    continue;
                }
                if (split[i].equalsIgnoreCase("nan")) {
                    ret[i] = Float.NaN;
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public static INDArray readNumpy(String filePath, String split) throws IOException {
        return Nd4j.readNumpy(DataType.FLOAT, filePath, split);
    }

    public static INDArray readNumpy(DataType dataType, String filePath, String split) throws IOException {
        try (FileInputStream is = new FileInputStream(filePath);){
            INDArray iNDArray = Nd4j.readNumpy(dataType, is, split, StandardCharsets.UTF_8);
            return iNDArray;
        }
    }

    public static INDArray readNumpy(String filePath) throws IOException {
        return Nd4j.readNumpy(DataType.FLOAT, filePath);
    }

    public static INDArray readNumpy(DataType dataType, String filePath) throws IOException {
        return Nd4j.readNumpy(dataType, filePath, " ");
    }

    public static INDArray read(InputStream reader) {
        return Nd4j.read(new DataInputStream(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INDArray readTxtString(InputStream ndarray) {
        String sep = ",";
        INDArray newArr = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(ndarray));
        LineIterator it = IOUtils.lineIterator((Reader)reader);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        format.setParseBigDecimal(true);
        try {
            int lineNum = 0;
            int tensorNum = 0;
            char theOrder = 'c';
            int rank = 0;
            long[] theShape = null;
            double[] subsetArr = null;
            while (it.hasNext()) {
                String[] lineArr;
                String fileSource;
                String line = it.nextLine();
                ++lineNum;
                if ((line = line.replaceAll("\\s", "")).equals("") || line.equals("}")) continue;
                if (lineNum == 2 && !(fileSource = (lineArr = line.split(":"))[1].replaceAll("\\W", "")).equals("dl4j")) {
                    throw new IllegalArgumentException("Only files written out from Nd4j.writeTxT/writeTxtString can be read with the readTxt/readTxtString methods");
                }
                if (lineNum == 3) {
                    lineArr = line.split(":");
                    theOrder = lineArr[1].replaceAll("\\W", "").charAt(0);
                    continue;
                }
                if (lineNum == 4) {
                    String shapeString = line.split(":")[1].replace("[", "").replace("],", "");
                    if (shapeString.isEmpty()) {
                        newArr = Nd4j.scalar(Nd4j.defaultFloatingPointType(), 0);
                        continue;
                    }
                    String[] shapeArr = shapeString.split(",");
                    rank = shapeArr.length;
                    theShape = new long[rank];
                    for (int i = 0; i < rank; ++i) {
                        theShape[i] = Integer.parseInt(shapeArr[i]);
                    }
                    newArr = theOrder == 'f' && theShape[rank - 1] == 1L ? Nd4j.create(Nd4j.defaultFloatingPointType(), theShape, 'c') : Nd4j.create(Nd4j.defaultFloatingPointType(), theShape, theOrder);
                    subsetArr = new double[(int)theShape[rank - 1]];
                    continue;
                }
                if (lineNum <= 5) continue;
                String[] entries = line.replace("\\],", "").replaceAll("]", "").replaceAll("\\[", "").split(sep);
                if (rank == 0) {
                    try {
                        newArr.addi(format.parse(entries[0]).doubleValue());
                    }
                    catch (ParseException e) {
                        log.error("", (Throwable)e);
                    }
                    continue;
                }
                Preconditions.checkState(((long)entries.length == theShape[rank - 1] ? 1 : 0) != 0, (String)"Invalid number of entries - format does not match expected shape.Expected %s values per line, got %s at line %s", (long)theShape[rank - 1], (long)entries.length, (long)lineNum);
                int i = 0;
                while ((long)i < theShape[rank - 1]) {
                    try {
                        BigDecimal number = (BigDecimal)format.parse(entries[i]);
                        subsetArr[i] = number.doubleValue();
                    }
                    catch (ParseException e) {
                        log.error("", (Throwable)e);
                    }
                    ++i;
                }
                INDArray subTensor = Nd4j.create(subsetArr, new long[]{subsetArr.length}, Nd4j.defaultFloatingPointType());
                newArr.tensorAlongDimension(tensorNum, rank - 1).addi(subTensor);
                ++tensorNum;
            }
            if (theOrder == 'f' && rank > 1 && theShape[rank - 1] == 1L) {
                newArr = newArr.dup('f');
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        if (newArr == null) {
            throw new IllegalStateException("Cannot parse file: file does not appear to represent a text serialized INDArray file");
        }
        return newArr;
    }

    public static INDArray readTxt(String filePath) {
        INDArray iNDArray;
        File file = new File(filePath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            iNDArray = Nd4j.readTxtString(is);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return iNDArray;
    }

    private static int[] toIntArray(int length, DataBuffer buffer) {
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = buffer.getInt(i);
        }
        return ret;
    }

    public static INDArray createArrayFromShapeBuffer(DataBuffer data, DataBuffer shapeInfo) {
        long[] jvmShapeInfo = shapeInfo.asLong();
        DataType dataType = ArrayOptionsHelper.dataType(jvmShapeInfo);
        long[] shape = Shape.shape(jvmShapeInfo);
        long[] strides = Shape.stridesOf(jvmShapeInfo);
        char order = Shape.order(jvmShapeInfo);
        INDArray result = Nd4j.create(data, shape, strides, 0L, order, dataType);
        if (data instanceof CompressedDataBuffer) {
            result.markAsCompressed(true);
        }
        return result;
    }

    public static INDArray createArrayFromShapeBuffer(DataBuffer data, Pair<DataBuffer, long[]> shapeInfo) {
        int rank = Shape.rank((DataBuffer)shapeInfo.getFirst());
        INDArray result = Nd4j.create(data, Nd4j.toIntArray(rank, Shape.shapeOf((DataBuffer)shapeInfo.getFirst())), Nd4j.toIntArray(rank, Shape.stride((DataBuffer)shapeInfo.getFirst())), 0L, Shape.order((DataBuffer)shapeInfo.getFirst()));
        if (data instanceof CompressedDataBuffer) {
            result.markAsCompressed(true);
        }
        return result;
    }

    public static INDArray read(DataInputStream dis) {
        Triple<DataBuffer.AllocationMode, Long, DataType> headerShape = BaseDataBuffer.readHeader(dis);
        DataBuffer shapeInformation = Nd4j.createBufferDetached(new long[]{(Long)headerShape.getMiddle()}, (DataType)((Object)headerShape.getRight()));
        shapeInformation.read(dis, (DataBuffer.AllocationMode)((Object)headerShape.getLeft()), (long)((Long)headerShape.getMiddle()), (DataType)((Object)headerShape.getThird()));
        DataBuffer data = null;
        Triple<DataBuffer.AllocationMode, Long, DataType> headerData = BaseDataBuffer.readHeader(dis);
        try {
            data = CompressedDataBuffer.readUnknown(dis, (DataBuffer.AllocationMode)((Object)headerData.getFirst()), (Long)headerData.getMiddle(), (DataType)((Object)headerData.getRight()));
            ArrayOptionsHelper.dataType(shapeInformation.asLong());
        }
        catch (ND4JUnknownDataTypeException e) {
            DataType type = (DataType)((Object)headerData.getRight());
            long extras = ArrayOptionsHelper.setOptionBit(0L, type);
            shapeInformation.put(shapeInformation.length() - 3L, extras);
        }
        return Nd4j.createArrayFromShapeBuffer(data, shapeInformation);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        if (arr.isView()) {
            arr = arr.dup();
        }
        arr.shapeInfoDataBuffer().write(dataOutputStream);
        arr.data().write(dataOutputStream);
    }

    public static void saveBinary(INDArray arr, File saveTo) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(saveTo));
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        dos.flush();
        dos.close();
        bos.close();
    }

    public static INDArray readBinary(File read) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(read));
        DataInputStream dis = new DataInputStream(bis);
        INDArray ret = Nd4j.read(dis);
        dis.close();
        return ret;
    }

    public static void clearNans(INDArray arr) {
        Nd4j.getExecutioner().exec(new ReplaceNans(arr, EPS_THRESHOLD));
    }

    public static INDArray reverse(INDArray reverse) {
        return Nd4j.getExecutioner().exec(new Reverse(reverse))[0];
    }

    public static INDArray arange(double begin, double end, double step) {
        return INSTANCE.arange(begin, end, step);
    }

    public static INDArray arange(double begin, double end) {
        return INSTANCE.arange(begin, end, 1.0);
    }

    public static INDArray arange(double end) {
        return Nd4j.arange(0.0, end);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static INDArray diag(INDArray x) {
        INDArray ret;
        if (x.isVectorOrScalar() || x.isRowVector() || x.isColumnVector()) {
            ret = Nd4j.create(x.dataType(), x.length(), x.length());
            Nd4j.getExecutioner().execAndReturn(new Diag(x, ret));
        } else {
            ret = Nd4j.createUninitialized(x.dataType(), Math.min(x.size(0), x.size(1)));
            Nd4j.getExecutioner().execAndReturn(new DiagPart(x, ret));
        }
        return ret;
    }

    public static INDArray choice(@NonNull INDArray source, @NonNull INDArray probs, @NonNull INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (probs == null) {
            throw new NullPointerException("probs is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (source.length() != probs.length()) {
            throw new ND4JIllegalStateException("Nd4j.choice() requires lengths of Source and Probs to be equal");
        }
        return Nd4j.getExecutioner().exec(new Choice(source, probs, target), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, INDArray target) {
        return Nd4j.choice(source, probs, target, Nd4j.getRandom());
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (numSamples < 1) {
            throw new ND4JIllegalStateException("Nd4j.choice() numSamples must be positive value");
        }
        return Nd4j.choice(source, probs, Nd4j.createUninitialized((long)numSamples), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples) {
        return Nd4j.choice(source, probs, numSamples, Nd4j.getRandom());
    }

    public static INDArray appendBias(INDArray ... vectors) {
        if (vectors == null) {
            throw new NullPointerException("vectors is marked non-null but is null");
        }
        return INSTANCE.appendBias(vectors);
    }

    public static INDArray rand(int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret);
    }

    public static INDArray rand(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret);
    }

    public static INDArray rand(@NonNull DataType dataType, long ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)dataType.isFPType(), (String)"Can't create a random array of a non-floating point data type");
        INDArray ret = Nd4j.createUninitialized(dataType, shape, Nd4j.order().charValue());
        return Nd4j.rand(ret);
    }

    public static INDArray rand(char order, int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, order);
        return Nd4j.rand(ret);
    }

    @Deprecated
    public static INDArray rand(@NonNull DataType dataType, int[] shape, char order) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return Nd4j.rand(dataType, order, ArrayUtil.toLongArray((int[])shape));
    }

    @Deprecated
    public static INDArray rand(@NonNull DataType dataType, char order, int ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.rand(dataType, order, ArrayUtil.toLongArray((int[])shape));
    }

    public static INDArray rand(@NonNull DataType dataType, char order, long ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(dataType, shape, order);
        return Nd4j.rand(ret);
    }

    public static INDArray rand(@NonNull DataType dataType, int ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(dataType, ArrayUtil.toLongArray((int[])shape), Nd4j.order().charValue());
        return Nd4j.rand(ret);
    }

    public static INDArray rand(long seed, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret, seed);
    }

    @Deprecated
    public static INDArray rand(int[] shape, long seed) {
        return Nd4j.rand(seed, ArrayUtil.toLongArray((int[])shape));
    }

    @Deprecated
    public static INDArray rand(int[] shape, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Nd4j.rand(rng, ArrayUtil.toLongArray((int[])shape));
    }

    public static INDArray rand(@NonNull org.nd4j.linalg.api.rng.Random rng, long ... shape) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret, rng);
    }

    @Deprecated
    public static INDArray rand(int[] shape, @NonNull Distribution dist) {
        if (dist == null) {
            throw new NullPointerException("dist is marked non-null but is null");
        }
        return Nd4j.rand(dist, ArrayUtil.toLongArray((int[])shape));
    }

    @Deprecated
    public static INDArray rand(long[] shape, @NonNull Distribution dist) {
        if (dist == null) {
            throw new NullPointerException("dist is marked non-null but is null");
        }
        return Nd4j.rand(dist, shape);
    }

    public static INDArray rand(@NonNull Distribution dist, long ... shape) {
        if (dist == null) {
            throw new NullPointerException("dist is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return dist.sample(shape);
    }

    public static INDArray rand(int rows, int columns, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        return Nd4j.rand(ret, rng);
    }

    @Deprecated
    public static INDArray rand(int[] shape, double min, double max, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Nd4j.rand(min, max, rng, ArrayUtil.toLongArray((int[])shape));
    }

    @Deprecated
    public static INDArray rand(long[] shape, double min, double max, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret, min, max, rng);
    }

    public static INDArray rand(double min, double max, @NonNull org.nd4j.linalg.api.rng.Random rng, long ... shape) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.rand(ret, min, max, rng);
    }

    public static INDArray randn(INDArray target) {
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), Nd4j.getRandom());
    }

    public static INDArray randn(@NonNull int[] shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.randn(ArrayUtil.toLongArray((int[])shape));
    }

    public static INDArray randn(@NonNull DataType dataType, @NonNull int[] shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.randn(dataType, ArrayUtil.toLongArray((int[])shape));
    }

    public static INDArray randn(@NonNull DataType dataType, long ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(dataType, shape, Nd4j.order().charValue());
        return Nd4j.randn(ret);
    }

    public static INDArray randn(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.randn(ret);
    }

    public static INDArray randn(char order, int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, order);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(char order, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, order);
        return Nd4j.randn(ret);
    }

    public static INDArray randn(@NonNull DataType dataType, char order, long ... shape) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(dataType, shape, order);
        return Nd4j.randn(ret);
    }

    @Deprecated
    public static INDArray randn(long seed, int[] shape) {
        return Nd4j.randn(seed, ArrayUtil.toLongArray((int[])shape));
    }

    public static INDArray randn(long seed, @NonNull long[] shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.randn(ret, seed);
    }

    @Deprecated
    public static INDArray randn(int[] shape, @NonNull org.nd4j.linalg.api.rng.Random r) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        return Nd4j.randn(r, ArrayUtil.toLongArray((int[])shape));
    }

    @Deprecated
    public static INDArray randn(long[] shape, @NonNull org.nd4j.linalg.api.rng.Random r) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        return Nd4j.randn(r, shape);
    }

    public static INDArray randn(@NonNull org.nd4j.linalg.api.rng.Random r, long ... shape) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        return Nd4j.randn(ret, r);
    }

    public static INDArray randn(double mean, double stddev, INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target, mean, stddev), rng);
    }

    public static INDArray randn(double mean, double stddev, long[] shape, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        INDArray target = Nd4j.createUninitialized(shape);
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target, mean, stddev), rng);
    }

    public static INDArray rand(INDArray target) {
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), Nd4j.getRandom());
    }

    public static INDArray rand(INDArray target, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), Nd4j.getRandom());
    }

    public static INDArray rand(INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Nd4j.getExecutioner().exec(new UniformDistribution(target), rng);
    }

    public static INDArray rand(INDArray target, @NonNull Distribution dist) {
        if (dist == null) {
            throw new NullPointerException("dist is marked non-null but is null");
        }
        return dist.sample(target);
    }

    public static INDArray rand(INDArray target, double min, double max, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        if (min > max) {
            throw new IllegalArgumentException("the maximum value supplied is smaller than the minimum");
        }
        return Nd4j.getExecutioner().exec(new UniformDistribution(target, min, max), rng);
    }

    public static INDArray randn(INDArray target, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), Nd4j.getRandom());
    }

    public static INDArray randn(INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng is marked non-null but is null");
        }
        return Nd4j.getExecutioner().exec(new GaussianDistribution(target), rng);
    }

    public static INDArray randomBernoulli(double p, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.randomBernoulli(p, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomBernoulli(double p, @NonNull INDArray target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Invalid probability: must be in range 0 to 1, got %s", (double)p);
        return Nd4j.getExecutioner().exec(new BernoulliDistribution(target, p));
    }

    public static INDArray randomBinomial(int nTrials, double p, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.randomBinomial(nTrials, p, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomBinomial(int nTrials, double p, INDArray target) {
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Invalid probability: must be in range 0 to 1, got %s", (double)p);
        Preconditions.checkArgument((nTrials >= 0 ? 1 : 0) != 0, (String)"Number of trials must be positive: got %s", (int)nTrials);
        return Nd4j.getExecutioner().exec(new BinomialDistribution(target, nTrials, p));
    }

    public static INDArray randomExponential(double lambda, long ... shape) {
        return Nd4j.randomExponential(lambda, Nd4j.createUninitialized(shape));
    }

    public static INDArray randomExponential(double lambda, INDArray target) {
        Preconditions.checkArgument((lambda > 0.0 ? 1 : 0) != 0, (String)"Lambda argument must be >= 0 - got %s", (double)lambda);
        INDArray shapeArr = Nd4j.createFromArray(target.shape());
        RandomExponential r = new RandomExponential(shapeArr, target, lambda);
        Nd4j.exec(r);
        return target;
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(boolean[] data) {
        return INSTANCE.create(data, new long[]{data.length}, new long[]{1L}, DataType.BOOL, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(List<? extends Number> list) {
        INDArray array = Nd4j.create(list.size());
        int cnt = 0;
        if (Nd4j.dataType() == DataType.DOUBLE) {
            for (Number number : list) {
                array.putScalar((long)cnt++, number.doubleValue());
            }
        } else {
            for (Number number : list) {
                array.putScalar((long)cnt++, number.floatValue());
            }
        }
        return array;
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(float[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(float[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(long[][] data) {
        long[] shape = new long[]{data.length, data[0].length};
        return INSTANCE.create(ArrayUtil.flatten((long[][])data), shape, Nd4j.getStrides(shape), DataType.LONG, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(boolean[][] data) {
        long[] shape = new long[]{data.length, data[0].length};
        return INSTANCE.create(ArrayUtil.flatten((boolean[][])data), shape, Nd4j.getStrides(shape), DataType.BOOL, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(boolean[][] data, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return INSTANCE.create(ArrayUtil.flatten((boolean[][])data), shape, Nd4j.getStrides(shape), DataType.BOOL, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((double[][][])data), data.length, data[0].length, data[0][0].length);
    }

    public static INDArray create(float[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((float[][][])data), new long[]{data.length, data[0].length, data[0][0].length});
    }

    public static INDArray create(int[][] data) {
        return Nd4j.createFromArray(data);
    }

    public static INDArray create(int[][][] data) {
        return Nd4j.create(ArrayUtil.flatten((int[][][])data), new int[]{data.length, data[0].length, data[0][0].length});
    }

    public static INDArray create(double[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((double[][][][])data), data.length, data[0].length, data[0][0].length, data[0][0][0].length);
    }

    public static INDArray create(float[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((float[][][][])data), new long[]{data.length, data[0].length, data[0][0].length, data[0][0][0].length});
    }

    public static INDArray create(int[][][][] data) {
        return Nd4j.create(ArrayUtil.flatten((int[][][][])data), new int[]{data.length, data[0].length, data[0][0].length, data[0][0][0].length});
    }

    public static INDArray create(double[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data, char order) {
        return INSTANCE.create(data, order);
    }

    public static INDArray create(double[] data, char order) {
        return INSTANCE.create(data, order);
    }

    public static INDArray create(int columns, char order) {
        return INSTANCE.create(new long[]{columns}, Nd4j.getStrides(new long[]{columns}, order), 0L, order);
    }

    public static INDArray zeros(int columns, char order) {
        return Nd4j.create(columns, order);
    }

    public static INDArray create(int[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(long[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(float[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(short[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(byte[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(boolean[] data, long[] shape, DataType type) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(int[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(long[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(float[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(short[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(byte[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(boolean[] data, long[] shape, long[] strides, char order, DataType type) {
        return INSTANCE.create(data, shape, strides, order, type, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray empty() {
        return Nd4j.empty(Nd4j.dataType());
    }

    public static INDArray empty(DataType type) {
        if (EMPTY_ARRAYS[type.ordinal()] == null) {
            try (MemoryWorkspace ignored = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                INDArray ret;
                Nd4j.EMPTY_ARRAYS[type.ordinal()] = ret = INSTANCE.empty(type);
            }
        }
        return EMPTY_ARRAYS[type.ordinal()];
    }

    public static INDArray create(float[] data, int[] shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.scalar(data[0]);
        }
        if (shape.length == 1 && shape[0] != data.length) {
            throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
        }
        Nd4j.checkShapeValues(data.length, LongUtils.toLongs(shape));
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(float[] data, long ... shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.scalar(data[0]);
        }
        Nd4j.commonCheckCreate(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), DataType.FLOAT, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[] data, long ... shape) {
        if (shape.length == 0 && data.length == 1) {
            return Nd4j.scalar(data[0]);
        }
        Nd4j.commonCheckCreate(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[] data, int[] shape) {
        Nd4j.commonCheckCreate(data.length, LongUtils.toLongs(shape));
        long[] lshape = ArrayUtil.toLongArray((int[])shape);
        return INSTANCE.create(data, lshape, Nd4j.getStrides(lshape, Nd4j.order().charValue()), DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(double[] data, int[] shape, long offset, char ordering) {
        Nd4j.commonCheckCreate(data.length, LongUtils.toLongs(shape));
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    private static void commonCheckCreate(int dataLength, long[] shape) {
        if (shape.length == 1 && shape[0] != (long)dataLength) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + dataLength);
        }
        Nd4j.checkShapeValues(dataLength, shape);
    }

    public static INDArray create(double[] data, long[] shape, long offset, char ordering) {
        Nd4j.commonCheckCreate(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, long offset) {
        Nd4j.commonCheckCreate(data.length, LongUtils.toLongs(shape));
        return INSTANCE.create(data, shape, stride, offset);
    }

    public static INDArray create(List<INDArray> list, int ... shape) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(list, shape);
    }

    public static INDArray create(List<INDArray> list, long ... shape) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(list, shape);
    }

    public static INDArray create(int rows, int columns, int[] stride, long offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        return INSTANCE.create((long)rows, (long)columns, stride, offset);
    }

    public static INDArray zeros(int rows, int columns, int[] stride, long offset) {
        return Nd4j.create(rows, columns, stride, offset);
    }

    public static INDArray create(int[] shape, int[] stride, long offset) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, stride, offset);
    }

    public static INDArray zeros(int[] shape, int[] stride, long offset) {
        return Nd4j.create(shape, stride, offset);
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(long[] shape, long[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride);
    }

    public static INDArray create(int ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray create(long ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray create(DataType type, long ... shape) {
        return Nd4j.create(type, shape, Nd4j.order().charValue());
    }

    public static INDArray create(DataBuffer data, int[] shape, int[] strides, long offset) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(data, shape, strides, offset);
    }

    public static INDArray create(DataBuffer data, long[] shape, long[] strides, long offset) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(data, shape, strides, offset);
    }

    public static INDArray create(DataBuffer data, int[] shape, long offset) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
    }

    public static INDArray create(DataBuffer data, int[] newShape, int[] newStride, long offset, char ordering) {
        Nd4j.checkShapeValues(newShape);
        return INSTANCE.create(data, newShape, newStride, offset, ordering);
    }

    public static INDArray create(DataBuffer data, long[] newShape, long[] newStride, long offset, char ordering) {
        Nd4j.checkShapeValues(newShape);
        return INSTANCE.create(data, newShape, newStride, offset, ordering);
    }

    public static INDArray create(DataBuffer data, long[] newShape, long[] newStride, long offset, long ews, char ordering) {
        Nd4j.checkShapeValues(newShape);
        return INSTANCE.create(data, newShape, newStride, offset, ews, ordering);
    }

    public static INDArray create(DataBuffer data, long[] newShape, long[] newStride, long offset, char ordering, DataType dataType) {
        Nd4j.checkShapeValues(newShape);
        return INSTANCE.create(data, newShape, newStride, offset, ordering, dataType);
    }

    public static INDArray create(DataBuffer data, int ... shape) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(DataBuffer data, long ... shape) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(data, shape);
    }

    public static INDArray create(DataBuffer buffer) {
        return INSTANCE.create(buffer);
    }

    public static INDArray create(int[] shape, DataType dataType) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, dataType, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray zeros(int[] shape, DataType dataType) {
        return Nd4j.create(shape, dataType);
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        Nd4j.commonCheckCreate(data.length, LongUtils.toLongs(shape));
        long[] lshape = ArrayUtil.toLongArray((int[])shape);
        return INSTANCE.create(data, lshape, Nd4j.getStrides(lshape, ordering), ordering, DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        Nd4j.commonCheckCreate(data.length, LongUtils.toLongs(shape));
        return INSTANCE.create(data, shape, ordering);
    }

    public static INDArray create(float[] data, long[] shape, char ordering) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), ordering, DataType.FLOAT);
    }

    public static INDArray create(double[] data, long[] shape, char ordering) {
        Nd4j.checkShapeValues(data.length, shape);
        return INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), ordering, DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(long[] shape, long[] stride, long offset, char ordering) {
        if (shape.length == 0) {
            return Nd4j.scalar(0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, stride, offset, ordering);
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        int[] shape = new int[]{rows, columns};
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, stride, 0L, ordering);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, stride, 0L, ordering);
    }

    public static INDArray create(long[] shape, long[] stride, char ordering) {
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, stride, 0L, ordering);
    }

    public static INDArray create(long rows, long columns, char ordering) {
        return Nd4j.create(new long[]{rows, columns}, ordering);
    }

    public static INDArray zeros(int rows, int columns, char ordering) {
        return Nd4j.create(new int[]{rows, columns}, ordering);
    }

    public static INDArray create(@NonNull int[] shape, char ordering) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        return INSTANCE.create(shape, ordering);
    }

    public static INDArray create(@NonNull long[] shape, char ordering) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, ordering);
    }

    public static INDArray create(DataType dataType, @NonNull long[] shape, long[] strides, char ordering) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(dataType, 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(dataType, shape, strides, ordering, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray create(@NonNull DataType dataType, @NonNull long[] shape, char ordering) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(dataType, 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(dataType, shape, ordering, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static void checkShapeValues(long ... shape) {
        for (long e : shape) {
            if (e >= 0L) continue;
            throw new ND4JIllegalStateException("Invalid shape: Requested INDArray shape " + Arrays.toString(shape) + " contains dimension size values < 0 (all dimensions must be 0 or more)");
        }
    }

    private static void checkShapeValues(int ... shape) {
        Nd4j.checkShapeValues(LongUtils.toLongs(shape));
    }

    private static void checkShapeValues(int length, long ... shape) {
        Nd4j.checkShapeValues(shape);
        if (ArrayUtil.prodLong((long[])shape) != (long)length && (length != 1 || shape.length != 0)) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + length + " - prod(shape) must equal the number of values provided");
        }
    }

    public static INDArray createUninitialized(int[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.createUninitialized(shape, ordering);
    }

    public static INDArray createUninitialized(DataType type, long ... shape) {
        return Nd4j.createUninitialized(type, shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(DataType type, long[] shape, char ordering) {
        if (shape.length == 0) {
            if (type == DataType.UTF8) {
                return Nd4j.scalar("");
            }
            return Nd4j.scalar(type, 0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.createUninitialized(type, shape, ordering, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray createUninitialized(long[] shape, char ordering) {
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.createUninitialized(shape, ordering);
    }

    public static INDArray createUninitialized(int ... shape) {
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 0.0);
        }
        Nd4j.checkShapeValues(shape);
        return Nd4j.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(long ... shape) {
        Nd4j.checkShapeValues(shape);
        return Nd4j.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(long length) {
        long[] shape = new long[]{length};
        return INSTANCE.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitializedDetached(DataType dataType, char ordering, long ... shape) {
        return INSTANCE.createUninitializedDetached(dataType, ordering, shape);
    }

    public static INDArray createUninitializedDetached(DataType dataType, long ... shape) {
        return Nd4j.createUninitializedDetached(dataType, Nd4j.order().charValue(), shape);
    }

    public static INDArray zeros(DataType dataType, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(dataType, 0);
        }
        return INSTANCE.create(dataType, shape, Nd4j.order().charValue(), Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        if (shape.length == 0) {
            return Nd4j.scalar(value);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.valueArrayOf(shape, value);
    }

    public static INDArray valueArrayOf(long[] shape, float value) {
        return Nd4j.valueArrayOf(shape, value, DataType.FLOAT);
    }

    public static INDArray valueArrayOf(long[] shape, int value) {
        return Nd4j.valueArrayOf(shape, (double)value, DataType.INT);
    }

    public static INDArray valueArrayOf(long[] shape, double value) {
        if (shape.length == 0) {
            return Nd4j.scalar(value);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.valueArrayOf(shape, value);
    }

    public static INDArray valueArrayOf(long[] shape, double value, DataType type) {
        if (shape.length == 0) {
            return Nd4j.scalar(type, value);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = Nd4j.createUninitialized(type, shape);
        ret.assign(value);
        return ret;
    }

    public static INDArray valueArrayOf(long[] shape, long value, DataType type) {
        if (shape.length == 0) {
            return Nd4j.scalar(type, value);
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = Nd4j.createUninitialized(type, shape);
        ret.assign(value);
        return ret;
    }

    public static INDArray valueArrayOf(long num, double value) {
        return INSTANCE.valueArrayOf(new long[]{num}, value);
    }

    public static INDArray valueArrayOf(long rows, long columns, double value) {
        return INSTANCE.valueArrayOf(rows, columns, value);
    }

    public static INDArray zerosLike(INDArray arr) {
        return Nd4j.zeros(arr.dataType(), arr.shape());
    }

    public static INDArray onesLike(INDArray arr) {
        return Nd4j.ones(arr.dataType(), arr.shape());
    }

    public static INDArray ones(DataType dataType, long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(dataType, 1.0);
        }
        INDArray ret = INSTANCE.createUninitialized(dataType, shape, Nd4j.order().charValue(), Nd4j.getMemoryManager().getCurrentWorkspace());
        ret.assign(1);
        return ret;
    }

    public static INDArray hstack(INDArray ... arrs) {
        if (arrs == null) {
            throw new NullPointerException("arrs is marked non-null but is null");
        }
        return INSTANCE.hstack(arrs);
    }

    public static INDArray hstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        return INSTANCE.hstack(arrays);
    }

    public static INDArray vstack(INDArray ... arrs) {
        if (arrs == null) {
            throw new NullPointerException("arrs is marked non-null but is null");
        }
        Preconditions.checkState((arrs != null && arrs.length > 0 ? 1 : 0) != 0, (String)"No input specified to vstack (null or length 0)");
        if (arrs[0].rank() == 1) {
            return Nd4j.pile(arrs);
        }
        return INSTANCE.vstack(arrs);
    }

    public static INDArray vstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        return Nd4j.vstack(arrays);
    }

    public static INDArray averageAndPropagate(INDArray[] arrays) {
        return INSTANCE.average(arrays);
    }

    public static INDArray averageAndPropagate(Collection<INDArray> arrays) {
        return INSTANCE.average(arrays);
    }

    public static INDArray averageAndPropagate(INDArray target, Collection<INDArray> arrays) {
        return INSTANCE.average(target, arrays);
    }

    public static INDArray stripOnes(INDArray toStrip) {
        if (toStrip.isVector()) {
            return toStrip;
        }
        long[] shape = Shape.squeeze(toStrip.shape());
        return toStrip.reshape(shape);
    }

    public static INDArray accumulate(INDArray ... arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        if (arrays == null || arrays.length == 0) {
            throw new ND4JIllegalStateException("Input for accumulation is null or empty");
        }
        return Nd4j.accumulate(Nd4j.create(arrays[0].shape(), arrays[0].ordering()), arrays);
    }

    public static INDArray accumulate(INDArray target, Collection<INDArray> arrays) {
        return Nd4j.accumulate(target, arrays.toArray(new INDArray[0]));
    }

    public static INDArray accumulate(INDArray target, INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            return target;
        }
        return Nd4j.factory().accumulate(target, arrays);
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int ... indexes) {
        if (indexes == null) {
            throw new NullPointerException("indexes is marked non-null but is null");
        }
        return Nd4j.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        if (sourceDimension >= source.rank()) {
            throw new IllegalStateException("Source dimension can't be higher the rank of source tensor");
        }
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Indexes shouldn't be empty");
        }
        if (order != 'c' && order != 'f' && order != 'a') {
            throw new IllegalStateException("Unknown order being passed in [" + order + "]");
        }
        for (int idx : indexes) {
            if (idx >= 0 && (long)idx < source.shape()[source.rank() - sourceDimension - 1]) continue;
            throw new IllegalStateException("Index can't be < 0 and >= " + source.shape()[source.rank() - sourceDimension - 1]);
        }
        Preconditions.checkArgument((source.rank() > 1 ? 1 : 0) != 0, (String)"pullRows() can't operate on 0D/1D arrays");
        return INSTANCE.pullRows(source, sourceDimension, indexes, order);
    }

    public static INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, int ... indexes) {
        if (indexes == null) {
            throw new NullPointerException("indexes is marked non-null but is null");
        }
        if (sourceDimension >= source.rank()) {
            throw new IllegalStateException("Source dimension can't be higher the rank of source tensor");
        }
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Indexes shouldn't be empty");
        }
        for (int idx : indexes) {
            if (idx >= 0 && (long)idx < source.shape()[source.rank() - sourceDimension - 1]) continue;
            throw new IllegalStateException("Index can't be < 0 and >= " + source.shape()[source.rank() - sourceDimension - 1]);
        }
        Preconditions.checkArgument((source.rank() > 1 ? 1 : 0) != 0, (String)"pullRows() can't operate on 0D/1D arrays");
        return INSTANCE.pullRows(source, destination, sourceDimension, indexes);
    }

    public static INDArray stack(int axis, INDArray ... values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        Preconditions.checkArgument((values != null && values.length > 0 ? 1 : 0) != 0, (String)"No inputs: %s", (Object[])values);
        Preconditions.checkState((axis >= -(values[0].rank() + 1) && axis < values[0].rank() + 1 ? 1 : 0) != 0, (String)"Invalid axis: must be between %s (inclusive) and %s (exclusive) for rank %s input, got %s", (int)(-(values[0].rank() + 1)), (int)(values[0].rank() + 1), (int)values[0].rank(), (int)axis);
        Stack stack = new Stack(values, null, axis);
        INDArray[] outputArrays = Nd4j.getExecutioner().allocateOutputArrays(stack);
        stack.addOutputArgument(outputArrays);
        Nd4j.getExecutioner().execAndReturn(stack);
        return outputArrays[0];
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat == null) {
            throw new NullPointerException("toConcat is marked non-null but is null");
        }
        if (dimension < 0) {
            dimension += toConcat[0].rank();
        }
        return INSTANCE.concat(dimension, toConcat);
    }

    public static INDArray specialConcat(int dimension, INDArray ... toConcat) {
        if (toConcat == null) {
            throw new NullPointerException("toConcat is marked non-null but is null");
        }
        return INSTANCE.specialConcat(dimension, toConcat);
    }

    public static INDArray zeros(int[] shape, char order) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, order);
    }

    public static INDArray zeros(long[] shape, char order) {
        Nd4j.checkShapeValues(shape);
        return INSTANCE.create(shape, order);
    }

    public static INDArray zeros(int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.create(shape);
    }

    public static INDArray zeros(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.create(shape);
    }

    public static INDArray ones(int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return shape.length == 0 ? Nd4j.scalar(Nd4j.dataType(), 1.0) : INSTANCE.ones(shape);
    }

    public static INDArray ones(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (shape.length == 0) {
            return Nd4j.scalar(Nd4j.dataType(), 1.0);
        }
        Nd4j.checkShapeValues(shape);
        return INSTANCE.ones(shape);
    }

    public static INDArray scalar(Number value) {
        return INSTANCE.scalar(value);
    }

    public static INDArray scalar(DataType dataType, Number value) {
        MemoryWorkspace ws = Nd4j.getMemoryManager().getCurrentWorkspace();
        switch (dataType) {
            case DOUBLE: {
                return INSTANCE.create(new double[]{value.doubleValue()}, new long[0], new long[0], dataType, ws);
            }
            case FLOAT: 
            case BFLOAT16: 
            case HALF: {
                return INSTANCE.create(new float[]{value.floatValue()}, new long[0], new long[0], dataType, ws);
            }
            case UINT32: 
            case INT: {
                return INSTANCE.create(new int[]{value.intValue()}, new long[0], new long[0], dataType, ws);
            }
            case UINT64: 
            case LONG: {
                return INSTANCE.create(new long[]{value.longValue()}, new long[0], new long[0], dataType, ws);
            }
            case UINT16: 
            case SHORT: {
                return INSTANCE.create(new short[]{value.shortValue()}, new long[0], new long[0], dataType, ws);
            }
            case BYTE: {
                return INSTANCE.create(new byte[]{value.byteValue()}, new long[0], new long[0], dataType, ws);
            }
            case UBYTE: {
                return INSTANCE.create(new short[]{value.shortValue()}, new long[0], new long[0], dataType, ws);
            }
            case BOOL: {
                return INSTANCE.create(new byte[]{value.byteValue()}, new long[0], new long[0], dataType, ws);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type used: " + (Object)((Object)dataType));
    }

    public static INDArray scalar(double value) {
        return Nd4j.scalar(DataType.DOUBLE, value);
    }

    public static INDArray scalar(float value) {
        return Nd4j.scalar(DataType.FLOAT, Float.valueOf(value));
    }

    public static INDArray scalar(boolean value) {
        return Nd4j.scalar(DataType.BOOL, value ? 1 : 0);
    }

    public static INDArray scalar(int value) {
        return Nd4j.scalar(DataType.INT, value);
    }

    public static INDArray scalar(long value) {
        return Nd4j.scalar(DataType.LONG, value);
    }

    public static int[] getStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((int[])shape);
        }
        return ArrayUtil.calcStrides((int[])shape);
    }

    public static long[] getStrides(long[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((long[])shape);
        }
        return ArrayUtil.calcStrides((long[])shape);
    }

    public static int[] getStrides(int ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static long[] getStrides(long ... shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static INDArray tile(INDArray tile, int ... repeat) {
        if (repeat == null) {
            throw new NullPointerException("repeat is marked non-null but is null");
        }
        return Nd4j.exec(new Tile(new INDArray[]{tile}, new INDArray[0], repeat))[0];
    }

    private synchronized void initContext() {
        try {
            defaultFloatingPointDataType = new AtomicReference();
            defaultFloatingPointDataType.set(DataType.FLOAT);
            Nd4jBackend backend = Nd4jBackend.load();
            this.initWithBackend(backend);
        }
        catch (Nd4jBackend.NoAvailableBackendException e) {
            throw new RuntimeException(e);
        }
    }

    public void initWithBackend(Nd4jBackend backend) {
        VersionCheck.checkVersions();
        try {
            if (System.getProperties().getProperty("backends") != null && !System.getProperties().getProperty("backends").contains(backend.getClass().getName())) {
                return;
            }
            if (!Nd4j.isSupportedPlatform()) {
                Nd4j.showAttractiveMessage(Nd4j.getMessageForUnsupportedPlatform());
                return;
            }
            Nd4j.backend = backend;
            this.updateNd4jContext();
            props = Nd4jContext.getInstance().getConf();
            PropertyParser pp = new PropertyParser(props);
            String otherDtype = pp.toString(DTYPE);
            DataType dataType = otherDtype.equalsIgnoreCase("float") ? DataType.FLOAT : (dtype = otherDtype.equalsIgnoreCase("half") ? DataType.HALF : DataType.DOUBLE);
            if (dtype == DataType.HALF && backend.getClass().getName().equals("CpuBackend")) {
                Nd4j.showAttractiveMessage(this.getMessageForNativeHalfPrecision());
            }
            if (Nd4j.dataType() != dtype) {
                DataTypeUtil.setDTypeForContext(dtype);
            }
            compressDebug = pp.toBoolean(COMPRESSION_DEBUG);
            char ORDER = pp.toChar(ORDER_KEY, 'c');
            Class<?> affinityManagerClazz = Class.forName(pp.toString(AFFINITY_MANAGER));
            affinityManager = (AffinityManager)affinityManagerClazz.newInstance();
            Class<?> ndArrayFactoryClazz = Class.forName(pp.toString(NDARRAY_FACTORY_CLASS));
            Class<?> convolutionInstanceClazz = Class.forName(pp.toString(CONVOLUTION_OPS, DefaultConvolutionInstance.class.getName()));
            String defaultName = pp.toString(DATA_BUFFER_OPS, "org.nd4j.linalg.cpu.nativecpu.buffer.DefaultDataBufferFactory");
            Class<?> dataBufferFactoryClazz = Class.forName(pp.toString(DATA_BUFFER_OPS, defaultName));
            Class<?> shapeInfoProviderClazz = Class.forName(pp.toString(SHAPEINFO_PROVIDER));
            Class<?> constantProviderClazz = Class.forName(pp.toString(CONSTANT_PROVIDER));
            Class<?> memoryManagerClazz = Class.forName(pp.toString(MEMORY_MANAGER));
            allowsOrder = backend.allowsOrder();
            String rand = pp.toString(RANDOM_PROVIDER, DefaultRandom.class.getName());
            Class<?> randomClazz = Class.forName(rand);
            randomFactory = new RandomFactory(randomClazz);
            Class<?> workspaceManagerClazz = Class.forName(pp.toString(WORKSPACE_MANAGER));
            Class<?> blasWrapperClazz = Class.forName(pp.toString(BLAS_OPS));
            String clazzName = pp.toString(DISTRIBUTION, DefaultDistributionFactory.class.getName());
            Class<?> distributionFactoryClazz = Class.forName(clazzName);
            memoryManager = (MemoryManager)memoryManagerClazz.newInstance();
            constantHandler = (ConstantHandler)constantProviderClazz.newInstance();
            shapeInfoProvider = (ShapeInfoProvider)shapeInfoProviderClazz.newInstance();
            workspaceManager = (MemoryWorkspaceManager)workspaceManagerClazz.newInstance();
            Class<?> opExecutionerClazz = Class.forName(pp.toString(OP_EXECUTIONER, DefaultOpExecutioner.class.getName()));
            OP_EXECUTIONER_INSTANCE = (OpExecutioner)opExecutionerClazz.newInstance();
            Constructor<?> c2 = ndArrayFactoryClazz.getConstructor(DataType.class, Character.TYPE);
            INSTANCE = (NDArrayFactory)c2.newInstance(new Object[]{dtype, Character.valueOf(ORDER)});
            CONVOLUTION_INSTANCE = (ConvolutionInstance)convolutionInstanceClazz.newInstance();
            BLAS_WRAPPER_INSTANCE = (BlasWrapper)blasWrapperClazz.newInstance();
            DATA_BUFFER_FACTORY_INSTANCE = (DataBufferFactory)dataBufferFactoryClazz.newInstance();
            DISTRIBUTION_FACTORY = (DistributionFactory)distributionFactoryClazz.newInstance();
            if (this.isFallback()) {
                fallbackMode.set(true);
                Nd4j.showAttractiveMessage(Nd4j.getMessageForFallback());
            } else {
                fallbackMode.set(false);
            }
            String logInitProperty = System.getProperty(LOG_INIT_ENV_PROPERTY, "true");
            if (Boolean.parseBoolean(logInitProperty)) {
                OP_EXECUTIONER_INSTANCE.printEnvironmentInformation();
            }
            ServiceLoader<EnvironmentalAction> actions = ServiceLoader.load(EnvironmentalAction.class);
            HashMap<String, EnvironmentalAction> mappedActions = new HashMap<String, EnvironmentalAction>();
            for (EnvironmentalAction a : actions) {
                if (mappedActions.containsKey(a.targetVariable())) continue;
                mappedActions.put(a.targetVariable(), a);
            }
            for (String e : mappedActions.keySet()) {
                EnvironmentalAction action = (EnvironmentalAction)mappedActions.get(e);
                String value = System.getenv(e);
                if (value == null) continue;
                try {
                    action.process(value);
                }
                catch (Exception e2) {
                    logger.info("Failed to process env variable [" + e + "], got exception: " + e2.toString());
                }
            }
            backend.logBackendInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSupportedPlatform() {
        return System.getProperty("java.vm.name").equalsIgnoreCase("Dalvik") || System.getProperty("os.arch").toLowerCase().startsWith("arm") || System.getProperty("sun.arch.data.model").equals("64");
    }

    private static void showAttractiveMessage(String ... strings) {
        System.out.println(Nd4j.attract(strings));
    }

    private static String attract(String ... strings) {
        String delimiter = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
        String shift = "                 ";
        StringBuilder sb = new StringBuilder().append(delimiter).append("\n").append("\n");
        for (String s : strings) {
            sb.append(shift).append(s).append("\n");
        }
        sb.append("\n").append(delimiter).append("\n");
        return sb.toString();
    }

    private static String[] getMessageForUnsupportedPlatform() {
        return new String[]{"Unfortunately you can't use DL4j/ND4j on 32-bit x86 JVM", "Please, consider running this on 64-bit JVM instead"};
    }

    private static String[] getMessageForFallback() {
        return new String[]{"ND4J_FALLBACK environment variable is detected!", "Performance will be slightly reduced"};
    }

    private String[] getMessageForNativeHalfPrecision() {
        return new String[]{"Half-precision data opType isn't support for nd4j-native", "Please, consider using FLOAT or DOUBLE data opType instead"};
    }

    private void updateNd4jContext() throws IOException {
        try (InputStream is = backend.getConfigurationResource().getInputStream();){
            Nd4jContext.getInstance().updateProperties(is);
        }
    }

    private boolean isFallback() {
        String fallback = System.getenv("ND4J_FALLBACK");
        if (fallback == null) {
            return false;
        }
        return fallback.equalsIgnoreCase("true") || fallback.equalsIgnoreCase("1");
    }

    public static ShapeInfoProvider getShapeInfoProvider() {
        return shapeInfoProvider;
    }

    public static ConstantHandler getConstantHandler() {
        return constantHandler;
    }

    public static AffinityManager getAffinityManager() {
        return affinityManager;
    }

    public static NDArrayFactory getNDArrayFactory() {
        return INSTANCE;
    }

    public static BasicNDArrayCompressor getCompressor() {
        return BasicNDArrayCompressor.getInstance();
    }

    public static MemoryManager getMemoryManager() {
        return memoryManager;
    }

    @Deprecated
    public static int sizeOfDataType() {
        return Nd4j.sizeOfDataType(Nd4j.dataType());
    }

    public static int sizeOfDataType(DataType dtype) {
        switch (dtype) {
            case BYTE: 
            case UBYTE: 
            case BOOL: {
                return 1;
            }
            case UINT16: 
            case SHORT: 
            case BFLOAT16: 
            case HALF: {
                return 2;
            }
            case UINT32: 
            case INT: 
            case FLOAT: {
                return 4;
            }
            case UINT64: 
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new ND4JIllegalStateException("Unsupported data type: [" + (Object)((Object)dtype) + "]");
    }

    public static void enableFallbackMode(boolean reallyEnable) {
        fallbackMode.set(reallyEnable);
    }

    public static boolean isFallbackModeEnabled() {
        return fallbackMode.get();
    }

    public static MemoryWorkspaceManager getWorkspaceManager() {
        return workspaceManager;
    }

    public static INDArray pile(INDArray ... arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        long[] shape = arrays[0].shape();
        long[] newShape = ArrayUtils.add((long[])shape, (int)0, (long)1L);
        ArrayList<INDArray> reshaped = new ArrayList<INDArray>();
        for (INDArray array : arrays) {
            reshaped.add(array.reshape(array.ordering(), newShape));
        }
        return Nd4j.vstack(reshaped);
    }

    public static INDArray pile(@NonNull Collection<INDArray> arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        return Nd4j.pile(arrays.toArray(new INDArray[0]));
    }

    public static INDArray[] tear(INDArray tensor, int ... dimensions) {
        if (dimensions == null) {
            throw new NullPointerException("dimensions is marked non-null but is null");
        }
        if (dimensions.length >= tensor.rank()) {
            throw new ND4JIllegalStateException("Target dimensions number should be less tensor rank");
        }
        for (int dimension : dimensions) {
            if (dimension >= 0) continue;
            throw new ND4JIllegalStateException("Target dimensions can't have negative values");
        }
        return Nd4j.factory().tear(tensor, dimensions);
    }

    public static INDArray triu(INDArray m, int k) {
        INDArray result = Nd4j.createUninitialized(m.shape());
        DynamicCustomOp op = DynamicCustomOp.builder("triu").addInputs(m).addOutputs(result).addIntegerArguments((long)k).build();
        Nd4j.getExecutioner().execAndReturn(op);
        return result;
    }

    public static INDArray tri(int n) {
        return Nd4j.tri(n, n, 0);
    }

    public static INDArray tri(int n, int k) {
        return Nd4j.tri(n, n, k);
    }

    public static INDArray tri(int n, int m, int k) {
        INDArray ret = Nd4j.createUninitialized(n, m);
        DynamicCustomOp op = DynamicCustomOp.builder("tri").addIntegerArguments(n, m, k).addOutputs(ret).build();
        Nd4j.getExecutioner().execAndReturn(op);
        return ret;
    }

    public static INDArray[] where(INDArray condition, INDArray x, INDArray y) {
        Preconditions.checkState((x == null && y == null || x != null && y != null ? 1 : 0) != 0, (String)"Both X and Y must benull, or neither must be null");
        DynamicCustomOp.DynamicCustomOpsBuilder op = DynamicCustomOp.builder("where_np");
        if (x == null) {
            op.addInputs(condition);
        } else {
            if (!x.equalShapes(y) || !x.equalShapes(condition)) {
                Preconditions.throwStateEx((String)"Shapes must be equal: condition=%s, x=%s, y=%s", (Object[])new Object[]{condition.shape(), x.shape(), y.shape()});
            }
            op.addInputs(condition, x, y);
        }
        DynamicCustomOp o = op.build();
        List<LongShapeDescriptor> outShapes = Nd4j.getExecutioner().calculateOutputShape(o);
        INDArray[] outputs = new INDArray[outShapes.size()];
        if (x == null && (outShapes.get(0) == null || outShapes.get(0).getShape().length == 0 || outShapes.get(0).getShape()[0] == 0L)) {
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = Nd4j.empty();
            }
            return outputs;
        }
        for (int i = 0; i < outputs.length; ++i) {
            outputs[i] = Nd4j.create(outShapes.get(i), false);
        }
        op.addOutputs(outputs);
        Nd4j.getExecutioner().execAndReturn(op.build());
        return outputs;
    }

    public static void writeAsNumpy(INDArray arr, File file) throws IOException {
        Nd4j.writeAsNumpy(arr, new FileOutputStream(file));
    }

    public static Pointer convertToNumpy(INDArray arr) {
        return INSTANCE.convertToNumpy(arr);
    }

    public static void writeAsNumpy(INDArray arr, OutputStream writeTo) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(writeTo);){
            Pointer asNumpy = Nd4j.convertToNumpy(arr);
            WritableByteChannel channel = Channels.newChannel(bufferedOutputStream);
            int written = channel.write(asNumpy.asByteBuffer());
            if ((long)written != asNumpy.capacity()) {
                throw new IllegalStateException("Not all bytes were written! Original capacity " + asNumpy.capacity() + " but wrote " + written);
            }
            bufferedOutputStream.flush();
        }
    }

    public static INDArray createFromNpyPointer(Pointer pointer) {
        return INSTANCE.createFromNpyPointer(pointer);
    }

    public static INDArray readNpy(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Nd4j.readNpy(new File(path));
    }

    public static INDArray readNpy(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return Nd4j.createFromNpyFile(file);
    }

    public static INDArray createFromNpyFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File [" + file.getAbsolutePath() + "] doesn't exist");
        }
        return INSTANCE.createFromNpyFile(file);
    }

    public static Map<String, INDArray> createFromNpzFile(File file) throws Exception {
        return INSTANCE.createFromNpzFile(file);
    }

    public static INDArray createNpyFromInputStream(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        byte[] content = IOUtils.toByteArray((InputStream)is);
        return Nd4j.createNpyFromByteArray(content);
    }

    public static INDArray createNpyFromByteArray(@NonNull byte[] input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(input.length);
        byteBuffer.put(input);
        ((Buffer)byteBuffer).rewind();
        Pointer pointer = new Pointer((Buffer)byteBuffer);
        return Nd4j.createFromNpyPointer(pointer);
    }

    public static byte[] toNpyByteArray(INDArray input) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Nd4j.writeAsNumpy(input, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static INDArray createFromFlatArray(FlatArray array) {
        byte dtype = array.dtype();
        byte order = array.byteOrder();
        int rank = (int)array.shape(0);
        long[] shapeInfo = new long[Shape.shapeInfoLength(rank)];
        for (int e = 0; e < shapeInfo.length; ++e) {
            shapeInfo[e] = array.shape(e);
        }
        long[] shapeOf = Shape.shapeOf(shapeInfo);
        DataType _dtype = FlatBuffersMapper.getDataTypeFromByte(dtype);
        if (Shape.isEmpty(shapeInfo)) {
            if (Shape.rank(shapeInfo) == 0) {
                return Nd4j.empty();
            }
            return Nd4j.create(_dtype, shapeOf);
        }
        char ordering = shapeInfo[shapeInfo.length - 1] == 99L ? (char)'c' : 'f';
        long[] stridesOf = Shape.stridesOf(shapeInfo);
        ByteOrder _order = FlatBuffersMapper.getOrderFromByte(order);
        int prod = rank > 0 ? ArrayUtil.prod((long[])shapeOf) : 1;
        ByteBuffer bb = array.bufferAsByteBuffer();
        switch (_dtype) {
            case DOUBLE: {
                double[] doubles = new double[prod];
                DoubleBuffer db = bb.order(_order).asDoubleBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = db.get(e);
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.DOUBLE);
            }
            case FLOAT: {
                float[] doubles = new float[prod];
                FloatBuffer fb = bb.order(_order).asFloatBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = fb.get(e);
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.FLOAT);
            }
            case HALF: {
                float[] doubles = new float[prod];
                ShortBuffer sb = bb.order(_order).asShortBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = HalfIndexer.toFloat((int)sb.get(e));
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.HALF);
            }
            case INT: {
                int[] doubles = new int[prod];
                IntBuffer sb = bb.order(_order).asIntBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = sb.get(e);
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.INT);
            }
            case LONG: {
                long[] doubles = new long[prod];
                LongBuffer sb = bb.order(_order).asLongBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = sb.get(e);
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.LONG);
            }
            case SHORT: {
                short[] doubles = new short[prod];
                ShortBuffer sb = bb.order(_order).asShortBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = sb.get(e);
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.SHORT);
            }
            case BYTE: {
                byte[] bytes = new byte[prod];
                ByteBuffer sb = bb.order(_order).asReadOnlyBuffer();
                for (int e = 0; e < prod; ++e) {
                    bytes[e] = sb.get(e + sb.position());
                }
                return Nd4j.create(bytes, shapeOf, stridesOf, ordering, DataType.BYTE);
            }
            case BOOL: {
                boolean[] doubles = new boolean[prod];
                ByteBuffer sb = bb.order(_order).asReadOnlyBuffer();
                for (int e = 0; e < prod; ++e) {
                    doubles[e] = sb.get(e + sb.position()) == 1;
                }
                return Nd4j.create(doubles, shapeOf, stridesOf, ordering, DataType.BOOL);
            }
            case UTF8: {
                try {
                    ByteBuffer sb = bb.order(_order);
                    int pos = sb.position();
                    byte[] arr = new byte[sb.limit() - pos];
                    for (int e = 0; e < arr.length; ++e) {
                        arr[e] = sb.get(e + pos);
                    }
                    DataBuffer buffer = DATA_BUFFER_FACTORY_INSTANCE.createUtf8Buffer(arr, prod);
                    return Nd4j.create(buffer, shapeOf);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case UINT16: 
            case UBYTE: 
            case BFLOAT16: {
                INDArray arr = Nd4j.createUninitialized(_dtype, shapeOf);
                ByteBuffer obb = bb.order(_order);
                int pos = obb.position();
                byte[] bArr = new byte[obb.limit() - pos];
                for (int e = 0; e < bArr.length; ++e) {
                    bArr[e] = obb.get(e + pos);
                }
                arr.data().asNio().put(bArr);
                return arr;
            }
        }
        throw new UnsupportedOperationException("Unknown datatype: [" + (Object)((Object)_dtype) + "]");
    }

    public static DataType defaultFloatingPointType() {
        return defaultFloatingPointDataType.get();
    }

    public static boolean isPrecisionBoostAllowed() {
        return false;
    }

    public static INDArray scalar(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        return Nd4j.create(Collections.singletonList(string), new long[0]);
    }

    public static INDArray create(String ... strings) {
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        return Nd4j.create(Arrays.asList(strings), new long[]{strings.length}, Nd4j.order().charValue());
    }

    public static INDArray create(@NonNull Collection<String> strings, long ... shape) {
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        return Nd4j.create(strings, shape, Nd4j.order().charValue());
    }

    public static INDArray create(@NonNull Collection<String> strings, long[] shape, char order) {
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        return INSTANCE.create(strings, shape, order);
    }

    public static INDArray createFromArray(double ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.DOUBLE);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.DOUBLE);
    }

    public static INDArray createFromArray(float ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.FLOAT);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.FLOAT);
    }

    public static INDArray createFromArray(int ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.INT);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.INT);
    }

    public static INDArray createFromArray(short ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.SHORT);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.SHORT);
    }

    public static INDArray createFromArray(byte ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.BYTE);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BYTE);
    }

    public static INDArray createFromArray(long ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.LONG);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.LONG);
    }

    public static INDArray createFromArray(boolean ... array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        if (array.length == 0) {
            return Nd4j.empty(DataType.BOOL);
        }
        long[] shape = new long[]{array.length};
        return Nd4j.create(array, shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BOOL);
    }

    public static INDArray createFromArray(double[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.DOUBLE);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((double[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.DOUBLE);
    }

    public static INDArray createFromArray(float[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.FLOAT);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((float[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.FLOAT);
    }

    public static INDArray createFromArray(long[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.LONG);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((long[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.LONG);
    }

    public static INDArray createFromArray(int[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.INT);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((int[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.INT);
    }

    public static INDArray createFromArray(short[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.SHORT);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((short[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.SHORT);
    }

    public static INDArray createFromArray(byte[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.BYTE);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((byte[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BYTE);
    }

    public static INDArray createFromArray(boolean[][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0) {
            return Nd4j.empty(DataType.BOOL);
        }
        long[] shape = new long[]{array.length, array[0].length};
        return Nd4j.create(ArrayUtil.flatten((boolean[][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BOOL);
    }

    public static INDArray createFromArray(double[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.DOUBLE);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((double[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.DOUBLE);
    }

    public static INDArray createFromArray(float[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.FLOAT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((float[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.FLOAT);
    }

    public static INDArray createFromArray(long[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.LONG);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((long[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.LONG);
    }

    public static INDArray createFromArray(int[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.INT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((int[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.INT);
    }

    public static INDArray createFromArray(short[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.SHORT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((short[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.SHORT);
    }

    public static INDArray createFromArray(byte[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.BYTE);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((byte[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BYTE);
    }

    public static INDArray createFromArray(boolean[][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0) {
            return Nd4j.empty(DataType.BOOL);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length};
        return Nd4j.create(ArrayUtil.flatten((boolean[][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BOOL);
    }

    public static INDArray createFromArray(double[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.DOUBLE);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((double[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.DOUBLE);
    }

    public static INDArray createFromArray(float[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.FLOAT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((float[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.FLOAT);
    }

    public static INDArray createFromArray(long[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.LONG);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((long[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.LONG);
    }

    public static INDArray createFromArray(int[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.INT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((int[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.INT);
    }

    public static INDArray createFromArray(short[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.SHORT);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((short[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.SHORT);
    }

    public static INDArray createFromArray(byte[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.BYTE);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((byte[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BYTE);
    }

    public static INDArray createFromArray(boolean[][][][] array) {
        Preconditions.checkNotNull((Object)array, (String)"Cannot create INDArray from null Java array");
        ArrayUtil.assertNotRagged((Object[])array);
        if (array.length == 0 || array[0].length == 0 || array[0][0].length == 0 || array[0][0][0].length == 0) {
            return Nd4j.empty(DataType.BOOL);
        }
        long[] shape = new long[]{array.length, array[0].length, array[0][0].length, array[0][0][0].length};
        return Nd4j.create(ArrayUtil.flatten((boolean[][][][])array), shape, ArrayUtil.calcStrides((long[])shape), 'c', DataType.BOOL);
    }

    public static synchronized DeallocatorService getDeallocatorService() {
        if (deallocatorService == null) {
            deallocatorService = new DeallocatorService();
        }
        return deallocatorService;
    }

    public static INDArray createFromArray(Double[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Double[])array));
    }

    public static INDArray createFromArray(Float[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Float[])array));
    }

    public static INDArray createFromArray(Integer[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Integer[])array));
    }

    public static INDArray createFromArray(Short[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Short[])array));
    }

    public static INDArray createFromArray(Byte[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Byte[])array));
    }

    public static INDArray createFromArray(Long[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Long[])array));
    }

    public static INDArray createFromArray(Boolean[] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Boolean[])array));
    }

    public static INDArray createFromArray(Double[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Double[][])array));
    }

    public static INDArray createFromArray(Float[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Float[][])array));
    }

    public static INDArray createFromArray(Integer[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Integer[][])array));
    }

    public static INDArray createFromArray(Short[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Short[][])array));
    }

    public static INDArray createFromArray(Byte[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Byte[][])array));
    }

    public static INDArray createFromArray(Long[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Long[][])array));
    }

    public static INDArray createFromArray(Boolean[][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Boolean[][])array));
    }

    public static INDArray createFromArray(Double[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Double[][][])array));
    }

    public static INDArray createFromArray(Float[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Float[][][])array));
    }

    public static INDArray createFromArray(Integer[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Integer[][][])array));
    }

    public static INDArray createFromArray(Short[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Short[][][])array));
    }

    public static INDArray createFromArray(Byte[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Byte[][][])array));
    }

    public static INDArray createFromArray(Long[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Long[][][])array));
    }

    public static INDArray createFromArray(Boolean[][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Boolean[][][])array));
    }

    public static INDArray createFromArray(Double[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Double[][][][])array));
    }

    public static INDArray createFromArray(Float[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Float[][][][])array));
    }

    public static INDArray createFromArray(Integer[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Integer[][][][])array));
    }

    public static INDArray createFromArray(Short[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Short[][][][])array));
    }

    public static INDArray createFromArray(Byte[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Byte[][][][])array));
    }

    public static INDArray createFromArray(Long[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Long[][][][])array));
    }

    public static INDArray createFromArray(Boolean[][][][] array) {
        return Nd4j.createFromArray(ArrayUtil.toPrimitives((Boolean[][][][])array));
    }

    public static boolean isExperimentalMode() {
        return Nd4j.getExecutioner().isExperimentalMode();
    }

    public static INDArray exec(Op op) {
        return Nd4j.getExecutioner().exec(op);
    }

    public static INDArray exec(Op op, OpContext context) {
        return Nd4j.getExecutioner().exec(op, context);
    }

    public static INDArray[] exec(CustomOp op) {
        return Nd4j.getExecutioner().exec(op);
    }

    public static INDArray[] exec(CustomOp op, OpContext context) {
        return Nd4j.getExecutioner().exec(op, context);
    }

    @Deprecated
    public static void scatterUpdate(ScatterUpdate.UpdateOp op, @NonNull INDArray array, @NonNull INDArray indices, @NonNull INDArray updates, int ... axis) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (indices == null) {
            throw new NullPointerException("indices is marked non-null but is null");
        }
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        Preconditions.checkArgument((indices.dataType() == DataType.INT || indices.dataType() == DataType.LONG ? 1 : 0) != 0, (String)"Indices should have INT data type");
        Preconditions.checkArgument((array.dataType() == updates.dataType() ? 1 : 0) != 0, (String)"Array and updates should have the same data type");
        Nd4j.getExecutioner().scatterUpdate(op, array, indices, updates, axis);
    }

    static {
        props = new Properties();
        logger = java.util.logging.Logger.getLogger(Nd4j.class.getName());
        EMPTY_ARRAYS = new INDArray[DataType.values().length];
        fallbackMode = new AtomicBoolean(false);
        Nd4j nd4j = new Nd4j();
        nd4j.initContext();
    }
}

