/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.rng.distribution.factory;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory;
import org.nd4j.linalg.api.rng.distribution.impl.BinomialDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.ConstantDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.LogNormalDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.NormalDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.OrthogonalDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.TruncatedNormalDistribution;
import org.nd4j.linalg.api.rng.distribution.impl.UniformDistribution;

public class DefaultDistributionFactory
implements DistributionFactory {
    @Override
    public Distribution createBinomial(int n, INDArray p) {
        return new BinomialDistribution(n, p);
    }

    @Override
    public Distribution createBinomial(int n, double p) {
        return new BinomialDistribution(n, p);
    }

    @Override
    public Distribution createNormal(INDArray mean, double std) {
        return new NormalDistribution(mean, std);
    }

    @Override
    public Distribution createNormal(double mean, double std) {
        return new NormalDistribution(mean, std);
    }

    @Override
    public Distribution createLogNormal(double mean, double std) {
        return new LogNormalDistribution(mean, std);
    }

    @Override
    public Distribution createTruncatedNormal(double mean, double std) {
        return new TruncatedNormalDistribution(mean, std);
    }

    @Override
    public Distribution createOrthogonal(double gain) {
        return new OrthogonalDistribution(gain);
    }

    @Override
    public Distribution createConstant(double value) {
        return new ConstantDistribution(value);
    }

    @Override
    public Distribution createUniform(double min, double max) {
        return new UniformDistribution(min, max);
    }
}

