/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.adapters.DataTypeAdapter;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class RandomGamma
extends DynamicCustomOp {
    private DataType outputDataType;

    public RandomGamma(@NonNull INDArray shape, @NonNull INDArray alpha, INDArray beta, int ... seeds) {
        this.outputDataType = DataType.FLOAT;
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
        if (beta != null) {
            this.addInputArgument(shape, alpha, beta);
        }
        this.addInputArgument(shape, alpha);
        this.addIArgument(seeds);
    }

    public RandomGamma(@NonNull INDArray shape, @NonNull INDArray alpha, INDArray beta) {
        this(shape, alpha, beta, 0, 0);
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
    }

    public RandomGamma(@NonNull SameDiff sameDiff, @NonNull SDVariable shape, @NonNull SDVariable alpha, SDVariable beta, int ... seeds) {
        SDVariable[] sDVariableArray;
        if (beta != null) {
            SDVariable[] sDVariableArray2 = new SDVariable[3];
            sDVariableArray2[0] = shape;
            sDVariableArray2[1] = alpha;
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[2] = beta;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[2];
            sDVariableArray3[0] = shape;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[1] = alpha;
        }
        super(null, sameDiff, sDVariableArray);
        this.outputDataType = DataType.FLOAT;
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (alpha == null) {
            throw new NullPointerException("alpha is marked non-null but is null");
        }
        this.addIArgument(seeds);
    }

    @Override
    public String opName() {
        return "random_gamma";
    }

    @Override
    public String tensorflowName() {
        return "RandomGamma";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("alpha")) {
            this.outputDataType = DataTypeAdapter.dtypeConv(attributesForNode.get("alpha").getType());
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null ? 1 : 0) != 0, (String)"Expected exactly input datatypes for %s, got null", this.getClass());
        return Collections.singletonList(this.outputDataType);
    }

    public RandomGamma() {
        this.outputDataType = DataType.FLOAT;
    }
}

