/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class LayerNormBp
extends DynamicCustomOp {
    private boolean noBias = false;
    private boolean channelsFirst;

    public LayerNormBp(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable gain, SDVariable bias, @NonNull SDVariable gradient, boolean channelsFirst, int ... dimensions) {
        super(null, sameDiff, LayerNormBp.wrapFilterNull(input, gain, bias, gradient), false);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (gain == null) {
            throw new NullPointerException("gain is marked non-null but is null");
        }
        if (gradient == null) {
            throw new NullPointerException("gradient is marked non-null but is null");
        }
        this.noBias = bias == null;
        this.channelsFirst = channelsFirst;
        this.setDimensions(dimensions);
    }

    public LayerNormBp(@NonNull INDArray input, @NonNull INDArray gain, INDArray bias, @NonNull INDArray grad, @NonNull INDArray dLdx, @NonNull INDArray dLdg, INDArray dLdb, boolean channelsFirst, int ... dimensions) {
        super("layer_norm_bp", LayerNormBp.wrapFilterNull(input, gain, bias, grad), LayerNormBp.wrapFilterNull(dLdx, dLdg, dLdb));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (gain == null) {
            throw new NullPointerException("gain is marked non-null but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked non-null but is null");
        }
        if (dLdx == null) {
            throw new NullPointerException("dLdx is marked non-null but is null");
        }
        if (dLdg == null) {
            throw new NullPointerException("dLdg is marked non-null but is null");
        }
        this.noBias = bias == null;
        this.channelsFirst = channelsFirst;
        this.setDimensions(dimensions);
    }

    public LayerNormBp(SameDiff sameDiff, SDVariable input, SDVariable gain, SDVariable gradient, boolean channelsFirst, int ... dimensions) {
        this(sameDiff, input, gain, null, gradient, channelsFirst, dimensions);
    }

    public LayerNormBp(INDArray input, INDArray gain, INDArray grad, INDArray dLdx, INDArray dLdg, boolean channelsFirst, int ... dimensions) {
        this(input, gain, null, grad, dLdx, dLdg, null, channelsFirst, dimensions);
    }

    @Override
    public void setDimensions(int[] dimensions) {
        Preconditions.checkArgument((dimensions != null ? 1 : 0) != 0, (String)"LayerNormBp: You have to provide dimensions");
        Preconditions.checkArgument((dimensions.length > 0 ? 1 : 0) != 0, (String)"LayerNormBp: You have to provide dimensions");
        this.dimensions = dimensions;
        this.iArguments.clear();
        this.addIArgument(dimensions);
        this.bArguments.clear();
        this.addBArgument(this.channelsFirst);
    }

    @Override
    public String opName() {
        return "layer_norm_bp";
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow name found for shape " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() >= 3 && dataTypes.size() <= 4 ? 1 : 0) != 0, (String)"Expected exactly 3 or 4 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (DataType dataType : dataTypes) {
            Preconditions.checkState((boolean)dataType.isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            Preconditions.checkState((first == dataType ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return dataTypes.subList(0, dataTypes.size() - 1);
    }

    @Override
    public int getNumOutputs() {
        return this.noBias ? 2 : 3;
    }

    public LayerNormBp() {
    }
}

