/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class GRUWeights
extends RNNWeights {
    private SDVariable ruWeight;
    private INDArray iRuWeights;
    private SDVariable cWeight;
    private INDArray iCWeight;
    private SDVariable ruBias;
    private INDArray iRUBias;
    private SDVariable cBias;
    private INDArray iCBias;

    @Override
    public SDVariable[] args() {
        return GRUWeights.filterNonNull(this.ruWeight, this.cWeight, this.ruBias, this.cBias);
    }

    @Override
    public INDArray[] arrayArgs() {
        return GRUWeights.filterNonNull(this.iRuWeights, this.iCWeight, this.iRUBias, this.iCBias);
    }

    GRUWeights(SDVariable ruWeight, INDArray iRuWeights, SDVariable cWeight, INDArray iCWeight, SDVariable ruBias, INDArray iRUBias, SDVariable cBias, INDArray iCBias) {
        this.ruWeight = ruWeight;
        this.iRuWeights = iRuWeights;
        this.cWeight = cWeight;
        this.iCWeight = iCWeight;
        this.ruBias = ruBias;
        this.iRUBias = iRUBias;
        this.cBias = cBias;
        this.iCBias = iCBias;
    }

    public static GRUWeightsBuilder builder() {
        return new GRUWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GRUWeights)) {
            return false;
        }
        GRUWeights other = (GRUWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$ruWeight = this.getRuWeight();
        SDVariable other$ruWeight = other.getRuWeight();
        if (this$ruWeight == null ? other$ruWeight != null : !((Object)this$ruWeight).equals(other$ruWeight)) {
            return false;
        }
        INDArray this$iRuWeights = this.getIRuWeights();
        INDArray other$iRuWeights = other.getIRuWeights();
        if (this$iRuWeights == null ? other$iRuWeights != null : !this$iRuWeights.equals(other$iRuWeights)) {
            return false;
        }
        SDVariable this$cWeight = this.getCWeight();
        SDVariable other$cWeight = other.getCWeight();
        if (this$cWeight == null ? other$cWeight != null : !((Object)this$cWeight).equals(other$cWeight)) {
            return false;
        }
        INDArray this$iCWeight = this.getICWeight();
        INDArray other$iCWeight = other.getICWeight();
        if (this$iCWeight == null ? other$iCWeight != null : !this$iCWeight.equals(other$iCWeight)) {
            return false;
        }
        SDVariable this$ruBias = this.getRuBias();
        SDVariable other$ruBias = other.getRuBias();
        if (this$ruBias == null ? other$ruBias != null : !((Object)this$ruBias).equals(other$ruBias)) {
            return false;
        }
        INDArray this$iRUBias = this.getIRUBias();
        INDArray other$iRUBias = other.getIRUBias();
        if (this$iRUBias == null ? other$iRUBias != null : !this$iRUBias.equals(other$iRUBias)) {
            return false;
        }
        SDVariable this$cBias = this.getCBias();
        SDVariable other$cBias = other.getCBias();
        if (this$cBias == null ? other$cBias != null : !((Object)this$cBias).equals(other$cBias)) {
            return false;
        }
        INDArray this$iCBias = this.getICBias();
        INDArray other$iCBias = other.getICBias();
        return !(this$iCBias == null ? other$iCBias != null : !this$iCBias.equals(other$iCBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GRUWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $ruWeight = this.getRuWeight();
        result = result * 59 + ($ruWeight == null ? 43 : ((Object)$ruWeight).hashCode());
        INDArray $iRuWeights = this.getIRuWeights();
        result = result * 59 + ($iRuWeights == null ? 43 : $iRuWeights.hashCode());
        SDVariable $cWeight = this.getCWeight();
        result = result * 59 + ($cWeight == null ? 43 : ((Object)$cWeight).hashCode());
        INDArray $iCWeight = this.getICWeight();
        result = result * 59 + ($iCWeight == null ? 43 : $iCWeight.hashCode());
        SDVariable $ruBias = this.getRuBias();
        result = result * 59 + ($ruBias == null ? 43 : ((Object)$ruBias).hashCode());
        INDArray $iRUBias = this.getIRUBias();
        result = result * 59 + ($iRUBias == null ? 43 : $iRUBias.hashCode());
        SDVariable $cBias = this.getCBias();
        result = result * 59 + ($cBias == null ? 43 : ((Object)$cBias).hashCode());
        INDArray $iCBias = this.getICBias();
        result = result * 59 + ($iCBias == null ? 43 : $iCBias.hashCode());
        return result;
    }

    public SDVariable getRuWeight() {
        return this.ruWeight;
    }

    public INDArray getIRuWeights() {
        return this.iRuWeights;
    }

    public SDVariable getCWeight() {
        return this.cWeight;
    }

    public INDArray getICWeight() {
        return this.iCWeight;
    }

    public SDVariable getRuBias() {
        return this.ruBias;
    }

    public INDArray getIRUBias() {
        return this.iRUBias;
    }

    public SDVariable getCBias() {
        return this.cBias;
    }

    public INDArray getICBias() {
        return this.iCBias;
    }

    public void setRuWeight(SDVariable ruWeight) {
        this.ruWeight = ruWeight;
    }

    public void setIRuWeights(INDArray iRuWeights) {
        this.iRuWeights = iRuWeights;
    }

    public void setCWeight(SDVariable cWeight) {
        this.cWeight = cWeight;
    }

    public void setICWeight(INDArray iCWeight) {
        this.iCWeight = iCWeight;
    }

    public void setRuBias(SDVariable ruBias) {
        this.ruBias = ruBias;
    }

    public void setIRUBias(INDArray iRUBias) {
        this.iRUBias = iRUBias;
    }

    public void setCBias(SDVariable cBias) {
        this.cBias = cBias;
    }

    public void setICBias(INDArray iCBias) {
        this.iCBias = iCBias;
    }

    public String toString() {
        return "GRUWeights(ruWeight=" + this.getRuWeight() + ", iRuWeights=" + this.getIRuWeights() + ", cWeight=" + this.getCWeight() + ", iCWeight=" + this.getICWeight() + ", ruBias=" + this.getRuBias() + ", iRUBias=" + this.getIRUBias() + ", cBias=" + this.getCBias() + ", iCBias=" + this.getICBias() + ")";
    }

    public static class GRUWeightsBuilder {
        private SDVariable ruWeight;
        private INDArray iRuWeights;
        private SDVariable cWeight;
        private INDArray iCWeight;
        private SDVariable ruBias;
        private INDArray iRUBias;
        private SDVariable cBias;
        private INDArray iCBias;

        GRUWeightsBuilder() {
        }

        public GRUWeightsBuilder ruWeight(SDVariable ruWeight) {
            this.ruWeight = ruWeight;
            return this;
        }

        public GRUWeightsBuilder iRuWeights(INDArray iRuWeights) {
            this.iRuWeights = iRuWeights;
            return this;
        }

        public GRUWeightsBuilder cWeight(SDVariable cWeight) {
            this.cWeight = cWeight;
            return this;
        }

        public GRUWeightsBuilder iCWeight(INDArray iCWeight) {
            this.iCWeight = iCWeight;
            return this;
        }

        public GRUWeightsBuilder ruBias(SDVariable ruBias) {
            this.ruBias = ruBias;
            return this;
        }

        public GRUWeightsBuilder iRUBias(INDArray iRUBias) {
            this.iRUBias = iRUBias;
            return this;
        }

        public GRUWeightsBuilder cBias(SDVariable cBias) {
            this.cBias = cBias;
            return this;
        }

        public GRUWeightsBuilder iCBias(INDArray iCBias) {
            this.iCBias = iCBias;
            return this;
        }

        public GRUWeights build() {
            return new GRUWeights(this.ruWeight, this.iRuWeights, this.cWeight, this.iCWeight, this.ruBias, this.iRUBias, this.cBias, this.iCBias);
        }

        public String toString() {
            return "GRUWeights.GRUWeightsBuilder(ruWeight=" + this.ruWeight + ", iRuWeights=" + this.iRuWeights + ", cWeight=" + this.cWeight + ", iCWeight=" + this.iCWeight + ", ruBias=" + this.ruBias + ", iRUBias=" + this.iRUBias + ", cBias=" + this.cBias + ", iCBias=" + this.iCBias + ")";
        }
    }
}

