/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.api.buffer.DataType;

public class DataTypeUtil {
    private static volatile transient DataType dtype;
    private static final ReadWriteLock lock;

    public static int lengthForDtype(DataType type) {
        switch (type) {
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INT: {
                return 4;
            }
            case HALF: {
                return 2;
            }
            case LONG: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Illegal opType for length");
    }

    public static DataType getDtypeFromContext(String dType) {
        switch (dType) {
            case "double": {
                return DataType.DOUBLE;
            }
            case "float": {
                return DataType.FLOAT;
            }
            case "int": {
                return DataType.INT;
            }
            case "half": {
                return DataType.HALF;
            }
        }
        return DataType.FLOAT;
    }

    public static String getDTypeForName(DataType allocationMode) {
        switch (allocationMode) {
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
            case HALF: {
                return "half";
            }
        }
        return "float";
    }

    public static DataType getDtypeFromContext() {
        try {
            lock.readLock().lock();
            if (dtype == null) {
                lock.readLock().unlock();
                lock.writeLock().lock();
                if (dtype == null) {
                    dtype = DataTypeUtil.getDtypeFromContext(Nd4jContext.getInstance().getConf().getProperty("dtype"));
                }
                lock.writeLock().unlock();
                lock.readLock().lock();
            }
            DataType dataType = dtype;
            return dataType;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void setDTypeForContext(DataType allocationModeForContext) {
        try {
            lock.writeLock().lock();
            dtype = allocationModeForContext;
            DataTypeUtil.setDTypeForContext(DataTypeUtil.getDTypeForName(allocationModeForContext));
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void setDTypeForContext(String allocationModeForContext) {
        if (!(allocationModeForContext.equals("double") || allocationModeForContext.equals("float") || allocationModeForContext.equals("int") || allocationModeForContext.equals("half"))) {
            throw new IllegalArgumentException("Allocation mode must be one of: double,float, or int");
        }
        Nd4jContext.getInstance().getConf().put("dtype", allocationModeForContext);
    }

    static {
        lock = new ReentrantReadWriteLock();
    }
}

