/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.linalg.api.ops.impl.loss.AbsoluteDifferenceLoss;
import org.nd4j.linalg.api.ops.impl.loss.CosineDistanceLoss;
import org.nd4j.linalg.api.ops.impl.loss.HingeLoss;
import org.nd4j.linalg.api.ops.impl.loss.HuberLoss;
import org.nd4j.linalg.api.ops.impl.loss.L2Loss;
import org.nd4j.linalg.api.ops.impl.loss.LogLoss;
import org.nd4j.linalg.api.ops.impl.loss.LogPoissonLoss;
import org.nd4j.linalg.api.ops.impl.loss.MeanPairwiseSquaredErrorLoss;
import org.nd4j.linalg.api.ops.impl.loss.MeanSquaredErrorLoss;
import org.nd4j.linalg.api.ops.impl.loss.SigmoidCrossEntropyLoss;
import org.nd4j.linalg.api.ops.impl.loss.SoftmaxCrossEntropyLoss;
import org.nd4j.linalg.api.ops.impl.loss.SparseSoftmaxCrossEntropyLossWithLogits;
import org.nd4j.linalg.api.ops.impl.loss.WeightedCrossEntropyLoss;

public class SDLoss
extends SDOps {
    public SDLoss(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable absoluteDifference(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("absoluteDifference", "label", label);
        SDValidation.validateNumerical("absoluteDifference", "predictions", predictions);
        SDValidation.validateNumerical("absoluteDifference", "weights", weights);
        SDVariable out = new AbsoluteDifferenceLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable absoluteDifference(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("absoluteDifference", "label", label);
        SDValidation.validateNumerical("absoluteDifference", "predictions", predictions);
        SDValidation.validateNumerical("absoluteDifference", "weights", weights);
        SDVariable out = new AbsoluteDifferenceLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable absoluteDifference(SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("absoluteDifference", "label", label);
        SDValidation.validateNumerical("absoluteDifference", "predictions", predictions);
        SDValidation.validateNumerical("absoluteDifference", "weights", weights);
        SDVariable out = new AbsoluteDifferenceLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable absoluteDifference(String name, SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("absoluteDifference", "label", label);
        SDValidation.validateNumerical("absoluteDifference", "predictions", predictions);
        SDValidation.validateNumerical("absoluteDifference", "weights", weights);
        SDVariable out = new AbsoluteDifferenceLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cosineDistance(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, int dimension) {
        SDValidation.validateNumerical("cosineDistance", "label", label);
        SDValidation.validateNumerical("cosineDistance", "predictions", predictions);
        SDValidation.validateNumerical("cosineDistance", "weights", weights);
        SDVariable out = new CosineDistanceLoss(this.sd, label, predictions, weights, lossReduce, dimension).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable cosineDistance(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, int dimension) {
        SDValidation.validateNumerical("cosineDistance", "label", label);
        SDValidation.validateNumerical("cosineDistance", "predictions", predictions);
        SDValidation.validateNumerical("cosineDistance", "weights", weights);
        SDVariable out = new CosineDistanceLoss(this.sd, label, predictions, weights, lossReduce, dimension).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cosineDistance(SDVariable label, SDVariable predictions, SDVariable weights, int dimension) {
        SDValidation.validateNumerical("cosineDistance", "label", label);
        SDValidation.validateNumerical("cosineDistance", "predictions", predictions);
        SDValidation.validateNumerical("cosineDistance", "weights", weights);
        SDVariable out = new CosineDistanceLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, dimension).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable cosineDistance(String name, SDVariable label, SDVariable predictions, SDVariable weights, int dimension) {
        SDValidation.validateNumerical("cosineDistance", "label", label);
        SDValidation.validateNumerical("cosineDistance", "predictions", predictions);
        SDValidation.validateNumerical("cosineDistance", "weights", weights);
        SDVariable out = new CosineDistanceLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, dimension).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hingeLoss(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("hingeLoss", "label", label);
        SDValidation.validateNumerical("hingeLoss", "predictions", predictions);
        SDValidation.validateNumerical("hingeLoss", "weights", weights);
        SDVariable out = new HingeLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable hingeLoss(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("hingeLoss", "label", label);
        SDValidation.validateNumerical("hingeLoss", "predictions", predictions);
        SDValidation.validateNumerical("hingeLoss", "weights", weights);
        SDVariable out = new HingeLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable hingeLoss(SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("hingeLoss", "label", label);
        SDValidation.validateNumerical("hingeLoss", "predictions", predictions);
        SDValidation.validateNumerical("hingeLoss", "weights", weights);
        SDVariable out = new HingeLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable hingeLoss(String name, SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("hingeLoss", "label", label);
        SDValidation.validateNumerical("hingeLoss", "predictions", predictions);
        SDValidation.validateNumerical("hingeLoss", "weights", weights);
        SDVariable out = new HingeLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable huberLoss(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, double delta) {
        SDValidation.validateNumerical("huberLoss", "label", label);
        SDValidation.validateNumerical("huberLoss", "predictions", predictions);
        SDValidation.validateNumerical("huberLoss", "weights", weights);
        SDVariable out = new HuberLoss(this.sd, label, predictions, weights, lossReduce, delta).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable huberLoss(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, double delta) {
        SDValidation.validateNumerical("huberLoss", "label", label);
        SDValidation.validateNumerical("huberLoss", "predictions", predictions);
        SDValidation.validateNumerical("huberLoss", "weights", weights);
        SDVariable out = new HuberLoss(this.sd, label, predictions, weights, lossReduce, delta).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable huberLoss(SDVariable label, SDVariable predictions, SDVariable weights, double delta) {
        SDValidation.validateNumerical("huberLoss", "label", label);
        SDValidation.validateNumerical("huberLoss", "predictions", predictions);
        SDValidation.validateNumerical("huberLoss", "weights", weights);
        SDVariable out = new HuberLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, delta).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable huberLoss(String name, SDVariable label, SDVariable predictions, SDVariable weights, double delta) {
        SDValidation.validateNumerical("huberLoss", "label", label);
        SDValidation.validateNumerical("huberLoss", "predictions", predictions);
        SDValidation.validateNumerical("huberLoss", "weights", weights);
        SDVariable out = new HuberLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, delta).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable l2Loss(SDVariable var) {
        SDValidation.validateNumerical("l2Loss", "var", var);
        SDVariable out = new L2Loss(this.sd, var).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable l2Loss(String name, SDVariable var) {
        SDValidation.validateNumerical("l2Loss", "var", var);
        SDVariable out = new L2Loss(this.sd, var).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logLoss(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, double epsilon) {
        SDValidation.validateNumerical("logLoss", "label", label);
        SDValidation.validateNumerical("logLoss", "predictions", predictions);
        SDValidation.validateNumerical("logLoss", "weights", weights);
        SDVariable out = new LogLoss(this.sd, label, predictions, weights, lossReduce, epsilon).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable logLoss(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, double epsilon) {
        SDValidation.validateNumerical("logLoss", "label", label);
        SDValidation.validateNumerical("logLoss", "predictions", predictions);
        SDValidation.validateNumerical("logLoss", "weights", weights);
        SDVariable out = new LogLoss(this.sd, label, predictions, weights, lossReduce, epsilon).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logLoss(SDVariable label, SDVariable predictions) {
        SDValidation.validateNumerical("logLoss", "label", label);
        SDValidation.validateNumerical("logLoss", "predictions", predictions);
        SDVariable out = new LogLoss(this.sd, label, predictions, null, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable logLoss(String name, SDVariable label, SDVariable predictions) {
        SDValidation.validateNumerical("logLoss", "label", label);
        SDValidation.validateNumerical("logLoss", "predictions", predictions);
        SDVariable out = new LogLoss(this.sd, label, predictions, null, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logPoisson(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, boolean full) {
        SDValidation.validateNumerical("logPoisson", "label", label);
        SDValidation.validateNumerical("logPoisson", "predictions", predictions);
        SDValidation.validateNumerical("logPoisson", "weights", weights);
        SDVariable out = new LogPoissonLoss(this.sd, label, predictions, weights, lossReduce, full).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable logPoisson(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce, boolean full) {
        SDValidation.validateNumerical("logPoisson", "label", label);
        SDValidation.validateNumerical("logPoisson", "predictions", predictions);
        SDValidation.validateNumerical("logPoisson", "weights", weights);
        SDVariable out = new LogPoissonLoss(this.sd, label, predictions, weights, lossReduce, full).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logPoisson(SDVariable label, SDVariable predictions, SDVariable weights, boolean full) {
        SDValidation.validateNumerical("logPoisson", "label", label);
        SDValidation.validateNumerical("logPoisson", "predictions", predictions);
        SDValidation.validateNumerical("logPoisson", "weights", weights);
        SDVariable out = new LogPoissonLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, full).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable logPoisson(String name, SDVariable label, SDVariable predictions, SDVariable weights, boolean full) {
        SDValidation.validateNumerical("logPoisson", "label", label);
        SDValidation.validateNumerical("logPoisson", "predictions", predictions);
        SDValidation.validateNumerical("logPoisson", "weights", weights);
        SDVariable out = new LogPoissonLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, full).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable meanPairwiseSquaredError(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("meanPairwiseSquaredError", "label", label);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "weights", weights);
        SDVariable out = new MeanPairwiseSquaredErrorLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable meanPairwiseSquaredError(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("meanPairwiseSquaredError", "label", label);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "weights", weights);
        SDVariable out = new MeanPairwiseSquaredErrorLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable meanPairwiseSquaredError(SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("meanPairwiseSquaredError", "label", label);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "weights", weights);
        SDVariable out = new MeanPairwiseSquaredErrorLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable meanPairwiseSquaredError(String name, SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("meanPairwiseSquaredError", "label", label);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanPairwiseSquaredError", "weights", weights);
        SDVariable out = new MeanPairwiseSquaredErrorLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable meanSquaredError(SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("meanSquaredError", "label", label);
        SDValidation.validateNumerical("meanSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanSquaredError", "weights", weights);
        SDVariable out = new MeanSquaredErrorLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable meanSquaredError(String name, SDVariable label, SDVariable predictions, SDVariable weights, LossReduce lossReduce) {
        SDValidation.validateNumerical("meanSquaredError", "label", label);
        SDValidation.validateNumerical("meanSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanSquaredError", "weights", weights);
        SDVariable out = new MeanSquaredErrorLoss(this.sd, label, predictions, weights, lossReduce).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable meanSquaredError(SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("meanSquaredError", "label", label);
        SDValidation.validateNumerical("meanSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanSquaredError", "weights", weights);
        SDVariable out = new MeanSquaredErrorLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable meanSquaredError(String name, SDVariable label, SDVariable predictions, SDVariable weights) {
        SDValidation.validateNumerical("meanSquaredError", "label", label);
        SDValidation.validateNumerical("meanSquaredError", "predictions", predictions);
        SDValidation.validateNumerical("meanSquaredError", "weights", weights);
        SDVariable out = new MeanSquaredErrorLoss(this.sd, label, predictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sigmoidCrossEntropy(SDVariable label, SDVariable predictionLogits, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        SDValidation.validateNumerical("sigmoidCrossEntropy", "label", label);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "predictionLogits", predictionLogits);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "weights", weights);
        SDVariable out = new SigmoidCrossEntropyLoss(this.sd, label, predictionLogits, weights, lossReduce, labelSmoothing).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable sigmoidCrossEntropy(String name, SDVariable label, SDVariable predictionLogits, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        SDValidation.validateNumerical("sigmoidCrossEntropy", "label", label);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "predictionLogits", predictionLogits);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "weights", weights);
        SDVariable out = new SigmoidCrossEntropyLoss(this.sd, label, predictionLogits, weights, lossReduce, labelSmoothing).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sigmoidCrossEntropy(SDVariable label, SDVariable predictionLogits, SDVariable weights) {
        SDValidation.validateNumerical("sigmoidCrossEntropy", "label", label);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "predictionLogits", predictionLogits);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "weights", weights);
        SDVariable out = new SigmoidCrossEntropyLoss(this.sd, label, predictionLogits, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable sigmoidCrossEntropy(String name, SDVariable label, SDVariable predictionLogits, SDVariable weights) {
        SDValidation.validateNumerical("sigmoidCrossEntropy", "label", label);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "predictionLogits", predictionLogits);
        SDValidation.validateNumerical("sigmoidCrossEntropy", "weights", weights);
        SDVariable out = new SigmoidCrossEntropyLoss(this.sd, label, predictionLogits, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softmaxCrossEntropy(SDVariable oneHotLabels, SDVariable logitPredictions, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        SDValidation.validateNumerical("softmaxCrossEntropy", "oneHotLabels", oneHotLabels);
        SDValidation.validateNumerical("softmaxCrossEntropy", "logitPredictions", logitPredictions);
        SDValidation.validateNumerical("softmaxCrossEntropy", "weights", weights);
        SDVariable out = new SoftmaxCrossEntropyLoss(this.sd, oneHotLabels, logitPredictions, weights, lossReduce, labelSmoothing).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable softmaxCrossEntropy(String name, SDVariable oneHotLabels, SDVariable logitPredictions, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        SDValidation.validateNumerical("softmaxCrossEntropy", "oneHotLabels", oneHotLabels);
        SDValidation.validateNumerical("softmaxCrossEntropy", "logitPredictions", logitPredictions);
        SDValidation.validateNumerical("softmaxCrossEntropy", "weights", weights);
        SDVariable out = new SoftmaxCrossEntropyLoss(this.sd, oneHotLabels, logitPredictions, weights, lossReduce, labelSmoothing).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable softmaxCrossEntropy(SDVariable oneHotLabels, SDVariable logitPredictions, SDVariable weights) {
        SDValidation.validateNumerical("softmaxCrossEntropy", "oneHotLabels", oneHotLabels);
        SDValidation.validateNumerical("softmaxCrossEntropy", "logitPredictions", logitPredictions);
        SDValidation.validateNumerical("softmaxCrossEntropy", "weights", weights);
        SDVariable out = new SoftmaxCrossEntropyLoss(this.sd, oneHotLabels, logitPredictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable softmaxCrossEntropy(String name, SDVariable oneHotLabels, SDVariable logitPredictions, SDVariable weights) {
        SDValidation.validateNumerical("softmaxCrossEntropy", "oneHotLabels", oneHotLabels);
        SDValidation.validateNumerical("softmaxCrossEntropy", "logitPredictions", logitPredictions);
        SDValidation.validateNumerical("softmaxCrossEntropy", "weights", weights);
        SDVariable out = new SoftmaxCrossEntropyLoss(this.sd, oneHotLabels, logitPredictions, weights, LossReduce.MEAN_BY_NONZERO_WEIGHT_COUNT, 0.0).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable sparseSoftmaxCrossEntropy(SDVariable logits, SDVariable labels) {
        SDValidation.validateNumerical("sparseSoftmaxCrossEntropy", "logits", logits);
        SDValidation.validateInteger("sparseSoftmaxCrossEntropy", "labels", labels);
        SDVariable out = new SparseSoftmaxCrossEntropyLossWithLogits(this.sd, logits, labels).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable sparseSoftmaxCrossEntropy(String name, SDVariable logits, SDVariable labels) {
        SDValidation.validateNumerical("sparseSoftmaxCrossEntropy", "logits", logits);
        SDValidation.validateInteger("sparseSoftmaxCrossEntropy", "labels", labels);
        SDVariable out = new SparseSoftmaxCrossEntropyLossWithLogits(this.sd, logits, labels).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable weightedCrossEntropyWithLogits(SDVariable targets, SDVariable inputs, SDVariable weights) {
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "targets", targets);
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "inputs", inputs);
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "weights", weights);
        SDVariable out = new WeightedCrossEntropyLoss(this.sd, targets, inputs, weights).outputVariable();
        out.markAsLoss();
        return out;
    }

    public SDVariable weightedCrossEntropyWithLogits(String name, SDVariable targets, SDVariable inputs, SDVariable weights) {
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "targets", targets);
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "inputs", inputs);
        SDValidation.validateNumerical("weightedCrossEntropyWithLogits", "weights", weights);
        SDVariable out = new WeightedCrossEntropyLoss(this.sd, targets, inputs, weights).outputVariable();
        out.markAsLoss();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

